/*
* THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
*
* Copyright (C) 2020 Apple Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
* THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "config.h"
#include "WebPreferences.h"

#include "WebPreferencesKeys.h"

namespace WebKit {

void WebPreferences::setAVFoundationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isAVFoundationEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::isAVFoundationEnabledKey(), value);
}

bool WebPreferences::isAVFoundationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isAVFoundationEnabledKey());
}

void WebPreferences::deleteAVFoundationEnabled()
{
    deleteKey(WebPreferencesKey::isAVFoundationEnabledKey());
}

void WebPreferences::setAVFoundationNSURLSessionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isAVFoundationNSURLSessionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::isAVFoundationNSURLSessionEnabledKey(), value);
}

bool WebPreferences::isAVFoundationNSURLSessionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isAVFoundationNSURLSessionEnabledKey());
}

void WebPreferences::deleteAVFoundationNSURLSessionEnabled()
{
    deleteKey(WebPreferencesKey::isAVFoundationNSURLSessionEnabledKey());
}

void WebPreferences::setAcceleratedCompositingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::acceleratedCompositingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::acceleratedCompositingEnabledKey(), value);
}

bool WebPreferences::acceleratedCompositingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::acceleratedCompositingEnabledKey());
}

void WebPreferences::deleteAcceleratedCompositingEnabled()
{
    deleteKey(WebPreferencesKey::acceleratedCompositingEnabledKey());
}

void WebPreferences::setAcceleratedCompositingForFixedPositionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::acceleratedCompositingForFixedPositionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::acceleratedCompositingForFixedPositionEnabledKey(), value);
}

bool WebPreferences::acceleratedCompositingForFixedPositionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::acceleratedCompositingForFixedPositionEnabledKey());
}

void WebPreferences::deleteAcceleratedCompositingForFixedPositionEnabled()
{
    deleteKey(WebPreferencesKey::acceleratedCompositingForFixedPositionEnabledKey());
}

void WebPreferences::setAggressiveTileRetentionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::aggressiveTileRetentionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::aggressiveTileRetentionEnabledKey(), value);
}

bool WebPreferences::aggressiveTileRetentionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::aggressiveTileRetentionEnabledKey());
}

void WebPreferences::deleteAggressiveTileRetentionEnabled()
{
    deleteKey(WebPreferencesKey::aggressiveTileRetentionEnabledKey());
}

void WebPreferences::setAllowContentSecurityPolicySourceStarToMatchAnyProtocol(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowContentSecurityPolicySourceStarToMatchAnyProtocolKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowContentSecurityPolicySourceStarToMatchAnyProtocolKey(), value);
}

bool WebPreferences::allowContentSecurityPolicySourceStarToMatchAnyProtocol() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowContentSecurityPolicySourceStarToMatchAnyProtocolKey());
}

void WebPreferences::deleteAllowContentSecurityPolicySourceStarToMatchAnyProtocol()
{
    deleteKey(WebPreferencesKey::allowContentSecurityPolicySourceStarToMatchAnyProtocolKey());
}

void WebPreferences::setAllowCrossOriginSubresourcesToAskForCredentials(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowCrossOriginSubresourcesToAskForCredentialsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowCrossOriginSubresourcesToAskForCredentialsKey(), value);
}

bool WebPreferences::allowCrossOriginSubresourcesToAskForCredentials() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowCrossOriginSubresourcesToAskForCredentialsKey());
}

void WebPreferences::deleteAllowCrossOriginSubresourcesToAskForCredentials()
{
    deleteKey(WebPreferencesKey::allowCrossOriginSubresourcesToAskForCredentialsKey());
}

void WebPreferences::setAllowDisplayOfInsecureContent(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowDisplayOfInsecureContentKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowDisplayOfInsecureContentKey(), value);
}

bool WebPreferences::allowDisplayOfInsecureContent() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowDisplayOfInsecureContentKey());
}

void WebPreferences::deleteAllowDisplayOfInsecureContent()
{
    deleteKey(WebPreferencesKey::allowDisplayOfInsecureContentKey());
}

void WebPreferences::setAllowFileAccessFromFileURLs(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowFileAccessFromFileURLsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowFileAccessFromFileURLsKey(), value);
}

bool WebPreferences::allowFileAccessFromFileURLs() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowFileAccessFromFileURLsKey());
}

void WebPreferences::deleteAllowFileAccessFromFileURLs()
{
    deleteKey(WebPreferencesKey::allowFileAccessFromFileURLsKey());
}

void WebPreferences::setAllowMediaContentTypesRequiringHardwareSupportAsFallback(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowMediaContentTypesRequiringHardwareSupportAsFallbackKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowMediaContentTypesRequiringHardwareSupportAsFallbackKey(), value);
}

bool WebPreferences::allowMediaContentTypesRequiringHardwareSupportAsFallback() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowMediaContentTypesRequiringHardwareSupportAsFallbackKey());
}

void WebPreferences::deleteAllowMediaContentTypesRequiringHardwareSupportAsFallback()
{
    deleteKey(WebPreferencesKey::allowMediaContentTypesRequiringHardwareSupportAsFallbackKey());
}

void WebPreferences::setAllowMultiElementImplicitSubmission(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowMultiElementImplicitSubmissionKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowMultiElementImplicitSubmissionKey(), value);
}

bool WebPreferences::allowMultiElementImplicitSubmission() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowMultiElementImplicitSubmissionKey());
}

void WebPreferences::deleteAllowMultiElementImplicitSubmission()
{
    deleteKey(WebPreferencesKey::allowMultiElementImplicitSubmissionKey());
}

void WebPreferences::setAllowRunningOfInsecureContent(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowRunningOfInsecureContentKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowRunningOfInsecureContentKey(), value);
}

bool WebPreferences::allowRunningOfInsecureContent() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowRunningOfInsecureContentKey());
}

void WebPreferences::deleteAllowRunningOfInsecureContent()
{
    deleteKey(WebPreferencesKey::allowRunningOfInsecureContentKey());
}

void WebPreferences::setAllowSettingAnyXHRHeaderFromFileURLs(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowSettingAnyXHRHeaderFromFileURLsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowSettingAnyXHRHeaderFromFileURLsKey(), value);
}

bool WebPreferences::allowSettingAnyXHRHeaderFromFileURLs() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowSettingAnyXHRHeaderFromFileURLsKey());
}

void WebPreferences::deleteAllowSettingAnyXHRHeaderFromFileURLs()
{
    deleteKey(WebPreferencesKey::allowSettingAnyXHRHeaderFromFileURLsKey());
}

void WebPreferences::setAllowTopNavigationToDataURLs(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowTopNavigationToDataURLsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowTopNavigationToDataURLsKey(), value);
}

bool WebPreferences::allowTopNavigationToDataURLs() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowTopNavigationToDataURLsKey());
}

void WebPreferences::deleteAllowTopNavigationToDataURLs()
{
    deleteKey(WebPreferencesKey::allowTopNavigationToDataURLsKey());
}

void WebPreferences::setAllowUniversalAccessFromFileURLs(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowUniversalAccessFromFileURLsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowUniversalAccessFromFileURLsKey(), value);
}

bool WebPreferences::allowUniversalAccessFromFileURLs() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowUniversalAccessFromFileURLsKey());
}

void WebPreferences::deleteAllowUniversalAccessFromFileURLs()
{
    deleteKey(WebPreferencesKey::allowUniversalAccessFromFileURLsKey());
}

void WebPreferences::setAllowsAirPlayForMediaPlayback(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowsAirPlayForMediaPlaybackKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowsAirPlayForMediaPlaybackKey(), value);
}

bool WebPreferences::allowsAirPlayForMediaPlayback() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowsAirPlayForMediaPlaybackKey());
}

void WebPreferences::deleteAllowsAirPlayForMediaPlayback()
{
    deleteKey(WebPreferencesKey::allowsAirPlayForMediaPlaybackKey());
}

void WebPreferences::setAllowsInlineMediaPlayback(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackKey(), value);
}

bool WebPreferences::allowsInlineMediaPlayback() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackKey());
}

void WebPreferences::deleteAllowsInlineMediaPlayback()
{
    deleteKey(WebPreferencesKey::allowsInlineMediaPlaybackKey());
}

void WebPreferences::setAllowsInlineMediaPlaybackAfterFullscreen(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackAfterFullscreenKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackAfterFullscreenKey(), value);
}

bool WebPreferences::allowsInlineMediaPlaybackAfterFullscreen() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackAfterFullscreenKey());
}

void WebPreferences::deleteAllowsInlineMediaPlaybackAfterFullscreen()
{
    deleteKey(WebPreferencesKey::allowsInlineMediaPlaybackAfterFullscreenKey());
}

void WebPreferences::setAllowsPictureInPictureMediaPlayback(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowsPictureInPictureMediaPlaybackKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::allowsPictureInPictureMediaPlaybackKey(), value);
}

bool WebPreferences::allowsPictureInPictureMediaPlayback() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowsPictureInPictureMediaPlaybackKey());
}

void WebPreferences::deleteAllowsPictureInPictureMediaPlayback()
{
    deleteKey(WebPreferencesKey::allowsPictureInPictureMediaPlaybackKey());
}

void WebPreferences::setAlternateFormControlDesignEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::alternateFormControlDesignEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::alternateFormControlDesignEnabledKey(), value);
}

bool WebPreferences::alternateFormControlDesignEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::alternateFormControlDesignEnabledKey());
}

void WebPreferences::deleteAlternateFormControlDesignEnabled()
{
    deleteKey(WebPreferencesKey::alternateFormControlDesignEnabledKey());
}

void WebPreferences::setAlwaysUseAcceleratedOverflowScroll(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::alwaysUseAcceleratedOverflowScrollKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::alwaysUseAcceleratedOverflowScrollKey(), value);
}

bool WebPreferences::alwaysUseAcceleratedOverflowScroll() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::alwaysUseAcceleratedOverflowScrollKey());
}

void WebPreferences::deleteAlwaysUseAcceleratedOverflowScroll()
{
    deleteKey(WebPreferencesKey::alwaysUseAcceleratedOverflowScrollKey());
}

void WebPreferences::setAnimatedImageAsyncDecodingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::animatedImageAsyncDecodingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::animatedImageAsyncDecodingEnabledKey(), value);
}

bool WebPreferences::animatedImageAsyncDecodingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::animatedImageAsyncDecodingEnabledKey());
}

void WebPreferences::deleteAnimatedImageAsyncDecodingEnabled()
{
    deleteKey(WebPreferencesKey::animatedImageAsyncDecodingEnabledKey());
}

void WebPreferences::setAppHighlightsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::appHighlightsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::appHighlightsEnabledKey(), value);
}

bool WebPreferences::appHighlightsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::appHighlightsEnabledKey());
}

void WebPreferences::deleteAppHighlightsEnabled()
{
    deleteKey(WebPreferencesKey::appHighlightsEnabledKey());
}

void WebPreferences::setAppleMailPaginationQuirkEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::appleMailPaginationQuirkEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::appleMailPaginationQuirkEnabledKey(), value);
}

bool WebPreferences::appleMailPaginationQuirkEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::appleMailPaginationQuirkEnabledKey());
}

void WebPreferences::deleteAppleMailPaginationQuirkEnabled()
{
    deleteKey(WebPreferencesKey::appleMailPaginationQuirkEnabledKey());
}

void WebPreferences::setApplePayCapabilityDisclosureAllowed(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::applePayCapabilityDisclosureAllowedKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::applePayCapabilityDisclosureAllowedKey(), value);
}

bool WebPreferences::applePayCapabilityDisclosureAllowed() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::applePayCapabilityDisclosureAllowedKey());
}

void WebPreferences::deleteApplePayCapabilityDisclosureAllowed()
{
    deleteKey(WebPreferencesKey::applePayCapabilityDisclosureAllowedKey());
}

void WebPreferences::setApplePayEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::applePayEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::applePayEnabledKey(), value);
}

bool WebPreferences::applePayEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::applePayEnabledKey());
}

void WebPreferences::deleteApplePayEnabled()
{
    deleteKey(WebPreferencesKey::applePayEnabledKey());
}

void WebPreferences::setAsynchronousSpellCheckingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::asynchronousSpellCheckingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::asynchronousSpellCheckingEnabledKey(), value);
}

bool WebPreferences::asynchronousSpellCheckingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::asynchronousSpellCheckingEnabledKey());
}

void WebPreferences::deleteAsynchronousSpellCheckingEnabled()
{
    deleteKey(WebPreferencesKey::asynchronousSpellCheckingEnabledKey());
}

void WebPreferences::setAttachmentElementEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::attachmentElementEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::attachmentElementEnabledKey(), value);
}

bool WebPreferences::attachmentElementEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::attachmentElementEnabledKey());
}

void WebPreferences::deleteAttachmentElementEnabled()
{
    deleteKey(WebPreferencesKey::attachmentElementEnabledKey());
}

void WebPreferences::setAuthorAndUserStylesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::authorAndUserStylesEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::authorAndUserStylesEnabledKey(), value);
}

bool WebPreferences::authorAndUserStylesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::authorAndUserStylesEnabledKey());
}

void WebPreferences::deleteAuthorAndUserStylesEnabled()
{
    deleteKey(WebPreferencesKey::authorAndUserStylesEnabledKey());
}

void WebPreferences::setBackspaceKeyNavigationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::backspaceKeyNavigationEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::backspaceKeyNavigationEnabledKey(), value);
}

bool WebPreferences::backspaceKeyNavigationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::backspaceKeyNavigationEnabledKey());
}

void WebPreferences::deleteBackspaceKeyNavigationEnabled()
{
    deleteKey(WebPreferencesKey::backspaceKeyNavigationEnabledKey());
}

void WebPreferences::setBeaconAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::beaconAPIEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::beaconAPIEnabledKey(), value);
}

bool WebPreferences::beaconAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::beaconAPIEnabledKey());
}

void WebPreferences::deleteBeaconAPIEnabled()
{
    deleteKey(WebPreferencesKey::beaconAPIEnabledKey());
}

void WebPreferences::setCSSTransformStyleOptimized3DEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssTransformStyleOptimized3DEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::cssTransformStyleOptimized3DEnabledKey(), value);
}

bool WebPreferences::cssTransformStyleOptimized3DEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssTransformStyleOptimized3DEnabledKey());
}

void WebPreferences::deleteCSSTransformStyleOptimized3DEnabled()
{
    deleteKey(WebPreferencesKey::cssTransformStyleOptimized3DEnabledKey());
}

void WebPreferences::setCacheAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cacheAPIEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::cacheAPIEnabledKey(), value);
}

bool WebPreferences::cacheAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cacheAPIEnabledKey());
}

void WebPreferences::deleteCacheAPIEnabled()
{
    deleteKey(WebPreferencesKey::cacheAPIEnabledKey());
}

void WebPreferences::setCanvasUsesAcceleratedDrawing(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::canvasUsesAcceleratedDrawingKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::canvasUsesAcceleratedDrawingKey(), value);
}

bool WebPreferences::canvasUsesAcceleratedDrawing() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::canvasUsesAcceleratedDrawingKey());
}

void WebPreferences::deleteCanvasUsesAcceleratedDrawing()
{
    deleteKey(WebPreferencesKey::canvasUsesAcceleratedDrawingKey());
}

void WebPreferences::setCaretBrowsingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::caretBrowsingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::caretBrowsingEnabledKey(), value);
}

bool WebPreferences::caretBrowsingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::caretBrowsingEnabledKey());
}

void WebPreferences::deleteCaretBrowsingEnabled()
{
    deleteKey(WebPreferencesKey::caretBrowsingEnabledKey());
}

void WebPreferences::setColorFilterEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::colorFilterEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::colorFilterEnabledKey(), value);
}

bool WebPreferences::colorFilterEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::colorFilterEnabledKey());
}

void WebPreferences::deleteColorFilterEnabled()
{
    deleteKey(WebPreferencesKey::colorFilterEnabledKey());
}

void WebPreferences::setConstantPropertiesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::constantPropertiesEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::constantPropertiesEnabledKey(), value);
}

bool WebPreferences::constantPropertiesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::constantPropertiesEnabledKey());
}

void WebPreferences::deleteConstantPropertiesEnabled()
{
    deleteKey(WebPreferencesKey::constantPropertiesEnabledKey());
}

void WebPreferences::setContentChangeObserverEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::contentChangeObserverEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::contentChangeObserverEnabledKey(), value);
}

bool WebPreferences::contentChangeObserverEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::contentChangeObserverEnabledKey());
}

void WebPreferences::deleteContentChangeObserverEnabled()
{
    deleteKey(WebPreferencesKey::contentChangeObserverEnabledKey());
}

void WebPreferences::setContentDispositionAttachmentSandboxEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::contentDispositionAttachmentSandboxEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::contentDispositionAttachmentSandboxEnabledKey(), value);
}

bool WebPreferences::contentDispositionAttachmentSandboxEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::contentDispositionAttachmentSandboxEnabledKey());
}

void WebPreferences::deleteContentDispositionAttachmentSandboxEnabled()
{
    deleteKey(WebPreferencesKey::contentDispositionAttachmentSandboxEnabledKey());
}

void WebPreferences::setCookieEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cookieEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::cookieEnabledKey(), value);
}

bool WebPreferences::cookieEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cookieEnabledKey());
}

void WebPreferences::deleteCookieEnabled()
{
    deleteKey(WebPreferencesKey::cookieEnabledKey());
}

void WebPreferences::setCursiveFontFamily(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::cursiveFontFamilyKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::cursiveFontFamilyKey(), value);
}

String WebPreferences::cursiveFontFamily() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::cursiveFontFamilyKey());
}

void WebPreferences::deleteCursiveFontFamily()
{
    deleteKey(WebPreferencesKey::cursiveFontFamilyKey());
}

void WebPreferences::setCustomPasteboardDataEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::customPasteboardDataEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::customPasteboardDataEnabledKey(), value);
}

bool WebPreferences::customPasteboardDataEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::customPasteboardDataEnabledKey());
}

void WebPreferences::deleteCustomPasteboardDataEnabled()
{
    deleteKey(WebPreferencesKey::customPasteboardDataEnabledKey());
}

void WebPreferences::setDNSPrefetchingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::dnsPrefetchingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::dnsPrefetchingEnabledKey(), value);
}

bool WebPreferences::dnsPrefetchingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::dnsPrefetchingEnabledKey());
}

void WebPreferences::deleteDNSPrefetchingEnabled()
{
    deleteKey(WebPreferencesKey::dnsPrefetchingEnabledKey());
}

void WebPreferences::setDOMPasteAllowed(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::domPasteAllowedKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::domPasteAllowedKey(), value);
}

bool WebPreferences::domPasteAllowed() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::domPasteAllowedKey());
}

void WebPreferences::deleteDOMPasteAllowed()
{
    deleteKey(WebPreferencesKey::domPasteAllowedKey());
}

void WebPreferences::setDOMTimersThrottlingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::domTimersThrottlingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::domTimersThrottlingEnabledKey(), value);
}

bool WebPreferences::domTimersThrottlingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::domTimersThrottlingEnabledKey());
}

void WebPreferences::deleteDOMTimersThrottlingEnabled()
{
    deleteKey(WebPreferencesKey::domTimersThrottlingEnabledKey());
}

void WebPreferences::setDataDetectorTypes(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::dataDetectorTypesKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::dataDetectorTypesKey(), value);
}

uint32_t WebPreferences::dataDetectorTypes() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::dataDetectorTypesKey());
}

void WebPreferences::deleteDataDetectorTypes()
{
    deleteKey(WebPreferencesKey::dataDetectorTypesKey());
}

void WebPreferences::setDataTransferItemsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::dataTransferItemsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::dataTransferItemsEnabledKey(), value);
}

bool WebPreferences::dataTransferItemsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::dataTransferItemsEnabledKey());
}

void WebPreferences::deleteDataTransferItemsEnabled()
{
    deleteKey(WebPreferencesKey::dataTransferItemsEnabledKey());
}

void WebPreferences::setDatabasesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::databasesEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::databasesEnabledKey(), value);
}

bool WebPreferences::databasesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::databasesEnabledKey());
}

void WebPreferences::deleteDatabasesEnabled()
{
    deleteKey(WebPreferencesKey::databasesEnabledKey());
}

void WebPreferences::setDefaultFixedFontSize(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::defaultFixedFontSizeKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::defaultFixedFontSizeKey(), value);
}

double WebPreferences::defaultFixedFontSize() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::defaultFixedFontSizeKey());
}

void WebPreferences::deleteDefaultFixedFontSize()
{
    deleteKey(WebPreferencesKey::defaultFixedFontSizeKey());
}

void WebPreferences::setDefaultFontSize(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::defaultFontSizeKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::defaultFontSizeKey(), value);
}

double WebPreferences::defaultFontSize() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::defaultFontSizeKey());
}

void WebPreferences::deleteDefaultFontSize()
{
    deleteKey(WebPreferencesKey::defaultFontSizeKey());
}

void WebPreferences::setDefaultTextEncodingName(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::defaultTextEncodingNameKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::defaultTextEncodingNameKey(), value);
}

String WebPreferences::defaultTextEncodingName() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::defaultTextEncodingNameKey());
}

void WebPreferences::deleteDefaultTextEncodingName()
{
    deleteKey(WebPreferencesKey::defaultTextEncodingNameKey());
}

void WebPreferences::setDeferredCSSParserEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::deferredCSSParserEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::deferredCSSParserEnabledKey(), value);
}

bool WebPreferences::deferredCSSParserEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::deferredCSSParserEnabledKey());
}

void WebPreferences::deleteDeferredCSSParserEnabled()
{
    deleteKey(WebPreferencesKey::deferredCSSParserEnabledKey());
}

void WebPreferences::setDeviceHeight(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::deviceHeightKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::deviceHeightKey(), value);
}

uint32_t WebPreferences::deviceHeight() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::deviceHeightKey());
}

void WebPreferences::deleteDeviceHeight()
{
    deleteKey(WebPreferencesKey::deviceHeightKey());
}

void WebPreferences::setDeviceOrientationEventEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::deviceOrientationEventEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::deviceOrientationEventEnabledKey(), value);
}

bool WebPreferences::deviceOrientationEventEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::deviceOrientationEventEnabledKey());
}

void WebPreferences::deleteDeviceOrientationEventEnabled()
{
    deleteKey(WebPreferencesKey::deviceOrientationEventEnabledKey());
}

void WebPreferences::setDeviceOrientationPermissionAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::deviceOrientationPermissionAPIEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::deviceOrientationPermissionAPIEnabledKey(), value);
}

bool WebPreferences::deviceOrientationPermissionAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::deviceOrientationPermissionAPIEnabledKey());
}

void WebPreferences::deleteDeviceOrientationPermissionAPIEnabled()
{
    deleteKey(WebPreferencesKey::deviceOrientationPermissionAPIEnabledKey());
}

void WebPreferences::setDeviceWidth(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::deviceWidthKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::deviceWidthKey(), value);
}

uint32_t WebPreferences::deviceWidth() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::deviceWidthKey());
}

void WebPreferences::deleteDeviceWidth()
{
    deleteKey(WebPreferencesKey::deviceWidthKey());
}

void WebPreferences::setDiagnosticLoggingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::diagnosticLoggingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::diagnosticLoggingEnabledKey(), value);
}

bool WebPreferences::diagnosticLoggingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::diagnosticLoggingEnabledKey());
}

void WebPreferences::deleteDiagnosticLoggingEnabled()
{
    deleteKey(WebPreferencesKey::diagnosticLoggingEnabledKey());
}

void WebPreferences::setDirectoryUploadEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::directoryUploadEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::directoryUploadEnabledKey(), value);
}

bool WebPreferences::directoryUploadEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::directoryUploadEnabledKey());
}

void WebPreferences::deleteDirectoryUploadEnabled()
{
    deleteKey(WebPreferencesKey::directoryUploadEnabledKey());
}

void WebPreferences::setDisabledAdaptationsMetaTagEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::disabledAdaptationsMetaTagEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::disabledAdaptationsMetaTagEnabledKey(), value);
}

bool WebPreferences::disabledAdaptationsMetaTagEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::disabledAdaptationsMetaTagEnabledKey());
}

void WebPreferences::deleteDisabledAdaptationsMetaTagEnabled()
{
    deleteKey(WebPreferencesKey::disabledAdaptationsMetaTagEnabledKey());
}

void WebPreferences::setDownloadAttributeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::downloadAttributeEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::downloadAttributeEnabledKey(), value);
}

bool WebPreferences::downloadAttributeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::downloadAttributeEnabledKey());
}

void WebPreferences::deleteDownloadAttributeEnabled()
{
    deleteKey(WebPreferencesKey::downloadAttributeEnabledKey());
}

void WebPreferences::setEditableLinkBehavior(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::editableLinkBehaviorKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::editableLinkBehaviorKey(), value);
}

uint32_t WebPreferences::editableLinkBehavior() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::editableLinkBehaviorKey());
}

void WebPreferences::deleteEditableLinkBehavior()
{
    deleteKey(WebPreferencesKey::editableLinkBehaviorKey());
}

void WebPreferences::setEnableInheritURIQueryComponent(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::enableInheritURIQueryComponentKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::enableInheritURIQueryComponentKey(), value);
}

bool WebPreferences::enableInheritURIQueryComponent() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::enableInheritURIQueryComponentKey());
}

void WebPreferences::deleteEnableInheritURIQueryComponent()
{
    deleteKey(WebPreferencesKey::enableInheritURIQueryComponentKey());
}

void WebPreferences::setEncryptedMediaAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::encryptedMediaAPIEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::encryptedMediaAPIEnabledKey(), value);
}

bool WebPreferences::encryptedMediaAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::encryptedMediaAPIEnabledKey());
}

void WebPreferences::deleteEncryptedMediaAPIEnabled()
{
    deleteKey(WebPreferencesKey::encryptedMediaAPIEnabledKey());
}

void WebPreferences::setEnumeratingAllNetworkInterfacesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::enumeratingAllNetworkInterfacesEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::enumeratingAllNetworkInterfacesEnabledKey(), value);
}

bool WebPreferences::enumeratingAllNetworkInterfacesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::enumeratingAllNetworkInterfacesEnabledKey());
}

void WebPreferences::deleteEnumeratingAllNetworkInterfacesEnabled()
{
    deleteKey(WebPreferencesKey::enumeratingAllNetworkInterfacesEnabledKey());
}

void WebPreferences::setExtensibleSSOEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isExtensibleSSOEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::isExtensibleSSOEnabledKey(), value);
}

bool WebPreferences::isExtensibleSSOEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isExtensibleSSOEnabledKey());
}

void WebPreferences::deleteExtensibleSSOEnabled()
{
    deleteKey(WebPreferencesKey::isExtensibleSSOEnabledKey());
}

void WebPreferences::setFTPDirectoryTemplatePath(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::ftpDirectoryTemplatePathKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::ftpDirectoryTemplatePathKey(), value);
}

String WebPreferences::ftpDirectoryTemplatePath() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::ftpDirectoryTemplatePathKey());
}

void WebPreferences::deleteFTPDirectoryTemplatePath()
{
    deleteKey(WebPreferencesKey::ftpDirectoryTemplatePathKey());
}

void WebPreferences::setFantasyFontFamily(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::fantasyFontFamilyKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::fantasyFontFamilyKey(), value);
}

String WebPreferences::fantasyFontFamily() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::fantasyFontFamilyKey());
}

void WebPreferences::deleteFantasyFontFamily()
{
    deleteKey(WebPreferencesKey::fantasyFontFamilyKey());
}

void WebPreferences::setFixedFontFamily(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::fixedFontFamilyKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::fixedFontFamilyKey(), value);
}

String WebPreferences::fixedFontFamily() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::fixedFontFamilyKey());
}

void WebPreferences::deleteFixedFontFamily()
{
    deleteKey(WebPreferencesKey::fixedFontFamilyKey());
}

void WebPreferences::setForceCompositingMode(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::forceCompositingModeKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::forceCompositingModeKey(), value);
}

bool WebPreferences::forceCompositingMode() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::forceCompositingModeKey());
}

void WebPreferences::deleteForceCompositingMode()
{
    deleteKey(WebPreferencesKey::forceCompositingModeKey());
}

void WebPreferences::setForceFTPDirectoryListings(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::forceFTPDirectoryListingsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::forceFTPDirectoryListingsKey(), value);
}

bool WebPreferences::forceFTPDirectoryListings() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::forceFTPDirectoryListingsKey());
}

void WebPreferences::deleteForceFTPDirectoryListings()
{
    deleteKey(WebPreferencesKey::forceFTPDirectoryListingsKey());
}

void WebPreferences::setForceWebGLUsesLowPower(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::forceWebGLUsesLowPowerKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::forceWebGLUsesLowPowerKey(), value);
}

bool WebPreferences::forceWebGLUsesLowPower() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::forceWebGLUsesLowPowerKey());
}

void WebPreferences::deleteForceWebGLUsesLowPower()
{
    deleteKey(WebPreferencesKey::forceWebGLUsesLowPowerKey());
}

void WebPreferences::setGStreamerEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isGStreamerEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::isGStreamerEnabledKey(), value);
}

bool WebPreferences::isGStreamerEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isGStreamerEnabledKey());
}

void WebPreferences::deleteGStreamerEnabled()
{
    deleteKey(WebPreferencesKey::isGStreamerEnabledKey());
}

void WebPreferences::setGamepadsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::gamepadsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::gamepadsEnabledKey(), value);
}

bool WebPreferences::gamepadsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::gamepadsEnabledKey());
}

void WebPreferences::deleteGamepadsEnabled()
{
    deleteKey(WebPreferencesKey::gamepadsEnabledKey());
}

void WebPreferences::setHTTPEquivEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::httpEquivEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::httpEquivEnabledKey(), value);
}

bool WebPreferences::httpEquivEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::httpEquivEnabledKey());
}

void WebPreferences::deleteHTTPEquivEnabled()
{
    deleteKey(WebPreferencesKey::httpEquivEnabledKey());
}

void WebPreferences::setHiddenPageCSSAnimationSuspensionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::hiddenPageCSSAnimationSuspensionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::hiddenPageCSSAnimationSuspensionEnabledKey(), value);
}

bool WebPreferences::hiddenPageCSSAnimationSuspensionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::hiddenPageCSSAnimationSuspensionEnabledKey());
}

void WebPreferences::deleteHiddenPageCSSAnimationSuspensionEnabled()
{
    deleteKey(WebPreferencesKey::hiddenPageCSSAnimationSuspensionEnabledKey());
}

void WebPreferences::setHiddenPageDOMTimerThrottlingAutoIncreases(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingAutoIncreasesKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingAutoIncreasesKey(), value);
}

bool WebPreferences::hiddenPageDOMTimerThrottlingAutoIncreases() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingAutoIncreasesKey());
}

void WebPreferences::deleteHiddenPageDOMTimerThrottlingAutoIncreases()
{
    deleteKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingAutoIncreasesKey());
}

void WebPreferences::setHiddenPageDOMTimerThrottlingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingEnabledKey(), value);
}

bool WebPreferences::hiddenPageDOMTimerThrottlingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingEnabledKey());
}

void WebPreferences::deleteHiddenPageDOMTimerThrottlingEnabled()
{
    deleteKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingEnabledKey());
}

void WebPreferences::setHyperlinkAuditingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::hyperlinkAuditingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::hyperlinkAuditingEnabledKey(), value);
}

bool WebPreferences::hyperlinkAuditingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::hyperlinkAuditingEnabledKey());
}

void WebPreferences::deleteHyperlinkAuditingEnabled()
{
    deleteKey(WebPreferencesKey::hyperlinkAuditingEnabledKey());
}

void WebPreferences::setImageControlsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::imageControlsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::imageControlsEnabledKey(), value);
}

bool WebPreferences::imageControlsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::imageControlsEnabledKey());
}

void WebPreferences::deleteImageControlsEnabled()
{
    deleteKey(WebPreferencesKey::imageControlsEnabledKey());
}

void WebPreferences::setInactiveMediaCaptureSteamRepromptIntervalInMinutes(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::inactiveMediaCaptureSteamRepromptIntervalInMinutesKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::inactiveMediaCaptureSteamRepromptIntervalInMinutesKey(), value);
}

double WebPreferences::inactiveMediaCaptureSteamRepromptIntervalInMinutes() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::inactiveMediaCaptureSteamRepromptIntervalInMinutesKey());
}

void WebPreferences::deleteInactiveMediaCaptureSteamRepromptIntervalInMinutes()
{
    deleteKey(WebPreferencesKey::inactiveMediaCaptureSteamRepromptIntervalInMinutesKey());
}

void WebPreferences::setIncompleteImageBorderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::incompleteImageBorderEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::incompleteImageBorderEnabledKey(), value);
}

bool WebPreferences::incompleteImageBorderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::incompleteImageBorderEnabledKey());
}

void WebPreferences::deleteIncompleteImageBorderEnabled()
{
    deleteKey(WebPreferencesKey::incompleteImageBorderEnabledKey());
}

void WebPreferences::setIncrementalRenderingSuppressionTimeout(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::incrementalRenderingSuppressionTimeoutKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::incrementalRenderingSuppressionTimeoutKey(), value);
}

double WebPreferences::incrementalRenderingSuppressionTimeout() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::incrementalRenderingSuppressionTimeoutKey());
}

void WebPreferences::deleteIncrementalRenderingSuppressionTimeout()
{
    deleteKey(WebPreferencesKey::incrementalRenderingSuppressionTimeoutKey());
}

void WebPreferences::setInlineMediaPlaybackRequiresPlaysInlineAttribute(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inlineMediaPlaybackRequiresPlaysInlineAttributeKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::inlineMediaPlaybackRequiresPlaysInlineAttributeKey(), value);
}

bool WebPreferences::inlineMediaPlaybackRequiresPlaysInlineAttribute() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inlineMediaPlaybackRequiresPlaysInlineAttributeKey());
}

void WebPreferences::deleteInlineMediaPlaybackRequiresPlaysInlineAttribute()
{
    deleteKey(WebPreferencesKey::inlineMediaPlaybackRequiresPlaysInlineAttributeKey());
}

void WebPreferences::setInspectorAdditionsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inspectorAdditionsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::inspectorAdditionsEnabledKey(), value);
}

bool WebPreferences::inspectorAdditionsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inspectorAdditionsEnabledKey());
}

void WebPreferences::deleteInspectorAdditionsEnabled()
{
    deleteKey(WebPreferencesKey::inspectorAdditionsEnabledKey());
}

void WebPreferences::setInspectorAttachedHeight(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::inspectorAttachedHeightKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::inspectorAttachedHeightKey(), value);
}

uint32_t WebPreferences::inspectorAttachedHeight() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::inspectorAttachedHeightKey());
}

void WebPreferences::deleteInspectorAttachedHeight()
{
    deleteKey(WebPreferencesKey::inspectorAttachedHeightKey());
}

void WebPreferences::setInspectorAttachedWidth(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::inspectorAttachedWidthKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::inspectorAttachedWidthKey(), value);
}

uint32_t WebPreferences::inspectorAttachedWidth() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::inspectorAttachedWidthKey());
}

void WebPreferences::deleteInspectorAttachedWidth()
{
    deleteKey(WebPreferencesKey::inspectorAttachedWidthKey());
}

void WebPreferences::setInspectorAttachmentSide(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::inspectorAttachmentSideKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::inspectorAttachmentSideKey(), value);
}

uint32_t WebPreferences::inspectorAttachmentSide() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::inspectorAttachmentSideKey());
}

void WebPreferences::deleteInspectorAttachmentSide()
{
    deleteKey(WebPreferencesKey::inspectorAttachmentSideKey());
}

void WebPreferences::setInspectorStartsAttached(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inspectorStartsAttachedKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::inspectorStartsAttachedKey(), value);
}

bool WebPreferences::inspectorStartsAttached() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inspectorStartsAttachedKey());
}

void WebPreferences::deleteInspectorStartsAttached()
{
    deleteKey(WebPreferencesKey::inspectorStartsAttachedKey());
}

void WebPreferences::setInspectorWindowFrame(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::inspectorWindowFrameKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::inspectorWindowFrameKey(), value);
}

String WebPreferences::inspectorWindowFrame() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::inspectorWindowFrameKey());
}

void WebPreferences::deleteInspectorWindowFrame()
{
    deleteKey(WebPreferencesKey::inspectorWindowFrameKey());
}

void WebPreferences::setInteractiveFormValidationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::interactiveFormValidationEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::interactiveFormValidationEnabledKey(), value);
}

bool WebPreferences::interactiveFormValidationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::interactiveFormValidationEnabledKey());
}

void WebPreferences::deleteInteractiveFormValidationEnabled()
{
    deleteKey(WebPreferencesKey::interactiveFormValidationEnabledKey());
}

void WebPreferences::setInterruptAudioOnPageVisibilityChangeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::interruptAudioOnPageVisibilityChangeEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::interruptAudioOnPageVisibilityChangeEnabledKey(), value);
}

bool WebPreferences::interruptAudioOnPageVisibilityChangeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::interruptAudioOnPageVisibilityChangeEnabledKey());
}

void WebPreferences::deleteInterruptAudioOnPageVisibilityChangeEnabled()
{
    deleteKey(WebPreferencesKey::interruptAudioOnPageVisibilityChangeEnabledKey());
}

void WebPreferences::setInvisibleAutoplayNotPermitted(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::invisibleAutoplayNotPermittedKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::invisibleAutoplayNotPermittedKey(), value);
}

bool WebPreferences::invisibleAutoplayNotPermitted() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::invisibleAutoplayNotPermittedKey());
}

void WebPreferences::deleteInvisibleAutoplayNotPermitted()
{
    deleteKey(WebPreferencesKey::invisibleAutoplayNotPermittedKey());
}

void WebPreferences::setIsAccessibilityIsolatedTreeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isAccessibilityIsolatedTreeEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::isAccessibilityIsolatedTreeEnabledKey(), value);
}

bool WebPreferences::isAccessibilityIsolatedTreeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isAccessibilityIsolatedTreeEnabledKey());
}

void WebPreferences::deleteIsAccessibilityIsolatedTreeEnabled()
{
    deleteKey(WebPreferencesKey::isAccessibilityIsolatedTreeEnabledKey());
}

void WebPreferences::setItpDebugModeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::itpDebugModeEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::itpDebugModeEnabledKey(), value);
}

bool WebPreferences::itpDebugModeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::itpDebugModeEnabledKey());
}

void WebPreferences::deleteItpDebugModeEnabled()
{
    deleteKey(WebPreferencesKey::itpDebugModeEnabledKey());
}

void WebPreferences::setJavaEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::javaEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::javaEnabledKey(), value);
}

bool WebPreferences::javaEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::javaEnabledKey());
}

void WebPreferences::deleteJavaEnabled()
{
    deleteKey(WebPreferencesKey::javaEnabledKey());
}

void WebPreferences::setJavaEnabledForLocalFiles(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::javaEnabledForLocalFilesKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::javaEnabledForLocalFilesKey(), value);
}

bool WebPreferences::javaEnabledForLocalFiles() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::javaEnabledForLocalFilesKey());
}

void WebPreferences::deleteJavaEnabledForLocalFiles()
{
    deleteKey(WebPreferencesKey::javaEnabledForLocalFilesKey());
}

void WebPreferences::setJavaScriptCanAccessClipboard(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::javaScriptCanAccessClipboardKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::javaScriptCanAccessClipboardKey(), value);
}

bool WebPreferences::javaScriptCanAccessClipboard() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::javaScriptCanAccessClipboardKey());
}

void WebPreferences::deleteJavaScriptCanAccessClipboard()
{
    deleteKey(WebPreferencesKey::javaScriptCanAccessClipboardKey());
}

void WebPreferences::setJavaScriptCanOpenWindowsAutomatically(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::javaScriptCanOpenWindowsAutomaticallyKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::javaScriptCanOpenWindowsAutomaticallyKey(), value);
}

bool WebPreferences::javaScriptCanOpenWindowsAutomatically() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::javaScriptCanOpenWindowsAutomaticallyKey());
}

void WebPreferences::deleteJavaScriptCanOpenWindowsAutomatically()
{
    deleteKey(WebPreferencesKey::javaScriptCanOpenWindowsAutomaticallyKey());
}

void WebPreferences::setJavaScriptEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::javaScriptEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::javaScriptEnabledKey(), value);
}

bool WebPreferences::javaScriptEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::javaScriptEnabledKey());
}

void WebPreferences::deleteJavaScriptEnabled()
{
    deleteKey(WebPreferencesKey::javaScriptEnabledKey());
}

void WebPreferences::setJavaScriptMarkupEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::javaScriptMarkupEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::javaScriptMarkupEnabledKey(), value);
}

bool WebPreferences::javaScriptMarkupEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::javaScriptMarkupEnabledKey());
}

void WebPreferences::deleteJavaScriptMarkupEnabled()
{
    deleteKey(WebPreferencesKey::javaScriptMarkupEnabledKey());
}

void WebPreferences::setJavaScriptRuntimeFlags(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::javaScriptRuntimeFlagsKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::javaScriptRuntimeFlagsKey(), value);
}

uint32_t WebPreferences::javaScriptRuntimeFlags() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::javaScriptRuntimeFlagsKey());
}

void WebPreferences::deleteJavaScriptRuntimeFlags()
{
    deleteKey(WebPreferencesKey::javaScriptRuntimeFlagsKey());
}

void WebPreferences::setLargeImageAsyncDecodingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::largeImageAsyncDecodingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::largeImageAsyncDecodingEnabledKey(), value);
}

bool WebPreferences::largeImageAsyncDecodingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::largeImageAsyncDecodingEnabledKey());
}

void WebPreferences::deleteLargeImageAsyncDecodingEnabled()
{
    deleteKey(WebPreferencesKey::largeImageAsyncDecodingEnabledKey());
}

void WebPreferences::setLayoutFallbackWidth(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::layoutFallbackWidthKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::layoutFallbackWidthKey(), value);
}

uint32_t WebPreferences::layoutFallbackWidth() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::layoutFallbackWidthKey());
}

void WebPreferences::deleteLayoutFallbackWidth()
{
    deleteKey(WebPreferencesKey::layoutFallbackWidthKey());
}

void WebPreferences::setLayoutViewportHeightExpansionFactor(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::layoutViewportHeightExpansionFactorKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::layoutViewportHeightExpansionFactorKey(), value);
}

double WebPreferences::layoutViewportHeightExpansionFactor() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::layoutViewportHeightExpansionFactorKey());
}

void WebPreferences::deleteLayoutViewportHeightExpansionFactor()
{
    deleteKey(WebPreferencesKey::layoutViewportHeightExpansionFactorKey());
}

void WebPreferences::setLegacyEncryptedMediaAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::legacyEncryptedMediaAPIEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::legacyEncryptedMediaAPIEnabledKey(), value);
}

bool WebPreferences::legacyEncryptedMediaAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::legacyEncryptedMediaAPIEnabledKey());
}

void WebPreferences::deleteLegacyEncryptedMediaAPIEnabled()
{
    deleteKey(WebPreferencesKey::legacyEncryptedMediaAPIEnabledKey());
}

void WebPreferences::setLinkPreconnect(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::linkPreconnectKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::linkPreconnectKey(), value);
}

bool WebPreferences::linkPreconnect() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::linkPreconnectKey());
}

void WebPreferences::deleteLinkPreconnect()
{
    deleteKey(WebPreferencesKey::linkPreconnectKey());
}

void WebPreferences::setLinkPreloadEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::linkPreloadEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::linkPreloadEnabledKey(), value);
}

bool WebPreferences::linkPreloadEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::linkPreloadEnabledKey());
}

void WebPreferences::deleteLinkPreloadEnabled()
{
    deleteKey(WebPreferencesKey::linkPreloadEnabledKey());
}

void WebPreferences::setLoadDeferringEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::loadDeferringEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::loadDeferringEnabledKey(), value);
}

bool WebPreferences::loadDeferringEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::loadDeferringEnabledKey());
}

void WebPreferences::deleteLoadDeferringEnabled()
{
    deleteKey(WebPreferencesKey::loadDeferringEnabledKey());
}

void WebPreferences::setLoadsImagesAutomatically(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::loadsImagesAutomaticallyKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::loadsImagesAutomaticallyKey(), value);
}

bool WebPreferences::loadsImagesAutomatically() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::loadsImagesAutomaticallyKey());
}

void WebPreferences::deleteLoadsImagesAutomatically()
{
    deleteKey(WebPreferencesKey::loadsImagesAutomaticallyKey());
}

void WebPreferences::setLoadsSiteIconsIgnoringImageLoadingPreference(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::loadsSiteIconsIgnoringImageLoadingPreferenceKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::loadsSiteIconsIgnoringImageLoadingPreferenceKey(), value);
}

bool WebPreferences::loadsSiteIconsIgnoringImageLoadingPreference() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::loadsSiteIconsIgnoringImageLoadingPreferenceKey());
}

void WebPreferences::deleteLoadsSiteIconsIgnoringImageLoadingPreference()
{
    deleteKey(WebPreferencesKey::loadsSiteIconsIgnoringImageLoadingPreferenceKey());
}

void WebPreferences::setLocalFileContentSniffingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::localFileContentSniffingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::localFileContentSniffingEnabledKey(), value);
}

bool WebPreferences::localFileContentSniffingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::localFileContentSniffingEnabledKey());
}

void WebPreferences::deleteLocalFileContentSniffingEnabled()
{
    deleteKey(WebPreferencesKey::localFileContentSniffingEnabledKey());
}

void WebPreferences::setLocalStorageEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::localStorageEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::localStorageEnabledKey(), value);
}

bool WebPreferences::localStorageEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::localStorageEnabledKey());
}

void WebPreferences::deleteLocalStorageEnabled()
{
    deleteKey(WebPreferencesKey::localStorageEnabledKey());
}

void WebPreferences::setLongRunningMediaCaptureStreamRepromptIntervalInHours(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::longRunningMediaCaptureStreamRepromptIntervalInHoursKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::longRunningMediaCaptureStreamRepromptIntervalInHoursKey(), value);
}

double WebPreferences::longRunningMediaCaptureStreamRepromptIntervalInHours() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::longRunningMediaCaptureStreamRepromptIntervalInHoursKey());
}

void WebPreferences::deleteLongRunningMediaCaptureStreamRepromptIntervalInHours()
{
    deleteKey(WebPreferencesKey::longRunningMediaCaptureStreamRepromptIntervalInHoursKey());
}

void WebPreferences::setLowPowerVideoAudioBufferSizeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::lowPowerVideoAudioBufferSizeEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::lowPowerVideoAudioBufferSizeEnabledKey(), value);
}

bool WebPreferences::lowPowerVideoAudioBufferSizeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::lowPowerVideoAudioBufferSizeEnabledKey());
}

void WebPreferences::deleteLowPowerVideoAudioBufferSizeEnabled()
{
    deleteKey(WebPreferencesKey::lowPowerVideoAudioBufferSizeEnabledKey());
}

void WebPreferences::setMainContentUserGestureOverrideEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mainContentUserGestureOverrideEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mainContentUserGestureOverrideEnabledKey(), value);
}

bool WebPreferences::mainContentUserGestureOverrideEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mainContentUserGestureOverrideEnabledKey());
}

void WebPreferences::deleteMainContentUserGestureOverrideEnabled()
{
    deleteKey(WebPreferencesKey::mainContentUserGestureOverrideEnabledKey());
}

void WebPreferences::setMathMLEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mathMLEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mathMLEnabledKey(), value);
}

bool WebPreferences::mathMLEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mathMLEnabledKey());
}

void WebPreferences::deleteMathMLEnabled()
{
    deleteKey(WebPreferencesKey::mathMLEnabledKey());
}

void WebPreferences::setMaxParseDuration(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::maxParseDurationKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::maxParseDurationKey(), value);
}

double WebPreferences::maxParseDuration() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::maxParseDurationKey());
}

void WebPreferences::deleteMaxParseDuration()
{
    deleteKey(WebPreferencesKey::maxParseDurationKey());
}

void WebPreferences::setMediaAudioCodecIDsAllowedInCaptivePortalMode(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::mediaAudioCodecIDsAllowedInCaptivePortalModeKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::mediaAudioCodecIDsAllowedInCaptivePortalModeKey(), value);
}

String WebPreferences::mediaAudioCodecIDsAllowedInCaptivePortalMode() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::mediaAudioCodecIDsAllowedInCaptivePortalModeKey());
}

void WebPreferences::deleteMediaAudioCodecIDsAllowedInCaptivePortalMode()
{
    deleteKey(WebPreferencesKey::mediaAudioCodecIDsAllowedInCaptivePortalModeKey());
}

void WebPreferences::setMediaCapabilitiesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaCapabilitiesEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaCapabilitiesEnabledKey(), value);
}

bool WebPreferences::mediaCapabilitiesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaCapabilitiesEnabledKey());
}

void WebPreferences::deleteMediaCapabilitiesEnabled()
{
    deleteKey(WebPreferencesKey::mediaCapabilitiesEnabledKey());
}

void WebPreferences::setMediaCaptionFormatTypesAllowedInCaptivePortalMode(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::mediaCaptionFormatTypesAllowedInCaptivePortalModeKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::mediaCaptionFormatTypesAllowedInCaptivePortalModeKey(), value);
}

String WebPreferences::mediaCaptionFormatTypesAllowedInCaptivePortalMode() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::mediaCaptionFormatTypesAllowedInCaptivePortalModeKey());
}

void WebPreferences::deleteMediaCaptionFormatTypesAllowedInCaptivePortalMode()
{
    deleteKey(WebPreferencesKey::mediaCaptionFormatTypesAllowedInCaptivePortalModeKey());
}

void WebPreferences::setMediaCodecTypesAllowedInCaptivePortalMode(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::mediaCodecTypesAllowedInCaptivePortalModeKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::mediaCodecTypesAllowedInCaptivePortalModeKey(), value);
}

String WebPreferences::mediaCodecTypesAllowedInCaptivePortalMode() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::mediaCodecTypesAllowedInCaptivePortalModeKey());
}

void WebPreferences::deleteMediaCodecTypesAllowedInCaptivePortalMode()
{
    deleteKey(WebPreferencesKey::mediaCodecTypesAllowedInCaptivePortalModeKey());
}

void WebPreferences::setMediaContainerTypesAllowedInCaptivePortalMode(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::mediaContainerTypesAllowedInCaptivePortalModeKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::mediaContainerTypesAllowedInCaptivePortalModeKey(), value);
}

String WebPreferences::mediaContainerTypesAllowedInCaptivePortalMode() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::mediaContainerTypesAllowedInCaptivePortalModeKey());
}

void WebPreferences::deleteMediaContainerTypesAllowedInCaptivePortalMode()
{
    deleteKey(WebPreferencesKey::mediaContainerTypesAllowedInCaptivePortalModeKey());
}

void WebPreferences::setMediaContentTypesRequiringHardwareSupport(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::mediaContentTypesRequiringHardwareSupportKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::mediaContentTypesRequiringHardwareSupportKey(), value);
}

String WebPreferences::mediaContentTypesRequiringHardwareSupport() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::mediaContentTypesRequiringHardwareSupportKey());
}

void WebPreferences::deleteMediaContentTypesRequiringHardwareSupport()
{
    deleteKey(WebPreferencesKey::mediaContentTypesRequiringHardwareSupportKey());
}

void WebPreferences::setMediaControlsContextMenusEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaControlsContextMenusEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaControlsContextMenusEnabledKey(), value);
}

bool WebPreferences::mediaControlsContextMenusEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaControlsContextMenusEnabledKey());
}

void WebPreferences::deleteMediaControlsContextMenusEnabled()
{
    deleteKey(WebPreferencesKey::mediaControlsContextMenusEnabledKey());
}

void WebPreferences::setMediaControlsScaleWithPageZoom(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaControlsScaleWithPageZoomKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaControlsScaleWithPageZoomKey(), value);
}

bool WebPreferences::mediaControlsScaleWithPageZoom() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaControlsScaleWithPageZoomKey());
}

void WebPreferences::deleteMediaControlsScaleWithPageZoom()
{
    deleteKey(WebPreferencesKey::mediaControlsScaleWithPageZoomKey());
}

void WebPreferences::setMediaDataLoadsAutomatically(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaDataLoadsAutomaticallyKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaDataLoadsAutomaticallyKey(), value);
}

bool WebPreferences::mediaDataLoadsAutomatically() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaDataLoadsAutomaticallyKey());
}

void WebPreferences::deleteMediaDataLoadsAutomatically()
{
    deleteKey(WebPreferencesKey::mediaDataLoadsAutomaticallyKey());
}

void WebPreferences::setMediaDevicesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaDevicesEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaDevicesEnabledKey(), value);
}

bool WebPreferences::mediaDevicesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaDevicesEnabledKey());
}

void WebPreferences::deleteMediaDevicesEnabled()
{
    deleteKey(WebPreferencesKey::mediaDevicesEnabledKey());
}

void WebPreferences::setMediaEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaEnabledKey(), value);
}

bool WebPreferences::mediaEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaEnabledKey());
}

void WebPreferences::deleteMediaEnabled()
{
    deleteKey(WebPreferencesKey::mediaEnabledKey());
}

void WebPreferences::setMediaPreloadingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaPreloadingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaPreloadingEnabledKey(), value);
}

bool WebPreferences::mediaPreloadingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaPreloadingEnabledKey());
}

void WebPreferences::deleteMediaPreloadingEnabled()
{
    deleteKey(WebPreferencesKey::mediaPreloadingEnabledKey());
}

void WebPreferences::setMediaSourceEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaSourceEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaSourceEnabledKey(), value);
}

bool WebPreferences::mediaSourceEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaSourceEnabledKey());
}

void WebPreferences::deleteMediaSourceEnabled()
{
    deleteKey(WebPreferencesKey::mediaSourceEnabledKey());
}

void WebPreferences::setMediaStreamEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaStreamEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaStreamEnabledKey(), value);
}

bool WebPreferences::mediaStreamEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaStreamEnabledKey());
}

void WebPreferences::deleteMediaStreamEnabled()
{
    deleteKey(WebPreferencesKey::mediaStreamEnabledKey());
}

void WebPreferences::setMediaUserGestureInheritsFromDocument(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaUserGestureInheritsFromDocumentKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mediaUserGestureInheritsFromDocumentKey(), value);
}

bool WebPreferences::mediaUserGestureInheritsFromDocument() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaUserGestureInheritsFromDocumentKey());
}

void WebPreferences::deleteMediaUserGestureInheritsFromDocument()
{
    deleteKey(WebPreferencesKey::mediaUserGestureInheritsFromDocumentKey());
}

void WebPreferences::setMediaVideoCodecIDsAllowedInCaptivePortalMode(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::mediaVideoCodecIDsAllowedInCaptivePortalModeKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::mediaVideoCodecIDsAllowedInCaptivePortalModeKey(), value);
}

String WebPreferences::mediaVideoCodecIDsAllowedInCaptivePortalMode() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::mediaVideoCodecIDsAllowedInCaptivePortalModeKey());
}

void WebPreferences::deleteMediaVideoCodecIDsAllowedInCaptivePortalMode()
{
    deleteKey(WebPreferencesKey::mediaVideoCodecIDsAllowedInCaptivePortalModeKey());
}

void WebPreferences::setMenuItemElementEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::menuItemElementEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::menuItemElementEnabledKey(), value);
}

bool WebPreferences::menuItemElementEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::menuItemElementEnabledKey());
}

void WebPreferences::deleteMenuItemElementEnabled()
{
    deleteKey(WebPreferencesKey::menuItemElementEnabledKey());
}

void WebPreferences::setMinimumFontSize(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::minimumFontSizeKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::minimumFontSizeKey(), value);
}

double WebPreferences::minimumFontSize() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::minimumFontSizeKey());
}

void WebPreferences::deleteMinimumFontSize()
{
    deleteKey(WebPreferencesKey::minimumFontSizeKey());
}

void WebPreferences::setMinimumLogicalFontSize(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::minimumLogicalFontSizeKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::minimumLogicalFontSizeKey(), value);
}

double WebPreferences::minimumLogicalFontSize() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::minimumLogicalFontSizeKey());
}

void WebPreferences::deleteMinimumLogicalFontSize()
{
    deleteKey(WebPreferencesKey::minimumLogicalFontSizeKey());
}

void WebPreferences::setMinimumZoomFontSize(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::minimumZoomFontSizeKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::minimumZoomFontSizeKey(), value);
}

double WebPreferences::minimumZoomFontSize() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::minimumZoomFontSizeKey());
}

void WebPreferences::deleteMinimumZoomFontSize()
{
    deleteKey(WebPreferencesKey::minimumZoomFontSizeKey());
}

void WebPreferences::setMockCaptureDevicesPromptEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mockCaptureDevicesPromptEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mockCaptureDevicesPromptEnabledKey(), value);
}

bool WebPreferences::mockCaptureDevicesPromptEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mockCaptureDevicesPromptEnabledKey());
}

void WebPreferences::deleteMockCaptureDevicesPromptEnabled()
{
    deleteKey(WebPreferencesKey::mockCaptureDevicesPromptEnabledKey());
}

void WebPreferences::setMockScrollbarsControllerEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mockScrollbarsControllerEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mockScrollbarsControllerEnabledKey(), value);
}

bool WebPreferences::mockScrollbarsControllerEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mockScrollbarsControllerEnabledKey());
}

void WebPreferences::deleteMockScrollbarsControllerEnabled()
{
    deleteKey(WebPreferencesKey::mockScrollbarsControllerEnabledKey());
}

void WebPreferences::setMockScrollbarsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mockScrollbarsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::mockScrollbarsEnabledKey(), value);
}

bool WebPreferences::mockScrollbarsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mockScrollbarsEnabledKey());
}

void WebPreferences::deleteMockScrollbarsEnabled()
{
    deleteKey(WebPreferencesKey::mockScrollbarsEnabledKey());
}

void WebPreferences::setNeedsAdobeFrameReloadingQuirk(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::needsAdobeFrameReloadingQuirkKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::needsAdobeFrameReloadingQuirkKey(), value);
}

bool WebPreferences::needsAdobeFrameReloadingQuirk() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::needsAdobeFrameReloadingQuirkKey());
}

void WebPreferences::deleteNeedsAdobeFrameReloadingQuirk()
{
    deleteKey(WebPreferencesKey::needsAdobeFrameReloadingQuirkKey());
}

void WebPreferences::setNeedsFrameNameFallbackToIdQuirk(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::needsFrameNameFallbackToIdQuirkKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::needsFrameNameFallbackToIdQuirkKey(), value);
}

bool WebPreferences::needsFrameNameFallbackToIdQuirk() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::needsFrameNameFallbackToIdQuirkKey());
}

void WebPreferences::deleteNeedsFrameNameFallbackToIdQuirk()
{
    deleteKey(WebPreferencesKey::needsFrameNameFallbackToIdQuirkKey());
}

void WebPreferences::setNeedsKeyboardEventDisambiguationQuirks(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::needsKeyboardEventDisambiguationQuirksKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::needsKeyboardEventDisambiguationQuirksKey(), value);
}

bool WebPreferences::needsKeyboardEventDisambiguationQuirks() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::needsKeyboardEventDisambiguationQuirksKey());
}

void WebPreferences::deleteNeedsKeyboardEventDisambiguationQuirks()
{
    deleteKey(WebPreferencesKey::needsKeyboardEventDisambiguationQuirksKey());
}

void WebPreferences::setNeedsSiteSpecificQuirks(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::needsSiteSpecificQuirksKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::needsSiteSpecificQuirksKey(), value);
}

bool WebPreferences::needsSiteSpecificQuirks() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::needsSiteSpecificQuirksKey());
}

void WebPreferences::deleteNeedsSiteSpecificQuirks()
{
    deleteKey(WebPreferencesKey::needsSiteSpecificQuirksKey());
}

void WebPreferences::setNeedsStorageAccessFromFileURLsQuirk(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::needsStorageAccessFromFileURLsQuirkKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::needsStorageAccessFromFileURLsQuirkKey(), value);
}

bool WebPreferences::needsStorageAccessFromFileURLsQuirk() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::needsStorageAccessFromFileURLsQuirkKey());
}

void WebPreferences::deleteNeedsStorageAccessFromFileURLsQuirk()
{
    deleteKey(WebPreferencesKey::needsStorageAccessFromFileURLsQuirkKey());
}

void WebPreferences::setNotificationsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::notificationsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::notificationsEnabledKey(), value);
}

bool WebPreferences::notificationsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::notificationsEnabledKey());
}

void WebPreferences::deleteNotificationsEnabled()
{
    deleteKey(WebPreferencesKey::notificationsEnabledKey());
}

void WebPreferences::setOfflineWebApplicationCacheEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::offlineWebApplicationCacheEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::offlineWebApplicationCacheEnabledKey(), value);
}

bool WebPreferences::offlineWebApplicationCacheEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::offlineWebApplicationCacheEnabledKey());
}

void WebPreferences::deleteOfflineWebApplicationCacheEnabled()
{
    deleteKey(WebPreferencesKey::offlineWebApplicationCacheEnabledKey());
}

void WebPreferences::setPDFPluginEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::pdfPluginEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::pdfPluginEnabledKey(), value);
}

bool WebPreferences::pdfPluginEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::pdfPluginEnabledKey());
}

void WebPreferences::deletePDFPluginEnabled()
{
    deleteKey(WebPreferencesKey::pdfPluginEnabledKey());
}

void WebPreferences::setPageVisibilityBasedProcessSuppressionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::pageVisibilityBasedProcessSuppressionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::pageVisibilityBasedProcessSuppressionEnabledKey(), value);
}

bool WebPreferences::pageVisibilityBasedProcessSuppressionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::pageVisibilityBasedProcessSuppressionEnabledKey());
}

void WebPreferences::deletePageVisibilityBasedProcessSuppressionEnabled()
{
    deleteKey(WebPreferencesKey::pageVisibilityBasedProcessSuppressionEnabledKey());
}

void WebPreferences::setPaginateDuringLayoutEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::paginateDuringLayoutEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::paginateDuringLayoutEnabledKey(), value);
}

bool WebPreferences::paginateDuringLayoutEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::paginateDuringLayoutEnabledKey());
}

void WebPreferences::deletePaginateDuringLayoutEnabled()
{
    deleteKey(WebPreferencesKey::paginateDuringLayoutEnabledKey());
}

void WebPreferences::setPassiveTouchListenersAsDefaultOnDocument(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::passiveTouchListenersAsDefaultOnDocumentKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::passiveTouchListenersAsDefaultOnDocumentKey(), value);
}

bool WebPreferences::passiveTouchListenersAsDefaultOnDocument() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::passiveTouchListenersAsDefaultOnDocumentKey());
}

void WebPreferences::deletePassiveTouchListenersAsDefaultOnDocument()
{
    deleteKey(WebPreferencesKey::passiveTouchListenersAsDefaultOnDocumentKey());
}

void WebPreferences::setPasswordEchoDuration(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::passwordEchoDurationKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::passwordEchoDurationKey(), value);
}

double WebPreferences::passwordEchoDuration() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::passwordEchoDurationKey());
}

void WebPreferences::deletePasswordEchoDuration()
{
    deleteKey(WebPreferencesKey::passwordEchoDurationKey());
}

void WebPreferences::setPasswordEchoEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::passwordEchoEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::passwordEchoEnabledKey(), value);
}

bool WebPreferences::passwordEchoEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::passwordEchoEnabledKey());
}

void WebPreferences::deletePasswordEchoEnabled()
{
    deleteKey(WebPreferencesKey::passwordEchoEnabledKey());
}

void WebPreferences::setPeerConnectionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::peerConnectionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::peerConnectionEnabledKey(), value);
}

bool WebPreferences::peerConnectionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::peerConnectionEnabledKey());
}

void WebPreferences::deletePeerConnectionEnabled()
{
    deleteKey(WebPreferencesKey::peerConnectionEnabledKey());
}

void WebPreferences::setPictographFontFamily(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::pictographFontFamilyKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::pictographFontFamilyKey(), value);
}

String WebPreferences::pictographFontFamily() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::pictographFontFamilyKey());
}

void WebPreferences::deletePictographFontFamily()
{
    deleteKey(WebPreferencesKey::pictographFontFamilyKey());
}

void WebPreferences::setPictureInPictureAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::pictureInPictureAPIEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::pictureInPictureAPIEnabledKey(), value);
}

bool WebPreferences::pictureInPictureAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::pictureInPictureAPIEnabledKey());
}

void WebPreferences::deletePictureInPictureAPIEnabled()
{
    deleteKey(WebPreferencesKey::pictureInPictureAPIEnabledKey());
}

void WebPreferences::setPitchCorrectionAlgorithm(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::pitchCorrectionAlgorithmKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::pitchCorrectionAlgorithmKey(), value);
}

uint32_t WebPreferences::pitchCorrectionAlgorithm() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::pitchCorrectionAlgorithmKey());
}

void WebPreferences::deletePitchCorrectionAlgorithm()
{
    deleteKey(WebPreferencesKey::pitchCorrectionAlgorithmKey());
}

void WebPreferences::setPluginsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::pluginsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::pluginsEnabledKey(), value);
}

bool WebPreferences::pluginsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::pluginsEnabledKey());
}

void WebPreferences::deletePluginsEnabled()
{
    deleteKey(WebPreferencesKey::pluginsEnabledKey());
}

void WebPreferences::setPrivateClickMeasurementEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::privateClickMeasurementEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::privateClickMeasurementEnabledKey(), value);
}

bool WebPreferences::privateClickMeasurementEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::privateClickMeasurementEnabledKey());
}

void WebPreferences::deletePrivateClickMeasurementEnabled()
{
    deleteKey(WebPreferencesKey::privateClickMeasurementEnabledKey());
}

void WebPreferences::setPunchOutWhiteBackgroundsInDarkMode(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::punchOutWhiteBackgroundsInDarkModeKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::punchOutWhiteBackgroundsInDarkModeKey(), value);
}

bool WebPreferences::punchOutWhiteBackgroundsInDarkMode() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::punchOutWhiteBackgroundsInDarkModeKey());
}

void WebPreferences::deletePunchOutWhiteBackgroundsInDarkMode()
{
    deleteKey(WebPreferencesKey::punchOutWhiteBackgroundsInDarkModeKey());
}

void WebPreferences::setRequiresPageVisibilityToPlayAudio(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requiresPageVisibilityToPlayAudioKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::requiresPageVisibilityToPlayAudioKey(), value);
}

bool WebPreferences::requiresPageVisibilityToPlayAudio() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requiresPageVisibilityToPlayAudioKey());
}

void WebPreferences::deleteRequiresPageVisibilityToPlayAudio()
{
    deleteKey(WebPreferencesKey::requiresPageVisibilityToPlayAudioKey());
}

void WebPreferences::setRequiresUserGestureForAudioPlayback(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requiresUserGestureForAudioPlaybackKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::requiresUserGestureForAudioPlaybackKey(), value);
}

bool WebPreferences::requiresUserGestureForAudioPlayback() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requiresUserGestureForAudioPlaybackKey());
}

void WebPreferences::deleteRequiresUserGestureForAudioPlayback()
{
    deleteKey(WebPreferencesKey::requiresUserGestureForAudioPlaybackKey());
}

void WebPreferences::setRequiresUserGestureForMediaPlayback(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requiresUserGestureForMediaPlaybackKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::requiresUserGestureForMediaPlaybackKey(), value);
}

bool WebPreferences::requiresUserGestureForMediaPlayback() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requiresUserGestureForMediaPlaybackKey());
}

void WebPreferences::deleteRequiresUserGestureForMediaPlayback()
{
    deleteKey(WebPreferencesKey::requiresUserGestureForMediaPlaybackKey());
}

void WebPreferences::setRequiresUserGestureForVideoPlayback(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requiresUserGestureForVideoPlaybackKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::requiresUserGestureForVideoPlaybackKey(), value);
}

bool WebPreferences::requiresUserGestureForVideoPlayback() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requiresUserGestureForVideoPlaybackKey());
}

void WebPreferences::deleteRequiresUserGestureForVideoPlayback()
{
    deleteKey(WebPreferencesKey::requiresUserGestureForVideoPlaybackKey());
}

void WebPreferences::setRequiresUserGestureToLoadVideo(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requiresUserGestureToLoadVideoKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::requiresUserGestureToLoadVideoKey(), value);
}

bool WebPreferences::requiresUserGestureToLoadVideo() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requiresUserGestureToLoadVideoKey());
}

void WebPreferences::deleteRequiresUserGestureToLoadVideo()
{
    deleteKey(WebPreferencesKey::requiresUserGestureToLoadVideoKey());
}

void WebPreferences::setRubberBandingForSubScrollableRegionsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::rubberBandingForSubScrollableRegionsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::rubberBandingForSubScrollableRegionsEnabledKey(), value);
}

bool WebPreferences::rubberBandingForSubScrollableRegionsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::rubberBandingForSubScrollableRegionsEnabledKey());
}

void WebPreferences::deleteRubberBandingForSubScrollableRegionsEnabled()
{
    deleteKey(WebPreferencesKey::rubberBandingForSubScrollableRegionsEnabledKey());
}

void WebPreferences::setSafeBrowsingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::safeBrowsingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::safeBrowsingEnabledKey(), value);
}

bool WebPreferences::safeBrowsingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::safeBrowsingEnabledKey());
}

void WebPreferences::deleteSafeBrowsingEnabled()
{
    deleteKey(WebPreferencesKey::safeBrowsingEnabledKey());
}

void WebPreferences::setSampledPageTopColorMaxDifference(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMaxDifferenceKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMaxDifferenceKey(), value);
}

double WebPreferences::sampledPageTopColorMaxDifference() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMaxDifferenceKey());
}

void WebPreferences::deleteSampledPageTopColorMaxDifference()
{
    deleteKey(WebPreferencesKey::sampledPageTopColorMaxDifferenceKey());
}

void WebPreferences::setSampledPageTopColorMinHeight(const double& value)
{
    if (!m_store.setDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMinHeightKey(), value))
        return;
    updateDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMinHeightKey(), value);
}

double WebPreferences::sampledPageTopColorMinHeight() const
{
    return m_store.getDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMinHeightKey());
}

void WebPreferences::deleteSampledPageTopColorMinHeight()
{
    deleteKey(WebPreferencesKey::sampledPageTopColorMinHeightKey());
}

void WebPreferences::setSansSerifFontFamily(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::sansSerifFontFamilyKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::sansSerifFontFamilyKey(), value);
}

String WebPreferences::sansSerifFontFamily() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::sansSerifFontFamilyKey());
}

void WebPreferences::deleteSansSerifFontFamily()
{
    deleteKey(WebPreferencesKey::sansSerifFontFamilyKey());
}

void WebPreferences::setScrollAnimatorEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::scrollAnimatorEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::scrollAnimatorEnabledKey(), value);
}

bool WebPreferences::scrollAnimatorEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::scrollAnimatorEnabledKey());
}

void WebPreferences::deleteScrollAnimatorEnabled()
{
    deleteKey(WebPreferencesKey::scrollAnimatorEnabledKey());
}

void WebPreferences::setSelectTrailingWhitespaceEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::selectTrailingWhitespaceEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::selectTrailingWhitespaceEnabledKey(), value);
}

bool WebPreferences::selectTrailingWhitespaceEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::selectTrailingWhitespaceEnabledKey());
}

void WebPreferences::deleteSelectTrailingWhitespaceEnabled()
{
    deleteKey(WebPreferencesKey::selectTrailingWhitespaceEnabledKey());
}

void WebPreferences::setSelectionPaintingWithoutSelectionGapsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::selectionPaintingWithoutSelectionGapsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::selectionPaintingWithoutSelectionGapsEnabledKey(), value);
}

bool WebPreferences::selectionPaintingWithoutSelectionGapsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::selectionPaintingWithoutSelectionGapsEnabledKey());
}

void WebPreferences::deleteSelectionPaintingWithoutSelectionGapsEnabled()
{
    deleteKey(WebPreferencesKey::selectionPaintingWithoutSelectionGapsEnabledKey());
}

void WebPreferences::setSerifFontFamily(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::serifFontFamilyKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::serifFontFamilyKey(), value);
}

String WebPreferences::serifFontFamily() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::serifFontFamilyKey());
}

void WebPreferences::deleteSerifFontFamily()
{
    deleteKey(WebPreferencesKey::serifFontFamilyKey());
}

void WebPreferences::setServiceControlsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::serviceControlsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::serviceControlsEnabledKey(), value);
}

bool WebPreferences::serviceControlsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::serviceControlsEnabledKey());
}

void WebPreferences::deleteServiceControlsEnabled()
{
    deleteKey(WebPreferencesKey::serviceControlsEnabledKey());
}

void WebPreferences::setServiceWorkerEntitlementDisabledForTesting(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::serviceWorkerEntitlementDisabledForTestingKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::serviceWorkerEntitlementDisabledForTestingKey(), value);
}

bool WebPreferences::serviceWorkerEntitlementDisabledForTesting() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::serviceWorkerEntitlementDisabledForTestingKey());
}

void WebPreferences::deleteServiceWorkerEntitlementDisabledForTesting()
{
    deleteKey(WebPreferencesKey::serviceWorkerEntitlementDisabledForTestingKey());
}

void WebPreferences::setShouldAllowUserInstalledFonts(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldAllowUserInstalledFontsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldAllowUserInstalledFontsKey(), value);
}

bool WebPreferences::shouldAllowUserInstalledFonts() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldAllowUserInstalledFontsKey());
}

void WebPreferences::deleteShouldAllowUserInstalledFonts()
{
    deleteKey(WebPreferencesKey::shouldAllowUserInstalledFontsKey());
}

void WebPreferences::setShouldConvertInvalidURLsToBlank(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldConvertInvalidURLsToBlankKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldConvertInvalidURLsToBlankKey(), value);
}

bool WebPreferences::shouldConvertInvalidURLsToBlank() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldConvertInvalidURLsToBlankKey());
}

void WebPreferences::deleteShouldConvertInvalidURLsToBlank()
{
    deleteKey(WebPreferencesKey::shouldConvertInvalidURLsToBlankKey());
}

void WebPreferences::setShouldConvertPositionStyleOnCopy(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldConvertPositionStyleOnCopyKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldConvertPositionStyleOnCopyKey(), value);
}

bool WebPreferences::shouldConvertPositionStyleOnCopy() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldConvertPositionStyleOnCopyKey());
}

void WebPreferences::deleteShouldConvertPositionStyleOnCopy()
{
    deleteKey(WebPreferencesKey::shouldConvertPositionStyleOnCopyKey());
}

void WebPreferences::setShouldDecidePolicyBeforeLoadingQuickLookPreview(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldDecidePolicyBeforeLoadingQuickLookPreviewKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldDecidePolicyBeforeLoadingQuickLookPreviewKey(), value);
}

bool WebPreferences::shouldDecidePolicyBeforeLoadingQuickLookPreview() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldDecidePolicyBeforeLoadingQuickLookPreviewKey());
}

void WebPreferences::deleteShouldDecidePolicyBeforeLoadingQuickLookPreview()
{
    deleteKey(WebPreferencesKey::shouldDecidePolicyBeforeLoadingQuickLookPreviewKey());
}

void WebPreferences::setShouldDisplayCaptions(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldDisplayCaptionsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldDisplayCaptionsKey(), value);
}

bool WebPreferences::shouldDisplayCaptions() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldDisplayCaptionsKey());
}

void WebPreferences::deleteShouldDisplayCaptions()
{
    deleteKey(WebPreferencesKey::shouldDisplayCaptionsKey());
}

void WebPreferences::setShouldDisplaySubtitles(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldDisplaySubtitlesKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldDisplaySubtitlesKey(), value);
}

bool WebPreferences::shouldDisplaySubtitles() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldDisplaySubtitlesKey());
}

void WebPreferences::deleteShouldDisplaySubtitles()
{
    deleteKey(WebPreferencesKey::shouldDisplaySubtitlesKey());
}

void WebPreferences::setShouldDisplayTextDescriptions(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldDisplayTextDescriptionsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldDisplayTextDescriptionsKey(), value);
}

bool WebPreferences::shouldDisplayTextDescriptions() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldDisplayTextDescriptionsKey());
}

void WebPreferences::deleteShouldDisplayTextDescriptions()
{
    deleteKey(WebPreferencesKey::shouldDisplayTextDescriptionsKey());
}

void WebPreferences::setShouldEnableTextAutosizingBoost(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldEnableTextAutosizingBoostKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldEnableTextAutosizingBoostKey(), value);
}

bool WebPreferences::shouldEnableTextAutosizingBoost() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldEnableTextAutosizingBoostKey());
}

void WebPreferences::deleteShouldEnableTextAutosizingBoost()
{
    deleteKey(WebPreferencesKey::shouldEnableTextAutosizingBoostKey());
}

void WebPreferences::setShouldIgnoreMetaViewport(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldIgnoreMetaViewportKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldIgnoreMetaViewportKey(), value);
}

bool WebPreferences::shouldIgnoreMetaViewport() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldIgnoreMetaViewportKey());
}

void WebPreferences::deleteShouldIgnoreMetaViewport()
{
    deleteKey(WebPreferencesKey::shouldIgnoreMetaViewportKey());
}

void WebPreferences::setShouldPrintBackgrounds(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldPrintBackgroundsKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldPrintBackgroundsKey(), value);
}

bool WebPreferences::shouldPrintBackgrounds() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldPrintBackgroundsKey());
}

void WebPreferences::deleteShouldPrintBackgrounds()
{
    deleteKey(WebPreferencesKey::shouldPrintBackgroundsKey());
}

void WebPreferences::setShouldRespectImageOrientation(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldRespectImageOrientationKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldRespectImageOrientationKey(), value);
}

bool WebPreferences::shouldRespectImageOrientation() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldRespectImageOrientationKey());
}

void WebPreferences::deleteShouldRespectImageOrientation()
{
    deleteKey(WebPreferencesKey::shouldRespectImageOrientationKey());
}

void WebPreferences::setShouldRestrictBaseURLSchemes(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldRestrictBaseURLSchemesKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldRestrictBaseURLSchemesKey(), value);
}

bool WebPreferences::shouldRestrictBaseURLSchemes() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldRestrictBaseURLSchemesKey());
}

void WebPreferences::deleteShouldRestrictBaseURLSchemes()
{
    deleteKey(WebPreferencesKey::shouldRestrictBaseURLSchemesKey());
}

void WebPreferences::setShouldSuppressTextInputFromEditingDuringProvisionalNavigation(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldSuppressTextInputFromEditingDuringProvisionalNavigationKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldSuppressTextInputFromEditingDuringProvisionalNavigationKey(), value);
}

bool WebPreferences::shouldSuppressTextInputFromEditingDuringProvisionalNavigation() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldSuppressTextInputFromEditingDuringProvisionalNavigationKey());
}

void WebPreferences::deleteShouldSuppressTextInputFromEditingDuringProvisionalNavigation()
{
    deleteKey(WebPreferencesKey::shouldSuppressTextInputFromEditingDuringProvisionalNavigationKey());
}

void WebPreferences::setShouldUseServiceWorkerShortTimeout(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldUseServiceWorkerShortTimeoutKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shouldUseServiceWorkerShortTimeoutKey(), value);
}

bool WebPreferences::shouldUseServiceWorkerShortTimeout() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldUseServiceWorkerShortTimeoutKey());
}

void WebPreferences::deleteShouldUseServiceWorkerShortTimeout()
{
    deleteKey(WebPreferencesKey::shouldUseServiceWorkerShortTimeoutKey());
}

void WebPreferences::setShowsToolTipOverTruncatedText(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::showsToolTipOverTruncatedTextKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::showsToolTipOverTruncatedTextKey(), value);
}

bool WebPreferences::showsToolTipOverTruncatedText() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::showsToolTipOverTruncatedTextKey());
}

void WebPreferences::deleteShowsToolTipOverTruncatedText()
{
    deleteKey(WebPreferencesKey::showsToolTipOverTruncatedTextKey());
}

void WebPreferences::setShowsURLsInToolTipsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::showsURLsInToolTipsEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::showsURLsInToolTipsEnabledKey(), value);
}

bool WebPreferences::showsURLsInToolTipsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::showsURLsInToolTipsEnabledKey());
}

void WebPreferences::deleteShowsURLsInToolTipsEnabled()
{
    deleteKey(WebPreferencesKey::showsURLsInToolTipsEnabledKey());
}

void WebPreferences::setShrinksStandaloneImagesToFit(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shrinksStandaloneImagesToFitKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::shrinksStandaloneImagesToFitKey(), value);
}

bool WebPreferences::shrinksStandaloneImagesToFit() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shrinksStandaloneImagesToFitKey());
}

void WebPreferences::deleteShrinksStandaloneImagesToFit()
{
    deleteKey(WebPreferencesKey::shrinksStandaloneImagesToFitKey());
}

void WebPreferences::setSmartInsertDeleteEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::smartInsertDeleteEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::smartInsertDeleteEnabledKey(), value);
}

bool WebPreferences::smartInsertDeleteEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::smartInsertDeleteEnabledKey());
}

void WebPreferences::deleteSmartInsertDeleteEnabled()
{
    deleteKey(WebPreferencesKey::smartInsertDeleteEnabledKey());
}

void WebPreferences::setSourceBufferChangeTypeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::sourceBufferChangeTypeEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::sourceBufferChangeTypeEnabledKey(), value);
}

bool WebPreferences::sourceBufferChangeTypeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::sourceBufferChangeTypeEnabledKey());
}

void WebPreferences::deleteSourceBufferChangeTypeEnabled()
{
    deleteKey(WebPreferencesKey::sourceBufferChangeTypeEnabledKey());
}

void WebPreferences::setSpatialNavigationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::spatialNavigationEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::spatialNavigationEnabledKey(), value);
}

bool WebPreferences::spatialNavigationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::spatialNavigationEnabledKey());
}

void WebPreferences::deleteSpatialNavigationEnabled()
{
    deleteKey(WebPreferencesKey::spatialNavigationEnabledKey());
}

void WebPreferences::setStandalone(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::standaloneKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::standaloneKey(), value);
}

bool WebPreferences::standalone() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::standaloneKey());
}

void WebPreferences::deleteStandalone()
{
    deleteKey(WebPreferencesKey::standaloneKey());
}

void WebPreferences::setStandardFontFamily(const String& value)
{
    if (!m_store.setStringValueForKey(WebPreferencesKey::standardFontFamilyKey(), value))
        return;
    updateStringValueForKey(WebPreferencesKey::standardFontFamilyKey(), value);
}

String WebPreferences::standardFontFamily() const
{
    return m_store.getStringValueForKey(WebPreferencesKey::standardFontFamilyKey());
}

void WebPreferences::deleteStandardFontFamily()
{
    deleteKey(WebPreferencesKey::standardFontFamilyKey());
}

void WebPreferences::setStorageAccessAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::storageAccessAPIEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::storageAccessAPIEnabledKey(), value);
}

bool WebPreferences::storageAccessAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::storageAccessAPIEnabledKey());
}

void WebPreferences::deleteStorageAccessAPIEnabled()
{
    deleteKey(WebPreferencesKey::storageAccessAPIEnabledKey());
}

void WebPreferences::setStorageBlockingPolicy(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::storageBlockingPolicyKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::storageBlockingPolicyKey(), value);
}

uint32_t WebPreferences::storageBlockingPolicy() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::storageBlockingPolicyKey());
}

void WebPreferences::deleteStorageBlockingPolicy()
{
    deleteKey(WebPreferencesKey::storageBlockingPolicyKey());
}

void WebPreferences::setSuppressesIncrementalRendering(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::suppressesIncrementalRenderingKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::suppressesIncrementalRenderingKey(), value);
}

bool WebPreferences::suppressesIncrementalRendering() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::suppressesIncrementalRenderingKey());
}

void WebPreferences::deleteSuppressesIncrementalRendering()
{
    deleteKey(WebPreferencesKey::suppressesIncrementalRenderingKey());
}

void WebPreferences::setSystemLayoutDirection(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::systemLayoutDirectionKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::systemLayoutDirectionKey(), value);
}

uint32_t WebPreferences::systemLayoutDirection() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::systemLayoutDirectionKey());
}

void WebPreferences::deleteSystemLayoutDirection()
{
    deleteKey(WebPreferencesKey::systemLayoutDirectionKey());
}

void WebPreferences::setSystemPreviewEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::systemPreviewEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::systemPreviewEnabledKey(), value);
}

bool WebPreferences::systemPreviewEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::systemPreviewEnabledKey());
}

void WebPreferences::deleteSystemPreviewEnabled()
{
    deleteKey(WebPreferencesKey::systemPreviewEnabledKey());
}

void WebPreferences::setTabsToLinks(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::tabsToLinksKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::tabsToLinksKey(), value);
}

bool WebPreferences::tabsToLinks() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::tabsToLinksKey());
}

void WebPreferences::deleteTabsToLinks()
{
    deleteKey(WebPreferencesKey::tabsToLinksKey());
}

void WebPreferences::setTelephoneNumberParsingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::telephoneNumberParsingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::telephoneNumberParsingEnabledKey(), value);
}

bool WebPreferences::telephoneNumberParsingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::telephoneNumberParsingEnabledKey());
}

void WebPreferences::deleteTelephoneNumberParsingEnabled()
{
    deleteKey(WebPreferencesKey::telephoneNumberParsingEnabledKey());
}

void WebPreferences::setTemporaryTileCohortRetentionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::temporaryTileCohortRetentionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::temporaryTileCohortRetentionEnabledKey(), value);
}

bool WebPreferences::temporaryTileCohortRetentionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::temporaryTileCohortRetentionEnabledKey());
}

void WebPreferences::deleteTemporaryTileCohortRetentionEnabled()
{
    deleteKey(WebPreferencesKey::temporaryTileCohortRetentionEnabledKey());
}

void WebPreferences::setTextAreasAreResizable(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::textAreasAreResizableKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::textAreasAreResizableKey(), value);
}

bool WebPreferences::textAreasAreResizable() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::textAreasAreResizableKey());
}

void WebPreferences::deleteTextAreasAreResizable()
{
    deleteKey(WebPreferencesKey::textAreasAreResizableKey());
}

void WebPreferences::setTextAutosizingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::textAutosizingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::textAutosizingEnabledKey(), value);
}

bool WebPreferences::textAutosizingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::textAutosizingEnabledKey());
}

void WebPreferences::deleteTextAutosizingEnabled()
{
    deleteKey(WebPreferencesKey::textAutosizingEnabledKey());
}

void WebPreferences::setTextInteractionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::textInteractionEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::textInteractionEnabledKey(), value);
}

bool WebPreferences::textInteractionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::textInteractionEnabledKey());
}

void WebPreferences::deleteTextInteractionEnabled()
{
    deleteKey(WebPreferencesKey::textInteractionEnabledKey());
}

void WebPreferences::setThreadedScrollingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::threadedScrollingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::threadedScrollingEnabledKey(), value);
}

bool WebPreferences::threadedScrollingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::threadedScrollingEnabledKey());
}

void WebPreferences::deleteThreadedScrollingEnabled()
{
    deleteKey(WebPreferencesKey::threadedScrollingEnabledKey());
}

void WebPreferences::setTreatsAnyTextCSSLinkAsStylesheet(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::treatsAnyTextCSSLinkAsStylesheetKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::treatsAnyTextCSSLinkAsStylesheetKey(), value);
}

bool WebPreferences::treatsAnyTextCSSLinkAsStylesheet() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::treatsAnyTextCSSLinkAsStylesheetKey());
}

void WebPreferences::deleteTreatsAnyTextCSSLinkAsStylesheet()
{
    deleteKey(WebPreferencesKey::treatsAnyTextCSSLinkAsStylesheetKey());
}

void WebPreferences::setUseGiantTiles(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useGiantTilesKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::useGiantTilesKey(), value);
}

bool WebPreferences::useGiantTiles() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useGiantTilesKey());
}

void WebPreferences::deleteUseGiantTiles()
{
    deleteKey(WebPreferencesKey::useGiantTilesKey());
}

void WebPreferences::setUseImageDocumentForSubframePDF(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useImageDocumentForSubframePDFKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::useImageDocumentForSubframePDFKey(), value);
}

bool WebPreferences::useImageDocumentForSubframePDF() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useImageDocumentForSubframePDFKey());
}

void WebPreferences::deleteUseImageDocumentForSubframePDF()
{
    deleteKey(WebPreferencesKey::useImageDocumentForSubframePDFKey());
}

void WebPreferences::setUseLegacyBackgroundSizeShorthandBehavior(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useLegacyBackgroundSizeShorthandBehaviorKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::useLegacyBackgroundSizeShorthandBehaviorKey(), value);
}

bool WebPreferences::useLegacyBackgroundSizeShorthandBehavior() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useLegacyBackgroundSizeShorthandBehaviorKey());
}

void WebPreferences::deleteUseLegacyBackgroundSizeShorthandBehavior()
{
    deleteKey(WebPreferencesKey::useLegacyBackgroundSizeShorthandBehaviorKey());
}

void WebPreferences::setUseLegacyTextAlignPositionedElementBehavior(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useLegacyTextAlignPositionedElementBehaviorKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::useLegacyTextAlignPositionedElementBehaviorKey(), value);
}

bool WebPreferences::useLegacyTextAlignPositionedElementBehavior() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useLegacyTextAlignPositionedElementBehaviorKey());
}

void WebPreferences::deleteUseLegacyTextAlignPositionedElementBehavior()
{
    deleteKey(WebPreferencesKey::useLegacyTextAlignPositionedElementBehaviorKey());
}

void WebPreferences::setUsePreHTML5ParserQuirks(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::usePreHTML5ParserQuirksKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::usePreHTML5ParserQuirksKey(), value);
}

bool WebPreferences::usePreHTML5ParserQuirks() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::usePreHTML5ParserQuirksKey());
}

void WebPreferences::deleteUsePreHTML5ParserQuirks()
{
    deleteKey(WebPreferencesKey::usePreHTML5ParserQuirksKey());
}

void WebPreferences::setUserInterfaceDirectionPolicy(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::userInterfaceDirectionPolicyKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::userInterfaceDirectionPolicyKey(), value);
}

uint32_t WebPreferences::userInterfaceDirectionPolicy() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::userInterfaceDirectionPolicyKey());
}

void WebPreferences::deleteUserInterfaceDirectionPolicy()
{
    deleteKey(WebPreferencesKey::userInterfaceDirectionPolicyKey());
}

void WebPreferences::setUsesBackForwardCache(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::usesBackForwardCacheKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::usesBackForwardCacheKey(), value);
}

bool WebPreferences::usesBackForwardCache() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::usesBackForwardCacheKey());
}

void WebPreferences::deleteUsesBackForwardCache()
{
    deleteKey(WebPreferencesKey::usesBackForwardCacheKey());
}

void WebPreferences::setUsesEncodingDetector(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::usesEncodingDetectorKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::usesEncodingDetectorKey(), value);
}

bool WebPreferences::usesEncodingDetector() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::usesEncodingDetectorKey());
}

void WebPreferences::deleteUsesEncodingDetector()
{
    deleteKey(WebPreferencesKey::usesEncodingDetectorKey());
}

void WebPreferences::setVideoQualityIncludesDisplayCompositingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::videoQualityIncludesDisplayCompositingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::videoQualityIncludesDisplayCompositingEnabledKey(), value);
}

bool WebPreferences::videoQualityIncludesDisplayCompositingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::videoQualityIncludesDisplayCompositingEnabledKey());
}

void WebPreferences::deleteVideoQualityIncludesDisplayCompositingEnabled()
{
    deleteKey(WebPreferencesKey::videoQualityIncludesDisplayCompositingEnabledKey());
}

void WebPreferences::setViewGestureDebuggingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::viewGestureDebuggingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::viewGestureDebuggingEnabledKey(), value);
}

bool WebPreferences::viewGestureDebuggingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::viewGestureDebuggingEnabledKey());
}

void WebPreferences::deleteViewGestureDebuggingEnabled()
{
    deleteKey(WebPreferencesKey::viewGestureDebuggingEnabledKey());
}

void WebPreferences::setViewportFitEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::viewportFitEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::viewportFitEnabledKey(), value);
}

bool WebPreferences::viewportFitEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::viewportFitEnabledKey());
}

void WebPreferences::deleteViewportFitEnabled()
{
    deleteKey(WebPreferencesKey::viewportFitEnabledKey());
}

void WebPreferences::setVisualViewportEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::visualViewportEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::visualViewportEnabledKey(), value);
}

bool WebPreferences::visualViewportEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::visualViewportEnabledKey());
}

void WebPreferences::deleteVisualViewportEnabled()
{
    deleteKey(WebPreferencesKey::visualViewportEnabledKey());
}

void WebPreferences::setWantsBalancedSetDefersLoadingBehavior(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::wantsBalancedSetDefersLoadingBehaviorKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::wantsBalancedSetDefersLoadingBehaviorKey(), value);
}

bool WebPreferences::wantsBalancedSetDefersLoadingBehavior() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::wantsBalancedSetDefersLoadingBehaviorKey());
}

void WebPreferences::deleteWantsBalancedSetDefersLoadingBehavior()
{
    deleteKey(WebPreferencesKey::wantsBalancedSetDefersLoadingBehaviorKey());
}

void WebPreferences::setWebArchiveDebugModeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webArchiveDebugModeEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::webArchiveDebugModeEnabledKey(), value);
}

bool WebPreferences::webArchiveDebugModeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webArchiveDebugModeEnabledKey());
}

void WebPreferences::deleteWebArchiveDebugModeEnabled()
{
    deleteKey(WebPreferencesKey::webArchiveDebugModeEnabledKey());
}

void WebPreferences::setWebAudioEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAudioEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::webAudioEnabledKey(), value);
}

bool WebPreferences::webAudioEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAudioEnabledKey());
}

void WebPreferences::deleteWebAudioEnabled()
{
    deleteKey(WebPreferencesKey::webAudioEnabledKey());
}

void WebPreferences::setWebGLEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webGLEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::webGLEnabledKey(), value);
}

bool WebPreferences::webGLEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webGLEnabledKey());
}

void WebPreferences::deleteWebGLEnabled()
{
    deleteKey(WebPreferencesKey::webGLEnabledKey());
}

void WebPreferences::setWebGPU(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webGPUKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::webGPUKey(), value);
}

bool WebPreferences::webGPU() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webGPUKey());
}

void WebPreferences::deleteWebGPU()
{
    deleteKey(WebPreferencesKey::webGPUKey());
}

void WebPreferences::setWebSecurityEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webSecurityEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::webSecurityEnabledKey(), value);
}

bool WebPreferences::webSecurityEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webSecurityEnabledKey());
}

void WebPreferences::deleteWebSecurityEnabled()
{
    deleteKey(WebPreferencesKey::webSecurityEnabledKey());
}

void WebPreferences::setWebShareEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webShareEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::webShareEnabledKey(), value);
}

bool WebPreferences::webShareEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webShareEnabledKey());
}

void WebPreferences::deleteWebShareEnabled()
{
    deleteKey(WebPreferencesKey::webShareEnabledKey());
}

void WebPreferences::setWindowFocusRestricted(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::windowFocusRestrictedKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::windowFocusRestrictedKey(), value);
}

bool WebPreferences::windowFocusRestricted() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::windowFocusRestrictedKey());
}

void WebPreferences::deleteWindowFocusRestricted()
{
    deleteKey(WebPreferencesKey::windowFocusRestrictedKey());
}

void WebPreferences::setXSSAuditorEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::xssAuditorEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::xssAuditorEnabledKey(), value);
}

bool WebPreferences::xssAuditorEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::xssAuditorEnabledKey());
}

void WebPreferences::deleteXSSAuditorEnabled()
{
    deleteKey(WebPreferencesKey::xssAuditorEnabledKey());
}

void WebPreferences::setAcceleratedDrawingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::acceleratedDrawingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::acceleratedDrawingEnabledKey(), value);
}

bool WebPreferences::acceleratedDrawingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::acceleratedDrawingEnabledKey());
}

void WebPreferences::deleteAcceleratedDrawingEnabled()
{
    deleteKey(WebPreferencesKey::acceleratedDrawingEnabledKey());
}

void WebPreferences::setCompositingBordersVisible(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::compositingBordersVisibleKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::compositingBordersVisibleKey(), value);
}

bool WebPreferences::compositingBordersVisible() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::compositingBordersVisibleKey());
}

void WebPreferences::deleteCompositingBordersVisible()
{
    deleteKey(WebPreferencesKey::compositingBordersVisibleKey());
}

void WebPreferences::setCompositingRepaintCountersVisible(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::compositingRepaintCountersVisibleKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::compositingRepaintCountersVisibleKey(), value);
}

bool WebPreferences::compositingRepaintCountersVisible() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::compositingRepaintCountersVisibleKey());
}

void WebPreferences::deleteCompositingRepaintCountersVisible()
{
    deleteKey(WebPreferencesKey::compositingRepaintCountersVisibleKey());
}

void WebPreferences::setDeveloperExtrasEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::developerExtrasEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::developerExtrasEnabledKey(), value);
}

bool WebPreferences::developerExtrasEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::developerExtrasEnabledKey());
}

void WebPreferences::deleteDeveloperExtrasEnabled()
{
    deleteKey(WebPreferencesKey::developerExtrasEnabledKey());
}

void WebPreferences::setDisableScreenSizeOverride(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::disableScreenSizeOverrideKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::disableScreenSizeOverrideKey(), value);
}

bool WebPreferences::disableScreenSizeOverride() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::disableScreenSizeOverrideKey());
}

void WebPreferences::deleteDisableScreenSizeOverride()
{
    deleteKey(WebPreferencesKey::disableScreenSizeOverrideKey());
}

void WebPreferences::setDisplayListDrawingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::displayListDrawingEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::displayListDrawingEnabledKey(), value);
}

bool WebPreferences::displayListDrawingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::displayListDrawingEnabledKey());
}

void WebPreferences::deleteDisplayListDrawingEnabled()
{
    deleteKey(WebPreferencesKey::displayListDrawingEnabledKey());
}

void WebPreferences::setForceAlwaysUserScalable(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::forceAlwaysUserScalableKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::forceAlwaysUserScalableKey(), value);
}

bool WebPreferences::forceAlwaysUserScalable() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::forceAlwaysUserScalableKey());
}

void WebPreferences::deleteForceAlwaysUserScalable()
{
    deleteKey(WebPreferencesKey::forceAlwaysUserScalableKey());
}

void WebPreferences::setLegacyLineLayoutVisualCoverageEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::legacyLineLayoutVisualCoverageEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::legacyLineLayoutVisualCoverageEnabledKey(), value);
}

bool WebPreferences::legacyLineLayoutVisualCoverageEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::legacyLineLayoutVisualCoverageEnabledKey());
}

void WebPreferences::deleteLegacyLineLayoutVisualCoverageEnabled()
{
    deleteKey(WebPreferencesKey::legacyLineLayoutVisualCoverageEnabledKey());
}

void WebPreferences::setLogsPageMessagesToSystemConsoleEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::logsPageMessagesToSystemConsoleEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::logsPageMessagesToSystemConsoleEnabledKey(), value);
}

bool WebPreferences::logsPageMessagesToSystemConsoleEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::logsPageMessagesToSystemConsoleEnabledKey());
}

void WebPreferences::deleteLogsPageMessagesToSystemConsoleEnabled()
{
    deleteKey(WebPreferencesKey::logsPageMessagesToSystemConsoleEnabledKey());
}

void WebPreferences::setNeedsInAppBrowserPrivacyQuirks(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::needsInAppBrowserPrivacyQuirksKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::needsInAppBrowserPrivacyQuirksKey(), value);
}

bool WebPreferences::needsInAppBrowserPrivacyQuirks() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::needsInAppBrowserPrivacyQuirksKey());
}

void WebPreferences::deleteNeedsInAppBrowserPrivacyQuirks()
{
    deleteKey(WebPreferencesKey::needsInAppBrowserPrivacyQuirksKey());
}

void WebPreferences::setResourceUsageOverlayVisible(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::resourceUsageOverlayVisibleKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::resourceUsageOverlayVisibleKey(), value);
}

bool WebPreferences::resourceUsageOverlayVisible() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::resourceUsageOverlayVisibleKey());
}

void WebPreferences::deleteResourceUsageOverlayVisible()
{
    deleteKey(WebPreferencesKey::resourceUsageOverlayVisibleKey());
}

void WebPreferences::setSubpixelAntialiasedLayerTextEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::subpixelAntialiasedLayerTextEnabledKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::subpixelAntialiasedLayerTextEnabledKey(), value);
}

bool WebPreferences::subpixelAntialiasedLayerTextEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::subpixelAntialiasedLayerTextEnabledKey());
}

void WebPreferences::deleteSubpixelAntialiasedLayerTextEnabled()
{
    deleteKey(WebPreferencesKey::subpixelAntialiasedLayerTextEnabledKey());
}

void WebPreferences::setTiledScrollingIndicatorVisible(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::tiledScrollingIndicatorVisibleKey(), value))
        return;
    updateBoolValueForKey(WebPreferencesKey::tiledScrollingIndicatorVisibleKey(), value);
}

bool WebPreferences::tiledScrollingIndicatorVisible() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::tiledScrollingIndicatorVisibleKey());
}

void WebPreferences::deleteTiledScrollingIndicatorVisible()
{
    deleteKey(WebPreferencesKey::tiledScrollingIndicatorVisibleKey());
}

void WebPreferences::setVisibleDebugOverlayRegions(const uint32_t& value)
{
    if (!m_store.setUInt32ValueForKey(WebPreferencesKey::visibleDebugOverlayRegionsKey(), value))
        return;
    updateUInt32ValueForKey(WebPreferencesKey::visibleDebugOverlayRegionsKey(), value);
}

uint32_t WebPreferences::visibleDebugOverlayRegions() const
{
    return m_store.getUInt32ValueForKey(WebPreferencesKey::visibleDebugOverlayRegionsKey());
}

void WebPreferences::deleteVisibleDebugOverlayRegions()
{
    deleteKey(WebPreferencesKey::visibleDebugOverlayRegionsKey());
}


void WebPreferences::setFocusVisibleEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::focusVisibleEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::focusVisibleEnabledKey(), value);
}

bool WebPreferences::focusVisibleEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::focusVisibleEnabledKey());
}

void WebPreferences::deleteFocusVisibleEnabled()
{
    deleteKey(WebPreferencesKey::focusVisibleEnabledKey());
}

void WebPreferences::setHasPseudoClassEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::hasPseudoClassEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::hasPseudoClassEnabledKey(), value);
}

bool WebPreferences::hasPseudoClassEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::hasPseudoClassEnabledKey());
}

void WebPreferences::deleteHasPseudoClassEnabled()
{
    deleteKey(WebPreferencesKey::hasPseudoClassEnabledKey());
}

void WebPreferences::setPageAtRuleSupportEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::pageAtRuleSupportEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::pageAtRuleSupportEnabledKey(), value);
}

bool WebPreferences::pageAtRuleSupportEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::pageAtRuleSupportEnabledKey());
}

void WebPreferences::deletePageAtRuleSupportEnabled()
{
    deleteKey(WebPreferencesKey::pageAtRuleSupportEnabledKey());
}

void WebPreferences::setAccessHandleEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::accessHandleEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::accessHandleEnabledKey(), value);
}

bool WebPreferences::accessHandleEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::accessHandleEnabledKey());
}

void WebPreferences::deleteAccessHandleEnabled()
{
    deleteKey(WebPreferencesKey::accessHandleEnabledKey());
}

void WebPreferences::setAccessibilityObjectModelEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::accessibilityObjectModelEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::accessibilityObjectModelEnabledKey(), value);
}

bool WebPreferences::accessibilityObjectModelEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::accessibilityObjectModelEnabledKey());
}

void WebPreferences::deleteAccessibilityObjectModelEnabled()
{
    deleteKey(WebPreferencesKey::accessibilityObjectModelEnabledKey());
}

void WebPreferences::setPerElementSpeakerSelectionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::perElementSpeakerSelectionEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::perElementSpeakerSelectionEnabledKey(), value);
}

bool WebPreferences::perElementSpeakerSelectionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::perElementSpeakerSelectionEnabledKey());
}

void WebPreferences::deletePerElementSpeakerSelectionEnabled()
{
    deleteKey(WebPreferencesKey::perElementSpeakerSelectionEnabledKey());
}

void WebPreferences::setExposeSpeakersEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::exposeSpeakersEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::exposeSpeakersEnabledKey(), value);
}

bool WebPreferences::exposeSpeakersEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::exposeSpeakersEnabledKey());
}

void WebPreferences::deleteExposeSpeakersEnabled()
{
    deleteKey(WebPreferencesKey::exposeSpeakersEnabledKey());
}

void WebPreferences::setAspectRatioOfImgFromWidthAndHeightEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::aspectRatioOfImgFromWidthAndHeightEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::aspectRatioOfImgFromWidthAndHeightEnabledKey(), value);
}

bool WebPreferences::aspectRatioOfImgFromWidthAndHeightEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::aspectRatioOfImgFromWidthAndHeightEnabledKey());
}

void WebPreferences::deleteAspectRatioOfImgFromWidthAndHeightEnabled()
{
    deleteKey(WebPreferencesKey::aspectRatioOfImgFromWidthAndHeightEnabledKey());
}

void WebPreferences::setAsyncClipboardAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::asyncClipboardAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::asyncClipboardAPIEnabledKey(), value);
}

bool WebPreferences::asyncClipboardAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::asyncClipboardAPIEnabledKey());
}

void WebPreferences::deleteAsyncClipboardAPIEnabled()
{
    deleteKey(WebPreferencesKey::asyncClipboardAPIEnabledKey());
}

void WebPreferences::setBlankAnchorTargetImpliesNoOpenerEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::blankAnchorTargetImpliesNoOpenerEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::blankAnchorTargetImpliesNoOpenerEnabledKey(), value);
}

bool WebPreferences::blankAnchorTargetImpliesNoOpenerEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::blankAnchorTargetImpliesNoOpenerEnabledKey());
}

void WebPreferences::deleteBlankAnchorTargetImpliesNoOpenerEnabled()
{
    deleteKey(WebPreferencesKey::blankAnchorTargetImpliesNoOpenerEnabledKey());
}

void WebPreferences::setThirdPartyIframeRedirectBlockingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::thirdPartyIframeRedirectBlockingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::thirdPartyIframeRedirectBlockingEnabledKey(), value);
}

bool WebPreferences::thirdPartyIframeRedirectBlockingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::thirdPartyIframeRedirectBlockingEnabledKey());
}

void WebPreferences::deleteThirdPartyIframeRedirectBlockingEnabled()
{
    deleteKey(WebPreferencesKey::thirdPartyIframeRedirectBlockingEnabledKey());
}

void WebPreferences::setBroadcastChannelEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::broadcastChannelEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::broadcastChannelEnabledKey(), value);
}

bool WebPreferences::broadcastChannelEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::broadcastChannelEnabledKey());
}

void WebPreferences::deleteBroadcastChannelEnabled()
{
    deleteKey(WebPreferencesKey::broadcastChannelEnabledKey());
}

void WebPreferences::setBroadcastChannelOriginPartitioningEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::broadcastChannelOriginPartitioningEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::broadcastChannelOriginPartitioningEnabledKey(), value);
}

bool WebPreferences::broadcastChannelOriginPartitioningEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::broadcastChannelOriginPartitioningEnabledKey());
}

void WebPreferences::deleteBroadcastChannelOriginPartitioningEnabled()
{
    deleteKey(WebPreferencesKey::broadcastChannelOriginPartitioningEnabledKey());
}

void WebPreferences::setBuiltInNotificationsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::builtInNotificationsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::builtInNotificationsEnabledKey(), value);
}

bool WebPreferences::builtInNotificationsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::builtInNotificationsEnabledKey());
}

void WebPreferences::deleteBuiltInNotificationsEnabled()
{
    deleteKey(WebPreferencesKey::builtInNotificationsEnabledKey());
}

void WebPreferences::setCSS3DTransformInteroperabilityEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::css3DTransformInteroperabilityEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::css3DTransformInteroperabilityEnabledKey(), value);
}

bool WebPreferences::css3DTransformInteroperabilityEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::css3DTransformInteroperabilityEnabledKey());
}

void WebPreferences::deleteCSS3DTransformInteroperabilityEnabled()
{
    deleteKey(WebPreferencesKey::css3DTransformInteroperabilityEnabledKey());
}

void WebPreferences::setCSSCounterStyleAtRuleImageSymbolsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssCounterStyleAtRuleImageSymbolsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssCounterStyleAtRuleImageSymbolsEnabledKey(), value);
}

bool WebPreferences::cssCounterStyleAtRuleImageSymbolsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssCounterStyleAtRuleImageSymbolsEnabledKey());
}

void WebPreferences::deleteCSSCounterStyleAtRuleImageSymbolsEnabled()
{
    deleteKey(WebPreferencesKey::cssCounterStyleAtRuleImageSymbolsEnabledKey());
}

void WebPreferences::setCSSCounterStyleAtRulesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssCounterStyleAtRulesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssCounterStyleAtRulesEnabledKey(), value);
}

bool WebPreferences::cssCounterStyleAtRulesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssCounterStyleAtRulesEnabledKey());
}

void WebPreferences::deleteCSSCounterStyleAtRulesEnabled()
{
    deleteKey(WebPreferencesKey::cssCounterStyleAtRulesEnabledKey());
}

void WebPreferences::setAccentColorEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::accentColorEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::accentColorEnabledKey(), value);
}

bool WebPreferences::accentColorEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::accentColorEnabledKey());
}

void WebPreferences::deleteAccentColorEnabled()
{
    deleteKey(WebPreferencesKey::accentColorEnabledKey());
}

void WebPreferences::setAspectRatioEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::aspectRatioEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::aspectRatioEnabledKey(), value);
}

bool WebPreferences::aspectRatioEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::aspectRatioEnabledKey());
}

void WebPreferences::deleteAspectRatioEnabled()
{
    deleteKey(WebPreferencesKey::aspectRatioEnabledKey());
}

void WebPreferences::setCSSCascadeLayersEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssCascadeLayersEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssCascadeLayersEnabledKey(), value);
}

bool WebPreferences::cssCascadeLayersEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssCascadeLayersEnabledKey());
}

void WebPreferences::deleteCSSCascadeLayersEnabled()
{
    deleteKey(WebPreferencesKey::cssCascadeLayersEnabledKey());
}

void WebPreferences::setCSSColor4(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssColor4Key(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssColor4Key(), value);
}

bool WebPreferences::cssColor4() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssColor4Key());
}

void WebPreferences::deleteCSSColor4()
{
    deleteKey(WebPreferencesKey::cssColor4Key());
}

void WebPreferences::setCSSContainerQueriesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssContainerQueriesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssContainerQueriesEnabledKey(), value);
}

bool WebPreferences::cssContainerQueriesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssContainerQueriesEnabledKey());
}

void WebPreferences::deleteCSSContainerQueriesEnabled()
{
    deleteKey(WebPreferencesKey::cssContainerQueriesEnabledKey());
}

void WebPreferences::setCSSContainmentEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssContainmentEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssContainmentEnabledKey(), value);
}

bool WebPreferences::cssContainmentEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssContainmentEnabledKey());
}

void WebPreferences::deleteCSSContainmentEnabled()
{
    deleteKey(WebPreferencesKey::cssContainmentEnabledKey());
}

void WebPreferences::setCSSCustomPropertiesAndValuesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssCustomPropertiesAndValuesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssCustomPropertiesAndValuesEnabledKey(), value);
}

bool WebPreferences::cssCustomPropertiesAndValuesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssCustomPropertiesAndValuesEnabledKey());
}

void WebPreferences::deleteCSSCustomPropertiesAndValuesEnabled()
{
    deleteKey(WebPreferencesKey::cssCustomPropertiesAndValuesEnabledKey());
}

void WebPreferences::setCSSGradientInterpolationColorSpacesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssGradientInterpolationColorSpacesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssGradientInterpolationColorSpacesEnabledKey(), value);
}

bool WebPreferences::cssGradientInterpolationColorSpacesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssGradientInterpolationColorSpacesEnabledKey());
}

void WebPreferences::deleteCSSGradientInterpolationColorSpacesEnabled()
{
    deleteKey(WebPreferencesKey::cssGradientInterpolationColorSpacesEnabledKey());
}

void WebPreferences::setCSSGradientPremultipliedAlphaInterpolationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssGradientPremultipliedAlphaInterpolationEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssGradientPremultipliedAlphaInterpolationEnabledKey(), value);
}

bool WebPreferences::cssGradientPremultipliedAlphaInterpolationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssGradientPremultipliedAlphaInterpolationEnabledKey());
}

void WebPreferences::deleteCSSGradientPremultipliedAlphaInterpolationEnabled()
{
    deleteKey(WebPreferencesKey::cssGradientPremultipliedAlphaInterpolationEnabledKey());
}

void WebPreferences::setCSSIndividualTransformPropertiesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssIndividualTransformPropertiesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssIndividualTransformPropertiesEnabledKey(), value);
}

bool WebPreferences::cssIndividualTransformPropertiesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssIndividualTransformPropertiesEnabledKey());
}

void WebPreferences::deleteCSSIndividualTransformPropertiesEnabled()
{
    deleteKey(WebPreferencesKey::cssIndividualTransformPropertiesEnabledKey());
}

void WebPreferences::setCSSInputSecurityEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssInputSecurityEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssInputSecurityEnabledKey(), value);
}

bool WebPreferences::cssInputSecurityEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssInputSecurityEnabledKey());
}

void WebPreferences::deleteCSSInputSecurityEnabled()
{
    deleteKey(WebPreferencesKey::cssInputSecurityEnabledKey());
}

void WebPreferences::setCSSMotionPathEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssMotionPathEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssMotionPathEnabledKey(), value);
}

bool WebPreferences::cssMotionPathEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssMotionPathEnabledKey());
}

void WebPreferences::deleteCSSMotionPathEnabled()
{
    deleteKey(WebPreferencesKey::cssMotionPathEnabledKey());
}

void WebPreferences::setOverscrollBehaviorEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::overscrollBehaviorEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::overscrollBehaviorEnabledKey(), value);
}

bool WebPreferences::overscrollBehaviorEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::overscrollBehaviorEnabledKey());
}

void WebPreferences::deleteOverscrollBehaviorEnabled()
{
    deleteKey(WebPreferencesKey::overscrollBehaviorEnabledKey());
}

void WebPreferences::setCSSPaintingAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssPaintingAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssPaintingAPIEnabledKey(), value);
}

bool WebPreferences::cssPaintingAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssPaintingAPIEnabledKey());
}

void WebPreferences::deleteCSSPaintingAPIEnabled()
{
    deleteKey(WebPreferencesKey::cssPaintingAPIEnabledKey());
}

void WebPreferences::setCSSRelativeColorSyntaxEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssRelativeColorSyntaxEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssRelativeColorSyntaxEnabledKey(), value);
}

bool WebPreferences::cssRelativeColorSyntaxEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssRelativeColorSyntaxEnabledKey());
}

void WebPreferences::deleteCSSRelativeColorSyntaxEnabled()
{
    deleteKey(WebPreferencesKey::cssRelativeColorSyntaxEnabledKey());
}

void WebPreferences::setSpringTimingFunctionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::springTimingFunctionEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::springTimingFunctionEnabledKey(), value);
}

bool WebPreferences::springTimingFunctionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::springTimingFunctionEnabledKey());
}

void WebPreferences::deleteSpringTimingFunctionEnabled()
{
    deleteKey(WebPreferencesKey::springTimingFunctionEnabledKey());
}

void WebPreferences::setCSSTypedOMEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssTypedOMEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssTypedOMEnabledKey(), value);
}

bool WebPreferences::cssTypedOMEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssTypedOMEnabledKey());
}

void WebPreferences::deleteCSSTypedOMEnabled()
{
    deleteKey(WebPreferencesKey::cssTypedOMEnabledKey());
}

void WebPreferences::setCSSColorContrastEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssColorContrastEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssColorContrastEnabledKey(), value);
}

bool WebPreferences::cssColorContrastEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssColorContrastEnabledKey());
}

void WebPreferences::deleteCSSColorContrastEnabled()
{
    deleteKey(WebPreferencesKey::cssColorContrastEnabledKey());
}

void WebPreferences::setCSSColorMixEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssColorMixEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssColorMixEnabledKey(), value);
}

bool WebPreferences::cssColorMixEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssColorMixEnabledKey());
}

void WebPreferences::deleteCSSColorMixEnabled()
{
    deleteKey(WebPreferencesKey::cssColorMixEnabledKey());
}

void WebPreferences::setOverflowClipEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::overflowClipEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::overflowClipEnabledKey(), value);
}

bool WebPreferences::overflowClipEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::overflowClipEnabledKey());
}

void WebPreferences::deleteOverflowClipEnabled()
{
    deleteKey(WebPreferencesKey::overflowClipEnabledKey());
}

void WebPreferences::setSubgridEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::subgridEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::subgridEnabledKey(), value);
}

bool WebPreferences::subgridEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::subgridEnabledKey());
}

void WebPreferences::deleteSubgridEnabled()
{
    deleteKey(WebPreferencesKey::subgridEnabledKey());
}

void WebPreferences::setCSSOMViewSmoothScrollingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssOMViewSmoothScrollingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cssOMViewSmoothScrollingEnabledKey(), value);
}

bool WebPreferences::cssOMViewSmoothScrollingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssOMViewSmoothScrollingEnabledKey());
}

void WebPreferences::deleteCSSOMViewSmoothScrollingEnabled()
{
    deleteKey(WebPreferencesKey::cssOMViewSmoothScrollingEnabledKey());
}

void WebPreferences::setCanvasColorSpaceEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::canvasColorSpaceEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::canvasColorSpaceEnabledKey(), value);
}

bool WebPreferences::canvasColorSpaceEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::canvasColorSpaceEnabledKey());
}

void WebPreferences::deleteCanvasColorSpaceEnabled()
{
    deleteKey(WebPreferencesKey::canvasColorSpaceEnabledKey());
}

void WebPreferences::setContactPickerAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::contactPickerAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::contactPickerAPIEnabledKey(), value);
}

bool WebPreferences::contactPickerAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::contactPickerAPIEnabledKey());
}

void WebPreferences::deleteContactPickerAPIEnabled()
{
    deleteKey(WebPreferencesKey::contactPickerAPIEnabledKey());
}

void WebPreferences::setCrossOriginEmbedderPolicyEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::crossOriginEmbedderPolicyEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::crossOriginEmbedderPolicyEnabledKey(), value);
}

bool WebPreferences::crossOriginEmbedderPolicyEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::crossOriginEmbedderPolicyEnabledKey());
}

void WebPreferences::deleteCrossOriginEmbedderPolicyEnabled()
{
    deleteKey(WebPreferencesKey::crossOriginEmbedderPolicyEnabledKey());
}

void WebPreferences::setCrossOriginOpenerPolicyEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::crossOriginOpenerPolicyEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::crossOriginOpenerPolicyEnabledKey(), value);
}

bool WebPreferences::crossOriginOpenerPolicyEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::crossOriginOpenerPolicyEnabledKey());
}

void WebPreferences::deleteCrossOriginOpenerPolicyEnabled()
{
    deleteKey(WebPreferencesKey::crossOriginOpenerPolicyEnabledKey());
}

void WebPreferences::setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaintKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaintKey(), value);
}

bool WebPreferences::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaintKey());
}

void WebPreferences::deleteShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint()
{
    deleteKey(WebPreferencesKey::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaintKey());
}

void WebPreferences::setDialogElementEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::dialogElementEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::dialogElementEnabledKey(), value);
}

bool WebPreferences::dialogElementEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::dialogElementEnabledKey());
}

void WebPreferences::deleteDialogElementEnabled()
{
    deleteKey(WebPreferencesKey::dialogElementEnabledKey());
}

void WebPreferences::setIsThirdPartyCookieBlockingDisabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isThirdPartyCookieBlockingDisabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::isThirdPartyCookieBlockingDisabledKey(), value);
}

bool WebPreferences::isThirdPartyCookieBlockingDisabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isThirdPartyCookieBlockingDisabledKey());
}

void WebPreferences::deleteIsThirdPartyCookieBlockingDisabled()
{
    deleteKey(WebPreferencesKey::isThirdPartyCookieBlockingDisabledKey());
}

void WebPreferences::setDisableMediaExperiencePIDInheritance(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::disableMediaExperiencePIDInheritanceKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::disableMediaExperiencePIDInheritanceKey(), value);
}

bool WebPreferences::disableMediaExperiencePIDInheritance() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::disableMediaExperiencePIDInheritanceKey());
}

void WebPreferences::deleteDisableMediaExperiencePIDInheritance()
{
    deleteKey(WebPreferencesKey::disableMediaExperiencePIDInheritanceKey());
}

void WebPreferences::setIsFirstPartyWebsiteDataRemovalDisabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalDisabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalDisabledKey(), value);
}

bool WebPreferences::isFirstPartyWebsiteDataRemovalDisabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalDisabledKey());
}

void WebPreferences::deleteIsFirstPartyWebsiteDataRemovalDisabled()
{
    deleteKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalDisabledKey());
}

void WebPreferences::setDisallowSyncXHRDuringPageDismissalEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::disallowSyncXHRDuringPageDismissalEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::disallowSyncXHRDuringPageDismissalEnabledKey(), value);
}

bool WebPreferences::disallowSyncXHRDuringPageDismissalEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::disallowSyncXHRDuringPageDismissalEnabledKey());
}

void WebPreferences::deleteDisallowSyncXHRDuringPageDismissalEnabled()
{
    deleteKey(WebPreferencesKey::disallowSyncXHRDuringPageDismissalEnabledKey());
}

void WebPreferences::setMediaSessionCoordinatorEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaSessionCoordinatorEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::mediaSessionCoordinatorEnabledKey(), value);
}

bool WebPreferences::mediaSessionCoordinatorEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaSessionCoordinatorEnabledKey());
}

void WebPreferences::deleteMediaSessionCoordinatorEnabled()
{
    deleteKey(WebPreferencesKey::mediaSessionCoordinatorEnabledKey());
}

void WebPreferences::setMediaSessionPlaylistEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaSessionPlaylistEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::mediaSessionPlaylistEnabledKey(), value);
}

bool WebPreferences::mediaSessionPlaylistEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaSessionPlaylistEnabledKey());
}

void WebPreferences::deleteMediaSessionPlaylistEnabled()
{
    deleteKey(WebPreferencesKey::mediaSessionPlaylistEnabledKey());
}

void WebPreferences::setMediaSourceInlinePaintingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaSourceInlinePaintingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::mediaSourceInlinePaintingEnabledKey(), value);
}

bool WebPreferences::mediaSourceInlinePaintingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaSourceInlinePaintingEnabledKey());
}

void WebPreferences::deleteMediaSourceInlinePaintingEnabled()
{
    deleteKey(WebPreferencesKey::mediaSourceInlinePaintingEnabledKey());
}

void WebPreferences::setCFNetworkNetworkLoaderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cFNetworkNetworkLoaderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::cFNetworkNetworkLoaderEnabledKey(), value);
}

bool WebPreferences::cFNetworkNetworkLoaderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cFNetworkNetworkLoaderEnabledKey());
}

void WebPreferences::deleteCFNetworkNetworkLoaderEnabled()
{
    deleteKey(WebPreferencesKey::cFNetworkNetworkLoaderEnabledKey());
}

void WebPreferences::setFTPEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::ftpEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::ftpEnabledKey(), value);
}

bool WebPreferences::ftpEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::ftpEnabledKey());
}

void WebPreferences::deleteFTPEnabled()
{
    deleteKey(WebPreferencesKey::ftpEnabledKey());
}

void WebPreferences::setFetchAPIKeepAliveEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::fetchAPIKeepAliveEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::fetchAPIKeepAliveEnabledKey(), value);
}

bool WebPreferences::fetchAPIKeepAliveEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::fetchAPIKeepAliveEnabledKey());
}

void WebPreferences::deleteFetchAPIKeepAliveEnabled()
{
    deleteKey(WebPreferencesKey::fetchAPIKeepAliveEnabledKey());
}

void WebPreferences::setFileSystemAccessEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::fileSystemAccessEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::fileSystemAccessEnabledKey(), value);
}

bool WebPreferences::fileSystemAccessEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::fileSystemAccessEnabledKey());
}

void WebPreferences::deleteFileSystemAccessEnabled()
{
    deleteKey(WebPreferencesKey::fileSystemAccessEnabledKey());
}

void WebPreferences::setRequestSubmitEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requestSubmitEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::requestSubmitEnabledKey(), value);
}

bool WebPreferences::requestSubmitEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requestSubmitEnabledKey());
}

void WebPreferences::deleteRequestSubmitEnabled()
{
    deleteKey(WebPreferencesKey::requestSubmitEnabledKey());
}

void WebPreferences::setUseGPUProcessForDOMRenderingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useGPUProcessForDOMRenderingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::useGPUProcessForDOMRenderingEnabledKey(), value);
}

bool WebPreferences::useGPUProcessForDOMRenderingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useGPUProcessForDOMRenderingEnabledKey());
}

void WebPreferences::deleteUseGPUProcessForDOMRenderingEnabled()
{
    deleteKey(WebPreferencesKey::useGPUProcessForDOMRenderingEnabledKey());
}

void WebPreferences::setUseGPUProcessForDisplayCapture(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useGPUProcessForDisplayCaptureKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::useGPUProcessForDisplayCaptureKey(), value);
}

bool WebPreferences::useGPUProcessForDisplayCapture() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useGPUProcessForDisplayCaptureKey());
}

void WebPreferences::deleteUseGPUProcessForDisplayCapture()
{
    deleteKey(WebPreferencesKey::useGPUProcessForDisplayCaptureKey());
}

void WebPreferences::setUseGPUProcessForWebGLEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useGPUProcessForWebGLEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::useGPUProcessForWebGLEnabledKey(), value);
}

bool WebPreferences::useGPUProcessForWebGLEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useGPUProcessForWebGLEnabledKey());
}

void WebPreferences::deleteUseGPUProcessForWebGLEnabled()
{
    deleteKey(WebPreferencesKey::useGPUProcessForWebGLEnabledKey());
}

void WebPreferences::setGenericCueAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::genericCueAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::genericCueAPIEnabledKey(), value);
}

bool WebPreferences::genericCueAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::genericCueAPIEnabledKey());
}

void WebPreferences::deleteGenericCueAPIEnabled()
{
    deleteKey(WebPreferencesKey::genericCueAPIEnabledKey());
}

void WebPreferences::setHDRMediaCapabilitiesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::hDRMediaCapabilitiesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::hDRMediaCapabilitiesEnabledKey(), value);
}

bool WebPreferences::hDRMediaCapabilitiesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::hDRMediaCapabilitiesEnabledKey());
}

void WebPreferences::deleteHDRMediaCapabilitiesEnabled()
{
    deleteKey(WebPreferencesKey::hDRMediaCapabilitiesEnabledKey());
}

void WebPreferences::setModelElementEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::modelElementEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::modelElementEnabledKey(), value);
}

bool WebPreferences::modelElementEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::modelElementEnabledKey());
}

void WebPreferences::deleteModelElementEnabled()
{
    deleteKey(WebPreferencesKey::modelElementEnabledKey());
}

void WebPreferences::setModelDocumentEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::modelDocumentEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::modelDocumentEnabledKey(), value);
}

bool WebPreferences::modelDocumentEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::modelDocumentEnabledKey());
}

void WebPreferences::deleteModelDocumentEnabled()
{
    deleteKey(WebPreferencesKey::modelDocumentEnabledKey());
}

void WebPreferences::setHTTP3Enabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::http3EnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::http3EnabledKey(), value);
}

bool WebPreferences::http3Enabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::http3EnabledKey());
}

void WebPreferences::deleteHTTP3Enabled()
{
    deleteKey(WebPreferencesKey::http3EnabledKey());
}

void WebPreferences::setHighlightAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::highlightAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::highlightAPIEnabledKey(), value);
}

bool WebPreferences::highlightAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::highlightAPIEnabledKey());
}

void WebPreferences::deleteHighlightAPIEnabled()
{
    deleteKey(WebPreferencesKey::highlightAPIEnabledKey());
}

void WebPreferences::setImageBitmapEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::imageBitmapEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::imageBitmapEnabledKey(), value);
}

bool WebPreferences::imageBitmapEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::imageBitmapEnabledKey());
}

void WebPreferences::deleteImageBitmapEnabled()
{
    deleteKey(WebPreferencesKey::imageBitmapEnabledKey());
}

void WebPreferences::setInProcessCookieCacheEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inProcessCookieCacheEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::inProcessCookieCacheEnabledKey(), value);
}

bool WebPreferences::inProcessCookieCacheEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inProcessCookieCacheEnabledKey());
}

void WebPreferences::deleteInProcessCookieCacheEnabled()
{
    deleteKey(WebPreferencesKey::inProcessCookieCacheEnabledKey());
}

void WebPreferences::setIncrementalPDFLoadingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::incrementalPDFLoadingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::incrementalPDFLoadingEnabledKey(), value);
}

bool WebPreferences::incrementalPDFLoadingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::incrementalPDFLoadingEnabledKey());
}

void WebPreferences::deleteIncrementalPDFLoadingEnabled()
{
    deleteKey(WebPreferencesKey::incrementalPDFLoadingEnabledKey());
}

void WebPreferences::setIntersectionObserverEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::intersectionObserverEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::intersectionObserverEnabledKey(), value);
}

bool WebPreferences::intersectionObserverEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::intersectionObserverEnabledKey());
}

void WebPreferences::deleteIntersectionObserverEnabled()
{
    deleteKey(WebPreferencesKey::intersectionObserverEnabledKey());
}

void WebPreferences::setIsLoggedInAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isLoggedInAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::isLoggedInAPIEnabledKey(), value);
}

bool WebPreferences::isLoggedInAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isLoggedInAPIEnabledKey());
}

void WebPreferences::deleteIsLoggedInAPIEnabled()
{
    deleteKey(WebPreferencesKey::isLoggedInAPIEnabledKey());
}

void WebPreferences::setLazyIframeLoadingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::lazyIframeLoadingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::lazyIframeLoadingEnabledKey(), value);
}

bool WebPreferences::lazyIframeLoadingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::lazyIframeLoadingEnabledKey());
}

void WebPreferences::deleteLazyIframeLoadingEnabled()
{
    deleteKey(WebPreferencesKey::lazyIframeLoadingEnabledKey());
}

void WebPreferences::setLazyImageLoadingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::lazyImageLoadingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::lazyImageLoadingEnabledKey(), value);
}

bool WebPreferences::lazyImageLoadingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::lazyImageLoadingEnabledKey());
}

void WebPreferences::deleteLazyImageLoadingEnabled()
{
    deleteKey(WebPreferencesKey::lazyImageLoadingEnabledKey());
}

void WebPreferences::setLinkSanitizerEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::linkSanitizerEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::linkSanitizerEnabledKey(), value);
}

bool WebPreferences::linkSanitizerEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::linkSanitizerEnabledKey());
}

void WebPreferences::deleteLinkSanitizerEnabled()
{
    deleteKey(WebPreferencesKey::linkSanitizerEnabledKey());
}

void WebPreferences::setLinkPreloadResponsiveImagesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::linkPreloadResponsiveImagesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::linkPreloadResponsiveImagesEnabledKey(), value);
}

bool WebPreferences::linkPreloadResponsiveImagesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::linkPreloadResponsiveImagesEnabledKey());
}

void WebPreferences::deleteLinkPreloadResponsiveImagesEnabled()
{
    deleteKey(WebPreferencesKey::linkPreloadResponsiveImagesEnabledKey());
}

void WebPreferences::setLinkPrefetchEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::linkPrefetchEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::linkPrefetchEnabledKey(), value);
}

bool WebPreferences::linkPrefetchEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::linkPrefetchEnabledKey());
}

void WebPreferences::deleteLinkPrefetchEnabled()
{
    deleteKey(WebPreferencesKey::linkPrefetchEnabledKey());
}

void WebPreferences::setMaskWebGLStringsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::maskWebGLStringsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::maskWebGLStringsEnabledKey(), value);
}

bool WebPreferences::maskWebGLStringsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::maskWebGLStringsEnabledKey());
}

void WebPreferences::deleteMaskWebGLStringsEnabled()
{
    deleteKey(WebPreferencesKey::maskWebGLStringsEnabledKey());
}

void WebPreferences::setCoreMathMLEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::coreMathMLEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::coreMathMLEnabledKey(), value);
}

bool WebPreferences::coreMathMLEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::coreMathMLEnabledKey());
}

void WebPreferences::deleteCoreMathMLEnabled()
{
    deleteKey(WebPreferencesKey::coreMathMLEnabledKey());
}

void WebPreferences::setMediaCapabilitiesExtensionsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaCapabilitiesExtensionsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::mediaCapabilitiesExtensionsEnabledKey(), value);
}

bool WebPreferences::mediaCapabilitiesExtensionsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaCapabilitiesExtensionsEnabledKey());
}

void WebPreferences::deleteMediaCapabilitiesExtensionsEnabled()
{
    deleteKey(WebPreferencesKey::mediaCapabilitiesExtensionsEnabledKey());
}

void WebPreferences::setMediaSessionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaSessionEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::mediaSessionEnabledKey(), value);
}

bool WebPreferences::mediaSessionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaSessionEnabledKey());
}

void WebPreferences::deleteMediaSessionEnabled()
{
    deleteKey(WebPreferencesKey::mediaSessionEnabledKey());
}

void WebPreferences::setMediaRecorderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaRecorderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::mediaRecorderEnabledKey(), value);
}

bool WebPreferences::mediaRecorderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaRecorderEnabledKey());
}

void WebPreferences::deleteMediaRecorderEnabled()
{
    deleteKey(WebPreferencesKey::mediaRecorderEnabledKey());
}

void WebPreferences::setIsNSURLSessionWebSocketEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isNSURLSessionWebSocketEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::isNSURLSessionWebSocketEnabledKey(), value);
}

bool WebPreferences::isNSURLSessionWebSocketEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isNSURLSessionWebSocketEnabledKey());
}

void WebPreferences::deleteIsNSURLSessionWebSocketEnabled()
{
    deleteKey(WebPreferencesKey::isNSURLSessionWebSocketEnabledKey());
}

void WebPreferences::setOpusDecoderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::opusDecoderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::opusDecoderEnabledKey(), value);
}

bool WebPreferences::opusDecoderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::opusDecoderEnabledKey());
}

void WebPreferences::deleteOpusDecoderEnabled()
{
    deleteKey(WebPreferencesKey::opusDecoderEnabledKey());
}

void WebPreferences::setPaintTimingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::paintTimingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::paintTimingEnabledKey(), value);
}

bool WebPreferences::paintTimingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::paintTimingEnabledKey());
}

void WebPreferences::deletePaintTimingEnabled()
{
    deleteKey(WebPreferencesKey::paintTimingEnabledKey());
}

void WebPreferences::setPerformanceNavigationTimingAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::performanceNavigationTimingAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::performanceNavigationTimingAPIEnabledKey(), value);
}

bool WebPreferences::performanceNavigationTimingAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::performanceNavigationTimingAPIEnabledKey());
}

void WebPreferences::deletePerformanceNavigationTimingAPIEnabled()
{
    deleteKey(WebPreferencesKey::performanceNavigationTimingAPIEnabledKey());
}

void WebPreferences::setPerformanceResourceTimingSensitivePropertiesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::performanceResourceTimingSensitivePropertiesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::performanceResourceTimingSensitivePropertiesEnabledKey(), value);
}

bool WebPreferences::performanceResourceTimingSensitivePropertiesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::performanceResourceTimingSensitivePropertiesEnabledKey());
}

void WebPreferences::deletePerformanceResourceTimingSensitivePropertiesEnabled()
{
    deleteKey(WebPreferencesKey::performanceResourceTimingSensitivePropertiesEnabledKey());
}

void WebPreferences::setPermissionsAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::permissionsAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::permissionsAPIEnabledKey(), value);
}

bool WebPreferences::permissionsAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::permissionsAPIEnabledKey());
}

void WebPreferences::deletePermissionsAPIEnabled()
{
    deleteKey(WebPreferencesKey::permissionsAPIEnabledKey());
}

void WebPreferences::setPreferPageRenderingUpdatesNear60FPSEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::preferPageRenderingUpdatesNear60FPSEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::preferPageRenderingUpdatesNear60FPSEnabledKey(), value);
}

bool WebPreferences::preferPageRenderingUpdatesNear60FPSEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::preferPageRenderingUpdatesNear60FPSEnabledKey());
}

void WebPreferences::deletePreferPageRenderingUpdatesNear60FPSEnabled()
{
    deleteKey(WebPreferencesKey::preferPageRenderingUpdatesNear60FPSEnabledKey());
}

void WebPreferences::setPrivateClickMeasurementDebugModeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::privateClickMeasurementDebugModeEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::privateClickMeasurementDebugModeEnabledKey(), value);
}

bool WebPreferences::privateClickMeasurementDebugModeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::privateClickMeasurementDebugModeEnabledKey());
}

void WebPreferences::deletePrivateClickMeasurementDebugModeEnabled()
{
    deleteKey(WebPreferencesKey::privateClickMeasurementDebugModeEnabledKey());
}

void WebPreferences::setPrivateClickMeasurementFraudPreventionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::privateClickMeasurementFraudPreventionEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::privateClickMeasurementFraudPreventionEnabledKey(), value);
}

bool WebPreferences::privateClickMeasurementFraudPreventionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::privateClickMeasurementFraudPreventionEnabledKey());
}

void WebPreferences::deletePrivateClickMeasurementFraudPreventionEnabled()
{
    deleteKey(WebPreferencesKey::privateClickMeasurementFraudPreventionEnabledKey());
}

void WebPreferences::setPushAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::pushAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::pushAPIEnabledKey(), value);
}

bool WebPreferences::pushAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::pushAPIEnabledKey());
}

void WebPreferences::deletePushAPIEnabled()
{
    deleteKey(WebPreferencesKey::pushAPIEnabledKey());
}

void WebPreferences::setGoogleAntiFlickerOptimizationQuirkEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::googleAntiFlickerOptimizationQuirkEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::googleAntiFlickerOptimizationQuirkEnabledKey(), value);
}

bool WebPreferences::googleAntiFlickerOptimizationQuirkEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::googleAntiFlickerOptimizationQuirkEnabledKey());
}

void WebPreferences::deleteGoogleAntiFlickerOptimizationQuirkEnabled()
{
    deleteKey(WebPreferencesKey::googleAntiFlickerOptimizationQuirkEnabledKey());
}

void WebPreferences::setReadableByteStreamAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::readableByteStreamAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::readableByteStreamAPIEnabledKey(), value);
}

bool WebPreferences::readableByteStreamAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::readableByteStreamAPIEnabledKey());
}

void WebPreferences::deleteReadableByteStreamAPIEnabled()
{
    deleteKey(WebPreferencesKey::readableByteStreamAPIEnabledKey());
}

void WebPreferences::setReferrerPolicyAttributeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::referrerPolicyAttributeEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::referrerPolicyAttributeEnabledKey(), value);
}

bool WebPreferences::referrerPolicyAttributeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::referrerPolicyAttributeEnabledKey());
}

void WebPreferences::deleteReferrerPolicyAttributeEnabled()
{
    deleteKey(WebPreferencesKey::referrerPolicyAttributeEnabledKey());
}

void WebPreferences::setRemotePlaybackEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::remotePlaybackEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::remotePlaybackEnabledKey(), value);
}

bool WebPreferences::remotePlaybackEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::remotePlaybackEnabledKey());
}

void WebPreferences::deleteRemotePlaybackEnabled()
{
    deleteKey(WebPreferencesKey::remotePlaybackEnabledKey());
}

void WebPreferences::setRequestVideoFrameCallbackEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requestVideoFrameCallbackEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::requestVideoFrameCallbackEnabledKey(), value);
}

bool WebPreferences::requestVideoFrameCallbackEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requestVideoFrameCallbackEnabledKey());
}

void WebPreferences::deleteRequestVideoFrameCallbackEnabled()
{
    deleteKey(WebPreferencesKey::requestVideoFrameCallbackEnabledKey());
}

void WebPreferences::setResizeObserverEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::resizeObserverEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::resizeObserverEnabledKey(), value);
}

bool WebPreferences::resizeObserverEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::resizeObserverEnabledKey());
}

void WebPreferences::deleteResizeObserverEnabled()
{
    deleteKey(WebPreferencesKey::resizeObserverEnabledKey());
}

void WebPreferences::setResolutionMediaFeatureEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::resolutionMediaFeatureEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::resolutionMediaFeatureEnabledKey(), value);
}

bool WebPreferences::resolutionMediaFeatureEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::resolutionMediaFeatureEnabledKey());
}

void WebPreferences::deleteResolutionMediaFeatureEnabled()
{
    deleteKey(WebPreferencesKey::resolutionMediaFeatureEnabledKey());
}

void WebPreferences::setIsSameSiteStrictEnforcementEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isSameSiteStrictEnforcementEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::isSameSiteStrictEnforcementEnabledKey(), value);
}

bool WebPreferences::isSameSiteStrictEnforcementEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isSameSiteStrictEnforcementEnabledKey());
}

void WebPreferences::deleteIsSameSiteStrictEnforcementEnabled()
{
    deleteKey(WebPreferencesKey::isSameSiteStrictEnforcementEnabledKey());
}

void WebPreferences::setScreenCaptureEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::screenCaptureEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::screenCaptureEnabledKey(), value);
}

bool WebPreferences::screenCaptureEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::screenCaptureEnabledKey());
}

void WebPreferences::deleteScreenCaptureEnabled()
{
    deleteKey(WebPreferencesKey::screenCaptureEnabledKey());
}

void WebPreferences::setScrollToTextFragmentEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::scrollToTextFragmentEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::scrollToTextFragmentEnabledKey(), value);
}

bool WebPreferences::scrollToTextFragmentEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::scrollToTextFragmentEnabledKey());
}

void WebPreferences::deleteScrollToTextFragmentEnabled()
{
    deleteKey(WebPreferencesKey::scrollToTextFragmentEnabledKey());
}

void WebPreferences::setServerTimingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::serverTimingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::serverTimingEnabledKey(), value);
}

bool WebPreferences::serverTimingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::serverTimingEnabledKey());
}

void WebPreferences::deleteServerTimingEnabled()
{
    deleteKey(WebPreferencesKey::serverTimingEnabledKey());
}

void WebPreferences::setServiceWorkerNavigationPreloadEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::serviceWorkerNavigationPreloadEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::serviceWorkerNavigationPreloadEnabledKey(), value);
}

bool WebPreferences::serviceWorkerNavigationPreloadEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::serviceWorkerNavigationPreloadEnabledKey());
}

void WebPreferences::deleteServiceWorkerNavigationPreloadEnabled()
{
    deleteKey(WebPreferencesKey::serviceWorkerNavigationPreloadEnabledKey());
}

void WebPreferences::setSharedWorkerEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::sharedWorkerEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::sharedWorkerEnabledKey(), value);
}

bool WebPreferences::sharedWorkerEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::sharedWorkerEnabledKey());
}

void WebPreferences::deleteSharedWorkerEnabled()
{
    deleteKey(WebPreferencesKey::sharedWorkerEnabledKey());
}

void WebPreferences::setSpeechRecognitionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::speechRecognitionEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::speechRecognitionEnabledKey(), value);
}

bool WebPreferences::speechRecognitionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::speechRecognitionEnabledKey());
}

void WebPreferences::deleteSpeechRecognitionEnabled()
{
    deleteKey(WebPreferencesKey::speechRecognitionEnabledKey());
}

void WebPreferences::setStorageAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::storageAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::storageAPIEnabledKey(), value);
}

bool WebPreferences::storageAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::storageAPIEnabledKey());
}

void WebPreferences::deleteStorageAPIEnabled()
{
    deleteKey(WebPreferencesKey::storageAPIEnabledKey());
}

void WebPreferences::setProcessSwapOnCrossSiteNavigationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::processSwapOnCrossSiteNavigationEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::processSwapOnCrossSiteNavigationEnabledKey(), value);
}

bool WebPreferences::processSwapOnCrossSiteNavigationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::processSwapOnCrossSiteNavigationEnabledKey());
}

void WebPreferences::deleteProcessSwapOnCrossSiteNavigationEnabled()
{
    deleteKey(WebPreferencesKey::processSwapOnCrossSiteNavigationEnabledKey());
}

void WebPreferences::setSyntheticEditingCommandsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::syntheticEditingCommandsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::syntheticEditingCommandsEnabledKey(), value);
}

bool WebPreferences::syntheticEditingCommandsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::syntheticEditingCommandsEnabledKey());
}

void WebPreferences::deleteSyntheticEditingCommandsEnabled()
{
    deleteKey(WebPreferencesKey::syntheticEditingCommandsEnabledKey());
}

void WebPreferences::setTrackConfigurationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::trackConfigurationEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::trackConfigurationEnabledKey(), value);
}

bool WebPreferences::trackConfigurationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::trackConfigurationEnabledKey());
}

void WebPreferences::deleteTrackConfigurationEnabled()
{
    deleteKey(WebPreferencesKey::trackConfigurationEnabledKey());
}

void WebPreferences::setTransformStreamAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::transformStreamAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::transformStreamAPIEnabledKey(), value);
}

bool WebPreferences::transformStreamAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::transformStreamAPIEnabledKey());
}

void WebPreferences::deleteTransformStreamAPIEnabled()
{
    deleteKey(WebPreferencesKey::transformStreamAPIEnabledKey());
}

void WebPreferences::setUseScreenCaptureKit(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useScreenCaptureKitKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::useScreenCaptureKitKey(), value);
}

bool WebPreferences::useScreenCaptureKit() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useScreenCaptureKitKey());
}

void WebPreferences::deleteUseScreenCaptureKit()
{
    deleteKey(WebPreferencesKey::useScreenCaptureKitKey());
}

void WebPreferences::setUserGesturePromisePropagationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::userGesturePromisePropagationEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::userGesturePromisePropagationEnabledKey(), value);
}

bool WebPreferences::userGesturePromisePropagationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::userGesturePromisePropagationEnabledKey());
}

void WebPreferences::deleteUserGesturePromisePropagationEnabled()
{
    deleteKey(WebPreferencesKey::userGesturePromisePropagationEnabledKey());
}

void WebPreferences::setVP8DecoderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::vp8DecoderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::vp8DecoderEnabledKey(), value);
}

bool WebPreferences::vp8DecoderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::vp8DecoderEnabledKey());
}

void WebPreferences::deleteVP8DecoderEnabled()
{
    deleteKey(WebPreferencesKey::vp8DecoderEnabledKey());
}

void WebPreferences::setVP9SWDecoderEnabledOnBattery(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::vp9SWDecoderEnabledOnBatteryKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::vp9SWDecoderEnabledOnBatteryKey(), value);
}

bool WebPreferences::vp9SWDecoderEnabledOnBattery() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::vp9SWDecoderEnabledOnBatteryKey());
}

void WebPreferences::deleteVP9SWDecoderEnabledOnBattery()
{
    deleteKey(WebPreferencesKey::vp9SWDecoderEnabledOnBatteryKey());
}

void WebPreferences::setVP9DecoderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::vp9DecoderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::vp9DecoderEnabledKey(), value);
}

bool WebPreferences::vp9DecoderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::vp9DecoderEnabledKey());
}

void WebPreferences::deleteVP9DecoderEnabled()
{
    deleteKey(WebPreferencesKey::vp9DecoderEnabledKey());
}

void WebPreferences::setVisualViewportAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::visualViewportAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::visualViewportAPIEnabledKey(), value);
}

bool WebPreferences::visualViewportAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::visualViewportAPIEnabledKey());
}

void WebPreferences::deleteVisualViewportAPIEnabled()
{
    deleteKey(WebPreferencesKey::visualViewportAPIEnabledKey());
}

void WebPreferences::setVorbisDecoderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::vorbisDecoderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::vorbisDecoderEnabledKey(), value);
}

bool WebPreferences::vorbisDecoderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::vorbisDecoderEnabledKey());
}

void WebPreferences::deleteVorbisDecoderEnabled()
{
    deleteKey(WebPreferencesKey::vorbisDecoderEnabledKey());
}

void WebPreferences::setWebAnimationsCompositeOperationsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAnimationsCompositeOperationsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webAnimationsCompositeOperationsEnabledKey(), value);
}

bool WebPreferences::webAnimationsCompositeOperationsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAnimationsCompositeOperationsEnabledKey());
}

void WebPreferences::deleteWebAnimationsCompositeOperationsEnabled()
{
    deleteKey(WebPreferencesKey::webAnimationsCompositeOperationsEnabledKey());
}

void WebPreferences::setWebAnimationsCustomEffectsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAnimationsCustomEffectsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webAnimationsCustomEffectsEnabledKey(), value);
}

bool WebPreferences::webAnimationsCustomEffectsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAnimationsCustomEffectsEnabledKey());
}

void WebPreferences::deleteWebAnimationsCustomEffectsEnabled()
{
    deleteKey(WebPreferencesKey::webAnimationsCustomEffectsEnabledKey());
}

void WebPreferences::setWebAnimationsCustomFrameRateEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAnimationsCustomFrameRateEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webAnimationsCustomFrameRateEnabledKey(), value);
}

bool WebPreferences::webAnimationsCustomFrameRateEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAnimationsCustomFrameRateEnabledKey());
}

void WebPreferences::deleteWebAnimationsCustomFrameRateEnabled()
{
    deleteKey(WebPreferencesKey::webAnimationsCustomFrameRateEnabledKey());
}

void WebPreferences::setWebAnimationsMutableTimelinesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAnimationsMutableTimelinesEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webAnimationsMutableTimelinesEnabledKey(), value);
}

bool WebPreferences::webAnimationsMutableTimelinesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAnimationsMutableTimelinesEnabledKey());
}

void WebPreferences::deleteWebAnimationsMutableTimelinesEnabled()
{
    deleteKey(WebPreferencesKey::webAnimationsMutableTimelinesEnabledKey());
}

void WebPreferences::setWebAuthenticationModernEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAuthenticationModernEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webAuthenticationModernEnabledKey(), value);
}

bool WebPreferences::webAuthenticationModernEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAuthenticationModernEnabledKey());
}

void WebPreferences::deleteWebAuthenticationModernEnabled()
{
    deleteKey(WebPreferencesKey::webAuthenticationModernEnabledKey());
}

void WebPreferences::setWebAuthenticationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAuthenticationEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webAuthenticationEnabledKey(), value);
}

bool WebPreferences::webAuthenticationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAuthenticationEnabledKey());
}

void WebPreferences::deleteWebAuthenticationEnabled()
{
    deleteKey(WebPreferencesKey::webAuthenticationEnabledKey());
}

void WebPreferences::setWebLocksAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webLocksAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webLocksAPIEnabledKey(), value);
}

bool WebPreferences::webLocksAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webLocksAPIEnabledKey());
}

void WebPreferences::deleteWebLocksAPIEnabled()
{
    deleteKey(WebPreferencesKey::webLocksAPIEnabledKey());
}

void WebPreferences::setWebShareFileAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webShareFileAPIEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webShareFileAPIEnabledKey(), value);
}

bool WebPreferences::webShareFileAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webShareFileAPIEnabledKey());
}

void WebPreferences::deleteWebShareFileAPIEnabled()
{
    deleteKey(WebPreferencesKey::webShareFileAPIEnabledKey());
}

void WebPreferences::setWebGL2Enabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webGL2EnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webGL2EnabledKey(), value);
}

bool WebPreferences::webGL2Enabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webGL2EnabledKey());
}

void WebPreferences::deleteWebGL2Enabled()
{
    deleteKey(WebPreferencesKey::webGL2EnabledKey());
}

void WebPreferences::setWebGLUsingMetal(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webGLUsingMetalKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webGLUsingMetalKey(), value);
}

bool WebPreferences::webGLUsingMetal() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webGLUsingMetalKey());
}

void WebPreferences::deleteWebGLUsingMetal()
{
    deleteKey(WebPreferencesKey::webGLUsingMetalKey());
}

void WebPreferences::setWebMParserEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webMParserEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webMParserEnabledKey(), value);
}

bool WebPreferences::webMParserEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webMParserEnabledKey());
}

void WebPreferences::deleteWebMParserEnabled()
{
    deleteKey(WebPreferencesKey::webMParserEnabledKey());
}

void WebPreferences::setWebMFormatReaderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webMFormatReaderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webMFormatReaderEnabledKey(), value);
}

bool WebPreferences::webMFormatReaderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webMFormatReaderEnabledKey());
}

void WebPreferences::deleteWebMFormatReaderEnabled()
{
    deleteKey(WebPreferencesKey::webMFormatReaderEnabledKey());
}

void WebPreferences::setWebRTCEncodedTransformEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCEncodedTransformEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCEncodedTransformEnabledKey(), value);
}

bool WebPreferences::webRTCEncodedTransformEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCEncodedTransformEnabledKey());
}

void WebPreferences::deleteWebRTCEncodedTransformEnabled()
{
    deleteKey(WebPreferencesKey::webRTCEncodedTransformEnabledKey());
}

void WebPreferences::setWebRTCH264LowLatencyEncoderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCH264LowLatencyEncoderEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCH264LowLatencyEncoderEnabledKey(), value);
}

bool WebPreferences::webRTCH264LowLatencyEncoderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCH264LowLatencyEncoderEnabledKey());
}

void WebPreferences::deleteWebRTCH264LowLatencyEncoderEnabled()
{
    deleteKey(WebPreferencesKey::webRTCH264LowLatencyEncoderEnabledKey());
}

void WebPreferences::setWebRTCH265CodecEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCH265CodecEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCH265CodecEnabledKey(), value);
}

bool WebPreferences::webRTCH265CodecEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCH265CodecEnabledKey());
}

void WebPreferences::deleteWebRTCH265CodecEnabled()
{
    deleteKey(WebPreferencesKey::webRTCH265CodecEnabledKey());
}

void WebPreferences::setWebRTCPlatformTCPSocketsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCPlatformTCPSocketsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCPlatformTCPSocketsEnabledKey(), value);
}

bool WebPreferences::webRTCPlatformTCPSocketsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCPlatformTCPSocketsEnabledKey());
}

void WebPreferences::deleteWebRTCPlatformTCPSocketsEnabled()
{
    deleteKey(WebPreferencesKey::webRTCPlatformTCPSocketsEnabledKey());
}

void WebPreferences::setWebRTCPlatformUDPSocketsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCPlatformUDPSocketsEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCPlatformUDPSocketsEnabledKey(), value);
}

bool WebPreferences::webRTCPlatformUDPSocketsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCPlatformUDPSocketsEnabledKey());
}

void WebPreferences::deleteWebRTCPlatformUDPSocketsEnabled()
{
    deleteKey(WebPreferencesKey::webRTCPlatformUDPSocketsEnabledKey());
}

void WebPreferences::setWebRTCSFrameTransformEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCSFrameTransformEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCSFrameTransformEnabledKey(), value);
}

bool WebPreferences::webRTCSFrameTransformEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCSFrameTransformEnabledKey());
}

void WebPreferences::deleteWebRTCSFrameTransformEnabled()
{
    deleteKey(WebPreferencesKey::webRTCSFrameTransformEnabledKey());
}

void WebPreferences::setWebRTCSocketsProxyingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCSocketsProxyingEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCSocketsProxyingEnabledKey(), value);
}

bool WebPreferences::webRTCSocketsProxyingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCSocketsProxyingEnabledKey());
}

void WebPreferences::deleteWebRTCSocketsProxyingEnabled()
{
    deleteKey(WebPreferencesKey::webRTCSocketsProxyingEnabledKey());
}

void WebPreferences::setWebRTCVP9Profile0CodecEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCVP9Profile0CodecEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCVP9Profile0CodecEnabledKey(), value);
}

bool WebPreferences::webRTCVP9Profile0CodecEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCVP9Profile0CodecEnabledKey());
}

void WebPreferences::deleteWebRTCVP9Profile0CodecEnabled()
{
    deleteKey(WebPreferencesKey::webRTCVP9Profile0CodecEnabledKey());
}

void WebPreferences::setWebRTCVP9Profile2CodecEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCVP9Profile2CodecEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webRTCVP9Profile2CodecEnabledKey(), value);
}

bool WebPreferences::webRTCVP9Profile2CodecEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCVP9Profile2CodecEnabledKey());
}

void WebPreferences::deleteWebRTCVP9Profile2CodecEnabled()
{
    deleteKey(WebPreferencesKey::webRTCVP9Profile2CodecEnabledKey());
}

void WebPreferences::setWebXRAugmentedRealityModuleEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webXRAugmentedRealityModuleEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webXRAugmentedRealityModuleEnabledKey(), value);
}

bool WebPreferences::webXRAugmentedRealityModuleEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webXRAugmentedRealityModuleEnabledKey());
}

void WebPreferences::deleteWebXRAugmentedRealityModuleEnabled()
{
    deleteKey(WebPreferencesKey::webXRAugmentedRealityModuleEnabledKey());
}

void WebPreferences::setWebXREnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webXREnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webXREnabledKey(), value);
}

bool WebPreferences::webXREnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webXREnabledKey());
}

void WebPreferences::deleteWebXREnabled()
{
    deleteKey(WebPreferencesKey::webXREnabledKey());
}

void WebPreferences::setWebXRGamepadsModuleEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webXRGamepadsModuleEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webXRGamepadsModuleEnabledKey(), value);
}

bool WebPreferences::webXRGamepadsModuleEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webXRGamepadsModuleEnabledKey());
}

void WebPreferences::deleteWebXRGamepadsModuleEnabled()
{
    deleteKey(WebPreferencesKey::webXRGamepadsModuleEnabledKey());
}

void WebPreferences::setWebXRHandInputModuleEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webXRHandInputModuleEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webXRHandInputModuleEnabledKey(), value);
}

bool WebPreferences::webXRHandInputModuleEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webXRHandInputModuleEnabledKey());
}

void WebPreferences::deleteWebXRHandInputModuleEnabled()
{
    deleteKey(WebPreferencesKey::webXRHandInputModuleEnabledKey());
}

void WebPreferences::setWheelEventGesturesBecomeNonBlocking(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::wheelEventGesturesBecomeNonBlockingKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::wheelEventGesturesBecomeNonBlockingKey(), value);
}

bool WebPreferences::wheelEventGesturesBecomeNonBlocking() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::wheelEventGesturesBecomeNonBlockingKey());
}

void WebPreferences::deleteWheelEventGesturesBecomeNonBlocking()
{
    deleteKey(WebPreferencesKey::wheelEventGesturesBecomeNonBlockingKey());
}

void WebPreferences::setPassiveWheelListenersAsDefaultOnDocument(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::passiveWheelListenersAsDefaultOnDocumentKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::passiveWheelListenersAsDefaultOnDocumentKey(), value);
}

bool WebPreferences::passiveWheelListenersAsDefaultOnDocument() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::passiveWheelListenersAsDefaultOnDocumentKey());
}

void WebPreferences::deletePassiveWheelListenersAsDefaultOnDocument()
{
    deleteKey(WebPreferencesKey::passiveWheelListenersAsDefaultOnDocumentKey());
}

void WebPreferences::setInertAttributeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inertAttributeEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::inertAttributeEnabledKey(), value);
}

bool WebPreferences::inertAttributeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inertAttributeEnabledKey());
}

void WebPreferences::deleteInertAttributeEnabled()
{
    deleteKey(WebPreferencesKey::inertAttributeEnabledKey());
}

void WebPreferences::setRequestIdleCallbackEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::requestIdleCallbackEnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::requestIdleCallbackEnabledKey(), value);
}

bool WebPreferences::requestIdleCallbackEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::requestIdleCallbackEnabledKey());
}

void WebPreferences::deleteRequestIdleCallbackEnabled()
{
    deleteKey(WebPreferencesKey::requestIdleCallbackEnabledKey());
}

void WebPreferences::setWebKitAdditionsFeature1Enabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webKitAdditionsFeature1EnabledKey(), value))
        return;
    updateBoolValueForExperimentalFeatureKey(WebPreferencesKey::webKitAdditionsFeature1EnabledKey(), value);
}

bool WebPreferences::webKitAdditionsFeature1Enabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webKitAdditionsFeature1EnabledKey());
}

void WebPreferences::deleteWebKitAdditionsFeature1Enabled()
{
    deleteKey(WebPreferencesKey::webKitAdditionsFeature1EnabledKey());
}


void WebPreferences::setMuteCameraOnMicrophoneInterruptionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::muteCameraOnMicrophoneInterruptionEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::muteCameraOnMicrophoneInterruptionEnabledKey(), value);
}

bool WebPreferences::muteCameraOnMicrophoneInterruptionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::muteCameraOnMicrophoneInterruptionEnabledKey());
}

void WebPreferences::deleteMuteCameraOnMicrophoneInterruptionEnabled()
{
    deleteKey(WebPreferencesKey::muteCameraOnMicrophoneInterruptionEnabledKey());
}

void WebPreferences::setAriaReflectionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::ariaReflectionEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::ariaReflectionEnabledKey(), value);
}

bool WebPreferences::ariaReflectionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::ariaReflectionEnabledKey());
}

void WebPreferences::deleteAriaReflectionEnabled()
{
    deleteKey(WebPreferencesKey::ariaReflectionEnabledKey());
}

void WebPreferences::setAcceleratedFiltersEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::acceleratedFiltersEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::acceleratedFiltersEnabledKey(), value);
}

bool WebPreferences::acceleratedFiltersEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::acceleratedFiltersEnabledKey());
}

void WebPreferences::deleteAcceleratedFiltersEnabled()
{
    deleteKey(WebPreferencesKey::acceleratedFiltersEnabledKey());
}

void WebPreferences::setCSSDisplayContentsAXSupportEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssDisplayContentsAXSupportEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::cssDisplayContentsAXSupportEnabledKey(), value);
}

bool WebPreferences::cssDisplayContentsAXSupportEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssDisplayContentsAXSupportEnabledKey());
}

void WebPreferences::deleteCSSDisplayContentsAXSupportEnabled()
{
    deleteKey(WebPreferencesKey::cssDisplayContentsAXSupportEnabledKey());
}

void WebPreferences::setAllowViewportShrinkToFitContent(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::allowViewportShrinkToFitContentKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::allowViewportShrinkToFitContentKey(), value);
}

bool WebPreferences::allowViewportShrinkToFitContent() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::allowViewportShrinkToFitContentKey());
}

void WebPreferences::deleteAllowViewportShrinkToFitContent()
{
    deleteKey(WebPreferencesKey::allowViewportShrinkToFitContentKey());
}

void WebPreferences::setApplePayRemoteUIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::applePayRemoteUIEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::applePayRemoteUIEnabledKey(), value);
}

bool WebPreferences::applePayRemoteUIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::applePayRemoteUIEnabledKey());
}

void WebPreferences::deleteApplePayRemoteUIEnabled()
{
    deleteKey(WebPreferencesKey::applePayRemoteUIEnabledKey());
}

void WebPreferences::setAsyncFrameScrollingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::asyncFrameScrollingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::asyncFrameScrollingEnabledKey(), value);
}

bool WebPreferences::asyncFrameScrollingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::asyncFrameScrollingEnabledKey());
}

void WebPreferences::deleteAsyncFrameScrollingEnabled()
{
    deleteKey(WebPreferencesKey::asyncFrameScrollingEnabledKey());
}

void WebPreferences::setAsyncOverflowScrollingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::asyncOverflowScrollingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::asyncOverflowScrollingEnabledKey(), value);
}

bool WebPreferences::asyncOverflowScrollingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::asyncOverflowScrollingEnabledKey());
}

void WebPreferences::deleteAsyncOverflowScrollingEnabled()
{
    deleteKey(WebPreferencesKey::asyncOverflowScrollingEnabledKey());
}

void WebPreferences::setUseCGDisplayListsForDOMRendering(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useCGDisplayListsForDOMRenderingKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::useCGDisplayListsForDOMRenderingKey(), value);
}

bool WebPreferences::useCGDisplayListsForDOMRendering() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useCGDisplayListsForDOMRenderingKey());
}

void WebPreferences::deleteUseCGDisplayListsForDOMRendering()
{
    deleteKey(WebPreferencesKey::useCGDisplayListsForDOMRenderingKey());
}

void WebPreferences::setReplayCGDisplayListsIntoBackingStore(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::replayCGDisplayListsIntoBackingStoreKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::replayCGDisplayListsIntoBackingStoreKey(), value);
}

bool WebPreferences::replayCGDisplayListsIntoBackingStore() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::replayCGDisplayListsIntoBackingStoreKey());
}

void WebPreferences::deleteReplayCGDisplayListsIntoBackingStore()
{
    deleteKey(WebPreferencesKey::replayCGDisplayListsIntoBackingStoreKey());
}

void WebPreferences::setCSSLogicalEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssLogicalEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::cssLogicalEnabledKey(), value);
}

bool WebPreferences::cssLogicalEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssLogicalEnabledKey());
}

void WebPreferences::deleteCSSLogicalEnabled()
{
    deleteKey(WebPreferencesKey::cssLogicalEnabledKey());
}

void WebPreferences::setCSSOMViewScrollingAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cssOMViewScrollingAPIEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::cssOMViewScrollingAPIEnabledKey(), value);
}

bool WebPreferences::cssOMViewScrollingAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cssOMViewScrollingAPIEnabledKey());
}

void WebPreferences::deleteCSSOMViewScrollingAPIEnabled()
{
    deleteKey(WebPreferencesKey::cssOMViewScrollingAPIEnabledKey());
}

void WebPreferences::setCaptureAudioInUIProcessEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::captureAudioInUIProcessEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::captureAudioInUIProcessEnabledKey(), value);
}

bool WebPreferences::captureAudioInUIProcessEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::captureAudioInUIProcessEnabledKey());
}

void WebPreferences::deleteCaptureAudioInUIProcessEnabled()
{
    deleteKey(WebPreferencesKey::captureAudioInUIProcessEnabledKey());
}

void WebPreferences::setCaptureVideoInUIProcessEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::captureVideoInUIProcessEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::captureVideoInUIProcessEnabledKey(), value);
}

bool WebPreferences::captureVideoInUIProcessEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::captureVideoInUIProcessEnabledKey());
}

void WebPreferences::deleteCaptureVideoInUIProcessEnabled()
{
    deleteKey(WebPreferencesKey::captureVideoInUIProcessEnabledKey());
}

void WebPreferences::setInputTypeColorEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inputTypeColorEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::inputTypeColorEnabledKey(), value);
}

bool WebPreferences::inputTypeColorEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inputTypeColorEnabledKey());
}

void WebPreferences::deleteInputTypeColorEnabled()
{
    deleteKey(WebPreferencesKey::inputTypeColorEnabledKey());
}

void WebPreferences::setCookieConsentAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::cookieConsentAPIEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::cookieConsentAPIEnabledKey(), value);
}

bool WebPreferences::cookieConsentAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::cookieConsentAPIEnabledKey());
}

void WebPreferences::deleteCookieConsentAPIEnabled()
{
    deleteKey(WebPreferencesKey::cookieConsentAPIEnabledKey());
}

void WebPreferences::setDOMPasteAccessRequestsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::domPasteAccessRequestsEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::domPasteAccessRequestsEnabledKey(), value);
}

bool WebPreferences::domPasteAccessRequestsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::domPasteAccessRequestsEnabledKey());
}

void WebPreferences::deleteDOMPasteAccessRequestsEnabled()
{
    deleteKey(WebPreferencesKey::domPasteAccessRequestsEnabledKey());
}

void WebPreferences::setZoomOnDoubleTapWhenRoot(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::zoomOnDoubleTapWhenRootKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::zoomOnDoubleTapWhenRootKey(), value);
}

bool WebPreferences::zoomOnDoubleTapWhenRoot() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::zoomOnDoubleTapWhenRootKey());
}

void WebPreferences::deleteZoomOnDoubleTapWhenRoot()
{
    deleteKey(WebPreferencesKey::zoomOnDoubleTapWhenRootKey());
}

void WebPreferences::setAlwaysZoomOnDoubleTap(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::alwaysZoomOnDoubleTapKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::alwaysZoomOnDoubleTapKey(), value);
}

bool WebPreferences::alwaysZoomOnDoubleTap() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::alwaysZoomOnDoubleTapKey());
}

void WebPreferences::deleteAlwaysZoomOnDoubleTap()
{
    deleteKey(WebPreferencesKey::alwaysZoomOnDoubleTapKey());
}

void WebPreferences::setDataListElementEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::dataListElementEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::dataListElementEnabledKey(), value);
}

bool WebPreferences::dataListElementEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::dataListElementEnabledKey());
}

void WebPreferences::deleteDataListElementEnabled()
{
    deleteKey(WebPreferencesKey::dataListElementEnabledKey());
}

void WebPreferences::setInputTypeDateEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inputTypeDateEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::inputTypeDateEnabledKey(), value);
}

bool WebPreferences::inputTypeDateEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inputTypeDateEnabledKey());
}

void WebPreferences::deleteInputTypeDateEnabled()
{
    deleteKey(WebPreferencesKey::inputTypeDateEnabledKey());
}

void WebPreferences::setDateTimeInputsEditableComponentsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::dateTimeInputsEditableComponentsEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::dateTimeInputsEditableComponentsEnabledKey(), value);
}

bool WebPreferences::dateTimeInputsEditableComponentsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::dateTimeInputsEditableComponentsEnabledKey());
}

void WebPreferences::deleteDateTimeInputsEditableComponentsEnabled()
{
    deleteKey(WebPreferencesKey::dateTimeInputsEditableComponentsEnabledKey());
}

void WebPreferences::setICECandidateFilteringEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::iceCandidateFilteringEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::iceCandidateFilteringEnabledKey(), value);
}

bool WebPreferences::iceCandidateFilteringEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::iceCandidateFilteringEnabledKey());
}

void WebPreferences::deleteICECandidateFilteringEnabled()
{
    deleteKey(WebPreferencesKey::iceCandidateFilteringEnabledKey());
}

void WebPreferences::setMockCaptureDevicesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mockCaptureDevicesEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::mockCaptureDevicesEnabledKey(), value);
}

bool WebPreferences::mockCaptureDevicesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mockCaptureDevicesEnabledKey());
}

void WebPreferences::deleteMockCaptureDevicesEnabled()
{
    deleteKey(WebPreferencesKey::mockCaptureDevicesEnabledKey());
}

void WebPreferences::setPdfJSViewerEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::pdfJSViewerEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::pdfJSViewerEnabledKey(), value);
}

bool WebPreferences::pdfJSViewerEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::pdfJSViewerEnabledKey());
}

void WebPreferences::deletePdfJSViewerEnabled()
{
    deleteKey(WebPreferencesKey::pdfJSViewerEnabledKey());
}

void WebPreferences::setEnterKeyHintEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::enterKeyHintEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::enterKeyHintEnabledKey(), value);
}

bool WebPreferences::enterKeyHintEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::enterKeyHintEnabledKey());
}

void WebPreferences::deleteEnterKeyHintEnabled()
{
    deleteKey(WebPreferencesKey::enterKeyHintEnabledKey());
}

void WebPreferences::setEventHandlerDrivenSmoothKeyboardScrollingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::eventHandlerDrivenSmoothKeyboardScrollingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::eventHandlerDrivenSmoothKeyboardScrollingEnabledKey(), value);
}

bool WebPreferences::eventHandlerDrivenSmoothKeyboardScrollingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::eventHandlerDrivenSmoothKeyboardScrollingEnabledKey());
}

void WebPreferences::deleteEventHandlerDrivenSmoothKeyboardScrollingEnabled()
{
    deleteKey(WebPreferencesKey::eventHandlerDrivenSmoothKeyboardScrollingEnabledKey());
}

void WebPreferences::setPreferFasterClickOverDoubleTap(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::preferFasterClickOverDoubleTapKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::preferFasterClickOverDoubleTapKey(), value);
}

bool WebPreferences::preferFasterClickOverDoubleTap() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::preferFasterClickOverDoubleTapKey());
}

void WebPreferences::deletePreferFasterClickOverDoubleTap()
{
    deleteKey(WebPreferencesKey::preferFasterClickOverDoubleTapKey());
}

void WebPreferences::setFasterClicksEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::fasterClicksEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::fasterClicksEnabledKey(), value);
}

bool WebPreferences::fasterClicksEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::fasterClicksEnabledKey());
}

void WebPreferences::deleteFasterClicksEnabled()
{
    deleteKey(WebPreferencesKey::fasterClicksEnabledKey());
}

void WebPreferences::setRestrictedHTTPResponseAccess(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::restrictedHTTPResponseAccessKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::restrictedHTTPResponseAccessKey(), value);
}

bool WebPreferences::restrictedHTTPResponseAccess() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::restrictedHTTPResponseAccessKey());
}

void WebPreferences::deleteRestrictedHTTPResponseAccess()
{
    deleteKey(WebPreferencesKey::restrictedHTTPResponseAccessKey());
}

void WebPreferences::setFrameFlatteningEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::frameFlatteningEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::frameFlatteningEnabledKey(), value);
}

bool WebPreferences::frameFlatteningEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::frameFlatteningEnabledKey());
}

void WebPreferences::deleteFrameFlatteningEnabled()
{
    deleteKey(WebPreferencesKey::frameFlatteningEnabledKey());
}

void WebPreferences::setLayoutFormattingContextEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::layoutFormattingContextEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::layoutFormattingContextEnabledKey(), value);
}

bool WebPreferences::layoutFormattingContextEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::layoutFormattingContextEnabledKey());
}

void WebPreferences::deleteLayoutFormattingContextEnabled()
{
    deleteKey(WebPreferencesKey::layoutFormattingContextEnabledKey());
}

void WebPreferences::setFullScreenEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::fullScreenEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::fullScreenEnabledKey(), value);
}

bool WebPreferences::fullScreenEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::fullScreenEnabledKey());
}

void WebPreferences::deleteFullScreenEnabled()
{
    deleteKey(WebPreferencesKey::fullScreenEnabledKey());
}

void WebPreferences::setCaptureAudioInGPUProcessEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::captureAudioInGPUProcessEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::captureAudioInGPUProcessEnabledKey(), value);
}

bool WebPreferences::captureAudioInGPUProcessEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::captureAudioInGPUProcessEnabledKey());
}

void WebPreferences::deleteCaptureAudioInGPUProcessEnabled()
{
    deleteKey(WebPreferencesKey::captureAudioInGPUProcessEnabledKey());
}

void WebPreferences::setUseGPUProcessForCanvasRenderingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useGPUProcessForCanvasRenderingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::useGPUProcessForCanvasRenderingEnabledKey(), value);
}

bool WebPreferences::useGPUProcessForCanvasRenderingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useGPUProcessForCanvasRenderingEnabledKey());
}

void WebPreferences::deleteUseGPUProcessForCanvasRenderingEnabled()
{
    deleteKey(WebPreferencesKey::useGPUProcessForCanvasRenderingEnabledKey());
}

void WebPreferences::setUseGPUProcessForMediaEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useGPUProcessForMediaEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::useGPUProcessForMediaEnabledKey(), value);
}

bool WebPreferences::useGPUProcessForMediaEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useGPUProcessForMediaEnabledKey());
}

void WebPreferences::deleteUseGPUProcessForMediaEnabled()
{
    deleteKey(WebPreferencesKey::useGPUProcessForMediaEnabledKey());
}

void WebPreferences::setCaptureVideoInGPUProcessEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::captureVideoInGPUProcessEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::captureVideoInGPUProcessEnabledKey(), value);
}

bool WebPreferences::captureVideoInGPUProcessEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::captureVideoInGPUProcessEnabledKey());
}

void WebPreferences::deleteCaptureVideoInGPUProcessEnabled()
{
    deleteKey(WebPreferencesKey::captureVideoInGPUProcessEnabledKey());
}

void WebPreferences::setWebRTCPlatformCodecsInGPUProcessEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCPlatformCodecsInGPUProcessEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::webRTCPlatformCodecsInGPUProcessEnabledKey(), value);
}

bool WebPreferences::webRTCPlatformCodecsInGPUProcessEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCPlatformCodecsInGPUProcessEnabledKey());
}

void WebPreferences::deleteWebRTCPlatformCodecsInGPUProcessEnabled()
{
    deleteKey(WebPreferencesKey::webRTCPlatformCodecsInGPUProcessEnabledKey());
}

void WebPreferences::setIPCTestingAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::ipcTestingAPIEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::ipcTestingAPIEnabledKey(), value);
}

bool WebPreferences::ipcTestingAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::ipcTestingAPIEnabledKey());
}

void WebPreferences::deleteIPCTestingAPIEnabled()
{
    deleteKey(WebPreferencesKey::ipcTestingAPIEnabledKey());
}

void WebPreferences::setTextAutosizingUsesIdempotentMode(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::textAutosizingUsesIdempotentModeKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::textAutosizingUsesIdempotentModeKey(), value);
}

bool WebPreferences::textAutosizingUsesIdempotentMode() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::textAutosizingUsesIdempotentModeKey());
}

void WebPreferences::deleteTextAutosizingUsesIdempotentMode()
{
    deleteKey(WebPreferencesKey::textAutosizingUsesIdempotentModeKey());
}

void WebPreferences::setImageAnalysisMarkupEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::imageAnalysisMarkupEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::imageAnalysisMarkupEnabledKey(), value);
}

bool WebPreferences::imageAnalysisMarkupEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::imageAnalysisMarkupEnabledKey());
}

void WebPreferences::deleteImageAnalysisMarkupEnabled()
{
    deleteKey(WebPreferencesKey::imageAnalysisMarkupEnabledKey());
}

void WebPreferences::setImageAnalysisQueueEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::imageAnalysisQueueEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::imageAnalysisQueueEnabledKey(), value);
}

bool WebPreferences::imageAnalysisQueueEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::imageAnalysisQueueEnabledKey());
}

void WebPreferences::deleteImageAnalysisQueueEnabled()
{
    deleteKey(WebPreferencesKey::imageAnalysisQueueEnabledKey());
}

void WebPreferences::setPreferInlineTextSelectionInImages(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::preferInlineTextSelectionInImagesKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::preferInlineTextSelectionInImagesKey(), value);
}

bool WebPreferences::preferInlineTextSelectionInImages() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::preferInlineTextSelectionInImagesKey());
}

void WebPreferences::deletePreferInlineTextSelectionInImages()
{
    deleteKey(WebPreferencesKey::preferInlineTextSelectionInImagesKey());
}

void WebPreferences::setLayerBasedSVGEngineEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::layerBasedSVGEngineEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::layerBasedSVGEngineEnabledKey(), value);
}

bool WebPreferences::layerBasedSVGEngineEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::layerBasedSVGEngineEnabledKey());
}

void WebPreferences::deleteLayerBasedSVGEngineEnabled()
{
    deleteKey(WebPreferencesKey::layerBasedSVGEngineEnabledKey());
}

void WebPreferences::setLegacyOverflowScrollingTouchEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::legacyOverflowScrollingTouchEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::legacyOverflowScrollingTouchEnabledKey(), value);
}

bool WebPreferences::legacyOverflowScrollingTouchEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::legacyOverflowScrollingTouchEnabledKey());
}

void WebPreferences::deleteLegacyOverflowScrollingTouchEnabled()
{
    deleteKey(WebPreferencesKey::legacyOverflowScrollingTouchEnabledKey());
}

void WebPreferences::setMediaCaptureRequiresSecureConnection(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mediaCaptureRequiresSecureConnectionKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::mediaCaptureRequiresSecureConnectionKey(), value);
}

bool WebPreferences::mediaCaptureRequiresSecureConnection() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mediaCaptureRequiresSecureConnectionKey());
}

void WebPreferences::deleteMediaCaptureRequiresSecureConnection()
{
    deleteKey(WebPreferencesKey::mediaCaptureRequiresSecureConnectionKey());
}

void WebPreferences::setLiveRangeSelectionEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::liveRangeSelectionEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::liveRangeSelectionEnabledKey(), value);
}

bool WebPreferences::liveRangeSelectionEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::liveRangeSelectionEnabledKey());
}

void WebPreferences::deleteLiveRangeSelectionEnabled()
{
    deleteKey(WebPreferencesKey::liveRangeSelectionEnabledKey());
}

void WebPreferences::setMomentumScrollingAnimatorEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::momentumScrollingAnimatorEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::momentumScrollingAnimatorEnabledKey(), value);
}

bool WebPreferences::momentumScrollingAnimatorEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::momentumScrollingAnimatorEnabledKey());
}

void WebPreferences::deleteMomentumScrollingAnimatorEnabled()
{
    deleteKey(WebPreferencesKey::momentumScrollingAnimatorEnabledKey());
}

void WebPreferences::setInputTypeMonthEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inputTypeMonthEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::inputTypeMonthEnabledKey(), value);
}

bool WebPreferences::inputTypeMonthEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inputTypeMonthEnabledKey());
}

void WebPreferences::deleteInputTypeMonthEnabled()
{
    deleteKey(WebPreferencesKey::inputTypeMonthEnabledKey());
}

void WebPreferences::setMouseEventsSimulationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::mouseEventsSimulationEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::mouseEventsSimulationEnabledKey(), value);
}

bool WebPreferences::mouseEventsSimulationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::mouseEventsSimulationEnabledKey());
}

void WebPreferences::deleteMouseEventsSimulationEnabled()
{
    deleteKey(WebPreferencesKey::mouseEventsSimulationEnabledKey());
}

void WebPreferences::setLayoutFormattingContextIntegrationEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::layoutFormattingContextIntegrationEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::layoutFormattingContextIntegrationEnabledKey(), value);
}

bool WebPreferences::layoutFormattingContextIntegrationEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::layoutFormattingContextIntegrationEnabledKey());
}

void WebPreferences::deleteLayoutFormattingContextIntegrationEnabled()
{
    deleteKey(WebPreferencesKey::layoutFormattingContextIntegrationEnabledKey());
}

void WebPreferences::setNotificationEventEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::notificationEventEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::notificationEventEnabledKey(), value);
}

bool WebPreferences::notificationEventEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::notificationEventEnabledKey());
}

void WebPreferences::deleteNotificationEventEnabled()
{
    deleteKey(WebPreferencesKey::notificationEventEnabledKey());
}

void WebPreferences::setOffscreenCanvasInWorkersEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::offscreenCanvasInWorkersEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::offscreenCanvasInWorkersEnabledKey(), value);
}

bool WebPreferences::offscreenCanvasInWorkersEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::offscreenCanvasInWorkersEnabledKey());
}

void WebPreferences::deleteOffscreenCanvasInWorkersEnabled()
{
    deleteKey(WebPreferencesKey::offscreenCanvasInWorkersEnabledKey());
}

void WebPreferences::setOffscreenCanvasEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::offscreenCanvasEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::offscreenCanvasEnabledKey(), value);
}

bool WebPreferences::offscreenCanvasEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::offscreenCanvasEnabledKey());
}

void WebPreferences::deleteOffscreenCanvasEnabled()
{
    deleteKey(WebPreferencesKey::offscreenCanvasEnabledKey());
}

void WebPreferences::setSpeakerSelectionRequiresUserGesture(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::speakerSelectionRequiresUserGestureKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::speakerSelectionRequiresUserGestureKey(), value);
}

bool WebPreferences::speakerSelectionRequiresUserGesture() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::speakerSelectionRequiresUserGestureKey());
}

void WebPreferences::deleteSpeakerSelectionRequiresUserGesture()
{
    deleteKey(WebPreferencesKey::speakerSelectionRequiresUserGestureKey());
}

void WebPreferences::setGetUserMediaRequiresFocus(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::getUserMediaRequiresFocusKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::getUserMediaRequiresFocusKey(), value);
}

bool WebPreferences::getUserMediaRequiresFocus() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::getUserMediaRequiresFocusKey());
}

void WebPreferences::deleteGetUserMediaRequiresFocus()
{
    deleteKey(WebPreferencesKey::getUserMediaRequiresFocusKey());
}

void WebPreferences::setResourceLoadSchedulingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::resourceLoadSchedulingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::resourceLoadSchedulingEnabledKey(), value);
}

bool WebPreferences::resourceLoadSchedulingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::resourceLoadSchedulingEnabledKey());
}

void WebPreferences::deleteResourceLoadSchedulingEnabled()
{
    deleteKey(WebPreferencesKey::resourceLoadSchedulingEnabledKey());
}

void WebPreferences::setScrollingPerformanceTestingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::scrollingPerformanceTestingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::scrollingPerformanceTestingEnabledKey(), value);
}

bool WebPreferences::scrollingPerformanceTestingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::scrollingPerformanceTestingEnabledKey());
}

void WebPreferences::deleteScrollingPerformanceTestingEnabled()
{
    deleteKey(WebPreferencesKey::scrollingPerformanceTestingEnabledKey());
}

void WebPreferences::setSecureContextChecksEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::secureContextChecksEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::secureContextChecksEnabledKey(), value);
}

bool WebPreferences::secureContextChecksEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::secureContextChecksEnabledKey());
}

void WebPreferences::deleteSecureContextChecksEnabled()
{
    deleteKey(WebPreferencesKey::secureContextChecksEnabledKey());
}

void WebPreferences::setSelectionFlippingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::selectionFlippingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::selectionFlippingEnabledKey(), value);
}

bool WebPreferences::selectionFlippingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::selectionFlippingEnabledKey());
}

void WebPreferences::deleteSelectionFlippingEnabled()
{
    deleteKey(WebPreferencesKey::selectionFlippingEnabledKey());
}

void WebPreferences::setServiceWorkersEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::serviceWorkersEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::serviceWorkersEnabledKey(), value);
}

bool WebPreferences::serviceWorkersEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::serviceWorkersEnabledKey());
}

void WebPreferences::deleteServiceWorkersEnabled()
{
    deleteKey(WebPreferencesKey::serviceWorkersEnabledKey());
}

void WebPreferences::setSimpleLineLayoutEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::simpleLineLayoutEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::simpleLineLayoutEnabledKey(), value);
}

bool WebPreferences::simpleLineLayoutEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::simpleLineLayoutEnabledKey());
}

void WebPreferences::deleteSimpleLineLayoutEnabled()
{
    deleteKey(WebPreferencesKey::simpleLineLayoutEnabledKey());
}

void WebPreferences::setTextRecognitionEnhancementsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::textRecognitionEnhancementsEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::textRecognitionEnhancementsEnabledKey(), value);
}

bool WebPreferences::textRecognitionEnhancementsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::textRecognitionEnhancementsEnabledKey());
}

void WebPreferences::deleteTextRecognitionEnhancementsEnabled()
{
    deleteKey(WebPreferencesKey::textRecognitionEnhancementsEnabledKey());
}

void WebPreferences::setInputTypeTimeEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inputTypeTimeEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::inputTypeTimeEnabledKey(), value);
}

bool WebPreferences::inputTypeTimeEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inputTypeTimeEnabledKey());
}

void WebPreferences::deleteInputTypeTimeEnabled()
{
    deleteKey(WebPreferencesKey::inputTypeTimeEnabledKey());
}

void WebPreferences::setUndoManagerAPIEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::undoManagerAPIEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::undoManagerAPIEnabledKey(), value);
}

bool WebPreferences::undoManagerAPIEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::undoManagerAPIEnabledKey());
}

void WebPreferences::deleteUndoManagerAPIEnabled()
{
    deleteKey(WebPreferencesKey::undoManagerAPIEnabledKey());
}

void WebPreferences::setUpgradeKnownHostsToHTTPSEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::upgradeKnownHostsToHTTPSEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::upgradeKnownHostsToHTTPSEnabledKey(), value);
}

bool WebPreferences::upgradeKnownHostsToHTTPSEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::upgradeKnownHostsToHTTPSEnabledKey());
}

void WebPreferences::deleteUpgradeKnownHostsToHTTPSEnabled()
{
    deleteKey(WebPreferencesKey::upgradeKnownHostsToHTTPSEnabledKey());
}

void WebPreferences::setUseARKitForModel(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useARKitForModelKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::useARKitForModelKey(), value);
}

bool WebPreferences::useARKitForModel() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useARKitForModelKey());
}

void WebPreferences::deleteUseARKitForModel()
{
    deleteKey(WebPreferencesKey::useARKitForModelKey());
}

void WebPreferences::setUseSceneKitForModel(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useSceneKitForModelKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::useSceneKitForModelKey(), value);
}

bool WebPreferences::useSceneKitForModel() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useSceneKitForModelKey());
}

void WebPreferences::deleteUseSceneKitForModel()
{
    deleteKey(WebPreferencesKey::useSceneKitForModelKey());
}

void WebPreferences::setUseiTunesAVOutputContext(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::useiTunesAVOutputContextKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::useiTunesAVOutputContextKey(), value);
}

bool WebPreferences::useiTunesAVOutputContext() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::useiTunesAVOutputContextKey());
}

void WebPreferences::deleteUseiTunesAVOutputContext()
{
    deleteKey(WebPreferencesKey::useiTunesAVOutputContextKey());
}

void WebPreferences::setWebAPIStatisticsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webAPIStatisticsEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::webAPIStatisticsEnabledKey(), value);
}

bool WebPreferences::webAPIStatisticsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webAPIStatisticsEnabledKey());
}

void WebPreferences::deleteWebAPIStatisticsEnabled()
{
    deleteKey(WebPreferencesKey::webAPIStatisticsEnabledKey());
}

void WebPreferences::setWebRTCDTMFEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCDTMFEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::webRTCDTMFEnabledKey(), value);
}

bool WebPreferences::webRTCDTMFEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCDTMFEnabledKey());
}

void WebPreferences::deleteWebRTCDTMFEnabled()
{
    deleteKey(WebPreferencesKey::webRTCDTMFEnabledKey());
}

void WebPreferences::setWebRTCH264HardwareEncoderEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCH264HardwareEncoderEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::webRTCH264HardwareEncoderEnabledKey(), value);
}

bool WebPreferences::webRTCH264HardwareEncoderEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCH264HardwareEncoderEnabledKey());
}

void WebPreferences::deleteWebRTCH264HardwareEncoderEnabled()
{
    deleteKey(WebPreferencesKey::webRTCH264HardwareEncoderEnabledKey());
}

void WebPreferences::setWebRTCH264SimulcastEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCH264SimulcastEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::webRTCH264SimulcastEnabledKey(), value);
}

bool WebPreferences::webRTCH264SimulcastEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCH264SimulcastEnabledKey());
}

void WebPreferences::deleteWebRTCH264SimulcastEnabled()
{
    deleteKey(WebPreferencesKey::webRTCH264SimulcastEnabledKey());
}

void WebPreferences::setWebRTCRemoteVideoFrameEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCRemoteVideoFrameEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::webRTCRemoteVideoFrameEnabledKey(), value);
}

bool WebPreferences::webRTCRemoteVideoFrameEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCRemoteVideoFrameEnabledKey());
}

void WebPreferences::deleteWebRTCRemoteVideoFrameEnabled()
{
    deleteKey(WebPreferencesKey::webRTCRemoteVideoFrameEnabledKey());
}

void WebPreferences::setWebRTCMDNSICECandidatesEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::webRTCMDNSICECandidatesEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::webRTCMDNSICECandidatesEnabledKey(), value);
}

bool WebPreferences::webRTCMDNSICECandidatesEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::webRTCMDNSICECandidatesEnabledKey());
}

void WebPreferences::deleteWebRTCMDNSICECandidatesEnabled()
{
    deleteKey(WebPreferencesKey::webRTCMDNSICECandidatesEnabledKey());
}

void WebPreferences::setInputTypeWeekEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inputTypeWeekEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::inputTypeWeekEnabledKey(), value);
}

bool WebPreferences::inputTypeWeekEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inputTypeWeekEnabledKey());
}

void WebPreferences::deleteInputTypeWeekEnabled()
{
    deleteKey(WebPreferencesKey::inputTypeWeekEnabledKey());
}

void WebPreferences::setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabledKey(), value);
}

bool WebPreferences::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabledKey());
}

void WebPreferences::deleteIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled()
{
    deleteKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabledKey());
}

void WebPreferences::setIsFirstPartyWebsiteDataRemovalReproTestingEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalReproTestingEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalReproTestingEnabledKey(), value);
}

bool WebPreferences::isFirstPartyWebsiteDataRemovalReproTestingEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalReproTestingEnabledKey());
}

void WebPreferences::deleteIsFirstPartyWebsiteDataRemovalReproTestingEnabled()
{
    deleteKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalReproTestingEnabledKey());
}

void WebPreferences::setInputTypeDateTimeLocalEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::inputTypeDateTimeLocalEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::inputTypeDateTimeLocalEnabledKey(), value);
}

bool WebPreferences::inputTypeDateTimeLocalEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::inputTypeDateTimeLocalEnabledKey());
}

void WebPreferences::deleteInputTypeDateTimeLocalEnabled()
{
    deleteKey(WebPreferencesKey::inputTypeDateTimeLocalEnabledKey());
}

void WebPreferences::setIOSFormControlRefreshEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::iOSFormControlRefreshEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::iOSFormControlRefreshEnabledKey(), value);
}

bool WebPreferences::iOSFormControlRefreshEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::iOSFormControlRefreshEnabledKey());
}

void WebPreferences::deleteIOSFormControlRefreshEnabled()
{
    deleteKey(WebPreferencesKey::iOSFormControlRefreshEnabledKey());
}

void WebPreferences::setLineHeightUnitsEnabled(const bool& value)
{
    if (!m_store.setBoolValueForKey(WebPreferencesKey::lineHeightUnitsEnabledKey(), value))
        return;
    updateBoolValueForInternalDebugFeatureKey(WebPreferencesKey::lineHeightUnitsEnabledKey(), value);
}

bool WebPreferences::lineHeightUnitsEnabled() const
{
    return m_store.getBoolValueForKey(WebPreferencesKey::lineHeightUnitsEnabledKey());
}

void WebPreferences::deleteLineHeightUnitsEnabled()
{
    deleteKey(WebPreferencesKey::lineHeightUnitsEnabledKey());
}


}
