/* KeyboardLayoutApplet.c generated by valac 0.56.3, the Vala compiler
 * generated from KeyboardLayoutApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "keyboardlayoutapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <ibus.h>
#include <gio/gio.h>
#include <libgnome-desktop/gnome-bg-crossfade.h>
#include <libgnome-desktop/gnome-bg-slide-show.h>
#include <libgnome-desktop/gnome-bg.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <libgnome-desktop/gnome-idle-monitor.h>
#include <libgnome-desktop/gnome-languages.h>
#include <libgnome-desktop/gnome-pnp-ids.h>
#include <libgnome-desktop/gnome-rr-config.h>
#include <libgnome-desktop/gnome-rr.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gobject/gvaluecollector.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libpeas/peas.h>

enum  {
	KEYBOARD_LAYOUT_PLUGIN_0_PROPERTY,
	KEYBOARD_LAYOUT_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* keyboard_layout_plugin_properties[KEYBOARD_LAYOUT_PLUGIN_NUM_PROPERTIES];

#define TYPE_INPUT_METHOD_ERROR (input_method_error_get_type ())

#define TYPE_APPLET_IBUS_MANAGER (applet_ibus_manager_get_type ())
#define APPLET_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLET_IBUS_MANAGER, AppletIBusManager))
#define APPLET_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLET_IBUS_MANAGER, AppletIBusManagerClass))
#define IS_APPLET_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLET_IBUS_MANAGER))
#define IS_APPLET_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLET_IBUS_MANAGER))
#define APPLET_IBUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLET_IBUS_MANAGER, AppletIBusManagerClass))

typedef struct _AppletIBusManager AppletIBusManager;
typedef struct _AppletIBusManagerClass AppletIBusManagerClass;
typedef struct _AppletIBusManagerPrivate AppletIBusManagerPrivate;
enum  {
	APPLET_IBUS_MANAGER_0_PROPERTY,
	APPLET_IBUS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* applet_ibus_manager_properties[APPLET_IBUS_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	APPLET_IBUS_MANAGER_READY_SIGNAL,
	APPLET_IBUS_MANAGER_NUM_SIGNALS
};
static guint applet_ibus_manager_signals[APPLET_IBUS_MANAGER_NUM_SIGNALS] = {0};

#define TYPE_INPUT_SOURCE (input_source_get_type ())
#define INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_SOURCE, InputSource))
#define INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_SOURCE, InputSourceClass))
#define IS_INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_SOURCE))
#define IS_INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_SOURCE))
#define INPUT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_SOURCE, InputSourceClass))

typedef struct _InputSource InputSource;
typedef struct _InputSourceClass InputSourceClass;
typedef struct _InputSourcePrivate InputSourcePrivate;
#define _input_source_unref0(var) ((var == NULL) ? NULL : (var = (input_source_unref (var), NULL)))
typedef struct _ParamSpecInputSource ParamSpecInputSource;

#define TYPE_INPUT_SOURCE_MENU_ITEM (input_source_menu_item_get_type ())
#define INPUT_SOURCE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItem))
#define INPUT_SOURCE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItemClass))
#define IS_INPUT_SOURCE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_SOURCE_MENU_ITEM))
#define IS_INPUT_SOURCE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_SOURCE_MENU_ITEM))
#define INPUT_SOURCE_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItemClass))

typedef struct _InputSourceMenuItem InputSourceMenuItem;
typedef struct _InputSourceMenuItemClass InputSourceMenuItemClass;
typedef struct _InputSourceMenuItemPrivate InputSourceMenuItemPrivate;
enum  {
	INPUT_SOURCE_MENU_ITEM_0_PROPERTY,
	INPUT_SOURCE_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* input_source_menu_item_properties[INPUT_SOURCE_MENU_ITEM_NUM_PROPERTIES];
enum  {
	KEYBOARD_LAYOUT_APPLET_0_PROPERTY,
	KEYBOARD_LAYOUT_APPLET_NUM_PROPERTIES
};
static GParamSpec* keyboard_layout_applet_properties[KEYBOARD_LAYOUT_APPLET_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

typedef enum  {
	INPUT_METHOD_ERROR_UNKNOWN_IME
} InputMethodError;
#define INPUT_METHOD_ERROR input_method_error_quark ()

struct _AppletIBusManager {
	GObject parent_instance;
	AppletIBusManagerPrivate * priv;
};

struct _AppletIBusManagerClass {
	GObjectClass parent_class;
};

struct _AppletIBusManagerPrivate {
	GHashTable* engines;
	GList* enginelist;
	gboolean did_ibus_init;
	gboolean ibus_available;
	IBusBus* bus;
};

struct _InputSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	InputSourcePrivate * priv;
	gboolean xkb;
	gchar* layout;
	gchar* variant;
	gchar* description;
	guint idx;
	gchar* ibus_engine;
};

struct _InputSourceClass {
	GTypeClass parent_class;
	void (*finalize) (InputSource *self);
};

struct _ParamSpecInputSource {
	GParamSpec parent_instance;
};

struct _InputSourceMenuItem {
	GtkButton parent_instance;
	InputSourceMenuItemPrivate * priv;
	guint idx;
};

struct _InputSourceMenuItemClass {
	GtkButtonClass parent_class;
};

struct _InputSourceMenuItemPrivate {
	GtkLabel* tick_label;
};

struct _KeyboardLayoutAppletPrivate {
	GtkEventBox* widget;
	GtkEventBox* img_wrap;
	GtkBox* layout;
	GtkImage* img;
	GSettings* settings;
	GArray* sources;
	InputSource* fallback;
	GnomeXkbInfo* xkb;
	GtkStack* label_stack;
	BudgiePopover* popover;
	GtkListBox* listbox;
	BudgiePopoverManager* manager;
	AppletIBusManager* ibus_manager;
};

static gpointer keyboard_layout_plugin_parent_class = NULL;
static BudgiePluginIface * keyboard_layout_plugin_budgie_plugin_parent_iface = NULL;
static GType keyboard_layout_plugin_type_id = 0;
static gint AppletIBusManager_private_offset;
static gpointer applet_ibus_manager_parent_class = NULL;
static GType applet_ibus_manager_type_id = 0;
static gpointer input_source_parent_class = NULL;
static GType input_source_type_id = 0;
static gint InputSourceMenuItem_private_offset;
static gpointer input_source_menu_item_parent_class = NULL;
static GType input_source_menu_item_type_id = 0;
static gint KeyboardLayoutApplet_private_offset;
static gpointer keyboard_layout_applet_parent_class = NULL;
static GType keyboard_layout_applet_type_id = 0;

static BudgieApplet* keyboard_layout_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                            const gchar* uuid);
VALA_EXTERN GQuark input_method_error_quark (void);
GType input_method_error_get_type (void) G_GNUC_CONST ;
GType applet_ibus_manager_register_type (GTypeModule * module);
VALA_EXTERN GType applet_ibus_manager_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN AppletIBusManager* applet_ibus_manager_new (void);
VALA_EXTERN AppletIBusManager* applet_ibus_manager_construct (GType object_type);
static void applet_ibus_manager_reset_ibus (AppletIBusManager* self);
VALA_EXTERN void applet_ibus_manager_do_init (AppletIBusManager* self);
static void _g_free0_ (gpointer var);
static void applet_ibus_manager_ibus_connected (AppletIBusManager* self);
static void _applet_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender,
                                                             gpointer self);
static void applet_ibus_manager_ibus_disconnected (AppletIBusManager* self);
static void _applet_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender,
                                                                   gpointer self);
static void applet_ibus_manager_on_engines_get (AppletIBusManager* self,
                                         GObject* o,
                                         GAsyncResult* res);
static void _applet_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object,
                                                                GAsyncResult* res,
                                                                gpointer self);
VALA_EXTERN IBusEngineDesc* applet_ibus_manager_get_engine (AppletIBusManager* self,
                                                const gchar* name);
static void applet_ibus_manager_finalize (GObject * obj);
VALA_EXTERN gpointer input_source_ref (gpointer instance);
VALA_EXTERN void input_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_input_source (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_input_source (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_input_source (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_input_source (const GValue* value);
GType input_source_register_type (GTypeModule * module);
VALA_EXTERN GType input_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN InputSource* input_source_new (AppletIBusManager* iman,
                               const gchar* id,
                               guint idx,
                               const gchar* layout,
                               const gchar* variant,
                               const gchar* description,
                               gboolean xkb,
                               GError** error);
VALA_EXTERN InputSource* input_source_construct (GType object_type,
                                     AppletIBusManager* iman,
                                     const gchar* id,
                                     guint idx,
                                     const gchar* layout,
                                     const gchar* variant,
                                     const gchar* description,
                                     gboolean xkb,
                                     GError** error);
static void input_source_finalize (InputSource * obj);
GType input_source_menu_item_register_type (GTypeModule * module);
VALA_EXTERN GType input_source_menu_item_get_type (void) G_GNUC_CONST ;
VALA_EXTERN InputSourceMenuItem* input_source_menu_item_new (const gchar* description,
                                                 guint idx);
VALA_EXTERN InputSourceMenuItem* input_source_menu_item_construct (GType object_type,
                                                       const gchar* description,
                                                       guint idx);
VALA_EXTERN void input_source_menu_item_set_ticked (InputSourceMenuItem* self,
                                        gboolean ticked);
static void input_source_menu_item_finalize (GObject * obj);
static gboolean __lambda4_ (KeyboardLayoutApplet* self,
                     GdkEventButton* e);
static gboolean ___lambda4__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void keyboard_layout_applet_update_fallback (KeyboardLayoutApplet* self);
static void keyboard_layout_applet_on_ibus_ready (KeyboardLayoutApplet* self);
static void _keyboard_layout_applet_on_ibus_ready_applet_ibus_manager_ready (AppletIBusManager* _sender,
                                                                      gpointer self);
static void keyboard_layout_applet_real_panel_position_changed (BudgieApplet* base,
                                                         BudgiePanelPosition position);
static void keyboard_layout_applet_on_settings_changed (KeyboardLayoutApplet* self,
                                                 const gchar* key);
static void _keyboard_layout_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
static void keyboard_layout_applet_on_row_activate (KeyboardLayoutApplet* self,
                                             GtkButton* item);
static void keyboard_layout_applet_reset_keyboards (KeyboardLayoutApplet* self);
static void _keyboard_layout_applet_on_row_activate_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void keyboard_layout_applet_update_sources (KeyboardLayoutApplet* self);
static void keyboard_layout_applet_update_current (KeyboardLayoutApplet* self);
static void _input_source_unref0_ (gpointer var);
static void _vala_InputSource_free_function_content_of (gpointer data);
static gchar* keyboard_layout_applet_get_xkb_description (KeyboardLayoutApplet* self,
                                                   const gchar* id);
static void keyboard_layout_applet_real_update_popovers (BudgieApplet* base,
                                                  BudgiePopoverManager* manager);
static void keyboard_layout_applet_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static BudgieApplet*
keyboard_layout_plugin_real_get_panel_widget (BudgiePlugin* base,
                                              const gchar* uuid)
{
	KeyboardLayoutPlugin * self;
	KeyboardLayoutApplet* _tmp0_;
	BudgieApplet* result;
	self = (KeyboardLayoutPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = keyboard_layout_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

KeyboardLayoutPlugin*
keyboard_layout_plugin_construct (GType object_type)
{
	KeyboardLayoutPlugin * self = NULL;
	self = (KeyboardLayoutPlugin*) g_object_new (object_type, NULL);
	return self;
}

KeyboardLayoutPlugin*
keyboard_layout_plugin_new (void)
{
	return keyboard_layout_plugin_construct (TYPE_KEYBOARD_LAYOUT_PLUGIN);
}

static void
keyboard_layout_plugin_class_init (KeyboardLayoutPluginClass * klass,
                                   gpointer klass_data)
{
	keyboard_layout_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
keyboard_layout_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                     gpointer iface_data)
{
	keyboard_layout_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) keyboard_layout_plugin_real_get_panel_widget;
}

static void
keyboard_layout_plugin_instance_init (KeyboardLayoutPlugin * self,
                                      gpointer klass)
{
}

GType
keyboard_layout_plugin_get_type (void)
{
	return keyboard_layout_plugin_type_id;
}

GType
keyboard_layout_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardLayoutPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_layout_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardLayoutPlugin), 0, (GInstanceInitFunc) keyboard_layout_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) keyboard_layout_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	keyboard_layout_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "KeyboardLayoutPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, keyboard_layout_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return keyboard_layout_plugin_type_id;
}

GQuark
input_method_error_quark (void)
{
	return g_quark_from_static_string ("input-method-error-quark");
}

static GType
input_method_error_get_type_once (void)
{
	static const GEnumValue values[] = {{INPUT_METHOD_ERROR_UNKNOWN_IME, "INPUT_METHOD_ERROR_UNKNOWN_IME", "unknown-ime"}, {0, NULL, NULL}};
	GType input_method_error_type_id;
	input_method_error_type_id = g_enum_register_static ("InputMethodError", values);
	return input_method_error_type_id;
}

GType
input_method_error_get_type (void)
{
	static volatile gsize input_method_error_type_id__once = 0;
	if (g_once_init_enter (&input_method_error_type_id__once)) {
		GType input_method_error_type_id;
		input_method_error_type_id = input_method_error_get_type_once ();
		g_once_init_leave (&input_method_error_type_id__once, input_method_error_type_id);
	}
	return input_method_error_type_id__once;
}

static inline gpointer
applet_ibus_manager_get_instance_private (AppletIBusManager* self)
{
	return G_STRUCT_MEMBER_P (self, AppletIBusManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

AppletIBusManager*
applet_ibus_manager_construct (GType object_type)
{
	AppletIBusManager * self = NULL;
	self = (AppletIBusManager*) g_object_new (object_type, NULL);
	applet_ibus_manager_reset_ibus (self);
	return self;
}

AppletIBusManager*
applet_ibus_manager_new (void)
{
	return applet_ibus_manager_construct (TYPE_APPLET_IBUS_MANAGER);
}

/**
 * Run init separately so that the owner can connect to the ready() signal
 */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_applet_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender,
                                                        gpointer self)
{
	applet_ibus_manager_ibus_connected ((AppletIBusManager*) self);
}

static void
_applet_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender,
                                                              gpointer self)
{
	applet_ibus_manager_ibus_disconnected ((AppletIBusManager*) self);
}

void
applet_ibus_manager_do_init (AppletIBusManager* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	IBusBus* _tmp6_;
	IBusBus* _tmp7_;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	IBusBus* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp2_;
	_tmp3_ = g_find_program_in_path ("ibus-daemon");
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		g_message ("KeyboardLayoutApplet.vala:48: ibus-daemon unsupported on this system");
		self->priv->ibus_available = FALSE;
		g_signal_emit (self, applet_ibus_manager_signals[APPLET_IBUS_MANAGER_READY_SIGNAL], 0);
		return;
	}
	_tmp6_ = ibus_bus_new_async ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp6_;
	_tmp7_ = self->priv->bus;
	g_signal_connect_object (_tmp7_, "connected", (GCallback) _applet_ibus_manager_ibus_connected_ibus_bus_connected, self, 0);
	_tmp8_ = self->priv->bus;
	g_signal_connect_object (_tmp8_, "disconnected", (GCallback) _applet_ibus_manager_ibus_disconnected_ibus_bus_disconnected, self, 0);
	_tmp9_ = self->priv->bus;
	ibus_bus_set_watch_dbus_signal (_tmp9_, TRUE);
	_tmp10_ = self->priv->bus;
	if (ibus_bus_is_connected (_tmp10_)) {
		applet_ibus_manager_ibus_connected (self);
	}
}

/**
 * Something on ibus changed so we'll reset our state
 */
static void
applet_ibus_manager_reset_ibus (AppletIBusManager* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp2_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
applet_ibus_manager_on_engines_get (AppletIBusManager* self,
                                    GObject* o,
                                    GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* _tmp0_ = NULL;
		IBusBus* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp1_ = self->priv->bus;
		_tmp2_ = ibus_bus_list_engines_async_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		(self->priv->enginelist == NULL) ? NULL : (self->priv->enginelist = (_g_list_free__g_object_unref0_ (self->priv->enginelist), NULL));
		self->priv->enginelist = _tmp3_;
		applet_ibus_manager_reset_ibus (self);
		_tmp4_ = self->priv->enginelist;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp4_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* _tmp5_;
				IBusEngineDesc* engine = NULL;
				_tmp5_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
				engine = _tmp5_;
				{
					GHashTable* _tmp6_;
					IBusEngineDesc* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					IBusEngineDesc* _tmp10_;
					_tmp6_ = self->priv->engines;
					_tmp7_ = engine;
					_tmp8_ = ibus_engine_desc_get_name (_tmp7_);
					_tmp9_ = g_strdup (_tmp8_);
					_tmp10_ = engine;
					g_hash_table_insert (_tmp6_, _tmp9_, _tmp10_);
					_g_object_unref0 (engine);
				}
			}
		}
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (_g_list_free__g_object_unref0_ (_tmp0_), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_message ("KeyboardLayoutApplet.vala:86: Failed to get engines: %s", _tmp12_);
		applet_ibus_manager_reset_ibus (self);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit (self, applet_ibus_manager_signals[APPLET_IBUS_MANAGER_READY_SIGNAL], 0);
}

/**
 * We gained connection to the ibus daemon
 */
static void
_applet_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object,
                                                           GAsyncResult* res,
                                                           gpointer self)
{
	applet_ibus_manager_on_engines_get ((AppletIBusManager*) self, source_object, res);
	g_object_unref (self);
}

static void
applet_ibus_manager_ibus_connected (AppletIBusManager* self)
{
	IBusBus* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->did_ibus_init) {
		ibus_init ();
		self->priv->did_ibus_init = TRUE;
	}
	_tmp0_ = self->priv->bus;
	ibus_bus_list_engines_async (_tmp0_, -1, NULL, _applet_ibus_manager_on_engines_get_gasync_ready_callback, g_object_ref (self));
}

/**
 * Lost connection to ibus
 */
static void
applet_ibus_manager_ibus_disconnected (AppletIBusManager* self)
{
	g_return_if_fail (self != NULL);
	applet_ibus_manager_reset_ibus (self);
}

/**
 * Attempt to grab the ibus engine for the given name if it
 * exists, or returns null
 */
IBusEngineDesc*
applet_ibus_manager_get_engine (AppletIBusManager* self,
                                const gchar* name)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	IBusEngineDesc* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->engines;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->engines;
	_tmp2_ = g_hash_table_lookup (_tmp1_, name);
	result = (IBusEngineDesc*) _tmp2_;
	return result;
}

static void
applet_ibus_manager_class_init (AppletIBusManagerClass * klass,
                                gpointer klass_data)
{
	applet_ibus_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AppletIBusManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = applet_ibus_manager_finalize;
	applet_ibus_manager_signals[APPLET_IBUS_MANAGER_READY_SIGNAL] = g_signal_new ("ready", TYPE_APPLET_IBUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
applet_ibus_manager_instance_init (AppletIBusManager * self,
                                   gpointer klass)
{
	self->priv = applet_ibus_manager_get_instance_private (self);
	self->priv->engines = NULL;
	self->priv->enginelist = NULL;
	self->priv->did_ibus_init = FALSE;
	self->priv->ibus_available = TRUE;
	self->priv->bus = NULL;
}

static void
applet_ibus_manager_finalize (GObject * obj)
{
	AppletIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLET_IBUS_MANAGER, AppletIBusManager);
	_g_hash_table_unref0 (self->priv->engines);
	(self->priv->enginelist == NULL) ? NULL : (self->priv->enginelist = (_g_list_free__g_object_unref0_ (self->priv->enginelist), NULL));
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (applet_ibus_manager_parent_class)->finalize (obj);
}

/**
 * Reflects the ibus-manager in budgie-wm, with very limited functionality,
 * simply to enable us to mimick the behavior over there.
 */
GType
applet_ibus_manager_get_type (void)
{
	return applet_ibus_manager_type_id;
}

GType
applet_ibus_manager_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppletIBusManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) applet_ibus_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppletIBusManager), 0, (GInstanceInitFunc) applet_ibus_manager_instance_init, NULL };
	applet_ibus_manager_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "AppletIBusManager", &g_define_type_info, 0);
	AppletIBusManager_private_offset = sizeof (AppletIBusManagerPrivate);
	return applet_ibus_manager_type_id;
}

InputSource*
input_source_construct (GType object_type,
                        AppletIBusManager* iman,
                        const gchar* id,
                        guint idx,
                        const gchar* layout,
                        const gchar* variant,
                        const gchar* description,
                        gboolean xkb,
                        GError** error)
{
	InputSource* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	IBusEngineDesc* engine = NULL;
	IBusEngineDesc* _tmp5_;
	IBusEngineDesc* _tmp6_;
	IBusEngineDesc* _tmp7_;
	gchar* language = NULL;
	IBusEngineDesc* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp18_;
	IBusEngineDesc* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* e_variant = NULL;
	IBusEngineDesc* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	IBusEngineDesc* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	self = (InputSource*) g_type_create_instance (object_type);
	self->idx = idx;
	_tmp0_ = g_strdup (layout);
	_g_free0 (self->layout);
	self->layout = _tmp0_;
	_tmp1_ = g_strdup (variant);
	_g_free0 (self->variant);
	self->variant = _tmp1_;
	self->xkb = xkb;
	if (description != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (description);
		_g_free0 (self->description);
		self->description = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->layout;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->description);
		self->description = _tmp4_;
	}
	if (iman == NULL) {
		return self;
	}
	_tmp5_ = applet_ibus_manager_get_engine (iman, id);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	engine = _tmp6_;
	_tmp7_ = engine;
	if (_tmp7_ == NULL) {
		if (!xkb) {
			GError* _tmp8_;
			_tmp8_ = g_error_new_literal (INPUT_METHOD_ERROR, INPUT_METHOD_ERROR_UNKNOWN_IME, "Unknown input method: id");
			_inner_error0_ = _tmp8_;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (engine);
			_input_source_unref0 (self);
			return NULL;
		}
		_g_object_unref0 (engine);
		return self;
	}
	_tmp9_ = engine;
	_tmp10_ = ibus_engine_desc_get_language (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gnome_get_language_from_code (_tmp11_, NULL);
	language = _tmp12_;
	_tmp13_ = language;
	if (_tmp13_ == NULL) {
		IBusEngineDesc* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp14_ = engine;
		_tmp15_ = ibus_engine_desc_get_language (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gnome_get_language_from_locale (_tmp16_, NULL);
		_g_free0 (language);
		language = _tmp17_;
	}
	_tmp18_ = language;
	_tmp19_ = engine;
	_tmp20_ = ibus_engine_desc_get_name (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("%s (%s)", _tmp18_, _tmp21_);
	_g_free0 (self->description);
	self->description = _tmp22_;
	_tmp23_ = engine;
	_tmp24_ = ibus_engine_desc_get_layout_variant (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup (_tmp25_);
	e_variant = _tmp26_;
	_tmp28_ = e_variant;
	if (_tmp28_ != NULL) {
		const gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp29_ = e_variant;
		_tmp30_ = strlen (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp27_ = _tmp31_ > 0;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp32_ = e_variant;
		_tmp33_ = g_strdup (_tmp32_);
		_g_free0 (self->variant);
		self->variant = _tmp33_;
	}
	_tmp34_ = engine;
	_tmp35_ = ibus_engine_desc_get_language (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strdup (_tmp36_);
	_g_free0 (self->layout);
	self->layout = _tmp37_;
	_tmp38_ = g_strdup (id);
	_g_free0 (self->ibus_engine);
	self->ibus_engine = _tmp38_;
	_g_free0 (e_variant);
	_g_free0 (language);
	_g_object_unref0 (engine);
	return self;
}

InputSource*
input_source_new (AppletIBusManager* iman,
                  const gchar* id,
                  guint idx,
                  const gchar* layout,
                  const gchar* variant,
                  const gchar* description,
                  gboolean xkb,
                  GError** error)
{
	return input_source_construct (TYPE_INPUT_SOURCE, iman, id, idx, layout, variant, description, xkb, error);
}

static void
value_input_source_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_input_source_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		input_source_unref (value->data[0].v_pointer);
	}
}

static void
value_input_source_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = input_source_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_input_source_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_input_source_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		InputSource * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = input_source_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_input_source_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	InputSource ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = input_source_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_input_source (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecInputSource* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_INPUT_SOURCE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_input_source (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INPUT_SOURCE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_input_source (GValue* value,
                        gpointer v_object)
{
	InputSource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		input_source_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		input_source_unref (old);
	}
}

void
value_take_input_source (GValue* value,
                         gpointer v_object)
{
	InputSource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		input_source_unref (old);
	}
}

static void
input_source_class_init (InputSourceClass * klass,
                         gpointer klass_data)
{
	input_source_parent_class = g_type_class_peek_parent (klass);
	((InputSourceClass *) klass)->finalize = input_source_finalize;
}

static void
input_source_instance_init (InputSource * self,
                            gpointer klass)
{
	self->xkb = FALSE;
	self->layout = NULL;
	self->variant = NULL;
	self->description = NULL;
	self->idx = (guint) 0;
	self->ibus_engine = NULL;
	self->ref_count = 1;
}

static void
input_source_finalize (InputSource * obj)
{
	InputSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INPUT_SOURCE, InputSource);
	g_signal_handlers_destroy (self);
	_g_free0 (self->layout);
	_g_free0 (self->variant);
	_g_free0 (self->description);
	_g_free0 (self->ibus_engine);
}

GType
input_source_get_type (void)
{
	return input_source_type_id;
}

GType
input_source_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { value_input_source_init, value_input_source_free_value, value_input_source_copy_value, value_input_source_peek_pointer, "p", value_input_source_collect_value, "p", value_input_source_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (InputSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputSource), 0, (GInstanceInitFunc) input_source_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	input_source_type_id = g_type_register_fundamental (g_type_fundamental_next (), "InputSource", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return input_source_type_id;
}

gpointer
input_source_ref (gpointer instance)
{
	InputSource * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
input_source_unref (gpointer instance)
{
	InputSource * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		INPUT_SOURCE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
input_source_menu_item_get_instance_private (InputSourceMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, InputSourceMenuItem_private_offset);
}

InputSourceMenuItem*
input_source_menu_item_construct (GType object_type,
                                  const gchar* description,
                                  guint idx)
{
	InputSourceMenuItem * self = NULL;
	GtkBox* layout = NULL;
	GtkBox* _tmp0_;
	GtkLabel* desc_label = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	self = (InputSourceMenuItem*) g_object_new (object_type, "can-focus", FALSE, NULL);
	self->idx = idx;
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	layout = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	_tmp1_ = (GtkLabel*) gtk_label_new (description);
	g_object_ref_sink (_tmp1_);
	desc_label = _tmp1_;
	gtk_box_pack_start (layout, (GtkWidget*) desc_label, FALSE, FALSE, (guint) 0);
	gtk_widget_set_halign ((GtkWidget*) desc_label, GTK_ALIGN_START);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
	_tmp2_ = (GtkLabel*) gtk_label_new ("  ✓");
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->tick_label);
	self->priv->tick_label = _tmp2_;
	_tmp3_ = self->priv->tick_label;
	gtk_box_pack_end (layout, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
	_tmp4_ = self->priv->tick_label;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp5_, "indicator-item");
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp6_, "menuitem");
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_g_object_unref0 (desc_label);
	_g_object_unref0 (layout);
	return self;
}

InputSourceMenuItem*
input_source_menu_item_new (const gchar* description,
                            guint idx)
{
	return input_source_menu_item_construct (TYPE_INPUT_SOURCE_MENU_ITEM, description, idx);
}

void
input_source_menu_item_set_ticked (InputSourceMenuItem* self,
                                   gboolean ticked)
{
	g_return_if_fail (self != NULL);
	if (ticked) {
		GtkLabel* _tmp0_;
		_tmp0_ = self->priv->tick_label;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		GtkLabel* _tmp1_;
		_tmp1_ = self->priv->tick_label;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}

static void
input_source_menu_item_class_init (InputSourceMenuItemClass * klass,
                                   gpointer klass_data)
{
	input_source_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &InputSourceMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->finalize = input_source_menu_item_finalize;
}

static void
input_source_menu_item_instance_init (InputSourceMenuItem * self,
                                      gpointer klass)
{
	self->priv = input_source_menu_item_get_instance_private (self);
}

static void
input_source_menu_item_finalize (GObject * obj)
{
	InputSourceMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItem);
	_g_object_unref0 (self->priv->tick_label);
	G_OBJECT_CLASS (input_source_menu_item_parent_class)->finalize (obj);
}

GType
input_source_menu_item_get_type (void)
{
	return input_source_menu_item_type_id;
}

GType
input_source_menu_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (InputSourceMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_source_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputSourceMenuItem), 0, (GInstanceInitFunc) input_source_menu_item_instance_init, NULL };
	input_source_menu_item_type_id = g_type_module_register_type (module, gtk_button_get_type (), "InputSourceMenuItem", &g_define_type_info, 0);
	InputSourceMenuItem_private_offset = sizeof (InputSourceMenuItemPrivate);
	return input_source_menu_item_type_id;
}

static inline gpointer
keyboard_layout_applet_get_instance_private (KeyboardLayoutApplet* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardLayoutApplet_private_offset);
}

static gboolean
__lambda4_ (KeyboardLayoutApplet* self,
            GdkEventButton* e)
{
	BudgiePopover* _tmp0_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		BudgiePopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		BudgiePopoverManager* _tmp2_;
		GtkEventBox* _tmp3_;
		_tmp2_ = self->priv->manager;
		_tmp3_ = self->priv->widget;
		budgie_popover_manager_show_popover (_tmp2_, (GtkWidget*) _tmp3_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda4__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda4_ ((KeyboardLayoutApplet*) self, event);
	return result;
}

static void
_keyboard_layout_applet_on_ibus_ready_applet_ibus_manager_ready (AppletIBusManager* _sender,
                                                                 gpointer self)
{
	keyboard_layout_applet_on_ibus_ready ((KeyboardLayoutApplet*) self);
}

KeyboardLayoutApplet*
keyboard_layout_applet_construct (GType object_type)
{
	KeyboardLayoutApplet * self = NULL;
	GtkEventBox* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkBox* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkImage* _tmp6_;
	GtkEventBox* _tmp7_;
	GtkEventBox* _tmp8_;
	GtkImage* _tmp9_;
	GtkBox* _tmp10_;
	GtkEventBox* _tmp11_;
	GtkEventBox* _tmp12_;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	GtkBox* _tmp15_;
	GtkStack* _tmp16_;
	GtkEventBox* _tmp17_;
	BudgiePopover* _tmp18_;
	BudgiePopover* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkListBox* _tmp21_;
	GtkListBox* _tmp22_;
	GtkListBox* _tmp23_;
	GtkListBox* _tmp24_;
	GtkStyleContext* _tmp25_;
	BudgiePopover* _tmp26_;
	GtkListBox* _tmp27_;
	BudgiePopover* _tmp28_;
	GtkWidget* _tmp29_;
	GnomeXkbInfo* _tmp30_;
	GSettings* _tmp31_;
	AppletIBusManager* _tmp32_;
	AppletIBusManager* _tmp33_;
	AppletIBusManager* _tmp34_;
	self = (KeyboardLayoutApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp0_;
	_tmp1_ = self->priv->widget;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "button-press-event", (GCallback) ___lambda4__gtk_widget_button_press_event, self, 0);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "keyboard-indicator");
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp3_;
	_tmp4_ = self->priv->widget;
	_tmp5_ = self->priv->layout;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("input-keyboard-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->img);
	self->priv->img = _tmp6_;
	_tmp7_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->img_wrap);
	self->priv->img_wrap = _tmp7_;
	_tmp8_ = self->priv->img_wrap;
	_tmp9_ = self->priv->img;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->layout;
	_tmp11_ = self->priv->img_wrap;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_tmp12_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp12_);
	_tmp13_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->label_stack);
	self->priv->label_stack = _tmp13_;
	_tmp14_ = self->priv->label_stack;
	gtk_stack_set_transition_type (_tmp14_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP_DOWN);
	_tmp15_ = self->priv->layout;
	_tmp16_ = self->priv->label_stack;
	gtk_box_pack_start (_tmp15_, (GtkWidget*) _tmp16_, FALSE, FALSE, (guint) 0);
	_tmp17_ = self->priv->img_wrap;
	_tmp18_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) _tmp17_);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp18_;
	_tmp19_ = self->priv->popover;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
	gtk_style_context_add_class (_tmp20_, "user-menu");
	_tmp21_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp21_;
	_tmp22_ = self->priv->listbox;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp22_, FALSE);
	_tmp23_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp23_, GTK_SELECTION_NONE);
	_tmp24_ = self->priv->listbox;
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
	gtk_style_context_add_class (_tmp25_, "content-box");
	_tmp26_ = self->priv->popover;
	_tmp27_ = self->priv->listbox;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->popover;
	_tmp29_ = gtk_bin_get_child ((GtkBin*) _tmp28_);
	gtk_widget_show_all (_tmp29_);
	_tmp30_ = gnome_xkb_info_new ();
	_g_object_unref0 (self->priv->xkb);
	self->priv->xkb = _tmp30_;
	_tmp31_ = g_settings_new ("org.gnome.desktop.input-sources");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp31_;
	_tmp32_ = applet_ibus_manager_new ();
	_g_object_unref0 (self->priv->ibus_manager);
	self->priv->ibus_manager = _tmp32_;
	keyboard_layout_applet_update_fallback (self);
	_tmp33_ = self->priv->ibus_manager;
	g_signal_connect_object (_tmp33_, "ready", (GCallback) _keyboard_layout_applet_on_ibus_ready_applet_ibus_manager_ready, self, 0);
	_tmp34_ = self->priv->ibus_manager;
	applet_ibus_manager_do_init (_tmp34_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

KeyboardLayoutApplet*
keyboard_layout_applet_new (void)
{
	return keyboard_layout_applet_construct (TYPE_KEYBOARD_LAYOUT_APPLET);
}

static void
keyboard_layout_applet_real_panel_position_changed (BudgieApplet* base,
                                                    BudgiePanelPosition position)
{
	KeyboardLayoutApplet * self;
	GtkOrientation orient = 0;
	gint margin = 0;
	gboolean _tmp0_ = FALSE;
	GtkImage* _tmp1_;
	GtkBox* _tmp2_;
	self = (KeyboardLayoutApplet*) base;
	orient = GTK_ORIENTATION_HORIZONTAL;
	margin = 4;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		orient = GTK_ORIENTATION_VERTICAL;
		margin = 0;
	}
	_tmp1_ = self->priv->img;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, margin);
	_tmp2_ = self->priv->layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp2_, orient);
}

/**
 * Only begin listing sources and such when ibus becomes available
 * or we explicitly find it won't work
 */
static void
_keyboard_layout_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	keyboard_layout_applet_on_settings_changed ((KeyboardLayoutApplet*) self, key);
}

static void
keyboard_layout_applet_on_ibus_ready (KeyboardLayoutApplet* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _keyboard_layout_applet_on_settings_changed_g_settings_changed, self, 0);
	keyboard_layout_applet_on_settings_changed (self, "sources");
	keyboard_layout_applet_on_settings_changed (self, "current");
}

/**
 * Tell the WM to change the keyboard to the current selection
 */
static void
keyboard_layout_applet_on_row_activate (KeyboardLayoutApplet* self,
                                        GtkButton* item)
{
	InputSourceMenuItem* btn = NULL;
	InputSourceMenuItem* _tmp0_;
	guint idx = 0U;
	GSettings* _tmp1_;
	BudgiePopover* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (IS_INPUT_SOURCE_MENU_ITEM (item) ? ((InputSourceMenuItem*) item) : NULL);
	btn = _tmp0_;
	idx = btn->idx;
	_tmp1_ = self->priv->settings;
	g_settings_set_uint (_tmp1_, "current", idx);
	_tmp2_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_g_object_unref0 (btn);
}

/**
 * Reset the menu/stack
 */
static gpointer
_input_source_ref0 (gpointer self)
{
	return self ? input_source_ref (self) : NULL;
}

static void
_keyboard_layout_applet_on_row_activate_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	keyboard_layout_applet_on_row_activate ((KeyboardLayoutApplet*) self, _sender);
}

static void
keyboard_layout_applet_reset_keyboards (KeyboardLayoutApplet* self)
{
	GtkStack* _tmp0_;
	GList* _tmp1_;
	GtkListBox* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_stack;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* child = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp2_;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = child;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (child);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp4_ = self->priv->listbox;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp6_;
			GtkWidget* child = NULL;
			_tmp6_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp6_;
			{
				GtkWidget* _tmp7_;
				_tmp7_ = child;
				gtk_widget_destroy (_tmp7_);
				_g_object_unref0 (child);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GArray* _tmp10_;
				InputSource* kbinfo = NULL;
				GArray* _tmp11_;
				InputSource* _tmp12_;
				InputSource* _tmp13_;
				GtkEventBox* wrap = NULL;
				GtkEventBox* _tmp14_;
				GtkLabel* displ_label = NULL;
				InputSource* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GtkLabel* _tmp19_;
				GtkLabel* _tmp20_;
				GtkEventBox* _tmp21_;
				GtkLabel* _tmp22_;
				GtkLabel* _tmp23_;
				GtkEventBox* _tmp24_;
				GtkStyleContext* _tmp25_;
				GtkStack* _tmp26_;
				GtkEventBox* _tmp27_;
				InputSource* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GtkEventBox* _tmp31_;
				InputSourceMenuItem* menu_label = NULL;
				InputSource* _tmp32_;
				const gchar* _tmp33_;
				InputSource* _tmp34_;
				InputSourceMenuItem* _tmp35_;
				InputSourceMenuItem* _tmp36_;
				InputSourceMenuItem* _tmp37_;
				GtkListBox* _tmp38_;
				InputSourceMenuItem* _tmp39_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = self->priv->sources;
				if (!(((guint) i) < _tmp10_->len)) {
					break;
				}
				_tmp11_ = self->priv->sources;
				_tmp12_ = g_array_index (_tmp11_, InputSource*, (guint) i);
				_tmp13_ = _input_source_ref0 (_tmp12_);
				kbinfo = _tmp13_;
				_tmp14_ = (GtkEventBox*) gtk_event_box_new ();
				g_object_ref_sink (_tmp14_);
				wrap = _tmp14_;
				_tmp15_ = kbinfo;
				_tmp16_ = _tmp15_->layout;
				_tmp17_ = g_utf8_strup (_tmp16_, (gssize) -1);
				_tmp18_ = _tmp17_;
				_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
				g_object_ref_sink (_tmp19_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				displ_label = _tmp20_;
				_tmp21_ = wrap;
				_tmp22_ = displ_label;
				gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
				_tmp23_ = displ_label;
				gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_FILL);
				_tmp24_ = wrap;
				_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
				gtk_style_context_add_class (_tmp25_, "keyboard-label");
				_tmp26_ = self->priv->label_stack;
				_tmp27_ = wrap;
				_tmp28_ = kbinfo;
				_tmp29_ = g_strdup_printf ("%u", _tmp28_->idx);
				_tmp30_ = _tmp29_;
				gtk_stack_add_named (_tmp26_, (GtkWidget*) _tmp27_, _tmp30_);
				_g_free0 (_tmp30_);
				_tmp31_ = wrap;
				gtk_widget_show_all ((GtkWidget*) _tmp31_);
				_tmp32_ = kbinfo;
				_tmp33_ = _tmp32_->description;
				_tmp34_ = kbinfo;
				_tmp35_ = input_source_menu_item_new (_tmp33_, _tmp34_->idx);
				g_object_ref_sink (_tmp35_);
				menu_label = _tmp35_;
				_tmp36_ = menu_label;
				g_signal_connect_object ((GtkButton*) _tmp36_, "clicked", (GCallback) _keyboard_layout_applet_on_row_activate_gtk_button_clicked, self, 0);
				_tmp37_ = menu_label;
				gtk_widget_show_all ((GtkWidget*) _tmp37_);
				_tmp38_ = self->priv->listbox;
				_tmp39_ = menu_label;
				gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
				_g_object_unref0 (menu_label);
				_g_object_unref0 (displ_label);
				_g_object_unref0 (wrap);
				_input_source_unref0 (kbinfo);
			}
		}
	}
}

static void
keyboard_layout_applet_on_settings_changed (KeyboardLayoutApplet* self,
                                            const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "sources") == 0) {
		keyboard_layout_applet_update_sources (self);
	} else {
		if (g_strcmp0 (key, "current") == 0) {
			keyboard_layout_applet_update_current (self);
		}
	}
}

static void
_input_source_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (input_source_unref (var), NULL));
}

static void
_vala_InputSource_free_function_content_of (gpointer data)
{
	InputSource* self;
	self = *((InputSource**) data);
	_input_source_unref0_ (self);
}

static void
keyboard_layout_applet_update_sources (KeyboardLayoutApplet* self)
{
	GArray* _tmp0_;
	GVariant* val = NULL;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GArray* _tmp44_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_g_array_unref0 (self->priv->sources);
	self->priv->sources = NULL;
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (InputSource*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_InputSource_free_function_content_of);
	_g_array_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "sources");
	val = _tmp2_;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GVariant* _tmp5_;
				InputSource* source = NULL;
				gchar* id = NULL;
				gchar* type = NULL;
				GVariant* _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				if (!_tmp3_) {
					gsize _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = val;
				if (!(i < g_variant_n_children (_tmp5_))) {
					break;
				}
				source = NULL;
				id = NULL;
				type = NULL;
				_tmp6_ = val;
				g_variant_get_child (_tmp6_, i, "(ss)", &_tmp7_, &_tmp8_, NULL);
				_g_free0 (id);
				id = _tmp7_;
				_g_free0 (type);
				type = _tmp8_;
				{
					const gchar* _tmp9_;
					_tmp9_ = id;
					if (g_strcmp0 (_tmp9_, "xkb") == 0) {
						gchar** spl = NULL;
						const gchar* _tmp10_;
						gchar** _tmp11_;
						gchar** _tmp12_;
						gint spl_length1;
						gint _spl_size_;
						gchar* variant = NULL;
						gchar* _tmp13_;
						gchar** _tmp14_;
						gint _tmp14__length1;
						gchar* desc = NULL;
						const gchar* _tmp18_;
						gchar* _tmp19_;
						InputSource* _tmp20_ = NULL;
						AppletIBusManager* _tmp21_;
						const gchar* _tmp22_;
						gchar** _tmp23_;
						gint _tmp23__length1;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						InputSource* _tmp27_;
						InputSource* _tmp28_;
						GArray* _tmp29_;
						InputSource* _tmp30_;
						InputSource* _tmp31_;
						_tmp10_ = type;
						_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "+", 0);
						spl = _tmp12_;
						spl_length1 = _vala_array_length (_tmp11_);
						_spl_size_ = spl_length1;
						_tmp13_ = g_strdup ("");
						variant = _tmp13_;
						_tmp14_ = spl;
						_tmp14__length1 = spl_length1;
						if (_tmp14__length1 > 1) {
							gchar** _tmp15_;
							gint _tmp15__length1;
							const gchar* _tmp16_;
							gchar* _tmp17_;
							_tmp15_ = spl;
							_tmp15__length1 = spl_length1;
							_tmp16_ = _tmp15_[1];
							_tmp17_ = g_strdup (_tmp16_);
							_g_free0 (variant);
							variant = _tmp17_;
						}
						_tmp18_ = type;
						_tmp19_ = keyboard_layout_applet_get_xkb_description (self, _tmp18_);
						desc = _tmp19_;
						_tmp21_ = self->priv->ibus_manager;
						_tmp22_ = type;
						_tmp23_ = spl;
						_tmp23__length1 = spl_length1;
						_tmp24_ = _tmp23_[0];
						_tmp25_ = variant;
						_tmp26_ = desc;
						_tmp27_ = input_source_new (_tmp21_, _tmp22_, (guint) i, _tmp24_, _tmp25_, _tmp26_, TRUE, &_inner_error0_);
						_tmp20_ = _tmp27_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (desc);
							_g_free0 (variant);
							spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
							goto __catch0_g_error;
						}
						_tmp28_ = _tmp20_;
						_tmp20_ = NULL;
						_input_source_unref0 (source);
						source = _tmp28_;
						_tmp29_ = self->priv->sources;
						_tmp30_ = source;
						_tmp31_ = _input_source_ref0 (_tmp30_);
						g_array_append_val (_tmp29_, _tmp31_);
						_input_source_unref0 (_tmp20_);
						_g_free0 (desc);
						_g_free0 (variant);
						spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
					} else {
						InputSource* _tmp32_ = NULL;
						AppletIBusManager* _tmp33_;
						const gchar* _tmp34_;
						InputSource* _tmp35_;
						InputSource* _tmp36_;
						GArray* _tmp37_;
						InputSource* _tmp38_;
						InputSource* _tmp39_;
						_tmp33_ = self->priv->ibus_manager;
						_tmp34_ = type;
						_tmp35_ = input_source_new (_tmp33_, _tmp34_, (guint) i, NULL, NULL, NULL, FALSE, &_inner_error0_);
						_tmp32_ = _tmp35_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp36_ = _tmp32_;
						_tmp32_ = NULL;
						_input_source_unref0 (source);
						source = _tmp36_;
						_tmp37_ = self->priv->sources;
						_tmp38_ = source;
						_tmp39_ = _input_source_ref0 (_tmp38_);
						g_array_append_val (_tmp37_, _tmp39_);
						_input_source_unref0 (_tmp32_);
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					GError* _tmp42_;
					const gchar* _tmp43_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp40_ = id;
					_tmp41_ = type;
					_tmp42_ = e;
					_tmp43_ = _tmp42_->message;
					g_message ("KeyboardLayoutApplet.vala:409: Error adding source %s|%s: %s", _tmp40_, _tmp41_, _tmp43_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (type);
					_g_free0 (id);
					_input_source_unref0 (source);
					_g_variant_unref0 (val);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (type);
				_g_free0 (id);
				_input_source_unref0 (source);
			}
		}
	}
	_tmp44_ = self->priv->sources;
	if (_tmp44_->len == ((guint) 0)) {
		InputSource* _tmp45_;
		GArray* _tmp46_;
		GArray* _tmp47_;
		InputSource* _tmp48_;
		InputSource* _tmp49_;
		_tmp45_ = self->priv->fallback;
		_tmp46_ = self->priv->sources;
		_tmp45_->idx = _tmp46_->len;
		_tmp47_ = self->priv->sources;
		_tmp48_ = self->priv->fallback;
		_tmp49_ = _input_source_ref0 (_tmp48_);
		g_array_append_val (_tmp47_, _tmp49_);
	}
	keyboard_layout_applet_reset_keyboards (self);
	_g_variant_unref0 (val);
}

static gchar*
keyboard_layout_applet_get_xkb_description (KeyboardLayoutApplet* self,
                                            const gchar* id)
{
	gchar* display_name = NULL;
	gchar* short_name = NULL;
	gchar* xkb_layout = NULL;
	gchar* xkb_variant = NULL;
	GnomeXkbInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	xkb_variant = NULL;
	_tmp0_ = self->priv->xkb;
	_tmp5_ = gnome_xkb_info_get_layout_info (_tmp0_, id, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (display_name);
	_tmp6_ = g_strdup (_tmp1_);
	display_name = _tmp6_;
	_g_free0 (short_name);
	_tmp7_ = g_strdup (_tmp2_);
	short_name = _tmp7_;
	_g_free0 (xkb_layout);
	_tmp8_ = g_strdup (_tmp3_);
	xkb_layout = _tmp8_;
	_g_free0 (xkb_variant);
	_tmp9_ = g_strdup (_tmp4_);
	xkb_variant = _tmp9_;
	if (_tmp5_) {
		result = display_name;
		_g_free0 (xkb_variant);
		_g_free0 (xkb_layout);
		_g_free0 (short_name);
		return result;
	}
	_tmp10_ = g_strdup (id);
	result = _tmp10_;
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	_g_free0 (short_name);
	_g_free0 (display_name);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
keyboard_layout_applet_update_fallback (KeyboardLayoutApplet* self)
{
	gchar* type = NULL;
	gchar* id = NULL;
	gchar* locale = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* display_name = NULL;
	gchar* short_name = NULL;
	gchar* xkb_layout = NULL;
	gchar* xkb_variant = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	type = NULL;
	id = NULL;
	_tmp1_ = _tmp0_ = g_get_language_names ();
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_strdup (_tmp2_);
	locale = _tmp3_;
	display_name = NULL;
	short_name = NULL;
	xkb_layout = NULL;
	xkb_variant = NULL;
	_tmp4_ = locale;
	if (!string_contains (_tmp4_, "_")) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (DEFAULT_LOCALE);
		_g_free0 (locale);
		locale = _tmp5_;
	}
	_tmp6_ = locale;
	_tmp9_ = gnome_get_input_source_from_locale (_tmp6_, &_tmp7_, &_tmp8_);
	_g_free0 (type);
	_tmp10_ = g_strdup (_tmp7_);
	type = _tmp10_;
	_g_free0 (id);
	_tmp11_ = g_strdup (_tmp8_);
	id = _tmp11_;
	if (!_tmp9_) {
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gnome_get_input_source_from_locale (DEFAULT_LOCALE, &_tmp12_, &_tmp13_);
		_g_free0 (type);
		_tmp14_ = g_strdup (_tmp12_);
		type = _tmp14_;
		_g_free0 (id);
		_tmp15_ = g_strdup (_tmp13_);
		id = _tmp15_;
	}
	{
		GnomeXkbInfo* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gboolean _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp16_ = self->priv->xkb;
		_tmp17_ = id;
		_tmp22_ = gnome_xkb_info_get_layout_info (_tmp16_, _tmp17_, &_tmp18_, &_tmp19_, &_tmp20_, &_tmp21_);
		_g_free0 (display_name);
		_tmp23_ = g_strdup (_tmp18_);
		display_name = _tmp23_;
		_g_free0 (short_name);
		_tmp24_ = g_strdup (_tmp19_);
		short_name = _tmp24_;
		_g_free0 (xkb_layout);
		_tmp25_ = g_strdup (_tmp20_);
		xkb_layout = _tmp25_;
		_g_free0 (xkb_variant);
		_tmp26_ = g_strdup (_tmp21_);
		xkb_variant = _tmp26_;
		if (_tmp22_) {
			InputSource* _tmp27_ = NULL;
			AppletIBusManager* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			InputSource* _tmp33_;
			InputSource* _tmp34_;
			_tmp28_ = self->priv->ibus_manager;
			_tmp29_ = id;
			_tmp30_ = xkb_layout;
			_tmp31_ = xkb_variant;
			_tmp32_ = display_name;
			_tmp33_ = input_source_new (_tmp28_, _tmp29_, (guint) 0, _tmp30_, _tmp31_, _tmp32_, TRUE, &_inner_error0_);
			_tmp27_ = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp34_ = _tmp27_;
			_tmp27_ = NULL;
			_input_source_unref0 (self->priv->fallback);
			self->priv->fallback = _tmp34_;
			_input_source_unref0 (_tmp27_);
		} else {
			InputSource* _tmp35_ = NULL;
			AppletIBusManager* _tmp36_;
			const gchar* _tmp37_;
			InputSource* _tmp38_;
			InputSource* _tmp39_;
			_tmp36_ = self->priv->ibus_manager;
			_tmp37_ = id;
			_tmp38_ = input_source_new (_tmp36_, _tmp37_, (guint) 0, DEFAULT_LAYOUT, DEFAULT_VARIANT, NULL, TRUE, &_inner_error0_);
			_tmp35_ = _tmp38_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp39_ = _tmp35_;
			_tmp35_ = NULL;
			_input_source_unref0 (self->priv->fallback);
			self->priv->fallback = _tmp39_;
			_input_source_unref0 (_tmp35_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp40_;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = id;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_message ("KeyboardLayoutApplet.vala:455: Error updating fallback source %s: %s", _tmp40_, _tmp42_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (xkb_variant);
		_g_free0 (xkb_layout);
		_g_free0 (short_name);
		_g_free0 (display_name);
		_g_free0 (locale);
		_g_free0 (id);
		_g_free0 (type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	_g_free0 (short_name);
	_g_free0 (display_name);
	_g_free0 (locale);
	_g_free0 (id);
	_g_free0 (type);
}

/**
 * Update our knowledge of the currently selected keyboard layout
 */
static void
keyboard_layout_applet_update_current (KeyboardLayoutApplet* self)
{
	guint id = 0U;
	GSettings* _tmp0_;
	GtkWidget* child = NULL;
	GtkStack* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkListBox* _tmp8_;
	GList* _tmp9_;
	GtkStack* _tmp17_;
	GtkWidget* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	id = g_settings_get_uint (_tmp0_, "current");
	_tmp1_ = self->priv->label_stack;
	_tmp2_ = g_strdup_printf ("%u", id);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_stack_get_child_by_name (_tmp1_, _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	child = _tmp6_;
	_tmp7_ = child;
	if (_tmp7_ == NULL) {
		g_message ("KeyboardLayoutApplet.vala:467: WARNING: Missing child in layout!!");
		_g_object_unref0 (child);
		return;
	}
	_tmp8_ = self->priv->listbox;
	_tmp9_ = gtk_container_get_children ((GtkContainer*) _tmp8_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp9_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* _tmp10_;
			GtkWidget* row = NULL;
			_tmp10_ = _g_object_ref0 ((GtkWidget*) row_it->data);
			row = _tmp10_;
			{
				InputSourceMenuItem* item = NULL;
				GtkWidget* _tmp11_;
				GtkWidget* _tmp12_;
				InputSourceMenuItem* _tmp13_;
				InputSourceMenuItem* _tmp14_;
				_tmp11_ = row;
				_tmp12_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_bin_get_type (), GtkBin));
				_tmp13_ = _g_object_ref0 (IS_INPUT_SOURCE_MENU_ITEM (_tmp12_) ? ((InputSourceMenuItem*) _tmp12_) : NULL);
				item = _tmp13_;
				_tmp14_ = item;
				if (_tmp14_->idx == id) {
					InputSourceMenuItem* _tmp15_;
					_tmp15_ = item;
					input_source_menu_item_set_ticked (_tmp15_, TRUE);
				} else {
					InputSourceMenuItem* _tmp16_;
					_tmp16_ = item;
					input_source_menu_item_set_ticked (_tmp16_, FALSE);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (row);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	_tmp17_ = self->priv->label_stack;
	_tmp18_ = child;
	gtk_stack_set_visible_child (_tmp17_, _tmp18_);
	_g_object_unref0 (child);
}

static void
keyboard_layout_applet_real_update_popovers (BudgieApplet* base,
                                             BudgiePopoverManager* manager)
{
	KeyboardLayoutApplet * self;
	BudgiePopoverManager* _tmp0_;
	GtkEventBox* _tmp1_;
	BudgiePopover* _tmp2_;
	self = (KeyboardLayoutApplet*) base;
	_tmp0_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp0_;
	_tmp1_ = self->priv->widget;
	_tmp2_ = self->priv->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp1_, _tmp2_);
}

static void
keyboard_layout_applet_class_init (KeyboardLayoutAppletClass * klass,
                                   gpointer klass_data)
{
	keyboard_layout_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardLayoutApplet_private_offset);
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) keyboard_layout_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) keyboard_layout_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->finalize = keyboard_layout_applet_finalize;
}

static void
keyboard_layout_applet_instance_init (KeyboardLayoutApplet * self,
                                      gpointer klass)
{
	self->priv = keyboard_layout_applet_get_instance_private (self);
	self->priv->manager = NULL;
	self->priv->ibus_manager = NULL;
}

static void
keyboard_layout_applet_finalize (GObject * obj)
{
	KeyboardLayoutApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYBOARD_LAYOUT_APPLET, KeyboardLayoutApplet);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->img_wrap);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->img);
	_g_object_unref0 (self->priv->settings);
	_g_array_unref0 (self->priv->sources);
	_input_source_unref0 (self->priv->fallback);
	_g_object_unref0 (self->priv->xkb);
	_g_object_unref0 (self->priv->label_stack);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->ibus_manager);
	G_OBJECT_CLASS (keyboard_layout_applet_parent_class)->finalize (obj);
}

GType
keyboard_layout_applet_get_type (void)
{
	return keyboard_layout_applet_type_id;
}

GType
keyboard_layout_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardLayoutAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_layout_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardLayoutApplet), 0, (GInstanceInitFunc) keyboard_layout_applet_instance_init, NULL };
	keyboard_layout_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "KeyboardLayoutApplet", &g_define_type_info, 0);
	KeyboardLayoutApplet_private_offset = sizeof (KeyboardLayoutAppletPrivate);
	return keyboard_layout_applet_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	keyboard_layout_plugin_register_type (module);
	applet_ibus_manager_register_type (module);
	input_source_register_type (module);
	input_source_menu_item_register_type (module);
	keyboard_layout_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_KEYBOARD_LAYOUT_PLUGIN);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

