/* DBusInterfaces.c generated by valac 0.56.3, the Vala compiler
 * generated from DBusInterfaces.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "userindicator.h"

#define TYPE_ACCOUNTS_INTERFACE (accounts_interface_get_type ())
#define ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterface))
#define IS_ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_INTERFACE))
#define ACCOUNTS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterfaceIface))

typedef struct _AccountsInterface AccountsInterface;
typedef struct _AccountsInterfaceIface AccountsInterfaceIface;

#define TYPE_ACCOUNTS_INTERFACE_PROXY (accounts_interface_proxy_get_type ())
typedef GDBusProxy AccountsInterfaceProxy;
typedef GDBusProxyClass AccountsInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ACCOUNT_USER_INTERFACE (account_user_interface_get_type ())
#define ACCOUNT_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_USER_INTERFACE, AccountUserInterface))
#define IS_ACCOUNT_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_USER_INTERFACE))
#define ACCOUNT_USER_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNT_USER_INTERFACE, AccountUserInterfaceIface))

typedef struct _AccountUserInterface AccountUserInterface;
typedef struct _AccountUserInterfaceIface AccountUserInterfaceIface;

#define TYPE_ACCOUNT_USER_INTERFACE_PROXY (account_user_interface_proxy_get_type ())
enum  {
	ACCOUNT_USER_INTERFACE_CHANGED_SIGNAL,
	ACCOUNT_USER_INTERFACE_NUM_SIGNALS
};
static guint account_user_interface_signals[ACCOUNT_USER_INTERFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy AccountUserInterfaceProxy;
typedef GDBusProxyClass AccountUserInterfaceProxyClass;

#define TYPE_PROPERTIES_INTERFACE (properties_interface_get_type ())
#define PROPERTIES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_INTERFACE, PropertiesInterface))
#define IS_PROPERTIES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_INTERFACE))
#define PROPERTIES_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROPERTIES_INTERFACE, PropertiesInterfaceIface))

typedef struct _PropertiesInterface PropertiesInterface;
typedef struct _PropertiesInterfaceIface PropertiesInterfaceIface;

#define TYPE_PROPERTIES_INTERFACE_PROXY (properties_interface_proxy_get_type ())
enum  {
	PROPERTIES_INTERFACE_PROPERTIES_CHANGED_SIGNAL,
	PROPERTIES_INTERFACE_NUM_SIGNALS
};
static guint properties_interface_signals[PROPERTIES_INTERFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy PropertiesInterfaceProxy;
typedef GDBusProxyClass PropertiesInterfaceProxyClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef GDBusProxy LogindInterfaceProxy;
typedef GDBusProxyClass LogindInterfaceProxyClass;
typedef GDBusProxy SessionManagerProxy;
typedef GDBusProxyClass SessionManagerProxyClass;
typedef struct _session_manager_RebootReadyData session_manager_RebootReadyData;
typedef struct _session_manager_ShutdownReadyData session_manager_ShutdownReadyData;
typedef GDBusProxy ScreenSaverProxy;
typedef GDBusProxyClass ScreenSaverProxyClass;

struct _AccountsInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (AccountsInterface* self, const gchar* username, GError** error);
};

struct _AccountUserInterfaceIface {
	GTypeInterface parent_iface;
};

struct _PropertiesInterfaceIface {
	GTypeInterface parent_iface;
	GVariant* (*get) (PropertiesInterface* self, const gchar* interface, const gchar* property, GError** error);
};

struct _session_manager_RebootReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _session_manager_ShutdownReadyData {
	GDBusMethodInvocation* _invocation_;
};

static GType accounts_interface_type_id = 0;
static GType account_user_interface_type_id = 0;
static GType properties_interface_type_id = 0;
static GType logind_interface_type_id = 0;
static GType session_manager_type_id = 0;
static GType screen_saver_type_id = 0;

VALA_EXTERN GType accounts_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void accounts_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint accounts_interface_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
GType accounts_interface_register_type (GTypeModule * module);
VALA_EXTERN GType accounts_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* accounts_interface_find_user_by_name (AccountsInterface* self,
                                             const gchar* username,
                                             GError** error);
static void accounts_interface_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static gchar* accounts_interface_proxy_find_user_by_name (AccountsInterface* self,
                                                   const gchar* username,
                                                   GError** error);
static void accounts_interface_proxy_accounts_interface_interface_init (AccountsInterfaceIface* iface);
static void _dbus_accounts_interface_find_user_by_name (AccountsInterface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void accounts_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* accounts_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean accounts_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _accounts_interface_unregister_object (gpointer user_data);
GType account_user_interface_register_type (GTypeModule * module);
VALA_EXTERN GType account_user_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType account_user_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void account_user_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint account_user_interface_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
static void account_user_interface_proxy_g_signal (GDBusProxy* proxy,
                                            const gchar* sender_name,
                                            const gchar* signal_name,
                                            GVariant* parameters);
static void _dbus_handle_account_user_interface_changed (AccountUserInterface* self,
                                                  GVariant* parameters);
static void account_user_interface_proxy_account_user_interface_interface_init (AccountUserInterfaceIface* iface);
static void account_user_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* account_user_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean account_user_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _dbus_account_user_interface_changed (GObject* _sender,
                                           gpointer* _data);
static void _account_user_interface_unregister_object (gpointer user_data);
VALA_EXTERN GType properties_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void properties_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint properties_interface_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
GType properties_interface_register_type (GTypeModule * module);
VALA_EXTERN GType properties_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GVariant* properties_interface_get (PropertiesInterface* self,
                                    const gchar* interface,
                                    const gchar* property,
                                    GError** error);
static void properties_interface_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static void _dbus_handle_properties_interface_properties_changed (PropertiesInterface* self,
                                                           GVariant* parameters);
static GVariant* properties_interface_proxy_get (PropertiesInterface* self,
                                          const gchar* interface,
                                          const gchar* property,
                                          GError** error);
static void properties_interface_proxy_properties_interface_interface_init (PropertiesInterfaceIface* iface);
static void _dbus_properties_interface_get (PropertiesInterface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void properties_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* properties_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean properties_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_properties_interface_properties_changed (GObject* _sender,
                                                    gpointer* _data);
static void _properties_interface_unregister_object (gpointer user_data);
static void logind_interface_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters);
static void logind_interface_proxy_suspend (LogindInterface* self,
                                     gboolean interactive,
                                     GError** error);
static void logind_interface_proxy_hibernate (LogindInterface* self,
                                       gboolean interactive,
                                       GError** error);
static void logind_interface_proxy_logind_interface_interface_init (LogindInterfaceIface* iface);
static void _dbus_logind_interface_suspend (LogindInterface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_logind_interface_hibernate (LogindInterface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void logind_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* logind_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean logind_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _logind_interface_unregister_object (gpointer user_data);
static void session_manager_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters);
static void session_manager_proxy_Logout (SessionManager* self,
                                   guint mode,
                                   GError** error);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void session_manager_proxy_Reboot_async (SessionManager* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void session_manager_proxy_Reboot_finish (SessionManager* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void session_manager_proxy_Shutdown_async (SessionManager* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void session_manager_proxy_Shutdown_finish (SessionManager* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void session_manager_proxy_session_manager_interface_init (SessionManagerIface* iface);
static void _dbus_session_manager_Logout (SessionManager* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_session_manager_Reboot (SessionManager* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_session_manager_Reboot_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_);
static void _dbus_session_manager_Shutdown (SessionManager* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_session_manager_Shutdown_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _session_manager_unregister_object (gpointer user_data);
static void screen_saver_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void screen_saver_proxy_lock (ScreenSaver* self,
                              GError** error);
static void screen_saver_proxy_screen_saver_interface_init (ScreenSaverIface* iface);
static void _dbus_screen_saver_lock (ScreenSaver* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation);
static void screen_saver_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* screen_saver_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean screen_saver_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _screen_saver_unregister_object (gpointer user_data);

static const GDBusArgInfo _accounts_interface_dbus_arg_info_find_user_by_name_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _accounts_interface_dbus_arg_info_find_user_by_name_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_find_user_by_name_in[] = {&_accounts_interface_dbus_arg_info_find_user_by_name_username, NULL};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_find_user_by_name_out[] = {&_accounts_interface_dbus_arg_info_find_user_by_name_result, NULL};
static const GDBusMethodInfo _accounts_interface_dbus_method_info_find_user_by_name = {-1, "FindUserByName", (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_find_user_by_name_in), (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_find_user_by_name_out), NULL};
static const GDBusMethodInfo * const _accounts_interface_dbus_method_info[] = {&_accounts_interface_dbus_method_info_find_user_by_name, NULL};
static const GDBusSignalInfo * const _accounts_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _accounts_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _accounts_interface_dbus_interface_info = {-1, "org.freedesktop.Accounts", (GDBusMethodInfo **) (&_accounts_interface_dbus_method_info), (GDBusSignalInfo **) (&_accounts_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_accounts_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _accounts_interface_dbus_interface_vtable = {accounts_interface_dbus_interface_method_call, accounts_interface_dbus_interface_get_property, accounts_interface_dbus_interface_set_property};
static const GDBusMethodInfo * const _account_user_interface_dbus_method_info[] = {NULL};
static const GDBusArgInfo * const _account_user_interface_dbus_arg_info_changed[] = {NULL};
static const GDBusSignalInfo _account_user_interface_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_account_user_interface_dbus_arg_info_changed), NULL};
static const GDBusSignalInfo * const _account_user_interface_dbus_signal_info[] = {&_account_user_interface_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo * const _account_user_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _account_user_interface_dbus_interface_info = {-1, "org.freedesktop.Accounts.User", (GDBusMethodInfo **) (&_account_user_interface_dbus_method_info), (GDBusSignalInfo **) (&_account_user_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_account_user_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _account_user_interface_dbus_interface_vtable = {account_user_interface_dbus_interface_method_call, account_user_interface_dbus_interface_get_property, account_user_interface_dbus_interface_set_property};
static const GDBusArgInfo _properties_interface_dbus_arg_info_get_interface = {-1, "interface", "s", NULL};
static const GDBusArgInfo _properties_interface_dbus_arg_info_get_property = {-1, "property", "s", NULL};
static const GDBusArgInfo _properties_interface_dbus_arg_info_get_result = {-1, "result", "v", NULL};
static const GDBusArgInfo * const _properties_interface_dbus_arg_info_get_in[] = {&_properties_interface_dbus_arg_info_get_interface, &_properties_interface_dbus_arg_info_get_property, NULL};
static const GDBusArgInfo * const _properties_interface_dbus_arg_info_get_out[] = {&_properties_interface_dbus_arg_info_get_result, NULL};
static const GDBusMethodInfo _properties_interface_dbus_method_info_get = {-1, "Get", (GDBusArgInfo **) (&_properties_interface_dbus_arg_info_get_in), (GDBusArgInfo **) (&_properties_interface_dbus_arg_info_get_out), NULL};
static const GDBusMethodInfo * const _properties_interface_dbus_method_info[] = {&_properties_interface_dbus_method_info_get, NULL};
static const GDBusArgInfo * const _properties_interface_dbus_arg_info_properties_changed[] = {NULL};
static const GDBusSignalInfo _properties_interface_dbus_signal_info_properties_changed = {-1, "PropertiesChanged", (GDBusArgInfo **) (&_properties_interface_dbus_arg_info_properties_changed), NULL};
static const GDBusSignalInfo * const _properties_interface_dbus_signal_info[] = {&_properties_interface_dbus_signal_info_properties_changed, NULL};
static const GDBusPropertyInfo * const _properties_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _properties_interface_dbus_interface_info = {-1, "org.freedesktop.DBus.Properties", (GDBusMethodInfo **) (&_properties_interface_dbus_method_info), (GDBusSignalInfo **) (&_properties_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_properties_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _properties_interface_dbus_interface_vtable = {properties_interface_dbus_interface_method_call, properties_interface_dbus_interface_get_property, properties_interface_dbus_interface_set_property};
static const GDBusArgInfo _logind_interface_dbus_arg_info_suspend_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _logind_interface_dbus_arg_info_suspend_in[] = {&_logind_interface_dbus_arg_info_suspend_interactive, NULL};
static const GDBusArgInfo * const _logind_interface_dbus_arg_info_suspend_out[] = {NULL};
static const GDBusMethodInfo _logind_interface_dbus_method_info_suspend = {-1, "Suspend", (GDBusArgInfo **) (&_logind_interface_dbus_arg_info_suspend_in), (GDBusArgInfo **) (&_logind_interface_dbus_arg_info_suspend_out), NULL};
static const GDBusArgInfo _logind_interface_dbus_arg_info_hibernate_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _logind_interface_dbus_arg_info_hibernate_in[] = {&_logind_interface_dbus_arg_info_hibernate_interactive, NULL};
static const GDBusArgInfo * const _logind_interface_dbus_arg_info_hibernate_out[] = {NULL};
static const GDBusMethodInfo _logind_interface_dbus_method_info_hibernate = {-1, "Hibernate", (GDBusArgInfo **) (&_logind_interface_dbus_arg_info_hibernate_in), (GDBusArgInfo **) (&_logind_interface_dbus_arg_info_hibernate_out), NULL};
static const GDBusMethodInfo * const _logind_interface_dbus_method_info[] = {&_logind_interface_dbus_method_info_suspend, &_logind_interface_dbus_method_info_hibernate, NULL};
static const GDBusSignalInfo * const _logind_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _logind_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _logind_interface_dbus_interface_info = {-1, "org.freedesktop.login1.Manager", (GDBusMethodInfo **) (&_logind_interface_dbus_method_info), (GDBusSignalInfo **) (&_logind_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_logind_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _logind_interface_dbus_interface_vtable = {logind_interface_dbus_interface_method_call, logind_interface_dbus_interface_get_property, logind_interface_dbus_interface_set_property};
static const GDBusArgInfo _session_manager_dbus_arg_info_Logout_mode = {-1, "mode", "u", NULL};
static const GDBusArgInfo * const _session_manager_dbus_arg_info_Logout_in[] = {&_session_manager_dbus_arg_info_Logout_mode, NULL};
static const GDBusArgInfo * const _session_manager_dbus_arg_info_Logout_out[] = {NULL};
static const GDBusMethodInfo _session_manager_dbus_method_info_Logout = {-1, "Logout", (GDBusArgInfo **) (&_session_manager_dbus_arg_info_Logout_in), (GDBusArgInfo **) (&_session_manager_dbus_arg_info_Logout_out), NULL};
static const GDBusArgInfo * const _session_manager_dbus_arg_info_Reboot_in[] = {NULL};
static const GDBusArgInfo * const _session_manager_dbus_arg_info_Reboot_out[] = {NULL};
static const GDBusMethodInfo _session_manager_dbus_method_info_Reboot = {-1, "Reboot", (GDBusArgInfo **) (&_session_manager_dbus_arg_info_Reboot_in), (GDBusArgInfo **) (&_session_manager_dbus_arg_info_Reboot_out), NULL};
static const GDBusArgInfo * const _session_manager_dbus_arg_info_Shutdown_in[] = {NULL};
static const GDBusArgInfo * const _session_manager_dbus_arg_info_Shutdown_out[] = {NULL};
static const GDBusMethodInfo _session_manager_dbus_method_info_Shutdown = {-1, "Shutdown", (GDBusArgInfo **) (&_session_manager_dbus_arg_info_Shutdown_in), (GDBusArgInfo **) (&_session_manager_dbus_arg_info_Shutdown_out), NULL};
static const GDBusMethodInfo * const _session_manager_dbus_method_info[] = {&_session_manager_dbus_method_info_Logout, &_session_manager_dbus_method_info_Reboot, &_session_manager_dbus_method_info_Shutdown, NULL};
static const GDBusSignalInfo * const _session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _session_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_session_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _session_manager_dbus_interface_vtable = {session_manager_dbus_interface_method_call, session_manager_dbus_interface_get_property, session_manager_dbus_interface_set_property};
static const GDBusArgInfo * const _screen_saver_dbus_arg_info_lock_in[] = {NULL};
static const GDBusArgInfo * const _screen_saver_dbus_arg_info_lock_out[] = {NULL};
static const GDBusMethodInfo _screen_saver_dbus_method_info_lock = {-1, "Lock", (GDBusArgInfo **) (&_screen_saver_dbus_arg_info_lock_in), (GDBusArgInfo **) (&_screen_saver_dbus_arg_info_lock_out), NULL};
static const GDBusMethodInfo * const _screen_saver_dbus_method_info[] = {&_screen_saver_dbus_method_info_lock, NULL};
static const GDBusSignalInfo * const _screen_saver_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _screen_saver_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _screen_saver_dbus_interface_info = {-1, "org.gnome.ScreenSaver", (GDBusMethodInfo **) (&_screen_saver_dbus_method_info), (GDBusSignalInfo **) (&_screen_saver_dbus_signal_info), (GDBusPropertyInfo **) (&_screen_saver_dbus_property_info), NULL};
static const GDBusInterfaceVTable _screen_saver_dbus_interface_vtable = {screen_saver_dbus_interface_method_call, screen_saver_dbus_interface_get_property, screen_saver_dbus_interface_set_property};

gchar*
accounts_interface_find_user_by_name (AccountsInterface* self,
                                      const gchar* username,
                                      GError** error)
{
	AccountsInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ACCOUNTS_INTERFACE_GET_INTERFACE (self);
	if (_iface_->find_user_by_name) {
		return _iface_->find_user_by_name (self, username, error);
	}
	return NULL;
}

static void
accounts_interface_default_init (AccountsInterfaceIface * iface,
                                 gpointer iface_data)
{
}

GType
accounts_interface_get_type (void)
{
	return accounts_interface_type_id;
}

GType
accounts_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	accounts_interface_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "AccountsInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (accounts_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (accounts_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) accounts_interface_proxy_get_type);
	g_type_set_qdata (accounts_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts");
	g_type_set_qdata (accounts_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_accounts_interface_dbus_interface_info));
	g_type_set_qdata (accounts_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) accounts_interface_register_object);
	return accounts_interface_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (AccountsInterfaceProxy, accounts_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_ACCOUNTS_INTERFACE, accounts_interface_proxy_accounts_interface_interface_init) )
static void
accounts_interface_proxy_class_init (AccountsInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = accounts_interface_proxy_g_signal;
}

static void
accounts_interface_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
accounts_interface_proxy_class_finalize (AccountsInterfaceProxyClass* klass)
{
}

void
accounts_interface_proxy_register_dynamic_type (GTypeModule* module)
{
	accounts_interface_proxy_register_type (module);
}

static void
accounts_interface_proxy_init (AccountsInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_accounts_interface_dbus_interface_info));
}

static gchar*
accounts_interface_proxy_find_user_by_name (AccountsInterface* self,
                                            const gchar* username,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp0_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts", "FindUserByName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (username));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static void
accounts_interface_proxy_accounts_interface_interface_init (AccountsInterfaceIface* iface)
{
	iface->find_user_by_name = accounts_interface_proxy_find_user_by_name;
}

static void
_dbus_accounts_interface_find_user_by_name (AccountsInterface* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp1_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	result = accounts_interface_find_user_by_name (self, username, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
accounts_interface_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindUserByName") == 0) {
		_dbus_accounts_interface_find_user_by_name (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
accounts_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
accounts_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
accounts_interface_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_accounts_interface_dbus_interface_info), &_accounts_interface_dbus_interface_vtable, data, _accounts_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_accounts_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
account_user_interface_default_init (AccountUserInterfaceIface * iface,
                                     gpointer iface_data)
{
	account_user_interface_signals[ACCOUNT_USER_INTERFACE_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_ACCOUNT_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

GType
account_user_interface_get_type (void)
{
	return account_user_interface_type_id;
}

GType
account_user_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountUserInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_user_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	account_user_interface_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "AccountUserInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (account_user_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (account_user_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) account_user_interface_proxy_get_type);
	g_type_set_qdata (account_user_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts.User");
	g_type_set_qdata (account_user_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_account_user_interface_dbus_interface_info));
	g_type_set_qdata (account_user_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) account_user_interface_register_object);
	return account_user_interface_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (AccountUserInterfaceProxy, account_user_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_ACCOUNT_USER_INTERFACE, account_user_interface_proxy_account_user_interface_interface_init) )
static void
account_user_interface_proxy_class_init (AccountUserInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = account_user_interface_proxy_g_signal;
}

static void
_dbus_handle_account_user_interface_changed (AccountUserInterface* self,
                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "changed");
}

static void
account_user_interface_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters)
{
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_account_user_interface_changed ((AccountUserInterface*) proxy, parameters);
	}
}

static void
account_user_interface_proxy_class_finalize (AccountUserInterfaceProxyClass* klass)
{
}

void
account_user_interface_proxy_register_dynamic_type (GTypeModule* module)
{
	account_user_interface_proxy_register_type (module);
}

static void
account_user_interface_proxy_init (AccountUserInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_account_user_interface_dbus_interface_info));
}

static void
account_user_interface_proxy_account_user_interface_interface_init (AccountUserInterfaceIface* iface)
{
}

static void
account_user_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
account_user_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
account_user_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_account_user_interface_changed (GObject* _sender,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Accounts.User", "Changed", _arguments, NULL);
}

guint
account_user_interface_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_account_user_interface_dbus_interface_info), &_account_user_interface_dbus_interface_vtable, data, _account_user_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_account_user_interface_changed, data);
	return result;
}

static void
_account_user_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_account_user_interface_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

GVariant*
properties_interface_get (PropertiesInterface* self,
                          const gchar* interface,
                          const gchar* property,
                          GError** error)
{
	PropertiesInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PROPERTIES_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get) {
		return _iface_->get (self, interface, property, error);
	}
	return NULL;
}

static void
properties_interface_default_init (PropertiesInterfaceIface * iface,
                                   gpointer iface_data)
{
	properties_interface_signals[PROPERTIES_INTERFACE_PROPERTIES_CHANGED_SIGNAL] = g_signal_new ("properties-changed", TYPE_PROPERTIES_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

GType
properties_interface_get_type (void)
{
	return properties_interface_type_id;
}

GType
properties_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropertiesInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	properties_interface_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "PropertiesInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (properties_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (properties_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) properties_interface_proxy_get_type);
	g_type_set_qdata (properties_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus.Properties");
	g_type_set_qdata (properties_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_properties_interface_dbus_interface_info));
	g_type_set_qdata (properties_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) properties_interface_register_object);
	return properties_interface_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (PropertiesInterfaceProxy, properties_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_PROPERTIES_INTERFACE, properties_interface_proxy_properties_interface_interface_init) )
static void
properties_interface_proxy_class_init (PropertiesInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = properties_interface_proxy_g_signal;
}

static void
_dbus_handle_properties_interface_properties_changed (PropertiesInterface* self,
                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "properties-changed");
}

static void
properties_interface_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
	if (strcmp (signal_name, "PropertiesChanged") == 0) {
		_dbus_handle_properties_interface_properties_changed ((PropertiesInterface*) proxy, parameters);
	}
}

static void
properties_interface_proxy_class_finalize (PropertiesInterfaceProxyClass* klass)
{
}

void
properties_interface_proxy_register_dynamic_type (GTypeModule* module)
{
	properties_interface_proxy_register_type (module);
}

static void
properties_interface_proxy_init (PropertiesInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_properties_interface_dbus_interface_info));
}

static GVariant*
properties_interface_proxy_get (PropertiesInterface* self,
                                const gchar* interface,
                                const gchar* property,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _result = NULL;
	GVariant* _tmp2_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus.Properties", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (interface));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (property));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_variant (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static void
properties_interface_proxy_properties_interface_interface_init (PropertiesInterfaceIface* iface)
{
	iface->get = properties_interface_proxy_get;
}

static void
_dbus_properties_interface_get (PropertiesInterface* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* interface = NULL;
	GVariant* _tmp3_;
	gchar* property = NULL;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	interface = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	property = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	result = properties_interface_get (self, interface, property, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_variant (result));
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (interface);
	_g_free0 (property);
	;
}

static void
properties_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Get") == 0) {
		_dbus_properties_interface_get (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
properties_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
properties_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_properties_interface_properties_changed (GObject* _sender,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus.Properties", "PropertiesChanged", _arguments, NULL);
}

guint
properties_interface_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_properties_interface_dbus_interface_info), &_properties_interface_dbus_interface_vtable, data, _properties_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "properties-changed", (GCallback) _dbus_properties_interface_properties_changed, data);
	return result;
}

static void
_properties_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_properties_interface_properties_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
logind_interface_suspend (LogindInterface* self,
                          gboolean interactive,
                          GError** error)
{
	LogindInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = LOGIND_INTERFACE_GET_INTERFACE (self);
	if (_iface_->suspend) {
		_iface_->suspend (self, interactive, error);
	}
}

void
logind_interface_hibernate (LogindInterface* self,
                            gboolean interactive,
                            GError** error)
{
	LogindInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = LOGIND_INTERFACE_GET_INTERFACE (self);
	if (_iface_->hibernate) {
		_iface_->hibernate (self, interactive, error);
	}
}

static void
logind_interface_default_init (LogindInterfaceIface * iface,
                               gpointer iface_data)
{
}

GType
logind_interface_get_type (void)
{
	return logind_interface_type_id;
}

GType
logind_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (LogindInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) logind_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	logind_interface_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "LogindInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (logind_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (logind_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) logind_interface_proxy_get_type);
	g_type_set_qdata (logind_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Manager");
	g_type_set_qdata (logind_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_logind_interface_dbus_interface_info));
	g_type_set_qdata (logind_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) logind_interface_register_object);
	return logind_interface_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (LogindInterfaceProxy, logind_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_LOGIND_INTERFACE, logind_interface_proxy_logind_interface_interface_init) )
static void
logind_interface_proxy_class_init (LogindInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = logind_interface_proxy_g_signal;
}

static void
logind_interface_proxy_g_signal (GDBusProxy* proxy,
                                 const gchar* sender_name,
                                 const gchar* signal_name,
                                 GVariant* parameters)
{
}

static void
logind_interface_proxy_class_finalize (LogindInterfaceProxyClass* klass)
{
}

void
logind_interface_proxy_register_dynamic_type (GTypeModule* module)
{
	logind_interface_proxy_register_type (module);
}

static void
logind_interface_proxy_init (LogindInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_logind_interface_dbus_interface_info));
}

static void
logind_interface_proxy_suspend (LogindInterface* self,
                                gboolean interactive,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "Suspend");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
logind_interface_proxy_hibernate (LogindInterface* self,
                                  gboolean interactive,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "Hibernate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
logind_interface_proxy_logind_interface_interface_init (LogindInterfaceIface* iface)
{
	iface->suspend = logind_interface_proxy_suspend;
	iface->hibernate = logind_interface_proxy_hibernate;
}

static void
_dbus_logind_interface_suspend (LogindInterface* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean interactive = FALSE;
	GVariant* _tmp5_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	interactive = g_variant_get_boolean (_tmp5_);
	g_variant_unref (_tmp5_);
	logind_interface_suspend (self, interactive, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_logind_interface_hibernate (LogindInterface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean interactive = FALSE;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	interactive = g_variant_get_boolean (_tmp6_);
	g_variant_unref (_tmp6_);
	logind_interface_hibernate (self, interactive, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
logind_interface_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Suspend") == 0) {
		_dbus_logind_interface_suspend (object, parameters, invocation);
	} else if (strcmp (method_name, "Hibernate") == 0) {
		_dbus_logind_interface_hibernate (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
logind_interface_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
logind_interface_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
logind_interface_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_logind_interface_dbus_interface_info), &_logind_interface_dbus_interface_vtable, data, _logind_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_logind_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
session_manager_Logout (SessionManager* self,
                        guint mode,
                        GError** error)
{
	SessionManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->Logout) {
		_iface_->Logout (self, mode, error);
	}
}

void
session_manager_Reboot (SessionManager* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	SessionManagerIface* _iface_;
	_iface_ = SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->Reboot) {
		_iface_->Reboot (self, _callback_, _user_data_);
	}
}

void
session_manager_Reboot_finish (SessionManager* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	SessionManagerIface* _iface_;
	_iface_ = SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->Reboot_finish) {
		_iface_->Reboot_finish (self, _res_, error);
	}
}

void
session_manager_Shutdown (SessionManager* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	SessionManagerIface* _iface_;
	_iface_ = SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->Shutdown) {
		_iface_->Shutdown (self, _callback_, _user_data_);
	}
}

void
session_manager_Shutdown_finish (SessionManager* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	SessionManagerIface* _iface_;
	_iface_ = SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->Shutdown_finish) {
		_iface_->Shutdown_finish (self, _res_, error);
	}
}

static void
session_manager_default_init (SessionManagerIface * iface,
                              gpointer iface_data)
{
}

GType
session_manager_get_type (void)
{
	return session_manager_type_id;
}

GType
session_manager_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	session_manager_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SessionManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (session_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) session_manager_proxy_get_type);
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_session_manager_dbus_interface_info));
	g_type_set_qdata (session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) session_manager_register_object);
	return session_manager_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (SessionManagerProxy, session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SESSION_MANAGER, session_manager_proxy_session_manager_interface_init) )
static void
session_manager_proxy_class_init (SessionManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = session_manager_proxy_g_signal;
}

static void
session_manager_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters)
{
}

static void
session_manager_proxy_class_finalize (SessionManagerProxyClass* klass)
{
}

void
session_manager_proxy_register_dynamic_type (GTypeModule* module)
{
	session_manager_proxy_register_type (module);
}

static void
session_manager_proxy_init (SessionManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_session_manager_dbus_interface_info));
}

static void
session_manager_proxy_Logout (SessionManager* self,
                              guint mode,
                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Logout");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (mode));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
session_manager_proxy_Reboot_async (SessionManager* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Reboot");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
session_manager_proxy_Reboot_finish (SessionManager* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
session_manager_proxy_Shutdown_async (SessionManager* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "Shutdown");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
session_manager_proxy_Shutdown_finish (SessionManager* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
session_manager_proxy_session_manager_interface_init (SessionManagerIface* iface)
{
	iface->Logout = session_manager_proxy_Logout;
	iface->Reboot = session_manager_proxy_Reboot_async;
	iface->Reboot_finish = session_manager_proxy_Reboot_finish;
	iface->Shutdown = session_manager_proxy_Shutdown_async;
	iface->Shutdown_finish = session_manager_proxy_Shutdown_finish;
}

static void
_dbus_session_manager_Logout (SessionManager* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint mode = 0U;
	GVariant* _tmp7_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	mode = g_variant_get_uint32 (_tmp7_);
	g_variant_unref (_tmp7_);
	session_manager_Logout (self, mode, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_session_manager_Reboot (SessionManager* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	session_manager_RebootReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (session_manager_RebootReadyData);
	_ready_data->_invocation_ = invocation;
	session_manager_Reboot (self, (GAsyncReadyCallback) _dbus_session_manager_Reboot_ready, _ready_data);
}

static void
_dbus_session_manager_Reboot_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_)
{
	session_manager_RebootReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	session_manager_Reboot_finish ((SessionManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (session_manager_RebootReadyData, _ready_data);
}

static void
_dbus_session_manager_Shutdown (SessionManager* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	session_manager_ShutdownReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (session_manager_ShutdownReadyData);
	_ready_data->_invocation_ = invocation;
	session_manager_Shutdown (self, (GAsyncReadyCallback) _dbus_session_manager_Shutdown_ready, _ready_data);
}

static void
_dbus_session_manager_Shutdown_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	session_manager_ShutdownReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	session_manager_Shutdown_finish ((SessionManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (session_manager_ShutdownReadyData, _ready_data);
}

static void
session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Logout") == 0) {
		_dbus_session_manager_Logout (object, parameters, invocation);
	} else if (strcmp (method_name, "Reboot") == 0) {
		_dbus_session_manager_Reboot (object, parameters, invocation);
	} else if (strcmp (method_name, "Shutdown") == 0) {
		_dbus_session_manager_Shutdown (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
session_manager_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_session_manager_dbus_interface_info), &_session_manager_dbus_interface_vtable, data, _session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_session_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
screen_saver_lock (ScreenSaver* self,
                   GError** error)
{
	ScreenSaverIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SCREEN_SAVER_GET_INTERFACE (self);
	if (_iface_->lock) {
		_iface_->lock (self, error);
	}
}

static void
screen_saver_default_init (ScreenSaverIface * iface,
                           gpointer iface_data)
{
}

GType
screen_saver_get_type (void)
{
	return screen_saver_type_id;
}

GType
screen_saver_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScreenSaverIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) screen_saver_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	screen_saver_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ScreenSaver", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (screen_saver_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (screen_saver_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) screen_saver_proxy_get_type);
	g_type_set_qdata (screen_saver_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.ScreenSaver");
	g_type_set_qdata (screen_saver_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_screen_saver_dbus_interface_info));
	g_type_set_qdata (screen_saver_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) screen_saver_register_object);
	return screen_saver_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (ScreenSaverProxy, screen_saver_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SCREEN_SAVER, screen_saver_proxy_screen_saver_interface_init) )
static void
screen_saver_proxy_class_init (ScreenSaverProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = screen_saver_proxy_g_signal;
}

static void
screen_saver_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
}

static void
screen_saver_proxy_class_finalize (ScreenSaverProxyClass* klass)
{
}

void
screen_saver_proxy_register_dynamic_type (GTypeModule* module)
{
	screen_saver_proxy_register_type (module);
}

static void
screen_saver_proxy_init (ScreenSaverProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_screen_saver_dbus_interface_info));
}

static void
screen_saver_proxy_lock (ScreenSaver* self,
                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.ScreenSaver", "Lock");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
screen_saver_proxy_screen_saver_interface_init (ScreenSaverIface* iface)
{
	iface->lock = screen_saver_proxy_lock;
}

static void
_dbus_screen_saver_lock (ScreenSaver* self,
                         GVariant* _parameters_,
                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	screen_saver_lock (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
screen_saver_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Lock") == 0) {
		_dbus_screen_saver_lock (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
screen_saver_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
screen_saver_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
screen_saver_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_screen_saver_dbus_interface_info), &_screen_saver_dbus_interface_vtable, data, _screen_saver_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_screen_saver_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

