/* keyboard.c generated by valac 0.56.3, the Vala compiler
 * generated from keyboard.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 * Copyright (C) GNOME Shell Developers (Heavy inspiration, logic theft)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gobject/gvaluecollector.h>
#include <meta/meta-plugin.h>
#include <libgnome-desktop/gnome-bg-crossfade.h>
#include <libgnome-desktop/gnome-bg-slide-show.h>
#include <libgnome-desktop/gnome-bg.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <libgnome-desktop/gnome-idle-monitor.h>
#include <libgnome-desktop/gnome-languages.h>
#include <libgnome-desktop/gnome-pnp-ids.h>
#include <libgnome-desktop/gnome-rr-config.h>
#include <libgnome-desktop/gnome-rr.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gio/gio.h>
#include <meta/display.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/main.h>
#include <meta/meta-backend.h>

#define BUDGIE_DEFAULT_LOCALE "en_US"
#define BUDGIE_DEFAULT_LAYOUT "us"
#define BUDGIE_DEFAULT_VARIANT ""
#define BUDGIE_DEFAULT_ENGINE "xkb:us::eng"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_INPUT_METHOD_ERROR (budgie_input_method_error_get_type ())

#define BUDGIE_TYPE_INPUT_SOURCE (budgie_input_source_get_type ())
#define BUDGIE_INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSource))
#define BUDGIE_INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSourceClass))
#define BUDGIE_IS_INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_INPUT_SOURCE))
#define BUDGIE_IS_INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_INPUT_SOURCE))
#define BUDGIE_INPUT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSourceClass))

typedef struct _BudgieInputSource BudgieInputSource;
typedef struct _BudgieInputSourceClass BudgieInputSourceClass;
typedef struct _BudgieInputSourcePrivate BudgieInputSourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_IBUS_MANAGER (budgie_ibus_manager_get_type ())
#define BUDGIE_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager))
#define BUDGIE_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))
#define BUDGIE_IS_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IS_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IBUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))

typedef struct _BudgieIBusManager BudgieIBusManager;
typedef struct _BudgieIBusManagerClass BudgieIBusManagerClass;
#define _budgie_input_source_unref0(var) ((var == NULL) ? NULL : (var = (budgie_input_source_unref (var), NULL)))
typedef struct _BudgieParamSpecInputSource BudgieParamSpecInputSource;

#define BUDGIE_TYPE_KEYBOARD_MANAGER (budgie_keyboard_manager_get_type ())
#define BUDGIE_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager))
#define BUDGIE_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))
#define BUDGIE_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))

typedef struct _BudgieKeyboardManager BudgieKeyboardManager;
typedef struct _BudgieKeyboardManagerClass BudgieKeyboardManagerClass;
typedef struct _BudgieKeyboardManagerPrivate BudgieKeyboardManagerPrivate;

#define BUDGIE_TYPE_BUDGIE_WM (budgie_budgie_wm_get_type ())
#define BUDGIE_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM))
#define BUDGIE_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))
#define BUDGIE_IS_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_IS_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_BUDGIE_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))

typedef struct _BudgieBudgieWM BudgieBudgieWM;
typedef struct _BudgieBudgieWMClass BudgieBudgieWMClass;
enum  {
	BUDGIE_KEYBOARD_MANAGER_0_PROPERTY,
	BUDGIE_KEYBOARD_MANAGER_WM_PROPERTY,
	BUDGIE_KEYBOARD_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_keyboard_manager_properties[BUDGIE_KEYBOARD_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef void (*BudgieKeyboardManagerKeyHandlerFunc) (MetaDisplay* display, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding, gpointer user_data);

typedef enum  {
	BUDGIE_INPUT_METHOD_ERROR_UNKNOWN_IME
} BudgieInputMethodError;
#define BUDGIE_INPUT_METHOD_ERROR budgie_input_method_error_quark ()

struct _BudgieInputSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieInputSourcePrivate * priv;
	gboolean xkb;
	gchar* layout;
	gchar* variant;
	guint idx;
	gchar* ibus_engine;
};

struct _BudgieInputSourceClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieInputSource *self);
};

struct _BudgieParamSpecInputSource {
	GParamSpec parent_instance;
};

struct _BudgieKeyboardManager {
	GObject parent_instance;
	BudgieKeyboardManagerPrivate * priv;
};

struct _BudgieKeyboardManagerClass {
	GObjectClass parent_class;
};

struct _BudgieKeyboardManagerPrivate {
	BudgieBudgieWM* _wm;
	GnomeXkbInfo* xkb;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	GSettings* settings;
	GArray* sources;
	BudgieInputSource* fallback;
	guint current_source;
	gulong sig_id;
	BudgieIBusManager* ibus_manager;
	gboolean is_keyboard_held;
};

static gpointer budgie_input_source_parent_class = NULL;
static gint BudgieKeyboardManager_private_offset;
static gpointer budgie_keyboard_manager_parent_class = NULL;

VALA_EXTERN GQuark budgie_input_method_error_quark (void);
GType budgie_input_method_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer budgie_input_source_ref (gpointer instance);
VALA_EXTERN void budgie_input_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_input_source (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void budgie_value_set_input_source (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void budgie_value_take_input_source (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_input_source (const GValue* value);
VALA_EXTERN GType budgie_input_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieInputSource, budgie_input_source_unref)
VALA_EXTERN GType budgie_ibus_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieIBusManager, g_object_unref)
VALA_EXTERN BudgieInputSource* budgie_input_source_new (BudgieIBusManager* iman,
                                            const gchar* id,
                                            guint idx,
                                            const gchar* layout,
                                            const gchar* variant,
                                            gboolean xkb,
                                            GError** error);
VALA_EXTERN BudgieInputSource* budgie_input_source_construct (GType object_type,
                                                  BudgieIBusManager* iman,
                                                  const gchar* id,
                                                  guint idx,
                                                  const gchar* layout,
                                                  const gchar* variant,
                                                  gboolean xkb,
                                                  GError** error);
VALA_EXTERN IBusEngineDesc* budgie_ibus_manager_get_engine (BudgieIBusManager* self,
                                                const gchar* name);
static void budgie_input_source_finalize (BudgieInputSource * obj);
static GType budgie_input_source_get_type_once (void);
VALA_EXTERN GType budgie_keyboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieKeyboardManager, g_object_unref)
VALA_EXTERN GType budgie_budgie_wm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBudgieWM, g_object_unref)
VALA_EXTERN BudgieKeyboardManager* budgie_keyboard_manager_new (BudgieBudgieWM* wm);
VALA_EXTERN BudgieKeyboardManager* budgie_keyboard_manager_construct (GType object_type,
                                                          BudgieBudgieWM* wm);
VALA_EXTERN BudgieIBusManager* budgie_ibus_manager_new (BudgieKeyboardManager* kbm);
VALA_EXTERN BudgieIBusManager* budgie_ibus_manager_construct (GType object_type,
                                                  BudgieKeyboardManager* kbm);
static void budgie_keyboard_manager_on_ibus_ready (BudgieKeyboardManager* self);
static void _budgie_keyboard_manager_on_ibus_ready_budgie_ibus_manager_ready (BudgieIBusManager* _sender,
                                                                       gpointer self);
VALA_EXTERN void budgie_ibus_manager_do_init (BudgieIBusManager* self);
static void budgie_keyboard_manager_on_current_source_changed (BudgieKeyboardManager* self);
static void _budgie_keyboard_manager_on_current_source_changed_g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self);
static void budgie_keyboard_manager_on_settings_changed (BudgieKeyboardManager* self,
                                                  const gchar* key);
static void _budgie_keyboard_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self);
static void budgie_keyboard_manager_update_fallback (BudgieKeyboardManager* self);
static void budgie_keyboard_manager_switch_input_source (BudgieKeyboardManager* self,
                                                  MetaDisplay* display,
                                                  MetaWindow* window,
                                                  ClutterKeyEvent* event,
                                                  MetaKeyBinding* binding);
VALA_EXTERN void budgie_keyboard_manager_hold_keyboard (BudgieKeyboardManager* self);
static void budgie_keyboard_manager_apply_layout (BudgieKeyboardManager* self,
                                           guint idx);
static void budgie_keyboard_manager_apply_ibus (BudgieKeyboardManager* self);
static void budgie_keyboard_manager_switch_input_source_backward (BudgieKeyboardManager* self,
                                                           MetaDisplay* display,
                                                           MetaWindow* window,
                                                           ClutterKeyEvent* event,
                                                           MetaKeyBinding* binding);
VALA_EXTERN void budgie_keyboard_manager_hook_extra (BudgieKeyboardManager* self);
VALA_EXTERN BudgieBudgieWM* budgie_keyboard_manager_get_wm (BudgieKeyboardManager* self);
static void _budgie_keyboard_manager_switch_input_source_meta_key_handler_func (MetaDisplay* display,
                                                                         MetaWindow* window,
                                                                         ClutterKeyEvent* event,
                                                                         MetaKeyBinding* binding,
                                                                         gpointer self);
static void _budgie_keyboard_manager_switch_input_source_backward_meta_key_handler_func (MetaDisplay* display,
                                                                                  MetaWindow* window,
                                                                                  ClutterKeyEvent* event,
                                                                                  MetaKeyBinding* binding,
                                                                                  gpointer self);
static void budgie_keyboard_manager_update_sources (BudgieKeyboardManager* self);
static void _budgie_input_source_unref0_ (gpointer var);
static void _vala_BudgieInputSource_free_function_content_of (gpointer data);
static void budgie_keyboard_manager_apply_layout_group (BudgieKeyboardManager* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void budgie_keyboard_manager_write_source_index (BudgieKeyboardManager* self,
                                                 guint index);
VALA_EXTERN void budgie_ibus_manager_set_engine (BudgieIBusManager* self,
                                     const gchar* name);
VALA_EXTERN void budgie_keyboard_manager_release_keyboard (BudgieKeyboardManager* self);
VALA_EXTERN void budgie_keyboard_manager_set_wm (BudgieKeyboardManager* self,
                                     BudgieBudgieWM* value);
static void budgie_keyboard_manager_finalize (GObject * obj);
static GType budgie_keyboard_manager_get_type_once (void);
static void _vala_budgie_keyboard_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_budgie_keyboard_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
budgie_input_method_error_quark (void)
{
	return g_quark_from_static_string ("budgie-input-method-error-quark");
}

static GType
budgie_input_method_error_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_INPUT_METHOD_ERROR_UNKNOWN_IME, "BUDGIE_INPUT_METHOD_ERROR_UNKNOWN_IME", "unknown-ime"}, {0, NULL, NULL}};
	GType budgie_input_method_error_type_id;
	budgie_input_method_error_type_id = g_enum_register_static ("BudgieInputMethodError", values);
	return budgie_input_method_error_type_id;
}

GType
budgie_input_method_error_get_type (void)
{
	static volatile gsize budgie_input_method_error_type_id__once = 0;
	if (g_once_init_enter (&budgie_input_method_error_type_id__once)) {
		GType budgie_input_method_error_type_id;
		budgie_input_method_error_type_id = budgie_input_method_error_get_type_once ();
		g_once_init_leave (&budgie_input_method_error_type_id__once, budgie_input_method_error_type_id);
	}
	return budgie_input_method_error_type_id__once;
}

BudgieInputSource*
budgie_input_source_construct (GType object_type,
                               BudgieIBusManager* iman,
                               const gchar* id,
                               guint idx,
                               const gchar* layout,
                               const gchar* variant,
                               gboolean xkb,
                               GError** error)
{
	BudgieInputSource* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	IBusEngineDesc* engine = NULL;
	gchar* e_variant = NULL;
	IBusEngineDesc* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	IBusEngineDesc* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	self = (BudgieInputSource*) g_type_create_instance (object_type);
	self->idx = idx;
	_tmp0_ = g_strdup (layout);
	_g_free0 (self->layout);
	self->layout = _tmp0_;
	_tmp1_ = g_strdup (variant);
	_g_free0 (self->variant);
	self->variant = _tmp1_;
	self->xkb = xkb;
	engine = NULL;
	if (iman != NULL) {
		IBusEngineDesc* _tmp2_;
		IBusEngineDesc* _tmp3_;
		_tmp2_ = budgie_ibus_manager_get_engine (iman, id);
		engine = _tmp2_;
		_tmp3_ = engine;
		if (_tmp3_ == NULL) {
			if (!xkb) {
				GError* _tmp4_;
				_tmp4_ = g_error_new_literal (BUDGIE_INPUT_METHOD_ERROR, BUDGIE_INPUT_METHOD_ERROR_UNKNOWN_IME, "Unknown input method: id");
				_inner_error0_ = _tmp4_;
				g_propagate_error (error, _inner_error0_);
				_budgie_input_source_unref0 (self);
				return NULL;
			}
			return self;
		}
	}
	_tmp5_ = engine;
	_tmp6_ = ibus_engine_desc_get_layout_variant (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	e_variant = _tmp8_;
	_tmp10_ = e_variant;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = e_variant;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_ > 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = e_variant;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (self->variant);
		self->variant = _tmp15_;
	}
	_tmp16_ = engine;
	_tmp17_ = ibus_engine_desc_get_layout (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (self->layout);
	self->layout = _tmp19_;
	_tmp20_ = g_strdup (id);
	_g_free0 (self->ibus_engine);
	self->ibus_engine = _tmp20_;
	_g_free0 (e_variant);
	return self;
}

BudgieInputSource*
budgie_input_source_new (BudgieIBusManager* iman,
                         const gchar* id,
                         guint idx,
                         const gchar* layout,
                         const gchar* variant,
                         gboolean xkb,
                         GError** error)
{
	return budgie_input_source_construct (BUDGIE_TYPE_INPUT_SOURCE, iman, id, idx, layout, variant, xkb, error);
}

static void
budgie_value_input_source_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_input_source_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_input_source_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_input_source_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_input_source_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_input_source_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_input_source_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieInputSource * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_input_source_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_input_source_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	BudgieInputSource ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_input_source_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_input_source (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	BudgieParamSpecInputSource* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_INPUT_SOURCE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_input_source (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_INPUT_SOURCE), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_input_source (GValue* value,
                               gpointer v_object)
{
	BudgieInputSource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_input_source_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_input_source_unref (old);
	}
}

void
budgie_value_take_input_source (GValue* value,
                                gpointer v_object)
{
	BudgieInputSource * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_input_source_unref (old);
	}
}

static void
budgie_input_source_class_init (BudgieInputSourceClass * klass,
                                gpointer klass_data)
{
	budgie_input_source_parent_class = g_type_class_peek_parent (klass);
	((BudgieInputSourceClass *) klass)->finalize = budgie_input_source_finalize;
}

static void
budgie_input_source_instance_init (BudgieInputSource * self,
                                   gpointer klass)
{
	self->xkb = FALSE;
	self->layout = NULL;
	self->variant = NULL;
	self->idx = (guint) 0;
	self->ibus_engine = NULL;
	self->ref_count = 1;
}

static void
budgie_input_source_finalize (BudgieInputSource * obj)
{
	BudgieInputSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSource);
	g_signal_handlers_destroy (self);
	_g_free0 (self->layout);
	_g_free0 (self->variant);
	_g_free0 (self->ibus_engine);
}

static GType
budgie_input_source_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_input_source_init, budgie_value_input_source_free_value, budgie_value_input_source_copy_value, budgie_value_input_source_peek_pointer, "p", budgie_value_input_source_collect_value, "p", budgie_value_input_source_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieInputSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_input_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieInputSource), 0, (GInstanceInitFunc) budgie_input_source_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_input_source_type_id;
	budgie_input_source_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieInputSource", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return budgie_input_source_type_id;
}

GType
budgie_input_source_get_type (void)
{
	static volatile gsize budgie_input_source_type_id__once = 0;
	if (g_once_init_enter (&budgie_input_source_type_id__once)) {
		GType budgie_input_source_type_id;
		budgie_input_source_type_id = budgie_input_source_get_type_once ();
		g_once_init_leave (&budgie_input_source_type_id__once, budgie_input_source_type_id);
	}
	return budgie_input_source_type_id__once;
}

gpointer
budgie_input_source_ref (gpointer instance)
{
	BudgieInputSource * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_input_source_unref (gpointer instance)
{
	BudgieInputSource * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_INPUT_SOURCE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
budgie_keyboard_manager_get_instance_private (BudgieKeyboardManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieKeyboardManager_private_offset);
}

static void
_budgie_keyboard_manager_on_ibus_ready_budgie_ibus_manager_ready (BudgieIBusManager* _sender,
                                                                  gpointer self)
{
	budgie_keyboard_manager_on_ibus_ready ((BudgieKeyboardManager*) self);
}

BudgieKeyboardManager*
budgie_keyboard_manager_construct (GType object_type,
                                   BudgieBudgieWM* wm)
{
	BudgieKeyboardManager * self = NULL;
	GnomeXkbInfo* _tmp0_;
	BudgieIBusManager* _tmp1_;
	BudgieIBusManager* _tmp2_;
	BudgieIBusManager* _tmp3_;
	self = (BudgieKeyboardManager*) g_object_new (object_type, "wm", wm, NULL);
	_tmp0_ = gnome_xkb_info_new ();
	_g_object_unref0 (self->priv->xkb);
	self->priv->xkb = _tmp0_;
	_tmp1_ = budgie_ibus_manager_new (self);
	_g_object_unref0 (self->priv->ibus_manager);
	self->priv->ibus_manager = _tmp1_;
	_tmp2_ = self->priv->ibus_manager;
	g_signal_connect_object (_tmp2_, "ready", (GCallback) _budgie_keyboard_manager_on_ibus_ready_budgie_ibus_manager_ready, self, 0);
	_tmp3_ = self->priv->ibus_manager;
	budgie_ibus_manager_do_init (_tmp3_);
	return self;
}

BudgieKeyboardManager*
budgie_keyboard_manager_new (BudgieBudgieWM* wm)
{
	return budgie_keyboard_manager_construct (BUDGIE_TYPE_KEYBOARD_MANAGER, wm);
}

static void
_budgie_keyboard_manager_on_current_source_changed_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self)
{
	budgie_keyboard_manager_on_current_source_changed ((BudgieKeyboardManager*) self);
}

static void
_budgie_keyboard_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self)
{
	budgie_keyboard_manager_on_settings_changed ((BudgieKeyboardManager*) self, key);
}

static void
budgie_keyboard_manager_on_ibus_ready (BudgieKeyboardManager* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gulong _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.input-sources");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_signal_connect_object (_tmp1_, "changed::current", (GCallback) _budgie_keyboard_manager_on_current_source_changed_g_settings_changed, self, 0);
	self->priv->sig_id = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _budgie_keyboard_manager_on_settings_changed_g_settings_changed, self, 0);
	budgie_keyboard_manager_update_fallback (self);
	budgie_keyboard_manager_on_settings_changed (self, "xkb-options");
	budgie_keyboard_manager_on_settings_changed (self, "sources");
}

static void
budgie_keyboard_manager_switch_input_source (BudgieKeyboardManager* self,
                                             MetaDisplay* display,
                                             MetaWindow* window,
                                             ClutterKeyEvent* event,
                                             MetaKeyBinding* binding)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp1_ = self->priv->sources;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GArray* _tmp2_;
		_tmp2_ = self->priv->sources;
		_tmp0_ = _tmp2_->len == ((guint) 0);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->sources;
	self->priv->current_source = (self->priv->current_source + 1) % _tmp3_->len;
	budgie_keyboard_manager_hold_keyboard (self);
	budgie_keyboard_manager_apply_layout (self, self->priv->current_source);
	budgie_keyboard_manager_apply_ibus (self);
}

static void
budgie_keyboard_manager_switch_input_source_backward (BudgieKeyboardManager* self,
                                                      MetaDisplay* display,
                                                      MetaWindow* window,
                                                      ClutterKeyEvent* event,
                                                      MetaKeyBinding* binding)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	GArray* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp1_ = self->priv->sources;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GArray* _tmp2_;
		_tmp2_ = self->priv->sources;
		_tmp0_ = _tmp2_->len == ((guint) 0);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->sources;
	self->priv->current_source = (self->priv->current_source - 1) % _tmp3_->len;
	budgie_keyboard_manager_hold_keyboard (self);
	budgie_keyboard_manager_apply_layout (self, self->priv->current_source);
	budgie_keyboard_manager_apply_ibus (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_budgie_keyboard_manager_switch_input_source_meta_key_handler_func (MetaDisplay* display,
                                                                    MetaWindow* window,
                                                                    ClutterKeyEvent* event,
                                                                    MetaKeyBinding* binding,
                                                                    gpointer self)
{
	budgie_keyboard_manager_switch_input_source ((BudgieKeyboardManager*) self, display, window, event, binding);
}

static void
_budgie_keyboard_manager_switch_input_source_backward_meta_key_handler_func (MetaDisplay* display,
                                                                             MetaWindow* window,
                                                                             ClutterKeyEvent* event,
                                                                             MetaKeyBinding* binding,
                                                                             gpointer self)
{
	budgie_keyboard_manager_switch_input_source_backward ((BudgieKeyboardManager*) self, display, window, event, binding);
}

void
budgie_keyboard_manager_hook_extra (BudgieKeyboardManager* self)
{
	MetaDisplay* display = NULL;
	BudgieBudgieWM* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	GSettings* schema = NULL;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.desktop.wm.keybindings");
	schema = _tmp3_;
	meta_display_add_keybinding (display, "switch-input-source", schema, META_KEY_BINDING_NONE, _budgie_keyboard_manager_switch_input_source_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_display_add_keybinding (display, "switch-input-source-backward", schema, META_KEY_BINDING_NONE, _budgie_keyboard_manager_switch_input_source_backward_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (schema);
	_g_object_unref0 (display);
}

static void
budgie_keyboard_manager_on_settings_changed (BudgieKeyboardManager* self,
                                             const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("sources")))) {
		switch (0) {
			default:
			{
				budgie_keyboard_manager_update_sources (self);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("xkb-options")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp3_;
				gchar** _tmp4_;
				gchar** _tmp5_;
				_tmp3_ = self->priv->settings;
				_tmp5_ = _tmp4_ = g_settings_get_strv (_tmp3_, key);
				self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
				self->priv->options = _tmp5_;
				self->priv->options_length1 = _vala_array_length (_tmp4_);
				self->priv->_options_size_ = self->priv->options_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				return;
			}
		}
	}
}

static void
_budgie_input_source_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (budgie_input_source_unref (var), NULL));
}

static void
_vala_BudgieInputSource_free_function_content_of (gpointer data)
{
	BudgieInputSource* self;
	self = *((BudgieInputSource**) data);
	_budgie_input_source_unref0_ (self);
}

static gpointer
_budgie_input_source_ref0 (gpointer self)
{
	return self ? budgie_input_source_ref (self) : NULL;
}

static void
budgie_keyboard_manager_update_sources (BudgieKeyboardManager* self)
{
	GArray* _tmp0_;
	GVariant* val = NULL;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GArray* _tmp43_;
	guint default_idx = 0U;
	GSettings* _tmp49_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (BudgieInputSource*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_BudgieInputSource_free_function_content_of);
	_g_array_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "sources");
	val = _tmp2_;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GVariant* _tmp5_;
				BudgieInputSource* source = NULL;
				gchar* id = NULL;
				gchar* type = NULL;
				GVariant* _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_;
				if (!_tmp3_) {
					gsize _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = val;
				if (!(i < g_variant_n_children (_tmp5_))) {
					break;
				}
				source = NULL;
				id = NULL;
				type = NULL;
				_tmp6_ = val;
				g_variant_get_child (_tmp6_, i, "(ss)", &_tmp7_, &_tmp8_, NULL);
				_g_free0 (id);
				id = _tmp7_;
				_g_free0 (type);
				type = _tmp8_;
				_tmp9_ = id;
				if (g_strcmp0 (_tmp9_, "xkb") == 0) {
					gchar** spl = NULL;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gchar** _tmp12_;
					gint spl_length1;
					gint _spl_size_;
					gchar* variant = NULL;
					gchar* _tmp13_;
					gchar** _tmp14_;
					gint _tmp14__length1;
					_tmp10_ = type;
					_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "+", 0);
					spl = _tmp12_;
					spl_length1 = _vala_array_length (_tmp11_);
					_spl_size_ = spl_length1;
					_tmp13_ = g_strdup ("");
					variant = _tmp13_;
					_tmp14_ = spl;
					_tmp14__length1 = spl_length1;
					if (_tmp14__length1 > 1) {
						gchar** _tmp15_;
						gint _tmp15__length1;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						_tmp15_ = spl;
						_tmp15__length1 = spl_length1;
						_tmp16_ = _tmp15_[1];
						_tmp17_ = g_strdup (_tmp16_);
						_g_free0 (variant);
						variant = _tmp17_;
					}
					{
						BudgieInputSource* _tmp18_ = NULL;
						BudgieIBusManager* _tmp19_;
						const gchar* _tmp20_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						BudgieInputSource* _tmp24_;
						BudgieInputSource* _tmp25_;
						GArray* _tmp26_;
						BudgieInputSource* _tmp27_;
						BudgieInputSource* _tmp28_;
						_tmp19_ = self->priv->ibus_manager;
						_tmp20_ = type;
						_tmp21_ = spl;
						_tmp21__length1 = spl_length1;
						_tmp22_ = _tmp21_[0];
						_tmp23_ = variant;
						_tmp24_ = budgie_input_source_new (_tmp19_, _tmp20_, (guint) i, _tmp22_, _tmp23_, TRUE, &_inner_error0_);
						_tmp18_ = _tmp24_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp25_ = _tmp18_;
						_tmp18_ = NULL;
						_budgie_input_source_unref0 (source);
						source = _tmp25_;
						_tmp26_ = self->priv->sources;
						_tmp27_ = source;
						_tmp28_ = _budgie_input_source_ref0 (_tmp27_);
						g_array_append_val (_tmp26_, _tmp28_);
						_budgie_input_source_unref0 (_tmp18_);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp29_;
						const gchar* _tmp30_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp29_ = e;
						_tmp30_ = _tmp29_->message;
						g_warning ("keyboard.vala:173: Failed to create InputSource: %s", _tmp30_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (variant);
						spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (type);
						_g_free0 (id);
						_budgie_input_source_unref0 (source);
						_g_variant_unref0 (val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_free0 (variant);
					spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
				} else {
					GArray* _tmp40_;
					BudgieInputSource* _tmp41_;
					BudgieInputSource* _tmp42_;
					{
						BudgieInputSource* _tmp31_ = NULL;
						BudgieIBusManager* _tmp32_;
						const gchar* _tmp33_;
						BudgieInputSource* _tmp34_;
						BudgieInputSource* _tmp35_;
						_tmp32_ = self->priv->ibus_manager;
						_tmp33_ = type;
						_tmp34_ = budgie_input_source_new (_tmp32_, _tmp33_, (guint) i, NULL, NULL, FALSE, &_inner_error0_);
						_tmp31_ = _tmp34_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp35_ = _tmp31_;
						_tmp31_ = NULL;
						_budgie_input_source_unref0 (source);
						source = _tmp35_;
						_budgie_input_source_unref0 (_tmp31_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						GError* _tmp38_;
						const gchar* _tmp39_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp36_ = id;
						_tmp37_ = type;
						_tmp38_ = e;
						_tmp39_ = _tmp38_->message;
						g_message ("keyboard.vala:179: Error adding source %s|%s: %s", _tmp36_, _tmp37_, _tmp39_);
						_g_error_free0 (e);
						_g_free0 (type);
						_g_free0 (id);
						_budgie_input_source_unref0 (source);
						continue;
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (type);
						_g_free0 (id);
						_budgie_input_source_unref0 (source);
						_g_variant_unref0 (val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp40_ = self->priv->sources;
					_tmp41_ = source;
					_tmp42_ = _budgie_input_source_ref0 (_tmp41_);
					g_array_append_val (_tmp40_, _tmp42_);
				}
				_g_free0 (type);
				_g_free0 (id);
				_budgie_input_source_unref0 (source);
			}
		}
	}
	_tmp43_ = self->priv->sources;
	if (_tmp43_->len == ((guint) 0)) {
		BudgieInputSource* _tmp44_;
		GArray* _tmp45_;
		GArray* _tmp46_;
		BudgieInputSource* _tmp47_;
		BudgieInputSource* _tmp48_;
		_tmp44_ = self->priv->fallback;
		_tmp45_ = self->priv->sources;
		_tmp44_->idx = _tmp45_->len;
		_tmp46_ = self->priv->sources;
		_tmp47_ = self->priv->fallback;
		_tmp48_ = _budgie_input_source_ref0 (_tmp47_);
		g_array_append_val (_tmp46_, _tmp48_);
	}
	budgie_keyboard_manager_hold_keyboard (self);
	budgie_keyboard_manager_apply_layout_group (self);
	_tmp49_ = self->priv->settings;
	default_idx = g_settings_get_uint (_tmp49_, "current");
	budgie_keyboard_manager_apply_layout (self, default_idx);
	budgie_keyboard_manager_apply_ibus (self);
	_g_variant_unref0 (val);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static void
budgie_keyboard_manager_apply_layout_group (BudgieKeyboardManager* self)
{
	BudgieInputSource* source = NULL;
	gchar** layouts = NULL;
	gchar** _tmp0_;
	gint layouts_length1;
	gint _layouts_size_;
	gchar** variants = NULL;
	gchar** _tmp1_;
	gint variants_length1;
	gint _variants_size_;
	gchar* slayouts = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar* svariants = NULL;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* options = NULL;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	MetaBackend* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	layouts = _tmp0_;
	layouts_length1 = 0;
	_layouts_size_ = layouts_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	variants = _tmp1_;
	variants_length1 = 0;
	_variants_size_ = variants_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				GArray* _tmp5_;
				BudgieInputSource* _tmp6_;
				BudgieInputSource* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				BudgieInputSource* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->sources;
				if (!(i < _tmp4_->len)) {
					break;
				}
				_tmp5_ = self->priv->sources;
				_tmp6_ = g_array_index (_tmp5_, BudgieInputSource*, i);
				source = _tmp6_;
				_tmp7_ = source;
				_tmp8_ = _tmp7_->layout;
				_tmp9_ = g_strdup (_tmp8_);
				_vala_array_add1 (&layouts, &layouts_length1, &_layouts_size_, _tmp9_);
				_tmp10_ = source;
				_tmp11_ = _tmp10_->variant;
				_tmp12_ = g_strdup (_tmp11_);
				_vala_array_add2 (&variants, &variants_length1, &_variants_size_, _tmp12_);
			}
		}
	}
	_tmp13_ = layouts;
	_tmp13__length1 = layouts_length1;
	_tmp14_ = _vala_g_strjoinv (",", _tmp13_, (gint) _tmp13__length1);
	slayouts = _tmp14_;
	_tmp15_ = variants;
	_tmp15__length1 = variants_length1;
	_tmp16_ = _vala_g_strjoinv (",", _tmp15_, (gint) _tmp15__length1);
	svariants = _tmp16_;
	_tmp17_ = self->priv->options;
	_tmp17__length1 = self->priv->options_length1;
	_tmp18_ = _vala_g_strjoinv (",", _tmp17_, (gint) _tmp17__length1);
	options = _tmp18_;
	_tmp19_ = meta_get_backend ();
	meta_backend_set_keymap (_tmp19_, slayouts, svariants, options);
	_g_free0 (options);
	_g_free0 (svariants);
	_g_free0 (slayouts);
	variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
	layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
}

static void
budgie_keyboard_manager_apply_layout (BudgieKeyboardManager* self,
                                      guint idx)
{
	GArray* _tmp0_;
	MetaBackend* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sources;
	if (idx > _tmp0_->len) {
		idx = (guint) 0;
	}
	self->priv->current_source = idx;
	_tmp1_ = meta_get_backend ();
	meta_backend_lock_layout_group (_tmp1_, idx);
	budgie_keyboard_manager_write_source_index (self, idx);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
budgie_keyboard_manager_update_fallback (BudgieKeyboardManager* self)
{
	gchar* type = NULL;
	gchar* id = NULL;
	gchar* locale = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* display_name = NULL;
	gchar* short_name = NULL;
	gchar* xkb_layout = NULL;
	gchar* xkb_variant = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GnomeXkbInfo* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	type = NULL;
	id = NULL;
	_tmp1_ = _tmp0_ = g_get_language_names ();
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_strdup (_tmp2_);
	locale = _tmp3_;
	display_name = NULL;
	short_name = NULL;
	xkb_layout = NULL;
	xkb_variant = NULL;
	_tmp4_ = locale;
	if (!string_contains (_tmp4_, "_")) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (BUDGIE_DEFAULT_LOCALE);
		_g_free0 (locale);
		locale = _tmp5_;
	}
	_tmp6_ = locale;
	_tmp9_ = gnome_get_input_source_from_locale (_tmp6_, &_tmp7_, &_tmp8_);
	_g_free0 (type);
	_tmp10_ = g_strdup (_tmp7_);
	type = _tmp10_;
	_g_free0 (id);
	_tmp11_ = g_strdup (_tmp8_);
	id = _tmp11_;
	if (!_tmp9_) {
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gnome_get_input_source_from_locale (BUDGIE_DEFAULT_LOCALE, &_tmp12_, &_tmp13_);
		_g_free0 (type);
		_tmp14_ = g_strdup (_tmp12_);
		type = _tmp14_;
		_g_free0 (id);
		_tmp15_ = g_strdup (_tmp13_);
		id = _tmp15_;
	}
	_tmp16_ = self->priv->xkb;
	_tmp17_ = id;
	_tmp22_ = gnome_xkb_info_get_layout_info (_tmp16_, _tmp17_, &_tmp18_, &_tmp19_, &_tmp20_, &_tmp21_);
	_g_free0 (display_name);
	_tmp23_ = g_strdup (_tmp18_);
	display_name = _tmp23_;
	_g_free0 (short_name);
	_tmp24_ = g_strdup (_tmp19_);
	short_name = _tmp24_;
	_g_free0 (xkb_layout);
	_tmp25_ = g_strdup (_tmp20_);
	xkb_layout = _tmp25_;
	_g_free0 (xkb_variant);
	_tmp26_ = g_strdup (_tmp21_);
	xkb_variant = _tmp26_;
	if (_tmp22_) {
		{
			BudgieInputSource* _tmp27_ = NULL;
			BudgieIBusManager* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			BudgieInputSource* _tmp32_;
			BudgieInputSource* _tmp33_;
			_tmp28_ = self->priv->ibus_manager;
			_tmp29_ = id;
			_tmp30_ = xkb_layout;
			_tmp31_ = xkb_variant;
			_tmp32_ = budgie_input_source_new (_tmp28_, _tmp29_, (guint) 0, _tmp30_, _tmp31_, TRUE, &_inner_error0_);
			_tmp27_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp33_ = _tmp27_;
			_tmp27_ = NULL;
			_budgie_input_source_unref0 (self->priv->fallback);
			self->priv->fallback = _tmp33_;
			_budgie_input_source_unref0 (_tmp27_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp34_;
			const gchar* _tmp35_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp34_ = e;
			_tmp35_ = _tmp34_->message;
			g_warning ("keyboard.vala:254: Failed to create InputSource: %s", _tmp35_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_free0 (short_name);
			_g_free0 (display_name);
			_g_free0 (locale);
			_g_free0 (id);
			_g_free0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		{
			BudgieInputSource* _tmp36_ = NULL;
			BudgieIBusManager* _tmp37_;
			const gchar* _tmp38_;
			BudgieInputSource* _tmp39_;
			BudgieInputSource* _tmp40_;
			_tmp37_ = self->priv->ibus_manager;
			_tmp38_ = id;
			_tmp39_ = budgie_input_source_new (_tmp37_, _tmp38_, (guint) 0, BUDGIE_DEFAULT_LAYOUT, BUDGIE_DEFAULT_VARIANT, TRUE, &_inner_error0_);
			_tmp36_ = _tmp39_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp40_ = _tmp36_;
			_tmp36_ = NULL;
			_budgie_input_source_unref0 (self->priv->fallback);
			self->priv->fallback = _tmp40_;
			_budgie_input_source_unref0 (_tmp36_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp41_;
			const gchar* _tmp42_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			g_warning ("keyboard.vala:260: Failed to create InputSource: %s", _tmp42_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_free0 (short_name);
			_g_free0 (display_name);
			_g_free0 (locale);
			_g_free0 (id);
			_g_free0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	_g_free0 (short_name);
	_g_free0 (display_name);
	_g_free0 (locale);
	_g_free0 (id);
	_g_free0 (type);
}

/**
* Update the index in gsettings so that clients know the current
*/
static void
budgie_keyboard_manager_write_source_index (BudgieKeyboardManager* self,
                                            guint index)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_signal_handler_block (_tmp0_, self->priv->sig_id);
	_tmp1_ = self->priv->settings;
	g_settings_set_uint (_tmp1_, "current", index);
	_tmp2_ = self->priv->settings;
	g_settings_apply (_tmp2_);
	_tmp3_ = self->priv->settings;
	g_signal_handler_unblock (_tmp3_, self->priv->sig_id);
}

/**
* Someone else changed the current source, do somethin' about it
*/
static void
budgie_keyboard_manager_on_current_source_changed (BudgieKeyboardManager* self)
{
	guint new_source = 0U;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	new_source = g_settings_get_uint (_tmp0_, "current");
	budgie_keyboard_manager_hold_keyboard (self);
	budgie_keyboard_manager_apply_layout (self, new_source);
	budgie_keyboard_manager_apply_ibus (self);
}

/**
* Apply the ibus engine and then release the keyboard
*/
static void
budgie_keyboard_manager_apply_ibus (BudgieKeyboardManager* self)
{
	gchar* engine_name = NULL;
	BudgieInputSource* current = NULL;
	GArray* _tmp0_;
	BudgieInputSource* _tmp1_;
	BudgieInputSource* _tmp2_;
	gboolean _tmp3_ = FALSE;
	BudgieInputSource* _tmp4_;
	BudgieIBusManager* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sources;
	_tmp1_ = g_array_index (_tmp0_, BudgieInputSource*, self->priv->current_source);
	_tmp2_ = _budgie_input_source_ref0 (_tmp1_);
	current = _tmp2_;
	_tmp4_ = current;
	if (_tmp4_ != NULL) {
		BudgieInputSource* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = current;
		_tmp6_ = _tmp5_->ibus_engine;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		BudgieInputSource* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = current;
		_tmp8_ = _tmp7_->ibus_engine;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (engine_name);
		engine_name = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (BUDGIE_DEFAULT_ENGINE);
		_g_free0 (engine_name);
		engine_name = _tmp10_;
	}
	_tmp11_ = self->priv->ibus_manager;
	_tmp12_ = engine_name;
	budgie_ibus_manager_set_engine (_tmp11_, _tmp12_);
	_budgie_input_source_unref0 (current);
	_g_free0 (engine_name);
}

/**
* Unfreeze the keyboard
*/
void
budgie_keyboard_manager_release_keyboard (BudgieKeyboardManager* self)
{
	BudgieBudgieWM* _tmp0_;
	MetaDisplay* _tmp1_;
	BudgieBudgieWM* _tmp2_;
	MetaDisplay* _tmp3_;
	g_return_if_fail (self != NULL);
	if (!self->priv->is_keyboard_held) {
		return;
	}
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	meta_display_ungrab_keyboard (_tmp1_, meta_display_get_current_time (_tmp3_));
	self->priv->is_keyboard_held = FALSE;
}

/**
* Freeze the keyboard so we don't loose input events
*/
void
budgie_keyboard_manager_hold_keyboard (BudgieKeyboardManager* self)
{
	BudgieBudgieWM* _tmp0_;
	MetaDisplay* _tmp1_;
	BudgieBudgieWM* _tmp2_;
	MetaDisplay* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->is_keyboard_held) {
		return;
	}
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	meta_display_freeze_keyboard (_tmp1_, meta_display_get_current_time (_tmp3_));
	self->priv->is_keyboard_held = TRUE;
}

BudgieBudgieWM*
budgie_keyboard_manager_get_wm (BudgieKeyboardManager* self)
{
	BudgieBudgieWM* result;
	BudgieBudgieWM* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

void
budgie_keyboard_manager_set_wm (BudgieKeyboardManager* self,
                                BudgieBudgieWM* value)
{
	BudgieBudgieWM* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_keyboard_manager_get_wm (self);
	if (old_value != value) {
		self->priv->_wm = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_keyboard_manager_properties[BUDGIE_KEYBOARD_MANAGER_WM_PROPERTY]);
	}
}

static void
budgie_keyboard_manager_class_init (BudgieKeyboardManagerClass * klass,
                                    gpointer klass_data)
{
	budgie_keyboard_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieKeyboardManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_keyboard_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_keyboard_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_keyboard_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_KEYBOARD_MANAGER_WM_PROPERTY, budgie_keyboard_manager_properties[BUDGIE_KEYBOARD_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", BUDGIE_TYPE_BUDGIE_WM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
budgie_keyboard_manager_instance_init (BudgieKeyboardManager * self,
                                       gpointer klass)
{
	gchar** _tmp0_;
	self->priv = budgie_keyboard_manager_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->options = _tmp0_;
	self->priv->options_length1 = 0;
	self->priv->_options_size_ = self->priv->options_length1;
	self->priv->settings = NULL;
	self->priv->sources = NULL;
	self->priv->current_source = (guint) 0;
	self->priv->sig_id = (gulong) 0;
	self->priv->is_keyboard_held = FALSE;
}

static void
budgie_keyboard_manager_finalize (GObject * obj)
{
	BudgieKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager);
	_g_object_unref0 (self->priv->xkb);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->settings);
	_g_array_unref0 (self->priv->sources);
	_budgie_input_source_unref0 (self->priv->fallback);
	_g_object_unref0 (self->priv->ibus_manager);
	G_OBJECT_CLASS (budgie_keyboard_manager_parent_class)->finalize (obj);
}

static GType
budgie_keyboard_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieKeyboardManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_keyboard_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieKeyboardManager), 0, (GInstanceInitFunc) budgie_keyboard_manager_instance_init, NULL };
	GType budgie_keyboard_manager_type_id;
	budgie_keyboard_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieKeyboardManager", &g_define_type_info, 0);
	BudgieKeyboardManager_private_offset = g_type_add_instance_private (budgie_keyboard_manager_type_id, sizeof (BudgieKeyboardManagerPrivate));
	return budgie_keyboard_manager_type_id;
}

GType
budgie_keyboard_manager_get_type (void)
{
	static volatile gsize budgie_keyboard_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_keyboard_manager_type_id__once)) {
		GType budgie_keyboard_manager_type_id;
		budgie_keyboard_manager_type_id = budgie_keyboard_manager_get_type_once ();
		g_once_init_leave (&budgie_keyboard_manager_type_id__once, budgie_keyboard_manager_type_id);
	}
	return budgie_keyboard_manager_type_id__once;
}

static void
_vala_budgie_keyboard_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	BudgieKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager);
	switch (property_id) {
		case BUDGIE_KEYBOARD_MANAGER_WM_PROPERTY:
		g_value_set_object (value, budgie_keyboard_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_keyboard_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	BudgieKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager);
	switch (property_id) {
		case BUDGIE_KEYBOARD_MANAGER_WM_PROPERTY:
		budgie_keyboard_manager_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

