/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;

public class FileRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private File baseDir = null;
    private boolean local = true;

    @Override
    public Resource getResource(String string) throws IOException {
        FileRepository fileRepository = this;
        return new FileResource(fileRepository, fileRepository.getFile(string));
    }

    @Override
    public void get(String string, File file) throws IOException {
        FileRepository fileRepository = this;
        fileRepository.fireTransferInitiated(fileRepository.getResource(string), 5);
        FileRepository fileRepository2 = this;
        fileRepository2.copy(fileRepository2.getFile(string), file, true);
    }

    private void copy(File file, File file2, boolean bl) throws IOException {
        try {
            this.getProgressListener().setTotalLength(new Long(file.length()));
            if (!FileUtil.copy(file, file2, (CopyProgressListener)this.getProgressListener(), bl)) {
                if (!bl && file2.exists()) {
                    throw new IOException("file copy not done from " + file + " to " + file2 + ": destination already exists and overwrite is false");
                }
                throw new IOException("file copy not done from " + file + " to " + file2);
            }
            return;
        }
        catch (IOException iOException) {
            this.fireTransferError(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.fireTransferError(runtimeException);
            throw runtimeException;
        }
        finally {
            this.getProgressListener().setTotalLength(null);
        }
    }

    protected RepositoryCopyProgressListener getProgressListener() {
        return this.progress;
    }

    @Override
    public List list(String string) throws IOException {
        String[] stringArray = this.getFile(string);
        if (stringArray.exists() && stringArray.isDirectory() && (stringArray = stringArray.list()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(string + this.getFileSeparator() + stringArray[i]);
            }
            return arrayList;
        }
        return null;
    }

    File getFile(String string) {
        if (this.baseDir != null) {
            return FileUtil.resolveFile(this.baseDir, string);
        }
        return Checks.checkAbsolute(string, "source");
    }

    public boolean isLocal() {
        return this.local;
    }

    @Override
    public String standardize(String string) {
        if (this.baseDir != null) {
            return FileUtil.resolveFile(this.baseDir, string).getPath();
        }
        return FileUtil.normalize(string).getPath();
    }

    @Override
    public String getFileSeparator() {
        return File.separator;
    }
}

