/**
 * **IMPORTANT** this module should not depend on `vscode-languageserver` only protocol and types
 */
import * as lsp from 'vscode-languageserver-protocol';
import type tsp from 'typescript/lib/protocol.d.js';
export declare namespace TypeScriptRenameRequest {
    const type: lsp.RequestType<lsp.TextDocumentPositionParams, void, void>;
}
export declare class DisplayPartKind {
    static readonly functionName = "functionName";
    static readonly methodName = "methodName";
    static readonly parameterName = "parameterName";
    static readonly propertyName = "propertyName";
    static readonly punctuation = "punctuation";
    static readonly text = "text";
}
export interface SupportedFeatures {
    codeActionDisabledSupport?: boolean;
    completionInsertReplaceSupport?: boolean;
    completionLabelDetails?: boolean;
    completionSnippets?: boolean;
    definitionLinkSupport?: boolean;
    diagnosticsTagSupport?: boolean;
}
export interface TypeScriptPlugin {
    name: string;
    location: string;
}
export interface TypeScriptInitializationOptions {
    disableAutomaticTypingAcquisition?: boolean;
    logVerbosity?: string;
    maxTsServerMemory?: number;
    npmLocation?: string;
    locale?: string;
    plugins: TypeScriptPlugin[];
    preferences?: tsp.UserPreferences;
    hostInfo?: string;
}
export declare type TypeScriptInitializeParams = lsp.InitializeParams & {
    initializationOptions?: Partial<TypeScriptInitializationOptions>;
};
export interface TypeScriptInitializeResult extends lsp.InitializeResult {
    logFileUri?: string;
}
//# sourceMappingURL=ts-protocol.d.ts.map