/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/*
 * Copyright (C) 2022 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
import fs from 'node:fs';
import { temporaryFile } from 'tempy';
const noopRequestCanceller = new class {
    constructor() {
        this.cancellationPipeName = undefined;
    }
    tryCancelOngoingRequest(_seq) {
        return false;
    }
};
export const noopRequestCancellerFactory = new class {
    create( /*_serverId: string, _tracer: Tracer*/) {
        return noopRequestCanceller;
    }
};
export class NodeRequestCanceller {
    constructor(
    // private readonly _serverId: string,
    // private readonly _tracer: Tracer,
    ) {
        this.cancellationPipeName = temporaryFile({ name: 'tscancellation' });
    }
    tryCancelOngoingRequest(seq) {
        if (!this.cancellationPipeName) {
            return false;
        }
        // this._tracer.logTrace(this._serverId, `TypeScript Server: trying to cancel ongoing request with sequence number ${seq}`);
        try {
            fs.writeFileSync(this.cancellationPipeName + String(seq), '');
        }
        catch {
            // noop
        }
        return true;
    }
}
export const nodeRequestCancellerFactory = new class {
    create( /*serverId: string, tracer: Tracer*/) {
        return new NodeRequestCanceller( /*serverId, tracer*/);
    }
};
//# sourceMappingURL=cancellation.js.map