/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
import API from '../utils/api.js';
import { ServerType } from './requests.js';
import { nodeRequestCancellerFactory } from './cancellation.js';
import { ProcessBasedTsServer } from './server.js';
import { NodeTsServerProcessFactory } from './serverProcess.js';
export class TypeScriptServerSpawner {
    constructor(_apiVersion, 
    // private readonly _logDirectoryProvider: ILogDirectoryProvider,
    _logger) {
        this._apiVersion = _apiVersion;
        this._logger = _logger;
    }
    spawn(version, configuration) {
        const kind = "main" /* TsServerProcessKind.Main */;
        const processFactory = new NodeTsServerProcessFactory();
        const canceller = nodeRequestCancellerFactory.create( /*kind, this._tracer*/);
        const { args, tsServerLogFile } = this.getTsServerArgs("main" /* TsServerProcessKind.Main */, configuration, this._apiVersion, canceller.cancellationPipeName);
        const process = processFactory.fork(version, args, "main" /* TsServerProcessKind.Main */, configuration);
        this._logger.log('Starting tsserver');
        return new ProcessBasedTsServer(kind, this.kindToServerType(kind), process, tsServerLogFile, canceller, version);
    }
    kindToServerType(kind) {
        switch (kind) {
            case "syntax" /* TsServerProcessKind.Syntax */:
                return ServerType.Syntax;
            case "main" /* TsServerProcessKind.Main */:
            case "semantic" /* TsServerProcessKind.Semantic */:
            case "diagnostics" /* TsServerProcessKind.Diagnostics */:
            default:
                return ServerType.Semantic;
        }
    }
    getTsServerArgs(kind, configuration, 
    // currentVersion: TypeScriptVersion,
    apiVersion, cancellationPipeName) {
        const args = [];
        let tsServerLogFile;
        let tsServerTraceDirectory;
        if (kind === "syntax" /* TsServerProcessKind.Syntax */) {
            if (apiVersion.gte(API.v401)) {
                args.push('--serverMode', 'partialSemantic');
            }
            else {
                args.push('--syntaxOnly');
            }
        }
        if (apiVersion.gte(API.v250)) {
            args.push('--useInferredProjectPerProjectRoot');
        }
        else {
            args.push('--useSingleInferredProject');
        }
        const { disableAutomaticTypingAcquisition, globalPlugins, locale, logFile, logVerbosity, npmLocation, pluginProbeLocations, } = configuration;
        if (disableAutomaticTypingAcquisition || kind === "syntax" /* TsServerProcessKind.Syntax */ || kind === "diagnostics" /* TsServerProcessKind.Diagnostics */) {
            args.push('--disableAutomaticTypingAcquisition');
        }
        // if (kind === TsServerProcessKind.Semantic || kind === TsServerProcessKind.Main) {
        //     args.push('--enableTelemetry');
        // }
        if (cancellationPipeName) {
            args.push('--cancellationPipeName', cancellationPipeName + '*');
        }
        // if (TspClient.isLoggingEnabled(configuration)) {
        //     const logDir = this._logDirectoryProvider.getNewLogDirectory();
        //     if (logDir) {
        //         tsServerLogFile = path.join(logDir, 'tsserver.log');
        //         args.push('--logVerbosity', TsServerLogLevel.toString(configuration.tsServerLogLevel));
        //         args.push('--logFile', tsServerLogFile);
        //     }
        // }
        if (logFile) {
            args.push('--logFile', logFile);
        }
        if (logVerbosity) {
            args.push('--logVerbosity', logVerbosity);
        }
        // if (configuration.enableTsServerTracing) {
        //     tsServerTraceDirectory = this._logDirectoryProvider.getNewLogDirectory();
        //     if (tsServerTraceDirectory) {
        //         args.push('--traceDirectory', tsServerTraceDirectory);
        //     }
        // }
        // const pluginPaths = this._pluginPathsProvider.getPluginPaths();
        // if (pluginManager.plugins.length) {
        //     args.push('--globalPlugins', pluginManager.plugins.map(x => x.name).join(','));
        //     const isUsingBundledTypeScriptVersion = currentVersion.path === this._versionProvider.defaultVersion.path;
        //     for (const plugin of pluginManager.plugins) {
        //         if (isUsingBundledTypeScriptVersion || plugin.enableForWorkspaceTypeScriptVersions) {
        //             pluginPaths.push(isWeb() ? plugin.uri.toString() : plugin.uri.fsPath);
        //         }
        //     }
        // }
        // if (pluginPaths.length !== 0) {
        //     args.push('--pluginProbeLocations', pluginPaths.join(','));
        // }
        if (globalPlugins && globalPlugins.length) {
            args.push('--globalPlugins', globalPlugins.join(','));
        }
        if (pluginProbeLocations && pluginProbeLocations.length) {
            args.push('--pluginProbeLocations', pluginProbeLocations.join(','));
        }
        if (npmLocation) {
            this._logger.info(`using npm from ${npmLocation}`);
            args.push('--npmLocation', `"${npmLocation}"`);
        }
        args.push('--locale', locale || 'en');
        // args.push('--noGetErrOnBackgroundUpdate');
        args.push('--validateDefaultNpmLocation');
        return { args, tsServerLogFile, tsServerTraceDirectory };
    }
}
//# sourceMappingURL=spawner.js.map