/* rygel-lms-all-videos.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-lms-all-videos.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-lms.h"
#include <sqlite3.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include "rygel-db.h"

#define RYGEL_LMS_ALL_VIDEOS_SQL_ALL "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_COUNT "SELECT count(videos.id) " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_FIND_OBJECT "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND files.id = ? AND videos.id = files.id;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_ADDED "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_REMOVED "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime <> 0 AND videos.id = files.id " "AND update_id > ? AND update_id <= ?;"

enum  {
	RYGEL_LMS_ALL_VIDEOS_0_PROPERTY,
	RYGEL_LMS_ALL_VIDEOS_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_all_videos_properties[RYGEL_LMS_ALL_VIDEOS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_database_cursor_iterator_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static gpointer rygel_lms_all_videos_parent_class = NULL;

static RygelMediaObject* rygel_lms_all_videos_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                                   sqlite3_stmt* statement);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static GType rygel_lms_all_videos_get_type_once (void);

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static RygelMediaObject*
rygel_lms_all_videos_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                 sqlite3_stmt* statement)
{
	RygelLMSAllVideos * self;
	gint id = 0;
	gchar* mime_type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* file = NULL;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gchar* title = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	RygelVideoItem* video = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelVideoItem* _tmp17_;
	RygelVideoItem* _tmp18_;
	RygelVideoItem* _tmp19_;
	const gchar* _tmp20_;
	RygelVideoItem* _tmp21_;
	GDateTime* dt = NULL;
	GDateTime* _tmp22_;
	RygelVideoItem* _tmp23_;
	GDateTime* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	RygelVideoItem* _tmp29_;
	RygelVideoItem* _tmp30_;
	const gchar* _tmp31_;
	RygelVideoItem* _tmp32_;
	const gchar* _tmp33_;
	RygelVideoItem* _tmp34_;
	GFile* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* video_data = NULL;
	gchar* _tmp38_;
	GError* _inner_error0_ = NULL;
	RygelMediaObject* result;
	self = (RygelLMSAllVideos*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	id = sqlite3_column_int (statement, 0);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, 8);
	_tmp1_ = g_strdup (_tmp0_);
	mime_type = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, 4);
	_tmp3_ = g_strdup (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	file = _tmp5_;
	_tmp7_ = mime_type;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = mime_type;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ == 0;
	}
	if (_tmp6_) {
		const gchar* _tmp11_;
		_tmp11_ = path;
		g_debug ("rygel-lms-all-videos.vala:77: Video item %d (%s) has no MIME type", id, _tmp11_);
	}
	_tmp12_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp13_ = g_strdup (_tmp12_);
	title = _tmp13_;
	_tmp14_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, id);
	_tmp15_ = _tmp14_;
	_tmp16_ = title;
	_tmp17_ = rygel_video_item_new (_tmp15_, (RygelMediaContainer*) self, _tmp16_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	video = _tmp18_;
	_tmp19_ = video;
	_tmp20_ = (const gchar*) sqlite3_column_text (statement, 2);
	rygel_media_object_set_creator ((RygelMediaObject*) _tmp19_, _tmp20_);
	_tmp21_ = video;
	rygel_audio_item_set_duration ((RygelAudioItem*) _tmp21_, (glong) sqlite3_column_int (statement, 3));
	_tmp22_ = g_date_time_new_from_unix_utc ((gint64) ((glong) sqlite3_column_int (statement, 5)));
	dt = _tmp22_;
	_tmp23_ = video;
	_tmp24_ = dt;
	_tmp25_ = g_date_time_format (_tmp24_, "%Y-%m-%dT%H:%M:%S");
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strdup_printf ("%sZ", _tmp26_);
	_tmp28_ = _tmp27_;
	rygel_media_object_set_date ((RygelMediaObject*) _tmp23_, _tmp28_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp29_ = video;
	rygel_media_file_item_set_size ((RygelMediaFileItem*) _tmp29_, (gint64) sqlite3_column_int (statement, 6));
	_tmp30_ = video;
	_tmp31_ = (const gchar*) sqlite3_column_text (statement, 7);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) _tmp30_, _tmp31_);
	_tmp32_ = video;
	_tmp33_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) _tmp32_, _tmp33_);
	_tmp34_ = video;
	_tmp35_ = file;
	_tmp36_ = g_file_get_uri (_tmp35_);
	_tmp37_ = _tmp36_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp34_, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = g_strdup ("select videos_videos.bitrate + videos_audios.bitrate, width, height, c" \
"hannels, sampling_rate " "from videos, videos_audios, videos_videos where videos.id = ? " "and videos.id = videos_audios.video_id and videos.id = videos_videos.v" \
"ideo_id;");
	video_data = _tmp38_;
	{
		GValue* args = NULL;
		GValue _tmp39_ = {0};
		GValue* _tmp40_;
		gint args_length1;
		gint _args_size_;
		RygelDatabaseCursor* cursor = NULL;
		RygelLMSDatabase* _tmp41_;
		RygelLMSDatabase* _tmp42_;
		const gchar* _tmp43_;
		GValue* _tmp44_;
		gint _tmp44__length1;
		RygelDatabaseCursor* _tmp45_;
		g_value_init (&_tmp39_, G_TYPE_INT);
		g_value_set_int (&_tmp39_, id);
		_tmp40_ = g_new0 (GValue, 1);
		_tmp40_[0] = _tmp39_;
		args = _tmp40_;
		args_length1 = 1;
		_args_size_ = args_length1;
		_tmp41_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = video_data;
		_tmp44_ = args;
		_tmp44__length1 = args_length1;
		_tmp45_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp42_, _tmp43_, _tmp44_, (gint) _tmp44__length1, &_inner_error0_);
		cursor = _tmp45_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch0_rygel_database_database_error;
			}
			_g_free0 (video_data);
			_g_date_time_unref0 (dt);
			_g_object_unref0 (video);
			_g_free0 (title);
			_g_object_unref0 (file);
			_g_free0 (path);
			_g_free0 (mime_type);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			RygelDatabaseCursorIterator* _stmt_it = NULL;
			RygelDatabaseCursor* _tmp46_;
			RygelDatabaseCursorIterator* _tmp47_;
			_tmp46_ = cursor;
			_tmp47_ = rygel_database_cursor_iterator (_tmp46_);
			_stmt_it = _tmp47_;
			while (TRUE) {
				gboolean _tmp48_ = FALSE;
				RygelDatabaseCursorIterator* _tmp49_;
				sqlite3_stmt* stmt = NULL;
				RygelDatabaseCursorIterator* _tmp50_;
				sqlite3_stmt* _tmp51_;
				RygelVideoItem* _tmp52_;
				sqlite3_stmt* _tmp53_;
				RygelVideoItem* _tmp54_;
				sqlite3_stmt* _tmp55_;
				RygelVideoItem* _tmp56_;
				sqlite3_stmt* _tmp57_;
				RygelVideoItem* _tmp58_;
				sqlite3_stmt* _tmp59_;
				RygelVideoItem* _tmp60_;
				sqlite3_stmt* _tmp61_;
				_tmp49_ = _stmt_it;
				_tmp48_ = rygel_database_cursor_iterator_next (_tmp49_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch0_rygel_database_database_error;
					}
					_g_free0 (video_data);
					_g_date_time_unref0 (dt);
					_g_object_unref0 (video);
					_g_free0 (title);
					_g_object_unref0 (file);
					_g_free0 (path);
					_g_free0 (mime_type);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				if (!_tmp48_) {
					break;
				}
				_tmp50_ = _stmt_it;
				_tmp51_ = rygel_database_cursor_iterator_get (_tmp50_, &_inner_error0_);
				stmt = _tmp51_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch0_rygel_database_database_error;
					}
					_g_free0 (video_data);
					_g_date_time_unref0 (dt);
					_g_object_unref0 (video);
					_g_free0 (title);
					_g_object_unref0 (file);
					_g_free0 (path);
					_g_free0 (mime_type);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp52_ = video;
				_tmp53_ = stmt;
				rygel_audio_item_set_bitrate ((RygelAudioItem*) _tmp52_, sqlite3_column_int (_tmp53_, 0) / 8);
				_tmp54_ = video;
				_tmp55_ = stmt;
				rygel_visual_item_set_width ((RygelVisualItem*) _tmp54_, sqlite3_column_int (_tmp55_, 1));
				_tmp56_ = video;
				_tmp57_ = stmt;
				rygel_visual_item_set_height ((RygelVisualItem*) _tmp56_, sqlite3_column_int (_tmp57_, 2));
				_tmp58_ = video;
				_tmp59_ = stmt;
				rygel_audio_item_set_channels ((RygelAudioItem*) _tmp58_, sqlite3_column_int (_tmp59_, 3));
				_tmp60_ = video;
				_tmp61_ = stmt;
				rygel_audio_item_set_sample_freq ((RygelAudioItem*) _tmp60_, sqlite3_column_int (_tmp61_, 4));
			}
			_rygel_database_cursor_iterator_unref0 (_stmt_it);
		}
		_g_object_unref0 (cursor);
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	goto __finally0;
	__catch0_rygel_database_database_error:
	{
		GError* e = NULL;
		GError* _tmp62_;
		const gchar* _tmp63_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp62_ = e;
		_tmp63_ = _tmp62_->message;
		g_warning ("rygel-lms-all-videos.vala:109: Query failed: %s", _tmp63_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (video_data);
		_g_date_time_unref0 (dt);
		_g_object_unref0 (video);
		_g_free0 (title);
		_g_object_unref0 (file);
		_g_free0 (path);
		_g_free0 (mime_type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = (RygelMediaObject*) video;
	_g_free0 (video_data);
	_g_date_time_unref0 (dt);
	_g_free0 (title);
	_g_object_unref0 (file);
	_g_free0 (path);
	_g_free0 (mime_type);
	return result;
}

RygelLMSAllVideos*
rygel_lms_all_videos_construct (GType object_type,
                                const gchar* id,
                                RygelMediaContainer* parent,
                                const gchar* title,
                                RygelLMSDatabase* lms_db)
{
	RygelLMSAllVideos * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	self = (RygelLMSAllVideos*) rygel_lms_category_container_construct (object_type, id, parent, title, lms_db, RYGEL_LMS_ALL_VIDEOS_SQL_ALL, RYGEL_LMS_ALL_VIDEOS_SQL_FIND_OBJECT, RYGEL_LMS_ALL_VIDEOS_SQL_COUNT, RYGEL_LMS_ALL_VIDEOS_SQL_ADDED, RYGEL_LMS_ALL_VIDEOS_SQL_REMOVED);
	return self;
}

RygelLMSAllVideos*
rygel_lms_all_videos_new (const gchar* id,
                          RygelMediaContainer* parent,
                          const gchar* title,
                          RygelLMSDatabase* lms_db)
{
	return rygel_lms_all_videos_construct (RYGEL_LMS_TYPE_ALL_VIDEOS, id, parent, title, lms_db);
}

static void
rygel_lms_all_videos_class_init (RygelLMSAllVideosClass * klass,
                                 gpointer klass_data)
{
	rygel_lms_all_videos_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_all_videos_real_object_from_statement;
}

static void
rygel_lms_all_videos_instance_init (RygelLMSAllVideos * self,
                                    gpointer klass)
{
}

static GType
rygel_lms_all_videos_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAllVideosClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_all_videos_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAllVideos), 0, (GInstanceInitFunc) rygel_lms_all_videos_instance_init, NULL };
	GType rygel_lms_all_videos_type_id;
	rygel_lms_all_videos_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAllVideos", &g_define_type_info, 0);
	return rygel_lms_all_videos_type_id;
}

GType
rygel_lms_all_videos_get_type (void)
{
	static volatile gsize rygel_lms_all_videos_type_id__once = 0;
	if (g_once_init_enter (&rygel_lms_all_videos_type_id__once)) {
		GType rygel_lms_all_videos_type_id;
		rygel_lms_all_videos_type_id = rygel_lms_all_videos_get_type_once ();
		g_once_init_leave (&rygel_lms_all_videos_type_id__once, rygel_lms_all_videos_type_id);
	}
	return rygel_lms_all_videos_type_id__once;
}

