/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
#include <qmatrix4x4.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qtransform.sip"
#include <qtransform.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qvector3d.sip"
#include <qvector3d.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qvector4d.sip"
#include <qvector4d.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 98 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 164 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 51 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qquaternion.sip"
#include <qquaternion.h>
#line 54 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"
#line 483 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qgenericmatrix.sip"
#include <qgenericmatrix.h>
#line 57 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"


PyDoc_STRVAR(doc_QMatrix4x4_determinant, "determinant(self) -> float");

extern "C" {static PyObject *meth_QMatrix4x4_determinant(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_determinant(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
            double sipRes;

            sipRes = sipCpp->determinant();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_determinant, doc_QMatrix4x4_determinant);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_inverted, "inverted(self) -> Tuple[QMatrix4x4, bool]");

extern "C" {static PyObject *meth_QMatrix4x4_inverted(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_inverted(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4(sipCpp->inverted(&a0));

            PyObject *sipResObj = sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
            return sipBuildResult(0,"(Rb)",sipResObj,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_inverted, doc_QMatrix4x4_inverted);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_transposed, "transposed(self) -> QMatrix4x4");

extern "C" {static PyObject *meth_QMatrix4x4_transposed(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_transposed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4(sipCpp->transposed());

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_transposed, doc_QMatrix4x4_transposed);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_normalMatrix, "normalMatrix(self) -> QMatrix3x3");

extern "C" {static PyObject *meth_QMatrix4x4_normalMatrix(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_normalMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
             ::QMatrix3x3*sipRes;

            sipRes = new  ::QMatrix3x3(sipCpp->normalMatrix());

            return sipConvertFromNewType(sipRes,sipType_QMatrix3x3,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_normalMatrix, doc_QMatrix4x4_normalMatrix);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_scale, "scale(self, QVector3D)\n"
"scale(self, float, float)\n"
"scale(self, float, float, float)\n"
"scale(self, float)");

extern "C" {static PyObject *meth_QMatrix4x4_scale(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_scale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QVector3D, &a0))
        {
            sipCpp->scale(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
        float a1;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1))
        {
            sipCpp->scale(a0,a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
        float a1;
        float a2;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bfff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->scale(a0,a1,a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0))
        {
            sipCpp->scale(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_scale, doc_QMatrix4x4_scale);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_translate, "translate(self, QVector3D)\n"
"translate(self, float, float)\n"
"translate(self, float, float, float)");

extern "C" {static PyObject *meth_QMatrix4x4_translate(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_translate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QVector3D, &a0))
        {
            sipCpp->translate(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
        float a1;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1))
        {
            sipCpp->translate(a0,a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
        float a1;
        float a2;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bfff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->translate(a0,a1,a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_translate, doc_QMatrix4x4_translate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_rotate, "rotate(self, float, QVector3D)\n"
"rotate(self, float, float, float, z: float = 0)\n"
"rotate(self, QQuaternion)");

extern "C" {static PyObject *meth_QMatrix4x4_rotate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_rotate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        const  ::QVector3D* a1;
         ::QMatrix4x4 *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BfJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, sipType_QVector3D, &a1))
        {
            sipCpp->rotate(a0,*a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
        float a1;
        float a2;
        float a3 = 0;
         ::QMatrix4x4 *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_z,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bfff|f", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1, &a2, &a3))
        {
            sipCpp->rotate(a0,a1,a2,a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::QQuaternion* a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QQuaternion, &a0))
        {
            sipCpp->rotate(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_rotate, doc_QMatrix4x4_rotate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_ortho, "ortho(self, QRect)\n"
"ortho(self, QRectF)\n"
"ortho(self, float, float, float, float, float, float)");

extern "C" {static PyObject *meth_QMatrix4x4_ortho(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_ortho(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QRect* a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QRect, &a0))
        {
            sipCpp->ortho(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::QRectF* a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QRectF, &a0))
        {
            sipCpp->ortho(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
        float a1;
        float a2;
        float a3;
        float a4;
        float a5;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bffffff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1, &a2, &a3, &a4, &a5))
        {
            sipCpp->ortho(a0,a1,a2,a3,a4,a5);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_ortho, doc_QMatrix4x4_ortho);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_frustum, "frustum(self, float, float, float, float, float, float)");

extern "C" {static PyObject *meth_QMatrix4x4_frustum(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_frustum(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        float a1;
        float a2;
        float a3;
        float a4;
        float a5;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bffffff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1, &a2, &a3, &a4, &a5))
        {
            sipCpp->frustum(a0,a1,a2,a3,a4,a5);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_frustum, doc_QMatrix4x4_frustum);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_perspective, "perspective(self, float, float, float, float)");

extern "C" {static PyObject *meth_QMatrix4x4_perspective(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_perspective(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        float a1;
        float a2;
        float a3;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bffff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1, &a2, &a3))
        {
            sipCpp->perspective(a0,a1,a2,a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_perspective, doc_QMatrix4x4_perspective);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_lookAt, "lookAt(self, QVector3D, QVector3D, QVector3D)");

extern "C" {static PyObject *meth_QMatrix4x4_lookAt(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_lookAt(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
        const  ::QVector3D* a1;
        const  ::QVector3D* a2;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9J9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QVector3D, &a0, sipType_QVector3D, &a1, sipType_QVector3D, &a2))
        {
            sipCpp->lookAt(*a0,*a1,*a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_lookAt, doc_QMatrix4x4_lookAt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_copyDataTo, "copyDataTo(self) -> List[float]");

extern "C" {static PyObject *meth_QMatrix4x4_copyDataTo(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_copyDataTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            sipErrorState sipError = sipErrorNone;

#line 129 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
        float values[16];
        
        sipCpp->copyDataTo(values);
        sipError = qtgui_matrixDataAsList(16, values, &sipRes);
#line 547 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipRes;
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_copyDataTo, doc_QMatrix4x4_copyDataTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_toTransform, "toTransform(self) -> QTransform\n"
"toTransform(self, float) -> QTransform");

extern "C" {static PyObject *meth_QMatrix4x4_toTransform(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_toTransform(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
             ::QTransform*sipRes;

            sipRes = new  ::QTransform(sipCpp->toTransform());

            return sipConvertFromNewType(sipRes,sipType_QTransform,SIP_NULLPTR);
        }
    }

    {
        float a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0))
        {
             ::QTransform*sipRes;

            sipRes = new  ::QTransform(sipCpp->toTransform(a0));

            return sipConvertFromNewType(sipRes,sipType_QTransform,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_toTransform, doc_QMatrix4x4_toTransform);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_mapRect, "mapRect(self, QRect) -> QRect\n"
"mapRect(self, QRectF) -> QRectF");

extern "C" {static PyObject *meth_QMatrix4x4_mapRect(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_mapRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QRect* a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QRect, &a0))
        {
             ::QRect*sipRes;

            sipRes = new  ::QRect(sipCpp->mapRect(*a0));

            return sipConvertFromNewType(sipRes,sipType_QRect,SIP_NULLPTR);
        }
    }

    {
        const  ::QRectF* a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QRectF, &a0))
        {
             ::QRectF*sipRes;

            sipRes = new  ::QRectF(sipCpp->mapRect(*a0));

            return sipConvertFromNewType(sipRes,sipType_QRectF,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_mapRect, doc_QMatrix4x4_mapRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_data, "data(self) -> List[float]");

extern "C" {static PyObject *meth_QMatrix4x4_data(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            sipErrorState sipError = sipErrorNone;

#line 141 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
        sipError = qtgui_matrixDataAsList(16, sipCpp->constData(), &sipRes);
#line 672 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipRes;
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_data, doc_QMatrix4x4_data);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_optimize, "optimize(self)");

extern "C" {static PyObject *meth_QMatrix4x4_optimize(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_optimize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
            sipCpp->optimize();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_optimize, doc_QMatrix4x4_optimize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_column, "column(self, int) -> QVector4D");

extern "C" {static PyObject *meth_QMatrix4x4_column(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_column(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D(sipCpp->column(a0));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_column, doc_QMatrix4x4_column);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_setColumn, "setColumn(self, int, QVector4D)");

extern "C" {static PyObject *meth_QMatrix4x4_setColumn(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_setColumn(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QVector4D* a1;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, sipType_QVector4D, &a1))
        {
            sipCpp->setColumn(a0,*a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_setColumn, doc_QMatrix4x4_setColumn);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_row, "row(self, int) -> QVector4D");

extern "C" {static PyObject *meth_QMatrix4x4_row(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_row(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D(sipCpp->row(a0));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_row, doc_QMatrix4x4_row);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_setRow, "setRow(self, int, QVector4D)");

extern "C" {static PyObject *meth_QMatrix4x4_setRow(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_setRow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QVector4D* a1;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, sipType_QVector4D, &a1))
        {
            sipCpp->setRow(a0,*a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_setRow, doc_QMatrix4x4_setRow);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_isIdentity, "isIdentity(self) -> bool");

extern "C" {static PyObject *meth_QMatrix4x4_isIdentity(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_isIdentity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isIdentity();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_isIdentity, doc_QMatrix4x4_isIdentity);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_setToIdentity, "setToIdentity(self)");

extern "C" {static PyObject *meth_QMatrix4x4_setToIdentity(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_setToIdentity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
            sipCpp->setToIdentity();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_setToIdentity, doc_QMatrix4x4_setToIdentity);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_fill, "fill(self, float)");

extern "C" {static PyObject *meth_QMatrix4x4_fill(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_fill(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0))
        {
            sipCpp->fill(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_fill, doc_QMatrix4x4_fill);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_map, "map(self, QPoint) -> QPoint\n"
"map(self, Union[QPointF, QPoint]) -> QPointF\n"
"map(self, QVector3D) -> QVector3D\n"
"map(self, QVector4D) -> QVector4D");

extern "C" {static PyObject *meth_QMatrix4x4_map(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_map(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPoint* a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QPoint, &a0))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint(sipCpp->map(*a0));

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    {
        const  ::QPointF* a0;
        int a0State = 0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF(sipCpp->map(*a0));
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    {
        const  ::QVector3D* a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QVector3D, &a0))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D(sipCpp->map(*a0));

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    {
        const  ::QVector4D* a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QVector4D, &a0))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D(sipCpp->map(*a0));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_map, doc_QMatrix4x4_map);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_mapVector, "mapVector(self, QVector3D) -> QVector3D");

extern "C" {static PyObject *meth_QMatrix4x4_mapVector(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_mapVector(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QVector3D, &a0))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D(sipCpp->mapVector(*a0));

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_mapVector, doc_QMatrix4x4_mapVector);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_viewport, "viewport(self, float, float, float, float, nearPlane: float = 0, farPlane: float = 1)\n"
"viewport(self, QRectF)");

extern "C" {static PyObject *meth_QMatrix4x4_viewport(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_viewport(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        float a1;
        float a2;
        float a3;
        float a4 = 0;
        float a5 = 1;
         ::QMatrix4x4 *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_nearPlane,
            sipName_farPlane,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bffff|ff", &sipSelf, sipType_QMatrix4x4, &sipCpp, &a0, &a1, &a2, &a3, &a4, &a5))
        {
            sipCpp->viewport(a0,a1,a2,a3,a4,a5);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::QRectF* a0;
         ::QMatrix4x4 *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QMatrix4x4, &sipCpp, sipType_QRectF, &a0))
        {
            sipCpp->viewport(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_viewport, doc_QMatrix4x4_viewport);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMatrix4x4_isAffine, "isAffine(self) -> bool");

extern "C" {static PyObject *meth_QMatrix4x4_isAffine(PyObject *, PyObject *);}
static PyObject *meth_QMatrix4x4_isAffine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4 *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMatrix4x4, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isAffine();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName_isAffine, doc_QMatrix4x4_isAffine);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QMatrix4x4___truediv__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___truediv__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QMatrix4x4, &a0, &a1))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4((*a0 / a1));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, truediv_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QMatrix4x4___add__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;
        const  ::QMatrix4x4* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QMatrix4x4, &a0, sipType_QMatrix4x4, &a1))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4((*a0 + *a1));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QMatrix4x4___sub__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;
        const  ::QMatrix4x4* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QMatrix4x4, &a0, sipType_QMatrix4x4, &a1))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4((*a0 - *a1));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QMatrix4x4___mul__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;
        const  ::QMatrix4x4* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QMatrix4x4, &a0, sipType_QMatrix4x4, &a1))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    {
        const  ::QMatrix4x4* a0;
        const  ::QVector3D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QMatrix4x4, &a0, sipType_QVector3D, &a1))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    {
        const  ::QMatrix4x4* a0;
        const  ::QVector4D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QMatrix4x4, &a0, sipType_QVector4D, &a1))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    {
        const  ::QMatrix4x4* a0;
        const  ::QPoint* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QMatrix4x4, &a0, sipType_QPoint, &a1))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    {
        const  ::QMatrix4x4* a0;
        const  ::QPointF* a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J1", sipType_QMatrix4x4, &a0, sipType_QPointF, &a1, &a1State))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF((*a0 * *a1));
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    {
        float a0;
        const  ::QMatrix4x4* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "fJ9", &a0, sipType_QMatrix4x4, &a1))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4((a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    {
        const  ::QMatrix4x4* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QMatrix4x4, &a0, &a1))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4((*a0 * a1));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QMatrix4x4___matmul__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___matmul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;
        const  ::QMatrix4x4* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QMatrix4x4, &a0, sipType_QMatrix4x4, &a1))
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, matmul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QMatrix4x4___neg__(PyObject *);}
static PyObject *slot_QMatrix4x4___neg__(PyObject *sipSelf)
{
     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
             ::QMatrix4x4*sipRes;

            sipRes = new  ::QMatrix4x4(-(*sipCpp));

            return sipConvertFromNewType(sipRes,sipType_QMatrix4x4,SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QMatrix4x4___ne__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMatrix4x4, &a0))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QMatrix4x4::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QMatrix4x4, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QMatrix4x4___eq__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMatrix4x4, &a0))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QMatrix4x4::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QMatrix4x4, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QMatrix4x4___itruediv__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___itruediv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QMatrix4x4)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp-> ::QMatrix4x4::operator/=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QMatrix4x4___imatmul__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___imatmul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QMatrix4x4)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMatrix4x4, &a0))
        {
            sipCpp-> ::QMatrix4x4::operator*=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QMatrix4x4___imul__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QMatrix4x4)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMatrix4x4, &a0))
        {
            sipCpp-> ::QMatrix4x4::operator*=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp-> ::QMatrix4x4::operator*=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QMatrix4x4___isub__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QMatrix4x4)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMatrix4x4, &a0))
        {
            sipCpp-> ::QMatrix4x4::operator-=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QMatrix4x4___iadd__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QMatrix4x4)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix4x4* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QMatrix4x4, &a0))
        {
            sipCpp-> ::QMatrix4x4::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static int slot_QMatrix4x4___setitem__(PyObject *,PyObject *);}
static int slot_QMatrix4x4___setitem__(PyObject *sipSelf,PyObject *sipArgs)
{
     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
         ::qreal a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "P0d", &a0, &a1))
        {
            sipErrorState sipError = sipErrorNone;

#line 160 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
        int row, column;
        
        if ((sipError = qtgui_matrixParseIndex(a0, 4, 4, &row, &column)) == sipErrorNone)
            sipCpp->operator()(row, column) = a1;
#line 1647 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

            if (sipError == sipErrorFail)
                return -1;

            if (sipError == sipErrorNone)
            {
            return 0;
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName___setitem__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_QMatrix4x4___getitem__(PyObject *,PyObject *);}
static PyObject *slot_QMatrix4x4___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1P0", &a0))
        {
            PyObject * sipRes = SIP_NULLPTR;
            sipErrorState sipError = sipErrorNone;

#line 147 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
        int row, column;
        
        if ((sipError = qtgui_matrixParseIndex(a0, 4, 4, &row, &column)) == sipErrorNone)
        {
            sipRes = PyFloat_FromDouble(sipCpp->operator()(row, column));
        
            if (!sipRes)
                sipError = sipErrorFail;
        }
#line 1695 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipRes;
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMatrix4x4, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QMatrix4x4___repr__(PyObject *);}
static PyObject *slot_QMatrix4x4___repr__(PyObject *sipSelf)
{
     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QMatrix4x4));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 60 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
        bool bad = false;
        int i;
        PyObject *m[16];
        PYQT_FLOAT data[16];
        
        // The raw data is in column-major order but we want row-major order.
        sipCpp->copyDataTo(data);
        
        for (i = 0; i < 16; ++i)
        {
            m[i] = PyFloat_FromDouble(data[i]);
        
            if (!m[i])
                bad = true;
        }
        
        if (!bad)
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromFormat("PyQt5.QtGui.QMatrix4x4("
                    "%R, %R, %R, %R, "
                    "%R, %R, %R, %R, "
                    "%R, %R, %R, %R, "
                    "%R, %R, %R, %R)",
                    m[0], m[1], m[2], m[3],
                    m[4], m[5], m[6], m[7],
                    m[8], m[9], m[10], m[11],
                    m[12], m[13], m[14], m[15]);
        #else
            sipRes = PyString_FromString("PyQt5.QtGui.QMatrix4x4(");
        
            for (i = 0; i < 16; ++i)
            {
                if (i != 0)
                    PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
        
                PyString_ConcatAndDel(&sipRes, PyObject_Repr(m[i]));
            }
        
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        }
        
        for (i = 0; i < 16; ++i)
            Py_XDECREF(m[i]);
#line 1774 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QMatrix4x4(void *, int);}
static void release_QMatrix4x4(void *sipCppV, int)
{
    delete reinterpret_cast< ::QMatrix4x4 *>(sipCppV);
}


extern "C" {static PyObject *pickle_QMatrix4x4(void *);}
static PyObject *pickle_QMatrix4x4(void *sipCppV)
{
     ::QMatrix4x4 *sipCpp = reinterpret_cast< ::QMatrix4x4 *>(sipCppV);
    PyObject *sipRes;

#line 34 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
    PYQT_FLOAT data[16];
    
    // We want the data in row-major order.
    sipCpp->copyDataTo(data);
    
    sipRes = Py_BuildValue((char *)"dddddddddddddddd",
            (double)data[0], (double)data[1], (double)data[2], (double)data[3],
            (double)data[4], (double)data[5], (double)data[6], (double)data[7],
            (double)data[8], (double)data[9], (double)data[10], (double)data[11],
            (double)data[12], (double)data[13], (double)data[14], (double)data[15]);
#line 1809 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

    return sipRes;
}


extern "C" {static void *array_QMatrix4x4(Py_ssize_t);}
static void *array_QMatrix4x4(Py_ssize_t sipNrElem)
{
    return new  ::QMatrix4x4[sipNrElem];
}


extern "C" {static void array_delete_QMatrix4x4(void *);}
static void array_delete_QMatrix4x4(void *sipCpp)
{
    delete[] reinterpret_cast< ::QMatrix4x4 *>(sipCpp);
}


extern "C" {static void assign_QMatrix4x4(void *, Py_ssize_t, void *);}
static void assign_QMatrix4x4(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QMatrix4x4 *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QMatrix4x4 *>(sipSrc);
}


extern "C" {static void *copy_QMatrix4x4(const void *, Py_ssize_t);}
static void *copy_QMatrix4x4(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QMatrix4x4(reinterpret_cast<const  ::QMatrix4x4 *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QMatrix4x4(sipSimpleWrapper *);}
static void dealloc_QMatrix4x4(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QMatrix4x4(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QMatrix4x4(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QMatrix4x4(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QMatrix4x4 *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QMatrix4x4();

            return sipCpp;
        }
    }

    {
        PyObject * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "P0", &a0))
        {
            sipErrorState sipError = sipErrorNone;

#line 50 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qmatrix4x4.sip"
        float values[16];
        
        if ((sipError = qtgui_matrixDataFromSequence(a0, 16, values)) == sipErrorNone)
            sipCpp = new QMatrix4x4(values);
#line 1879 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQMatrix4x4.cpp"

            if (sipError == sipErrorNone)
                return sipCpp;

            if (sipUnused)
            {
                Py_XDECREF(*sipUnused);
            }

            sipAddException(sipError, sipParseErr);

            if (sipError == sipErrorFail)
                return SIP_NULLPTR;
        }
    }

    {
        float a0;
        float a1;
        float a2;
        float a3;
        float a4;
        float a5;
        float a6;
        float a7;
        float a8;
        float a9;
        float a10;
        float a11;
        float a12;
        float a13;
        float a14;
        float a15;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "ffffffffffffffff", &a0, &a1, &a2, &a3, &a4, &a5, &a6, &a7, &a8, &a9, &a10, &a11, &a12, &a13, &a14, &a15))
        {
            sipCpp = new  ::QMatrix4x4(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);

            return sipCpp;
        }
    }

    {
        const  ::QTransform* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QTransform, &a0))
        {
            sipCpp = new  ::QMatrix4x4(*a0);

            return sipCpp;
        }
    }

    {
        const  ::QMatrix4x4* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QMatrix4x4, &a0))
        {
            sipCpp = new  ::QMatrix4x4(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QMatrix4x4[] = {
    {(void *)slot_QMatrix4x4___truediv__, truediv_slot},
    {(void *)slot_QMatrix4x4___add__, add_slot},
    {(void *)slot_QMatrix4x4___sub__, sub_slot},
    {(void *)slot_QMatrix4x4___mul__, mul_slot},
    {(void *)slot_QMatrix4x4___matmul__, matmul_slot},
    {(void *)slot_QMatrix4x4___neg__, neg_slot},
    {(void *)slot_QMatrix4x4___ne__, ne_slot},
    {(void *)slot_QMatrix4x4___eq__, eq_slot},
    {(void *)slot_QMatrix4x4___itruediv__, itruediv_slot},
    {(void *)slot_QMatrix4x4___imatmul__, imatmul_slot},
    {(void *)slot_QMatrix4x4___imul__, imul_slot},
    {(void *)slot_QMatrix4x4___isub__, isub_slot},
    {(void *)slot_QMatrix4x4___iadd__, iadd_slot},
    {(void *)slot_QMatrix4x4___setitem__, setitem_slot},
    {(void *)slot_QMatrix4x4___getitem__, getitem_slot},
    {(void *)slot_QMatrix4x4___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QMatrix4x4[] = {
    {sipName_column, meth_QMatrix4x4_column, METH_VARARGS, doc_QMatrix4x4_column},
    {sipName_copyDataTo, meth_QMatrix4x4_copyDataTo, METH_VARARGS, doc_QMatrix4x4_copyDataTo},
    {sipName_data, meth_QMatrix4x4_data, METH_VARARGS, doc_QMatrix4x4_data},
    {sipName_determinant, meth_QMatrix4x4_determinant, METH_VARARGS, doc_QMatrix4x4_determinant},
    {sipName_fill, meth_QMatrix4x4_fill, METH_VARARGS, doc_QMatrix4x4_fill},
    {sipName_frustum, meth_QMatrix4x4_frustum, METH_VARARGS, doc_QMatrix4x4_frustum},
    {sipName_inverted, SIP_MLMETH_CAST(meth_QMatrix4x4_inverted), METH_VARARGS|METH_KEYWORDS, doc_QMatrix4x4_inverted},
    {sipName_isAffine, meth_QMatrix4x4_isAffine, METH_VARARGS, doc_QMatrix4x4_isAffine},
    {sipName_isIdentity, meth_QMatrix4x4_isIdentity, METH_VARARGS, doc_QMatrix4x4_isIdentity},
    {sipName_lookAt, meth_QMatrix4x4_lookAt, METH_VARARGS, doc_QMatrix4x4_lookAt},
    {sipName_map, meth_QMatrix4x4_map, METH_VARARGS, doc_QMatrix4x4_map},
    {sipName_mapRect, meth_QMatrix4x4_mapRect, METH_VARARGS, doc_QMatrix4x4_mapRect},
    {sipName_mapVector, meth_QMatrix4x4_mapVector, METH_VARARGS, doc_QMatrix4x4_mapVector},
    {sipName_normalMatrix, meth_QMatrix4x4_normalMatrix, METH_VARARGS, doc_QMatrix4x4_normalMatrix},
    {sipName_optimize, meth_QMatrix4x4_optimize, METH_VARARGS, doc_QMatrix4x4_optimize},
    {sipName_ortho, meth_QMatrix4x4_ortho, METH_VARARGS, doc_QMatrix4x4_ortho},
    {sipName_perspective, meth_QMatrix4x4_perspective, METH_VARARGS, doc_QMatrix4x4_perspective},
    {sipName_rotate, SIP_MLMETH_CAST(meth_QMatrix4x4_rotate), METH_VARARGS|METH_KEYWORDS, doc_QMatrix4x4_rotate},
    {sipName_row, meth_QMatrix4x4_row, METH_VARARGS, doc_QMatrix4x4_row},
    {sipName_scale, meth_QMatrix4x4_scale, METH_VARARGS, doc_QMatrix4x4_scale},
    {sipName_setColumn, meth_QMatrix4x4_setColumn, METH_VARARGS, doc_QMatrix4x4_setColumn},
    {sipName_setRow, meth_QMatrix4x4_setRow, METH_VARARGS, doc_QMatrix4x4_setRow},
    {sipName_setToIdentity, meth_QMatrix4x4_setToIdentity, METH_VARARGS, doc_QMatrix4x4_setToIdentity},
    {sipName_toTransform, meth_QMatrix4x4_toTransform, METH_VARARGS, doc_QMatrix4x4_toTransform},
    {sipName_translate, meth_QMatrix4x4_translate, METH_VARARGS, doc_QMatrix4x4_translate},
    {sipName_transposed, meth_QMatrix4x4_transposed, METH_VARARGS, doc_QMatrix4x4_transposed},
    {sipName_viewport, SIP_MLMETH_CAST(meth_QMatrix4x4_viewport), METH_VARARGS|METH_KEYWORDS, doc_QMatrix4x4_viewport}
};

PyDoc_STRVAR(doc_QMatrix4x4, "\1QMatrix4x4()\n"
"QMatrix4x4(Sequence[float])\n"
"QMatrix4x4(float, float, float, float, float, float, float, float, float, float, float, float, float, float, float, float)\n"
"QMatrix4x4(QTransform)\n"
"QMatrix4x4(QMatrix4x4)");


static pyqt5ClassPluginDef plugin_QMatrix4x4 = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QMatrix4x4 = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QMatrix4x4,
        SIP_NULLPTR,
        &plugin_QMatrix4x4
    },
    {
        sipNameNr_QMatrix4x4,
        {0, 0, 1},
        27, methods_QMatrix4x4,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QMatrix4x4,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QMatrix4x4,
    init_type_QMatrix4x4,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QMatrix4x4,
    assign_QMatrix4x4,
    array_QMatrix4x4,
    copy_QMatrix4x4,
    release_QMatrix4x4,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QMatrix4x4,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QMatrix4x4,
    sizeof ( ::QMatrix4x4),
};
