/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.util.res.StringManager;

public class HttpMessages {
    private static final Map<Locale, HttpMessages> instances = new ConcurrentHashMap<Locale, HttpMessages>();
    private static final HttpMessages DEFAULT = new HttpMessages(StringManager.getManager((String)"org.apache.tomcat.util.http.res", (Locale)Locale.getDefault()));
    private final StringManager sm;
    private String st_200 = null;
    private String st_302 = null;
    private String st_400 = null;
    private String st_404 = null;
    private String st_500 = null;

    private HttpMessages(StringManager stringManager) {
        this.sm = stringManager;
    }

    public String getMessage(int n) {
        switch (n) {
            case 200: {
                if (this.st_200 == null) {
                    this.st_200 = this.sm.getString("sc.200");
                }
                return this.st_200;
            }
            case 302: {
                if (this.st_302 == null) {
                    this.st_302 = this.sm.getString("sc.302");
                }
                return this.st_302;
            }
            case 400: {
                if (this.st_400 == null) {
                    this.st_400 = this.sm.getString("sc.400");
                }
                return this.st_400;
            }
            case 404: {
                if (this.st_404 == null) {
                    this.st_404 = this.sm.getString("sc.404");
                }
                return this.st_404;
            }
            case 500: {
                if (this.st_500 == null) {
                    this.st_500 = this.sm.getString("sc.500");
                }
                return this.st_500;
            }
        }
        return this.sm.getString("sc." + n);
    }

    public static HttpMessages getInstance(Locale locale) {
        HttpMessages httpMessages = instances.get(locale);
        if (httpMessages == null) {
            StringManager stringManager = StringManager.getManager((String)"org.apache.tomcat.util.http.res", (Locale)locale);
            httpMessages = Locale.getDefault().equals(stringManager.getLocale()) ? DEFAULT : new HttpMessages(stringManager);
            instances.put(locale, httpMessages);
        }
        return httpMessages;
    }

    public static boolean isSafeInHttpHeader(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (' ' <= c && c <= '~' || '\u0080' <= c && c <= '\u00ff' || c == '\t') continue;
            return false;
        }
        return true;
    }
}

