
#ifndef KUNITCONVERSION_EXPORT_H
#define KUNITCONVERSION_EXPORT_H

#ifdef KUNITCONVERSION_STATIC_DEFINE
#  define KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_NO_EXPORT
#else
#  ifndef KUNITCONVERSION_EXPORT
#    ifdef KF5UnitConversion_EXPORTS
        /* We are building this library */
#      define KUNITCONVERSION_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KUNITCONVERSION_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KUNITCONVERSION_NO_EXPORT
#    define KUNITCONVERSION_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KUNITCONVERSION_DECL_DEPRECATED
#  define KUNITCONVERSION_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KUNITCONVERSION_DECL_DEPRECATED_EXPORT
#  define KUNITCONVERSION_DECL_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT KUNITCONVERSION_DECL_DEPRECATED
#endif

#ifndef KUNITCONVERSION_DECL_DEPRECATED_NO_EXPORT
#  define KUNITCONVERSION_DECL_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT KUNITCONVERSION_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KUNITCONVERSION_NO_DEPRECATED
#    define KUNITCONVERSION_NO_DEPRECATED
#  endif
#endif

#define KUNITCONVERSION_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KUNITCONVERSION_NO_DEPRECATED) && !defined(KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KUNITCONVERSION_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KUNITCONVERSION_NO_DEPRECATED_WARNINGS) && !defined(KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KUNITCONVERSION_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KUNITCONVERSION_NO_DEPRECATED)
#  undef KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT
#elif defined(KUNITCONVERSION_NO_DEPRECATED_WARNINGS)
#  define KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT
#else
#  define KUNITCONVERSION_DEPRECATED KUNITCONVERSION_DECL_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_DECL_DEPRECATED_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KUNITCONVERSION_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KUNITCONVERSION_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KUNITCONVERSION_NO_DEPRECATED
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56200
#endif
#ifdef KUNITCONVERSION_NO_DEPRECATED_WARNINGS
#  define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE
#  ifdef KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE 0x56200
#  endif
#endif

#ifndef KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KUNITCONVERSION_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE >= 0x55b00
#  define KUNITCONVERSION_DEPRECATED_VERSION_5_91(text) KUNITCONVERSION_DECL_DEPRECATED_TEXT(text)
#else
#  define KUNITCONVERSION_DEPRECATED_VERSION_5_91(text)
#endif
#define KUNITCONVERSION_DEPRECATED_VERSION_5(minor, text)      KUNITCONVERSION_DEPRECATED_VERSION_5_##minor(text)
#define KUNITCONVERSION_DEPRECATED_VERSION(major, minor, text) KUNITCONVERSION_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KUNITCONVERSION_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KUNITCONVERSION_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KUNITCONVERSION_DEPRECATED_VERSION(major, minor, text)
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KUNITCONVERSION_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KUNITCONVERSION_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KUNITCONVERSION_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KUNITCONVERSION_EXPORT_H


#define KUNITCONVERSION_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KUNITCONVERSION_NO_DEPRECATED) && !defined(KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KUNITCONVERSION_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KUNITCONVERSION_NO_DEPRECATED_WARNINGS) && !defined(KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KUNITCONVERSION_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KUNITCONVERSION_NO_DEPRECATED)
#  undef KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT
#elif defined(KUNITCONVERSION_NO_DEPRECATED_WARNINGS)
#  define KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_NO_EXPORT
#else
#  define KUNITCONVERSION_DEPRECATED KUNITCONVERSION_DECL_DEPRECATED
#  define KUNITCONVERSION_DEPRECATED_EXPORT KUNITCONVERSION_DECL_DEPRECATED_EXPORT
#  define KUNITCONVERSION_DEPRECATED_NO_EXPORT KUNITCONVERSION_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KUNITCONVERSION_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KUNITCONVERSION_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KUNITCONVERSION_NO_DEPRECATED
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56200
#endif
#ifdef KUNITCONVERSION_NO_DEPRECATED_WARNINGS
#  define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE
#  ifdef KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE 0x56200
#  endif
#endif

#ifndef KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KUNITCONVERSION_DEPRECATED
#  define KUNITCONVERSION_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KUNITCONVERSION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KUNITCONVERSION_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KUNITCONVERSION_DEPRECATED_WARNINGS_SINCE >= 0x55b00
#  define KUNITCONVERSION_DEPRECATED_VERSION_5_91(text) KUNITCONVERSION_DECL_DEPRECATED_TEXT(text)
#else
#  define KUNITCONVERSION_DEPRECATED_VERSION_5_91(text)
#endif
#define KUNITCONVERSION_DEPRECATED_VERSION_5(minor, text)      KUNITCONVERSION_DEPRECATED_VERSION_5_##minor(text)
#define KUNITCONVERSION_DEPRECATED_VERSION(major, minor, text) KUNITCONVERSION_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KUNITCONVERSION_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KUNITCONVERSION_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KUNITCONVERSION_DEPRECATED_VERSION(major, minor, text)
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KUNITCONVERSION_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KUNITCONVERSION_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KUNITCONVERSION_EXPORT_H */
