/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.IOException;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.RootNode;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRWriter;
import org.jruby.ir.persistence.IRWriterStream;
import org.jruby.ir.persistence.util.IRFileExpert;

public abstract class IRTranslator<R, S> {
    public R execute(Ruby runtime2, ParseResult result2, S specificObject) {
        IRScriptBody scope = null;
        if (result2 instanceof IRScriptBody) {
            scope = (IRScriptBody)result2;
        } else if (result2 instanceof RootNode) {
            InterpreterContext ic = IRBuilder.buildRoot(runtime2.getIRManager(), (RootNode)result2);
            scope = (IRScriptBody)ic.getScope();
            scope.setScriptDynamicScope(((RootNode)result2).getScope());
            if (RubyInstanceConfig.IR_WRITING) {
                try {
                    IRWriter.persist(new IRWriterStream(IRFileExpert.getIRPersistedFile(scope.getFile())), scope);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        }
        return this.execute(runtime2, scope, specificObject);
    }

    protected abstract R execute(Ruby var1, IRScriptBody var2, S var3);
}

