// components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-params-data.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared-message-ids.h"

#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-import-headers.h"


#ifndef COMPONENTS_DISCARDABLE_MEMORY_PUBLIC_MOJOM_DISCARDABLE_SHARED_MEMORY_MANAGER_MOJOM_JUMBO_H_
#define COMPONENTS_DISCARDABLE_MEMORY_PUBLIC_MOJOM_DISCARDABLE_SHARED_MEMORY_MANAGER_MOJOM_JUMBO_H_
#endif
namespace discardable_memory {
namespace mojom {
const char DiscardableSharedMemoryManager::Name_[] = "discardable_memory.mojom.DiscardableSharedMemoryManager";

class DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback(
      DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback);
};

DiscardableSharedMemoryManagerProxy::DiscardableSharedMemoryManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DiscardableSharedMemoryManagerProxy::AllocateLockedDiscardableSharedMemory(
    uint32_t in_size, int32_t in_id, AllocateLockedDiscardableSharedMemoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::discardable_memory::mojom::internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data> params(
          message);
  params.Allocate();
  params->size = in_size;
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscardableSharedMemoryManager::Name_);
  message.set_method_name("AllocateLockedDiscardableSharedMemory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DiscardableSharedMemoryManagerProxy::DeletedDiscardableSharedMemory(
    int32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "discardable_memory::mojom::DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::discardable_memory::mojom::internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data> params(
          message);
  params.Allocate();
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscardableSharedMemoryManager::Name_);
  message.set_method_name("DeletedDiscardableSharedMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder {
 public:
  static DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder> proxy(
        new DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::UnsafeSharedMemoryRegion in_region);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder);
};

bool DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::UnsafeSharedMemoryRegion p_region{};
  DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRegion(&p_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DiscardableSharedMemoryManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_region));
  return true;
}

void DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder::Run(
    ::base::UnsafeSharedMemoryRegion in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::discardable_memory::mojom::internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_region, region_fragment);
  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DiscardableSharedMemoryManager::Name_);
  message.set_method_name("AllocateLockedDiscardableSharedMemory");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DiscardableSharedMemoryManagerStubDispatch::Accept(
    DiscardableSharedMemoryManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Name: {
      break;
    }
    case internal::kDiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::DeletedDiscardableSharedMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data* params =
          reinterpret_cast<internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_id{};
      DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DiscardableSharedMemoryManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeletedDiscardableSharedMemory(
std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool DiscardableSharedMemoryManagerStubDispatch::AcceptWithResponder(
    DiscardableSharedMemoryManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)discardable_memory::mojom::DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data* params =
          reinterpret_cast<
              internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_size{};
      int32_t p_id{};
      DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_size = input_data_view.size();
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DiscardableSharedMemoryManager::Name_, 0, false);
        return false;
      }
      DiscardableSharedMemoryManager::AllocateLockedDiscardableSharedMemoryCallback callback =
          DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllocateLockedDiscardableSharedMemory(
std::move(p_size), 
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kDiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDiscardableSharedMemoryManagerValidationInfo[] = {
    {internal::kDiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Name,
     {&internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_Params_Data::Validate,
      &internal::DiscardableSharedMemoryManager_AllocateLockedDiscardableSharedMemory_ResponseParams_Data::Validate}},
    {internal::kDiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Name,
     {&internal::DiscardableSharedMemoryManager_DeletedDiscardableSharedMemory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DiscardableSharedMemoryManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::discardable_memory::mojom::DiscardableSharedMemoryManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDiscardableSharedMemoryManagerValidationInfo);
}

bool DiscardableSharedMemoryManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::discardable_memory::mojom::DiscardableSharedMemoryManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDiscardableSharedMemoryManagerValidationInfo);

}
}  // namespace mojom
}  // namespace discardable_memory

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif