// components/paint_preview/common/mojom/paint_preview_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-params-data.h"
#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-shared-message-ids.h"

#include "components/paint_preview/common/mojom/paint_preview_recorder.mojom-import-headers.h"


#ifndef COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_JUMBO_H_
#define COMPONENTS_PAINT_PREVIEW_COMMON_MOJOM_PAINT_PREVIEW_RECORDER_MOJOM_JUMBO_H_
#endif
namespace paint_preview {
namespace mojom {
PaintPreviewCaptureParams::PaintPreviewCaptureParams()
    : persistence(),
      guid(),
      clip_rect(),
      clip_rect_is_hint(),
      is_main_frame(),
      capture_links(),
      file(),
      max_capture_size(),
      max_decoded_image_size_bytes(),
      skip_accelerated_content() {}

PaintPreviewCaptureParams::PaintPreviewCaptureParams(
    ::paint_preview::RecordingPersistence persistence_in,
    const ::base::UnguessableToken& guid_in,
    const ::gfx::Rect& clip_rect_in,
    bool clip_rect_is_hint_in,
    bool is_main_frame_in,
    bool capture_links_in,
    ::base::File file_in,
    uint64_t max_capture_size_in,
    uint64_t max_decoded_image_size_bytes_in,
    bool skip_accelerated_content_in)
    : persistence(std::move(persistence_in)),
      guid(std::move(guid_in)),
      clip_rect(std::move(clip_rect_in)),
      clip_rect_is_hint(std::move(clip_rect_is_hint_in)),
      is_main_frame(std::move(is_main_frame_in)),
      capture_links(std::move(capture_links_in)),
      file(std::move(file_in)),
      max_capture_size(std::move(max_capture_size_in)),
      max_decoded_image_size_bytes(std::move(max_decoded_image_size_bytes_in)),
      skip_accelerated_content(std::move(skip_accelerated_content_in)) {}

PaintPreviewCaptureParams::~PaintPreviewCaptureParams() = default;

void PaintPreviewCaptureParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "persistence"), this->persistence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::paint_preview::RecordingPersistence>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_rect"), this->clip_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_rect_is_hint"), this->clip_rect_is_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_main_frame"), this->is_main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_links"), this->capture_links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file"), this->file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_capture_size"), this->max_capture_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_decoded_image_size_bytes"), this->max_decoded_image_size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_accelerated_content"), this->skip_accelerated_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintPreviewCaptureParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LinkData::LinkData()
    : url(),
      rect() {}

LinkData::LinkData(
    const ::GURL& url_in,
    const ::gfx::Rect& rect_in)
    : url(std::move(url_in)),
      rect(std::move(rect_in)) {}

LinkData::~LinkData() = default;

void LinkData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect"), this->rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LinkData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaintPreviewCaptureResponse::PaintPreviewCaptureResponse()
    : embedding_token(),
      content_id_to_embedding_token(),
      links(),
      blink_recording_time(),
      serialized_size(),
      scroll_offsets(),
      skp() {}

PaintPreviewCaptureResponse::PaintPreviewCaptureResponse(
    const absl::optional<::base::UnguessableToken>& embedding_token_in,
    const base::flat_map<uint32_t, ::base::UnguessableToken>& content_id_to_embedding_token_in,
    std::vector<LinkDataPtr> links_in,
    ::base::TimeDelta blink_recording_time_in,
    uint64_t serialized_size_in,
    const ::gfx::Size& scroll_offsets_in,
    absl::optional<::mojo_base::BigBuffer> skp_in)
    : embedding_token(std::move(embedding_token_in)),
      content_id_to_embedding_token(std::move(content_id_to_embedding_token_in)),
      links(std::move(links_in)),
      blink_recording_time(std::move(blink_recording_time_in)),
      serialized_size(std::move(serialized_size_in)),
      scroll_offsets(std::move(scroll_offsets_in)),
      skp(std::move(skp_in)) {}

PaintPreviewCaptureResponse::~PaintPreviewCaptureResponse() = default;

void PaintPreviewCaptureResponse::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedding_token"), this->embedding_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_id_to_embedding_token"), this->content_id_to_embedding_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint32_t, ::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "links"), this->links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<LinkDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blink_recording_time"), this->blink_recording_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serialized_size"), this->serialized_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_offsets"), this->scroll_offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skp"), this->skp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::mojo_base::BigBuffer>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaintPreviewCaptureResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaintPreviewRecorder::Name_[] = "paint_preview.mojom.PaintPreviewRecorder";

class PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback(
      PaintPreviewRecorder::CapturePaintPreviewCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaintPreviewRecorder::CapturePaintPreviewCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback);
};

PaintPreviewRecorderProxy::PaintPreviewRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaintPreviewRecorderProxy::CapturePaintPreview(
    PaintPreviewCaptureParamsPtr in_params, CapturePaintPreviewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type PaintPreviewCaptureParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaintPreviewRecorder_CapturePaintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCaptureParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in PaintPreviewRecorder.CapturePaintPreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewRecorder::Name_);
  message.set_method_name("CapturePaintPreview");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder {
 public:
  static PaintPreviewRecorder::CapturePaintPreviewCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder> proxy(
        new PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaintPreviewRecorder::CapturePaintPreviewCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaintPreviewStatus in_status, PaintPreviewCaptureResponsePtr in_response);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder);
};

bool PaintPreviewRecorder_CapturePaintPreview_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreviewCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaintPreviewStatus p_status{};
  PaintPreviewCaptureResponsePtr p_response{};
  PaintPreviewRecorder_CapturePaintPreview_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaintPreviewRecorder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_response));
  return true;
}

void PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::Run(
    PaintPreviewStatus in_status, PaintPreviewCaptureResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreviewCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaintPreviewStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type PaintPreviewCaptureResponsePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaintPreviewRecorder_CapturePaintPreview_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::paint_preview::mojom::internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::paint_preview::mojom::PaintPreviewCaptureResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreviewCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaintPreviewRecorder::Name_);
  message.set_method_name("CapturePaintPreview");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaintPreviewRecorderStubDispatch::Accept(
    PaintPreviewRecorder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPaintPreviewRecorder_CapturePaintPreview_Name: {
      break;
    }
  }
  return false;
}

// static
bool PaintPreviewRecorderStubDispatch::AcceptWithResponder(
    PaintPreviewRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaintPreviewRecorder_CapturePaintPreview_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)paint_preview::mojom::PaintPreviewRecorder::CapturePaintPreview");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data* params =
          reinterpret_cast<
              internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaintPreviewCaptureParamsPtr p_params{};
      PaintPreviewRecorder_CapturePaintPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaintPreviewRecorder::Name_, 0, false);
        return false;
      }
      PaintPreviewRecorder::CapturePaintPreviewCallback callback =
          PaintPreviewRecorder_CapturePaintPreview_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreview(
std::move(p_params), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPaintPreviewRecorderValidationInfo[] = {
    {internal::kPaintPreviewRecorder_CapturePaintPreview_Name,
     {&internal::PaintPreviewRecorder_CapturePaintPreview_Params_Data::Validate,
      &internal::PaintPreviewRecorder_CapturePaintPreview_ResponseParams_Data::Validate}},
};

bool PaintPreviewRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::paint_preview::mojom::PaintPreviewRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPaintPreviewRecorderValidationInfo);
}

bool PaintPreviewRecorderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::paint_preview::mojom::PaintPreviewRecorder::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPaintPreviewRecorderValidationInfo);

}
}  // namespace mojom
}  // namespace paint_preview

namespace mojo {


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewCaptureParams::DataView, ::paint_preview::mojom::PaintPreviewCaptureParamsPtr>::Read(
    ::paint_preview::mojom::PaintPreviewCaptureParams::DataView input,
    ::paint_preview::mojom::PaintPreviewCaptureParamsPtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewCaptureParamsPtr result(::paint_preview::mojom::PaintPreviewCaptureParams::New());
  
      if (success && !input.ReadPersistence(&result->persistence))
        success = false;
      if (success && !input.ReadGuid(&result->guid))
        success = false;
      if (success && !input.ReadClipRect(&result->clip_rect))
        success = false;
      if (success)
        result->clip_rect_is_hint = input.clip_rect_is_hint();
      if (success)
        result->is_main_frame = input.is_main_frame();
      if (success)
        result->capture_links = input.capture_links();
      if (success && !input.ReadFile(&result->file))
        success = false;
      if (success)
        result->max_capture_size = input.max_capture_size();
      if (success)
        result->max_decoded_image_size_bytes = input.max_decoded_image_size_bytes();
      if (success)
        result->skip_accelerated_content = input.skip_accelerated_content();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::LinkData::DataView, ::paint_preview::mojom::LinkDataPtr>::Read(
    ::paint_preview::mojom::LinkData::DataView input,
    ::paint_preview::mojom::LinkDataPtr* output) {
  bool success = true;
  ::paint_preview::mojom::LinkDataPtr result(::paint_preview::mojom::LinkData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadRect(&result->rect))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::paint_preview::mojom::PaintPreviewCaptureResponse::DataView, ::paint_preview::mojom::PaintPreviewCaptureResponsePtr>::Read(
    ::paint_preview::mojom::PaintPreviewCaptureResponse::DataView input,
    ::paint_preview::mojom::PaintPreviewCaptureResponsePtr* output) {
  bool success = true;
  ::paint_preview::mojom::PaintPreviewCaptureResponsePtr result(::paint_preview::mojom::PaintPreviewCaptureResponse::New());
  
      if (success && !input.ReadEmbeddingToken(&result->embedding_token))
        success = false;
      if (success && !input.ReadContentIdToEmbeddingToken(&result->content_id_to_embedding_token))
        success = false;
      if (success && !input.ReadLinks(&result->links))
        success = false;
      if (success && !input.ReadBlinkRecordingTime(&result->blink_recording_time))
        success = false;
      if (success)
        result->serialized_size = input.serialized_size();
      if (success && !input.ReadScrollOffsets(&result->scroll_offsets))
        success = false;
      if (success && !input.ReadSkp(&result->skp))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif