// components/performance_manager/public/mojom/lifecycle.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/performance_manager/public/mojom/lifecycle.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/lifecycle.mojom-params-data.h"
namespace performance_manager {
namespace mojom {

static NOINLINE const char* LifecycleStateToStringHelper(LifecycleState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LifecycleState::kRunning:
      return "kRunning";
    case LifecycleState::kFrozen:
      return "kFrozen";
    case LifecycleState::kDiscarded:
      return "kDiscarded";
    default:
      return nullptr;
  }
}

std::string LifecycleStateToString(LifecycleState value) {
  const char *str = LifecycleStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LifecycleState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LifecycleState value) {
  return os << LifecycleStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace performance_manager

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::LifecycleState>::WriteIntoTrace(
   perfetto::TracedValue context, ::performance_manager::mojom::LifecycleState value) {
  return std::move(context).WriteString(::performance_manager::mojom::LifecycleStateToString(value));
}

} // namespace perfetto
