// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE SCHEMA DEFINITION AND DESCRIPTION IN
//   ../../../../../qtwebengine-everywhere-src-6.3.2/src/3rdparty/chromium/components/search_engines/prepopulated_engines_schema.json
//   ../../../../../qtwebengine-everywhere-src-6.3.2/src/3rdparty/chromium/components/search_engines/prepopulated_engines.json
// DO NOT EDIT.

#include "prepopulated_engines.h"

namespace TemplateURLPrepopulateData {

const int kMaxPrepopulatedEngineID = 101;
const int kCurrentDataVersion = 126;

const PrepopulatedEngine ask = {
  L"Ask",
  L"ask.com",
  "https://sp.ask.com/sh/i/a16/favicon/favicon.ico",
  "https://www.ask.com/web?q={searchTerms}",
  "UTF-8",
  "https://lss.sse-iacapps.com/query?q={searchTerms}&li=ff",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_ASK,
  NULL,
  4,
};

const char* const array_baidu_alternate_urls[] = {
  "https://www.baidu.com/s?ie={inputEncoding}&wd={searchTerms}",
  "https://www.baidu.com/s?ie={inputEncoding}&word={searchTerms}",
  "https://www.baidu.com/{google:pathWildcard}/s?ie={inputEncoding}&word={searchTerms}",
};
const PrepopulatedEngine baidu = {
  L"\x767e" L"\x5ea6" L"",
  L"baidu.com",
  "https://www.baidu.com/favicon.ico",
  "https://www.baidu.com/#ie={inputEncoding}&wd={searchTerms}",
  "UTF-8",
  "https://suggestion.baidu.com/su?wd={searchTerms}&action=opensearch&ie={inputEncoding}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_baidu_alternate_urls,
  3,
  SEARCH_ENGINE_BAIDU,
  NULL,
  21,
};

const PrepopulatedEngine bing = {
  L"Bing",
  L"bing.com",
  "https://www.bing.com/sa/simg/bing_p_rr_teal_min.ico",
  "https://www.bing.com/search?q={searchTerms}&PC=U316&FORM=CHROMN",
  "UTF-8",
  "https://www.bing.com/osjson.aspx?query={searchTerms}&language={language}&PC=U316",
  "https://www.bing.com/images/detail/search?iss=sbiupload&FORM=CHROMI#enterInsights",
  "https://www.bing.com/chrome/newtab",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  "imageBin={google:imageThumbnailBase64}",
  NULL,
  0,
  SEARCH_ENGINE_BING,
  NULL,
  3,
};

const PrepopulatedEngine coccoc = {
  L"C\x1ed1" L"c C\x1ed1" L"c",
  L"coccoc.com",
  "https://coccoc.com/favicon.ico",
  "https://coccoc.com/search#query={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_COCCOC,
  NULL,
  91,
};

const PrepopulatedEngine daum = {
  L"Daum",
  L"daum.net",
  "https://search.daum.net/favicon.ico",
  "https://search.daum.net/search?w=tot&DA=JU5&q={searchTerms}",
  "UTF-8",
  "https://suggest.search.daum.net/sushi/opensearch/pc?q={searchTerms}&DA=JU6",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_DAUM,
  NULL,
  68,
};

const PrepopulatedEngine duckduckgo = {
  L"DuckDuckGo",
  L"duckduckgo.com",
  "https://duckduckgo.com/favicon.ico",
  "https://duckduckgo.com/?q={searchTerms}",
  "UTF-8",
  "https://duckduckgo.com/ac/?q={searchTerms}&type=list",
  NULL,
  "https://duckduckgo.com/chrome_newtab",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_DUCKDUCKGO,
  NULL,
  92,
};

const PrepopulatedEngine ecosia = {
  L"Ecosia",
  L"ecosia.org",
  "https://cdn.ecosia.org/assets/images/ico/favicon.ico",
  "https://www.ecosia.org/search?q={searchTerms}&addon=opensearch",
  "UTF-8",
  "https://ac.ecosia.org/autocomplete?q={searchTerms}&type=list",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_ECOSIA,
  NULL,
  101,
};

const char* const array_google_alternate_urls[] = {
  "{google:baseURL}#q={searchTerms}",
  "{google:baseURL}search#q={searchTerms}",
  "{google:baseURL}webhp#q={searchTerms}",
  "{google:baseURL}s#q={searchTerms}",
  "{google:baseURL}s?q={searchTerms}",
};
const PrepopulatedEngine google = {
  L"Google",
  L"google.com",
  "https://www.google.com/images/branding/product/ico/googleg_lodp.ico",
  "{google:baseURL}search?q={searchTerms}&{google:RLZ}{google:originalQueryForSuggestion}{google:assistedQueryStats}{google:searchFieldtrialParameter}{google:iOSSearchLanguage}{google:prefetchSource}{google:searchClient}{google:sourceId}{google:contextualSearchVersion}ie={inputEncoding}",
  "UTF-8",
  "{google:baseSuggestURL}search?{google:searchFieldtrialParameter}client={google:suggestClient}&gs_ri={google:suggestRid}&xssi=t&q={searchTerms}&{google:inputType}{google:omniboxFocusType}{google:cursorPosition}{google:currentPageUrl}{google:pageClassification}{google:searchVersion}{google:sessionToken}{google:prefetchQuery}sugkey={google:suggestAPIKeyParameter}",
  "{google:baseSearchByImageURL}upload",
  NULL,
  "{google:baseURL}_/contextualsearch?{google:contextualSearchVersion}{google:contextualSearchContextData}",
  NULL,
  NULL,
  NULL,
  NULL,
  "encoded_image={google:imageThumbnail},image_url={google:imageURL},sbisrc={google:imageSearchSource},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight}",
  array_google_alternate_urls,
  5,
  SEARCH_ENGINE_GOOGLE,
  "ALLOWED",
  1,
};

const char* const array_mail_ru_alternate_urls[] = {
  "https://go.mail.ru/msearch?q={searchTerms}&{mailru:referralID}",
};
const PrepopulatedEngine mail_ru = {
  L"@MAIL.RU",
  L"mail.ru",
  "https://go.imgsmail.ru/favicon.ico",
  "https://go.mail.ru/search?q={searchTerms}&{mailru:referralID}",
  "UTF-8",
  "https://suggests.go.mail.ru/chrome?q={searchTerms}",
  NULL,
  "https://go.mail.ru/chrome/newtab/",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_mail_ru_alternate_urls,
  1,
  SEARCH_ENGINE_MAILRU,
  NULL,
  83,
};

const PrepopulatedEngine naver = {
  L"\xb124" L"\xc774" L"\xbc84" L"",
  L"naver.com",
  "https://ssl.pstatic.net/sstatic/search/favicon/favicon_140327.ico",
  "https://search.naver.com/search.naver?ie={inputEncoding}&query={searchTerms}&sm=chr_hty",
  "UTF-8",
  "https://ac.search.naver.com/nx/ac?of=os&ie={inputEncoding}&q={searchTerms}&oe={outputEncoding}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_NAVER,
  NULL,
  67,
};

const PrepopulatedEngine qwant = {
  L"Qwant",
  L"qwant.com",
  "https://www.qwant.com/favicon.ico",
  "https://www.qwant.com/?q={searchTerms}&client=opensearch",
  "UTF-8",
  "https://api.qwant.com/api/suggest/?q={searchTerms}&client=opensearch",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_QWANT,
  NULL,
  94,
};

const PrepopulatedEngine seznam_cz = {
  L"Seznam",
  L"seznam.cz",
  "https://search.seznam.cz/favicon.ico",
  "https://search.seznam.cz/?q={searchTerms}",
  "UTF-8",
  "https://suggest.seznam.cz/fulltext_ff?phrase={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_SEZNAM,
  NULL,
  25,
};

const PrepopulatedEngine seznam_sk = {
  L"Seznam",
  L"seznam.sk",
  "https://search.seznam.sk/favicon.ico",
  "https://search.seznam.sk/?q={searchTerms}",
  "UTF-8",
  "https://suggest.seznam.sk/fulltext_ff?phrase={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_SEZNAM,
  NULL,
  25,
};

const char* const array_so_360_alternate_urls[] = {
  "https://m.so.com/s?ie={inputEncoding}&q={searchTerms}",
  "https://m.so.com/index.php?ie={inputEncoding}&q={searchTerms}",
};
const PrepopulatedEngine so_360 = {
  L"360",
  L"so.com",
  "https://www.so.com/favicon.ico",
  "https://www.so.com/s?ie={inputEncoding}&q={searchTerms}",
  "UTF-8",
  "https://sug.so.360.cn/suggest?encodein={inputEncoding}&encodeout={outputEncoding}&format=opensearch&word={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_so_360_alternate_urls,
  2,
  SEARCH_ENGINE_360,
  NULL,
  88,
};

const char* const array_sogou_alternate_urls[] = {
  "https://m.sogou.com/web/{google:pathWildcard}?ie={inputEncoding}&keyword={searchTerms}",
};
const PrepopulatedEngine sogou = {
  L"\x641c" L"\x72d7" L"",
  L"sogou.com",
  "https://www.sogou.com/images/logo/old/favicon.ico",
  "https://www.sogou.com/web?ie={inputEncoding}&query={searchTerms}",
  "UTF-8",
  "https://sugg.sogou.com/sugg/ajaj_json.jsp?type=addrbar&key={searchTerms}&ie={inputEncoding}&from=google",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_sogou_alternate_urls,
  1,
  SEARCH_ENGINE_SOGOU,
  NULL,
  56,
};

const PrepopulatedEngine yahoo = {
  L"Yahoo!",
  L"yahoo.com",
  "https://search.yahoo.com/favicon.ico",
  "https://search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_ar = {
  L"Yahoo! Argentina",
  L"ar.yahoo.com",
  "https://ar.search.yahoo.com/favicon.ico",
  "https://ar.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ar.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_at = {
  L"Yahoo! \x00d6" L"sterreich",
  L"at.yahoo.com",
  "https://at.search.yahoo.com/favicon.ico",
  "https://at.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://at.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_au = {
  L"Yahoo!7",
  L"au.yahoo.com",
  "https://au.search.yahoo.com/favicon.ico",
  "https://au.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://au.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_br = {
  L"Yahoo! Brasil",
  L"br.yahoo.com",
  "https://br.search.yahoo.com/favicon.ico",
  "https://br.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://br.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_ca = {
  L"Yahoo! Canada",
  L"ca.yahoo.com",
  "https://ca.search.yahoo.com/favicon.ico",
  "https://ca.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ca.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_ch = {
  L"Yahoo! Schweiz",
  L"ch.yahoo.com",
  "https://ch.search.yahoo.com/favicon.ico",
  "https://ch.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ch.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_cl = {
  L"Yahoo! Chile",
  L"cl.yahoo.com",
  "https://cl.search.yahoo.com/favicon.ico",
  "https://cl.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://cl.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_co = {
  L"Yahoo! Colombia",
  L"co.yahoo.com",
  "https://co.search.yahoo.com/favicon.ico",
  "https://co.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://co.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_de = {
  L"Yahoo! Deutschland",
  L"de.yahoo.com",
  "https://de.search.yahoo.com/favicon.ico",
  "https://de.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://de.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_dk = {
  L"Yahoo! Danmark",
  L"dk.yahoo.com",
  "https://dk.search.yahoo.com/favicon.ico",
  "https://dk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_es = {
  L"Yahoo! Espa\x00f1" L"a",
  L"es.yahoo.com",
  "https://es.search.yahoo.com/favicon.ico",
  "https://es.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://es.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_fi = {
  L"Yahoo! Suomi",
  L"fi.yahoo.com",
  "https://fi.search.yahoo.com/favicon.ico",
  "https://fi.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_fr = {
  L"Yahoo! France",
  L"fr.yahoo.com",
  "https://fr.search.yahoo.com/favicon.ico",
  "https://fr.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://fr.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_hk = {
  L"Yahoo! Hong Kong",
  L"hk.yahoo.com",
  "https://hk.search.yahoo.com/favicon.ico",
  "https://hk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://hk.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_id = {
  L"Yahoo! Indonesia",
  L"id.yahoo.com",
  "https://id.search.yahoo.com/favicon.ico",
  "https://id.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://id.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_in = {
  L"Yahoo! India",
  L"in.yahoo.com",
  "https://in.search.yahoo.com/favicon.ico",
  "https://in.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://in.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_jp = {
  L"Yahoo! JAPAN",
  L"yahoo.co.jp",
  "https://search.yahoo.co.jp/favicon.ico",
  "https://search.yahoo.co.jp/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://search.yahooapis.jp/AssistSearchService/V2/webassistSearch?p={searchTerms}&appid=oQsoxcyxg66enp0TYoirkKoryq6rF8bK76mW0KYxZ0v0WPLtn.Lix6wy8F_LwGWHUII-&output=fxjson&fr=crmas",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_mx = {
  L"Yahoo! M\x00e9" L"xico",
  L"mx.yahoo.com",
  "https://mx.search.yahoo.com/favicon.ico",
  "https://mx.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://mx.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_my = {
  L"Yahoo! Malaysia",
  L"malaysia.yahoo.com",
  "https://malaysia.search.yahoo.com/favicon.ico",
  "https://malaysia.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://malaysia.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_nl = {
  L"Yahoo! Nederland",
  L"nl.yahoo.com",
  "https://nl.search.yahoo.com/favicon.ico",
  "https://nl.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://nl.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_nz = {
  L"Yahoo! New Zealand",
  L"nz.yahoo.com",
  "https://nz.search.yahoo.com/favicon.ico",
  "https://nz.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://nz.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_pe = {
  L"Yahoo! Per\x00fa" L"",
  L"pe.yahoo.com",
  "https://pe.search.yahoo.com/favicon.ico",
  "https://pe.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://pe.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_ph = {
  L"Yahoo! Philippines",
  L"ph.yahoo.com",
  "https://ph.search.yahoo.com/favicon.ico",
  "https://ph.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ph.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_se = {
  L"Yahoo! Sverige",
  L"se.yahoo.com",
  "https://se.search.yahoo.com/favicon.ico",
  "https://se.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_sg = {
  L"Yahoo! Singapore",
  L"sg.yahoo.com",
  "https://sg.search.yahoo.com/favicon.ico",
  "https://sg.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://sg.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_th = {
  L"Yahoo! \x0e1b" L"\x0e23" L"\x0e30" L"\x0e40" L"\x0e17" L"\x0e28" L"\x0e44" L"\x0e17" L"\x0e22" L"",
  L"th.yahoo.com",
  "https://th.search.yahoo.com/favicon.ico",
  "https://th.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://th.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_tr = {
  L"Yahoo! T\x00fc" L"rkiye",
  L"tr.yahoo.com",
  "https://tr.search.yahoo.com/favicon.ico",
  "https://tr.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_tw = {
  L"Yahoo!\x5947" L"\x6469" L"",
  L"tw.yahoo.com",
  "https://tw.search.yahoo.com/favicon.ico",
  "https://tw.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://tw.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_uk = {
  L"Yahoo! UK & Ireland",
  L"uk.yahoo.com",
  "https://uk.search.yahoo.com/favicon.ico",
  "https://uk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://uk.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_ve = {
  L"Yahoo! Venezuela",
  L"ve.yahoo.com",
  "https://ve.search.yahoo.com/favicon.ico",
  "https://ve.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ve.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yahoo_vn = {
  L"Yahoo! Vi\x1ec7" L"t Nam",
  L"vn.yahoo.com",
  "https://vn.search.yahoo.com/favicon.ico",
  "https://vn.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://vn.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const PrepopulatedEngine yandex_by = {
  L"\x042f" L"\x043d" L"\x0434" L"\x0435" L"\x043a" L"\x0441" L"",
  L"yandex.by",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.by/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.by/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.by/images/search/?rpt=imageview",
  "https://www.yandex.by/chrome/newtab",
  NULL,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  NULL,
  NULL,
  NULL,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  NULL,
  0,
  SEARCH_ENGINE_YANDEX,
  NULL,
  15,
};

const PrepopulatedEngine yandex_com = {
  L"Yandex",
  L"yandex.com",
  "https://yastatic.net/lego/_/rBTjd6UOPk5913OSn5ZQVYMTQWQ.ico",
  "https://yandex.com/search/?text={searchTerms}&from=os&clid=1836588",
  "UTF-8",
  "https://suggest.yandex.com/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}&uil=en&v=3&sn=5",
  "https://yandex.com/images/search?rpt=imageview",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  NULL,
  0,
  SEARCH_ENGINE_YANDEX,
  NULL,
  15,
};

const PrepopulatedEngine yandex_kz = {
  L"\x042f" L"\x043d" L"\x0434" L"\x0435" L"\x043a" L"\x0441" L"",
  L"yandex.kz",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.kz/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.kz/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.kz/images/search/?rpt=imageview",
  "https://www.yandex.kz/chrome/newtab",
  NULL,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  NULL,
  NULL,
  NULL,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  NULL,
  0,
  SEARCH_ENGINE_YANDEX,
  NULL,
  15,
};

const PrepopulatedEngine yandex_ru = {
  L"\x042f" L"\x043d" L"\x0434" L"\x0435" L"\x043a" L"\x0441" L"",
  L"yandex.ru",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.ru/{yandex:searchPath}?text={searchTerms}&{yandex:referralID}",
  "UTF-8",
  "https://suggest.yandex.ru/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.ru/images/search/?rpt=imageview",
  "https://www.yandex.ru/chrome/newtab",
  NULL,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  NULL,
  NULL,
  NULL,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  NULL,
  0,
  SEARCH_ENGINE_YANDEX,
  NULL,
  15,
};

const PrepopulatedEngine yandex_tr = {
  L"Yandex",
  L"yandex.com.tr",
  "https://yastatic.net/lego/_/rBTjd6UOPk5913OSn5ZQVYMTQWQ.ico",
  "https://www.yandex.com.tr/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.com.tr/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.com.tr/gorsel/search?rpt=imageview",
  "https://www.yandex.com.tr/chrome/newtab",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  NULL,
  0,
  SEARCH_ENGINE_YANDEX,
  NULL,
  15,
};

const PrepopulatedEngine yandex_ua = {
  L"\x042f" L"\x043d" L"\x0434" L"\x0435" L"\x043a" L"\x0441" L"",
  L"yandex.ua",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "https://yandex.ua/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.ua/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.ua/images/search/?rpt=imageview",
  "https://www.yandex.ua/chrome/newtab",
  NULL,
  "https://storage.ape.yandex.net/get/browser/Doodles/yandex/drawable-xxhdpi/yandex.png",
  NULL,
  NULL,
  NULL,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  NULL,
  0,
  SEARCH_ENGINE_YANDEX,
  NULL,
  15,
};

const char* const array_atlas_cz_alternate_urls[] = {
  "http://searchatlas.centrum.cz/?q={searchTerms}",
};
const PrepopulatedEngine atlas_cz = {
  L"Atlas.cz",
  L"atlas.cz",
  "https://searchatlas.centrum.cz/favicon.ico",
  "https://searchatlas.centrum.cz/?q={searchTerms}",
  "UTF-8",
  "http://radce.centrum.cz/?q={searchTerms}&of=1",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_atlas_cz_alternate_urls,
  1,
  SEARCH_ENGINE_ATLAS,
  NULL,
  27,
};

const char* const array_atlas_sk_alternate_urls[] = {
  "http://hladaj.atlas.sk/fulltext/?phrase={searchTerms}",
};
const PrepopulatedEngine atlas_sk = {
  L"ATLAS.SK",
  L"atlas.sk",
  "http://static.mediacentrum.sk/katalog/atlas.sk/images/favicon.ico",
  "https://hladaj.atlas.sk/fulltext/?phrase={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_atlas_sk_alternate_urls,
  1,
  SEARCH_ENGINE_ATLAS,
  NULL,
  27,
};

const char* const array_avg_alternate_urls[] = {
  "http://isearch.avg.com/search?q={searchTerms}",
  "http://search.avg.com/route/?q={searchTerms}&lng={language}",
  "https://isearch.avg.com/search?q={searchTerms}",
  "https://search.avg.com/route/?q={searchTerms}&lng={language}",
};
const PrepopulatedEngine avg = {
  L"AVG",
  L"search.avg.com",
  "http://search.avg.com/favicon.ico",
  "http://search.avg.com/search?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_avg_alternate_urls,
  4,
  SEARCH_ENGINE_AVG,
  NULL,
  50,
};

const char* const array_babylon_alternate_urls[] = {
  "http://search.babylon.com/?q={searchTerms}",
};
const PrepopulatedEngine babylon = {
  L"Babylon",
  L"search.babylon.com",
  "http://search.babylon.com/favicon.ico",
  "http://search.babylon.com/home?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_babylon_alternate_urls,
  1,
  SEARCH_ENGINE_BABYLON,
  NULL,
  64,
};

const char* const array_conduit_alternate_urls[] = {
  "http://search.conduit.com/Results.aspx?q={searchTerms}",
};
const PrepopulatedEngine conduit = {
  L"Conduit",
  L"conduit.com",
  "http://www.conduit.com/favicon.ico",
  "http://www.conduit.com/search?q={searchTerms}&ie={inputEncoding}&cx=010301873083402539744%3Anxaq5wgrtuo&cof=forid%3A11",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_conduit_alternate_urls,
  1,
  SEARCH_ENGINE_CONDUIT,
  NULL,
  36,
};

const char* const array_delfi_lt_alternate_urls[] = {
  "http://www.delfi.lt/paieska/?q={searchTerms}",
};
const PrepopulatedEngine delfi_lt = {
  L"DELFI",
  L"delfi.lt",
  "https://www.delfi.lt/favicon.ico",
  "https://www.delfi.lt/paieska/?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_delfi_lt_alternate_urls,
  1,
  SEARCH_ENGINE_DELFI,
  NULL,
  45,
};

const PrepopulatedEngine delfi_lv = {
  L"DELFI",
  L"delfi.lv",
  "http://g1.delphi.lv/favicon.ico",
  "http://www.delfi.lv/search_all/?ie={inputEncoding}&q={searchTerms}&lang={language}&cx=partner-pub-7754285690273419%3A1507605038&cof=FORID%3A10",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_DELFI,
  NULL,
  45,
};

const char* const array_delta_alternate_urls[] = {
  "http://www.delta-search.com/?q={searchTerms}",
  "http://www1.delta-search.com/home?q={searchTerms}",
  "http://www1.delta-search.com/?q={searchTerms}",
  "http://www2.delta-search.com/home?q={searchTerms}",
  "http://www2.delta-search.com/?q={searchTerms}",
  "http://www.search.delta-search.com/home?q={searchTerms}",
  "http://www.search.delta-search.com/?q={searchTerms}",
  "http://www.yhs.delta-search.com/home?q={searchTerms}",
  "http://www.yhs.delta-search.com/?q={searchTerms}",
  "http://mixidj.delta-search.com/home?q={searchTerms}",
  "http://mixidj.delta-search.com/?q={searchTerms}",
  "http://www.search.delta-search.com/home?q={searchTerms}",
  "http://www.search.delta-search.com/?q={searchTerms}",
};
const PrepopulatedEngine delta = {
  L"Delta",
  L"delta-search.com",
  "http://www.delta-search.com/favicon.ico",
  "http://www.delta-search.com/home?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_delta_alternate_urls,
  13,
  SEARCH_ENGINE_DELTA,
  NULL,
  66,
};

const PrepopulatedEngine funmoods = {
  L"Funmoods",
  L"searchfunmoods.com",
  "http://searchfunmoods.com/favicon.ico",
  "http://searchfunmoods.com/results.php?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_FUNMOODS,
  NULL,
  60,
};

const PrepopulatedEngine givero = {
  L"Givero",
  L"givero.com",
  "https://www.givero.com/favicon.ico",
  "https://www.givero.com/search?q={searchTerms}",
  "UTF-8",
  "https://www.givero.com/suggest?q={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_GIVERO,
  NULL,
  95,
};

const PrepopulatedEngine gmx = {
  L"GMX Search",
  L"search.gmx.com",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.com/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.com/s?q={searchTerms}&brand=gmxcom&enc={inputEncoding}&sp=b",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_GMX,
  NULL,
  96,
};

const PrepopulatedEngine gmx_at = {
  L"GMX Suche",
  L"suche.gmx.at",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://suche.gmx.at/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.at/s?q={searchTerms}&brand=gmxat&enc={inputEncoding}&sp=b",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_GMX,
  NULL,
  96,
};

const PrepopulatedEngine gmx_de = {
  L"GMX Suche",
  L"suche.gmx.net",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://suche.gmx.net/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.net/s?q={searchTerms}&brand=gmx&enc={inputEncoding}&sp=b",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_GMX,
  NULL,
  96,
};

const PrepopulatedEngine gmx_es = {
  L"GMX Search",
  L"search.gmx.es",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.es/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.es/s?q={searchTerms}&brand=gmxes&enc={inputEncoding}&sp=b",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_GMX,
  NULL,
  96,
};

const PrepopulatedEngine gmx_fr = {
  L"GMX Search",
  L"search.gmx.fr",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.fr/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.fr/s?q={searchTerms}&brand=gmxfr&enc={inputEncoding}&sp=b",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_GMX,
  NULL,
  96,
};

const PrepopulatedEngine gmx_gb = {
  L"GMX Search",
  L"search.gmx.co.uk",
  "https://dl.gmx.com/apps/favicon.ico",
  "https://search.gmx.co.uk/web/result?q={searchTerms}&sp=b",
  "UTF-8",
  "https://suggestplugin.gmx.co.uk/s?q={searchTerms}&brand=gmxcouk&enc={inputEncoding}&sp=b",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_GMX,
  NULL,
  96,
};

const char* const array_goo_alternate_urls[] = {
  "http://search.goo.ne.jp/web.jsp?MT={searchTerms}&IE={inputEncoding}",
  "http://search.goo.ne.jp/sgt.jsp?MT={searchTerms}&CL=plugin&FM=json&IE={inputEncoding}",
};
const PrepopulatedEngine goo = {
  L"goo",
  L"search.goo.ne.jp",
  "https://search.goo.ne.jp/cdn/common/img/favicon.ico",
  "https://search.goo.ne.jp/web.jsp?MT={searchTerms}&IE={inputEncoding}",
  "EUC-JP",
  "https://search.goo.ne.jp/sgt.jsp?MT={searchTerms}&CL=plugin&FM=json&IE={inputEncoding}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_goo_alternate_urls,
  2,
  SEARCH_ENGINE_GOO,
  NULL,
  23,
};

const PrepopulatedEngine imesh = {
  L"IMesh",
  L"search.imesh.net",
  "http://search.imesh.net/favicon.ico",
  "http://search.imesh.net/music?hl={language}&si={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_IMESH,
  NULL,
  81,
};

const char* const array_iminent_alternate_urls[] = {
  "http://search.iminent.com/SearchTheWeb/v6/1033/homepage/Default.aspx#q={searchTerms}",
  "http://search.iminent.com/SearchTheWeb/v6/1033/homepage/Result.aspx#q={searchTerms}",
  "http://start.iminent.com/?q={searchTerms}",
  "http://start.iminent.com/StartWeb/1033/homepage/#q={searchTerms}",
};
const PrepopulatedEngine iminent = {
  L"SearchTheWeb",
  L"iminent.com",
  "http://search.iminent.com/Shared/Images/favicon_gl.ico",
  "http://search.iminent.com/?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_iminent_alternate_urls,
  4,
  SEARCH_ENGINE_IMINENT,
  NULL,
  79,
};

const PrepopulatedEngine in = {
  L"in.gr",
  L"in.gr",
  "http://find.in.gr/Themes/1/Default/Media/Layout/icon_in.png",
  "http://find.in.gr/?q={searchTerms}&ie={inputEncoding}&cx=partner-pub-3451081775397713%3Aklnvxp4nycj&cof=FORID%3A9",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_IN,
  NULL,
  54,
};

const char* const array_incredibar_alternate_urls[] = {
  "http://search.incredibar.com/?q={searchTerms}",
  "http://mystart.incredibar.com/?search={searchTerms}",
};
const PrepopulatedEngine incredibar = {
  L"MyStart",
  L"mystart.incredibar.com",
  "http://search.incredibar.com/favicon.ico",
  "http://search.incredibar.com/search.php?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_incredibar_alternate_urls,
  2,
  SEARCH_ENGINE_INCREDIBAR,
  NULL,
  74,
};

const PrepopulatedEngine info_com = {
  L"Info.com",
  L"info.com",
  "https://www.info.com/static/www.info.com/favicon.ico",
  "https://www.info.com/serp?q={searchTerms}&segment=info.0472",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_INFO_COM,
  NULL,
  97,
};

const PrepopulatedEngine libero = {
  L"Libero",
  L"libero.it",
  "http://ms1.iol.it/graph_hf/v.8.3.04/themes/default/img/favicon.ico",
  "http://arianna.libero.it/search/abin/integrata.cgi?query={searchTerms}",
  "ISO-8859-1",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_LIBERO,
  NULL,
  63,
};

const PrepopulatedEngine metager_de = {
  L"MetaGer",
  L"metager.de",
  "https://metager.de/favicon.ico",
  "https://metager.de/meta/meta.ger3?eingabe={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_METAGER,
  NULL,
  98,
};

const PrepopulatedEngine metager_gb = {
  L"MetaGer",
  L"metager.org",
  "https://metager.de/favicon.ico",
  "https://metager.org/meta/meta.ger3?eingabe={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_METAGER,
  NULL,
  98,
};

const char* const array_neti_alternate_urls[] = {
  "https://www.neti.ee/cgi-bin/otsing?query={searchTerms}&src=web",
  "https://www.neti.ee/api/suggestOS?suggestVersion=1&suggestQuery={searchTerms}",
};
const PrepopulatedEngine neti = {
  L"NETI",
  L"neti.ee",
  "http://www.neti.ee/favicon.ico",
  "http://www.neti.ee/cgi-bin/otsing?query={searchTerms}",
  "ISO-8859-1",
  "http://www.neti.ee/api/suggestOS?suggestQuery={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_neti_alternate_urls,
  2,
  SEARCH_ENGINE_NETI,
  NULL,
  44,
};

const PrepopulatedEngine nigma = {
  L"\x041d" L"\x0438" L"\x0433" L"\x043c" L"\x0430" L"",
  L"nigma.ru",
  "http://nigma.ru/themes/nigma/img/favicon.ico",
  "http://nigma.ru/?s={searchTerms}",
  "UTF-8",
  "http://autocomplete.nigma.ru/complete/query_help.php?suggest=true&q={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_NIGMA,
  NULL,
  43,
};

const PrepopulatedEngine oceanhero = {
  L"OceanHero",
  L"oceanhero.today",
  "https://oceanhero.today/favicon.ico",
  "https://oceanhero.today/web?q={searchTerms}",
  "UTF-8",
  "https://api.oceanhero.today/suggestions?q={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_OCEANHERO,
  NULL,
  99,
};

const PrepopulatedEngine ok = {
  L"OK.hu",
  L"ok.hu",
  "http://ok.hu/gfx/favicon.ico",
  "http://ok.hu/katalogus?q={searchTerms}",
  "ISO-8859-2",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_OK,
  NULL,
  6,
};

const PrepopulatedEngine privacywall = {
  L"PrivacyWall",
  L"privacywall.org",
  "https://www.privacywall.org/images/favicon_32x32.ico",
  "https://www.privacywall.org/search/secure/?q={searchTerms}",
  "UTF-8",
  "https://search.privacywall.org/suggest.php?q={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_PRIVACYWALL,
  NULL,
  100,
};

const char* const array_rambler_alternate_urls[] = {
  "https://nova.rambler.ru/search?query={searchTerms}",
  "https://nova.rambler.ru/suggest?v=3&query={searchTerms}",
};
const PrepopulatedEngine rambler = {
  L"\x0420" L"\x0430" L"\x043c" L"\x0431" L"\x043b" L"\x0435" L"\x0440" L"",
  L"rambler.ru",
  "http://i.rl0.ru/2011/icons/rambler.ico",
  "http://nova.rambler.ru/search?query={searchTerms}",
  "UTF-8",
  "http://nova.rambler.ru/suggest?v=3&query={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_rambler_alternate_urls,
  2,
  SEARCH_ENGINE_RAMBLER,
  NULL,
  16,
};

const PrepopulatedEngine sapo = {
  L"SAPO",
  L"sapo.pt",
  "http://imgs.sapo.pt/images/sapo.ico",
  "http://pesquisa.sapo.pt/?q={searchTerms}",
  "UTF-8",
  "http://pesquisa.sapo.pt/livesapo?q={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_SAPO,
  NULL,
  77,
};

const PrepopulatedEngine searchnu = {
  L"searchnu",
  L"searchnu.com",
  "http://www.searchnu.com/favicon.ico",
  "http://www.searchnu.com/web?hl={language}&si={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_SEARCHNU,
  NULL,
  61,
};

const char* const array_search_results_alternate_urls[] = {
  "http://www.search-results.com/web?q={searchTerms}",
};
const PrepopulatedEngine search_results = {
  L"Search-results",
  L"search-results.com",
  "http://ak.apnstatic.com/media/images/favicon_search-results.ico",
  "http://dts.search-results.com/sr?lng={language}&src=hmp&q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_search_results_alternate_urls,
  1,
  SEARCH_ENGINE_SEARCH_RESULTS,
  NULL,
  78,
};

const char* const array_snapdo_alternate_urls[] = {
  "http://search.snap.do/?q={searchTerms}",
  "http://feed.snapdo.com/?q={searchTerms}",
  "http://feed.snap.do/?q={searchTerms}",
};
const PrepopulatedEngine snapdo = {
  L"SnapDo",
  L"search.snapdo.com",
  "http://linkurystoragenorthus.blob.core.windows.net/static/favicon.ico",
  "http://search.snapdo.com/?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_snapdo_alternate_urls,
  3,
  SEARCH_ENGINE_SNAPDO,
  NULL,
  70,
};

const char* const array_softonic_alternate_urls[] = {
  "http://en.softonic.com/s/{searchTerms}",
  "http://www.softonic.com/s/{searchTerms}",
  "http://www.softonic.com.br/s/{searchTerms}",
  "http://buscador.softonic.com/?q={searchTerms}",
  "http://nl.softonic.com/s/{searchTerms}",
  "https://search.softonic.com/?q={searchTerms}",
  "https://en.softonic.com/s/{searchTerms}",
  "https://www.softonic.com/s/{searchTerms}",
  "https://www.softonic.com.br/s/{searchTerms}",
  "https://buscador.softonic.com/?q={searchTerms}",
  "https://nl.softonic.com/s/{searchTerms}",
};
const PrepopulatedEngine softonic = {
  L"softonic",
  L"search.softonic.com",
  "http://search.softonic.com/img/favicon.ico",
  "http://search.softonic.com/?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_softonic_alternate_urls,
  11,
  SEARCH_ENGINE_SOFTONIC,
  NULL,
  80,
};

const PrepopulatedEngine sweetim = {
  L"SweetIM",
  L"home.sweetim.com",
  "http://search.sweetim.com/favicon.ico",
  "http://search.sweetim.com/search.asp?q={searchTerms}&ln={language}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_SWEETPACKS,
  NULL,
  65,
};

const char* const array_sweetpacks_alternate_urls[] = {
  "http://start.sweetpacks.com/?q={searchTerms}",
  "http://mysearch.sweetpacks.com/?q={searchTerms}",
};
const PrepopulatedEngine sweetpacks = {
  L"Sweetpacks",
  L"start.sweetpacks.com",
  "http://start.sweetpacks.com/favicon.ico",
  "http://start.sweetpacks.com/search.asp?q={searchTerms}&ln={language}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_sweetpacks_alternate_urls,
  2,
  SEARCH_ENGINE_SWEETPACKS,
  NULL,
  65,
};

const char* const array_terra_ar_alternate_urls[] = {
  "https://buscador.terra.com.ar/Default.aspx?source=Search&ca=s&query={searchTerms}",
};
const PrepopulatedEngine terra_ar = {
  L"Terra Argentina",
  L"terra.com.ar",
  "http://buscar.terra.com.ar/favicon.ico",
  "http://buscar.terra.com.ar/Default.aspx?source=Search&ca=s&query={searchTerms}",
  "ISO-8859-1",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_terra_ar_alternate_urls,
  1,
  SEARCH_ENGINE_TERRA,
  NULL,
  90,
};

const char* const array_terra_es_alternate_urls[] = {
  "https://buscador.terra.es/Default.aspx?source=Search&ca=s&query={searchTerms}",
};
const PrepopulatedEngine terra_es = {
  L"Terra",
  L"terra.es",
  "http://buscador.terra.es/favicon.ico",
  "http://buscador.terra.es/Default.aspx?source=Search&ca=s&query={searchTerms}",
  "ISO-8859-1",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_terra_es_alternate_urls,
  1,
  SEARCH_ENGINE_TERRA,
  NULL,
  90,
};

const PrepopulatedEngine tut = {
  L"TUT.BY",
  L"tut.by",
  "http://search.tut.by/favicon.ico",
  "http://search.tut.by/?ru=1&query={searchTerms}",
  "UTF-8",
  "http://suggest.yandex.ru/suggest-ff.cgi?part={searchTerms}&limit=10",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_TUT,
  NULL,
  17,
};

const char* const array_walla_alternate_urls[] = {
  "https://search.walla.co.il/?q={searchTerms}",
};
const PrepopulatedEngine walla = {
  L"\x05d5" L"\x05d5" L"\x05d0" L"\x05dc" L"\x05d4" L"!",
  L"walla.co.il",
  "http://www.walla.co.il/favicon.ico",
  "http://search.walla.co.il/?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_walla_alternate_urls,
  1,
  SEARCH_ENGINE_WALLA,
  NULL,
  55,
};

const PrepopulatedEngine wp = {
  L"Wirtualna Polska",
  L"wp.pl",
  "http://i.wp.pl/a/i/stg/500/favicon.ico",
  "http://szukaj.wp.pl/szukaj.html?q={searchTerms}",
  "UTF-8",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_WP,
  NULL,
  76,
};

const PrepopulatedEngine yahoo_qc = {
  L"Yahoo! Qu\x00e9" L"bec",
  L"qc.yahoo.com",
  "https://qc.search.yahoo.com/favicon.ico",
  "https://qc.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://qc.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  0,
  SEARCH_ENGINE_YAHOO,
  NULL,
  2,
};

const char* const array_zoznam_alternate_urls[] = {
  "http://www.zoznam.sk/hladaj.fcgi?s={searchTerms}",
};
const PrepopulatedEngine zoznam = {
  L"Zoznam",
  L"zoznam.sk",
  "https://www.zoznam.sk/favicon.ico",
  "https://www.zoznam.sk/hladaj.fcgi?s={searchTerms}",
  "windows-1250",
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  array_zoznam_alternate_urls,
  1,
  SEARCH_ENGINE_ZOZNAM,
  NULL,
  85,
};

const PrepopulatedEngine* const kAllEngines[] = {
	&ask,
	&baidu,
	&bing,
	&coccoc,
	&daum,
	&duckduckgo,
	&ecosia,
	&google,
	&mail_ru,
	&naver,
	&qwant,
	&seznam_cz,
	&seznam_sk,
	&so_360,
	&sogou,
	&yahoo,
	&yahoo_ar,
	&yahoo_at,
	&yahoo_au,
	&yahoo_br,
	&yahoo_ca,
	&yahoo_ch,
	&yahoo_cl,
	&yahoo_co,
	&yahoo_de,
	&yahoo_dk,
	&yahoo_es,
	&yahoo_fi,
	&yahoo_fr,
	&yahoo_hk,
	&yahoo_id,
	&yahoo_in,
	&yahoo_jp,
	&yahoo_mx,
	&yahoo_my,
	&yahoo_nl,
	&yahoo_nz,
	&yahoo_pe,
	&yahoo_ph,
	&yahoo_se,
	&yahoo_sg,
	&yahoo_th,
	&yahoo_tr,
	&yahoo_tw,
	&yahoo_uk,
	&yahoo_ve,
	&yahoo_vn,
	&yandex_by,
	&yandex_com,
	&yandex_kz,
	&yandex_ru,
	&yandex_tr,
	&yandex_ua,
	&atlas_cz,
	&atlas_sk,
	&avg,
	&babylon,
	&conduit,
	&delfi_lt,
	&delfi_lv,
	&delta,
	&funmoods,
	&givero,
	&gmx,
	&gmx_at,
	&gmx_de,
	&gmx_es,
	&gmx_fr,
	&gmx_gb,
	&goo,
	&imesh,
	&iminent,
	&in,
	&incredibar,
	&info_com,
	&libero,
	&metager_de,
	&metager_gb,
	&neti,
	&nigma,
	&oceanhero,
	&ok,
	&privacywall,
	&rambler,
	&sapo,
	&searchnu,
	&search_results,
	&snapdo,
	&softonic,
	&sweetim,
	&sweetpacks,
	&terra_ar,
	&terra_es,
	&tut,
	&walla,
	&wp,
	&yahoo_qc,
	&zoznam,
};
const size_t kAllEnginesLength = 98;

}  // namespace TemplateURLPrepopulateData
