// components/services/app_service/public/mojom/app_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/app_service/public/mojom/app_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/app_service/public/mojom/app_service.mojom-params-data.h"
namespace apps {
namespace mojom {

namespace internal {


// static
bool ConnectOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConnectOptions_Data* object = static_cast<const ConnectOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ConnectOptions_Data::ConnectOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_RegisterPublisher_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_RegisterPublisher_Params_Data* object = static_cast<const AppService_RegisterPublisher_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->publisher, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->publisher,
                                                 validation_context)) {
    return false;
  }


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  return true;
}

AppService_RegisterPublisher_Params_Data::AppService_RegisterPublisher_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_RegisterSubscriber_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_RegisterSubscriber_Params_Data* object = static_cast<const AppService_RegisterSubscriber_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subscriber, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subscriber,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->opts, validation_context))
    return false;

  return true;
}

AppService_RegisterSubscriber_Params_Data::AppService_RegisterSubscriber_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_LoadIcon_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_LoadIcon_Params_Data* object = static_cast<const AppService_LoadIcon_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_key, validation_context))
    return false;


  if (!::apps::mojom::internal::IconType_Data
        ::Validate(object->icon_type, validation_context))
    return false;

  return true;
}

AppService_LoadIcon_Params_Data::AppService_LoadIcon_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_LoadIcon_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_LoadIcon_ResponseParams_Data* object = static_cast<const AppService_LoadIcon_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_value, validation_context))
    return false;

  return true;
}

AppService_LoadIcon_ResponseParams_Data::AppService_LoadIcon_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_Launch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_Launch_Params_Data* object = static_cast<const AppService_Launch_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::LaunchSource_Data
        ::Validate(object->launch_source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->window_info, validation_context))
    return false;

  return true;
}

AppService_Launch_Params_Data::AppService_Launch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_LaunchAppWithFiles_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_LaunchAppWithFiles_Params_Data* object = static_cast<const AppService_LaunchAppWithFiles_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::LaunchSource_Data
        ::Validate(object->launch_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_paths, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_paths, validation_context))
    return false;

  return true;
}

AppService_LaunchAppWithFiles_Params_Data::AppService_LaunchAppWithFiles_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_LaunchAppWithIntent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_LaunchAppWithIntent_Params_Data* object = static_cast<const AppService_LaunchAppWithIntent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent, validation_context))
    return false;


  if (!::apps::mojom::internal::LaunchSource_Data
        ::Validate(object->launch_source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->window_info, validation_context))
    return false;

  return true;
}

AppService_LaunchAppWithIntent_Params_Data::AppService_LaunchAppWithIntent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_SetPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_SetPermission_Params_Data* object = static_cast<const AppService_SetPermission_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;

  return true;
}

AppService_SetPermission_Params_Data::AppService_SetPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_Uninstall_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_Uninstall_Params_Data* object = static_cast<const AppService_Uninstall_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::UninstallSource_Data
        ::Validate(object->uninstall_source, validation_context))
    return false;

  return true;
}

AppService_Uninstall_Params_Data::AppService_Uninstall_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_PauseApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_PauseApp_Params_Data* object = static_cast<const AppService_PauseApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

AppService_PauseApp_Params_Data::AppService_PauseApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_UnpauseApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_UnpauseApp_Params_Data* object = static_cast<const AppService_UnpauseApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

AppService_UnpauseApp_Params_Data::AppService_UnpauseApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_StopApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_StopApp_Params_Data* object = static_cast<const AppService_StopApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

AppService_StopApp_Params_Data::AppService_StopApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_GetMenuModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_GetMenuModel_Params_Data* object = static_cast<const AppService_GetMenuModel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::MenuType_Data
        ::Validate(object->menu_type, validation_context))
    return false;

  return true;
}

AppService_GetMenuModel_Params_Data::AppService_GetMenuModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_GetMenuModel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_GetMenuModel_ResponseParams_Data* object = static_cast<const AppService_GetMenuModel_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->menu_items, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->menu_items, validation_context))
    return false;

  return true;
}

AppService_GetMenuModel_ResponseParams_Data::AppService_GetMenuModel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_ExecuteContextMenuCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_ExecuteContextMenuCommand_Params_Data* object = static_cast<const AppService_ExecuteContextMenuCommand_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shortcut_id, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams shortcut_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shortcut_id, validation_context,
                                         &shortcut_id_validate_params)) {
    return false;
  }

  return true;
}

AppService_ExecuteContextMenuCommand_Params_Data::AppService_ExecuteContextMenuCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_OpenNativeSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_OpenNativeSettings_Params_Data* object = static_cast<const AppService_OpenNativeSettings_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

AppService_OpenNativeSettings_Params_Data::AppService_OpenNativeSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_AddPreferredApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_AddPreferredApp_Params_Data* object = static_cast<const AppService_AddPreferredApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filter, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent_filter, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->intent, validation_context))
    return false;

  return true;
}

AppService_AddPreferredApp_Params_Data::AppService_AddPreferredApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_RemovePreferredApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_RemovePreferredApp_Params_Data* object = static_cast<const AppService_RemovePreferredApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

AppService_RemovePreferredApp_Params_Data::AppService_RemovePreferredApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_RemovePreferredAppForFilter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_RemovePreferredAppForFilter_Params_Data* object = static_cast<const AppService_RemovePreferredAppForFilter_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filter, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent_filter, validation_context))
    return false;

  return true;
}

AppService_RemovePreferredAppForFilter_Params_Data::AppService_RemovePreferredAppForFilter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_SetResizeLocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_SetResizeLocked_Params_Data* object = static_cast<const AppService_SetResizeLocked_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->locked, validation_context))
    return false;

  return true;
}

AppService_SetResizeLocked_Params_Data::AppService_SetResizeLocked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppService_SetWindowMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AppService_SetWindowMode_Params_Data* object = static_cast<const AppService_SetWindowMode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::WindowMode_Data
        ::Validate(object->window_mode, validation_context))
    return false;

  return true;
}

AppService_SetWindowMode_Params_Data::AppService_SetWindowMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_Connect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_Connect_Params_Data* object = static_cast<const Publisher_Connect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subscriber, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subscriber,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->opts, validation_context))
    return false;

  return true;
}

Publisher_Connect_Params_Data::Publisher_Connect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_LoadIcon_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_LoadIcon_Params_Data* object = static_cast<const Publisher_LoadIcon_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_key, validation_context))
    return false;


  if (!::apps::mojom::internal::IconType_Data
        ::Validate(object->icon_type, validation_context))
    return false;

  return true;
}

Publisher_LoadIcon_Params_Data::Publisher_LoadIcon_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_LoadIcon_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_LoadIcon_ResponseParams_Data* object = static_cast<const Publisher_LoadIcon_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_value, validation_context))
    return false;

  return true;
}

Publisher_LoadIcon_ResponseParams_Data::Publisher_LoadIcon_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_Launch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_Launch_Params_Data* object = static_cast<const Publisher_Launch_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::LaunchSource_Data
        ::Validate(object->launch_source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->window_info, validation_context))
    return false;

  return true;
}

Publisher_Launch_Params_Data::Publisher_Launch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_LaunchAppWithFiles_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_LaunchAppWithFiles_Params_Data* object = static_cast<const Publisher_LaunchAppWithFiles_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::LaunchSource_Data
        ::Validate(object->launch_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_paths, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_paths, validation_context))
    return false;

  return true;
}

Publisher_LaunchAppWithFiles_Params_Data::Publisher_LaunchAppWithFiles_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_LaunchAppWithIntent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_LaunchAppWithIntent_Params_Data* object = static_cast<const Publisher_LaunchAppWithIntent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent, validation_context))
    return false;


  if (!::apps::mojom::internal::LaunchSource_Data
        ::Validate(object->launch_source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->window_info, validation_context))
    return false;

  return true;
}

Publisher_LaunchAppWithIntent_Params_Data::Publisher_LaunchAppWithIntent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_SetPermission_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_SetPermission_Params_Data* object = static_cast<const Publisher_SetPermission_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permission, validation_context))
    return false;

  return true;
}

Publisher_SetPermission_Params_Data::Publisher_SetPermission_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_Uninstall_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_Uninstall_Params_Data* object = static_cast<const Publisher_Uninstall_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::UninstallSource_Data
        ::Validate(object->uninstall_source, validation_context))
    return false;

  return true;
}

Publisher_Uninstall_Params_Data::Publisher_Uninstall_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_PauseApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_PauseApp_Params_Data* object = static_cast<const Publisher_PauseApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

Publisher_PauseApp_Params_Data::Publisher_PauseApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_UnpauseApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_UnpauseApp_Params_Data* object = static_cast<const Publisher_UnpauseApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

Publisher_UnpauseApp_Params_Data::Publisher_UnpauseApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_StopApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_StopApp_Params_Data* object = static_cast<const Publisher_StopApp_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

Publisher_StopApp_Params_Data::Publisher_StopApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_GetMenuModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_GetMenuModel_Params_Data* object = static_cast<const Publisher_GetMenuModel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::MenuType_Data
        ::Validate(object->menu_type, validation_context))
    return false;

  return true;
}

Publisher_GetMenuModel_Params_Data::Publisher_GetMenuModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_GetMenuModel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_GetMenuModel_ResponseParams_Data* object = static_cast<const Publisher_GetMenuModel_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->menu_items, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->menu_items, validation_context))
    return false;

  return true;
}

Publisher_GetMenuModel_ResponseParams_Data::Publisher_GetMenuModel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_ExecuteContextMenuCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_ExecuteContextMenuCommand_Params_Data* object = static_cast<const Publisher_ExecuteContextMenuCommand_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shortcut_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams shortcut_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shortcut_id, validation_context,
                                         &shortcut_id_validate_params)) {
    return false;
  }

  return true;
}

Publisher_ExecuteContextMenuCommand_Params_Data::Publisher_ExecuteContextMenuCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_OpenNativeSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_OpenNativeSettings_Params_Data* object = static_cast<const Publisher_OpenNativeSettings_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

Publisher_OpenNativeSettings_Params_Data::Publisher_OpenNativeSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_OnPreferredAppSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_OnPreferredAppSet_Params_Data* object = static_cast<const Publisher_OnPreferredAppSet_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filter, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent_filter, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replaced_app_preferences, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replaced_app_preferences, validation_context))
    return false;

  return true;
}

Publisher_OnPreferredAppSet_Params_Data::Publisher_OnPreferredAppSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_SetResizeLocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_SetResizeLocked_Params_Data* object = static_cast<const Publisher_SetResizeLocked_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->locked, validation_context))
    return false;

  return true;
}

Publisher_SetResizeLocked_Params_Data::Publisher_SetResizeLocked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Publisher_SetWindowMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Publisher_SetWindowMode_Params_Data* object = static_cast<const Publisher_SetWindowMode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::WindowMode_Data
        ::Validate(object->window_mode, validation_context))
    return false;

  return true;
}

Publisher_SetWindowMode_Params_Data::Publisher_SetWindowMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Subscriber_OnApps_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Subscriber_OnApps_Params_Data* object = static_cast<const Subscriber_OnApps_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deltas, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams deltas_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->deltas, validation_context,
                                         &deltas_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  return true;
}

Subscriber_OnApps_Params_Data::Subscriber_OnApps_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Subscriber_OnCapabilityAccesses_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Subscriber_OnCapabilityAccesses_Params_Data* object = static_cast<const Subscriber_OnCapabilityAccesses_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deltas, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams deltas_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->deltas, validation_context,
                                         &deltas_validate_params)) {
    return false;
  }

  return true;
}

Subscriber_OnCapabilityAccesses_Params_Data::Subscriber_OnCapabilityAccesses_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Subscriber_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Subscriber_Clone_Params_Data* object = static_cast<const Subscriber_Clone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Subscriber_Clone_Params_Data::Subscriber_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Subscriber_OnPreferredAppSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Subscriber_OnPreferredAppSet_Params_Data* object = static_cast<const Subscriber_OnPreferredAppSet_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filter, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent_filter, validation_context))
    return false;

  return true;
}

Subscriber_OnPreferredAppSet_Params_Data::Subscriber_OnPreferredAppSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Subscriber_OnPreferredAppRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Subscriber_OnPreferredAppRemoved_Params_Data* object = static_cast<const Subscriber_OnPreferredAppRemoved_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filter, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent_filter, validation_context))
    return false;

  return true;
}

Subscriber_OnPreferredAppRemoved_Params_Data::Subscriber_OnPreferredAppRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Subscriber_InitializePreferredApps_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Subscriber_InitializePreferredApps_Params_Data* object = static_cast<const Subscriber_InitializePreferredApps_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preferred_apps, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams preferred_apps_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->preferred_apps, validation_context,
                                         &preferred_apps_validate_params)) {
    return false;
  }

  return true;
}

Subscriber_InitializePreferredApps_Params_Data::Subscriber_InitializePreferredApps_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace apps
