// components/services/app_service/public/mojom/types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/app_service/public/mojom/types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/app_service/public/mojom/types.mojom-params-data.h"
namespace apps {
namespace mojom {

static NOINLINE const char* AppTypeToStringHelper(AppType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppType::kUnknown:
      return "kUnknown";
    case AppType::kArc:
      return "kArc";
    case AppType::kBuiltIn:
      return "kBuiltIn";
    case AppType::kCrostini:
      return "kCrostini";
    case AppType::kExtension:
      return "kExtension";
    case AppType::kWeb:
      return "kWeb";
    case AppType::kMacOs:
      return "kMacOs";
    case AppType::kPluginVm:
      return "kPluginVm";
    case AppType::kStandaloneBrowser:
      return "kStandaloneBrowser";
    case AppType::kRemote:
      return "kRemote";
    case AppType::kBorealis:
      return "kBorealis";
    case AppType::kSystemWeb:
      return "kSystemWeb";
    case AppType::kStandaloneBrowserExtension:
      return "kStandaloneBrowserExtension";
    default:
      return nullptr;
  }
}

std::string AppTypeToString(AppType value) {
  const char *str = AppTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppType value) {
  return os << AppTypeToString(value);
}

static NOINLINE const char* ReadinessToStringHelper(Readiness value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Readiness::kUnknown:
      return "kUnknown";
    case Readiness::kReady:
      return "kReady";
    case Readiness::kDisabledByBlocklist:
      return "kDisabledByBlocklist";
    case Readiness::kDisabledByPolicy:
      return "kDisabledByPolicy";
    case Readiness::kDisabledByUser:
      return "kDisabledByUser";
    case Readiness::kTerminated:
      return "kTerminated";
    case Readiness::kUninstalledByUser:
      return "kUninstalledByUser";
    case Readiness::kRemoved:
      return "kRemoved";
    case Readiness::kUninstalledByMigration:
      return "kUninstalledByMigration";
    default:
      return nullptr;
  }
}

std::string ReadinessToString(Readiness value) {
  const char *str = ReadinessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Readiness value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Readiness value) {
  return os << ReadinessToString(value);
}

static NOINLINE const char* InstallSourceToStringHelper(InstallSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InstallSource::kUnknown:
      return "kUnknown";
    case InstallSource::kSystem:
      return "kSystem";
    case InstallSource::kPolicy:
      return "kPolicy";
    case InstallSource::kOem:
      return "kOem";
    case InstallSource::kDefault:
      return "kDefault";
    case InstallSource::kSync:
      return "kSync";
    case InstallSource::kUser:
      return "kUser";
    default:
      return nullptr;
  }
}

std::string InstallSourceToString(InstallSource value) {
  const char *str = InstallSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InstallSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InstallSource value) {
  return os << InstallSourceToString(value);
}

static NOINLINE const char* UninstallSourceToStringHelper(UninstallSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UninstallSource::kUnknown:
      return "kUnknown";
    case UninstallSource::kAppList:
      return "kAppList";
    case UninstallSource::kAppManagement:
      return "kAppManagement";
    case UninstallSource::kShelf:
      return "kShelf";
    case UninstallSource::kMigration:
      return "kMigration";
    default:
      return nullptr;
  }
}

std::string UninstallSourceToString(UninstallSource value) {
  const char *str = UninstallSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UninstallSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UninstallSource value) {
  return os << UninstallSourceToString(value);
}

static NOINLINE const char* OptionalBoolToStringHelper(OptionalBool value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OptionalBool::kUnknown:
      return "kUnknown";
    case OptionalBool::kFalse:
      return "kFalse";
    case OptionalBool::kTrue:
      return "kTrue";
    default:
      return nullptr;
  }
}

std::string OptionalBoolToString(OptionalBool value) {
  const char *str = OptionalBoolToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OptionalBool value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OptionalBool value) {
  return os << OptionalBoolToString(value);
}

static NOINLINE const char* IconTypeToStringHelper(IconType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IconType::kUnknown:
      return "kUnknown";
    case IconType::kUncompressed:
      return "kUncompressed";
    case IconType::kCompressed:
      return "kCompressed";
    case IconType::kStandard:
      return "kStandard";
    default:
      return nullptr;
  }
}

std::string IconTypeToString(IconType value) {
  const char *str = IconTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IconType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IconType value) {
  return os << IconTypeToString(value);
}

static NOINLINE const char* LaunchSourceToStringHelper(LaunchSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LaunchSource::kUnknown:
      return "kUnknown";
    case LaunchSource::kFromAppListGrid:
      return "kFromAppListGrid";
    case LaunchSource::kFromAppListGridContextMenu:
      return "kFromAppListGridContextMenu";
    case LaunchSource::kFromAppListQuery:
      return "kFromAppListQuery";
    case LaunchSource::kFromAppListQueryContextMenu:
      return "kFromAppListQueryContextMenu";
    case LaunchSource::kFromAppListRecommendation:
      return "kFromAppListRecommendation";
    case LaunchSource::kFromParentalControls:
      return "kFromParentalControls";
    case LaunchSource::kFromShelf:
      return "kFromShelf";
    case LaunchSource::kFromFileManager:
      return "kFromFileManager";
    case LaunchSource::kFromLink:
      return "kFromLink";
    case LaunchSource::kFromOmnibox:
      return "kFromOmnibox";
    case LaunchSource::kFromChromeInternal:
      return "kFromChromeInternal";
    case LaunchSource::kFromKeyboard:
      return "kFromKeyboard";
    case LaunchSource::kFromOtherApp:
      return "kFromOtherApp";
    case LaunchSource::kFromMenu:
      return "kFromMenu";
    case LaunchSource::kFromInstalledNotification:
      return "kFromInstalledNotification";
    case LaunchSource::kFromTest:
      return "kFromTest";
    case LaunchSource::kFromArc:
      return "kFromArc";
    case LaunchSource::kFromSharesheet:
      return "kFromSharesheet";
    case LaunchSource::kFromReleaseNotesNotification:
      return "kFromReleaseNotesNotification";
    case LaunchSource::kFromFullRestore:
      return "kFromFullRestore";
    case LaunchSource::kFromSmartTextContextMenu:
      return "kFromSmartTextContextMenu";
    case LaunchSource::kFromDiscoverTabNotification:
      return "kFromDiscoverTabNotification";
    default:
      return nullptr;
  }
}

std::string LaunchSourceToString(LaunchSource value) {
  const char *str = LaunchSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LaunchSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LaunchSource value) {
  return os << LaunchSourceToString(value);
}

static NOINLINE const char* TriStateToStringHelper(TriState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TriState::kAllow:
      return "kAllow";
    case TriState::kBlock:
      return "kBlock";
    case TriState::kAsk:
      return "kAsk";
    default:
      return nullptr;
  }
}

std::string TriStateToString(TriState value) {
  const char *str = TriStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TriState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TriState value) {
  return os << TriStateToString(value);
}

static NOINLINE const char* PermissionValueTypeToStringHelper(PermissionValueType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PermissionValueType::kBool:
      return "kBool";
    case PermissionValueType::kTriState:
      return "kTriState";
    default:
      return nullptr;
  }
}

std::string PermissionValueTypeToString(PermissionValueType value) {
  const char *str = PermissionValueTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PermissionValueType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PermissionValueType value) {
  return os << PermissionValueTypeToString(value);
}

static NOINLINE const char* MenuItemTypeToStringHelper(MenuItemType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MenuItemType::kCommand:
      return "kCommand";
    case MenuItemType::kRadio:
      return "kRadio";
    case MenuItemType::kSeparator:
      return "kSeparator";
    case MenuItemType::kSubmenu:
      return "kSubmenu";
    case MenuItemType::kPublisherCommand:
      return "kPublisherCommand";
    default:
      return nullptr;
  }
}

std::string MenuItemTypeToString(MenuItemType value) {
  const char *str = MenuItemTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MenuItemType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MenuItemType value) {
  return os << MenuItemTypeToString(value);
}

static NOINLINE const char* MenuTypeToStringHelper(MenuType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MenuType::kAppList:
      return "kAppList";
    case MenuType::kShelf:
      return "kShelf";
    default:
      return nullptr;
  }
}

std::string MenuTypeToString(MenuType value) {
  const char *str = MenuTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MenuType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MenuType value) {
  return os << MenuTypeToString(value);
}

static NOINLINE const char* ConditionTypeToStringHelper(ConditionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConditionType::kScheme:
      return "kScheme";
    case ConditionType::kHost:
      return "kHost";
    case ConditionType::kPattern:
      return "kPattern";
    case ConditionType::kAction:
      return "kAction";
    case ConditionType::kMimeType:
      return "kMimeType";
    default:
      return nullptr;
  }
}

std::string ConditionTypeToString(ConditionType value) {
  const char *str = ConditionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConditionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConditionType value) {
  return os << ConditionTypeToString(value);
}

static NOINLINE const char* PatternMatchTypeToStringHelper(PatternMatchType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PatternMatchType::kNone:
      return "kNone";
    case PatternMatchType::kLiteral:
      return "kLiteral";
    case PatternMatchType::kPrefix:
      return "kPrefix";
    case PatternMatchType::kGlob:
      return "kGlob";
    case PatternMatchType::kMimeType:
      return "kMimeType";
    default:
      return nullptr;
  }
}

std::string PatternMatchTypeToString(PatternMatchType value) {
  const char *str = PatternMatchTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PatternMatchType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PatternMatchType value) {
  return os << PatternMatchTypeToString(value);
}

static NOINLINE const char* AppLaunchSourceToStringHelper(AppLaunchSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AppLaunchSource::kSourceNone:
      return "kSourceNone";
    case AppLaunchSource::kSourceUntracked:
      return "kSourceUntracked";
    case AppLaunchSource::kSourceAppLauncher:
      return "kSourceAppLauncher";
    case AppLaunchSource::kSourceNewTabPage:
      return "kSourceNewTabPage";
    case AppLaunchSource::kSourceReload:
      return "kSourceReload";
    case AppLaunchSource::kSourceRestart:
      return "kSourceRestart";
    case AppLaunchSource::kSourceLoadAndLaunch:
      return "kSourceLoadAndLaunch";
    case AppLaunchSource::kSourceCommandLine:
      return "kSourceCommandLine";
    case AppLaunchSource::kSourceFileHandler:
      return "kSourceFileHandler";
    case AppLaunchSource::kSourceUrlHandler:
      return "kSourceUrlHandler";
    case AppLaunchSource::kSourceSystemTray:
      return "kSourceSystemTray";
    case AppLaunchSource::kSourceAboutPage:
      return "kSourceAboutPage";
    case AppLaunchSource::kSourceKeyboard:
      return "kSourceKeyboard";
    case AppLaunchSource::kSourceExtensionsPage:
      return "kSourceExtensionsPage";
    case AppLaunchSource::kSourceManagementApi:
      return "kSourceManagementApi";
    case AppLaunchSource::kSourceEphemeralAppDeprecated:
      return "kSourceEphemeralAppDeprecated";
    case AppLaunchSource::kSourceBackground:
      return "kSourceBackground";
    case AppLaunchSource::kSourceKiosk:
      return "kSourceKiosk";
    case AppLaunchSource::kSourceChromeInternal:
      return "kSourceChromeInternal";
    case AppLaunchSource::kSourceTest:
      return "kSourceTest";
    case AppLaunchSource::kSourceInstalledNotification:
      return "kSourceInstalledNotification";
    case AppLaunchSource::kSourceContextMenu:
      return "kSourceContextMenu";
    case AppLaunchSource::kSourceArc:
      return "kSourceArc";
    case AppLaunchSource::kSourceIntentUrl:
      return "kSourceIntentUrl";
    case AppLaunchSource::kSourceRunOnOsLogin:
      return "kSourceRunOnOsLogin";
    default:
      return nullptr;
  }
}

std::string AppLaunchSourceToString(AppLaunchSource value) {
  const char *str = AppLaunchSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AppLaunchSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AppLaunchSource value) {
  return os << AppLaunchSourceToString(value);
}

static NOINLINE const char* LaunchContainerToStringHelper(LaunchContainer value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LaunchContainer::kLaunchContainerWindow:
      return "kLaunchContainerWindow";
    case LaunchContainer::kLaunchContainerPanelDeprecated:
      return "kLaunchContainerPanelDeprecated";
    case LaunchContainer::kLaunchContainerTab:
      return "kLaunchContainerTab";
    case LaunchContainer::kLaunchContainerNone:
      return "kLaunchContainerNone";
    default:
      return nullptr;
  }
}

std::string LaunchContainerToString(LaunchContainer value) {
  const char *str = LaunchContainerToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LaunchContainer value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LaunchContainer value) {
  return os << LaunchContainerToString(value);
}

static NOINLINE const char* WindowModeToStringHelper(WindowMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowMode::kUnknown:
      return "kUnknown";
    case WindowMode::kWindow:
      return "kWindow";
    case WindowMode::kBrowser:
      return "kBrowser";
    case WindowMode::kTabbedWindow:
      return "kTabbedWindow";
    default:
      return nullptr;
  }
}

std::string WindowModeToString(WindowMode value) {
  const char *str = WindowModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowMode value) {
  return os << WindowModeToString(value);
}

namespace internal {


// static
bool App_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const App_Data* object = static_cast<const App_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::AppType_Data
        ::Validate(object->app_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::Readiness_Data
        ::Validate(object->readiness, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams short_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->short_name, validation_context,
                                         &short_name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams publisher_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->publisher_id, validation_context,
                                         &publisher_id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams description_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams version_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_search_terms, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_search_terms_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->additional_search_terms, validation_context,
                                         &additional_search_terms_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->icon_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_launch_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->install_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions, 13, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams permissions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->permissions, validation_context,
                                         &permissions_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::InstallSource_Data
        ::Validate(object->install_source, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->is_platform_app, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->recommendable, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->searchable, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_launcher, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_shelf, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_search, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->show_in_management, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->has_badge, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->paused, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filters, 24, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams intent_filters_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->intent_filters, validation_context,
                                         &intent_filters_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->resize_locked, validation_context))
    return false;


  if (!::apps::mojom::internal::WindowMode_Data
        ::Validate(object->window_mode, validation_context))
    return false;

  return true;
}

App_Data::App_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Permission_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Permission_Data* object = static_cast<const Permission_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::PermissionValueType_Data
        ::Validate(object->value_type, validation_context))
    return false;

  return true;
}

Permission_Data::Permission_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IconKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IconKey_Data* object = static_cast<const IconKey_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

IconKey_Data::IconKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IconValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IconValue_Data* object = static_cast<const IconValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::IconType_Data
        ::Validate(object->icon_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->uncompressed, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams compressed_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->compressed, validation_context,
                                         &compressed_validate_params)) {
    return false;
  }

  return true;
}

IconValue_Data::IconValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MenuItems_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MenuItems_Data* object = static_cast<const MenuItems_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams items_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

MenuItems_Data::MenuItems_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MenuItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MenuItem_Data* object = static_cast<const MenuItem_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::MenuItemType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->submenu, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams submenu_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->submenu, validation_context,
                                         &submenu_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shortcut_id, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams shortcut_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->shortcut_id, validation_context,
                                         &shortcut_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

MenuItem_Data::MenuItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConditionValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ConditionValue_Data* object = static_cast<const ConditionValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::PatternMatchType_Data
        ::Validate(object->match_type, validation_context))
    return false;

  return true;
}

ConditionValue_Data::ConditionValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Condition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Condition_Data* object = static_cast<const Condition_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::apps::mojom::internal::ConditionType_Data
        ::Validate(object->condition_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->condition_values, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams condition_values_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->condition_values, validation_context,
                                         &condition_values_validate_params)) {
    return false;
  }

  return true;
}

Condition_Data::Condition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IntentFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IntentFilter_Data* object = static_cast<const IntentFilter_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conditions, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams conditions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->conditions, validation_context,
                                         &conditions_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams activity_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->activity_name, validation_context,
                                         &activity_name_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams activity_label_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->activity_label, validation_context,
                                         &activity_label_validate_params)) {
    return false;
  }

  return true;
}

IntentFilter_Data::IntentFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IntentFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IntentFile_Data* object = static_cast<const IntentFile_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams file_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_name, validation_context,
                                         &file_name_validate_params)) {
    return false;
  }

  return true;
}

IntentFile_Data::IntentFile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Intent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Intent_Data* object = static_cast<const Intent_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams action_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->action, validation_context,
                                         &action_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams files_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->files, validation_context,
                                         &files_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams activity_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->activity_name, validation_context,
                                         &activity_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->drive_share_url, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams share_text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->share_text, validation_context,
                                         &share_text_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams share_title_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->share_title, validation_context,
                                         &share_title_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams start_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->start_type, validation_context,
                                         &start_type_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams categories_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->categories, validation_context,
                                         &categories_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->ui_bypassed, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams extras_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->extras, validation_context,
                                         &extras_validate_params)) {
    return false;
  }

  return true;
}

Intent_Data::Intent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReplacedAppPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ReplacedAppPreferences_Data* object = static_cast<const ReplacedAppPreferences_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replaced_preference, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams replaced_preference_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->replaced_preference, validation_context,
                                         &replaced_preference_validate_params)) {
    return false;
  }

  return true;
}

ReplacedAppPreferences_Data::ReplacedAppPreferences_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PreferredApp_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PreferredApp_Data* object = static_cast<const PreferredApp_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intent_filter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intent_filter, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

PreferredApp_Data::PreferredApp_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilePaths_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FilePaths_Data* object = static_cast<const FilePaths_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_paths, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams file_paths_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_paths, validation_context,
                                         &file_paths_validate_params)) {
    return false;
  }

  return true;
}

FilePaths_Data::FilePaths_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CapabilityAccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CapabilityAccess_Data* object = static_cast<const CapabilityAccess_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->camera, validation_context))
    return false;


  if (!::apps::mojom::internal::OptionalBool_Data
        ::Validate(object->microphone, validation_context))
    return false;

  return true;
}

CapabilityAccess_Data::CapabilityAccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Rect_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Rect_Data* object = static_cast<const Rect_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Rect_Data::Rect_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WindowInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WindowInfo_Data* object = static_cast<const WindowInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

WindowInfo_Data::WindowInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace apps

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::AppType>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::AppType value) {
  return std::move(context).WriteString(::apps::mojom::AppTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::Readiness>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::Readiness value) {
  return std::move(context).WriteString(::apps::mojom::ReadinessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::InstallSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::InstallSource value) {
  return std::move(context).WriteString(::apps::mojom::InstallSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::UninstallSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::UninstallSource value) {
  return std::move(context).WriteString(::apps::mojom::UninstallSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::OptionalBool>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::OptionalBool value) {
  return std::move(context).WriteString(::apps::mojom::OptionalBoolToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::IconType>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::IconType value) {
  return std::move(context).WriteString(::apps::mojom::IconTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::LaunchSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::LaunchSource value) {
  return std::move(context).WriteString(::apps::mojom::LaunchSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::TriState>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::TriState value) {
  return std::move(context).WriteString(::apps::mojom::TriStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::PermissionValueType>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::PermissionValueType value) {
  return std::move(context).WriteString(::apps::mojom::PermissionValueTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::MenuItemType>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::MenuItemType value) {
  return std::move(context).WriteString(::apps::mojom::MenuItemTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::MenuType>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::MenuType value) {
  return std::move(context).WriteString(::apps::mojom::MenuTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::ConditionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::ConditionType value) {
  return std::move(context).WriteString(::apps::mojom::ConditionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::PatternMatchType>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::PatternMatchType value) {
  return std::move(context).WriteString(::apps::mojom::PatternMatchTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::AppLaunchSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::AppLaunchSource value) {
  return std::move(context).WriteString(::apps::mojom::AppLaunchSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::LaunchContainer>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::LaunchContainer value) {
  return std::move(context).WriteString(::apps::mojom::LaunchContainerToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::apps::mojom::WindowMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::apps::mojom::WindowMode value) {
  return std::move(context).WriteString(::apps::mojom::WindowModeToString(value));
}

} // namespace perfetto
