// components/services/filesystem/public/mojom/types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/filesystem/public/mojom/types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/filesystem/public/mojom/types.mojom-params-data.h"
namespace filesystem {
namespace mojom {

static NOINLINE const char* WhenceToStringHelper(Whence value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Whence::FROM_BEGIN:
      return "FROM_BEGIN";
    case Whence::FROM_CURRENT:
      return "FROM_CURRENT";
    case Whence::FROM_END:
      return "FROM_END";
    default:
      return nullptr;
  }
}

std::string WhenceToString(Whence value) {
  const char *str = WhenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Whence value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Whence value) {
  return os << WhenceToString(value);
}

static NOINLINE const char* FsFileTypeToStringHelper(FsFileType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FsFileType::UNKNOWN:
      return "UNKNOWN";
    case FsFileType::REGULAR_FILE:
      return "REGULAR_FILE";
    case FsFileType::DIRECTORY:
      return "DIRECTORY";
    default:
      return nullptr;
  }
}

std::string FsFileTypeToString(FsFileType value) {
  const char *str = FsFileTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FsFileType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FsFileType value) {
  return os << FsFileTypeToString(value);
}

namespace internal {


// static
bool TimespecOrNow_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TimespecOrNow_Data* object = static_cast<const TimespecOrNow_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TimespecOrNow_Data::TimespecOrNow_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileInformation_Data* object = static_cast<const FileInformation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::filesystem::mojom::internal::FsFileType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

FileInformation_Data::FileInformation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectoryEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DirectoryEntry_Data* object = static_cast<const DirectoryEntry_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;


  if (!::filesystem::mojom::internal::FsFileType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

DirectoryEntry_Data::DirectoryEntry_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace filesystem

namespace perfetto {

// static
void TraceFormatTraits<::filesystem::mojom::Whence>::WriteIntoTrace(
   perfetto::TracedValue context, ::filesystem::mojom::Whence value) {
  return std::move(context).WriteString(::filesystem::mojom::WhenceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::filesystem::mojom::FsFileType>::WriteIntoTrace(
   perfetto::TracedValue context, ::filesystem::mojom::FsFileType value) {
  return std::move(context).WriteString(::filesystem::mojom::FsFileTypeToString(value));
}

} // namespace perfetto
