// components/services/print_compositor/public/mojom/print_compositor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-params-data.h"
namespace printing {
namespace mojom {

static NOINLINE const char* PrintCompositor_StatusToStringHelper(PrintCompositor_Status value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrintCompositor_Status::kSuccess:
      return "kSuccess";
    case PrintCompositor_Status::kHandleMapError:
      return "kHandleMapError";
    case PrintCompositor_Status::kContentFormatError:
      return "kContentFormatError";
    case PrintCompositor_Status::kCompositingFailure:
      return "kCompositingFailure";
    default:
      return nullptr;
  }
}

std::string PrintCompositor_StatusToString(PrintCompositor_Status value) {
  const char *str = PrintCompositor_StatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrintCompositor_Status value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrintCompositor_Status value) {
  return os << PrintCompositor_StatusToString(value);
}

namespace internal {


// static
bool PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data* object = static_cast<const PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->manager, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data::PrintCompositor_SetDiscardableSharedMemoryManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_NotifyUnavailableSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_NotifyUnavailableSubframe_Params_Data* object = static_cast<const PrintCompositor_NotifyUnavailableSubframe_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PrintCompositor_NotifyUnavailableSubframe_Params_Data::PrintCompositor_NotifyUnavailableSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_AddSubframeContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_AddSubframeContent_Params_Data* object = static_cast<const PrintCompositor_AddSubframeContent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_content, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_content, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_content_info, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams subframe_content_info_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->subframe_content_info, validation_context,
                                         &subframe_content_info_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_AddSubframeContent_Params_Data::PrintCompositor_AddSubframeContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetAccessibilityTree_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_SetAccessibilityTree_Params_Data* object = static_cast<const PrintCompositor_SetAccessibilityTree_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accessibility_tree, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accessibility_tree, validation_context))
    return false;

  return true;
}

PrintCompositor_SetAccessibilityTree_Params_Data::PrintCompositor_SetAccessibilityTree_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositePageToPdf_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_CompositePageToPdf_Params_Data* object = static_cast<const PrintCompositor_CompositePageToPdf_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sk_region, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sk_region, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_content_info, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams subframe_content_info_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->subframe_content_info, validation_context,
                                         &subframe_content_info_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_CompositePageToPdf_Params_Data::PrintCompositor_CompositePageToPdf_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositePageToPdf_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_CompositePageToPdf_ResponseParams_Data* object = static_cast<const PrintCompositor_CompositePageToPdf_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pdf_region, validation_context))
    return false;

  return true;
}

PrintCompositor_CompositePageToPdf_ResponseParams_Data::PrintCompositor_CompositePageToPdf_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositeDocumentToPdf_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_CompositeDocumentToPdf_Params_Data* object = static_cast<const PrintCompositor_CompositeDocumentToPdf_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sk_region, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sk_region, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_content_info, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams subframe_content_info_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->subframe_content_info, validation_context,
                                         &subframe_content_info_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_CompositeDocumentToPdf_Params_Data::PrintCompositor_CompositeDocumentToPdf_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data* object = static_cast<const PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pdf_region, validation_context))
    return false;

  return true;
}

PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data::PrintCompositor_CompositeDocumentToPdf_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_PrepareForDocumentToPdf_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_PrepareForDocumentToPdf_Params_Data* object = static_cast<const PrintCompositor_PrepareForDocumentToPdf_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PrintCompositor_PrepareForDocumentToPdf_Params_Data::PrintCompositor_PrepareForDocumentToPdf_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data* object = static_cast<const PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data::PrintCompositor_PrepareForDocumentToPdf_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompleteDocumentToPdf_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_CompleteDocumentToPdf_Params_Data* object = static_cast<const PrintCompositor_CompleteDocumentToPdf_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PrintCompositor_CompleteDocumentToPdf_Params_Data::PrintCompositor_CompleteDocumentToPdf_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data* object = static_cast<const PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pdf_region, validation_context))
    return false;

  return true;
}

PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data::PrintCompositor_CompleteDocumentToPdf_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetWebContentsURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_SetWebContentsURL_Params_Data* object = static_cast<const PrintCompositor_SetWebContentsURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PrintCompositor_SetWebContentsURL_Params_Data::PrintCompositor_SetWebContentsURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetUserAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PrintCompositor_SetUserAgent_Params_Data* object = static_cast<const PrintCompositor_SetUserAgent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_agent, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams user_agent_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->user_agent, validation_context,
                                         &user_agent_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_SetUserAgent_Params_Data::PrintCompositor_SetUserAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PrintCompositor_Status>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PrintCompositor_Status value) {
  return std::move(context).WriteString(::printing::mojom::PrintCompositor_StatusToString(value));
}

} // namespace perfetto
