// components/services/quarantine/public/mojom/quarantine.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/quarantine/public/mojom/quarantine.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/quarantine/public/mojom/quarantine.mojom-params-data.h"
#include "components/services/quarantine/public/mojom/quarantine.mojom-shared-message-ids.h"

#include "components/services/quarantine/public/mojom/quarantine.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_JUMBO_H_
#endif
namespace quarantine {
namespace mojom {
const char Quarantine::Name_[] = "quarantine.mojom.Quarantine";

class Quarantine_QuarantineFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Quarantine_QuarantineFile_ForwardToCallback(
      Quarantine::QuarantineFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Quarantine::QuarantineFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Quarantine_QuarantineFile_ForwardToCallback);
};

QuarantineProxy::QuarantineProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuarantineProxy::QuarantineFile(
    const ::base::FilePath& in_full_path, const ::GURL& in_source_url, const ::GURL& in_referrer_url, const std::string& in_client_guid, QuarantineFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "quarantine::mojom::Quarantine::QuarantineFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("full_path"), in_full_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("referrer_url"), in_referrer_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_guid"), in_client_guid,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuarantine_QuarantineFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::quarantine::mojom::internal::Quarantine_QuarantineFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->full_path)::BaseType> full_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_full_path, full_path_fragment);
  params->full_path.Set(
      full_path_fragment.is_null() ? nullptr : full_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->full_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null full_path in Quarantine.QuarantineFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_source_url, source_url_fragment);
  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_url in Quarantine.QuarantineFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->referrer_url)::BaseType> referrer_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_referrer_url, referrer_url_fragment);
  params->referrer_url.Set(
      referrer_url_fragment.is_null() ? nullptr : referrer_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->referrer_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referrer_url in Quarantine.QuarantineFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_guid)::BaseType> client_guid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_client_guid, client_guid_fragment);
  params->client_guid.Set(
      client_guid_fragment.is_null() ? nullptr : client_guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_guid in Quarantine.QuarantineFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Quarantine::Name_);
  message.set_method_name("QuarantineFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Quarantine_QuarantineFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Quarantine_QuarantineFile_ProxyToResponder {
 public:
  static Quarantine::QuarantineFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Quarantine_QuarantineFile_ProxyToResponder> proxy(
        new Quarantine_QuarantineFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Quarantine_QuarantineFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Quarantine_QuarantineFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Quarantine_QuarantineFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Quarantine::QuarantineFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      QuarantineFileResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Quarantine_QuarantineFile_ProxyToResponder);
};

bool Quarantine_QuarantineFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "quarantine::mojom::Quarantine::QuarantineFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Quarantine_QuarantineFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Quarantine_QuarantineFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  QuarantineFileResult p_result{};
  Quarantine_QuarantineFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Quarantine::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Quarantine_QuarantineFile_ProxyToResponder::Run(
    QuarantineFileResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)quarantine::mojom::Quarantine::QuarantineFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type QuarantineFileResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kQuarantine_QuarantineFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::quarantine::mojom::internal::Quarantine_QuarantineFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::quarantine::mojom::QuarantineFileResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)quarantine::mojom::Quarantine::QuarantineFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Quarantine::Name_);
  message.set_method_name("QuarantineFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuarantineStubDispatch::Accept(
    Quarantine* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuarantine_QuarantineFile_Name: {
      break;
    }
  }
  return false;
}

// static
bool QuarantineStubDispatch::AcceptWithResponder(
    Quarantine* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuarantine_QuarantineFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)quarantine::mojom::Quarantine::QuarantineFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)quarantine::mojom::Quarantine::QuarantineFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Quarantine_QuarantineFile_Params_Data* params =
          reinterpret_cast<
              internal::Quarantine_QuarantineFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_full_path{};
      ::GURL p_source_url{};
      ::GURL p_referrer_url{};
      std::string p_client_guid{};
      Quarantine_QuarantineFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFullPath(&p_full_path))
        success = false;
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (success && !input_data_view.ReadReferrerUrl(&p_referrer_url))
        success = false;
      if (success && !input_data_view.ReadClientGuid(&p_client_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Quarantine::Name_, 0, false);
        return false;
      }
      Quarantine::QuarantineFileCallback callback =
          Quarantine_QuarantineFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QuarantineFile(
std::move(p_full_path), 
std::move(p_source_url), 
std::move(p_referrer_url), 
std::move(p_client_guid), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuarantineValidationInfo[] = {
    {internal::kQuarantine_QuarantineFile_Name,
     {&internal::Quarantine_QuarantineFile_Params_Data::Validate,
      &internal::Quarantine_QuarantineFile_ResponseParams_Data::Validate}},
};

bool QuarantineRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::quarantine::mojom::Quarantine::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuarantineValidationInfo);
}

bool QuarantineResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::quarantine::mojom::Quarantine::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kQuarantineValidationInfo);

}
}  // namespace mojom
}  // namespace quarantine

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif