// components/services/unzip/public/mojom/unzipper.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "components/services/unzip/public/mojom/unzipper.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "components/services/filesystem/public/mojom/directory.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/read_only_file.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"


#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_JUMBO_H_
#endif


namespace unzip {
namespace mojom {


void UnzipFilterInterceptorForTesting::ShouldUnzipFile(const ::base::FilePath& path, ShouldUnzipFileCallback callback) {
  GetForwardingInterface()->ShouldUnzipFile(std::move(path), std::move(callback));
}
UnzipFilterAsyncWaiter::UnzipFilterAsyncWaiter(
    UnzipFilter* proxy) : proxy_(proxy) {}

UnzipFilterAsyncWaiter::~UnzipFilterAsyncWaiter() = default;

void UnzipFilterAsyncWaiter::ShouldUnzipFile(
    const ::base::FilePath& path, bool* out_result) {
  base::RunLoop loop;
  proxy_->ShouldUnzipFile(std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void UnzipperInterceptorForTesting::Unzip(::base::File zip_file, ::mojo::PendingRemote<::filesystem::mojom::Directory> output_dir, UnzipCallback callback) {
  GetForwardingInterface()->Unzip(std::move(zip_file), std::move(output_dir), std::move(callback));
}
void UnzipperInterceptorForTesting::UnzipWithFilter(::base::File zip_file, ::mojo::PendingRemote<::filesystem::mojom::Directory> output_dir, ::mojo::PendingRemote<UnzipFilter> filter, UnzipWithFilterCallback callback) {
  GetForwardingInterface()->UnzipWithFilter(std::move(zip_file), std::move(output_dir), std::move(filter), std::move(callback));
}
UnzipperAsyncWaiter::UnzipperAsyncWaiter(
    Unzipper* proxy) : proxy_(proxy) {}

UnzipperAsyncWaiter::~UnzipperAsyncWaiter() = default;

void UnzipperAsyncWaiter::Unzip(
    ::base::File zip_file, ::mojo::PendingRemote<::filesystem::mojom::Directory> output_dir, bool* out_result) {
  base::RunLoop loop;
  proxy_->Unzip(std::move(zip_file),std::move(output_dir),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void UnzipperAsyncWaiter::UnzipWithFilter(
    ::base::File zip_file, ::mojo::PendingRemote<::filesystem::mojom::Directory> output_dir, ::mojo::PendingRemote<UnzipFilter> filter, bool* out_result) {
  base::RunLoop loop;
  proxy_->UnzipWithFilter(std::move(zip_file),std::move(output_dir),std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}





}  // namespace mojom
}  // namespace unzip

#if defined(__clang__)
#pragma clang diagnostic pop
#endif