// content/browser/process_internals/process_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/process_internals/process_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/process_internals/process_internals.mojom-params-data.h"
namespace mojom {

static NOINLINE const char* FrameInfo_TypeToStringHelper(FrameInfo_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FrameInfo_Type::kActive:
      return "kActive";
    case FrameInfo_Type::kBackForwardCache:
      return "kBackForwardCache";
    case FrameInfo_Type::kPrerender:
      return "kPrerender";
    default:
      return nullptr;
  }
}

std::string FrameInfo_TypeToString(FrameInfo_Type value) {
  const char *str = FrameInfo_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FrameInfo_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FrameInfo_Type value) {
  return os << FrameInfo_TypeToString(value);
}

namespace internal {


// static
bool SiteInstanceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SiteInstanceInfo_Data* object = static_cast<const SiteInstanceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->site_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->process_lock_url, validation_context))
    return false;

  return true;
}

SiteInstanceInfo_Data::SiteInstanceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameInfo_Data* object = static_cast<const FrameInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_instance, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_instance, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->last_committed_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframes, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams subframes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->subframes, validation_context,
                                         &subframes_validate_params)) {
    return false;
  }


  if (!::mojom::internal::FrameInfo_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

FrameInfo_Data::FrameInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentsInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebContentsInfo_Data* object = static_cast<const WebContentsInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams title_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_frame, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_frame, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bfcached_root_frames, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams bfcached_root_frames_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bfcached_root_frames, validation_context,
                                         &bfcached_root_frames_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prerender_root_frames, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams prerender_root_frames_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->prerender_root_frames, validation_context,
                                         &prerender_root_frames_validate_params)) {
    return false;
  }

  return true;
}

WebContentsInfo_Data::WebContentsInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool IsolatedOriginInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IsolatedOriginInfo_Data* object = static_cast<const IsolatedOriginInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams origin_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->origin, validation_context,
                                         &origin_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams source_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->source, validation_context,
                                         &source_validate_params)) {
    return false;
  }

  return true;
}

IsolatedOriginInfo_Data::IsolatedOriginInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetIsolationMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetIsolationMode_Params_Data* object = static_cast<const ProcessInternalsHandler_GetIsolationMode_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProcessInternalsHandler_GetIsolationMode_Params_Data::ProcessInternalsHandler_GetIsolationMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data* object = static_cast<const ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mode, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mode_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mode, validation_context,
                                         &mode_validate_params)) {
    return false;
  }

  return true;
}

ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data* object = static_cast<const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data* object = static_cast<const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolated_origins, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams isolated_origins_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->isolated_origins, validation_context,
                                         &isolated_origins_validate_params)) {
    return false;
  }

  return true;
}

ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data* object = static_cast<const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data* object = static_cast<const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolated_origins, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams isolated_origins_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->isolated_origins, validation_context,
                                         &isolated_origins_validate_params)) {
    return false;
  }

  return true;
}

ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data* object = static_cast<const ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data* object = static_cast<const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolated_origins, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams isolated_origins_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->isolated_origins, validation_context,
                                         &isolated_origins_validate_params)) {
    return false;
  }

  return true;
}

ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data* object = static_cast<const ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data* object = static_cast<const ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->infos, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams infos_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->infos, validation_context,
                                         &infos_validate_params)) {
    return false;
  }

  return true;
}

ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom

namespace perfetto {

// static
void TraceFormatTraits<::mojom::FrameInfo_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojom::FrameInfo_Type value) {
  return std::move(context).WriteString(::mojom::FrameInfo_TypeToString(value));
}

} // namespace perfetto
