// content/common/agent_scheduling_group.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/agent_scheduling_group.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/agent_scheduling_group.mojom-params-data.h"
#include "content/common/agent_scheduling_group.mojom-shared-message-ids.h"

#include "content/common/agent_scheduling_group.mojom-import-headers.h"


#ifndef CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_JUMBO_H_
#define CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_JUMBO_H_
#include "third_party/blink/common/permissions_policy/permissions_policy_mojom_traits.h"
#endif
namespace content {
namespace mojom {
const char AgentSchedulingGroupHost::Name_[] = "content.mojom.AgentSchedulingGroupHost";

AgentSchedulingGroupHostProxy::AgentSchedulingGroupHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AgentSchedulingGroupHostProxy::DidUnloadRenderFrame(
    const ::blink::LocalFrameToken& in_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroupHost::DidUnloadRenderFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAgentSchedulingGroupHost_DidUnloadRenderFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
      in_frame_token, frame_token_fragment);
  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_token in AgentSchedulingGroupHost.DidUnloadRenderFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroupHost::Name_);
  message.set_method_name("DidUnloadRenderFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AgentSchedulingGroupHostStubDispatch::Accept(
    AgentSchedulingGroupHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAgentSchedulingGroupHost_DidUnloadRenderFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroupHost::DidUnloadRenderFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroupHost::DidUnloadRenderFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::LocalFrameToken p_frame_token{};
      AgentSchedulingGroupHost_DidUnloadRenderFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameToken(&p_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroupHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUnloadRenderFrame(
std::move(p_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool AgentSchedulingGroupHostStubDispatch::AcceptWithResponder(
    AgentSchedulingGroupHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAgentSchedulingGroupHost_DidUnloadRenderFrame_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAgentSchedulingGroupHostValidationInfo[] = {
    {internal::kAgentSchedulingGroupHost_DidUnloadRenderFrame_Name,
     {&internal::AgentSchedulingGroupHost_DidUnloadRenderFrame_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AgentSchedulingGroupHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::AgentSchedulingGroupHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAgentSchedulingGroupHostValidationInfo);
}

const char AgentSchedulingGroup::Name_[] = "content.mojom.AgentSchedulingGroup";

AgentSchedulingGroupProxy::AgentSchedulingGroupProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AgentSchedulingGroupProxy::BindAssociatedInterfaces(
    ::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost> in_remote_host, ::mojo::PendingAssociatedRemote<::content::mojom::RouteProvider> in_remote_route_provider, ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider> in_route_provider_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::BindAssociatedInterfaces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_host"), in_remote_host,
                        "<value of type ::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_route_provider"), in_remote_route_provider,
                        "<value of type ::mojo::PendingAssociatedRemote<::content::mojom::RouteProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("route_provider_receiver"), in_route_provider_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_BindAssociatedInterfaces_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::content::mojom::AgentSchedulingGroupHostAssociatedPtrInfoDataView>(
      in_remote_host, &params->remote_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid remote_host in AgentSchedulingGroup.BindAssociatedInterfaces request");
  mojo::internal::Serialize<::content::mojom::RouteProviderAssociatedPtrInfoDataView>(
      in_remote_route_provider, &params->remote_route_provider, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote_route_provider),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid remote_route_provider in AgentSchedulingGroup.BindAssociatedInterfaces request");
  mojo::internal::Serialize<::content::mojom::RouteProviderAssociatedRequestDataView>(
      in_route_provider_receiver, &params->route_provider_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->route_provider_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid route_provider_receiver in AgentSchedulingGroup.BindAssociatedInterfaces request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("BindAssociatedInterfaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AgentSchedulingGroupProxy::CreateView(
    ::content::mojom::CreateViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::CreateView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::content::mojom::CreateViewParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_CreateView_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_CreateView_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CreateViewParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in AgentSchedulingGroup.CreateView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AgentSchedulingGroupProxy::DestroyView(
    int32_t in_view_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::DestroyView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_id"), in_view_id,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_DestroyView_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_DestroyView_Params_Data> params(
          message);
  params.Allocate();
  params->view_id = in_view_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("DestroyView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AgentSchedulingGroupProxy::CreateFrame(
    ::content::mojom::CreateFrameParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::CreateFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::content::mojom::CreateFrameParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_CreateFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_CreateFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CreateFrameParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in AgentSchedulingGroup.CreateFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AgentSchedulingGroupProxy::CreateFrameProxy(
    const ::blink::RemoteFrameToken& in_token, int32_t in_routing_id, const absl::optional<::blink::FrameToken>& in_opener_frame_token, int32_t in_view_routing_id, int32_t in_parent_routing_id, ::blink::mojom::TreeScopeType in_tree_scope_type, ::blink::mojom::FrameReplicationStatePtr in_replication_state, const ::base::UnguessableToken& in_devtools_frame_token, ::content::mojom::RemoteMainFrameInterfacesPtr in_remote_main_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::CreateFrameProxy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const absl::optional<::blink::FrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_routing_id"), in_view_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_routing_id"), in_parent_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_scope_type"), in_tree_scope_type,
                        "<value of type ::blink::mojom::TreeScopeType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replication_state"), in_replication_state,
                        "<value of type ::blink::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_main_frame_interfaces"), in_remote_main_frame_interfaces,
                        "<value of type ::content::mojom::RemoteMainFrameInterfacesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_CreateFrameProxy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in AgentSchedulingGroup.CreateFrameProxy request");
  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<decltype(params->opener_frame_token)>
      opener_frame_token_fragment(params.message());
  opener_frame_token_fragment.Claim(&params->opener_frame_token);
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_opener_frame_token, opener_frame_token_fragment, true);
  params->view_routing_id = in_view_routing_id;
  params->parent_routing_id = in_parent_routing_id;
  mojo::internal::Serialize<::blink::mojom::TreeScopeType>(
      in_tree_scope_type, &params->tree_scope_type);
  mojo::internal::MessageFragment<
      typename decltype(params->replication_state)::BaseType> replication_state_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
      in_replication_state, replication_state_fragment);
  params->replication_state.Set(
      replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->replication_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replication_state in AgentSchedulingGroup.CreateFrameProxy request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token, devtools_frame_token_fragment);
  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in AgentSchedulingGroup.CreateFrameProxy request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_main_frame_interfaces)::BaseType> remote_main_frame_interfaces_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::RemoteMainFrameInterfacesDataView>(
      in_remote_main_frame_interfaces, remote_main_frame_interfaces_fragment);
  params->remote_main_frame_interfaces.Set(
      remote_main_frame_interfaces_fragment.is_null() ? nullptr : remote_main_frame_interfaces_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_main_frame_interfaces.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_main_frame_interfaces in AgentSchedulingGroup.CreateFrameProxy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateFrameProxy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AgentSchedulingGroupStubDispatch::Accept(
    AgentSchedulingGroup* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAgentSchedulingGroup_BindAssociatedInterfaces_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::BindAssociatedInterfaces",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::BindAssociatedInterfaces");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost> p_remote_host{};
      ::mojo::PendingAssociatedRemote<::content::mojom::RouteProvider> p_remote_route_provider{};
      ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider> p_route_provider_receiver{};
      AgentSchedulingGroup_BindAssociatedInterfaces_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote_host =
            input_data_view.TakeRemoteHost<decltype(p_remote_host)>();
      }
      if (success) {
        p_remote_route_provider =
            input_data_view.TakeRemoteRouteProvider<decltype(p_remote_route_provider)>();
      }
      if (success) {
        p_route_provider_receiver =
            input_data_view.TakeRouteProviderReceiver<decltype(p_route_provider_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAssociatedInterfaces(
std::move(p_remote_host), 
std::move(p_remote_route_provider), 
std::move(p_route_provider_receiver));
      return true;
    }
    case internal::kAgentSchedulingGroup_CreateView_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::CreateView",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::CreateView");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateView_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateView_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CreateViewParamsPtr p_params{};
      AgentSchedulingGroup_CreateView_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateView(
std::move(p_params));
      return true;
    }
    case internal::kAgentSchedulingGroup_DestroyView_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::DestroyView",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::DestroyView");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_DestroyView_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_DestroyView_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_view_id{};
      AgentSchedulingGroup_DestroyView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_view_id = input_data_view.view_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyView(
std::move(p_view_id));
      return true;
    }
    case internal::kAgentSchedulingGroup_CreateFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::CreateFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::CreateFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateFrame_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::content::mojom::CreateFrameParamsPtr p_params{};
      AgentSchedulingGroup_CreateFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrame(
std::move(p_params));
      return true;
    }
    case internal::kAgentSchedulingGroup_CreateFrameProxy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::CreateFrameProxy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::CreateFrameProxy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::RemoteFrameToken p_token{};
      int32_t p_routing_id{};
      absl::optional<::blink::FrameToken> p_opener_frame_token{};
      int32_t p_view_routing_id{};
      int32_t p_parent_routing_id{};
      ::blink::mojom::TreeScopeType p_tree_scope_type{};
      ::blink::mojom::FrameReplicationStatePtr p_replication_state{};
      ::base::UnguessableToken p_devtools_frame_token{};
      ::content::mojom::RemoteMainFrameInterfacesPtr p_remote_main_frame_interfaces{};
      AgentSchedulingGroup_CreateFrameProxy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (success)
        p_view_routing_id = input_data_view.view_routing_id();
      if (success)
        p_parent_routing_id = input_data_view.parent_routing_id();
      if (success && !input_data_view.ReadTreeScopeType(&p_tree_scope_type))
        success = false;
      if (success && !input_data_view.ReadReplicationState(&p_replication_state))
        success = false;
      if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
        success = false;
      if (success && !input_data_view.ReadRemoteMainFrameInterfaces(&p_remote_main_frame_interfaces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrameProxy(
std::move(p_token), 
std::move(p_routing_id), 
std::move(p_opener_frame_token), 
std::move(p_view_routing_id), 
std::move(p_parent_routing_id), 
std::move(p_tree_scope_type), 
std::move(p_replication_state), 
std::move(p_devtools_frame_token), 
std::move(p_remote_main_frame_interfaces));
      return true;
    }
  }
  return false;
}

// static
bool AgentSchedulingGroupStubDispatch::AcceptWithResponder(
    AgentSchedulingGroup* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAgentSchedulingGroup_BindAssociatedInterfaces_Name: {
      break;
    }
    case internal::kAgentSchedulingGroup_CreateView_Name: {
      break;
    }
    case internal::kAgentSchedulingGroup_DestroyView_Name: {
      break;
    }
    case internal::kAgentSchedulingGroup_CreateFrame_Name: {
      break;
    }
    case internal::kAgentSchedulingGroup_CreateFrameProxy_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAgentSchedulingGroupValidationInfo[] = {
    {internal::kAgentSchedulingGroup_BindAssociatedInterfaces_Name,
     {&internal::AgentSchedulingGroup_BindAssociatedInterfaces_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAgentSchedulingGroup_CreateView_Name,
     {&internal::AgentSchedulingGroup_CreateView_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAgentSchedulingGroup_DestroyView_Name,
     {&internal::AgentSchedulingGroup_DestroyView_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAgentSchedulingGroup_CreateFrame_Name,
     {&internal::AgentSchedulingGroup_CreateFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAgentSchedulingGroup_CreateFrameProxy_Name,
     {&internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AgentSchedulingGroupRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::AgentSchedulingGroup::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAgentSchedulingGroupValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif