// content/common/frame.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/common/frame.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "cc/mojom/browser_controls_state.mojom.h"
#include "content/common/frame_messages.mojom.h"
#include "content/common/native_types.mojom.h"
#include "content/common/navigation_client.mojom.h"
#include "content/common/web_ui.mojom.h"
#include "content/public/common/window_container_type.mojom.h"
#include "ipc/constants.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_request.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/service_manager/public/mojom/interface_provider.mojom.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom.h"
#include "third_party/blink/public/mojom/frame/frame.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_owner_element_type.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom.h"
#include "third_party/blink/public/mojom/page/page.mojom.h"
#include "third_party/blink/public/mojom/page/widget.mojom.h"
#include "third_party/blink/public/mojom/portal/portal.mojom.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef CONTENT_COMMON_FRAME_MOJOM_JUMBO_H_
#define CONTENT_COMMON_FRAME_MOJOM_JUMBO_H_
#include "content/common/content_param_traits_macros.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "third_party/blink/common/permissions_policy/permissions_policy_mojom_traits.h"
#endif


namespace content {
namespace mojom {


void FrameHTMLSerializerHandlerInterceptorForTesting::DidReceiveData(const std::string& data_buffer) {
  GetForwardingInterface()->DidReceiveData(std::move(data_buffer));
}
void FrameHTMLSerializerHandlerInterceptorForTesting::Done() {
  GetForwardingInterface()->Done();
}
FrameHTMLSerializerHandlerAsyncWaiter::FrameHTMLSerializerHandlerAsyncWaiter(
    FrameHTMLSerializerHandler* proxy) : proxy_(proxy) {}

FrameHTMLSerializerHandlerAsyncWaiter::~FrameHTMLSerializerHandlerAsyncWaiter() = default;




void FrameInterceptorForTesting::CommitSameDocumentNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, CommitSameDocumentNavigationCallback callback) {
  GetForwardingInterface()->CommitSameDocumentNavigation(std::move(common_params), std::move(request_params), std::move(callback));
}
void FrameInterceptorForTesting::UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) {
  GetForwardingInterface()->UpdateSubresourceLoaderFactories(std::move(subresource_loader_factories));
}
void FrameInterceptorForTesting::SetWantErrorMessageStackTrace() {
  GetForwardingInterface()->SetWantErrorMessageStackTrace();
}
void FrameInterceptorForTesting::Unload(int32_t new_remote_frame_routing_id, bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces) {
  GetForwardingInterface()->Unload(std::move(new_remote_frame_routing_id), std::move(is_loading), std::move(new_remote_frame_replication_state), std::move(new_remote_frame_token), std::move(new_remote_main_frame_interfaces));
}
void FrameInterceptorForTesting::Delete(FrameDeleteIntention intention) {
  GetForwardingInterface()->Delete(std::move(intention));
}
void FrameInterceptorForTesting::UndoCommitNavigation(int32_t new_remote_frame_routing_id, bool is_loading, ::blink::mojom::FrameReplicationStatePtr new_remote_frame_replication_state, const ::blink::RemoteFrameToken& new_remote_frame_token, RemoteMainFrameInterfacesPtr new_remote_main_frame_interfaces) {
  GetForwardingInterface()->UndoCommitNavigation(std::move(new_remote_frame_routing_id), std::move(is_loading), std::move(new_remote_frame_replication_state), std::move(new_remote_frame_token), std::move(new_remote_main_frame_interfaces));
}
void FrameInterceptorForTesting::BlockRequests() {
  GetForwardingInterface()->BlockRequests();
}
void FrameInterceptorForTesting::ResumeBlockedRequests() {
  GetForwardingInterface()->ResumeBlockedRequests();
}
void FrameInterceptorForTesting::GetInterfaceProvider(::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interfaces) {
  GetForwardingInterface()->GetInterfaceProvider(std::move(interfaces));
}
void FrameInterceptorForTesting::SnapshotAccessibilityTree(SnapshotAccessibilityTreeParamsPtr params, SnapshotAccessibilityTreeCallback callback) {
  GetForwardingInterface()->SnapshotAccessibilityTree(std::move(params), std::move(callback));
}
void FrameInterceptorForTesting::GetSerializedHtmlWithLocalLinks(const base::flat_map<::GURL, ::base::FilePath>& url_map, const base::flat_map<::blink::FrameToken, ::base::FilePath>& frame_token_map, bool save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> handler_remote) {
  GetForwardingInterface()->GetSerializedHtmlWithLocalLinks(std::move(url_map), std::move(frame_token_map), std::move(save_with_empty_url), std::move(handler_remote));
}
FrameAsyncWaiter::FrameAsyncWaiter(
    Frame* proxy) : proxy_(proxy) {}

FrameAsyncWaiter::~FrameAsyncWaiter() = default;

void FrameAsyncWaiter::CommitSameDocumentNavigation(
    ::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::CommitNavigationParamsPtr request_params, ::blink::mojom::CommitResult* out_commit_result) {
  base::RunLoop loop;
  proxy_->CommitSameDocumentNavigation(std::move(common_params),std::move(request_params),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::CommitResult* out_commit_result
,
             ::blink::mojom::CommitResult commit_result) {*out_commit_result = std::move(commit_result);
            loop->Quit();
          },
          &loop,
          out_commit_result));
  loop.Run();
}
void FrameAsyncWaiter::SnapshotAccessibilityTree(
    SnapshotAccessibilityTreeParamsPtr params, ::ui::AXTreeUpdate* out_snapshot) {
  base::RunLoop loop;
  proxy_->SnapshotAccessibilityTree(std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ui::AXTreeUpdate* out_snapshot
,
             const ::ui::AXTreeUpdate& snapshot) {*out_snapshot = std::move(snapshot);
            loop->Quit();
          },
          &loop,
          out_snapshot));
  loop.Run();
}



void FrameBindingsControlInterceptorForTesting::AllowBindings(int32_t enabled_bindings_flags) {
  GetForwardingInterface()->AllowBindings(std::move(enabled_bindings_flags));
}
void FrameBindingsControlInterceptorForTesting::EnableMojoJsBindings() {
  GetForwardingInterface()->EnableMojoJsBindings();
}
void FrameBindingsControlInterceptorForTesting::BindWebUI(::mojo::PendingAssociatedReceiver<::content::mojom::WebUI> receiver, ::mojo::PendingAssociatedRemote<::content::mojom::WebUIHost> remote) {
  GetForwardingInterface()->BindWebUI(std::move(receiver), std::move(remote));
}
FrameBindingsControlAsyncWaiter::FrameBindingsControlAsyncWaiter(
    FrameBindingsControl* proxy) : proxy_(proxy) {}

FrameBindingsControlAsyncWaiter::~FrameBindingsControlAsyncWaiter() = default;




void FrameHostInterceptorForTesting::CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowCallback callback) {
  GetForwardingInterface()->CreateNewWindow(std::move(params), std::move(callback));
}
void FrameHostInterceptorForTesting::CreatePortal(::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, CreatePortalCallback callback) {
  GetForwardingInterface()->CreatePortal(std::move(portal), std::move(client), std::move(callback));
}
void FrameHostInterceptorForTesting::AdoptPortal(const ::blink::PortalToken& portal_token, AdoptPortalCallback callback) {
  GetForwardingInterface()->AdoptPortal(std::move(portal_token), std::move(callback));
}
void FrameHostInterceptorForTesting::CreateChildFrame(int32_t child_routing_id, ::mojo::PendingAssociatedRemote<Frame> frame, ::mojo::PendingReceiver<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker, ::blink::mojom::PolicyContainerBindParamsPtr policy_container_bind_params, ::blink::mojom::TreeScopeType scope, const std::string& frame_name, const std::string& frame_unique_name, bool is_created_by_script, const ::blink::FramePolicy& frame_policy, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties, ::blink::mojom::FrameOwnerElementType frame_owner_element_type) {
  GetForwardingInterface()->CreateChildFrame(std::move(child_routing_id), std::move(frame), std::move(browser_interface_broker), std::move(policy_container_bind_params), std::move(scope), std::move(frame_name), std::move(frame_unique_name), std::move(is_created_by_script), std::move(frame_policy), std::move(frame_owner_properties), std::move(frame_owner_element_type));
}
void FrameHostInterceptorForTesting::DidCommitProvisionalLoad(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) {
  GetForwardingInterface()->DidCommitProvisionalLoad(std::move(params), std::move(interface_params));
}
void FrameHostInterceptorForTesting::DidCommitSameDocumentNavigation(::content::mojom::DidCommitProvisionalLoadParamsPtr params, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr same_document_params) {
  GetForwardingInterface()->DidCommitSameDocumentNavigation(std::move(params), std::move(same_document_params));
}
void FrameHostInterceptorForTesting::DidOpenDocumentInputStream(const ::GURL& url) {
  GetForwardingInterface()->DidOpenDocumentInputStream(std::move(url));
}
void FrameHostInterceptorForTesting::BeginNavigation(::blink::mojom::CommonNavigationParamsPtr common_params, ::blink::mojom::BeginNavigationParamsPtr begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> navigation_client, ::mojo::PendingRemote<::blink::mojom::PolicyContainerHostKeepAliveHandle> initiator_policy_container_keep_alive_handle) {
  GetForwardingInterface()->BeginNavigation(std::move(common_params), std::move(begin_params), std::move(blob_url_token), std::move(navigation_client), std::move(initiator_policy_container_keep_alive_handle));
}
void FrameHostInterceptorForTesting::SubresourceResponseStarted(const ::GURL& url, uint32_t cert_status) {
  GetForwardingInterface()->SubresourceResponseStarted(std::move(url), std::move(cert_status));
}
void FrameHostInterceptorForTesting::ResourceLoadComplete(::blink::mojom::ResourceLoadInfoPtr url_load_info) {
  GetForwardingInterface()->ResourceLoadComplete(std::move(url_load_info));
}
void FrameHostInterceptorForTesting::DidChangeName(const std::string& name, const std::string& unique_name) {
  GetForwardingInterface()->DidChangeName(std::move(name), std::move(unique_name));
}
void FrameHostInterceptorForTesting::CancelInitialHistoryLoad() {
  GetForwardingInterface()->CancelInitialHistoryLoad();
}
void FrameHostInterceptorForTesting::UpdateEncoding(const std::string& encoding_name) {
  GetForwardingInterface()->UpdateEncoding(std::move(encoding_name));
}
void FrameHostInterceptorForTesting::UpdateState(const ::blink::PageState& state) {
  GetForwardingInterface()->UpdateState(std::move(state));
}
void FrameHostInterceptorForTesting::OpenURL(::blink::mojom::OpenURLParamsPtr params) {
  GetForwardingInterface()->OpenURL(std::move(params));
}
void FrameHostInterceptorForTesting::DidStopLoading() {
  GetForwardingInterface()->DidStopLoading();
}
FrameHostAsyncWaiter::FrameHostAsyncWaiter(
    FrameHost* proxy) : proxy_(proxy) {}

FrameHostAsyncWaiter::~FrameHostAsyncWaiter() = default;

void FrameHostAsyncWaiter::CreateNewWindow(
    CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply) {
  base::RunLoop loop;
  proxy_->CreateNewWindow(std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateNewWindowStatus* out_status
,
             CreateNewWindowReplyPtr* out_reply
,
             CreateNewWindowStatus status,
             CreateNewWindowReplyPtr reply) {*out_status = std::move(status);*out_reply = std::move(reply);
            loop->Quit();
          },
          &loop,
          out_status,
          out_reply));
  loop.Run();
}
void FrameHostAsyncWaiter::CreatePortal(
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, int32_t* out_proxy_routing_id, ::blink::mojom::FrameReplicationStatePtr* out_initial_replicated_state, ::blink::PortalToken* out_portal_token, ::blink::RemoteFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  base::RunLoop loop;
  proxy_->CreatePortal(std::move(portal),std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_proxy_routing_id
,
             ::blink::mojom::FrameReplicationStatePtr* out_initial_replicated_state
,
             ::blink::PortalToken* out_portal_token
,
             ::blink::RemoteFrameToken* out_frame_token
,
             ::base::UnguessableToken* out_devtools_frame_token
,
             int32_t proxy_routing_id,
             ::blink::mojom::FrameReplicationStatePtr initial_replicated_state,
             const ::blink::PortalToken& portal_token,
             const ::blink::RemoteFrameToken& frame_token,
             const ::base::UnguessableToken& devtools_frame_token) {*out_proxy_routing_id = std::move(proxy_routing_id);*out_initial_replicated_state = std::move(initial_replicated_state);*out_portal_token = std::move(portal_token);*out_frame_token = std::move(frame_token);*out_devtools_frame_token = std::move(devtools_frame_token);
            loop->Quit();
          },
          &loop,
          out_proxy_routing_id,
          out_initial_replicated_state,
          out_portal_token,
          out_frame_token,
          out_devtools_frame_token));
  loop.Run();
}
void FrameHostAsyncWaiter::AdoptPortal(
    const ::blink::PortalToken& portal_token, int32_t* out_proxy_routing_id, ::blink::mojom::FrameReplicationStatePtr* out_replicated_state, ::blink::RemoteFrameToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) {
  base::RunLoop loop;
  proxy_->AdoptPortal(std::move(portal_token),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_proxy_routing_id
,
             ::blink::mojom::FrameReplicationStatePtr* out_replicated_state
,
             ::blink::RemoteFrameToken* out_frame_token
,
             ::base::UnguessableToken* out_devtools_frame_token
,
             int32_t proxy_routing_id,
             ::blink::mojom::FrameReplicationStatePtr replicated_state,
             const ::blink::RemoteFrameToken& frame_token,
             const ::base::UnguessableToken& devtools_frame_token) {*out_proxy_routing_id = std::move(proxy_routing_id);*out_replicated_state = std::move(replicated_state);*out_frame_token = std::move(frame_token);*out_devtools_frame_token = std::move(devtools_frame_token);
            loop->Quit();
          },
          &loop,
          out_proxy_routing_id,
          out_replicated_state,
          out_frame_token,
          out_devtools_frame_token));
  loop.Run();
}





}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif