// content/common/navigation_client.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/navigation_client.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/navigation_client.mojom-params-data.h"
namespace content {
namespace mojom {

namespace internal {


// static
bool DidCommitProvisionalLoadParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 184, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DidCommitProvisionalLoadParams_Data* object = static_cast<const DidCommitProvisionalLoadParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_history_key, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams app_history_key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->app_history_key, validation_context,
                                         &app_history_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->virtual_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->virtual_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::content::mojom::internal::PageTransition_Data
        ::Validate(object->transition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents_mime_type, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams contents_mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->contents_mime_type, validation_context,
                                         &contents_mime_type_validate_params)) {
    return false;
  }


  if (!::content::mojom::internal::NavigationGesture_Data
        ::Validate(object->gesture, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 14, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_state, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 21, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions_policy_header, 22, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams permissions_policy_header_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->permissions_policy_header, validation_context,
                                         &permissions_policy_header_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_policy_header, 23, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams document_policy_header_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::DocumentPolicyFeature_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->document_policy_header, validation_context,
                                         &document_policy_header_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::InsecureRequestPolicy_Data
        ::Validate(object->insecure_request_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->insecure_navigations_set, 25, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams insecure_navigations_set_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->insecure_navigations_set, validation_context,
                                         &insecure_navigations_set_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_token, 28, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->embedding_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->unload_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->unload_end, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->commit_navigation_end, validation_context))
    return false;

  return true;
}

DidCommitProvisionalLoadParams_Data::DidCommitProvisionalLoadParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DidCommitSameDocumentNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DidCommitSameDocumentNavigationParams_Data* object = static_cast<const DidCommitSameDocumentNavigationParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::SameDocumentNavigationType_Data
        ::Validate(object->same_document_navigation_type, validation_context))
    return false;

  return true;
}

DidCommitSameDocumentNavigationParams_Data::DidCommitSameDocumentNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieManagerInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CookieManagerInfo_Data* object = static_cast<const CookieManagerInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cookie_manager, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cookie_manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CookieManagerInfo_Data::CookieManagerInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StorageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const StorageInfo_Data* object = static_cast<const StorageInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->local_storage_area,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->session_storage_area,
                                                 validation_context)) {
    return false;
  }

  return true;
}

StorageInfo_Data::StorageInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 128, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitNavigation_Params_Data* object = static_cast<const NavigationClient_CommitNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->common_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->common_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_head, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_head, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->response_body,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->url_loader_client_endpoints, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams subresource_overrides_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->subresource_overrides, validation_context,
                                         &subresource_overrides_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->controller_service_worker_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->container_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->prefetch_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_navigation_token, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_navigation_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_container, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_container, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->code_cache_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->cookie_manager_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->storage_info, validation_context))
    return false;

  return true;
}

NavigationClient_CommitNavigation_Params_Data::NavigationClient_CommitNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitNavigation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitNavigation_ResponseParams_Data* object = static_cast<const NavigationClient_CommitNavigation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->interface_params, validation_context))
    return false;

  return true;
}

NavigationClient_CommitNavigation_ResponseParams_Data::NavigationClient_CommitNavigation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitFailedNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitFailedNavigation_Params_Data* object = static_cast<const NavigationClient_CommitFailedNavigation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->common_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->common_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolve_error_info, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resolve_error_info, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams error_page_content_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error_page_content, validation_context,
                                         &error_page_content_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->subresource_loader_factories, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_container, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policy_container, validation_context))
    return false;

  return true;
}

NavigationClient_CommitFailedNavigation_Params_Data::NavigationClient_CommitFailedNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationClient_CommitFailedNavigation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationClient_CommitFailedNavigation_ResponseParams_Data* object = static_cast<const NavigationClient_CommitFailedNavigation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->interface_params, validation_context))
    return false;

  return true;
}

NavigationClient_CommitFailedNavigation_ResponseParams_Data::NavigationClient_CommitFailedNavigation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content
