// content/common/navigation_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/navigation_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/navigation_client.mojom-params-data.h"
#include "content/common/navigation_client.mojom-shared-message-ids.h"

#include "content/common/navigation_client.mojom-import-headers.h"


#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_JUMBO_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_JUMBO_H_
#include "content/common/content_param_traits_macros.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "third_party/blink/common/permissions_policy/permissions_policy_mojom_traits.h"
#endif
namespace content {
namespace mojom {
DidCommitProvisionalLoadParams::DidCommitProvisionalLoadParams()
    : item_sequence_number(-1),
      document_sequence_number(-1),
      app_history_key(),
      url(),
      virtual_url(),
      referrer(),
      transition(),
      should_update_history(false),
      contents_mime_type(),
      intended_as_new_entry(),
      did_create_new_entry(),
      should_replace_current_entry(),
      gesture(),
      method(),
      post_id(),
      http_status_code(),
      url_is_unreachable(),
      page_state(),
      is_overriding_user_agent(),
      history_list_was_cleared(),
      origin(),
      permissions_policy_header(),
      document_policy_header(),
      insecure_request_policy(),
      insecure_navigations_set(),
      has_potentially_trustworthy_unique_origin(),
      request_id(),
      navigation_token(),
      embedding_token(),
      unload_start(),
      unload_end(),
      commit_navigation_end() {}

DidCommitProvisionalLoadParams::DidCommitProvisionalLoadParams(
    int64_t item_sequence_number_in,
    int64_t document_sequence_number_in,
    const std::string& app_history_key_in,
    const ::GURL& url_in,
    const ::GURL& virtual_url_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::ui::PageTransition transition_in,
    bool should_update_history_in,
    const std::string& contents_mime_type_in,
    bool intended_as_new_entry_in,
    bool did_create_new_entry_in,
    bool should_replace_current_entry_in,
    ::content::NavigationGesture gesture_in,
    const std::string& method_in,
    int64_t post_id_in,
    int32_t http_status_code_in,
    bool url_is_unreachable_in,
    const ::blink::PageState& page_state_in,
    bool is_overriding_user_agent_in,
    bool history_list_was_cleared_in,
    const ::url::Origin& origin_in,
    std::vector<::blink::ParsedPermissionsPolicyDeclaration> permissions_policy_header_in,
    const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& document_policy_header_in,
    ::blink::mojom::InsecureRequestPolicy insecure_request_policy_in,
    std::vector<uint32_t> insecure_navigations_set_in,
    bool has_potentially_trustworthy_unique_origin_in,
    int32_t request_id_in,
    const ::base::UnguessableToken& navigation_token_in,
    const absl::optional<::base::UnguessableToken>& embedding_token_in,
    absl::optional<::base::TimeTicks> unload_start_in,
    absl::optional<::base::TimeTicks> unload_end_in,
    absl::optional<::base::TimeTicks> commit_navigation_end_in)
    : item_sequence_number(std::move(item_sequence_number_in)),
      document_sequence_number(std::move(document_sequence_number_in)),
      app_history_key(std::move(app_history_key_in)),
      url(std::move(url_in)),
      virtual_url(std::move(virtual_url_in)),
      referrer(std::move(referrer_in)),
      transition(std::move(transition_in)),
      should_update_history(std::move(should_update_history_in)),
      contents_mime_type(std::move(contents_mime_type_in)),
      intended_as_new_entry(std::move(intended_as_new_entry_in)),
      did_create_new_entry(std::move(did_create_new_entry_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      gesture(std::move(gesture_in)),
      method(std::move(method_in)),
      post_id(std::move(post_id_in)),
      http_status_code(std::move(http_status_code_in)),
      url_is_unreachable(std::move(url_is_unreachable_in)),
      page_state(std::move(page_state_in)),
      is_overriding_user_agent(std::move(is_overriding_user_agent_in)),
      history_list_was_cleared(std::move(history_list_was_cleared_in)),
      origin(std::move(origin_in)),
      permissions_policy_header(std::move(permissions_policy_header_in)),
      document_policy_header(std::move(document_policy_header_in)),
      insecure_request_policy(std::move(insecure_request_policy_in)),
      insecure_navigations_set(std::move(insecure_navigations_set_in)),
      has_potentially_trustworthy_unique_origin(std::move(has_potentially_trustworthy_unique_origin_in)),
      request_id(std::move(request_id_in)),
      navigation_token(std::move(navigation_token_in)),
      embedding_token(std::move(embedding_token_in)),
      unload_start(std::move(unload_start_in)),
      unload_end(std::move(unload_end_in)),
      commit_navigation_end(std::move(commit_navigation_end_in)) {}

DidCommitProvisionalLoadParams::~DidCommitProvisionalLoadParams() = default;

void DidCommitProvisionalLoadParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item_sequence_number"), this->item_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_sequence_number"), this->document_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_history_key"), this->app_history_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "virtual_url"), this->virtual_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition"), this->transition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::PageTransition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_update_history"), this->should_update_history,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_mime_type"), this->contents_mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intended_as_new_entry"), this->intended_as_new_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "did_create_new_entry"), this->did_create_new_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_replace_current_entry"), this->should_replace_current_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture"), this->gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::content::NavigationGesture>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_id"), this->post_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_status_code"), this->http_status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_is_unreachable"), this->url_is_unreachable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_state"), this->page_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::PageState&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_overriding_user_agent"), this->is_overriding_user_agent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "history_list_was_cleared"), this->history_list_was_cleared,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions_policy_header"), this->permissions_policy_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::ParsedPermissionsPolicyDeclaration>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_policy_header"), this->document_policy_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_request_policy"), this->insecure_request_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::InsecureRequestPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_navigations_set"), this->insecure_navigations_set,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_potentially_trustworthy_unique_origin"), this->has_potentially_trustworthy_unique_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_token"), this->navigation_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedding_token"), this->embedding_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unload_start"), this->unload_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unload_end"), this->unload_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "commit_navigation_end"), this->commit_navigation_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidCommitProvisionalLoadParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidCommitSameDocumentNavigationParams::DidCommitSameDocumentNavigationParams()
    : same_document_navigation_type(),
      is_client_redirect(false) {}

DidCommitSameDocumentNavigationParams::DidCommitSameDocumentNavigationParams(
    ::blink::mojom::SameDocumentNavigationType same_document_navigation_type_in,
    bool is_client_redirect_in)
    : same_document_navigation_type(std::move(same_document_navigation_type_in)),
      is_client_redirect(std::move(is_client_redirect_in)) {}

DidCommitSameDocumentNavigationParams::~DidCommitSameDocumentNavigationParams() = default;
size_t DidCommitSameDocumentNavigationParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->same_document_navigation_type);
  seed = mojo::internal::Hash(seed, this->is_client_redirect);
  return seed;
}

void DidCommitSameDocumentNavigationParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_document_navigation_type"), this->same_document_navigation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::SameDocumentNavigationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_client_redirect"), this->is_client_redirect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidCommitSameDocumentNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieManagerInfo::CookieManagerInfo()
    : origin(),
      cookie_manager() {}

CookieManagerInfo::CookieManagerInfo(
    const ::url::Origin& origin_in,
    ::mojo::PendingRemote<::network::mojom::RestrictedCookieManager> cookie_manager_in)
    : origin(std::move(origin_in)),
      cookie_manager(std::move(cookie_manager_in)) {}

CookieManagerInfo::~CookieManagerInfo() = default;

void CookieManagerInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_manager"), this->cookie_manager,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::RestrictedCookieManager>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieManagerInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StorageInfo::StorageInfo()
    : local_storage_area(),
      session_storage_area() {}

StorageInfo::StorageInfo(
    ::mojo::PendingRemote<::blink::mojom::StorageArea> local_storage_area_in,
    ::mojo::PendingRemote<::blink::mojom::StorageArea> session_storage_area_in)
    : local_storage_area(std::move(local_storage_area_in)),
      session_storage_area(std::move(session_storage_area_in)) {}

StorageInfo::~StorageInfo() = default;

void StorageInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_storage_area"), this->local_storage_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::StorageArea>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_storage_area"), this->session_storage_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::StorageArea>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StorageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NavigationClient::Name_[] = "content.mojom.NavigationClient";

class NavigationClient_CommitNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigationClient_CommitNavigation_ForwardToCallback(
      NavigationClient::CommitNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NavigationClient::CommitNavigationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitNavigation_ForwardToCallback);
};

class NavigationClient_CommitFailedNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigationClient_CommitFailedNavigation_ForwardToCallback(
      NavigationClient::CommitFailedNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NavigationClient::CommitFailedNavigationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitFailedNavigation_ForwardToCallback);
};

NavigationClientProxy::NavigationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigationClientProxy::CommitNavigation(
    ::blink::mojom::CommonNavigationParamsPtr in_common_params, ::blink::mojom::CommitNavigationParamsPtr in_request_params, ::network::mojom::URLResponseHeadPtr in_response_head, ::mojo::ScopedDataPipeConsumerHandle in_response_body, ::network::mojom::URLLoaderClientEndpointsPtr in_url_loader_client_endpoints, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, absl::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> in_subresource_overrides, ::blink::mojom::ControllerServiceWorkerInfoPtr in_controller_service_worker_info, ::blink::mojom::ServiceWorkerContainerInfoForClientPtr in_container_info, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_prefetch_loader_factory, const ::base::UnguessableToken& in_devtools_navigation_token, ::blink::mojom::PolicyContainerPtr in_policy_container, ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> in_code_cache_host, CookieManagerInfoPtr in_cookie_manager_info, StorageInfoPtr in_storage_info, CommitNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigationClient::CommitNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params,
                        "<value of type ::blink::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_params"), in_request_params,
                        "<value of type ::blink::mojom::CommitNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_head"), in_response_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_body"), in_response_body,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_client_endpoints"), in_url_loader_client_endpoints,
                        "<value of type ::network::mojom::URLLoaderClientEndpointsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_overrides"), in_subresource_overrides,
                        "<value of type absl::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller_service_worker_info"), in_controller_service_worker_info,
                        "<value of type ::blink::mojom::ControllerServiceWorkerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("container_info"), in_container_info,
                        "<value of type ::blink::mojom::ServiceWorkerContainerInfoForClientPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prefetch_loader_factory"), in_prefetch_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_navigation_token"), in_devtools_navigation_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_container"), in_policy_container,
                        "<value of type ::blink::mojom::PolicyContainerPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code_cache_host"), in_code_cache_host,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::CodeCacheHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_manager_info"), in_cookie_manager_info,
                        "<value of type CookieManagerInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_info"), in_storage_info,
                        "<value of type StorageInfoPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNavigationClient_CommitNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CommonNavigationParamsDataView>(
      in_common_params, common_params_fragment);
  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_params)::BaseType> request_params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CommitNavigationParamsDataView>(
      in_request_params, request_params_fragment);
  params->request_params.Set(
      request_params_fragment.is_null() ? nullptr : request_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_params in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->response_head)::BaseType> response_head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_response_head, response_head_fragment);
  params->response_head.Set(
      response_head_fragment.is_null() ? nullptr : response_head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response_head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_head in NavigationClient.CommitNavigation request");
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_response_body, &params->response_body, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->url_loader_client_endpoints)::BaseType> url_loader_client_endpoints_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLLoaderClientEndpointsDataView>(
      in_url_loader_client_endpoints, url_loader_client_endpoints_fragment);
  params->url_loader_client_endpoints.Set(
      url_loader_client_endpoints_fragment.is_null() ? nullptr : url_loader_client_endpoints_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, subresource_loader_factories_fragment);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_overrides)::BaseType>
      subresource_overrides_fragment(params.message());
  const mojo::internal::ContainerValidateParams subresource_overrides_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>>(
      in_subresource_overrides, subresource_overrides_fragment, &subresource_overrides_validate_params);
  params->subresource_overrides.Set(
      subresource_overrides_fragment.is_null() ? nullptr : subresource_overrides_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->controller_service_worker_info)::BaseType> controller_service_worker_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
      in_controller_service_worker_info, controller_service_worker_info_fragment);
  params->controller_service_worker_info.Set(
      controller_service_worker_info_fragment.is_null() ? nullptr : controller_service_worker_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->container_info)::BaseType> container_info_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
      in_container_info, container_info_fragment);
  params->container_info.Set(
      container_info_fragment.is_null() ? nullptr : container_info_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_prefetch_loader_factory, &params->prefetch_loader_factory, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_navigation_token)::BaseType> devtools_navigation_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_navigation_token, devtools_navigation_token_fragment);
  params->devtools_navigation_token.Set(
      devtools_navigation_token_fragment.is_null() ? nullptr : devtools_navigation_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_navigation_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_navigation_token in NavigationClient.CommitNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy_container)::BaseType> policy_container_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
      in_policy_container, policy_container_fragment);
  params->policy_container.Set(
      policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_container.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_container in NavigationClient.CommitNavigation request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::CodeCacheHostInterfaceBase>>(
      in_code_cache_host, &params->code_cache_host, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_manager_info)::BaseType> cookie_manager_info_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::CookieManagerInfoDataView>(
      in_cookie_manager_info, cookie_manager_info_fragment);
  params->cookie_manager_info.Set(
      cookie_manager_info_fragment.is_null() ? nullptr : cookie_manager_info_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->storage_info)::BaseType> storage_info_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::StorageInfoDataView>(
      in_storage_info, storage_info_fragment);
  params->storage_info.Set(
      storage_info_fragment.is_null() ? nullptr : storage_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigationClient_CommitNavigation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NavigationClientProxy::CommitFailedNavigation(
    ::blink::mojom::CommonNavigationParamsPtr in_common_params, ::blink::mojom::CommitNavigationParamsPtr in_request_params, bool in_has_stale_copy_in_cache, int32_t in_error_code, int32_t in_extended_error_code, const ::net::ResolveErrorInfo& in_resolve_error_info, const absl::optional<std::string>& in_error_page_content, ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> in_subresource_loader_factories, ::blink::mojom::PolicyContainerPtr in_policy_container, CommitFailedNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigationClient::CommitFailedNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("common_params"), in_common_params,
                        "<value of type ::blink::mojom::CommonNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_params"), in_request_params,
                        "<value of type ::blink::mojom::CommitNavigationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_stale_copy_in_cache"), in_has_stale_copy_in_cache,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extended_error_code"), in_extended_error_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolve_error_info"), in_resolve_error_info,
                        "<value of type const ::net::ResolveErrorInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_page_content"), in_error_page_content,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_loader_factories"), in_subresource_loader_factories,
                        "<value of type ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_container"), in_policy_container,
                        "<value of type ::blink::mojom::PolicyContainerPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNavigationClient_CommitFailedNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitFailedNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->common_params)::BaseType> common_params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CommonNavigationParamsDataView>(
      in_common_params, common_params_fragment);
  params->common_params.Set(
      common_params_fragment.is_null() ? nullptr : common_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->common_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null common_params in NavigationClient.CommitFailedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_params)::BaseType> request_params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::CommitNavigationParamsDataView>(
      in_request_params, request_params_fragment);
  params->request_params.Set(
      request_params_fragment.is_null() ? nullptr : request_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_params in NavigationClient.CommitFailedNavigation request");
  params->has_stale_copy_in_cache = in_has_stale_copy_in_cache;
  params->error_code = in_error_code;
  params->extended_error_code = in_extended_error_code;
  mojo::internal::MessageFragment<
      typename decltype(params->resolve_error_info)::BaseType> resolve_error_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView>(
      in_resolve_error_info, resolve_error_info_fragment);
  params->resolve_error_info.Set(
      resolve_error_info_fragment.is_null() ? nullptr : resolve_error_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resolve_error_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resolve_error_info in NavigationClient.CommitFailedNavigation request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_page_content)::BaseType> error_page_content_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_page_content, error_page_content_fragment);
  params->error_page_content.Set(
      error_page_content_fragment.is_null() ? nullptr : error_page_content_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
      in_subresource_loader_factories, subresource_loader_factories_fragment);
  params->subresource_loader_factories.Set(
      subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->policy_container)::BaseType> policy_container_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
      in_policy_container, policy_container_fragment);
  params->policy_container.Set(
      policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_container.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_container in NavigationClient.CommitFailedNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitFailedNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigationClient_CommitFailedNavigation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NavigationClient_CommitNavigation_ProxyToResponder {
 public:
  static NavigationClient::CommitNavigationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NavigationClient_CommitNavigation_ProxyToResponder> proxy(
        new NavigationClient_CommitNavigation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NavigationClient_CommitNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigationClient_CommitNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NavigationClient_CommitNavigation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NavigationClient::CommitNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitNavigation_ProxyToResponder);
};

bool NavigationClient_CommitNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::NavigationClient::CommitNavigationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NavigationClient_CommitNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigationClient_CommitNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DidCommitProvisionalLoadParamsPtr p_params{};
  ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
  NavigationClient_CommitNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigationClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_params), 
std::move(p_interface_params));
  return true;
}

void NavigationClient_CommitNavigation_ProxyToResponder::Run(
    DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::NavigationClient::CommitNavigationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_params"), in_interface_params,
                        "<value of type ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNavigationClient_CommitNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_params)::BaseType> interface_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
      in_interface_params, interface_params_fragment);
  params->interface_params.Set(
      interface_params_fragment.is_null() ? nullptr : interface_params_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::NavigationClient::CommitNavigationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitNavigation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NavigationClient_CommitFailedNavigation_ProxyToResponder {
 public:
  static NavigationClient::CommitFailedNavigationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NavigationClient_CommitFailedNavigation_ProxyToResponder> proxy(
        new NavigationClient_CommitFailedNavigation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NavigationClient_CommitFailedNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigationClient_CommitFailedNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NavigationClient_CommitFailedNavigation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NavigationClient::CommitFailedNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NavigationClient_CommitFailedNavigation_ProxyToResponder);
};

bool NavigationClient_CommitFailedNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::NavigationClient::CommitFailedNavigationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  DidCommitProvisionalLoadParamsPtr p_params{};
  ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr p_interface_params{};
  NavigationClient_CommitFailedNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (success && !input_data_view.ReadInterfaceParams(&p_interface_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigationClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_params), 
std::move(p_interface_params));
  return true;
}

void NavigationClient_CommitFailedNavigation_ProxyToResponder::Run(
    DidCommitProvisionalLoadParamsPtr in_params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr in_interface_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::NavigationClient::CommitFailedNavigationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidCommitProvisionalLoadParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_params"), in_interface_params,
                        "<value of type ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kNavigationClient_CommitFailedNavigation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_params)::BaseType> interface_params_fragment(
          params.message());
  mojo::internal::Serialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
      in_interface_params, interface_params_fragment);
  params->interface_params.Set(
      interface_params_fragment.is_null() ? nullptr : interface_params_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::NavigationClient::CommitFailedNavigationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigationClient::Name_);
  message.set_method_name("CommitFailedNavigation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NavigationClientStubDispatch::Accept(
    NavigationClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNavigationClient_CommitNavigation_Name: {
      break;
    }
    case internal::kNavigationClient_CommitFailedNavigation_Name: {
      break;
    }
  }
  return false;
}

// static
bool NavigationClientStubDispatch::AcceptWithResponder(
    NavigationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNavigationClient_CommitNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigationClient::CommitNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigationClient::CommitNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NavigationClient_CommitNavigation_Params_Data* params =
          reinterpret_cast<
              internal::NavigationClient_CommitNavigation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::CommonNavigationParamsPtr p_common_params{};
      ::blink::mojom::CommitNavigationParamsPtr p_request_params{};
      ::network::mojom::URLResponseHeadPtr p_response_head{};
      ::mojo::ScopedDataPipeConsumerHandle p_response_body{};
      ::network::mojom::URLLoaderClientEndpointsPtr p_url_loader_client_endpoints{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      absl::optional<std::vector<::blink::mojom::TransferrableURLLoaderPtr>> p_subresource_overrides{};
      ::blink::mojom::ControllerServiceWorkerInfoPtr p_controller_service_worker_info{};
      ::blink::mojom::ServiceWorkerContainerInfoForClientPtr p_container_info{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_prefetch_loader_factory{};
      ::base::UnguessableToken p_devtools_navigation_token{};
      ::blink::mojom::PolicyContainerPtr p_policy_container{};
      ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> p_code_cache_host{};
      CookieManagerInfoPtr p_cookie_manager_info{};
      StorageInfoPtr p_storage_info{};
      NavigationClient_CommitNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (success && !input_data_view.ReadResponseHead(&p_response_head))
        success = false;
      if (success)
        p_response_body = input_data_view.TakeResponseBody();
      if (success && !input_data_view.ReadUrlLoaderClientEndpoints(&p_url_loader_client_endpoints))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success && !input_data_view.ReadSubresourceOverrides(&p_subresource_overrides))
        success = false;
      if (success && !input_data_view.ReadControllerServiceWorkerInfo(&p_controller_service_worker_info))
        success = false;
      if (success && !input_data_view.ReadContainerInfo(&p_container_info))
        success = false;
      if (success) {
        p_prefetch_loader_factory =
            input_data_view.TakePrefetchLoaderFactory<decltype(p_prefetch_loader_factory)>();
      }
      if (success && !input_data_view.ReadDevtoolsNavigationToken(&p_devtools_navigation_token))
        success = false;
      if (success && !input_data_view.ReadPolicyContainer(&p_policy_container))
        success = false;
      if (success) {
        p_code_cache_host =
            input_data_view.TakeCodeCacheHost<decltype(p_code_cache_host)>();
      }
      if (success && !input_data_view.ReadCookieManagerInfo(&p_cookie_manager_info))
        success = false;
      if (success && !input_data_view.ReadStorageInfo(&p_storage_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationClient::Name_, 0, false);
        return false;
      }
      NavigationClient::CommitNavigationCallback callback =
          NavigationClient_CommitNavigation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitNavigation(
std::move(p_common_params), 
std::move(p_request_params), 
std::move(p_response_head), 
std::move(p_response_body), 
std::move(p_url_loader_client_endpoints), 
std::move(p_subresource_loader_factories), 
std::move(p_subresource_overrides), 
std::move(p_controller_service_worker_info), 
std::move(p_container_info), 
std::move(p_prefetch_loader_factory), 
std::move(p_devtools_navigation_token), 
std::move(p_policy_container), 
std::move(p_code_cache_host), 
std::move(p_cookie_manager_info), 
std::move(p_storage_info), std::move(callback));
      return true;
    }
    case internal::kNavigationClient_CommitFailedNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigationClient::CommitFailedNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigationClient::CommitFailedNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NavigationClient_CommitFailedNavigation_Params_Data* params =
          reinterpret_cast<
              internal::NavigationClient_CommitFailedNavigation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::CommonNavigationParamsPtr p_common_params{};
      ::blink::mojom::CommitNavigationParamsPtr p_request_params{};
      bool p_has_stale_copy_in_cache{};
      int32_t p_error_code{};
      int32_t p_extended_error_code{};
      ::net::ResolveErrorInfo p_resolve_error_info{};
      absl::optional<std::string> p_error_page_content{};
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> p_subresource_loader_factories{};
      ::blink::mojom::PolicyContainerPtr p_policy_container{};
      NavigationClient_CommitFailedNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommonParams(&p_common_params))
        success = false;
      if (success && !input_data_view.ReadRequestParams(&p_request_params))
        success = false;
      if (success)
        p_has_stale_copy_in_cache = input_data_view.has_stale_copy_in_cache();
      if (success)
        p_error_code = input_data_view.error_code();
      if (success)
        p_extended_error_code = input_data_view.extended_error_code();
      if (success && !input_data_view.ReadResolveErrorInfo(&p_resolve_error_info))
        success = false;
      if (success && !input_data_view.ReadErrorPageContent(&p_error_page_content))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoaderFactories(&p_subresource_loader_factories))
        success = false;
      if (success && !input_data_view.ReadPolicyContainer(&p_policy_container))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigationClient::Name_, 1, false);
        return false;
      }
      NavigationClient::CommitFailedNavigationCallback callback =
          NavigationClient_CommitFailedNavigation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitFailedNavigation(
std::move(p_common_params), 
std::move(p_request_params), 
std::move(p_has_stale_copy_in_cache), 
std::move(p_error_code), 
std::move(p_extended_error_code), 
std::move(p_resolve_error_info), 
std::move(p_error_page_content), 
std::move(p_subresource_loader_factories), 
std::move(p_policy_container), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNavigationClientValidationInfo[] = {
    {internal::kNavigationClient_CommitNavigation_Name,
     {&internal::NavigationClient_CommitNavigation_Params_Data::Validate,
      &internal::NavigationClient_CommitNavigation_ResponseParams_Data::Validate}},
    {internal::kNavigationClient_CommitFailedNavigation_Name,
     {&internal::NavigationClient_CommitFailedNavigation_Params_Data::Validate,
      &internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data::Validate}},
};

bool NavigationClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigationClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNavigationClientValidationInfo);
}

bool NavigationClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigationClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNavigationClientValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::DidCommitProvisionalLoadParams::DataView, ::content::mojom::DidCommitProvisionalLoadParamsPtr>::Read(
    ::content::mojom::DidCommitProvisionalLoadParams::DataView input,
    ::content::mojom::DidCommitProvisionalLoadParamsPtr* output) {
  bool success = true;
  ::content::mojom::DidCommitProvisionalLoadParamsPtr result(::content::mojom::DidCommitProvisionalLoadParams::New());
  
      if (success)
        result->item_sequence_number = input.item_sequence_number();
      if (success)
        result->document_sequence_number = input.document_sequence_number();
      if (success && !input.ReadAppHistoryKey(&result->app_history_key))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadVirtualUrl(&result->virtual_url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadTransition(&result->transition))
        success = false;
      if (success)
        result->should_update_history = input.should_update_history();
      if (success && !input.ReadContentsMimeType(&result->contents_mime_type))
        success = false;
      if (success)
        result->intended_as_new_entry = input.intended_as_new_entry();
      if (success)
        result->did_create_new_entry = input.did_create_new_entry();
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success && !input.ReadGesture(&result->gesture))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success)
        result->post_id = input.post_id();
      if (success)
        result->http_status_code = input.http_status_code();
      if (success)
        result->url_is_unreachable = input.url_is_unreachable();
      if (success && !input.ReadPageState(&result->page_state))
        success = false;
      if (success)
        result->is_overriding_user_agent = input.is_overriding_user_agent();
      if (success)
        result->history_list_was_cleared = input.history_list_was_cleared();
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadPermissionsPolicyHeader(&result->permissions_policy_header))
        success = false;
      if (success && !input.ReadDocumentPolicyHeader(&result->document_policy_header))
        success = false;
      if (success && !input.ReadInsecureRequestPolicy(&result->insecure_request_policy))
        success = false;
      if (success && !input.ReadInsecureNavigationsSet(&result->insecure_navigations_set))
        success = false;
      if (success)
        result->has_potentially_trustworthy_unique_origin = input.has_potentially_trustworthy_unique_origin();
      if (success)
        result->request_id = input.request_id();
      if (success && !input.ReadNavigationToken(&result->navigation_token))
        success = false;
      if (success && !input.ReadEmbeddingToken(&result->embedding_token))
        success = false;
      if (success && !input.ReadUnloadStart(&result->unload_start))
        success = false;
      if (success && !input.ReadUnloadEnd(&result->unload_end))
        success = false;
      if (success && !input.ReadCommitNavigationEnd(&result->commit_navigation_end))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::DidCommitSameDocumentNavigationParams::DataView, ::content::mojom::DidCommitSameDocumentNavigationParamsPtr>::Read(
    ::content::mojom::DidCommitSameDocumentNavigationParams::DataView input,
    ::content::mojom::DidCommitSameDocumentNavigationParamsPtr* output) {
  bool success = true;
  ::content::mojom::DidCommitSameDocumentNavigationParamsPtr result(::content::mojom::DidCommitSameDocumentNavigationParams::New());
  
      if (success && !input.ReadSameDocumentNavigationType(&result->same_document_navigation_type))
        success = false;
      if (success)
        result->is_client_redirect = input.is_client_redirect();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CookieManagerInfo::DataView, ::content::mojom::CookieManagerInfoPtr>::Read(
    ::content::mojom::CookieManagerInfo::DataView input,
    ::content::mojom::CookieManagerInfoPtr* output) {
  bool success = true;
  ::content::mojom::CookieManagerInfoPtr result(::content::mojom::CookieManagerInfo::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success) {
        result->cookie_manager =
            input.TakeCookieManager<decltype(result->cookie_manager)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::StorageInfo::DataView, ::content::mojom::StorageInfoPtr>::Read(
    ::content::mojom::StorageInfo::DataView input,
    ::content::mojom::StorageInfoPtr* output) {
  bool success = true;
  ::content::mojom::StorageInfoPtr result(::content::mojom::StorageInfo::New());
  
      if (success) {
        result->local_storage_area =
            input.TakeLocalStorageArea<decltype(result->local_storage_area)>();
      }
      if (success) {
        result->session_storage_area =
            input.TakeSessionStorageArea<decltype(result->session_storage_area)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif