// content/common/pepper_plugin.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/common/pepper_plugin.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "content/public/common/webplugininfo.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/process_id.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef CONTENT_COMMON_PEPPER_PLUGIN_MOJOM_JUMBO_H_
#define CONTENT_COMMON_PEPPER_PLUGIN_MOJOM_JUMBO_H_
#include "content/public/common/webplugininfo_param_traits.h"
#endif


namespace content {
namespace mojom {


void PepperHostInterceptorForTesting::InstanceCreated(int32_t instance_id, ::mojo::PendingAssociatedRemote<PepperPluginInstance> instance, ::mojo::PendingAssociatedReceiver<PepperPluginInstanceHost> host) {
  GetForwardingInterface()->InstanceCreated(std::move(instance_id), std::move(instance), std::move(host));
}
void PepperHostInterceptorForTesting::BindHungDetectorHost(::mojo::PendingReceiver<PepperHungDetectorHost> host, int32_t plugin_child_id, const ::base::FilePath& plugin_path) {
  GetForwardingInterface()->BindHungDetectorHost(std::move(host), std::move(plugin_child_id), std::move(plugin_path));
}
void PepperHostInterceptorForTesting::GetPluginInfo(const ::GURL& url, const ::url::Origin& main_frame_origin, const std::string& mime_type, GetPluginInfoCallback callback) {
  GetForwardingInterface()->GetPluginInfo(std::move(url), std::move(main_frame_origin), std::move(mime_type), std::move(callback));
}
void PepperHostInterceptorForTesting::DidCreateInProcessInstance(int32_t instance_id, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url) {
  GetForwardingInterface()->DidCreateInProcessInstance(std::move(instance_id), std::move(frame_routing_id), std::move(document_url), std::move(plugin_url));
}
void PepperHostInterceptorForTesting::DidDeleteInProcessInstance(int32_t instance_id) {
  GetForwardingInterface()->DidDeleteInProcessInstance(std::move(instance_id));
}
void PepperHostInterceptorForTesting::DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context, DidCreateOutOfProcessPepperInstanceCallback callback) {
  GetForwardingInterface()->DidCreateOutOfProcessPepperInstance(std::move(plugin_child_id), std::move(pp_instance), std::move(is_external), std::move(frame_routing_id), std::move(document_url), std::move(plugin_url), std::move(is_privileged_context), std::move(callback));
}
void PepperHostInterceptorForTesting::DidDeleteOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external) {
  GetForwardingInterface()->DidDeleteOutOfProcessPepperInstance(std::move(plugin_child_id), std::move(pp_instance), std::move(is_external));
}
void PepperHostInterceptorForTesting::OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const absl::optional<::url::Origin>& origin_lock, OpenChannelToPepperPluginCallback callback) {
  GetForwardingInterface()->OpenChannelToPepperPlugin(std::move(embedder_origin), std::move(path), std::move(origin_lock), std::move(callback));
}
PepperHostAsyncWaiter::PepperHostAsyncWaiter(
    PepperHost* proxy) : proxy_(proxy) {}

PepperHostAsyncWaiter::~PepperHostAsyncWaiter() = default;

void PepperHostAsyncWaiter::GetPluginInfo(
    const ::GURL& url, const ::url::Origin& main_frame_origin, const std::string& mime_type, bool* out_found, ::content::WebPluginInfo* out_plugin_info, std::string* out_actual_mime_type) {
  base::RunLoop loop;
  proxy_->GetPluginInfo(std::move(url),std::move(main_frame_origin),std::move(mime_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_found
,
             ::content::WebPluginInfo* out_plugin_info
,
             std::string* out_actual_mime_type
,
             bool found,
             const ::content::WebPluginInfo& plugin_info,
             const std::string& actual_mime_type) {*out_found = std::move(found);*out_plugin_info = std::move(plugin_info);*out_actual_mime_type = std::move(actual_mime_type);
            loop->Quit();
          },
          &loop,
          out_found,
          out_plugin_info,
          out_actual_mime_type));
  loop.Run();
}
void PepperHostAsyncWaiter::DidCreateOutOfProcessPepperInstance(
    int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context) {
  base::RunLoop loop;
  proxy_->DidCreateOutOfProcessPepperInstance(std::move(plugin_child_id),std::move(pp_instance),std::move(is_external),std::move(frame_routing_id),std::move(document_url),std::move(plugin_url),std::move(is_privileged_context),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void PepperHostAsyncWaiter::OpenChannelToPepperPlugin(
    const ::url::Origin& embedder_origin, const ::base::FilePath& path, const absl::optional<::url::Origin>& origin_lock, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id) {
  base::RunLoop loop;
  proxy_->OpenChannelToPepperPlugin(std::move(embedder_origin),std::move(path),std::move(origin_lock),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::ScopedMessagePipeHandle* out_handle_to_channel
,
             ::base::ProcessId* out_plugin_pid
,
             int32_t* out_plugin_child_id
,
             ::mojo::ScopedMessagePipeHandle handle_to_channel,
             ::base::ProcessId plugin_pid,
             int32_t plugin_child_id) {*out_handle_to_channel = std::move(handle_to_channel);*out_plugin_pid = std::move(plugin_pid);*out_plugin_child_id = std::move(plugin_child_id);
            loop->Quit();
          },
          &loop,
          out_handle_to_channel,
          out_plugin_pid,
          out_plugin_child_id));
  loop.Run();
}



void PepperIOHostInterceptorForTesting::DidCreateInProcessInstance(int32_t instance_id, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url) {
  GetForwardingInterface()->DidCreateInProcessInstance(std::move(instance_id), std::move(frame_routing_id), std::move(document_url), std::move(plugin_url));
}
void PepperIOHostInterceptorForTesting::DidDeleteInProcessInstance(int32_t instance_id) {
  GetForwardingInterface()->DidDeleteInProcessInstance(std::move(instance_id));
}
void PepperIOHostInterceptorForTesting::DidCreateOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context, DidCreateOutOfProcessPepperInstanceCallback callback) {
  GetForwardingInterface()->DidCreateOutOfProcessPepperInstance(std::move(plugin_child_id), std::move(pp_instance), std::move(is_external), std::move(frame_routing_id), std::move(document_url), std::move(plugin_url), std::move(is_privileged_context), std::move(callback));
}
void PepperIOHostInterceptorForTesting::DidDeleteOutOfProcessPepperInstance(int32_t plugin_child_id, int32_t pp_instance, bool is_external) {
  GetForwardingInterface()->DidDeleteOutOfProcessPepperInstance(std::move(plugin_child_id), std::move(pp_instance), std::move(is_external));
}
void PepperIOHostInterceptorForTesting::OpenChannelToPepperPlugin(const ::url::Origin& embedder_origin, const ::base::FilePath& path, const absl::optional<::url::Origin>& origin_lock, OpenChannelToPepperPluginCallback callback) {
  GetForwardingInterface()->OpenChannelToPepperPlugin(std::move(embedder_origin), std::move(path), std::move(origin_lock), std::move(callback));
}
PepperIOHostAsyncWaiter::PepperIOHostAsyncWaiter(
    PepperIOHost* proxy) : proxy_(proxy) {}

PepperIOHostAsyncWaiter::~PepperIOHostAsyncWaiter() = default;

void PepperIOHostAsyncWaiter::DidCreateOutOfProcessPepperInstance(
    int32_t plugin_child_id, int32_t pp_instance, bool is_external, int32_t frame_routing_id, const ::GURL& document_url, const ::GURL& plugin_url, bool is_privileged_context) {
  base::RunLoop loop;
  proxy_->DidCreateOutOfProcessPepperInstance(std::move(plugin_child_id),std::move(pp_instance),std::move(is_external),std::move(frame_routing_id),std::move(document_url),std::move(plugin_url),std::move(is_privileged_context),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void PepperIOHostAsyncWaiter::OpenChannelToPepperPlugin(
    const ::url::Origin& embedder_origin, const ::base::FilePath& path, const absl::optional<::url::Origin>& origin_lock, ::mojo::ScopedMessagePipeHandle* out_handle_to_channel, ::base::ProcessId* out_plugin_pid, int32_t* out_plugin_child_id) {
  base::RunLoop loop;
  proxy_->OpenChannelToPepperPlugin(std::move(embedder_origin),std::move(path),std::move(origin_lock),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::ScopedMessagePipeHandle* out_handle_to_channel
,
             ::base::ProcessId* out_plugin_pid
,
             int32_t* out_plugin_child_id
,
             ::mojo::ScopedMessagePipeHandle handle_to_channel,
             ::base::ProcessId plugin_pid,
             int32_t plugin_child_id) {*out_handle_to_channel = std::move(handle_to_channel);*out_plugin_pid = std::move(plugin_pid);*out_plugin_child_id = std::move(plugin_child_id);
            loop->Quit();
          },
          &loop,
          out_handle_to_channel,
          out_plugin_pid,
          out_plugin_child_id));
  loop.Run();
}



void PepperHungDetectorHostInterceptorForTesting::PluginHung(bool is_hung) {
  GetForwardingInterface()->PluginHung(std::move(is_hung));
}
PepperHungDetectorHostAsyncWaiter::PepperHungDetectorHostAsyncWaiter(
    PepperHungDetectorHost* proxy) : proxy_(proxy) {}

PepperHungDetectorHostAsyncWaiter::~PepperHungDetectorHostAsyncWaiter() = default;




void PepperPluginInstanceHostInterceptorForTesting::StartsPlayback() {
  GetForwardingInterface()->StartsPlayback();
}
void PepperPluginInstanceHostInterceptorForTesting::StopsPlayback() {
  GetForwardingInterface()->StopsPlayback();
}
void PepperPluginInstanceHostInterceptorForTesting::InstanceCrashed(const ::base::FilePath& plugin_path, ::base::ProcessId plugin_pid) {
  GetForwardingInterface()->InstanceCrashed(std::move(plugin_path), std::move(plugin_pid));
}
PepperPluginInstanceHostAsyncWaiter::PepperPluginInstanceHostAsyncWaiter(
    PepperPluginInstanceHost* proxy) : proxy_(proxy) {}

PepperPluginInstanceHostAsyncWaiter::~PepperPluginInstanceHostAsyncWaiter() = default;




void PepperPluginInstanceInterceptorForTesting::SetVolume(double volume) {
  GetForwardingInterface()->SetVolume(std::move(volume));
}
PepperPluginInstanceAsyncWaiter::PepperPluginInstanceAsyncWaiter(
    PepperPluginInstance* proxy) : proxy_(proxy) {}

PepperPluginInstanceAsyncWaiter::~PepperPluginInstanceAsyncWaiter() = default;






}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif