// content/common/renderer_host.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "content/common/renderer_host.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "url/mojom/url.mojom.h"


#ifndef CONTENT_COMMON_RENDERER_HOST_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDERER_HOST_MOJOM_JUMBO_H_
#endif


namespace content {
namespace mojom {


void RendererHostInterceptorForTesting::GetBrowserHistogram(const std::string& name, GetBrowserHistogramCallback callback) {
  GetForwardingInterface()->GetBrowserHistogram(std::move(name), std::move(callback));
}
void RendererHostInterceptorForTesting::SuddenTerminationChanged(bool enabled) {
  GetForwardingInterface()->SuddenTerminationChanged(std::move(enabled));
}
void RendererHostInterceptorForTesting::RecordUserMetricsAction(const std::string& action) {
  GetForwardingInterface()->RecordUserMetricsAction(std::move(action));
}
RendererHostAsyncWaiter::RendererHostAsyncWaiter(
    RendererHost* proxy) : proxy_(proxy) {}

RendererHostAsyncWaiter::~RendererHostAsyncWaiter() = default;

void RendererHostAsyncWaiter::GetBrowserHistogram(
    const std::string& name, std::string* out_histogram_json) {
  base::RunLoop loop;
  proxy_->GetBrowserHistogram(std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_histogram_json
,
             const std::string& histogram_json) {*out_histogram_json = std::move(histogram_json);
            loop->Quit();
          },
          &loop,
          out_histogram_json));
  loop.Run();
}





}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif