// content/common/renderer_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/renderer_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/renderer_host.mojom-params-data.h"
#include "content/common/renderer_host.mojom-shared-message-ids.h"

#include "content/common/renderer_host.mojom-import-headers.h"


#ifndef CONTENT_COMMON_RENDERER_HOST_MOJOM_JUMBO_H_
#define CONTENT_COMMON_RENDERER_HOST_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
const char RendererHost::Name_[] = "content.mojom.RendererHost";
bool RendererHost::GetBrowserHistogram(const std::string& name, std::string* out_histogram_json) {
  NOTREACHED();
  return false;
}
class RendererHost_GetBrowserHistogram_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RendererHost_GetBrowserHistogram_HandleSyncResponse(
      bool* result, std::string* out_histogram_json)
      : result_(result), out_histogram_json_(out_histogram_json) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::string* out_histogram_json_;DISALLOW_COPY_AND_ASSIGN(RendererHost_GetBrowserHistogram_HandleSyncResponse);
};

class RendererHost_GetBrowserHistogram_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RendererHost_GetBrowserHistogram_ForwardToCallback(
      RendererHost::GetBrowserHistogramCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RendererHost::GetBrowserHistogramCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RendererHost_GetBrowserHistogram_ForwardToCallback);
};

RendererHostProxy::RendererHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool RendererHostProxy::GetBrowserHistogram(
    const std::string& param_name, std::string* out_param_histogram_json) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "content::mojom::RendererHost::GetBrowserHistogram", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), param_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRendererHost_GetBrowserHistogram_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_GetBrowserHistogram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in RendererHost.GetBrowserHistogram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetBrowserHistogram");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_GetBrowserHistogram_HandleSyncResponse(
          &result, out_param_histogram_json));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "content::mojom::RendererHost::GetBrowserHistogram", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_json"), out_param_histogram_json,
                        "<value of type const std::string&>");
   });
#endif
  return result;
}

void RendererHostProxy::GetBrowserHistogram(
    const std::string& in_name, GetBrowserHistogramCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RendererHost::GetBrowserHistogram", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRendererHost_GetBrowserHistogram_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_GetBrowserHistogram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in RendererHost.GetBrowserHistogram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetBrowserHistogram");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_GetBrowserHistogram_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RendererHostProxy::SuddenTerminationChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RendererHost::SuddenTerminationChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRendererHost_SuddenTerminationChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_SuddenTerminationChanged_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("SuddenTerminationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererHostProxy::RecordUserMetricsAction(
    const std::string& in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::RendererHost::RecordUserMetricsAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRendererHost_RecordUserMetricsAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_RecordUserMetricsAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType> action_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_action, action_fragment);
  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->action.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in RendererHost.RecordUserMetricsAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("RecordUserMetricsAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class RendererHost_GetBrowserHistogram_ProxyToResponder {
 public:
  static RendererHost::GetBrowserHistogramCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RendererHost_GetBrowserHistogram_ProxyToResponder> proxy(
        new RendererHost_GetBrowserHistogram_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RendererHost_GetBrowserHistogram_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RendererHost_GetBrowserHistogram_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RendererHost_GetBrowserHistogram_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RendererHost::GetBrowserHistogramCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_histogram_json);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RendererHost_GetBrowserHistogram_ProxyToResponder);
};

bool RendererHost_GetBrowserHistogram_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::RendererHost::GetBrowserHistogramCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::RendererHost_GetBrowserHistogram_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RendererHost_GetBrowserHistogram_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::string p_histogram_json{};
  RendererHost_GetBrowserHistogram_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHistogramJson(&p_histogram_json))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_histogram_json));
  return true;
}

void RendererHost_GetBrowserHistogram_ProxyToResponder::Run(
    const std::string& in_histogram_json) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::RendererHost::GetBrowserHistogramCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_json"), in_histogram_json,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kRendererHost_GetBrowserHistogram_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::RendererHost_GetBrowserHistogram_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_json)::BaseType> histogram_json_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_histogram_json, histogram_json_fragment);
  params->histogram_json.Set(
      histogram_json_fragment.is_null() ? nullptr : histogram_json_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->histogram_json.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null histogram_json in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::RendererHost::GetBrowserHistogramCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetBrowserHistogram");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RendererHost_GetBrowserHistogram_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::RendererHost_GetBrowserHistogram_ResponseParams_Data* params =
      reinterpret_cast<internal::RendererHost_GetBrowserHistogram_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  std::string p_histogram_json{};
  RendererHost_GetBrowserHistogram_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHistogramJson(&p_histogram_json))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 0, true);
    return false;
  }
  *out_histogram_json_ = std::move(p_histogram_json);
  *result_ = true;
  return true;
}

// static
bool RendererHostStubDispatch::Accept(
    RendererHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRendererHost_GetBrowserHistogram_Name: {
      break;
    }
    case internal::kRendererHost_SuddenTerminationChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RendererHost::SuddenTerminationChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RendererHost::SuddenTerminationChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererHost_SuddenTerminationChanged_Params_Data* params =
          reinterpret_cast<internal::RendererHost_SuddenTerminationChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      RendererHost_SuddenTerminationChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuddenTerminationChanged(
std::move(p_enabled));
      return true;
    }
    case internal::kRendererHost_RecordUserMetricsAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RendererHost::RecordUserMetricsAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RendererHost::RecordUserMetricsAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererHost_RecordUserMetricsAction_Params_Data* params =
          reinterpret_cast<internal::RendererHost_RecordUserMetricsAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_action{};
      RendererHost_RecordUserMetricsAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordUserMetricsAction(
std::move(p_action));
      return true;
    }
  }
  return false;
}

// static
bool RendererHostStubDispatch::AcceptWithResponder(
    RendererHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRendererHost_GetBrowserHistogram_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::RendererHost::GetBrowserHistogram",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::RendererHost::GetBrowserHistogram");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RendererHost_GetBrowserHistogram_Params_Data* params =
          reinterpret_cast<
              internal::RendererHost_GetBrowserHistogram_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      RendererHost_GetBrowserHistogram_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 0, false);
        return false;
      }
      RendererHost::GetBrowserHistogramCallback callback =
          RendererHost_GetBrowserHistogram_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBrowserHistogram(
std::move(p_name), std::move(callback));
      return true;
    }
    case internal::kRendererHost_SuddenTerminationChanged_Name: {
      break;
    }
    case internal::kRendererHost_RecordUserMetricsAction_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererHostValidationInfo[] = {
    {internal::kRendererHost_GetBrowserHistogram_Name,
     {&internal::RendererHost_GetBrowserHistogram_Params_Data::Validate,
      &internal::RendererHost_GetBrowserHistogram_ResponseParams_Data::Validate}},
    {internal::kRendererHost_SuddenTerminationChanged_Name,
     {&internal::RendererHost_SuddenTerminationChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererHost_RecordUserMetricsAction_Name,
     {&internal::RendererHost_RecordUserMetricsAction_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RendererHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererHostValidationInfo);
}

bool RendererHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::RendererHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRendererHostValidationInfo);

}
}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif