// content/public/common/media_playback_renderer_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/public/common/media_playback_renderer_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/public/common/media_playback_renderer_type.mojom-params-data.h"
namespace content {
namespace mojom {

static NOINLINE const char* RendererTypeToStringHelper(RendererType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RendererType::DEFAULT_RENDERER:
      return "DEFAULT_RENDERER";
    case RendererType::MOJO_RENDERER:
      return "MOJO_RENDERER";
    case RendererType::REMOTING_RENDERER:
      return "REMOTING_RENDERER";
    default:
      return nullptr;
  }
}

std::string RendererTypeToString(RendererType value) {
  const char *str = RendererTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RendererType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RendererType value) {
  return os << RendererTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace content

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::RendererType>::WriteIntoTrace(
   perfetto::TracedValue context, ::content::mojom::RendererType value) {
  return std::move(context).WriteString(::content::mojom::RendererTypeToString(value));
}

} // namespace perfetto
