// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-import-headers.h"


#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_JUMBO_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_JUMBO_H_
#endif
namespace auction_worklet {
namespace mojom {
BrowserSignals::BrowserSignals()
    : top_frame_origin(),
      seller() {}

BrowserSignals::BrowserSignals(
    const ::url::Origin& top_frame_origin_in,
    const ::url::Origin& seller_in)
    : top_frame_origin(std::move(top_frame_origin_in)),
      seller(std::move(seller_in)) {}

BrowserSignals::~BrowserSignals() = default;

void BrowserSignals::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_frame_origin"), this->top_frame_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller"), this->seller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BrowserSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AuctionWorkletService::Name_[] = "auction_worklet.mojom.AuctionWorkletService";

class AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ForwardToCallback(
      AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ForwardToCallback);
};

class AuctionWorkletService_LoadSellerWorklet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AuctionWorkletService_LoadSellerWorklet_ForwardToCallback(
      AuctionWorkletService::LoadSellerWorkletCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AuctionWorkletService::LoadSellerWorkletCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AuctionWorkletService_LoadSellerWorklet_ForwardToCallback);
};

AuctionWorkletServiceProxy::AuctionWorkletServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuctionWorkletServiceProxy::LoadBidderWorkletAndGenerateBid(
    ::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet> in_bidder_worklet, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_url_loader_factory, ::auction_worklet::mojom::BiddingInterestGroupPtr in_bidding_interest_group, const absl::optional<std::string>& in_auction_signals_json, const absl::optional<std::string>& in_per_buyer_signals_json, const ::url::Origin& in_browser_signal_top_window_origin, const ::url::Origin& in_browser_signal_seller_origin, ::base::Time in_auction_start_time, LoadBidderWorkletAndGenerateBidCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "auction_worklet::mojom::AuctionWorkletService::LoadBidderWorkletAndGenerateBid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidder_worklet"), in_bidder_worklet,
                        "<value of type ::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bidding_interest_group"), in_bidding_interest_group,
                        "<value of type ::auction_worklet::mojom::BiddingInterestGroupPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_signals_json"), in_auction_signals_json,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("per_buyer_signals_json"), in_per_buyer_signals_json,
                        "<value of type const absl::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_top_window_origin"), in_browser_signal_top_window_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_signal_seller_origin"), in_browser_signal_seller_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auction_start_time"), in_auction_start_time,
                        "<value of type ::base::Time>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuctionWorkletService_LoadBidderWorkletAndGenerateBid_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::auction_worklet::mojom::BidderWorkletInterfaceBase>>(
      in_bidder_worklet, &params->bidder_worklet, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->bidder_worklet),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid bidder_worklet in AuctionWorkletService.LoadBidderWorkletAndGenerateBid request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in AuctionWorkletService.LoadBidderWorkletAndGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->bidding_interest_group)::BaseType> bidding_interest_group_fragment(
          params.message());
  mojo::internal::Serialize<::auction_worklet::mojom::BiddingInterestGroupDataView>(
      in_bidding_interest_group, bidding_interest_group_fragment);
  params->bidding_interest_group.Set(
      bidding_interest_group_fragment.is_null() ? nullptr : bidding_interest_group_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bidding_interest_group.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bidding_interest_group in AuctionWorkletService.LoadBidderWorkletAndGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->auction_signals_json)::BaseType> auction_signals_json_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_auction_signals_json, auction_signals_json_fragment);
  params->auction_signals_json.Set(
      auction_signals_json_fragment.is_null() ? nullptr : auction_signals_json_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->per_buyer_signals_json)::BaseType> per_buyer_signals_json_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_per_buyer_signals_json, per_buyer_signals_json_fragment);
  params->per_buyer_signals_json.Set(
      per_buyer_signals_json_fragment.is_null() ? nullptr : per_buyer_signals_json_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_top_window_origin)::BaseType> browser_signal_top_window_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_browser_signal_top_window_origin, browser_signal_top_window_origin_fragment);
  params->browser_signal_top_window_origin.Set(
      browser_signal_top_window_origin_fragment.is_null() ? nullptr : browser_signal_top_window_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_top_window_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_top_window_origin in AuctionWorkletService.LoadBidderWorkletAndGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->browser_signal_seller_origin)::BaseType> browser_signal_seller_origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_browser_signal_seller_origin, browser_signal_seller_origin_fragment);
  params->browser_signal_seller_origin.Set(
      browser_signal_seller_origin_fragment.is_null() ? nullptr : browser_signal_seller_origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->browser_signal_seller_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_signal_seller_origin in AuctionWorkletService.LoadBidderWorkletAndGenerateBid request");
  mojo::internal::MessageFragment<
      typename decltype(params->auction_start_time)::BaseType> auction_start_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_auction_start_time, auction_start_time_fragment);
  params->auction_start_time.Set(
      auction_start_time_fragment.is_null() ? nullptr : auction_start_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->auction_start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null auction_start_time in AuctionWorkletService.LoadBidderWorkletAndGenerateBid request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionWorkletService::Name_);
  message.set_method_name("LoadBidderWorkletAndGenerateBid");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AuctionWorkletServiceProxy::LoadSellerWorklet(
    ::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet> in_seller_worklet, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_url_loader_factory, const ::GURL& in_script_source_url, LoadSellerWorkletCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "auction_worklet::mojom::AuctionWorkletService::LoadSellerWorklet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seller_worklet"), in_seller_worklet,
                        "<value of type ::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_source_url"), in_script_source_url,
                        "<value of type const ::GURL&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuctionWorkletService_LoadSellerWorklet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionWorkletService_LoadSellerWorklet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::auction_worklet::mojom::SellerWorkletInterfaceBase>>(
      in_seller_worklet, &params->seller_worklet, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->seller_worklet),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid seller_worklet in AuctionWorkletService.LoadSellerWorklet request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in AuctionWorkletService.LoadSellerWorklet request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_source_url)::BaseType> script_source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_source_url, script_source_url_fragment);
  params->script_source_url.Set(
      script_source_url_fragment.is_null() ? nullptr : script_source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->script_source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_source_url in AuctionWorkletService.LoadSellerWorklet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionWorkletService::Name_);
  message.set_method_name("LoadSellerWorklet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AuctionWorkletService_LoadSellerWorklet_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder {
 public:
  static AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder> proxy(
        new AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::auction_worklet::mojom::BidderWorkletBidPtr in_bid, const std::vector<std::string>& in_errors);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder);
};

bool AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "auction_worklet::mojom::AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::auction_worklet::mojom::BidderWorkletBidPtr p_bid{};
  std::vector<std::string> p_errors{};
  AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBid(&p_bid))
    success = false;
  if (success && !input_data_view.ReadErrors(&p_errors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AuctionWorkletService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_bid), 
std::move(p_errors));
  return true;
}

void AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder::Run(
    ::auction_worklet::mojom::BidderWorkletBidPtr in_bid, const std::vector<std::string>& in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bid"), in_bid,
                        "<value of type ::auction_worklet::mojom::BidderWorkletBidPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuctionWorkletService_LoadBidderWorkletAndGenerateBid_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bid)::BaseType> bid_fragment(
          params.message());
  mojo::internal::Serialize<::auction_worklet::mojom::BidderWorkletBidDataView>(
      in_bid, bid_fragment);
  params->bid.Set(
      bid_fragment.is_null() ? nullptr : bid_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_errors, errors_fragment, &errors_validate_params);
  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->errors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionWorkletService::Name_);
  message.set_method_name("LoadBidderWorkletAndGenerateBid");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AuctionWorkletService_LoadSellerWorklet_ProxyToResponder {
 public:
  static AuctionWorkletService::LoadSellerWorkletCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AuctionWorkletService_LoadSellerWorklet_ProxyToResponder> proxy(
        new AuctionWorkletService_LoadSellerWorklet_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AuctionWorkletService_LoadSellerWorklet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AuctionWorkletService_LoadSellerWorklet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AuctionWorkletService_LoadSellerWorklet_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AuctionWorkletService::LoadSellerWorkletCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<std::string>& in_errors);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AuctionWorkletService_LoadSellerWorklet_ProxyToResponder);
};

bool AuctionWorkletService_LoadSellerWorklet_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "auction_worklet::mojom::AuctionWorkletService::LoadSellerWorkletCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  std::vector<std::string> p_errors{};
  AuctionWorkletService_LoadSellerWorklet_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrors(&p_errors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AuctionWorkletService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_errors));
  return true;
}

void AuctionWorkletService_LoadSellerWorklet_ProxyToResponder::Run(
    bool in_success, const std::vector<std::string>& in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadSellerWorkletCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAuctionWorkletService_LoadSellerWorklet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_errors, errors_fragment, &errors_validate_params);
  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->errors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadSellerWorkletCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionWorkletService::Name_);
  message.set_method_name("LoadSellerWorklet");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AuctionWorkletServiceStubDispatch::Accept(
    AuctionWorkletService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAuctionWorkletService_LoadBidderWorkletAndGenerateBid_Name: {
      break;
    }
    case internal::kAuctionWorkletService_LoadSellerWorklet_Name: {
      break;
    }
  }
  return false;
}

// static
bool AuctionWorkletServiceStubDispatch::AcceptWithResponder(
    AuctionWorkletService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAuctionWorkletService_LoadBidderWorkletAndGenerateBid_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadBidderWorkletAndGenerateBid",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadBidderWorkletAndGenerateBid");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data* params =
          reinterpret_cast<
              internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet> p_bidder_worklet{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      ::auction_worklet::mojom::BiddingInterestGroupPtr p_bidding_interest_group{};
      absl::optional<std::string> p_auction_signals_json{};
      absl::optional<std::string> p_per_buyer_signals_json{};
      ::url::Origin p_browser_signal_top_window_origin{};
      ::url::Origin p_browser_signal_seller_origin{};
      ::base::Time p_auction_start_time{};
      AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_bidder_worklet =
            input_data_view.TakeBidderWorklet<decltype(p_bidder_worklet)>();
      }
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success && !input_data_view.ReadBiddingInterestGroup(&p_bidding_interest_group))
        success = false;
      if (success && !input_data_view.ReadAuctionSignalsJson(&p_auction_signals_json))
        success = false;
      if (success && !input_data_view.ReadPerBuyerSignalsJson(&p_per_buyer_signals_json))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalTopWindowOrigin(&p_browser_signal_top_window_origin))
        success = false;
      if (success && !input_data_view.ReadBrowserSignalSellerOrigin(&p_browser_signal_seller_origin))
        success = false;
      if (success && !input_data_view.ReadAuctionStartTime(&p_auction_start_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionWorkletService::Name_, 0, false);
        return false;
      }
      AuctionWorkletService::LoadBidderWorkletAndGenerateBidCallback callback =
          AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadBidderWorkletAndGenerateBid(
std::move(p_bidder_worklet), 
std::move(p_url_loader_factory), 
std::move(p_bidding_interest_group), 
std::move(p_auction_signals_json), 
std::move(p_per_buyer_signals_json), 
std::move(p_browser_signal_top_window_origin), 
std::move(p_browser_signal_seller_origin), 
std::move(p_auction_start_time), std::move(callback));
      return true;
    }
    case internal::kAuctionWorkletService_LoadSellerWorklet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadSellerWorklet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)auction_worklet::mojom::AuctionWorkletService::LoadSellerWorklet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AuctionWorkletService_LoadSellerWorklet_Params_Data* params =
          reinterpret_cast<
              internal::AuctionWorkletService_LoadSellerWorklet_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet> p_seller_worklet{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      ::GURL p_script_source_url{};
      AuctionWorkletService_LoadSellerWorklet_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_seller_worklet =
            input_data_view.TakeSellerWorklet<decltype(p_seller_worklet)>();
      }
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success && !input_data_view.ReadScriptSourceUrl(&p_script_source_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionWorkletService::Name_, 1, false);
        return false;
      }
      AuctionWorkletService::LoadSellerWorkletCallback callback =
          AuctionWorkletService_LoadSellerWorklet_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadSellerWorklet(
std::move(p_seller_worklet), 
std::move(p_url_loader_factory), 
std::move(p_script_source_url), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAuctionWorkletServiceValidationInfo[] = {
    {internal::kAuctionWorkletService_LoadBidderWorkletAndGenerateBid_Name,
     {&internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_Params_Data::Validate,
      &internal::AuctionWorkletService_LoadBidderWorkletAndGenerateBid_ResponseParams_Data::Validate}},
    {internal::kAuctionWorkletService_LoadSellerWorklet_Name,
     {&internal::AuctionWorkletService_LoadSellerWorklet_Params_Data::Validate,
      &internal::AuctionWorkletService_LoadSellerWorklet_ResponseParams_Data::Validate}},
};

bool AuctionWorkletServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::AuctionWorkletService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAuctionWorkletServiceValidationInfo);
}

bool AuctionWorkletServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::auction_worklet::mojom::AuctionWorkletService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kAuctionWorkletServiceValidationInfo);

}
}  // namespace mojom
}  // namespace auction_worklet

namespace mojo {


// static
bool StructTraits<::auction_worklet::mojom::BrowserSignals::DataView, ::auction_worklet::mojom::BrowserSignalsPtr>::Read(
    ::auction_worklet::mojom::BrowserSignals::DataView input,
    ::auction_worklet::mojom::BrowserSignalsPtr* output) {
  bool success = true;
  ::auction_worklet::mojom::BrowserSignalsPtr result(::auction_worklet::mojom::BrowserSignals::New());
  
      if (success && !input.ReadTopFrameOrigin(&result->top_frame_origin))
        success = false;
      if (success && !input.ReadSeller(&result->seller))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif