// content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

namespace internal {


// static
bool PreviousWin_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PreviousWin_Data* object = static_cast<const PreviousWin_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_json, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams ad_json_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->ad_json, validation_context,
                                         &ad_json_validate_params)) {
    return false;
  }

  return true;
}

PreviousWin_Data::PreviousWin_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BiddingBrowserSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BiddingBrowserSignals_Data* object = static_cast<const BiddingBrowserSignals_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prev_wins, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams prev_wins_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->prev_wins, validation_context,
                                         &prev_wins_validate_params)) {
    return false;
  }

  return true;
}

BiddingBrowserSignals_Data::BiddingBrowserSignals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BiddingInterestGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BiddingInterestGroup_Data* object = static_cast<const BiddingInterestGroup_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signals, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->signals, validation_context))
    return false;

  return true;
}

BiddingInterestGroup_Data::BiddingInterestGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorkletBid_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BidderWorkletBid_Data* object = static_cast<const BidderWorkletBid_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams ad_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->ad, validation_context,
                                         &ad_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->render_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->render_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bid_duration, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bid_duration, validation_context))
    return false;

  return true;
}

BidderWorkletBid_Data::BidderWorkletBid_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorklet_ReportWin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BidderWorklet_ReportWin_Params_Data* object = static_cast<const BidderWorklet_ReportWin_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seller_signals_json, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams seller_signals_json_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->seller_signals_json, validation_context,
                                         &seller_signals_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_render_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_render_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_ad_render_fingerprint, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams browser_signal_ad_render_fingerprint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->browser_signal_ad_render_fingerprint, validation_context,
                                         &browser_signal_ad_render_fingerprint_validate_params)) {
    return false;
  }

  return true;
}

BidderWorklet_ReportWin_Params_Data::BidderWorklet_ReportWin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BidderWorklet_ReportWin_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BidderWorklet_ReportWin_ResponseParams_Data* object = static_cast<const BidderWorklet_ReportWin_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams errors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  return true;
}

BidderWorklet_ReportWin_ResponseParams_Data::BidderWorklet_ReportWin_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet
