// device/vr/public/mojom/vr_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/vr/public/mojom/vr_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/vr_service.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* XRDeviceIdToStringHelper(XRDeviceId value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRDeviceId::WEB_TEST_DEVICE_ID:
      return "WEB_TEST_DEVICE_ID";
    case XRDeviceId::FAKE_DEVICE_ID:
      return "FAKE_DEVICE_ID";
    case XRDeviceId::ORIENTATION_DEVICE_ID:
      return "ORIENTATION_DEVICE_ID";
    case XRDeviceId::GVR_DEVICE_ID:
      return "GVR_DEVICE_ID";
    case XRDeviceId::ARCORE_DEVICE_ID:
      return "ARCORE_DEVICE_ID";
    default:
      return nullptr;
  }
}

std::string XRDeviceIdToString(XRDeviceId value) {
  const char *str = XRDeviceIdToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRDeviceId value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRDeviceId value) {
  return os << XRDeviceIdToString(value);
}

static NOINLINE const char* XRHandednessToStringHelper(XRHandedness value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRHandedness::NONE:
      return "NONE";
    case XRHandedness::LEFT:
      return "LEFT";
    case XRHandedness::RIGHT:
      return "RIGHT";
    default:
      return nullptr;
  }
}

std::string XRHandednessToString(XRHandedness value) {
  const char *str = XRHandednessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRHandedness value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRHandedness value) {
  return os << XRHandednessToString(value);
}

static NOINLINE const char* XRTargetRayModeToStringHelper(XRTargetRayMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRTargetRayMode::GAZING:
      return "GAZING";
    case XRTargetRayMode::POINTING:
      return "POINTING";
    case XRTargetRayMode::TAPPING:
      return "TAPPING";
    default:
      return nullptr;
  }
}

std::string XRTargetRayModeToString(XRTargetRayMode value) {
  const char *str = XRTargetRayModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRTargetRayMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRTargetRayMode value) {
  return os << XRTargetRayModeToString(value);
}

static NOINLINE const char* XRSessionFeatureToStringHelper(XRSessionFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRSessionFeature::REF_SPACE_VIEWER:
      return "REF_SPACE_VIEWER";
    case XRSessionFeature::REF_SPACE_LOCAL:
      return "REF_SPACE_LOCAL";
    case XRSessionFeature::REF_SPACE_LOCAL_FLOOR:
      return "REF_SPACE_LOCAL_FLOOR";
    case XRSessionFeature::REF_SPACE_BOUNDED_FLOOR:
      return "REF_SPACE_BOUNDED_FLOOR";
    case XRSessionFeature::REF_SPACE_UNBOUNDED:
      return "REF_SPACE_UNBOUNDED";
    case XRSessionFeature::DOM_OVERLAY:
      return "DOM_OVERLAY";
    case XRSessionFeature::HIT_TEST:
      return "HIT_TEST";
    case XRSessionFeature::LIGHT_ESTIMATION:
      return "LIGHT_ESTIMATION";
    case XRSessionFeature::ANCHORS:
      return "ANCHORS";
    case XRSessionFeature::CAMERA_ACCESS:
      return "CAMERA_ACCESS";
    case XRSessionFeature::PLANE_DETECTION:
      return "PLANE_DETECTION";
    case XRSessionFeature::DEPTH:
      return "DEPTH";
    case XRSessionFeature::IMAGE_TRACKING:
      return "IMAGE_TRACKING";
    case XRSessionFeature::HAND_INPUT:
      return "HAND_INPUT";
    default:
      return nullptr;
  }
}

std::string XRSessionFeatureToString(XRSessionFeature value) {
  const char *str = XRSessionFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRSessionFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRSessionFeature value) {
  return os << XRSessionFeatureToString(value);
}

static NOINLINE const char* XRSessionFeatureRequestStatusToStringHelper(XRSessionFeatureRequestStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRSessionFeatureRequestStatus::kNotRequested:
      return "kNotRequested";
    case XRSessionFeatureRequestStatus::kRequired:
      return "kRequired";
    case XRSessionFeatureRequestStatus::kOptionalAccepted:
      return "kOptionalAccepted";
    case XRSessionFeatureRequestStatus::kOptionalRejected:
      return "kOptionalRejected";
    default:
      return nullptr;
  }
}

std::string XRSessionFeatureRequestStatusToString(XRSessionFeatureRequestStatus value) {
  const char *str = XRSessionFeatureRequestStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRSessionFeatureRequestStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRSessionFeatureRequestStatus value) {
  return os << XRSessionFeatureRequestStatusToString(value);
}

static NOINLINE const char* XRSessionModeToStringHelper(XRSessionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRSessionMode::kInline:
      return "kInline";
    case XRSessionMode::kImmersiveVr:
      return "kImmersiveVr";
    case XRSessionMode::kImmersiveAr:
      return "kImmersiveAr";
    default:
      return nullptr;
  }
}

std::string XRSessionModeToString(XRSessionMode value) {
  const char *str = XRSessionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRSessionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRSessionMode value) {
  return os << XRSessionModeToString(value);
}

static NOINLINE const char* XREnvironmentBlendModeToStringHelper(XREnvironmentBlendMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XREnvironmentBlendMode::kOpaque:
      return "kOpaque";
    case XREnvironmentBlendMode::kAlphaBlend:
      return "kAlphaBlend";
    case XREnvironmentBlendMode::kAdditive:
      return "kAdditive";
    default:
      return nullptr;
  }
}

std::string XREnvironmentBlendModeToString(XREnvironmentBlendMode value) {
  const char *str = XREnvironmentBlendModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XREnvironmentBlendMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XREnvironmentBlendMode value) {
  return os << XREnvironmentBlendModeToString(value);
}

static NOINLINE const char* XRDepthUsageToStringHelper(XRDepthUsage value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRDepthUsage::kCPUOptimized:
      return "kCPUOptimized";
    case XRDepthUsage::kGPUOptimized:
      return "kGPUOptimized";
    default:
      return nullptr;
  }
}

std::string XRDepthUsageToString(XRDepthUsage value) {
  const char *str = XRDepthUsageToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRDepthUsage value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRDepthUsage value) {
  return os << XRDepthUsageToString(value);
}

static NOINLINE const char* XRDepthDataFormatToStringHelper(XRDepthDataFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRDepthDataFormat::kLuminanceAlpha:
      return "kLuminanceAlpha";
    case XRDepthDataFormat::kFloat32:
      return "kFloat32";
    default:
      return nullptr;
  }
}

std::string XRDepthDataFormatToString(XRDepthDataFormat value) {
  const char *str = XRDepthDataFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRDepthDataFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRDepthDataFormat value) {
  return os << XRDepthDataFormatToString(value);
}

static NOINLINE const char* XRInteractionModeToStringHelper(XRInteractionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRInteractionMode::kScreenSpace:
      return "kScreenSpace";
    case XRInteractionMode::kWorldSpace:
      return "kWorldSpace";
    default:
      return nullptr;
  }
}

std::string XRInteractionModeToString(XRInteractionMode value) {
  const char *str = XRInteractionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRInteractionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRInteractionMode value) {
  return os << XRInteractionModeToString(value);
}

static NOINLINE const char* XRHandJointToStringHelper(XRHandJoint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRHandJoint::kWrist:
      return "kWrist";
    case XRHandJoint::kThumbMetacarpal:
      return "kThumbMetacarpal";
    case XRHandJoint::kThumbPhalanxProximal:
      return "kThumbPhalanxProximal";
    case XRHandJoint::kThumbPhalanxDistal:
      return "kThumbPhalanxDistal";
    case XRHandJoint::kThumbTip:
      return "kThumbTip";
    case XRHandJoint::kIndexFingerMetacarpal:
      return "kIndexFingerMetacarpal";
    case XRHandJoint::kIndexFingerPhalanxProximal:
      return "kIndexFingerPhalanxProximal";
    case XRHandJoint::kIndexFingerPhalanxIntermediate:
      return "kIndexFingerPhalanxIntermediate";
    case XRHandJoint::kIndexFingerPhalanxDistal:
      return "kIndexFingerPhalanxDistal";
    case XRHandJoint::kIndexFingerTip:
      return "kIndexFingerTip";
    case XRHandJoint::kMiddleFingerMetacarpal:
      return "kMiddleFingerMetacarpal";
    case XRHandJoint::kMiddleFingerPhalanxProximal:
      return "kMiddleFingerPhalanxProximal";
    case XRHandJoint::kMiddleFingerPhalanxIntermediate:
      return "kMiddleFingerPhalanxIntermediate";
    case XRHandJoint::kMiddleFingerPhalanxDistal:
      return "kMiddleFingerPhalanxDistal";
    case XRHandJoint::kMiddleFingerTip:
      return "kMiddleFingerTip";
    case XRHandJoint::kRingFingerMetacarpal:
      return "kRingFingerMetacarpal";
    case XRHandJoint::kRingFingerPhalanxProximal:
      return "kRingFingerPhalanxProximal";
    case XRHandJoint::kRingFingerPhalanxIntermediate:
      return "kRingFingerPhalanxIntermediate";
    case XRHandJoint::kRingFingerPhalanxDistal:
      return "kRingFingerPhalanxDistal";
    case XRHandJoint::kRingFingerTip:
      return "kRingFingerTip";
    case XRHandJoint::kPinkyFingerMetacarpal:
      return "kPinkyFingerMetacarpal";
    case XRHandJoint::kPinkyFingerPhalanxProximal:
      return "kPinkyFingerPhalanxProximal";
    case XRHandJoint::kPinkyFingerPhalanxIntermediate:
      return "kPinkyFingerPhalanxIntermediate";
    case XRHandJoint::kPinkyFingerPhalanxDistal:
      return "kPinkyFingerPhalanxDistal";
    case XRHandJoint::kPinkyFingerTip:
      return "kPinkyFingerTip";
    default:
      return nullptr;
  }
}

std::string XRHandJointToString(XRHandJoint value) {
  const char *str = XRHandJointToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRHandJoint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRHandJoint value) {
  return os << XRHandJointToString(value);
}

static NOINLINE const char* XREyeToStringHelper(XREye value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XREye::kNone:
      return "kNone";
    case XREye::kLeft:
      return "kLeft";
    case XREye::kRight:
      return "kRight";
    default:
      return nullptr;
  }
}

std::string XREyeToString(XREye value) {
  const char *str = XREyeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XREye value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XREye value) {
  return os << XREyeToString(value);
}

static NOINLINE const char* XRPresentationTransportMethodToStringHelper(XRPresentationTransportMethod value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRPresentationTransportMethod::NONE:
      return "NONE";
    case XRPresentationTransportMethod::SUBMIT_AS_TEXTURE_HANDLE:
      return "SUBMIT_AS_TEXTURE_HANDLE";
    case XRPresentationTransportMethod::SUBMIT_AS_MAILBOX_HOLDER:
      return "SUBMIT_AS_MAILBOX_HOLDER";
    case XRPresentationTransportMethod::DRAW_INTO_TEXTURE_MAILBOX:
      return "DRAW_INTO_TEXTURE_MAILBOX";
    default:
      return nullptr;
  }
}

std::string XRPresentationTransportMethodToString(XRPresentationTransportMethod value) {
  const char *str = XRPresentationTransportMethodToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRPresentationTransportMethod value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRPresentationTransportMethod value) {
  return os << XRPresentationTransportMethodToString(value);
}

static NOINLINE const char* XRReferenceSpaceTypeToStringHelper(XRReferenceSpaceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRReferenceSpaceType::kViewer:
      return "kViewer";
    case XRReferenceSpaceType::kLocal:
      return "kLocal";
    case XRReferenceSpaceType::kLocalFloor:
      return "kLocalFloor";
    case XRReferenceSpaceType::kBoundedFloor:
      return "kBoundedFloor";
    case XRReferenceSpaceType::kUnbounded:
      return "kUnbounded";
    default:
      return nullptr;
  }
}

std::string XRReferenceSpaceTypeToString(XRReferenceSpaceType value) {
  const char *str = XRReferenceSpaceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRReferenceSpaceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRReferenceSpaceType value) {
  return os << XRReferenceSpaceTypeToString(value);
}

static NOINLINE const char* XRInputSourceSpaceTypeToStringHelper(XRInputSourceSpaceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRInputSourceSpaceType::kTargetRay:
      return "kTargetRay";
    case XRInputSourceSpaceType::kGrip:
      return "kGrip";
    default:
      return nullptr;
  }
}

std::string XRInputSourceSpaceTypeToString(XRInputSourceSpaceType value) {
  const char *str = XRInputSourceSpaceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRInputSourceSpaceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRInputSourceSpaceType value) {
  return os << XRInputSourceSpaceTypeToString(value);
}

static NOINLINE const char* XRPlaneOrientationToStringHelper(XRPlaneOrientation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRPlaneOrientation::UNKNOWN:
      return "UNKNOWN";
    case XRPlaneOrientation::HORIZONTAL:
      return "HORIZONTAL";
    case XRPlaneOrientation::VERTICAL:
      return "VERTICAL";
    default:
      return nullptr;
  }
}

std::string XRPlaneOrientationToString(XRPlaneOrientation value) {
  const char *str = XRPlaneOrientationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRPlaneOrientation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRPlaneOrientation value) {
  return os << XRPlaneOrientationToString(value);
}

static NOINLINE const char* RequestSessionErrorToStringHelper(RequestSessionError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestSessionError::EXISTING_IMMERSIVE_SESSION:
      return "EXISTING_IMMERSIVE_SESSION";
    case RequestSessionError::INVALID_CLIENT:
      return "INVALID_CLIENT";
    case RequestSessionError::USER_DENIED_CONSENT:
      return "USER_DENIED_CONSENT";
    case RequestSessionError::NO_RUNTIME_FOUND:
      return "NO_RUNTIME_FOUND";
    case RequestSessionError::UNKNOWN_RUNTIME_ERROR:
      return "UNKNOWN_RUNTIME_ERROR";
    case RequestSessionError::RUNTIME_INSTALL_FAILURE:
      return "RUNTIME_INSTALL_FAILURE";
    case RequestSessionError::RUNTIMES_CHANGED:
      return "RUNTIMES_CHANGED";
    case RequestSessionError::FULLSCREEN_ERROR:
      return "FULLSCREEN_ERROR";
    case RequestSessionError::UNKNOWN_FAILURE:
      return "UNKNOWN_FAILURE";
    default:
      return nullptr;
  }
}

std::string RequestSessionErrorToString(RequestSessionError value) {
  const char *str = RequestSessionErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestSessionError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestSessionError value) {
  return os << RequestSessionErrorToString(value);
}

static NOINLINE const char* XrCompatibleResultToStringHelper(XrCompatibleResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XrCompatibleResult::kAlreadyCompatible:
      return "kAlreadyCompatible";
    case XrCompatibleResult::kNoDeviceAvailable:
      return "kNoDeviceAvailable";
    case XrCompatibleResult::kWebXrFeaturePolicyBlocked:
      return "kWebXrFeaturePolicyBlocked";
    case XrCompatibleResult::kCompatibleAfterRestart:
      return "kCompatibleAfterRestart";
    case XrCompatibleResult::kNotCompatibleAfterRestart:
      return "kNotCompatibleAfterRestart";
    default:
      return nullptr;
  }
}

std::string XrCompatibleResultToString(XrCompatibleResult value) {
  const char *str = XrCompatibleResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XrCompatibleResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XrCompatibleResult value) {
  return os << XrCompatibleResultToString(value);
}

static NOINLINE const char* CreateAnchorResultToStringHelper(CreateAnchorResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateAnchorResult::SUCCESS:
      return "SUCCESS";
    case CreateAnchorResult::FAILURE:
      return "FAILURE";
    default:
      return nullptr;
  }
}

std::string CreateAnchorResultToString(CreateAnchorResult value) {
  const char *str = CreateAnchorResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateAnchorResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateAnchorResult value) {
  return os << CreateAnchorResultToString(value);
}

static NOINLINE const char* SubscribeToHitTestResultToStringHelper(SubscribeToHitTestResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SubscribeToHitTestResult::SUCCESS:
      return "SUCCESS";
    case SubscribeToHitTestResult::FAILURE_GENERIC:
      return "FAILURE_GENERIC";
    default:
      return nullptr;
  }
}

std::string SubscribeToHitTestResultToString(SubscribeToHitTestResult value) {
  const char *str = SubscribeToHitTestResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SubscribeToHitTestResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SubscribeToHitTestResult value) {
  return os << SubscribeToHitTestResultToString(value);
}

static NOINLINE const char* EntityTypeForHitTestToStringHelper(EntityTypeForHitTest value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EntityTypeForHitTest::POINT:
      return "POINT";
    case EntityTypeForHitTest::PLANE:
      return "PLANE";
    default:
      return nullptr;
  }
}

std::string EntityTypeForHitTestToString(EntityTypeForHitTest value) {
  const char *str = EntityTypeForHitTestToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EntityTypeForHitTest value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EntityTypeForHitTest value) {
  return os << EntityTypeForHitTestToString(value);
}

static NOINLINE const char* XRVisibilityStateToStringHelper(XRVisibilityState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRVisibilityState::VISIBLE:
      return "VISIBLE";
    case XRVisibilityState::VISIBLE_BLURRED:
      return "VISIBLE_BLURRED";
    case XRVisibilityState::HIDDEN:
      return "HIDDEN";
    default:
      return nullptr;
  }
}

std::string XRVisibilityStateToString(XRVisibilityState value) {
  const char *str = XRVisibilityStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRVisibilityState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRVisibilityState value) {
  return os << XRVisibilityStateToString(value);
}

namespace internal {
// static
bool XRNativeOriginInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const XRNativeOriginInformation_Data* object = static_cast<const XRNativeOriginInformation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case XRNativeOriginInformation_Tag::INPUT_SOURCE_SPACE_INFO: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_input_source_space_info, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_input_source_space_info, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::PLANE_ID: {

      return true;
    }
    case XRNativeOriginInformation_Tag::ANCHOR_ID: {

      return true;
    }
    case XRNativeOriginInformation_Tag::REFERENCE_SPACE_TYPE: {


      if (!::device::mojom::internal::XRReferenceSpaceType_Data
            ::Validate(object->data.f_reference_space_type, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::HAND_JOINT_SPACE_INFO: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_hand_joint_space_info, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_hand_joint_space_info, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::IMAGE_INDEX: {

      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in XRNativeOriginInformation");
      return false;
    }
  }
}
// static
bool XRDepthData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const XRDepthData_Data* object = static_cast<const XRDepthData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case XRDepthData_Tag::DATA_STILL_VALID: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data_still_valid, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_data_still_valid, validation_context))
        return false;
      return true;
    }
    case XRDepthData_Tag::UPDATED_DEPTH_DATA: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_updated_depth_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_updated_depth_data, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in XRDepthData");
      return false;
    }
  }
}
// static
bool RequestSessionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RequestSessionResult_Data* object = static_cast<const RequestSessionResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RequestSessionResult_Tag::SUCCESS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case RequestSessionResult_Tag::FAILURE_REASON: {


      if (!::device::mojom::internal::RequestSessionError_Data
            ::Validate(object->data.f_failure_reason, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RequestSessionResult");
      return false;
    }
  }
}


// static
bool XRTrackedImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTrackedImage_Data* object = static_cast<const XRTrackedImage_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitmap, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size_in_pixels, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size_in_pixels, validation_context))
    return false;

  return true;
}

XRTrackedImage_Data::XRTrackedImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRDepthOptions_Data* object = static_cast<const XRDepthOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->usage_preferences, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams usage_preferences_validate_params(
      0, ::device::mojom::internal::XRDepthUsage_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->usage_preferences, validation_context,
                                         &usage_preferences_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_format_preferences, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_format_preferences_validate_params(
      0, ::device::mojom::internal::XRDepthDataFormat_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->data_format_preferences, validation_context,
                                         &data_format_preferences_validate_params)) {
    return false;
  }

  return true;
}

XRDepthOptions_Data::XRDepthOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionOptions_Data* object = static_cast<const XRSessionOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRSessionMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->required_features, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams required_features_validate_params(
      0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->required_features, validation_context,
                                         &required_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->optional_features, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams optional_features_validate_params(
      0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->optional_features, validation_context,
                                         &optional_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tracked_images, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams tracked_images_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->tracked_images, validation_context,
                                         &tracked_images_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->depth_options, validation_context))
    return false;

  return true;
}

XRSessionOptions_Data::XRSessionOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRDepthConfig_Data* object = static_cast<const XRDepthConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRDepthUsage_Data
        ::Validate(object->depth_usage, validation_context))
    return false;


  if (!::device::mojom::internal::XRDepthDataFormat_Data
        ::Validate(object->depth_data_format, validation_context))
    return false;

  return true;
}

XRDepthConfig_Data::XRDepthConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionDeviceConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionDeviceConfig_Data* object = static_cast<const XRSessionDeviceConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->depth_configuration, validation_context))
    return false;

  return true;
}

XRSessionDeviceConfig_Data::XRSessionDeviceConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSession_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSession_Data* object = static_cast<const XRSession_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_provider,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->submit_frame_sink, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_features, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams enabled_features_validate_params(
      0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->enabled_features, validation_context,
                                         &enabled_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_config, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_config, validation_context))
    return false;


  if (!::device::mojom::internal::XREnvironmentBlendMode_Data
        ::Validate(object->enviroment_blend_mode, validation_context))
    return false;


  if (!::device::mojom::internal::XRInteractionMode_Data
        ::Validate(object->interaction_mode, validation_context))
    return false;

  return true;
}

XRSession_Data::XRSession_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationConnection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationConnection_Data* object = static_cast<const XRPresentationConnection_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->provider,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transport_options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transport_options, validation_context))
    return false;

  return true;
}

XRPresentationConnection_Data::XRPresentationConnection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceDescription_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRInputSourceDescription_Data* object = static_cast<const XRInputSourceDescription_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRTargetRayMode_Data
        ::Validate(object->target_ray_mode, validation_context))
    return false;


  if (!::device::mojom::internal::XRHandedness_Data
        ::Validate(object->handedness, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->input_from_pointer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profiles, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams profiles_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->profiles, validation_context,
                                         &profiles_validate_params)) {
    return false;
  }

  return true;
}

XRInputSourceDescription_Data::XRInputSourceDescription_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHandJointData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHandJointData_Data* object = static_cast<const XRHandJointData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRHandJoint_Data
        ::Validate(object->joint, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_joint, validation_context))
    return false;

  return true;
}

XRHandJointData_Data::XRHandJointData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHandTrackingData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHandTrackingData_Data* object = static_cast<const XRHandTrackingData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hand_joint_data, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hand_joint_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hand_joint_data, validation_context,
                                         &hand_joint_data_validate_params)) {
    return false;
  }

  return true;
}

XRHandTrackingData_Data::XRHandTrackingData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRInputSourceState_Data* object = static_cast<const XRInputSourceState_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_input, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->gamepad, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->overlay_pointer_position, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hand_tracking_data, validation_context))
    return false;

  return true;
}

XRInputSourceState_Data::XRInputSourceState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRFieldOfView_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRFieldOfView_Data* object = static_cast<const VRFieldOfView_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VRFieldOfView_Data::VRFieldOfView_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRPose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRPose_Data* object = static_cast<const VRPose_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

VRPose_Data::VRPose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Pose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Pose_Data* object = static_cast<const Pose_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->orientation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

Pose_Data::Pose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRRay_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRRay_Data* object = static_cast<const XRRay_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->direction, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->direction, validation_context))
    return false;

  return true;
}

XRRay_Data::XRRay_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitResult_Data* object = static_cast<const XRHitResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_result, validation_context))
    return false;

  return true;
}

XRHitResult_Data::XRHitResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRView_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRView_Data* object = static_cast<const XRView_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XREye_Data
        ::Validate(object->eye, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_of_view, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_of_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->head_from_eye, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->head_from_eye, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport, validation_context))
    return false;

  return true;
}

XRView_Data::XRView_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRStageParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRStageParameters_Data* object = static_cast<const VRStageParameters_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_floor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_floor, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams bounds_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bounds, validation_context,
                                         &bounds_validate_params)) {
    return false;
  }

  return true;
}

VRStageParameters_Data::VRStageParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRDisplayInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRDisplayInfo_Data* object = static_cast<const VRDisplayInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->views, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams views_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->views, validation_context,
                                         &views_validate_params)) {
    return false;
  }

  return true;
}

VRDisplayInfo_Data::VRDisplayInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationTransportOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationTransportOptions_Data* object = static_cast<const XRPresentationTransportOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRPresentationTransportMethod_Data
        ::Validate(object->transport_method, validation_context))
    return false;

  return true;
}

XRPresentationTransportOptions_Data::XRPresentationTransportOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceSpaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRInputSourceSpaceInfo_Data* object = static_cast<const XRInputSourceSpaceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRInputSourceSpaceType_Data
        ::Validate(object->input_source_space_type, validation_context))
    return false;

  return true;
}

XRInputSourceSpaceInfo_Data::XRInputSourceSpaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHandJointSpaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHandJointSpaceInfo_Data* object = static_cast<const XRHandJointSpaceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRHandedness_Data
        ::Validate(object->handedness, validation_context))
    return false;


  if (!::device::mojom::internal::XRHandJoint_Data
        ::Validate(object->joint, validation_context))
    return false;

  return true;
}

XRHandJointSpaceInfo_Data::XRHandJointSpaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlanePointData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPlanePointData_Data* object = static_cast<const XRPlanePointData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRPlanePointData_Data::XRPlanePointData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlaneData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPlaneData_Data* object = static_cast<const XRPlaneData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRPlaneOrientation_Data
        ::Validate(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_plane, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->polygon, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams polygon_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->polygon, validation_context,
                                         &polygon_validate_params)) {
    return false;
  }

  return true;
}

XRPlaneData_Data::XRPlaneData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlaneDetectionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPlaneDetectionData_Data* object = static_cast<const XRPlaneDetectionData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_planes_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams all_planes_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->all_planes_ids, validation_context,
                                         &all_planes_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_planes_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams updated_planes_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->updated_planes_data, validation_context,
                                         &updated_planes_data_validate_params)) {
    return false;
  }

  return true;
}

XRPlaneDetectionData_Data::XRPlaneDetectionData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRAnchorData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRAnchorData_Data* object = static_cast<const XRAnchorData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->mojo_from_anchor, validation_context))
    return false;

  return true;
}

XRAnchorData_Data::XRAnchorData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRAnchorsData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRAnchorsData_Data* object = static_cast<const XRAnchorsData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_anchors_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams all_anchors_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->all_anchors_ids, validation_context,
                                         &all_anchors_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_anchors_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams updated_anchors_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->updated_anchors_data, validation_context,
                                         &updated_anchors_data_validate_params)) {
    return false;
  }

  return true;
}

XRAnchorsData_Data::XRAnchorsData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestSubscriptionResultData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitTestSubscriptionResultData_Data* object = static_cast<const XRHitTestSubscriptionResultData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hit_test_results, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hit_test_results_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hit_test_results, validation_context,
                                         &hit_test_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestSubscriptionResultData_Data::XRHitTestSubscriptionResultData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestTransientInputSubscriptionResultData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitTestTransientInputSubscriptionResultData_Data* object = static_cast<const XRHitTestTransientInputSubscriptionResultData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_source_id_to_hit_test_results, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams input_source_id_to_hit_test_results_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->input_source_id_to_hit_test_results, validation_context,
                                         &input_source_id_to_hit_test_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestTransientInputSubscriptionResultData_Data::XRHitTestTransientInputSubscriptionResultData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestSubscriptionResultsData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitTestSubscriptionResultsData_Data* object = static_cast<const XRHitTestSubscriptionResultsData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->results, validation_context,
                                         &results_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transient_input_results, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams transient_input_results_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->transient_input_results, validation_context,
                                         &transient_input_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestSubscriptionResultsData_Data::XRHitTestSubscriptionResultsData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RgbTupleF32_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RgbTupleF32_Data* object = static_cast<const RgbTupleF32_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RgbTupleF32_Data::RgbTupleF32_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSphericalHarmonics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSphericalHarmonics_Data* object = static_cast<const XRSphericalHarmonics_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coefficients, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams coefficients_validate_params(
      9, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->coefficients, validation_context,
                                         &coefficients_validate_params)) {
    return false;
  }

  return true;
}

XRSphericalHarmonics_Data::XRSphericalHarmonics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RgbaTupleF16_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RgbaTupleF16_Data* object = static_cast<const RgbaTupleF16_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RgbaTupleF16_Data::RgbaTupleF16_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRCubeMap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRCubeMap_Data* object = static_cast<const XRCubeMap_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_x, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams positive_x_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->positive_x, validation_context,
                                         &positive_x_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_x, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams negative_x_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->negative_x, validation_context,
                                         &negative_x_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_y, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams positive_y_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->positive_y, validation_context,
                                         &positive_y_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_y, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams negative_y_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->negative_y, validation_context,
                                         &negative_y_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_z, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams positive_z_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->positive_z, validation_context,
                                         &positive_z_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_z, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams negative_z_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->negative_z, validation_context,
                                         &negative_z_validate_params)) {
    return false;
  }

  return true;
}

XRCubeMap_Data::XRCubeMap_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRLightProbe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRLightProbe_Data* object = static_cast<const XRLightProbe_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spherical_harmonics, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->spherical_harmonics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_light_direction, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_light_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_light_intensity, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_light_intensity, validation_context))
    return false;

  return true;
}

XRLightProbe_Data::XRLightProbe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRReflectionProbe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRReflectionProbe_Data* object = static_cast<const XRReflectionProbe_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cube_map, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cube_map, validation_context))
    return false;

  return true;
}

XRReflectionProbe_Data::XRReflectionProbe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRLightEstimationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRLightEstimationData_Data* object = static_cast<const XRLightEstimationData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->light_probe, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reflection_probe, validation_context))
    return false;

  return true;
}

XRLightEstimationData_Data::XRLightEstimationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthDataStillValid_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRDepthDataStillValid_Data* object = static_cast<const XRDepthDataStillValid_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRDepthDataStillValid_Data::XRDepthDataStillValid_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthDataUpdated_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRDepthDataUpdated_Data* object = static_cast<const XRDepthDataUpdated_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_delta, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_delta, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pixel_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pixel_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->norm_texture_from_norm_view, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->norm_texture_from_norm_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

XRDepthDataUpdated_Data::XRDepthDataUpdated_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTrackedImageData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTrackedImageData_Data* object = static_cast<const XRTrackedImageData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_image, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_image, validation_context))
    return false;

  return true;
}

XRTrackedImageData_Data::XRTrackedImageData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTrackedImagesData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTrackedImagesData_Data* object = static_cast<const XRTrackedImagesData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->images_data, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams images_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->images_data, validation_context,
                                         &images_data_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams image_trackable_scores_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->image_trackable_scores, validation_context,
                                         &image_trackable_scores_validate_params)) {
    return false;
  }

  return true;
}

XRTrackedImagesData_Data::XRTrackedImagesData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 144, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameData_Data* object = static_cast<const XRFrameData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->pose, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_delta, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_delta, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->buffer_holder, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->camera_image_buffer_holder, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->camera_image_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->depth_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->views, 9, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams views_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->views, validation_context,
                                         &views_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams input_state_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->input_state, validation_context,
                                         &input_state_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->stage_parameters, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->detected_planes_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->anchors_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->light_estimation_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hit_test_subscription_results, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tracked_images, validation_context))
    return false;

  return true;
}

XRFrameData_Data::XRFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequestSessionSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RequestSessionSuccess_Data* object = static_cast<const RequestSessionSuccess_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->metrics_recorder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->metrics_recorder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RequestSessionSuccess_Data::RequestSessionSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataRequestOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataRequestOptions_Data* object = static_cast<const XRFrameDataRequestOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRFrameDataRequestOptions_Data::XRFrameDataRequestOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SetClient_Params_Data* object = static_cast<const VRService_SetClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VRService_SetClient_Params_Data::VRService_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_RequestSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_RequestSession_Params_Data* object = static_cast<const VRService_RequestSession_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

VRService_RequestSession_Params_Data::VRService_RequestSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_RequestSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_RequestSession_ResponseParams_Data* object = static_cast<const VRService_RequestSession_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

VRService_RequestSession_ResponseParams_Data::VRService_RequestSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SupportsSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SupportsSession_Params_Data* object = static_cast<const VRService_SupportsSession_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

VRService_SupportsSession_Params_Data::VRService_SupportsSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SupportsSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SupportsSession_ResponseParams_Data* object = static_cast<const VRService_SupportsSession_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VRService_SupportsSession_ResponseParams_Data::VRService_SupportsSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_ExitPresent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_ExitPresent_Params_Data* object = static_cast<const VRService_ExitPresent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VRService_ExitPresent_Params_Data::VRService_ExitPresent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_ExitPresent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_ExitPresent_ResponseParams_Data* object = static_cast<const VRService_ExitPresent_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VRService_ExitPresent_ResponseParams_Data::VRService_ExitPresent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SetFramesThrottled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SetFramesThrottled_Params_Data* object = static_cast<const VRService_SetFramesThrottled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VRService_SetFramesThrottled_Params_Data::VRService_SetFramesThrottled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_MakeXrCompatible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_MakeXrCompatible_Params_Data* object = static_cast<const VRService_MakeXrCompatible_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VRService_MakeXrCompatible_Params_Data::VRService_MakeXrCompatible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_MakeXrCompatible_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_MakeXrCompatible_ResponseParams_Data* object = static_cast<const VRService_MakeXrCompatible_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XrCompatibleResult_Data
        ::Validate(object->xr_compatible_result, validation_context))
    return false;

  return true;
}

VRService_MakeXrCompatible_ResponseParams_Data::VRService_MakeXrCompatible_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* object = static_cast<const XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRSessionFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRServiceClient_OnDeviceChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRServiceClient_OnDeviceChanged_Params_Data* object = static_cast<const VRServiceClient_OnDeviceChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VRServiceClient_OnDeviceChanged_Params_Data::VRServiceClient_OnDeviceChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entity_types, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams entity_types_validate_params(
      0, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->entity_types, validation_context,
                                         &entity_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ray, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ray, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::SubscribeToHitTestResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams profile_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->profile_name, validation_context,
                                         &profile_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entity_types, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams entity_types_validate_params(
      0, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->entity_types, validation_context,
                                         &entity_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ray, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ray, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::SubscribeToHitTestResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreateAnchor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_origin_from_anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->native_origin_from_anchor, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::CreateAnchorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_origin_from_anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->native_origin_from_anchor, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::CreateAnchorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_DetachAnchor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceButtonListener_OnButtonEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRInputSourceButtonListener_OnButtonEvent_Params_Data* object = static_cast<const XRInputSourceButtonListener_OnButtonEvent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_source, validation_context))
    return false;

  return true;
}

XRInputSourceButtonListener_OnButtonEvent_Params_Data::XRInputSourceButtonListener_OnButtonEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetFrameData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_GetFrameData_Params_Data* object = static_cast<const XRFrameDataProvider_GetFrameData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

XRFrameDataProvider_GetFrameData_Params_Data::XRFrameDataProvider_GetFrameData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetFrameData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_GetFrameData_ResponseParams_Data* object = static_cast<const XRFrameDataProvider_GetFrameData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->frame_data, validation_context))
    return false;

  return true;
}

XRFrameDataProvider_GetFrameData_ResponseParams_Data::XRFrameDataProvider_GetFrameData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* object = static_cast<const XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->environment_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->environment_provider,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_SetInputSourceButtonListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_SetInputSourceButtonListener_Params_Data* object = static_cast<const XRFrameDataProvider_SetInputSourceButtonListener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->event_listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRFrameDataProvider_SetInputSourceButtonListener_Params_Data::XRFrameDataProvider_SetInputSourceButtonListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_UpdateLayerBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_UpdateLayerBounds_Params_Data* object = static_cast<const XRPresentationProvider_UpdateLayerBounds_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->left_bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->left_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->right_bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->right_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_size, validation_context))
    return false;

  return true;
}

XRPresentationProvider_UpdateLayerBounds_Params_Data::XRPresentationProvider_UpdateLayerBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameMissing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrameMissing_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrameMissing_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrameMissing_Params_Data::XRPresentationProvider_SubmitFrameMissing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrame_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrame_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox_holder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox_holder, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_waited, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_waited, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrame_Params_Data::XRPresentationProvider_SubmitFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->texture, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->texture,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data::XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_waited, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_waited, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameTransferred_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationClient_OnSubmitFrameTransferred_Params_Data* object = static_cast<const XRPresentationClient_OnSubmitFrameTransferred_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRPresentationClient_OnSubmitFrameTransferred_Params_Data::XRPresentationClient_OnSubmitFrameTransferred_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationClient_OnSubmitFrameRendered_Params_Data* object = static_cast<const XRPresentationClient_OnSubmitFrameRendered_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRPresentationClient_OnSubmitFrameRendered_Params_Data::XRPresentationClient_OnSubmitFrameRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* object = static_cast<const XRPresentationClient_OnSubmitFrameGpuFence_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_fence_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_fence_handle, validation_context))
    return false;

  return true;
}

XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionClient_OnChanged_Params_Data* object = static_cast<const XRSessionClient_OnChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display, validation_context))
    return false;

  return true;
}

XRSessionClient_OnChanged_Params_Data::XRSessionClient_OnChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnExitPresent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionClient_OnExitPresent_Params_Data* object = static_cast<const XRSessionClient_OnExitPresent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRSessionClient_OnExitPresent_Params_Data::XRSessionClient_OnExitPresent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnVisibilityStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionClient_OnVisibilityStateChanged_Params_Data* object = static_cast<const XRSessionClient_OnVisibilityStateChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::XRVisibilityState_Data
        ::Validate(object->visibility_state, validation_context))
    return false;

  return true;
}

XRSessionClient_OnVisibilityStateChanged_Params_Data::XRSessionClient_OnVisibilityStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRDeviceId>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRDeviceId value) {
  return std::move(context).WriteString(::device::mojom::XRDeviceIdToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRHandedness>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRHandedness value) {
  return std::move(context).WriteString(::device::mojom::XRHandednessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRTargetRayMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRTargetRayMode value) {
  return std::move(context).WriteString(::device::mojom::XRTargetRayModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRSessionFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRSessionFeature value) {
  return std::move(context).WriteString(::device::mojom::XRSessionFeatureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRSessionFeatureRequestStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRSessionFeatureRequestStatus value) {
  return std::move(context).WriteString(::device::mojom::XRSessionFeatureRequestStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRSessionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRSessionMode value) {
  return std::move(context).WriteString(::device::mojom::XRSessionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XREnvironmentBlendMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XREnvironmentBlendMode value) {
  return std::move(context).WriteString(::device::mojom::XREnvironmentBlendModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRDepthUsage>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRDepthUsage value) {
  return std::move(context).WriteString(::device::mojom::XRDepthUsageToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRDepthDataFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRDepthDataFormat value) {
  return std::move(context).WriteString(::device::mojom::XRDepthDataFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRInteractionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRInteractionMode value) {
  return std::move(context).WriteString(::device::mojom::XRInteractionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRHandJoint>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRHandJoint value) {
  return std::move(context).WriteString(::device::mojom::XRHandJointToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XREye>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XREye value) {
  return std::move(context).WriteString(::device::mojom::XREyeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRPresentationTransportMethod>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRPresentationTransportMethod value) {
  return std::move(context).WriteString(::device::mojom::XRPresentationTransportMethodToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRReferenceSpaceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRReferenceSpaceType value) {
  return std::move(context).WriteString(::device::mojom::XRReferenceSpaceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRInputSourceSpaceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRInputSourceSpaceType value) {
  return std::move(context).WriteString(::device::mojom::XRInputSourceSpaceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRPlaneOrientation>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRPlaneOrientation value) {
  return std::move(context).WriteString(::device::mojom::XRPlaneOrientationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::RequestSessionError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::RequestSessionError value) {
  return std::move(context).WriteString(::device::mojom::RequestSessionErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XrCompatibleResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XrCompatibleResult value) {
  return std::move(context).WriteString(::device::mojom::XrCompatibleResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::CreateAnchorResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::CreateAnchorResult value) {
  return std::move(context).WriteString(::device::mojom::CreateAnchorResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SubscribeToHitTestResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SubscribeToHitTestResult value) {
  return std::move(context).WriteString(::device::mojom::SubscribeToHitTestResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::EntityTypeForHitTest>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::EntityTypeForHitTest value) {
  return std::move(context).WriteString(::device::mojom::EntityTypeForHitTestToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRVisibilityState>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRVisibilityState value) {
  return std::move(context).WriteString(::device::mojom::XRVisibilityStateToString(value));
}

} // namespace perfetto
