// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/app_current_window_internal.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/app_current_window_internal.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace app_current_window_internal {
//
// Types
//

Bounds::Bounds()
 {}

Bounds::~Bounds() = default;
Bounds::Bounds(Bounds&& rhs) = default;
Bounds& Bounds::operator=(Bounds&& rhs) = default;
// static
bool Bounds::Populate(
    const base::Value& value, Bounds* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* left_value = dict->FindKey("left");
  if (left_value) {
    {
      auto temp = left_value->GetIfInt();
      if (!temp.has_value()) {
        out->left.reset();
        return false;
      }
      out->left = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* top_value = dict->FindKey("top");
  if (top_value) {
    {
      auto temp = top_value->GetIfInt();
      if (!temp.has_value()) {
        out->top.reset();
        return false;
      }
      out->top = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* width_value = dict->FindKey("width");
  if (width_value) {
    {
      auto temp = width_value->GetIfInt();
      if (!temp.has_value()) {
        out->width.reset();
        return false;
      }
      out->width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* height_value = dict->FindKey("height");
  if (height_value) {
    {
      auto temp = height_value->GetIfInt();
      if (!temp.has_value()) {
        out->height.reset();
        return false;
      }
      out->height = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<Bounds> Bounds::FromValue(const base::Value& value) {
  auto out = std::make_unique<Bounds>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Bounds::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->left.get()) {
    to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(*this->left));

  }
  if (this->top.get()) {
    to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(*this->top));

  }
  if (this->width.get()) {
    to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(*this->width));

  }
  if (this->height.get()) {
    to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(*this->height));

  }

  return to_value_result;
}


SizeConstraints::SizeConstraints()
 {}

SizeConstraints::~SizeConstraints() = default;
SizeConstraints::SizeConstraints(SizeConstraints&& rhs) = default;
SizeConstraints& SizeConstraints::operator=(SizeConstraints&& rhs) = default;
// static
bool SizeConstraints::Populate(
    const base::Value& value, SizeConstraints* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* min_width_value = dict->FindKey("minWidth");
  if (min_width_value) {
    {
      auto temp = min_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_width.reset();
        return false;
      }
      out->min_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* min_height_value = dict->FindKey("minHeight");
  if (min_height_value) {
    {
      auto temp = min_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_height.reset();
        return false;
      }
      out->min_height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_width_value = dict->FindKey("maxWidth");
  if (max_width_value) {
    {
      auto temp = max_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_width.reset();
        return false;
      }
      out->max_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_height_value = dict->FindKey("maxHeight");
  if (max_height_value) {
    {
      auto temp = max_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_height.reset();
        return false;
      }
      out->max_height = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<SizeConstraints> SizeConstraints::FromValue(const base::Value& value) {
  auto out = std::make_unique<SizeConstraints>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SizeConstraints::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->min_width.get()) {
    to_value_result->SetWithoutPathExpansion("minWidth", std::make_unique<base::Value>(*this->min_width));

  }
  if (this->min_height.get()) {
    to_value_result->SetWithoutPathExpansion("minHeight", std::make_unique<base::Value>(*this->min_height));

  }
  if (this->max_width.get()) {
    to_value_result->SetWithoutPathExpansion("maxWidth", std::make_unique<base::Value>(*this->max_width));

  }
  if (this->max_height.get()) {
    to_value_result->SetWithoutPathExpansion("maxHeight", std::make_unique<base::Value>(*this->max_height));

  }

  return to_value_result;
}


RegionRect::RegionRect()
: left(0),
top(0),
width(0),
height(0) {}

RegionRect::~RegionRect() = default;
RegionRect::RegionRect(RegionRect&& rhs) = default;
RegionRect& RegionRect::operator=(RegionRect&& rhs) = default;
// static
bool RegionRect::Populate(
    const base::Value& value, RegionRect* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* left_value = dict->FindKey("left");
  if (!left_value) {
    return false;
  }
  {
    auto temp = left_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->left = temp.value();
  }

  const base::Value* top_value = dict->FindKey("top");
  if (!top_value) {
    return false;
  }
  {
    auto temp = top_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->top = temp.value();
  }

  const base::Value* width_value = dict->FindKey("width");
  if (!width_value) {
    return false;
  }
  {
    auto temp = width_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->width = temp.value();
  }

  const base::Value* height_value = dict->FindKey("height");
  if (!height_value) {
    return false;
  }
  {
    auto temp = height_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->height = temp.value();
  }

  return true;
}

// static
std::unique_ptr<RegionRect> RegionRect::FromValue(const base::Value& value) {
  auto out = std::make_unique<RegionRect>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RegionRect::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(this->left));

  to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(this->top));

  to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(this->width));

  to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(this->height));


  return to_value_result;
}


Region::Region()
 {}

Region::~Region() = default;
Region::Region(Region&& rhs) = default;
Region& Region::operator=(Region&& rhs) = default;
// static
bool Region::Populate(
    const base::Value& value, Region* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* rects_value = dict->FindKey("rects");
  if (rects_value) {
    {
      const base::ListValue* list = nullptr;
      if (!rects_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->rects)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<Region> Region::FromValue(const base::Value& value) {
  auto out = std::make_unique<Region>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Region::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->rects.get()) {
    to_value_result->SetWithoutPathExpansion("rects", json_schema_compiler::util::CreateValueFromArray(*this->rects));

  }

  return to_value_result;
}



//
// Functions
//

namespace Focus {

}  // namespace Focus

namespace Fullscreen {

}  // namespace Fullscreen

namespace Minimize {

}  // namespace Minimize

namespace Maximize {

}  // namespace Maximize

namespace Restore {

}  // namespace Restore

namespace DrawAttention {

}  // namespace DrawAttention

namespace ClearAttention {

}  // namespace ClearAttention

namespace Show {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* focused_value = nullptr;
  if (args.Get(0, &focused_value) &&
      !focused_value->is_none()) {
    {
      auto temp = focused_value->GetIfBool();
      if (!temp.has_value()) {
        params->focused.reset();
        return std::unique_ptr<Params>();
      }
      params->focused = std::make_unique<bool>(temp.value());
    }
  }

  return params;
}


}  // namespace Show

namespace Hide {

}  // namespace Hide

namespace SetBounds {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* bounds_type_value = nullptr;
  if (args.Get(0, &bounds_type_value) &&
      !bounds_type_value->is_none()) {
    {
      auto* temp = bounds_type_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->bounds_type = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* bounds_value = nullptr;
  if (args.Get(1, &bounds_value) &&
      !bounds_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!bounds_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!Bounds::Populate(*dictionary, &params->bounds)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetBounds

namespace SetSizeConstraints {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* bounds_type_value = nullptr;
  if (args.Get(0, &bounds_type_value) &&
      !bounds_type_value->is_none()) {
    {
      auto* temp = bounds_type_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->bounds_type = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* constraints_value = nullptr;
  if (args.Get(1, &constraints_value) &&
      !constraints_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!constraints_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!SizeConstraints::Populate(*dictionary, &params->constraints)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetSizeConstraints

namespace SetIcon {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* icon_url_value = nullptr;
  if (args.Get(0, &icon_url_value) &&
      !icon_url_value->is_none()) {
    {
      auto* temp = icon_url_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->icon_url = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetIcon

namespace SetShape {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* region_value = nullptr;
  if (args.Get(0, &region_value) &&
      !region_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!region_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!Region::Populate(*dictionary, &params->region)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetShape

namespace SetAlwaysOnTop {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* always_on_top_value = nullptr;
  if (args.Get(0, &always_on_top_value) &&
      !always_on_top_value->is_none()) {
    {
      auto temp = always_on_top_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->always_on_top = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetAlwaysOnTop

namespace SetVisibleOnAllWorkspaces {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* always_visible_value = nullptr;
  if (args.Get(0, &always_visible_value) &&
      !always_visible_value->is_none()) {
    {
      auto temp = always_visible_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->always_visible = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetVisibleOnAllWorkspaces

namespace SetActivateOnPointer {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* activate_on_pointer_value = nullptr;
  if (args.Get(0, &activate_on_pointer_value) &&
      !activate_on_pointer_value->is_none()) {
    {
      auto temp = activate_on_pointer_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->activate_on_pointer = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace SetActivateOnPointer

//
// Events
//

namespace OnClosed {

const char kEventName[] = "app.currentWindowInternal.onClosed";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnClosed

namespace OnBoundsChanged {

const char kEventName[] = "app.currentWindowInternal.onBoundsChanged";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnBoundsChanged

namespace OnFullscreened {

const char kEventName[] = "app.currentWindowInternal.onFullscreened";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnFullscreened

namespace OnMinimized {

const char kEventName[] = "app.currentWindowInternal.onMinimized";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnMinimized

namespace OnMaximized {

const char kEventName[] = "app.currentWindowInternal.onMaximized";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnMaximized

namespace OnRestored {

const char kEventName[] = "app.currentWindowInternal.onRestored";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnRestored

namespace OnAlphaEnabledChanged {

const char kEventName[] = "app.currentWindowInternal.onAlphaEnabledChanged";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnAlphaEnabledChanged

}  // namespace app_current_window_internal
}  // namespace api
}  // namespace extensions

