// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/app_window.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/app_window.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"
#include "extensions/common/api/app_runtime.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace app_window {
//
// Types
//

ContentBounds::ContentBounds()
 {}

ContentBounds::~ContentBounds() = default;
ContentBounds::ContentBounds(ContentBounds&& rhs) = default;
ContentBounds& ContentBounds::operator=(ContentBounds&& rhs) = default;
// static
bool ContentBounds::Populate(
    const base::Value& value, ContentBounds* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* left_value = dict->FindKey("left");
  if (left_value) {
    {
      auto temp = left_value->GetIfInt();
      if (!temp.has_value()) {
        out->left.reset();
        return false;
      }
      out->left = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* top_value = dict->FindKey("top");
  if (top_value) {
    {
      auto temp = top_value->GetIfInt();
      if (!temp.has_value()) {
        out->top.reset();
        return false;
      }
      out->top = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* width_value = dict->FindKey("width");
  if (width_value) {
    {
      auto temp = width_value->GetIfInt();
      if (!temp.has_value()) {
        out->width.reset();
        return false;
      }
      out->width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* height_value = dict->FindKey("height");
  if (height_value) {
    {
      auto temp = height_value->GetIfInt();
      if (!temp.has_value()) {
        out->height.reset();
        return false;
      }
      out->height = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ContentBounds> ContentBounds::FromValue(const base::Value& value) {
  auto out = std::make_unique<ContentBounds>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ContentBounds::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->left.get()) {
    to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(*this->left));

  }
  if (this->top.get()) {
    to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(*this->top));

  }
  if (this->width.get()) {
    to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(*this->width));

  }
  if (this->height.get()) {
    to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(*this->height));

  }

  return to_value_result;
}


BoundsSpecification::BoundsSpecification()
 {}

BoundsSpecification::~BoundsSpecification() = default;
BoundsSpecification::BoundsSpecification(BoundsSpecification&& rhs) = default;
BoundsSpecification& BoundsSpecification::operator=(BoundsSpecification&& rhs) = default;
// static
bool BoundsSpecification::Populate(
    const base::Value& value, BoundsSpecification* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* left_value = dict->FindKey("left");
  if (left_value) {
    {
      auto temp = left_value->GetIfInt();
      if (!temp.has_value()) {
        out->left.reset();
        return false;
      }
      out->left = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* top_value = dict->FindKey("top");
  if (top_value) {
    {
      auto temp = top_value->GetIfInt();
      if (!temp.has_value()) {
        out->top.reset();
        return false;
      }
      out->top = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* width_value = dict->FindKey("width");
  if (width_value) {
    {
      auto temp = width_value->GetIfInt();
      if (!temp.has_value()) {
        out->width.reset();
        return false;
      }
      out->width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* height_value = dict->FindKey("height");
  if (height_value) {
    {
      auto temp = height_value->GetIfInt();
      if (!temp.has_value()) {
        out->height.reset();
        return false;
      }
      out->height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* min_width_value = dict->FindKey("minWidth");
  if (min_width_value) {
    {
      auto temp = min_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_width.reset();
        return false;
      }
      out->min_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* min_height_value = dict->FindKey("minHeight");
  if (min_height_value) {
    {
      auto temp = min_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_height.reset();
        return false;
      }
      out->min_height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_width_value = dict->FindKey("maxWidth");
  if (max_width_value) {
    {
      auto temp = max_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_width.reset();
        return false;
      }
      out->max_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_height_value = dict->FindKey("maxHeight");
  if (max_height_value) {
    {
      auto temp = max_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_height.reset();
        return false;
      }
      out->max_height = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<BoundsSpecification> BoundsSpecification::FromValue(const base::Value& value) {
  auto out = std::make_unique<BoundsSpecification>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> BoundsSpecification::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->left.get()) {
    to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(*this->left));

  }
  if (this->top.get()) {
    to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(*this->top));

  }
  if (this->width.get()) {
    to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(*this->width));

  }
  if (this->height.get()) {
    to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(*this->height));

  }
  if (this->min_width.get()) {
    to_value_result->SetWithoutPathExpansion("minWidth", std::make_unique<base::Value>(*this->min_width));

  }
  if (this->min_height.get()) {
    to_value_result->SetWithoutPathExpansion("minHeight", std::make_unique<base::Value>(*this->min_height));

  }
  if (this->max_width.get()) {
    to_value_result->SetWithoutPathExpansion("maxWidth", std::make_unique<base::Value>(*this->max_width));

  }
  if (this->max_height.get()) {
    to_value_result->SetWithoutPathExpansion("maxHeight", std::make_unique<base::Value>(*this->max_height));

  }

  return to_value_result;
}


Bounds::Bounds()
: left(0),
top(0),
width(0),
height(0) {}

Bounds::~Bounds() = default;
Bounds::Bounds(Bounds&& rhs) = default;
Bounds& Bounds::operator=(Bounds&& rhs) = default;
// static
bool Bounds::Populate(
    const base::Value& value, Bounds* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* left_value = dict->FindKey("left");
  if (!left_value) {
    return false;
  }
  {
    auto temp = left_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->left = temp.value();
  }

  const base::Value* top_value = dict->FindKey("top");
  if (!top_value) {
    return false;
  }
  {
    auto temp = top_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->top = temp.value();
  }

  const base::Value* width_value = dict->FindKey("width");
  if (!width_value) {
    return false;
  }
  {
    auto temp = width_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->width = temp.value();
  }

  const base::Value* height_value = dict->FindKey("height");
  if (!height_value) {
    return false;
  }
  {
    auto temp = height_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->height = temp.value();
  }

  const base::Value* min_width_value = dict->FindKey("minWidth");
  if (min_width_value) {
    {
      auto temp = min_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_width.reset();
        return false;
      }
      out->min_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* min_height_value = dict->FindKey("minHeight");
  if (min_height_value) {
    {
      auto temp = min_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_height.reset();
        return false;
      }
      out->min_height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_width_value = dict->FindKey("maxWidth");
  if (max_width_value) {
    {
      auto temp = max_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_width.reset();
        return false;
      }
      out->max_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_height_value = dict->FindKey("maxHeight");
  if (max_height_value) {
    {
      auto temp = max_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_height.reset();
        return false;
      }
      out->max_height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* set_position_value = dict->FindKey("setPosition");
  if (!set_position_value) {
    return false;
  }

  const base::Value* set_size_value = dict->FindKey("setSize");
  if (!set_size_value) {
    return false;
  }

  const base::Value* set_minimum_size_value = dict->FindKey("setMinimumSize");
  if (!set_minimum_size_value) {
    return false;
  }

  const base::Value* set_maximum_size_value = dict->FindKey("setMaximumSize");
  if (!set_maximum_size_value) {
    return false;
  }

  return true;
}

// static
std::unique_ptr<Bounds> Bounds::FromValue(const base::Value& value) {
  auto out = std::make_unique<Bounds>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Bounds::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(this->left));

  to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(this->top));

  to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(this->width));

  to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(this->height));

  if (this->min_width.get()) {
    to_value_result->SetWithoutPathExpansion("minWidth", std::make_unique<base::Value>(*this->min_width));

  }
  if (this->min_height.get()) {
    to_value_result->SetWithoutPathExpansion("minHeight", std::make_unique<base::Value>(*this->min_height));

  }
  if (this->max_width.get()) {
    to_value_result->SetWithoutPathExpansion("maxWidth", std::make_unique<base::Value>(*this->max_width));

  }
  if (this->max_height.get()) {
    to_value_result->SetWithoutPathExpansion("maxHeight", std::make_unique<base::Value>(*this->max_height));

  }
  to_value_result->SetWithoutPathExpansion("setPosition", (this->set_position).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("setSize", (this->set_size).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("setMinimumSize", (this->set_minimum_size).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("setMaximumSize", (this->set_maximum_size).CreateDeepCopy());


  return to_value_result;
}


FrameOptions::FrameOptions()
 {}

FrameOptions::~FrameOptions() = default;
FrameOptions::FrameOptions(FrameOptions&& rhs) = default;
FrameOptions& FrameOptions::operator=(FrameOptions&& rhs) = default;
// static
bool FrameOptions::Populate(
    const base::Value& value, FrameOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* type_value = dict->FindKey("type");
  if (type_value) {
    {
      auto* temp = type_value->GetIfString();
      if (!temp) {
        out->type.reset();
        return false;
      }
      out->type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* color_value = dict->FindKey("color");
  if (color_value) {
    {
      auto* temp = color_value->GetIfString();
      if (!temp) {
        out->color.reset();
        return false;
      }
      out->color = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* active_color_value = dict->FindKey("activeColor");
  if (active_color_value) {
    {
      auto* temp = active_color_value->GetIfString();
      if (!temp) {
        out->active_color.reset();
        return false;
      }
      out->active_color = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* inactive_color_value = dict->FindKey("inactiveColor");
  if (inactive_color_value) {
    {
      auto* temp = inactive_color_value->GetIfString();
      if (!temp) {
        out->inactive_color.reset();
        return false;
      }
      out->inactive_color = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<FrameOptions> FrameOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<FrameOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> FrameOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->type.get()) {
    to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(*this->type));

  }
  if (this->color.get()) {
    to_value_result->SetWithoutPathExpansion("color", std::make_unique<base::Value>(*this->color));

  }
  if (this->active_color.get()) {
    to_value_result->SetWithoutPathExpansion("activeColor", std::make_unique<base::Value>(*this->active_color));

  }
  if (this->inactive_color.get()) {
    to_value_result->SetWithoutPathExpansion("inactiveColor", std::make_unique<base::Value>(*this->inactive_color));

  }

  return to_value_result;
}


const char* ToString(State enum_param) {
  switch (enum_param) {
    case STATE_NORMAL:
      return "normal";
    case STATE_FULLSCREEN:
      return "fullscreen";
    case STATE_MAXIMIZED:
      return "maximized";
    case STATE_MINIMIZED:
      return "minimized";
    case STATE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

State ParseState(const std::string& enum_string) {
  if (enum_string == "normal")
    return STATE_NORMAL;
  if (enum_string == "fullscreen")
    return STATE_FULLSCREEN;
  if (enum_string == "maximized")
    return STATE_MAXIMIZED;
  if (enum_string == "minimized")
    return STATE_MINIMIZED;
  return STATE_NONE;
}


const char* ToString(WindowType enum_param) {
  switch (enum_param) {
    case WINDOW_TYPE_SHELL:
      return "shell";
    case WINDOW_TYPE_PANEL:
      return "panel";
    case WINDOW_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

WindowType ParseWindowType(const std::string& enum_string) {
  if (enum_string == "shell")
    return WINDOW_TYPE_SHELL;
  if (enum_string == "panel")
    return WINDOW_TYPE_PANEL;
  return WINDOW_TYPE_NONE;
}


CreateWindowOptions::Frame::Frame()
 {}

CreateWindowOptions::Frame::~Frame() = default;
CreateWindowOptions::Frame::Frame(Frame&& rhs) = default;
CreateWindowOptions::Frame& CreateWindowOptions::Frame::operator=(Frame&& rhs) = default;
// static
bool CreateWindowOptions::Frame::Populate(
    const base::Value& value, Frame* out) {
  if (value.type() == base::Value::Type::STRING) {
    {
      auto* temp = (&value)->GetIfString();
      if (!temp) {
        out->as_string.reset();
        return false;
      }
      out->as_string = std::make_unique<std::string>(*temp);
    }
    return true;
  }
  if (value.type() == base::Value::Type::DICTIONARY) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!(&value)->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<FrameOptions>();
        if (!FrameOptions::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->as_frame_options = std::move(temp);
      }
    }
    return true;
  }
  return false;
}

std::unique_ptr<base::Value> CreateWindowOptions::Frame::ToValue() const {
  std::unique_ptr<base::Value> result;
  if (as_string) {
    DCHECK(!result) << "Cannot set multiple choices for frame";
    result = std::make_unique<base::Value>(*as_string);

  }
  if (as_frame_options) {
    DCHECK(!result) << "Cannot set multiple choices for frame";
    result = (as_frame_options)->ToValue();

  }
  DCHECK(result) << "Must set at least one choice for frame";
  return result;
}



CreateWindowOptions::CreateWindowOptions()
: type(WINDOW_TYPE_NONE),
state(STATE_NONE),
lock_screen_action(app_runtime::ACTION_TYPE_NONE) {}

CreateWindowOptions::~CreateWindowOptions() = default;
CreateWindowOptions::CreateWindowOptions(CreateWindowOptions&& rhs) = default;
CreateWindowOptions& CreateWindowOptions::operator=(CreateWindowOptions&& rhs) = default;
// static
bool CreateWindowOptions::Populate(
    const base::Value& value, CreateWindowOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->type = WINDOW_TYPE_NONE;
  out->state = STATE_NONE;
  out->lock_screen_action = app_runtime::ACTION_TYPE_NONE;
  const base::Value* id_value = dict->FindKey("id");
  if (id_value) {
    {
      auto* temp = id_value->GetIfString();
      if (!temp) {
        out->id.reset();
        return false;
      }
      out->id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* inner_bounds_value = dict->FindKey("innerBounds");
  if (inner_bounds_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!inner_bounds_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<BoundsSpecification>();
        if (!BoundsSpecification::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->inner_bounds = std::move(temp);
      }
    }
  }

  const base::Value* outer_bounds_value = dict->FindKey("outerBounds");
  if (outer_bounds_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!outer_bounds_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<BoundsSpecification>();
        if (!BoundsSpecification::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->outer_bounds = std::move(temp);
      }
    }
  }

  const base::Value* default_width_value = dict->FindKey("defaultWidth");
  if (default_width_value) {
    {
      auto temp = default_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->default_width.reset();
        return false;
      }
      out->default_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* default_height_value = dict->FindKey("defaultHeight");
  if (default_height_value) {
    {
      auto temp = default_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->default_height.reset();
        return false;
      }
      out->default_height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* default_left_value = dict->FindKey("defaultLeft");
  if (default_left_value) {
    {
      auto temp = default_left_value->GetIfInt();
      if (!temp.has_value()) {
        out->default_left.reset();
        return false;
      }
      out->default_left = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* default_top_value = dict->FindKey("defaultTop");
  if (default_top_value) {
    {
      auto temp = default_top_value->GetIfInt();
      if (!temp.has_value()) {
        out->default_top.reset();
        return false;
      }
      out->default_top = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* width_value = dict->FindKey("width");
  if (width_value) {
    {
      auto temp = width_value->GetIfInt();
      if (!temp.has_value()) {
        out->width.reset();
        return false;
      }
      out->width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* height_value = dict->FindKey("height");
  if (height_value) {
    {
      auto temp = height_value->GetIfInt();
      if (!temp.has_value()) {
        out->height.reset();
        return false;
      }
      out->height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* left_value = dict->FindKey("left");
  if (left_value) {
    {
      auto temp = left_value->GetIfInt();
      if (!temp.has_value()) {
        out->left.reset();
        return false;
      }
      out->left = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* top_value = dict->FindKey("top");
  if (top_value) {
    {
      auto temp = top_value->GetIfInt();
      if (!temp.has_value()) {
        out->top.reset();
        return false;
      }
      out->top = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* min_width_value = dict->FindKey("minWidth");
  if (min_width_value) {
    {
      auto temp = min_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_width.reset();
        return false;
      }
      out->min_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* min_height_value = dict->FindKey("minHeight");
  if (min_height_value) {
    {
      auto temp = min_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->min_height.reset();
        return false;
      }
      out->min_height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_width_value = dict->FindKey("maxWidth");
  if (max_width_value) {
    {
      auto temp = max_width_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_width.reset();
        return false;
      }
      out->max_width = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* max_height_value = dict->FindKey("maxHeight");
  if (max_height_value) {
    {
      auto temp = max_height_value->GetIfInt();
      if (!temp.has_value()) {
        out->max_height.reset();
        return false;
      }
      out->max_height = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* type_value = dict->FindKey("type");
  if (type_value) {
    {
      std::string window_type_as_string;
      if (!type_value->GetAsString(&window_type_as_string)) {
        return false;
      }
      out->type = ParseWindowType(window_type_as_string);
      if (out->type == WINDOW_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->type = WINDOW_TYPE_NONE;
  }

  const base::Value* ime_value = dict->FindKey("ime");
  if (ime_value) {
    {
      auto temp = ime_value->GetIfBool();
      if (!temp.has_value()) {
        out->ime.reset();
        return false;
      }
      out->ime = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* show_in_shelf_value = dict->FindKey("showInShelf");
  if (show_in_shelf_value) {
    {
      auto temp = show_in_shelf_value->GetIfBool();
      if (!temp.has_value()) {
        out->show_in_shelf.reset();
        return false;
      }
      out->show_in_shelf = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* icon_value = dict->FindKey("icon");
  if (icon_value) {
    {
      auto* temp = icon_value->GetIfString();
      if (!temp) {
        out->icon.reset();
        return false;
      }
      out->icon = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* frame_value = dict->FindKey("frame");
  if (frame_value) {
    {
      auto temp = std::make_unique<Frame>();
      if (!Frame::Populate(*frame_value, temp.get()))
        return false;
      out->frame = std::move(temp);
    }
  }

  const base::Value* bounds_value = dict->FindKey("bounds");
  if (bounds_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!bounds_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ContentBounds>();
        if (!ContentBounds::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->bounds = std::move(temp);
      }
    }
  }

  const base::Value* alpha_enabled_value = dict->FindKey("alphaEnabled");
  if (alpha_enabled_value) {
    {
      auto temp = alpha_enabled_value->GetIfBool();
      if (!temp.has_value()) {
        out->alpha_enabled.reset();
        return false;
      }
      out->alpha_enabled = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* state_value = dict->FindKey("state");
  if (state_value) {
    {
      std::string state_as_string;
      if (!state_value->GetAsString(&state_as_string)) {
        return false;
      }
      out->state = ParseState(state_as_string);
      if (out->state == STATE_NONE) {
        return false;
      }
    }
    } else {
    out->state = STATE_NONE;
  }

  const base::Value* hidden_value = dict->FindKey("hidden");
  if (hidden_value) {
    {
      auto temp = hidden_value->GetIfBool();
      if (!temp.has_value()) {
        out->hidden.reset();
        return false;
      }
      out->hidden = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* resizable_value = dict->FindKey("resizable");
  if (resizable_value) {
    {
      auto temp = resizable_value->GetIfBool();
      if (!temp.has_value()) {
        out->resizable.reset();
        return false;
      }
      out->resizable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* singleton_value = dict->FindKey("singleton");
  if (singleton_value) {
    {
      auto temp = singleton_value->GetIfBool();
      if (!temp.has_value()) {
        out->singleton.reset();
        return false;
      }
      out->singleton = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* always_on_top_value = dict->FindKey("alwaysOnTop");
  if (always_on_top_value) {
    {
      auto temp = always_on_top_value->GetIfBool();
      if (!temp.has_value()) {
        out->always_on_top.reset();
        return false;
      }
      out->always_on_top = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* focused_value = dict->FindKey("focused");
  if (focused_value) {
    {
      auto temp = focused_value->GetIfBool();
      if (!temp.has_value()) {
        out->focused.reset();
        return false;
      }
      out->focused = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* visible_on_all_workspaces_value = dict->FindKey("visibleOnAllWorkspaces");
  if (visible_on_all_workspaces_value) {
    {
      auto temp = visible_on_all_workspaces_value->GetIfBool();
      if (!temp.has_value()) {
        out->visible_on_all_workspaces.reset();
        return false;
      }
      out->visible_on_all_workspaces = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* lock_screen_action_value = dict->FindKey("lockScreenAction");
  if (lock_screen_action_value) {
    {
      std::string action_type_as_string;
      if (!lock_screen_action_value->GetAsString(&action_type_as_string)) {
        return false;
      }
      out->lock_screen_action = app_runtime::ParseActionType(action_type_as_string);
      if (out->lock_screen_action == app_runtime::ACTION_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->lock_screen_action = app_runtime::ACTION_TYPE_NONE;
  }

  return true;
}

// static
std::unique_ptr<CreateWindowOptions> CreateWindowOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<CreateWindowOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CreateWindowOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->id.get()) {
    to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(*this->id));

  }
  if (this->inner_bounds.get()) {
    to_value_result->SetWithoutPathExpansion("innerBounds", (this->inner_bounds)->ToValue());

  }
  if (this->outer_bounds.get()) {
    to_value_result->SetWithoutPathExpansion("outerBounds", (this->outer_bounds)->ToValue());

  }
  if (this->default_width.get()) {
    to_value_result->SetWithoutPathExpansion("defaultWidth", std::make_unique<base::Value>(*this->default_width));

  }
  if (this->default_height.get()) {
    to_value_result->SetWithoutPathExpansion("defaultHeight", std::make_unique<base::Value>(*this->default_height));

  }
  if (this->default_left.get()) {
    to_value_result->SetWithoutPathExpansion("defaultLeft", std::make_unique<base::Value>(*this->default_left));

  }
  if (this->default_top.get()) {
    to_value_result->SetWithoutPathExpansion("defaultTop", std::make_unique<base::Value>(*this->default_top));

  }
  if (this->width.get()) {
    to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(*this->width));

  }
  if (this->height.get()) {
    to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(*this->height));

  }
  if (this->left.get()) {
    to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(*this->left));

  }
  if (this->top.get()) {
    to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(*this->top));

  }
  if (this->min_width.get()) {
    to_value_result->SetWithoutPathExpansion("minWidth", std::make_unique<base::Value>(*this->min_width));

  }
  if (this->min_height.get()) {
    to_value_result->SetWithoutPathExpansion("minHeight", std::make_unique<base::Value>(*this->min_height));

  }
  if (this->max_width.get()) {
    to_value_result->SetWithoutPathExpansion("maxWidth", std::make_unique<base::Value>(*this->max_width));

  }
  if (this->max_height.get()) {
    to_value_result->SetWithoutPathExpansion("maxHeight", std::make_unique<base::Value>(*this->max_height));

  }
  if (this->type != WINDOW_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(app_window::ToString(this->type)));

  }
  if (this->ime.get()) {
    to_value_result->SetWithoutPathExpansion("ime", std::make_unique<base::Value>(*this->ime));

  }
  if (this->show_in_shelf.get()) {
    to_value_result->SetWithoutPathExpansion("showInShelf", std::make_unique<base::Value>(*this->show_in_shelf));

  }
  if (this->icon.get()) {
    to_value_result->SetWithoutPathExpansion("icon", std::make_unique<base::Value>(*this->icon));

  }
  if (this->frame.get()) {
    to_value_result->SetWithoutPathExpansion("frame", (this->frame)->ToValue());

  }
  if (this->bounds.get()) {
    to_value_result->SetWithoutPathExpansion("bounds", (this->bounds)->ToValue());

  }
  if (this->alpha_enabled.get()) {
    to_value_result->SetWithoutPathExpansion("alphaEnabled", std::make_unique<base::Value>(*this->alpha_enabled));

  }
  if (this->state != STATE_NONE) {
    to_value_result->SetWithoutPathExpansion("state", std::make_unique<base::Value>(app_window::ToString(this->state)));

  }
  if (this->hidden.get()) {
    to_value_result->SetWithoutPathExpansion("hidden", std::make_unique<base::Value>(*this->hidden));

  }
  if (this->resizable.get()) {
    to_value_result->SetWithoutPathExpansion("resizable", std::make_unique<base::Value>(*this->resizable));

  }
  if (this->singleton.get()) {
    to_value_result->SetWithoutPathExpansion("singleton", std::make_unique<base::Value>(*this->singleton));

  }
  if (this->always_on_top.get()) {
    to_value_result->SetWithoutPathExpansion("alwaysOnTop", std::make_unique<base::Value>(*this->always_on_top));

  }
  if (this->focused.get()) {
    to_value_result->SetWithoutPathExpansion("focused", std::make_unique<base::Value>(*this->focused));

  }
  if (this->visible_on_all_workspaces.get()) {
    to_value_result->SetWithoutPathExpansion("visibleOnAllWorkspaces", std::make_unique<base::Value>(*this->visible_on_all_workspaces));

  }
  if (this->lock_screen_action != app_runtime::ACTION_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("lockScreenAction", std::make_unique<base::Value>(app_runtime::ToString(this->lock_screen_action)));

  }

  return to_value_result;
}


AppWindow::ContentWindow::ContentWindow()
 {}

AppWindow::ContentWindow::~ContentWindow() = default;
AppWindow::ContentWindow::ContentWindow(ContentWindow&& rhs) = default;
AppWindow::ContentWindow& AppWindow::ContentWindow::operator=(ContentWindow&& rhs) = default;
// static
bool AppWindow::ContentWindow::Populate(
    const base::Value& value, ContentWindow* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->additional_properties.MergeDictionary(dict);
  return true;
}

std::unique_ptr<base::DictionaryValue> AppWindow::ContentWindow::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->MergeDictionary(&additional_properties);

  return to_value_result;
}



AppWindow::AppWindow()
: has_frame_color(false),
active_frame_color(0),
inactive_frame_color(0) {}

AppWindow::~AppWindow() = default;
AppWindow::AppWindow(AppWindow&& rhs) = default;
AppWindow& AppWindow::operator=(AppWindow&& rhs) = default;
// static
bool AppWindow::Populate(
    const base::Value& value, AppWindow* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* focus_value = dict->FindKey("focus");
  if (!focus_value) {
    return false;
  }

  const base::Value* fullscreen_value = dict->FindKey("fullscreen");
  if (!fullscreen_value) {
    return false;
  }

  const base::Value* is_fullscreen_value = dict->FindKey("isFullscreen");
  if (!is_fullscreen_value) {
    return false;
  }

  const base::Value* minimize_value = dict->FindKey("minimize");
  if (!minimize_value) {
    return false;
  }

  const base::Value* is_minimized_value = dict->FindKey("isMinimized");
  if (!is_minimized_value) {
    return false;
  }

  const base::Value* maximize_value = dict->FindKey("maximize");
  if (!maximize_value) {
    return false;
  }

  const base::Value* is_maximized_value = dict->FindKey("isMaximized");
  if (!is_maximized_value) {
    return false;
  }

  const base::Value* restore_value = dict->FindKey("restore");
  if (!restore_value) {
    return false;
  }

  const base::Value* move_to_value = dict->FindKey("moveTo");
  if (!move_to_value) {
    return false;
  }

  const base::Value* resize_to_value = dict->FindKey("resizeTo");
  if (!resize_to_value) {
    return false;
  }

  const base::Value* draw_attention_value = dict->FindKey("drawAttention");
  if (!draw_attention_value) {
    return false;
  }

  const base::Value* clear_attention_value = dict->FindKey("clearAttention");
  if (!clear_attention_value) {
    return false;
  }

  const base::Value* close_value = dict->FindKey("close");
  if (!close_value) {
    return false;
  }

  const base::Value* show_value = dict->FindKey("show");
  if (!show_value) {
    return false;
  }

  const base::Value* hide_value = dict->FindKey("hide");
  if (!hide_value) {
    return false;
  }

  const base::Value* set_icon_value = dict->FindKey("setIcon");
  if (!set_icon_value) {
    return false;
  }

  const base::Value* is_always_on_top_value = dict->FindKey("isAlwaysOnTop");
  if (!is_always_on_top_value) {
    return false;
  }

  const base::Value* has_frame_color_value = dict->FindKey("hasFrameColor");
  if (!has_frame_color_value) {
    return false;
  }
  {
    auto temp = has_frame_color_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->has_frame_color = temp.value();
  }

  const base::Value* active_frame_color_value = dict->FindKey("activeFrameColor");
  if (!active_frame_color_value) {
    return false;
  }
  {
    auto temp = active_frame_color_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->active_frame_color = temp.value();
  }

  const base::Value* inactive_frame_color_value = dict->FindKey("inactiveFrameColor");
  if (!inactive_frame_color_value) {
    return false;
  }
  {
    auto temp = inactive_frame_color_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->inactive_frame_color = temp.value();
  }

  const base::Value* set_always_on_top_value = dict->FindKey("setAlwaysOnTop");
  if (!set_always_on_top_value) {
    return false;
  }

  const base::Value* alpha_enabled_value = dict->FindKey("alphaEnabled");
  if (!alpha_enabled_value) {
    return false;
  }

  const base::Value* set_visible_on_all_workspaces_value = dict->FindKey("setVisibleOnAllWorkspaces");
  if (!set_visible_on_all_workspaces_value) {
    return false;
  }

  const base::Value* content_window_value = dict->FindKey("contentWindow");
  if (!content_window_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!content_window_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ContentWindow::Populate(*dictionary, &out->content_window)) {
      return false;
    }
  }

  const base::Value* id_value = dict->FindKey("id");
  if (!id_value) {
    return false;
  }
  {
    auto* temp = id_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->id = *temp;
  }

  const base::Value* inner_bounds_value = dict->FindKey("innerBounds");
  if (!inner_bounds_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!inner_bounds_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!Bounds::Populate(*dictionary, &out->inner_bounds)) {
      return false;
    }
  }

  const base::Value* outer_bounds_value = dict->FindKey("outerBounds");
  if (!outer_bounds_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!outer_bounds_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!Bounds::Populate(*dictionary, &out->outer_bounds)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<AppWindow> AppWindow::FromValue(const base::Value& value) {
  auto out = std::make_unique<AppWindow>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> AppWindow::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("focus", (this->focus).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("fullscreen", (this->fullscreen).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("isFullscreen", (this->is_fullscreen).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("minimize", (this->minimize).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("isMinimized", (this->is_minimized).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("maximize", (this->maximize).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("isMaximized", (this->is_maximized).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("restore", (this->restore).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("moveTo", (this->move_to).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("resizeTo", (this->resize_to).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("drawAttention", (this->draw_attention).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("clearAttention", (this->clear_attention).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("close", (this->close).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("show", (this->show).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("hide", (this->hide).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("setIcon", (this->set_icon).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("isAlwaysOnTop", (this->is_always_on_top).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("hasFrameColor", std::make_unique<base::Value>(this->has_frame_color));

  to_value_result->SetWithoutPathExpansion("activeFrameColor", std::make_unique<base::Value>(this->active_frame_color));

  to_value_result->SetWithoutPathExpansion("inactiveFrameColor", std::make_unique<base::Value>(this->inactive_frame_color));

  to_value_result->SetWithoutPathExpansion("setAlwaysOnTop", (this->set_always_on_top).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("alphaEnabled", (this->alpha_enabled).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("setVisibleOnAllWorkspaces", (this->set_visible_on_all_workspaces).CreateDeepCopy());

  to_value_result->SetWithoutPathExpansion("contentWindow", (this->content_window).ToValue());

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  to_value_result->SetWithoutPathExpansion("innerBounds", (this->inner_bounds).ToValue());

  to_value_result->SetWithoutPathExpansion("outerBounds", (this->outer_bounds).ToValue());


  return to_value_result;
}



//
// Functions
//

namespace Create {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* url_value = nullptr;
  if (args.Get(0, &url_value) &&
      !url_value->is_none()) {
    {
      auto* temp = url_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->url = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<CreateWindowOptions>();
        if (!CreateWindowOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


Results::CreatedWindow::CreatedWindow()
 {}

Results::CreatedWindow::~CreatedWindow() = default;
Results::CreatedWindow::CreatedWindow(CreatedWindow&& rhs) = default;
Results::CreatedWindow& Results::CreatedWindow::operator=(CreatedWindow&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::CreatedWindow::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->MergeDictionary(&additional_properties);

  return to_value_result;
}


std::vector<base::Value> Results::Create(const CreatedWindow& created_window) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((created_window).ToValue()));

  return create_results;
}
}  // namespace Create

}  // namespace app_window
}  // namespace api
}  // namespace extensions

