// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/cross_origin_isolation.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/cross_origin_isolation.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace cross_origin_isolation {
//
// Types
//

ResponseHeader::ResponseHeader()
 {}

ResponseHeader::~ResponseHeader() = default;
ResponseHeader::ResponseHeader(ResponseHeader&& rhs) = default;
ResponseHeader& ResponseHeader::operator=(ResponseHeader&& rhs) = default;
// static
constexpr char ResponseHeader::kValue[];

// static
bool ResponseHeader::Populate(
    const base::Value& value, ResponseHeader* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* value_value = dict->FindKey("value");
  if (value_value) {
    {
      auto* temp = value_value->GetIfString();
      if (!temp) {
        out->value.reset();
        return false;
      }
      out->value = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<ResponseHeader> ResponseHeader::FromValue(const base::Value& value) {
  auto out = std::make_unique<ResponseHeader>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ResponseHeader::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->value.get()) {
    to_value_result->SetWithoutPathExpansion("value", std::make_unique<base::Value>(*this->value));

  }

  return to_value_result;
}

//static
bool ResponseHeader::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, ResponseHeader* out, std::u16string* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kValue, &out->value, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
 {}

ManifestKeys::~ManifestKeys() = default;
ManifestKeys::ManifestKeys(ManifestKeys&& rhs) = default;
ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs) = default;
// static
constexpr char ManifestKeys::kCrossOriginEmbedderPolicy[];
// static
constexpr char ManifestKeys::kCrossOriginOpenerPolicy[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, std::u16string* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kCrossOriginEmbedderPolicy, &out->cross_origin_embedder_policy, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kCrossOriginOpenerPolicy, &out->cross_origin_opener_policy, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


}  // namespace cross_origin_isolation
}  // namespace api
}  // namespace extensions

