// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/dns.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/dns.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace dns {
//
// Types
//

ResolveCallbackResolveInfo::ResolveCallbackResolveInfo()
: result_code(0) {}

ResolveCallbackResolveInfo::~ResolveCallbackResolveInfo() = default;
ResolveCallbackResolveInfo::ResolveCallbackResolveInfo(ResolveCallbackResolveInfo&& rhs) = default;
ResolveCallbackResolveInfo& ResolveCallbackResolveInfo::operator=(ResolveCallbackResolveInfo&& rhs) = default;
// static
bool ResolveCallbackResolveInfo::Populate(
    const base::Value& value, ResolveCallbackResolveInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* result_code_value = dict->FindKey("resultCode");
  if (!result_code_value) {
    return false;
  }
  {
    auto temp = result_code_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->result_code = temp.value();
  }

  const base::Value* address_value = dict->FindKey("address");
  if (address_value) {
    {
      auto* temp = address_value->GetIfString();
      if (!temp) {
        out->address.reset();
        return false;
      }
      out->address = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<ResolveCallbackResolveInfo> ResolveCallbackResolveInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ResolveCallbackResolveInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ResolveCallbackResolveInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("resultCode", std::make_unique<base::Value>(this->result_code));

  if (this->address.get()) {
    to_value_result->SetWithoutPathExpansion("address", std::make_unique<base::Value>(*this->address));

  }

  return to_value_result;
}



//
// Functions
//

namespace Resolve {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* hostname_value = nullptr;
  if (args.Get(0, &hostname_value) &&
      !hostname_value->is_none()) {
    {
      auto* temp = hostname_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->hostname = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const ResolveCallbackResolveInfo& resolve_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((resolve_info).ToValue()));

  return create_results;
}
}  // namespace Resolve

}  // namespace dns
}  // namespace api
}  // namespace extensions

