// extensions/common/api/mime_handler.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/api/mime_handler.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/api/mime_handler.mojom-params-data.h"
namespace extensions {
namespace mime_handler {

namespace internal {


// static
bool StreamInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const StreamInfo_Data* object = static_cast<const StreamInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_url, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams original_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->original_url, validation_context,
                                         &original_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stream_url, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stream_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stream_url, validation_context,
                                         &stream_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_headers, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams response_headers_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->response_headers, validation_context,
                                         &response_headers_validate_params)) {
    return false;
  }

  return true;
}

StreamInfo_Data::StreamInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MimeHandlerService_GetStreamInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MimeHandlerService_GetStreamInfo_Params_Data* object = static_cast<const MimeHandlerService_GetStreamInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MimeHandlerService_GetStreamInfo_Params_Data::MimeHandlerService_GetStreamInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MimeHandlerService_GetStreamInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MimeHandlerService_GetStreamInfo_ResponseParams_Data* object = static_cast<const MimeHandlerService_GetStreamInfo_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->stream_info, validation_context))
    return false;

  return true;
}

MimeHandlerService_GetStreamInfo_ResponseParams_Data::MimeHandlerService_GetStreamInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data* object = static_cast<const BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data* object = static_cast<const BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mime_handler
}  // namespace extensions
