// extensions/common/api/mime_handler.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/api/mime_handler.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/api/mime_handler.mojom-params-data.h"
#include "extensions/common/api/mime_handler.mojom-shared-message-ids.h"

#include "extensions/common/api/mime_handler.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mime_handler {
StreamInfo::StreamInfo()
    : mime_type(),
      original_url(),
      stream_url(),
      tab_id(),
      response_headers(),
      embedded() {}

StreamInfo::StreamInfo(
    const std::string& mime_type_in,
    const std::string& original_url_in,
    const std::string& stream_url_in,
    int32_t tab_id_in,
    const base::flat_map<std::string, std::string>& response_headers_in,
    bool embedded_in)
    : mime_type(std::move(mime_type_in)),
      original_url(std::move(original_url_in)),
      stream_url(std::move(stream_url_in)),
      tab_id(std::move(tab_id_in)),
      response_headers(std::move(response_headers_in)),
      embedded(std::move(embedded_in)) {}

StreamInfo::~StreamInfo() = default;

void StreamInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_url"), this->original_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_url"), this->stream_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_headers"), this->response_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedded"), this->embedded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StreamInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char MimeHandlerService::Name_[] = "extensions.mime_handler.MimeHandlerService";

class MimeHandlerService_GetStreamInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MimeHandlerService_GetStreamInfo_ForwardToCallback(
      MimeHandlerService::GetStreamInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MimeHandlerService::GetStreamInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MimeHandlerService_GetStreamInfo_ForwardToCallback);
};

MimeHandlerServiceProxy::MimeHandlerServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MimeHandlerServiceProxy::GetStreamInfo(
    GetStreamInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "extensions::mime_handler::MimeHandlerService::GetStreamInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMimeHandlerService_GetStreamInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::MimeHandlerService_GetStreamInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerService::Name_);
  message.set_method_name("GetStreamInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MimeHandlerService_GetStreamInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class MimeHandlerService_GetStreamInfo_ProxyToResponder {
 public:
  static MimeHandlerService::GetStreamInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MimeHandlerService_GetStreamInfo_ProxyToResponder> proxy(
        new MimeHandlerService_GetStreamInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MimeHandlerService_GetStreamInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MimeHandlerService_GetStreamInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MimeHandlerService_GetStreamInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MimeHandlerService::GetStreamInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      StreamInfoPtr in_stream_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MimeHandlerService_GetStreamInfo_ProxyToResponder);
};

bool MimeHandlerService_GetStreamInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mime_handler::MimeHandlerService::GetStreamInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  StreamInfoPtr p_stream_info{};
  MimeHandlerService_GetStreamInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStreamInfo(&p_stream_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MimeHandlerService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_stream_info));
  return true;
}

void MimeHandlerService_GetStreamInfo_ProxyToResponder::Run(
    StreamInfoPtr in_stream_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)extensions::mime_handler::MimeHandlerService::GetStreamInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_info"), in_stream_info,
                        "<value of type StreamInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMimeHandlerService_GetStreamInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stream_info)::BaseType> stream_info_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mime_handler::StreamInfoDataView>(
      in_stream_info, stream_info_fragment);
  params->stream_info.Set(
      stream_info_fragment.is_null() ? nullptr : stream_info_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mime_handler::MimeHandlerService::GetStreamInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerService::Name_);
  message.set_method_name("GetStreamInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MimeHandlerServiceStubDispatch::Accept(
    MimeHandlerService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMimeHandlerService_GetStreamInfo_Name: {
      break;
    }
  }
  return false;
}

// static
bool MimeHandlerServiceStubDispatch::AcceptWithResponder(
    MimeHandlerService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMimeHandlerService_GetStreamInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mime_handler::MimeHandlerService::GetStreamInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mime_handler::MimeHandlerService::GetStreamInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MimeHandlerService_GetStreamInfo_Params_Data* params =
          reinterpret_cast<
              internal::MimeHandlerService_GetStreamInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      MimeHandlerService_GetStreamInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerService::Name_, 0, false);
        return false;
      }
      MimeHandlerService::GetStreamInfoCallback callback =
          MimeHandlerService_GetStreamInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStreamInfo(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMimeHandlerServiceValidationInfo[] = {
    {internal::kMimeHandlerService_GetStreamInfo_Name,
     {&internal::MimeHandlerService_GetStreamInfo_Params_Data::Validate,
      &internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data::Validate}},
};

bool MimeHandlerServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mime_handler::MimeHandlerService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMimeHandlerServiceValidationInfo);
}

bool MimeHandlerServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mime_handler::MimeHandlerService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kMimeHandlerServiceValidationInfo);

}
const char BeforeUnloadControl::Name_[] = "extensions.mime_handler.BeforeUnloadControl";

class BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback(
      BeforeUnloadControl::SetShowBeforeUnloadDialogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BeforeUnloadControl::SetShowBeforeUnloadDialogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback);
};

BeforeUnloadControlProxy::BeforeUnloadControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BeforeUnloadControlProxy::SetShowBeforeUnloadDialog(
    bool in_show_dialog, SetShowBeforeUnloadDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show_dialog"), in_show_dialog,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBeforeUnloadControl_SetShowBeforeUnloadDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data> params(
          message);
  params.Allocate();
  params->show_dialog = in_show_dialog;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BeforeUnloadControl::Name_);
  message.set_method_name("SetShowBeforeUnloadDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder {
 public:
  static BeforeUnloadControl::SetShowBeforeUnloadDialogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder> proxy(
        new BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BeforeUnloadControl::SetShowBeforeUnloadDialogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder);
};

bool BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialogCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BeforeUnloadControl::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialogCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBeforeUnloadControl_SetShowBeforeUnloadDialog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BeforeUnloadControl::Name_);
  message.set_method_name("SetShowBeforeUnloadDialog");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BeforeUnloadControlStubDispatch::Accept(
    BeforeUnloadControl* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBeforeUnloadControl_SetShowBeforeUnloadDialog_Name: {
      break;
    }
  }
  return false;
}

// static
bool BeforeUnloadControlStubDispatch::AcceptWithResponder(
    BeforeUnloadControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBeforeUnloadControl_SetShowBeforeUnloadDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data* params =
          reinterpret_cast<
              internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_show_dialog{};
      BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_show_dialog = input_data_view.show_dialog();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BeforeUnloadControl::Name_, 0, false);
        return false;
      }
      BeforeUnloadControl::SetShowBeforeUnloadDialogCallback callback =
          BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetShowBeforeUnloadDialog(
std::move(p_show_dialog), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBeforeUnloadControlValidationInfo[] = {
    {internal::kBeforeUnloadControl_SetShowBeforeUnloadDialog_Name,
     {&internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data::Validate,
      &internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data::Validate}},
};

bool BeforeUnloadControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mime_handler::BeforeUnloadControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBeforeUnloadControlValidationInfo);
}

bool BeforeUnloadControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mime_handler::BeforeUnloadControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBeforeUnloadControlValidationInfo);

}
}  // namespace mime_handler
}  // namespace extensions

namespace mojo {


// static
bool StructTraits<::extensions::mime_handler::StreamInfo::DataView, ::extensions::mime_handler::StreamInfoPtr>::Read(
    ::extensions::mime_handler::StreamInfo::DataView input,
    ::extensions::mime_handler::StreamInfoPtr* output) {
  bool success = true;
  ::extensions::mime_handler::StreamInfoPtr result(::extensions::mime_handler::StreamInfo::New());
  
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadOriginalUrl(&result->original_url))
        success = false;
      if (success && !input.ReadStreamUrl(&result->stream_url))
        success = false;
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadResponseHeaders(&result->response_headers))
        success = false;
      if (success)
        result->embedded = input.embedded();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif