// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/networking_private.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/networking_private.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace networking_private {
//
// Types
//

const char* ToString(ActivationStateType enum_param) {
  switch (enum_param) {
    case ACTIVATION_STATE_TYPE_ACTIVATED:
      return "Activated";
    case ACTIVATION_STATE_TYPE_ACTIVATING:
      return "Activating";
    case ACTIVATION_STATE_TYPE_NOTACTIVATED:
      return "NotActivated";
    case ACTIVATION_STATE_TYPE_PARTIALLYACTIVATED:
      return "PartiallyActivated";
    case ACTIVATION_STATE_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ActivationStateType ParseActivationStateType(const std::string& enum_string) {
  if (enum_string == "Activated")
    return ACTIVATION_STATE_TYPE_ACTIVATED;
  if (enum_string == "Activating")
    return ACTIVATION_STATE_TYPE_ACTIVATING;
  if (enum_string == "NotActivated")
    return ACTIVATION_STATE_TYPE_NOTACTIVATED;
  if (enum_string == "PartiallyActivated")
    return ACTIVATION_STATE_TYPE_PARTIALLYACTIVATED;
  return ACTIVATION_STATE_TYPE_NONE;
}


const char* ToString(CaptivePortalStatus enum_param) {
  switch (enum_param) {
    case CAPTIVE_PORTAL_STATUS_UNKNOWN:
      return "Unknown";
    case CAPTIVE_PORTAL_STATUS_OFFLINE:
      return "Offline";
    case CAPTIVE_PORTAL_STATUS_ONLINE:
      return "Online";
    case CAPTIVE_PORTAL_STATUS_PORTAL:
      return "Portal";
    case CAPTIVE_PORTAL_STATUS_PROXYAUTHREQUIRED:
      return "ProxyAuthRequired";
    case CAPTIVE_PORTAL_STATUS_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

CaptivePortalStatus ParseCaptivePortalStatus(const std::string& enum_string) {
  if (enum_string == "Unknown")
    return CAPTIVE_PORTAL_STATUS_UNKNOWN;
  if (enum_string == "Offline")
    return CAPTIVE_PORTAL_STATUS_OFFLINE;
  if (enum_string == "Online")
    return CAPTIVE_PORTAL_STATUS_ONLINE;
  if (enum_string == "Portal")
    return CAPTIVE_PORTAL_STATUS_PORTAL;
  if (enum_string == "ProxyAuthRequired")
    return CAPTIVE_PORTAL_STATUS_PROXYAUTHREQUIRED;
  return CAPTIVE_PORTAL_STATUS_NONE;
}


const char* ToString(ConnectionStateType enum_param) {
  switch (enum_param) {
    case CONNECTION_STATE_TYPE_CONNECTED:
      return "Connected";
    case CONNECTION_STATE_TYPE_CONNECTING:
      return "Connecting";
    case CONNECTION_STATE_TYPE_NOTCONNECTED:
      return "NotConnected";
    case CONNECTION_STATE_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ConnectionStateType ParseConnectionStateType(const std::string& enum_string) {
  if (enum_string == "Connected")
    return CONNECTION_STATE_TYPE_CONNECTED;
  if (enum_string == "Connecting")
    return CONNECTION_STATE_TYPE_CONNECTING;
  if (enum_string == "NotConnected")
    return CONNECTION_STATE_TYPE_NOTCONNECTED;
  return CONNECTION_STATE_TYPE_NONE;
}


const char* ToString(DeviceStateType enum_param) {
  switch (enum_param) {
    case DEVICE_STATE_TYPE_UNINITIALIZED:
      return "Uninitialized";
    case DEVICE_STATE_TYPE_DISABLED:
      return "Disabled";
    case DEVICE_STATE_TYPE_ENABLING:
      return "Enabling";
    case DEVICE_STATE_TYPE_ENABLED:
      return "Enabled";
    case DEVICE_STATE_TYPE_PROHIBITED:
      return "Prohibited";
    case DEVICE_STATE_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

DeviceStateType ParseDeviceStateType(const std::string& enum_string) {
  if (enum_string == "Uninitialized")
    return DEVICE_STATE_TYPE_UNINITIALIZED;
  if (enum_string == "Disabled")
    return DEVICE_STATE_TYPE_DISABLED;
  if (enum_string == "Enabling")
    return DEVICE_STATE_TYPE_ENABLING;
  if (enum_string == "Enabled")
    return DEVICE_STATE_TYPE_ENABLED;
  if (enum_string == "Prohibited")
    return DEVICE_STATE_TYPE_PROHIBITED;
  return DEVICE_STATE_TYPE_NONE;
}


const char* ToString(IPConfigType enum_param) {
  switch (enum_param) {
    case IP_CONFIG_TYPE_DHCP:
      return "DHCP";
    case IP_CONFIG_TYPE_STATIC:
      return "Static";
    case IP_CONFIG_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

IPConfigType ParseIPConfigType(const std::string& enum_string) {
  if (enum_string == "DHCP")
    return IP_CONFIG_TYPE_DHCP;
  if (enum_string == "Static")
    return IP_CONFIG_TYPE_STATIC;
  return IP_CONFIG_TYPE_NONE;
}


const char* ToString(NetworkType enum_param) {
  switch (enum_param) {
    case NETWORK_TYPE_ALL:
      return "All";
    case NETWORK_TYPE_CELLULAR:
      return "Cellular";
    case NETWORK_TYPE_ETHERNET:
      return "Ethernet";
    case NETWORK_TYPE_TETHER:
      return "Tether";
    case NETWORK_TYPE_VPN:
      return "VPN";
    case NETWORK_TYPE_WIRELESS:
      return "Wireless";
    case NETWORK_TYPE_WIFI:
      return "WiFi";
    case NETWORK_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

NetworkType ParseNetworkType(const std::string& enum_string) {
  if (enum_string == "All")
    return NETWORK_TYPE_ALL;
  if (enum_string == "Cellular")
    return NETWORK_TYPE_CELLULAR;
  if (enum_string == "Ethernet")
    return NETWORK_TYPE_ETHERNET;
  if (enum_string == "Tether")
    return NETWORK_TYPE_TETHER;
  if (enum_string == "VPN")
    return NETWORK_TYPE_VPN;
  if (enum_string == "Wireless")
    return NETWORK_TYPE_WIRELESS;
  if (enum_string == "WiFi")
    return NETWORK_TYPE_WIFI;
  return NETWORK_TYPE_NONE;
}


const char* ToString(ProxySettingsType enum_param) {
  switch (enum_param) {
    case PROXY_SETTINGS_TYPE_DIRECT:
      return "Direct";
    case PROXY_SETTINGS_TYPE_MANUAL:
      return "Manual";
    case PROXY_SETTINGS_TYPE_PAC:
      return "PAC";
    case PROXY_SETTINGS_TYPE_WPAD:
      return "WPAD";
    case PROXY_SETTINGS_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ProxySettingsType ParseProxySettingsType(const std::string& enum_string) {
  if (enum_string == "Direct")
    return PROXY_SETTINGS_TYPE_DIRECT;
  if (enum_string == "Manual")
    return PROXY_SETTINGS_TYPE_MANUAL;
  if (enum_string == "PAC")
    return PROXY_SETTINGS_TYPE_PAC;
  if (enum_string == "WPAD")
    return PROXY_SETTINGS_TYPE_WPAD;
  return PROXY_SETTINGS_TYPE_NONE;
}


ManagedBoolean::ManagedBoolean()
 {}

ManagedBoolean::~ManagedBoolean() = default;
ManagedBoolean::ManagedBoolean(ManagedBoolean&& rhs) = default;
ManagedBoolean& ManagedBoolean::operator=(ManagedBoolean&& rhs) = default;
// static
bool ManagedBoolean::Populate(
    const base::Value& value, ManagedBoolean* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* active_value = dict->FindKey("Active");
  if (active_value) {
    {
      auto temp = active_value->GetIfBool();
      if (!temp.has_value()) {
        out->active.reset();
        return false;
      }
      out->active = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* effective_value = dict->FindKey("Effective");
  if (effective_value) {
    {
      auto* temp = effective_value->GetIfString();
      if (!temp) {
        out->effective.reset();
        return false;
      }
      out->effective = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_policy_value = dict->FindKey("UserPolicy");
  if (user_policy_value) {
    {
      auto temp = user_policy_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_policy.reset();
        return false;
      }
      out->user_policy = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_policy_value = dict->FindKey("DevicePolicy");
  if (device_policy_value) {
    {
      auto temp = device_policy_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_policy.reset();
        return false;
      }
      out->device_policy = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* user_setting_value = dict->FindKey("UserSetting");
  if (user_setting_value) {
    {
      auto temp = user_setting_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_setting.reset();
        return false;
      }
      out->user_setting = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* shared_setting_value = dict->FindKey("SharedSetting");
  if (shared_setting_value) {
    {
      auto temp = shared_setting_value->GetIfBool();
      if (!temp.has_value()) {
        out->shared_setting.reset();
        return false;
      }
      out->shared_setting = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* user_editable_value = dict->FindKey("UserEditable");
  if (user_editable_value) {
    {
      auto temp = user_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_editable.reset();
        return false;
      }
      out->user_editable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_editable_value = dict->FindKey("DeviceEditable");
  if (device_editable_value) {
    {
      auto temp = device_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_editable.reset();
        return false;
      }
      out->device_editable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedBoolean> ManagedBoolean::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedBoolean>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedBoolean::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->active.get()) {
    to_value_result->SetWithoutPathExpansion("Active", std::make_unique<base::Value>(*this->active));

  }
  if (this->effective.get()) {
    to_value_result->SetWithoutPathExpansion("Effective", std::make_unique<base::Value>(*this->effective));

  }
  if (this->user_policy.get()) {
    to_value_result->SetWithoutPathExpansion("UserPolicy", std::make_unique<base::Value>(*this->user_policy));

  }
  if (this->device_policy.get()) {
    to_value_result->SetWithoutPathExpansion("DevicePolicy", std::make_unique<base::Value>(*this->device_policy));

  }
  if (this->user_setting.get()) {
    to_value_result->SetWithoutPathExpansion("UserSetting", std::make_unique<base::Value>(*this->user_setting));

  }
  if (this->shared_setting.get()) {
    to_value_result->SetWithoutPathExpansion("SharedSetting", std::make_unique<base::Value>(*this->shared_setting));

  }
  if (this->user_editable.get()) {
    to_value_result->SetWithoutPathExpansion("UserEditable", std::make_unique<base::Value>(*this->user_editable));

  }
  if (this->device_editable.get()) {
    to_value_result->SetWithoutPathExpansion("DeviceEditable", std::make_unique<base::Value>(*this->device_editable));

  }

  return to_value_result;
}


ManagedLong::ManagedLong()
 {}

ManagedLong::~ManagedLong() = default;
ManagedLong::ManagedLong(ManagedLong&& rhs) = default;
ManagedLong& ManagedLong::operator=(ManagedLong&& rhs) = default;
// static
bool ManagedLong::Populate(
    const base::Value& value, ManagedLong* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* active_value = dict->FindKey("Active");
  if (active_value) {
    {
      auto temp = active_value->GetIfInt();
      if (!temp.has_value()) {
        out->active.reset();
        return false;
      }
      out->active = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* effective_value = dict->FindKey("Effective");
  if (effective_value) {
    {
      auto* temp = effective_value->GetIfString();
      if (!temp) {
        out->effective.reset();
        return false;
      }
      out->effective = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_policy_value = dict->FindKey("UserPolicy");
  if (user_policy_value) {
    {
      auto temp = user_policy_value->GetIfInt();
      if (!temp.has_value()) {
        out->user_policy.reset();
        return false;
      }
      out->user_policy = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* device_policy_value = dict->FindKey("DevicePolicy");
  if (device_policy_value) {
    {
      auto temp = device_policy_value->GetIfInt();
      if (!temp.has_value()) {
        out->device_policy.reset();
        return false;
      }
      out->device_policy = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* user_setting_value = dict->FindKey("UserSetting");
  if (user_setting_value) {
    {
      auto temp = user_setting_value->GetIfInt();
      if (!temp.has_value()) {
        out->user_setting.reset();
        return false;
      }
      out->user_setting = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* shared_setting_value = dict->FindKey("SharedSetting");
  if (shared_setting_value) {
    {
      auto temp = shared_setting_value->GetIfInt();
      if (!temp.has_value()) {
        out->shared_setting.reset();
        return false;
      }
      out->shared_setting = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* user_editable_value = dict->FindKey("UserEditable");
  if (user_editable_value) {
    {
      auto temp = user_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_editable.reset();
        return false;
      }
      out->user_editable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_editable_value = dict->FindKey("DeviceEditable");
  if (device_editable_value) {
    {
      auto temp = device_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_editable.reset();
        return false;
      }
      out->device_editable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedLong> ManagedLong::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedLong>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedLong::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->active.get()) {
    to_value_result->SetWithoutPathExpansion("Active", std::make_unique<base::Value>(*this->active));

  }
  if (this->effective.get()) {
    to_value_result->SetWithoutPathExpansion("Effective", std::make_unique<base::Value>(*this->effective));

  }
  if (this->user_policy.get()) {
    to_value_result->SetWithoutPathExpansion("UserPolicy", std::make_unique<base::Value>(*this->user_policy));

  }
  if (this->device_policy.get()) {
    to_value_result->SetWithoutPathExpansion("DevicePolicy", std::make_unique<base::Value>(*this->device_policy));

  }
  if (this->user_setting.get()) {
    to_value_result->SetWithoutPathExpansion("UserSetting", std::make_unique<base::Value>(*this->user_setting));

  }
  if (this->shared_setting.get()) {
    to_value_result->SetWithoutPathExpansion("SharedSetting", std::make_unique<base::Value>(*this->shared_setting));

  }
  if (this->user_editable.get()) {
    to_value_result->SetWithoutPathExpansion("UserEditable", std::make_unique<base::Value>(*this->user_editable));

  }
  if (this->device_editable.get()) {
    to_value_result->SetWithoutPathExpansion("DeviceEditable", std::make_unique<base::Value>(*this->device_editable));

  }

  return to_value_result;
}


ManagedDOMString::ManagedDOMString()
 {}

ManagedDOMString::~ManagedDOMString() = default;
ManagedDOMString::ManagedDOMString(ManagedDOMString&& rhs) = default;
ManagedDOMString& ManagedDOMString::operator=(ManagedDOMString&& rhs) = default;
// static
bool ManagedDOMString::Populate(
    const base::Value& value, ManagedDOMString* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* active_value = dict->FindKey("Active");
  if (active_value) {
    {
      auto* temp = active_value->GetIfString();
      if (!temp) {
        out->active.reset();
        return false;
      }
      out->active = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* effective_value = dict->FindKey("Effective");
  if (effective_value) {
    {
      auto* temp = effective_value->GetIfString();
      if (!temp) {
        out->effective.reset();
        return false;
      }
      out->effective = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_policy_value = dict->FindKey("UserPolicy");
  if (user_policy_value) {
    {
      auto* temp = user_policy_value->GetIfString();
      if (!temp) {
        out->user_policy.reset();
        return false;
      }
      out->user_policy = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* device_policy_value = dict->FindKey("DevicePolicy");
  if (device_policy_value) {
    {
      auto* temp = device_policy_value->GetIfString();
      if (!temp) {
        out->device_policy.reset();
        return false;
      }
      out->device_policy = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_setting_value = dict->FindKey("UserSetting");
  if (user_setting_value) {
    {
      auto* temp = user_setting_value->GetIfString();
      if (!temp) {
        out->user_setting.reset();
        return false;
      }
      out->user_setting = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* shared_setting_value = dict->FindKey("SharedSetting");
  if (shared_setting_value) {
    {
      auto* temp = shared_setting_value->GetIfString();
      if (!temp) {
        out->shared_setting.reset();
        return false;
      }
      out->shared_setting = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_editable_value = dict->FindKey("UserEditable");
  if (user_editable_value) {
    {
      auto temp = user_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_editable.reset();
        return false;
      }
      out->user_editable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_editable_value = dict->FindKey("DeviceEditable");
  if (device_editable_value) {
    {
      auto temp = device_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_editable.reset();
        return false;
      }
      out->device_editable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedDOMString> ManagedDOMString::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedDOMString>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedDOMString::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->active.get()) {
    to_value_result->SetWithoutPathExpansion("Active", std::make_unique<base::Value>(*this->active));

  }
  if (this->effective.get()) {
    to_value_result->SetWithoutPathExpansion("Effective", std::make_unique<base::Value>(*this->effective));

  }
  if (this->user_policy.get()) {
    to_value_result->SetWithoutPathExpansion("UserPolicy", std::make_unique<base::Value>(*this->user_policy));

  }
  if (this->device_policy.get()) {
    to_value_result->SetWithoutPathExpansion("DevicePolicy", std::make_unique<base::Value>(*this->device_policy));

  }
  if (this->user_setting.get()) {
    to_value_result->SetWithoutPathExpansion("UserSetting", std::make_unique<base::Value>(*this->user_setting));

  }
  if (this->shared_setting.get()) {
    to_value_result->SetWithoutPathExpansion("SharedSetting", std::make_unique<base::Value>(*this->shared_setting));

  }
  if (this->user_editable.get()) {
    to_value_result->SetWithoutPathExpansion("UserEditable", std::make_unique<base::Value>(*this->user_editable));

  }
  if (this->device_editable.get()) {
    to_value_result->SetWithoutPathExpansion("DeviceEditable", std::make_unique<base::Value>(*this->device_editable));

  }

  return to_value_result;
}


ManagedDOMStringList::ManagedDOMStringList()
 {}

ManagedDOMStringList::~ManagedDOMStringList() = default;
ManagedDOMStringList::ManagedDOMStringList(ManagedDOMStringList&& rhs) = default;
ManagedDOMStringList& ManagedDOMStringList::operator=(ManagedDOMStringList&& rhs) = default;
// static
bool ManagedDOMStringList::Populate(
    const base::Value& value, ManagedDOMStringList* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* active_value = dict->FindKey("Active");
  if (active_value) {
    {
      const base::ListValue* list = nullptr;
      if (!active_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->active)) {
          return false;
        }
      }
    }
  }

  const base::Value* effective_value = dict->FindKey("Effective");
  if (effective_value) {
    {
      auto* temp = effective_value->GetIfString();
      if (!temp) {
        out->effective.reset();
        return false;
      }
      out->effective = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_policy_value = dict->FindKey("UserPolicy");
  if (user_policy_value) {
    {
      const base::ListValue* list = nullptr;
      if (!user_policy_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->user_policy)) {
          return false;
        }
      }
    }
  }

  const base::Value* device_policy_value = dict->FindKey("DevicePolicy");
  if (device_policy_value) {
    {
      const base::ListValue* list = nullptr;
      if (!device_policy_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->device_policy)) {
          return false;
        }
      }
    }
  }

  const base::Value* user_setting_value = dict->FindKey("UserSetting");
  if (user_setting_value) {
    {
      const base::ListValue* list = nullptr;
      if (!user_setting_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->user_setting)) {
          return false;
        }
      }
    }
  }

  const base::Value* shared_setting_value = dict->FindKey("SharedSetting");
  if (shared_setting_value) {
    {
      const base::ListValue* list = nullptr;
      if (!shared_setting_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->shared_setting)) {
          return false;
        }
      }
    }
  }

  const base::Value* user_editable_value = dict->FindKey("UserEditable");
  if (user_editable_value) {
    {
      auto temp = user_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_editable.reset();
        return false;
      }
      out->user_editable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_editable_value = dict->FindKey("DeviceEditable");
  if (device_editable_value) {
    {
      auto temp = device_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_editable.reset();
        return false;
      }
      out->device_editable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedDOMStringList> ManagedDOMStringList::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedDOMStringList>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedDOMStringList::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->active.get()) {
    to_value_result->SetWithoutPathExpansion("Active", json_schema_compiler::util::CreateValueFromArray(*this->active));

  }
  if (this->effective.get()) {
    to_value_result->SetWithoutPathExpansion("Effective", std::make_unique<base::Value>(*this->effective));

  }
  if (this->user_policy.get()) {
    to_value_result->SetWithoutPathExpansion("UserPolicy", json_schema_compiler::util::CreateValueFromArray(*this->user_policy));

  }
  if (this->device_policy.get()) {
    to_value_result->SetWithoutPathExpansion("DevicePolicy", json_schema_compiler::util::CreateValueFromArray(*this->device_policy));

  }
  if (this->user_setting.get()) {
    to_value_result->SetWithoutPathExpansion("UserSetting", json_schema_compiler::util::CreateValueFromArray(*this->user_setting));

  }
  if (this->shared_setting.get()) {
    to_value_result->SetWithoutPathExpansion("SharedSetting", json_schema_compiler::util::CreateValueFromArray(*this->shared_setting));

  }
  if (this->user_editable.get()) {
    to_value_result->SetWithoutPathExpansion("UserEditable", std::make_unique<base::Value>(*this->user_editable));

  }
  if (this->device_editable.get()) {
    to_value_result->SetWithoutPathExpansion("DeviceEditable", std::make_unique<base::Value>(*this->device_editable));

  }

  return to_value_result;
}


ManagedIPConfigType::ManagedIPConfigType()
: active(IP_CONFIG_TYPE_NONE),
user_policy(IP_CONFIG_TYPE_NONE),
device_policy(IP_CONFIG_TYPE_NONE),
user_setting(IP_CONFIG_TYPE_NONE),
shared_setting(IP_CONFIG_TYPE_NONE) {}

ManagedIPConfigType::~ManagedIPConfigType() = default;
ManagedIPConfigType::ManagedIPConfigType(ManagedIPConfigType&& rhs) = default;
ManagedIPConfigType& ManagedIPConfigType::operator=(ManagedIPConfigType&& rhs) = default;
// static
bool ManagedIPConfigType::Populate(
    const base::Value& value, ManagedIPConfigType* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->active = IP_CONFIG_TYPE_NONE;
  out->user_policy = IP_CONFIG_TYPE_NONE;
  out->device_policy = IP_CONFIG_TYPE_NONE;
  out->user_setting = IP_CONFIG_TYPE_NONE;
  out->shared_setting = IP_CONFIG_TYPE_NONE;
  const base::Value* active_value = dict->FindKey("Active");
  if (active_value) {
    {
      std::string ip_config_type_as_string;
      if (!active_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->active = ParseIPConfigType(ip_config_type_as_string);
      if (out->active == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->active = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* effective_value = dict->FindKey("Effective");
  if (effective_value) {
    {
      auto* temp = effective_value->GetIfString();
      if (!temp) {
        out->effective.reset();
        return false;
      }
      out->effective = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_policy_value = dict->FindKey("UserPolicy");
  if (user_policy_value) {
    {
      std::string ip_config_type_as_string;
      if (!user_policy_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->user_policy = ParseIPConfigType(ip_config_type_as_string);
      if (out->user_policy == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->user_policy = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* device_policy_value = dict->FindKey("DevicePolicy");
  if (device_policy_value) {
    {
      std::string ip_config_type_as_string;
      if (!device_policy_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->device_policy = ParseIPConfigType(ip_config_type_as_string);
      if (out->device_policy == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->device_policy = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* user_setting_value = dict->FindKey("UserSetting");
  if (user_setting_value) {
    {
      std::string ip_config_type_as_string;
      if (!user_setting_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->user_setting = ParseIPConfigType(ip_config_type_as_string);
      if (out->user_setting == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->user_setting = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* shared_setting_value = dict->FindKey("SharedSetting");
  if (shared_setting_value) {
    {
      std::string ip_config_type_as_string;
      if (!shared_setting_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->shared_setting = ParseIPConfigType(ip_config_type_as_string);
      if (out->shared_setting == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->shared_setting = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* user_editable_value = dict->FindKey("UserEditable");
  if (user_editable_value) {
    {
      auto temp = user_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_editable.reset();
        return false;
      }
      out->user_editable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_editable_value = dict->FindKey("DeviceEditable");
  if (device_editable_value) {
    {
      auto temp = device_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_editable.reset();
        return false;
      }
      out->device_editable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedIPConfigType> ManagedIPConfigType::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedIPConfigType>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedIPConfigType::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->active != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("Active", std::make_unique<base::Value>(networking_private::ToString(this->active)));

  }
  if (this->effective.get()) {
    to_value_result->SetWithoutPathExpansion("Effective", std::make_unique<base::Value>(*this->effective));

  }
  if (this->user_policy != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("UserPolicy", std::make_unique<base::Value>(networking_private::ToString(this->user_policy)));

  }
  if (this->device_policy != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("DevicePolicy", std::make_unique<base::Value>(networking_private::ToString(this->device_policy)));

  }
  if (this->user_setting != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("UserSetting", std::make_unique<base::Value>(networking_private::ToString(this->user_setting)));

  }
  if (this->shared_setting != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("SharedSetting", std::make_unique<base::Value>(networking_private::ToString(this->shared_setting)));

  }
  if (this->user_editable.get()) {
    to_value_result->SetWithoutPathExpansion("UserEditable", std::make_unique<base::Value>(*this->user_editable));

  }
  if (this->device_editable.get()) {
    to_value_result->SetWithoutPathExpansion("DeviceEditable", std::make_unique<base::Value>(*this->device_editable));

  }

  return to_value_result;
}


ManagedProxySettingsType::ManagedProxySettingsType()
: active(PROXY_SETTINGS_TYPE_NONE),
user_policy(PROXY_SETTINGS_TYPE_NONE),
device_policy(PROXY_SETTINGS_TYPE_NONE),
user_setting(PROXY_SETTINGS_TYPE_NONE),
shared_setting(PROXY_SETTINGS_TYPE_NONE) {}

ManagedProxySettingsType::~ManagedProxySettingsType() = default;
ManagedProxySettingsType::ManagedProxySettingsType(ManagedProxySettingsType&& rhs) = default;
ManagedProxySettingsType& ManagedProxySettingsType::operator=(ManagedProxySettingsType&& rhs) = default;
// static
bool ManagedProxySettingsType::Populate(
    const base::Value& value, ManagedProxySettingsType* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->active = PROXY_SETTINGS_TYPE_NONE;
  out->user_policy = PROXY_SETTINGS_TYPE_NONE;
  out->device_policy = PROXY_SETTINGS_TYPE_NONE;
  out->user_setting = PROXY_SETTINGS_TYPE_NONE;
  out->shared_setting = PROXY_SETTINGS_TYPE_NONE;
  const base::Value* active_value = dict->FindKey("Active");
  if (active_value) {
    {
      std::string proxy_settings_type_as_string;
      if (!active_value->GetAsString(&proxy_settings_type_as_string)) {
        return false;
      }
      out->active = ParseProxySettingsType(proxy_settings_type_as_string);
      if (out->active == PROXY_SETTINGS_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->active = PROXY_SETTINGS_TYPE_NONE;
  }

  const base::Value* effective_value = dict->FindKey("Effective");
  if (effective_value) {
    {
      auto* temp = effective_value->GetIfString();
      if (!temp) {
        out->effective.reset();
        return false;
      }
      out->effective = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_policy_value = dict->FindKey("UserPolicy");
  if (user_policy_value) {
    {
      std::string proxy_settings_type_as_string;
      if (!user_policy_value->GetAsString(&proxy_settings_type_as_string)) {
        return false;
      }
      out->user_policy = ParseProxySettingsType(proxy_settings_type_as_string);
      if (out->user_policy == PROXY_SETTINGS_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->user_policy = PROXY_SETTINGS_TYPE_NONE;
  }

  const base::Value* device_policy_value = dict->FindKey("DevicePolicy");
  if (device_policy_value) {
    {
      std::string proxy_settings_type_as_string;
      if (!device_policy_value->GetAsString(&proxy_settings_type_as_string)) {
        return false;
      }
      out->device_policy = ParseProxySettingsType(proxy_settings_type_as_string);
      if (out->device_policy == PROXY_SETTINGS_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->device_policy = PROXY_SETTINGS_TYPE_NONE;
  }

  const base::Value* user_setting_value = dict->FindKey("UserSetting");
  if (user_setting_value) {
    {
      std::string proxy_settings_type_as_string;
      if (!user_setting_value->GetAsString(&proxy_settings_type_as_string)) {
        return false;
      }
      out->user_setting = ParseProxySettingsType(proxy_settings_type_as_string);
      if (out->user_setting == PROXY_SETTINGS_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->user_setting = PROXY_SETTINGS_TYPE_NONE;
  }

  const base::Value* shared_setting_value = dict->FindKey("SharedSetting");
  if (shared_setting_value) {
    {
      std::string proxy_settings_type_as_string;
      if (!shared_setting_value->GetAsString(&proxy_settings_type_as_string)) {
        return false;
      }
      out->shared_setting = ParseProxySettingsType(proxy_settings_type_as_string);
      if (out->shared_setting == PROXY_SETTINGS_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->shared_setting = PROXY_SETTINGS_TYPE_NONE;
  }

  const base::Value* user_editable_value = dict->FindKey("UserEditable");
  if (user_editable_value) {
    {
      auto temp = user_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_editable.reset();
        return false;
      }
      out->user_editable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_editable_value = dict->FindKey("DeviceEditable");
  if (device_editable_value) {
    {
      auto temp = device_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_editable.reset();
        return false;
      }
      out->device_editable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedProxySettingsType> ManagedProxySettingsType::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedProxySettingsType>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedProxySettingsType::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->active != PROXY_SETTINGS_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("Active", std::make_unique<base::Value>(networking_private::ToString(this->active)));

  }
  if (this->effective.get()) {
    to_value_result->SetWithoutPathExpansion("Effective", std::make_unique<base::Value>(*this->effective));

  }
  if (this->user_policy != PROXY_SETTINGS_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("UserPolicy", std::make_unique<base::Value>(networking_private::ToString(this->user_policy)));

  }
  if (this->device_policy != PROXY_SETTINGS_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("DevicePolicy", std::make_unique<base::Value>(networking_private::ToString(this->device_policy)));

  }
  if (this->user_setting != PROXY_SETTINGS_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("UserSetting", std::make_unique<base::Value>(networking_private::ToString(this->user_setting)));

  }
  if (this->shared_setting != PROXY_SETTINGS_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("SharedSetting", std::make_unique<base::Value>(networking_private::ToString(this->shared_setting)));

  }
  if (this->user_editable.get()) {
    to_value_result->SetWithoutPathExpansion("UserEditable", std::make_unique<base::Value>(*this->user_editable));

  }
  if (this->device_editable.get()) {
    to_value_result->SetWithoutPathExpansion("DeviceEditable", std::make_unique<base::Value>(*this->device_editable));

  }

  return to_value_result;
}


APNProperties::APNProperties()
 {}

APNProperties::~APNProperties() = default;
APNProperties::APNProperties(APNProperties&& rhs) = default;
APNProperties& APNProperties::operator=(APNProperties&& rhs) = default;
// static
bool APNProperties::Populate(
    const base::Value& value, APNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* access_point_name_value = dict->FindKey("AccessPointName");
  if (!access_point_name_value) {
    return false;
  }
  {
    auto* temp = access_point_name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->access_point_name = *temp;
  }

  const base::Value* authentication_value = dict->FindKey("Authentication");
  if (authentication_value) {
    {
      auto* temp = authentication_value->GetIfString();
      if (!temp) {
        out->authentication.reset();
        return false;
      }
      out->authentication = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* language_value = dict->FindKey("Language");
  if (language_value) {
    {
      auto* temp = language_value->GetIfString();
      if (!temp) {
        out->language.reset();
        return false;
      }
      out->language = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* localized_name_value = dict->FindKey("LocalizedName");
  if (localized_name_value) {
    {
      auto* temp = localized_name_value->GetIfString();
      if (!temp) {
        out->localized_name.reset();
        return false;
      }
      out->localized_name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      auto* temp = password_value->GetIfString();
      if (!temp) {
        out->password.reset();
        return false;
      }
      out->password = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      auto* temp = username_value->GetIfString();
      if (!temp) {
        out->username.reset();
        return false;
      }
      out->username = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<APNProperties> APNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<APNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> APNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("AccessPointName", std::make_unique<base::Value>(this->access_point_name));

  if (this->authentication.get()) {
    to_value_result->SetWithoutPathExpansion("Authentication", std::make_unique<base::Value>(*this->authentication));

  }
  if (this->language.get()) {
    to_value_result->SetWithoutPathExpansion("Language", std::make_unique<base::Value>(*this->language));

  }
  if (this->localized_name.get()) {
    to_value_result->SetWithoutPathExpansion("LocalizedName", std::make_unique<base::Value>(*this->localized_name));

  }
  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", std::make_unique<base::Value>(*this->name));

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", std::make_unique<base::Value>(*this->password));

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", std::make_unique<base::Value>(*this->username));

  }

  return to_value_result;
}


ManagedAPNProperties::ManagedAPNProperties()
 {}

ManagedAPNProperties::~ManagedAPNProperties() = default;
ManagedAPNProperties::ManagedAPNProperties(ManagedAPNProperties&& rhs) = default;
ManagedAPNProperties& ManagedAPNProperties::operator=(ManagedAPNProperties&& rhs) = default;
// static
bool ManagedAPNProperties::Populate(
    const base::Value& value, ManagedAPNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* access_point_name_value = dict->FindKey("AccessPointName");
  if (!access_point_name_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!access_point_name_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ManagedDOMString::Populate(*dictionary, &out->access_point_name)) {
      return false;
    }
  }

  const base::Value* authentication_value = dict->FindKey("Authentication");
  if (authentication_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!authentication_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->authentication = std::move(temp);
      }
    }
  }

  const base::Value* language_value = dict->FindKey("Language");
  if (language_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!language_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->language = std::move(temp);
      }
    }
  }

  const base::Value* localized_name_value = dict->FindKey("LocalizedName");
  if (localized_name_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!localized_name_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->localized_name = std::move(temp);
      }
    }
  }

  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!name_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->name = std::move(temp);
      }
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!password_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->password = std::move(temp);
      }
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!username_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->username = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedAPNProperties> ManagedAPNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedAPNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedAPNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("AccessPointName", (this->access_point_name).ToValue());

  if (this->authentication.get()) {
    to_value_result->SetWithoutPathExpansion("Authentication", (this->authentication)->ToValue());

  }
  if (this->language.get()) {
    to_value_result->SetWithoutPathExpansion("Language", (this->language)->ToValue());

  }
  if (this->localized_name.get()) {
    to_value_result->SetWithoutPathExpansion("LocalizedName", (this->localized_name)->ToValue());

  }
  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", (this->name)->ToValue());

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", (this->password)->ToValue());

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", (this->username)->ToValue());

  }

  return to_value_result;
}


ManagedAPNList::ManagedAPNList()
 {}

ManagedAPNList::~ManagedAPNList() = default;
ManagedAPNList::ManagedAPNList(ManagedAPNList&& rhs) = default;
ManagedAPNList& ManagedAPNList::operator=(ManagedAPNList&& rhs) = default;
// static
bool ManagedAPNList::Populate(
    const base::Value& value, ManagedAPNList* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* active_value = dict->FindKey("Active");
  if (active_value) {
    {
      const base::ListValue* list = nullptr;
      if (!active_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->active)) {
          return false;
        }
      }
    }
  }

  const base::Value* effective_value = dict->FindKey("Effective");
  if (effective_value) {
    {
      auto* temp = effective_value->GetIfString();
      if (!temp) {
        out->effective.reset();
        return false;
      }
      out->effective = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_policy_value = dict->FindKey("UserPolicy");
  if (user_policy_value) {
    {
      const base::ListValue* list = nullptr;
      if (!user_policy_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->user_policy)) {
          return false;
        }
      }
    }
  }

  const base::Value* device_policy_value = dict->FindKey("DevicePolicy");
  if (device_policy_value) {
    {
      const base::ListValue* list = nullptr;
      if (!device_policy_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->device_policy)) {
          return false;
        }
      }
    }
  }

  const base::Value* user_setting_value = dict->FindKey("UserSetting");
  if (user_setting_value) {
    {
      const base::ListValue* list = nullptr;
      if (!user_setting_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->user_setting)) {
          return false;
        }
      }
    }
  }

  const base::Value* shared_setting_value = dict->FindKey("SharedSetting");
  if (shared_setting_value) {
    {
      const base::ListValue* list = nullptr;
      if (!shared_setting_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->shared_setting)) {
          return false;
        }
      }
    }
  }

  const base::Value* user_editable_value = dict->FindKey("UserEditable");
  if (user_editable_value) {
    {
      auto temp = user_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->user_editable.reset();
        return false;
      }
      out->user_editable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* device_editable_value = dict->FindKey("DeviceEditable");
  if (device_editable_value) {
    {
      auto temp = device_editable_value->GetIfBool();
      if (!temp.has_value()) {
        out->device_editable.reset();
        return false;
      }
      out->device_editable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedAPNList> ManagedAPNList::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedAPNList>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedAPNList::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->active.get()) {
    to_value_result->SetWithoutPathExpansion("Active", json_schema_compiler::util::CreateValueFromArray(*this->active));

  }
  if (this->effective.get()) {
    to_value_result->SetWithoutPathExpansion("Effective", std::make_unique<base::Value>(*this->effective));

  }
  if (this->user_policy.get()) {
    to_value_result->SetWithoutPathExpansion("UserPolicy", json_schema_compiler::util::CreateValueFromArray(*this->user_policy));

  }
  if (this->device_policy.get()) {
    to_value_result->SetWithoutPathExpansion("DevicePolicy", json_schema_compiler::util::CreateValueFromArray(*this->device_policy));

  }
  if (this->user_setting.get()) {
    to_value_result->SetWithoutPathExpansion("UserSetting", json_schema_compiler::util::CreateValueFromArray(*this->user_setting));

  }
  if (this->shared_setting.get()) {
    to_value_result->SetWithoutPathExpansion("SharedSetting", json_schema_compiler::util::CreateValueFromArray(*this->shared_setting));

  }
  if (this->user_editable.get()) {
    to_value_result->SetWithoutPathExpansion("UserEditable", std::make_unique<base::Value>(*this->user_editable));

  }
  if (this->device_editable.get()) {
    to_value_result->SetWithoutPathExpansion("DeviceEditable", std::make_unique<base::Value>(*this->device_editable));

  }

  return to_value_result;
}


CellularProviderProperties::CellularProviderProperties()
 {}

CellularProviderProperties::~CellularProviderProperties() = default;
CellularProviderProperties::CellularProviderProperties(CellularProviderProperties&& rhs) = default;
CellularProviderProperties& CellularProviderProperties::operator=(CellularProviderProperties&& rhs) = default;
// static
bool CellularProviderProperties::Populate(
    const base::Value& value, CellularProviderProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* name_value = dict->FindKey("Name");
  if (!name_value) {
    return false;
  }
  {
    auto* temp = name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->name = *temp;
  }

  const base::Value* code_value = dict->FindKey("Code");
  if (!code_value) {
    return false;
  }
  {
    auto* temp = code_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->code = *temp;
  }

  const base::Value* country_value = dict->FindKey("Country");
  if (country_value) {
    {
      auto* temp = country_value->GetIfString();
      if (!temp) {
        out->country.reset();
        return false;
      }
      out->country = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<CellularProviderProperties> CellularProviderProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<CellularProviderProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CellularProviderProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Name", std::make_unique<base::Value>(this->name));

  to_value_result->SetWithoutPathExpansion("Code", std::make_unique<base::Value>(this->code));

  if (this->country.get()) {
    to_value_result->SetWithoutPathExpansion("Country", std::make_unique<base::Value>(*this->country));

  }

  return to_value_result;
}


CellularSimState::CellularSimState()
: require_pin(false) {}

CellularSimState::~CellularSimState() = default;
CellularSimState::CellularSimState(CellularSimState&& rhs) = default;
CellularSimState& CellularSimState::operator=(CellularSimState&& rhs) = default;
// static
bool CellularSimState::Populate(
    const base::Value& value, CellularSimState* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* require_pin_value = dict->FindKey("requirePin");
  if (!require_pin_value) {
    return false;
  }
  {
    auto temp = require_pin_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->require_pin = temp.value();
  }

  const base::Value* current_pin_value = dict->FindKey("currentPin");
  if (!current_pin_value) {
    return false;
  }
  {
    auto* temp = current_pin_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->current_pin = *temp;
  }

  const base::Value* new_pin_value = dict->FindKey("newPin");
  if (new_pin_value) {
    {
      auto* temp = new_pin_value->GetIfString();
      if (!temp) {
        out->new_pin.reset();
        return false;
      }
      out->new_pin = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<CellularSimState> CellularSimState::FromValue(const base::Value& value) {
  auto out = std::make_unique<CellularSimState>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CellularSimState::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("requirePin", std::make_unique<base::Value>(this->require_pin));

  to_value_result->SetWithoutPathExpansion("currentPin", std::make_unique<base::Value>(this->current_pin));

  if (this->new_pin.get()) {
    to_value_result->SetWithoutPathExpansion("newPin", std::make_unique<base::Value>(*this->new_pin));

  }

  return to_value_result;
}


IssuerSubjectPattern::IssuerSubjectPattern()
 {}

IssuerSubjectPattern::~IssuerSubjectPattern() = default;
IssuerSubjectPattern::IssuerSubjectPattern(IssuerSubjectPattern&& rhs) = default;
IssuerSubjectPattern& IssuerSubjectPattern::operator=(IssuerSubjectPattern&& rhs) = default;
// static
bool IssuerSubjectPattern::Populate(
    const base::Value& value, IssuerSubjectPattern* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* common_name_value = dict->FindKey("CommonName");
  if (common_name_value) {
    {
      auto* temp = common_name_value->GetIfString();
      if (!temp) {
        out->common_name.reset();
        return false;
      }
      out->common_name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* locality_value = dict->FindKey("Locality");
  if (locality_value) {
    {
      auto* temp = locality_value->GetIfString();
      if (!temp) {
        out->locality.reset();
        return false;
      }
      out->locality = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* organization_value = dict->FindKey("Organization");
  if (organization_value) {
    {
      auto* temp = organization_value->GetIfString();
      if (!temp) {
        out->organization.reset();
        return false;
      }
      out->organization = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* organizational_unit_value = dict->FindKey("OrganizationalUnit");
  if (organizational_unit_value) {
    {
      auto* temp = organizational_unit_value->GetIfString();
      if (!temp) {
        out->organizational_unit.reset();
        return false;
      }
      out->organizational_unit = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<IssuerSubjectPattern> IssuerSubjectPattern::FromValue(const base::Value& value) {
  auto out = std::make_unique<IssuerSubjectPattern>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> IssuerSubjectPattern::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->common_name.get()) {
    to_value_result->SetWithoutPathExpansion("CommonName", std::make_unique<base::Value>(*this->common_name));

  }
  if (this->locality.get()) {
    to_value_result->SetWithoutPathExpansion("Locality", std::make_unique<base::Value>(*this->locality));

  }
  if (this->organization.get()) {
    to_value_result->SetWithoutPathExpansion("Organization", std::make_unique<base::Value>(*this->organization));

  }
  if (this->organizational_unit.get()) {
    to_value_result->SetWithoutPathExpansion("OrganizationalUnit", std::make_unique<base::Value>(*this->organizational_unit));

  }

  return to_value_result;
}


ManagedIssuerSubjectPattern::ManagedIssuerSubjectPattern()
 {}

ManagedIssuerSubjectPattern::~ManagedIssuerSubjectPattern() = default;
ManagedIssuerSubjectPattern::ManagedIssuerSubjectPattern(ManagedIssuerSubjectPattern&& rhs) = default;
ManagedIssuerSubjectPattern& ManagedIssuerSubjectPattern::operator=(ManagedIssuerSubjectPattern&& rhs) = default;
// static
bool ManagedIssuerSubjectPattern::Populate(
    const base::Value& value, ManagedIssuerSubjectPattern* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* common_name_value = dict->FindKey("CommonName");
  if (common_name_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!common_name_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->common_name = std::move(temp);
      }
    }
  }

  const base::Value* locality_value = dict->FindKey("Locality");
  if (locality_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!locality_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->locality = std::move(temp);
      }
    }
  }

  const base::Value* organization_value = dict->FindKey("Organization");
  if (organization_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!organization_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->organization = std::move(temp);
      }
    }
  }

  const base::Value* organizational_unit_value = dict->FindKey("OrganizationalUnit");
  if (organizational_unit_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!organizational_unit_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->organizational_unit = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedIssuerSubjectPattern> ManagedIssuerSubjectPattern::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedIssuerSubjectPattern>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedIssuerSubjectPattern::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->common_name.get()) {
    to_value_result->SetWithoutPathExpansion("CommonName", (this->common_name)->ToValue());

  }
  if (this->locality.get()) {
    to_value_result->SetWithoutPathExpansion("Locality", (this->locality)->ToValue());

  }
  if (this->organization.get()) {
    to_value_result->SetWithoutPathExpansion("Organization", (this->organization)->ToValue());

  }
  if (this->organizational_unit.get()) {
    to_value_result->SetWithoutPathExpansion("OrganizationalUnit", (this->organizational_unit)->ToValue());

  }

  return to_value_result;
}


CertificatePattern::CertificatePattern()
 {}

CertificatePattern::~CertificatePattern() = default;
CertificatePattern::CertificatePattern(CertificatePattern&& rhs) = default;
CertificatePattern& CertificatePattern::operator=(CertificatePattern&& rhs) = default;
// static
bool CertificatePattern::Populate(
    const base::Value& value, CertificatePattern* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* enrollment_uri_value = dict->FindKey("EnrollmentURI");
  if (enrollment_uri_value) {
    {
      const base::ListValue* list = nullptr;
      if (!enrollment_uri_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->enrollment_uri)) {
          return false;
        }
      }
    }
  }

  const base::Value* issuer_value = dict->FindKey("Issuer");
  if (issuer_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!issuer_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IssuerSubjectPattern>();
        if (!IssuerSubjectPattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->issuer = std::move(temp);
      }
    }
  }

  const base::Value* issuer_cape_ms_value = dict->FindKey("IssuerCAPEMs");
  if (issuer_cape_ms_value) {
    {
      const base::ListValue* list = nullptr;
      if (!issuer_cape_ms_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->issuer_cape_ms)) {
          return false;
        }
      }
    }
  }

  const base::Value* issuer_ca_ref_value = dict->FindKey("IssuerCARef");
  if (issuer_ca_ref_value) {
    {
      const base::ListValue* list = nullptr;
      if (!issuer_ca_ref_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->issuer_ca_ref)) {
          return false;
        }
      }
    }
  }

  const base::Value* subject_value = dict->FindKey("Subject");
  if (subject_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!subject_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IssuerSubjectPattern>();
        if (!IssuerSubjectPattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->subject = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<CertificatePattern> CertificatePattern::FromValue(const base::Value& value) {
  auto out = std::make_unique<CertificatePattern>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CertificatePattern::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->enrollment_uri.get()) {
    to_value_result->SetWithoutPathExpansion("EnrollmentURI", json_schema_compiler::util::CreateValueFromArray(*this->enrollment_uri));

  }
  if (this->issuer.get()) {
    to_value_result->SetWithoutPathExpansion("Issuer", (this->issuer)->ToValue());

  }
  if (this->issuer_cape_ms.get()) {
    to_value_result->SetWithoutPathExpansion("IssuerCAPEMs", json_schema_compiler::util::CreateValueFromArray(*this->issuer_cape_ms));

  }
  if (this->issuer_ca_ref.get()) {
    to_value_result->SetWithoutPathExpansion("IssuerCARef", json_schema_compiler::util::CreateValueFromArray(*this->issuer_ca_ref));

  }
  if (this->subject.get()) {
    to_value_result->SetWithoutPathExpansion("Subject", (this->subject)->ToValue());

  }

  return to_value_result;
}


ManagedCertificatePattern::ManagedCertificatePattern()
 {}

ManagedCertificatePattern::~ManagedCertificatePattern() = default;
ManagedCertificatePattern::ManagedCertificatePattern(ManagedCertificatePattern&& rhs) = default;
ManagedCertificatePattern& ManagedCertificatePattern::operator=(ManagedCertificatePattern&& rhs) = default;
// static
bool ManagedCertificatePattern::Populate(
    const base::Value& value, ManagedCertificatePattern* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* enrollment_uri_value = dict->FindKey("EnrollmentURI");
  if (enrollment_uri_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!enrollment_uri_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->enrollment_uri = std::move(temp);
      }
    }
  }

  const base::Value* issuer_value = dict->FindKey("Issuer");
  if (issuer_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!issuer_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedIssuerSubjectPattern>();
        if (!ManagedIssuerSubjectPattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->issuer = std::move(temp);
      }
    }
  }

  const base::Value* issuer_ca_ref_value = dict->FindKey("IssuerCARef");
  if (issuer_ca_ref_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!issuer_ca_ref_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->issuer_ca_ref = std::move(temp);
      }
    }
  }

  const base::Value* subject_value = dict->FindKey("Subject");
  if (subject_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!subject_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedIssuerSubjectPattern>();
        if (!ManagedIssuerSubjectPattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->subject = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedCertificatePattern> ManagedCertificatePattern::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedCertificatePattern>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedCertificatePattern::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->enrollment_uri.get()) {
    to_value_result->SetWithoutPathExpansion("EnrollmentURI", (this->enrollment_uri)->ToValue());

  }
  if (this->issuer.get()) {
    to_value_result->SetWithoutPathExpansion("Issuer", (this->issuer)->ToValue());

  }
  if (this->issuer_ca_ref.get()) {
    to_value_result->SetWithoutPathExpansion("IssuerCARef", (this->issuer_ca_ref)->ToValue());

  }
  if (this->subject.get()) {
    to_value_result->SetWithoutPathExpansion("Subject", (this->subject)->ToValue());

  }

  return to_value_result;
}


EAPProperties::EAPProperties()
 {}

EAPProperties::~EAPProperties() = default;
EAPProperties::EAPProperties(EAPProperties&& rhs) = default;
EAPProperties& EAPProperties::operator=(EAPProperties&& rhs) = default;
// static
bool EAPProperties::Populate(
    const base::Value& value, EAPProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* anonymous_identity_value = dict->FindKey("AnonymousIdentity");
  if (anonymous_identity_value) {
    {
      auto* temp = anonymous_identity_value->GetIfString();
      if (!temp) {
        out->anonymous_identity.reset();
        return false;
      }
      out->anonymous_identity = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_pattern_value = dict->FindKey("ClientCertPattern");
  if (client_cert_pattern_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pattern_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CertificatePattern>();
        if (!CertificatePattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pattern = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_pkcs11_id_value = dict->FindKey("ClientCertPKCS11Id");
  if (client_cert_pkcs11_id_value) {
    {
      auto* temp = client_cert_pkcs11_id_value->GetIfString();
      if (!temp) {
        out->client_cert_pkcs11_id.reset();
        return false;
      }
      out->client_cert_pkcs11_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_provisioning_profile_id_value = dict->FindKey("ClientCertProvisioningProfileId");
  if (client_cert_provisioning_profile_id_value) {
    {
      auto* temp = client_cert_provisioning_profile_id_value->GetIfString();
      if (!temp) {
        out->client_cert_provisioning_profile_id.reset();
        return false;
      }
      out->client_cert_provisioning_profile_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_ref_value = dict->FindKey("ClientCertRef");
  if (client_cert_ref_value) {
    {
      auto* temp = client_cert_ref_value->GetIfString();
      if (!temp) {
        out->client_cert_ref.reset();
        return false;
      }
      out->client_cert_ref = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_type_value = dict->FindKey("ClientCertType");
  if (client_cert_type_value) {
    {
      auto* temp = client_cert_type_value->GetIfString();
      if (!temp) {
        out->client_cert_type.reset();
        return false;
      }
      out->client_cert_type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* identity_value = dict->FindKey("Identity");
  if (identity_value) {
    {
      auto* temp = identity_value->GetIfString();
      if (!temp) {
        out->identity.reset();
        return false;
      }
      out->identity = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* inner_value = dict->FindKey("Inner");
  if (inner_value) {
    {
      auto* temp = inner_value->GetIfString();
      if (!temp) {
        out->inner.reset();
        return false;
      }
      out->inner = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* outer_value = dict->FindKey("Outer");
  if (outer_value) {
    {
      auto* temp = outer_value->GetIfString();
      if (!temp) {
        out->outer.reset();
        return false;
      }
      out->outer = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      auto* temp = password_value->GetIfString();
      if (!temp) {
        out->password.reset();
        return false;
      }
      out->password = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      auto temp = save_credentials_value->GetIfBool();
      if (!temp.has_value()) {
        out->save_credentials.reset();
        return false;
      }
      out->save_credentials = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* server_cape_ms_value = dict->FindKey("ServerCAPEMs");
  if (server_cape_ms_value) {
    {
      const base::ListValue* list = nullptr;
      if (!server_cape_ms_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->server_cape_ms)) {
          return false;
        }
      }
    }
  }

  const base::Value* server_ca_refs_value = dict->FindKey("ServerCARefs");
  if (server_ca_refs_value) {
    {
      const base::ListValue* list = nullptr;
      if (!server_ca_refs_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->server_ca_refs)) {
          return false;
        }
      }
    }
  }

  const base::Value* subject_match_value = dict->FindKey("SubjectMatch");
  if (subject_match_value) {
    {
      auto* temp = subject_match_value->GetIfString();
      if (!temp) {
        out->subject_match.reset();
        return false;
      }
      out->subject_match = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tls_version_max_value = dict->FindKey("TLSVersionMax");
  if (tls_version_max_value) {
    {
      auto* temp = tls_version_max_value->GetIfString();
      if (!temp) {
        out->tls_version_max.reset();
        return false;
      }
      out->tls_version_max = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* use_proactive_key_caching_value = dict->FindKey("UseProactiveKeyCaching");
  if (use_proactive_key_caching_value) {
    {
      auto temp = use_proactive_key_caching_value->GetIfBool();
      if (!temp.has_value()) {
        out->use_proactive_key_caching.reset();
        return false;
      }
      out->use_proactive_key_caching = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* use_system_c_as_value = dict->FindKey("UseSystemCAs");
  if (use_system_c_as_value) {
    {
      auto temp = use_system_c_as_value->GetIfBool();
      if (!temp.has_value()) {
        out->use_system_c_as.reset();
        return false;
      }
      out->use_system_c_as = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<EAPProperties> EAPProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<EAPProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EAPProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->anonymous_identity.get()) {
    to_value_result->SetWithoutPathExpansion("AnonymousIdentity", std::make_unique<base::Value>(*this->anonymous_identity));

  }
  if (this->client_cert_pattern.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPattern", (this->client_cert_pattern)->ToValue());

  }
  if (this->client_cert_pkcs11_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPKCS11Id", std::make_unique<base::Value>(*this->client_cert_pkcs11_id));

  }
  if (this->client_cert_provisioning_profile_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertProvisioningProfileId", std::make_unique<base::Value>(*this->client_cert_provisioning_profile_id));

  }
  if (this->client_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertRef", std::make_unique<base::Value>(*this->client_cert_ref));

  }
  if (this->client_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertType", std::make_unique<base::Value>(*this->client_cert_type));

  }
  if (this->identity.get()) {
    to_value_result->SetWithoutPathExpansion("Identity", std::make_unique<base::Value>(*this->identity));

  }
  if (this->inner.get()) {
    to_value_result->SetWithoutPathExpansion("Inner", std::make_unique<base::Value>(*this->inner));

  }
  if (this->outer.get()) {
    to_value_result->SetWithoutPathExpansion("Outer", std::make_unique<base::Value>(*this->outer));

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", std::make_unique<base::Value>(*this->password));

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", std::make_unique<base::Value>(*this->save_credentials));

  }
  if (this->server_cape_ms.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCAPEMs", json_schema_compiler::util::CreateValueFromArray(*this->server_cape_ms));

  }
  if (this->server_ca_refs.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCARefs", json_schema_compiler::util::CreateValueFromArray(*this->server_ca_refs));

  }
  if (this->subject_match.get()) {
    to_value_result->SetWithoutPathExpansion("SubjectMatch", std::make_unique<base::Value>(*this->subject_match));

  }
  if (this->tls_version_max.get()) {
    to_value_result->SetWithoutPathExpansion("TLSVersionMax", std::make_unique<base::Value>(*this->tls_version_max));

  }
  if (this->use_proactive_key_caching.get()) {
    to_value_result->SetWithoutPathExpansion("UseProactiveKeyCaching", std::make_unique<base::Value>(*this->use_proactive_key_caching));

  }
  if (this->use_system_c_as.get()) {
    to_value_result->SetWithoutPathExpansion("UseSystemCAs", std::make_unique<base::Value>(*this->use_system_c_as));

  }

  return to_value_result;
}


ManagedEAPProperties::ManagedEAPProperties()
 {}

ManagedEAPProperties::~ManagedEAPProperties() = default;
ManagedEAPProperties::ManagedEAPProperties(ManagedEAPProperties&& rhs) = default;
ManagedEAPProperties& ManagedEAPProperties::operator=(ManagedEAPProperties&& rhs) = default;
// static
bool ManagedEAPProperties::Populate(
    const base::Value& value, ManagedEAPProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* anonymous_identity_value = dict->FindKey("AnonymousIdentity");
  if (anonymous_identity_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!anonymous_identity_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->anonymous_identity = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_pattern_value = dict->FindKey("ClientCertPattern");
  if (client_cert_pattern_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pattern_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedCertificatePattern>();
        if (!ManagedCertificatePattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pattern = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_pkcs11_id_value = dict->FindKey("ClientCertPKCS11Id");
  if (client_cert_pkcs11_id_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pkcs11_id_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pkcs11_id = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_provisioning_profile_id_value = dict->FindKey("ClientCertProvisioningProfileId");
  if (client_cert_provisioning_profile_id_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_provisioning_profile_id_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_provisioning_profile_id = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_ref_value = dict->FindKey("ClientCertRef");
  if (client_cert_ref_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_ref_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_ref = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_type_value = dict->FindKey("ClientCertType");
  if (client_cert_type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_type = std::move(temp);
      }
    }
  }

  const base::Value* identity_value = dict->FindKey("Identity");
  if (identity_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!identity_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->identity = std::move(temp);
      }
    }
  }

  const base::Value* inner_value = dict->FindKey("Inner");
  if (inner_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!inner_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->inner = std::move(temp);
      }
    }
  }

  const base::Value* outer_value = dict->FindKey("Outer");
  if (outer_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!outer_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->outer = std::move(temp);
      }
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!password_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->password = std::move(temp);
      }
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!save_credentials_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->save_credentials = std::move(temp);
      }
    }
  }

  const base::Value* server_cape_ms_value = dict->FindKey("ServerCAPEMs");
  if (server_cape_ms_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_cape_ms_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_cape_ms = std::move(temp);
      }
    }
  }

  const base::Value* server_ca_refs_value = dict->FindKey("ServerCARefs");
  if (server_ca_refs_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_ca_refs_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_ca_refs = std::move(temp);
      }
    }
  }

  const base::Value* subject_match_value = dict->FindKey("SubjectMatch");
  if (subject_match_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!subject_match_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->subject_match = std::move(temp);
      }
    }
  }

  const base::Value* tls_version_max_value = dict->FindKey("TLSVersionMax");
  if (tls_version_max_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tls_version_max_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tls_version_max = std::move(temp);
      }
    }
  }

  const base::Value* use_proactive_key_caching_value = dict->FindKey("UseProactiveKeyCaching");
  if (use_proactive_key_caching_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!use_proactive_key_caching_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->use_proactive_key_caching = std::move(temp);
      }
    }
  }

  const base::Value* use_system_c_as_value = dict->FindKey("UseSystemCAs");
  if (use_system_c_as_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!use_system_c_as_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->use_system_c_as = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedEAPProperties> ManagedEAPProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedEAPProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedEAPProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->anonymous_identity.get()) {
    to_value_result->SetWithoutPathExpansion("AnonymousIdentity", (this->anonymous_identity)->ToValue());

  }
  if (this->client_cert_pattern.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPattern", (this->client_cert_pattern)->ToValue());

  }
  if (this->client_cert_pkcs11_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPKCS11Id", (this->client_cert_pkcs11_id)->ToValue());

  }
  if (this->client_cert_provisioning_profile_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertProvisioningProfileId", (this->client_cert_provisioning_profile_id)->ToValue());

  }
  if (this->client_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertRef", (this->client_cert_ref)->ToValue());

  }
  if (this->client_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertType", (this->client_cert_type)->ToValue());

  }
  if (this->identity.get()) {
    to_value_result->SetWithoutPathExpansion("Identity", (this->identity)->ToValue());

  }
  if (this->inner.get()) {
    to_value_result->SetWithoutPathExpansion("Inner", (this->inner)->ToValue());

  }
  if (this->outer.get()) {
    to_value_result->SetWithoutPathExpansion("Outer", (this->outer)->ToValue());

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", (this->password)->ToValue());

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", (this->save_credentials)->ToValue());

  }
  if (this->server_cape_ms.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCAPEMs", (this->server_cape_ms)->ToValue());

  }
  if (this->server_ca_refs.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCARefs", (this->server_ca_refs)->ToValue());

  }
  if (this->subject_match.get()) {
    to_value_result->SetWithoutPathExpansion("SubjectMatch", (this->subject_match)->ToValue());

  }
  if (this->tls_version_max.get()) {
    to_value_result->SetWithoutPathExpansion("TLSVersionMax", (this->tls_version_max)->ToValue());

  }
  if (this->use_proactive_key_caching.get()) {
    to_value_result->SetWithoutPathExpansion("UseProactiveKeyCaching", (this->use_proactive_key_caching)->ToValue());

  }
  if (this->use_system_c_as.get()) {
    to_value_result->SetWithoutPathExpansion("UseSystemCAs", (this->use_system_c_as)->ToValue());

  }

  return to_value_result;
}


FoundNetworkProperties::FoundNetworkProperties()
 {}

FoundNetworkProperties::~FoundNetworkProperties() = default;
FoundNetworkProperties::FoundNetworkProperties(FoundNetworkProperties&& rhs) = default;
FoundNetworkProperties& FoundNetworkProperties::operator=(FoundNetworkProperties&& rhs) = default;
// static
bool FoundNetworkProperties::Populate(
    const base::Value& value, FoundNetworkProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* status_value = dict->FindKey("Status");
  if (!status_value) {
    return false;
  }
  {
    auto* temp = status_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->status = *temp;
  }

  const base::Value* network_id_value = dict->FindKey("NetworkId");
  if (!network_id_value) {
    return false;
  }
  {
    auto* temp = network_id_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->network_id = *temp;
  }

  const base::Value* technology_value = dict->FindKey("Technology");
  if (!technology_value) {
    return false;
  }
  {
    auto* temp = technology_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->technology = *temp;
  }

  const base::Value* short_name_value = dict->FindKey("ShortName");
  if (short_name_value) {
    {
      auto* temp = short_name_value->GetIfString();
      if (!temp) {
        out->short_name.reset();
        return false;
      }
      out->short_name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* long_name_value = dict->FindKey("LongName");
  if (long_name_value) {
    {
      auto* temp = long_name_value->GetIfString();
      if (!temp) {
        out->long_name.reset();
        return false;
      }
      out->long_name = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<FoundNetworkProperties> FoundNetworkProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<FoundNetworkProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> FoundNetworkProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Status", std::make_unique<base::Value>(this->status));

  to_value_result->SetWithoutPathExpansion("NetworkId", std::make_unique<base::Value>(this->network_id));

  to_value_result->SetWithoutPathExpansion("Technology", std::make_unique<base::Value>(this->technology));

  if (this->short_name.get()) {
    to_value_result->SetWithoutPathExpansion("ShortName", std::make_unique<base::Value>(*this->short_name));

  }
  if (this->long_name.get()) {
    to_value_result->SetWithoutPathExpansion("LongName", std::make_unique<base::Value>(*this->long_name));

  }

  return to_value_result;
}


IPConfigProperties::IPConfigProperties()
 {}

IPConfigProperties::~IPConfigProperties() = default;
IPConfigProperties::IPConfigProperties(IPConfigProperties&& rhs) = default;
IPConfigProperties& IPConfigProperties::operator=(IPConfigProperties&& rhs) = default;
// static
bool IPConfigProperties::Populate(
    const base::Value& value, IPConfigProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* gateway_value = dict->FindKey("Gateway");
  if (gateway_value) {
    {
      auto* temp = gateway_value->GetIfString();
      if (!temp) {
        out->gateway.reset();
        return false;
      }
      out->gateway = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* ip_address_value = dict->FindKey("IPAddress");
  if (ip_address_value) {
    {
      auto* temp = ip_address_value->GetIfString();
      if (!temp) {
        out->ip_address.reset();
        return false;
      }
      out->ip_address = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* excluded_routes_value = dict->FindKey("ExcludedRoutes");
  if (excluded_routes_value) {
    {
      const base::ListValue* list = nullptr;
      if (!excluded_routes_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->excluded_routes)) {
          return false;
        }
      }
    }
  }

  const base::Value* included_routes_value = dict->FindKey("IncludedRoutes");
  if (included_routes_value) {
    {
      const base::ListValue* list = nullptr;
      if (!included_routes_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->included_routes)) {
          return false;
        }
      }
    }
  }

  const base::Value* name_servers_value = dict->FindKey("NameServers");
  if (name_servers_value) {
    {
      const base::ListValue* list = nullptr;
      if (!name_servers_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->name_servers)) {
          return false;
        }
      }
    }
  }

  const base::Value* search_domains_value = dict->FindKey("SearchDomains");
  if (search_domains_value) {
    {
      const base::ListValue* list = nullptr;
      if (!search_domains_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->search_domains)) {
          return false;
        }
      }
    }
  }

  const base::Value* routing_prefix_value = dict->FindKey("RoutingPrefix");
  if (routing_prefix_value) {
    {
      auto temp = routing_prefix_value->GetIfInt();
      if (!temp.has_value()) {
        out->routing_prefix.reset();
        return false;
      }
      out->routing_prefix = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (type_value) {
    {
      auto* temp = type_value->GetIfString();
      if (!temp) {
        out->type.reset();
        return false;
      }
      out->type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* web_proxy_auto_discovery_url_value = dict->FindKey("WebProxyAutoDiscoveryUrl");
  if (web_proxy_auto_discovery_url_value) {
    {
      auto* temp = web_proxy_auto_discovery_url_value->GetIfString();
      if (!temp) {
        out->web_proxy_auto_discovery_url.reset();
        return false;
      }
      out->web_proxy_auto_discovery_url = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<IPConfigProperties> IPConfigProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<IPConfigProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> IPConfigProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->gateway.get()) {
    to_value_result->SetWithoutPathExpansion("Gateway", std::make_unique<base::Value>(*this->gateway));

  }
  if (this->ip_address.get()) {
    to_value_result->SetWithoutPathExpansion("IPAddress", std::make_unique<base::Value>(*this->ip_address));

  }
  if (this->excluded_routes.get()) {
    to_value_result->SetWithoutPathExpansion("ExcludedRoutes", json_schema_compiler::util::CreateValueFromArray(*this->excluded_routes));

  }
  if (this->included_routes.get()) {
    to_value_result->SetWithoutPathExpansion("IncludedRoutes", json_schema_compiler::util::CreateValueFromArray(*this->included_routes));

  }
  if (this->name_servers.get()) {
    to_value_result->SetWithoutPathExpansion("NameServers", json_schema_compiler::util::CreateValueFromArray(*this->name_servers));

  }
  if (this->search_domains.get()) {
    to_value_result->SetWithoutPathExpansion("SearchDomains", json_schema_compiler::util::CreateValueFromArray(*this->search_domains));

  }
  if (this->routing_prefix.get()) {
    to_value_result->SetWithoutPathExpansion("RoutingPrefix", std::make_unique<base::Value>(*this->routing_prefix));

  }
  if (this->type.get()) {
    to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(*this->type));

  }
  if (this->web_proxy_auto_discovery_url.get()) {
    to_value_result->SetWithoutPathExpansion("WebProxyAutoDiscoveryUrl", std::make_unique<base::Value>(*this->web_proxy_auto_discovery_url));

  }

  return to_value_result;
}


ManagedIPConfigProperties::ManagedIPConfigProperties()
 {}

ManagedIPConfigProperties::~ManagedIPConfigProperties() = default;
ManagedIPConfigProperties::ManagedIPConfigProperties(ManagedIPConfigProperties&& rhs) = default;
ManagedIPConfigProperties& ManagedIPConfigProperties::operator=(ManagedIPConfigProperties&& rhs) = default;
// static
bool ManagedIPConfigProperties::Populate(
    const base::Value& value, ManagedIPConfigProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* gateway_value = dict->FindKey("Gateway");
  if (gateway_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!gateway_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->gateway = std::move(temp);
      }
    }
  }

  const base::Value* ip_address_value = dict->FindKey("IPAddress");
  if (ip_address_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ip_address_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ip_address = std::move(temp);
      }
    }
  }

  const base::Value* name_servers_value = dict->FindKey("NameServers");
  if (name_servers_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!name_servers_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->name_servers = std::move(temp);
      }
    }
  }

  const base::Value* routing_prefix_value = dict->FindKey("RoutingPrefix");
  if (routing_prefix_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!routing_prefix_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedLong>();
        if (!ManagedLong::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->routing_prefix = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->type = std::move(temp);
      }
    }
  }

  const base::Value* web_proxy_auto_discovery_url_value = dict->FindKey("WebProxyAutoDiscoveryUrl");
  if (web_proxy_auto_discovery_url_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!web_proxy_auto_discovery_url_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->web_proxy_auto_discovery_url = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedIPConfigProperties> ManagedIPConfigProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedIPConfigProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedIPConfigProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->gateway.get()) {
    to_value_result->SetWithoutPathExpansion("Gateway", (this->gateway)->ToValue());

  }
  if (this->ip_address.get()) {
    to_value_result->SetWithoutPathExpansion("IPAddress", (this->ip_address)->ToValue());

  }
  if (this->name_servers.get()) {
    to_value_result->SetWithoutPathExpansion("NameServers", (this->name_servers)->ToValue());

  }
  if (this->routing_prefix.get()) {
    to_value_result->SetWithoutPathExpansion("RoutingPrefix", (this->routing_prefix)->ToValue());

  }
  if (this->type.get()) {
    to_value_result->SetWithoutPathExpansion("Type", (this->type)->ToValue());

  }
  if (this->web_proxy_auto_discovery_url.get()) {
    to_value_result->SetWithoutPathExpansion("WebProxyAutoDiscoveryUrl", (this->web_proxy_auto_discovery_url)->ToValue());

  }

  return to_value_result;
}


XAUTHProperties::XAUTHProperties()
 {}

XAUTHProperties::~XAUTHProperties() = default;
XAUTHProperties::XAUTHProperties(XAUTHProperties&& rhs) = default;
XAUTHProperties& XAUTHProperties::operator=(XAUTHProperties&& rhs) = default;
// static
bool XAUTHProperties::Populate(
    const base::Value& value, XAUTHProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      auto* temp = password_value->GetIfString();
      if (!temp) {
        out->password.reset();
        return false;
      }
      out->password = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      auto temp = save_credentials_value->GetIfBool();
      if (!temp.has_value()) {
        out->save_credentials.reset();
        return false;
      }
      out->save_credentials = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      auto* temp = username_value->GetIfString();
      if (!temp) {
        out->username.reset();
        return false;
      }
      out->username = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<XAUTHProperties> XAUTHProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<XAUTHProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> XAUTHProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", std::make_unique<base::Value>(*this->password));

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", std::make_unique<base::Value>(*this->save_credentials));

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", std::make_unique<base::Value>(*this->username));

  }

  return to_value_result;
}


ManagedXAUTHProperties::ManagedXAUTHProperties()
 {}

ManagedXAUTHProperties::~ManagedXAUTHProperties() = default;
ManagedXAUTHProperties::ManagedXAUTHProperties(ManagedXAUTHProperties&& rhs) = default;
ManagedXAUTHProperties& ManagedXAUTHProperties::operator=(ManagedXAUTHProperties&& rhs) = default;
// static
bool ManagedXAUTHProperties::Populate(
    const base::Value& value, ManagedXAUTHProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!password_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->password = std::move(temp);
      }
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!save_credentials_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->save_credentials = std::move(temp);
      }
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!username_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->username = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedXAUTHProperties> ManagedXAUTHProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedXAUTHProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedXAUTHProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", (this->password)->ToValue());

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", (this->save_credentials)->ToValue());

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", (this->username)->ToValue());

  }

  return to_value_result;
}


IPSecProperties::IPSecProperties()
 {}

IPSecProperties::~IPSecProperties() = default;
IPSecProperties::IPSecProperties(IPSecProperties&& rhs) = default;
IPSecProperties& IPSecProperties::operator=(IPSecProperties&& rhs) = default;
// static
bool IPSecProperties::Populate(
    const base::Value& value, IPSecProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* authentication_type_value = dict->FindKey("AuthenticationType");
  if (!authentication_type_value) {
    return false;
  }
  {
    auto* temp = authentication_type_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->authentication_type = *temp;
  }

  const base::Value* client_cert_pattern_value = dict->FindKey("ClientCertPattern");
  if (client_cert_pattern_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pattern_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CertificatePattern>();
        if (!CertificatePattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pattern = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_pkcs11_id_value = dict->FindKey("ClientCertPKCS11Id");
  if (client_cert_pkcs11_id_value) {
    {
      auto* temp = client_cert_pkcs11_id_value->GetIfString();
      if (!temp) {
        out->client_cert_pkcs11_id.reset();
        return false;
      }
      out->client_cert_pkcs11_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_provisioning_profile_id_value = dict->FindKey("ClientCertProvisioningProfileId");
  if (client_cert_provisioning_profile_id_value) {
    {
      auto* temp = client_cert_provisioning_profile_id_value->GetIfString();
      if (!temp) {
        out->client_cert_provisioning_profile_id.reset();
        return false;
      }
      out->client_cert_provisioning_profile_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_ref_value = dict->FindKey("ClientCertRef");
  if (client_cert_ref_value) {
    {
      auto* temp = client_cert_ref_value->GetIfString();
      if (!temp) {
        out->client_cert_ref.reset();
        return false;
      }
      out->client_cert_ref = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_type_value = dict->FindKey("ClientCertType");
  if (client_cert_type_value) {
    {
      auto* temp = client_cert_type_value->GetIfString();
      if (!temp) {
        out->client_cert_type.reset();
        return false;
      }
      out->client_cert_type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* eap_value = dict->FindKey("EAP");
  if (eap_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!eap_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<EAPProperties>();
        if (!EAPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->eap = std::move(temp);
      }
    }
  }

  const base::Value* group_value = dict->FindKey("Group");
  if (group_value) {
    {
      auto* temp = group_value->GetIfString();
      if (!temp) {
        out->group.reset();
        return false;
      }
      out->group = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* ike_version_value = dict->FindKey("IKEVersion");
  if (ike_version_value) {
    {
      auto temp = ike_version_value->GetIfInt();
      if (!temp.has_value()) {
        out->ike_version.reset();
        return false;
      }
      out->ike_version = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* psk_value = dict->FindKey("PSK");
  if (psk_value) {
    {
      auto* temp = psk_value->GetIfString();
      if (!temp) {
        out->psk.reset();
        return false;
      }
      out->psk = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      auto temp = save_credentials_value->GetIfBool();
      if (!temp.has_value()) {
        out->save_credentials.reset();
        return false;
      }
      out->save_credentials = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* server_cape_ms_value = dict->FindKey("ServerCAPEMs");
  if (server_cape_ms_value) {
    {
      const base::ListValue* list = nullptr;
      if (!server_cape_ms_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->server_cape_ms)) {
          return false;
        }
      }
    }
  }

  const base::Value* server_ca_refs_value = dict->FindKey("ServerCARefs");
  if (server_ca_refs_value) {
    {
      const base::ListValue* list = nullptr;
      if (!server_ca_refs_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->server_ca_refs)) {
          return false;
        }
      }
    }
  }

  const base::Value* xauth_value = dict->FindKey("XAUTH");
  if (xauth_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!xauth_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<XAUTHProperties>();
        if (!XAUTHProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->xauth = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<IPSecProperties> IPSecProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<IPSecProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> IPSecProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("AuthenticationType", std::make_unique<base::Value>(this->authentication_type));

  if (this->client_cert_pattern.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPattern", (this->client_cert_pattern)->ToValue());

  }
  if (this->client_cert_pkcs11_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPKCS11Id", std::make_unique<base::Value>(*this->client_cert_pkcs11_id));

  }
  if (this->client_cert_provisioning_profile_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertProvisioningProfileId", std::make_unique<base::Value>(*this->client_cert_provisioning_profile_id));

  }
  if (this->client_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertRef", std::make_unique<base::Value>(*this->client_cert_ref));

  }
  if (this->client_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertType", std::make_unique<base::Value>(*this->client_cert_type));

  }
  if (this->eap.get()) {
    to_value_result->SetWithoutPathExpansion("EAP", (this->eap)->ToValue());

  }
  if (this->group.get()) {
    to_value_result->SetWithoutPathExpansion("Group", std::make_unique<base::Value>(*this->group));

  }
  if (this->ike_version.get()) {
    to_value_result->SetWithoutPathExpansion("IKEVersion", std::make_unique<base::Value>(*this->ike_version));

  }
  if (this->psk.get()) {
    to_value_result->SetWithoutPathExpansion("PSK", std::make_unique<base::Value>(*this->psk));

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", std::make_unique<base::Value>(*this->save_credentials));

  }
  if (this->server_cape_ms.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCAPEMs", json_schema_compiler::util::CreateValueFromArray(*this->server_cape_ms));

  }
  if (this->server_ca_refs.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCARefs", json_schema_compiler::util::CreateValueFromArray(*this->server_ca_refs));

  }
  if (this->xauth.get()) {
    to_value_result->SetWithoutPathExpansion("XAUTH", (this->xauth)->ToValue());

  }

  return to_value_result;
}


ManagedIPSecProperties::ManagedIPSecProperties()
 {}

ManagedIPSecProperties::~ManagedIPSecProperties() = default;
ManagedIPSecProperties::ManagedIPSecProperties(ManagedIPSecProperties&& rhs) = default;
ManagedIPSecProperties& ManagedIPSecProperties::operator=(ManagedIPSecProperties&& rhs) = default;
// static
bool ManagedIPSecProperties::Populate(
    const base::Value& value, ManagedIPSecProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* authentication_type_value = dict->FindKey("AuthenticationType");
  if (!authentication_type_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!authentication_type_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ManagedDOMString::Populate(*dictionary, &out->authentication_type)) {
      return false;
    }
  }

  const base::Value* client_cert_pattern_value = dict->FindKey("ClientCertPattern");
  if (client_cert_pattern_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pattern_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedCertificatePattern>();
        if (!ManagedCertificatePattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pattern = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_pkcs11_id_value = dict->FindKey("ClientCertPKCS11Id");
  if (client_cert_pkcs11_id_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pkcs11_id_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pkcs11_id = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_provisioning_profile_id_value = dict->FindKey("ClientCertProvisioningProfileId");
  if (client_cert_provisioning_profile_id_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_provisioning_profile_id_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_provisioning_profile_id = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_ref_value = dict->FindKey("ClientCertRef");
  if (client_cert_ref_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_ref_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_ref = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_type_value = dict->FindKey("ClientCertType");
  if (client_cert_type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_type = std::move(temp);
      }
    }
  }

  const base::Value* eap_value = dict->FindKey("EAP");
  if (eap_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!eap_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedEAPProperties>();
        if (!ManagedEAPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->eap = std::move(temp);
      }
    }
  }

  const base::Value* group_value = dict->FindKey("Group");
  if (group_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!group_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->group = std::move(temp);
      }
    }
  }

  const base::Value* ike_version_value = dict->FindKey("IKEVersion");
  if (ike_version_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ike_version_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedLong>();
        if (!ManagedLong::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ike_version = std::move(temp);
      }
    }
  }

  const base::Value* psk_value = dict->FindKey("PSK");
  if (psk_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!psk_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->psk = std::move(temp);
      }
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!save_credentials_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->save_credentials = std::move(temp);
      }
    }
  }

  const base::Value* server_cape_ms_value = dict->FindKey("ServerCAPEMs");
  if (server_cape_ms_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_cape_ms_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_cape_ms = std::move(temp);
      }
    }
  }

  const base::Value* server_ca_refs_value = dict->FindKey("ServerCARefs");
  if (server_ca_refs_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_ca_refs_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_ca_refs = std::move(temp);
      }
    }
  }

  const base::Value* xauth_value = dict->FindKey("XAUTH");
  if (xauth_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!xauth_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedXAUTHProperties>();
        if (!ManagedXAUTHProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->xauth = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedIPSecProperties> ManagedIPSecProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedIPSecProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedIPSecProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("AuthenticationType", (this->authentication_type).ToValue());

  if (this->client_cert_pattern.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPattern", (this->client_cert_pattern)->ToValue());

  }
  if (this->client_cert_pkcs11_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPKCS11Id", (this->client_cert_pkcs11_id)->ToValue());

  }
  if (this->client_cert_provisioning_profile_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertProvisioningProfileId", (this->client_cert_provisioning_profile_id)->ToValue());

  }
  if (this->client_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertRef", (this->client_cert_ref)->ToValue());

  }
  if (this->client_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertType", (this->client_cert_type)->ToValue());

  }
  if (this->eap.get()) {
    to_value_result->SetWithoutPathExpansion("EAP", (this->eap)->ToValue());

  }
  if (this->group.get()) {
    to_value_result->SetWithoutPathExpansion("Group", (this->group)->ToValue());

  }
  if (this->ike_version.get()) {
    to_value_result->SetWithoutPathExpansion("IKEVersion", (this->ike_version)->ToValue());

  }
  if (this->psk.get()) {
    to_value_result->SetWithoutPathExpansion("PSK", (this->psk)->ToValue());

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", (this->save_credentials)->ToValue());

  }
  if (this->server_cape_ms.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCAPEMs", (this->server_cape_ms)->ToValue());

  }
  if (this->server_ca_refs.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCARefs", (this->server_ca_refs)->ToValue());

  }
  if (this->xauth.get()) {
    to_value_result->SetWithoutPathExpansion("XAUTH", (this->xauth)->ToValue());

  }

  return to_value_result;
}


L2TPProperties::L2TPProperties()
 {}

L2TPProperties::~L2TPProperties() = default;
L2TPProperties::L2TPProperties(L2TPProperties&& rhs) = default;
L2TPProperties& L2TPProperties::operator=(L2TPProperties&& rhs) = default;
// static
bool L2TPProperties::Populate(
    const base::Value& value, L2TPProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* lcp_echo_disabled_value = dict->FindKey("LcpEchoDisabled");
  if (lcp_echo_disabled_value) {
    {
      auto temp = lcp_echo_disabled_value->GetIfBool();
      if (!temp.has_value()) {
        out->lcp_echo_disabled.reset();
        return false;
      }
      out->lcp_echo_disabled = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      auto* temp = password_value->GetIfString();
      if (!temp) {
        out->password.reset();
        return false;
      }
      out->password = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      auto temp = save_credentials_value->GetIfBool();
      if (!temp.has_value()) {
        out->save_credentials.reset();
        return false;
      }
      out->save_credentials = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      auto* temp = username_value->GetIfString();
      if (!temp) {
        out->username.reset();
        return false;
      }
      out->username = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<L2TPProperties> L2TPProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<L2TPProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> L2TPProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->lcp_echo_disabled.get()) {
    to_value_result->SetWithoutPathExpansion("LcpEchoDisabled", std::make_unique<base::Value>(*this->lcp_echo_disabled));

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", std::make_unique<base::Value>(*this->password));

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", std::make_unique<base::Value>(*this->save_credentials));

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", std::make_unique<base::Value>(*this->username));

  }

  return to_value_result;
}


ManagedL2TPProperties::ManagedL2TPProperties()
 {}

ManagedL2TPProperties::~ManagedL2TPProperties() = default;
ManagedL2TPProperties::ManagedL2TPProperties(ManagedL2TPProperties&& rhs) = default;
ManagedL2TPProperties& ManagedL2TPProperties::operator=(ManagedL2TPProperties&& rhs) = default;
// static
bool ManagedL2TPProperties::Populate(
    const base::Value& value, ManagedL2TPProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* lcp_echo_disabled_value = dict->FindKey("LcpEchoDisabled");
  if (lcp_echo_disabled_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!lcp_echo_disabled_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->lcp_echo_disabled = std::move(temp);
      }
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!password_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->password = std::move(temp);
      }
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!save_credentials_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->save_credentials = std::move(temp);
      }
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!username_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->username = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedL2TPProperties> ManagedL2TPProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedL2TPProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedL2TPProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->lcp_echo_disabled.get()) {
    to_value_result->SetWithoutPathExpansion("LcpEchoDisabled", (this->lcp_echo_disabled)->ToValue());

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", (this->password)->ToValue());

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", (this->save_credentials)->ToValue());

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", (this->username)->ToValue());

  }

  return to_value_result;
}


PaymentPortal::PaymentPortal()
 {}

PaymentPortal::~PaymentPortal() = default;
PaymentPortal::PaymentPortal(PaymentPortal&& rhs) = default;
PaymentPortal& PaymentPortal::operator=(PaymentPortal&& rhs) = default;
// static
bool PaymentPortal::Populate(
    const base::Value& value, PaymentPortal* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* method_value = dict->FindKey("Method");
  if (!method_value) {
    return false;
  }
  {
    auto* temp = method_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->method = *temp;
  }

  const base::Value* post_data_value = dict->FindKey("PostData");
  if (post_data_value) {
    {
      auto* temp = post_data_value->GetIfString();
      if (!temp) {
        out->post_data.reset();
        return false;
      }
      out->post_data = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* url_value = dict->FindKey("Url");
  if (url_value) {
    {
      auto* temp = url_value->GetIfString();
      if (!temp) {
        out->url.reset();
        return false;
      }
      out->url = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<PaymentPortal> PaymentPortal::FromValue(const base::Value& value) {
  auto out = std::make_unique<PaymentPortal>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> PaymentPortal::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Method", std::make_unique<base::Value>(this->method));

  if (this->post_data.get()) {
    to_value_result->SetWithoutPathExpansion("PostData", std::make_unique<base::Value>(*this->post_data));

  }
  if (this->url.get()) {
    to_value_result->SetWithoutPathExpansion("Url", std::make_unique<base::Value>(*this->url));

  }

  return to_value_result;
}


ProxyLocation::ProxyLocation()
: port(0) {}

ProxyLocation::~ProxyLocation() = default;
ProxyLocation::ProxyLocation(ProxyLocation&& rhs) = default;
ProxyLocation& ProxyLocation::operator=(ProxyLocation&& rhs) = default;
// static
bool ProxyLocation::Populate(
    const base::Value& value, ProxyLocation* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* host_value = dict->FindKey("Host");
  if (!host_value) {
    return false;
  }
  {
    auto* temp = host_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->host = *temp;
  }

  const base::Value* port_value = dict->FindKey("Port");
  if (!port_value) {
    return false;
  }
  {
    auto temp = port_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->port = temp.value();
  }

  return true;
}

// static
std::unique_ptr<ProxyLocation> ProxyLocation::FromValue(const base::Value& value) {
  auto out = std::make_unique<ProxyLocation>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ProxyLocation::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Host", std::make_unique<base::Value>(this->host));

  to_value_result->SetWithoutPathExpansion("Port", std::make_unique<base::Value>(this->port));


  return to_value_result;
}


ManagedProxyLocation::ManagedProxyLocation()
 {}

ManagedProxyLocation::~ManagedProxyLocation() = default;
ManagedProxyLocation::ManagedProxyLocation(ManagedProxyLocation&& rhs) = default;
ManagedProxyLocation& ManagedProxyLocation::operator=(ManagedProxyLocation&& rhs) = default;
// static
bool ManagedProxyLocation::Populate(
    const base::Value& value, ManagedProxyLocation* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* host_value = dict->FindKey("Host");
  if (!host_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!host_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ManagedDOMString::Populate(*dictionary, &out->host)) {
      return false;
    }
  }

  const base::Value* port_value = dict->FindKey("Port");
  if (!port_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!port_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ManagedLong::Populate(*dictionary, &out->port)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedProxyLocation> ManagedProxyLocation::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedProxyLocation>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedProxyLocation::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Host", (this->host).ToValue());

  to_value_result->SetWithoutPathExpansion("Port", (this->port).ToValue());


  return to_value_result;
}


ManualProxySettings::ManualProxySettings()
 {}

ManualProxySettings::~ManualProxySettings() = default;
ManualProxySettings::ManualProxySettings(ManualProxySettings&& rhs) = default;
ManualProxySettings& ManualProxySettings::operator=(ManualProxySettings&& rhs) = default;
// static
bool ManualProxySettings::Populate(
    const base::Value& value, ManualProxySettings* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* http_proxy_value = dict->FindKey("HTTPProxy");
  if (http_proxy_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!http_proxy_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ProxyLocation>();
        if (!ProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->http_proxy = std::move(temp);
      }
    }
  }

  const base::Value* secure_http_proxy_value = dict->FindKey("SecureHTTPProxy");
  if (secure_http_proxy_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!secure_http_proxy_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ProxyLocation>();
        if (!ProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->secure_http_proxy = std::move(temp);
      }
    }
  }

  const base::Value* ftp_proxy_value = dict->FindKey("FTPProxy");
  if (ftp_proxy_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ftp_proxy_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ProxyLocation>();
        if (!ProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ftp_proxy = std::move(temp);
      }
    }
  }

  const base::Value* socks_value = dict->FindKey("SOCKS");
  if (socks_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!socks_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ProxyLocation>();
        if (!ProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->socks = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManualProxySettings> ManualProxySettings::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManualProxySettings>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManualProxySettings::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->http_proxy.get()) {
    to_value_result->SetWithoutPathExpansion("HTTPProxy", (this->http_proxy)->ToValue());

  }
  if (this->secure_http_proxy.get()) {
    to_value_result->SetWithoutPathExpansion("SecureHTTPProxy", (this->secure_http_proxy)->ToValue());

  }
  if (this->ftp_proxy.get()) {
    to_value_result->SetWithoutPathExpansion("FTPProxy", (this->ftp_proxy)->ToValue());

  }
  if (this->socks.get()) {
    to_value_result->SetWithoutPathExpansion("SOCKS", (this->socks)->ToValue());

  }

  return to_value_result;
}


ManagedManualProxySettings::ManagedManualProxySettings()
 {}

ManagedManualProxySettings::~ManagedManualProxySettings() = default;
ManagedManualProxySettings::ManagedManualProxySettings(ManagedManualProxySettings&& rhs) = default;
ManagedManualProxySettings& ManagedManualProxySettings::operator=(ManagedManualProxySettings&& rhs) = default;
// static
bool ManagedManualProxySettings::Populate(
    const base::Value& value, ManagedManualProxySettings* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* http_proxy_value = dict->FindKey("HTTPProxy");
  if (http_proxy_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!http_proxy_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedProxyLocation>();
        if (!ManagedProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->http_proxy = std::move(temp);
      }
    }
  }

  const base::Value* secure_http_proxy_value = dict->FindKey("SecureHTTPProxy");
  if (secure_http_proxy_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!secure_http_proxy_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedProxyLocation>();
        if (!ManagedProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->secure_http_proxy = std::move(temp);
      }
    }
  }

  const base::Value* ftp_proxy_value = dict->FindKey("FTPProxy");
  if (ftp_proxy_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ftp_proxy_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedProxyLocation>();
        if (!ManagedProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ftp_proxy = std::move(temp);
      }
    }
  }

  const base::Value* socks_value = dict->FindKey("SOCKS");
  if (socks_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!socks_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedProxyLocation>();
        if (!ManagedProxyLocation::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->socks = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedManualProxySettings> ManagedManualProxySettings::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedManualProxySettings>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedManualProxySettings::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->http_proxy.get()) {
    to_value_result->SetWithoutPathExpansion("HTTPProxy", (this->http_proxy)->ToValue());

  }
  if (this->secure_http_proxy.get()) {
    to_value_result->SetWithoutPathExpansion("SecureHTTPProxy", (this->secure_http_proxy)->ToValue());

  }
  if (this->ftp_proxy.get()) {
    to_value_result->SetWithoutPathExpansion("FTPProxy", (this->ftp_proxy)->ToValue());

  }
  if (this->socks.get()) {
    to_value_result->SetWithoutPathExpansion("SOCKS", (this->socks)->ToValue());

  }

  return to_value_result;
}


ProxySettings::ProxySettings()
: type(PROXY_SETTINGS_TYPE_NONE) {}

ProxySettings::~ProxySettings() = default;
ProxySettings::ProxySettings(ProxySettings&& rhs) = default;
ProxySettings& ProxySettings::operator=(ProxySettings&& rhs) = default;
// static
bool ProxySettings::Populate(
    const base::Value& value, ProxySettings* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* type_value = dict->FindKey("Type");
  if (!type_value) {
    return false;
  }
  {
    std::string proxy_settings_type_as_string;
    if (!type_value->GetAsString(&proxy_settings_type_as_string)) {
      return false;
    }
    out->type = ParseProxySettingsType(proxy_settings_type_as_string);
    if (out->type == PROXY_SETTINGS_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* manual_value = dict->FindKey("Manual");
  if (manual_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!manual_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManualProxySettings>();
        if (!ManualProxySettings::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->manual = std::move(temp);
      }
    }
  }

  const base::Value* exclude_domains_value = dict->FindKey("ExcludeDomains");
  if (exclude_domains_value) {
    {
      const base::ListValue* list = nullptr;
      if (!exclude_domains_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->exclude_domains)) {
          return false;
        }
      }
    }
  }

  const base::Value* pac_value = dict->FindKey("PAC");
  if (pac_value) {
    {
      auto* temp = pac_value->GetIfString();
      if (!temp) {
        out->pac.reset();
        return false;
      }
      out->pac = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<ProxySettings> ProxySettings::FromValue(const base::Value& value) {
  auto out = std::make_unique<ProxySettings>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ProxySettings::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(networking_private::ToString(this->type)));

  if (this->manual.get()) {
    to_value_result->SetWithoutPathExpansion("Manual", (this->manual)->ToValue());

  }
  if (this->exclude_domains.get()) {
    to_value_result->SetWithoutPathExpansion("ExcludeDomains", json_schema_compiler::util::CreateValueFromArray(*this->exclude_domains));

  }
  if (this->pac.get()) {
    to_value_result->SetWithoutPathExpansion("PAC", std::make_unique<base::Value>(*this->pac));

  }

  return to_value_result;
}


ManagedProxySettings::ManagedProxySettings()
 {}

ManagedProxySettings::~ManagedProxySettings() = default;
ManagedProxySettings::ManagedProxySettings(ManagedProxySettings&& rhs) = default;
ManagedProxySettings& ManagedProxySettings::operator=(ManagedProxySettings&& rhs) = default;
// static
bool ManagedProxySettings::Populate(
    const base::Value& value, ManagedProxySettings* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* type_value = dict->FindKey("Type");
  if (!type_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!type_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ManagedProxySettingsType::Populate(*dictionary, &out->type)) {
      return false;
    }
  }

  const base::Value* manual_value = dict->FindKey("Manual");
  if (manual_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!manual_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedManualProxySettings>();
        if (!ManagedManualProxySettings::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->manual = std::move(temp);
      }
    }
  }

  const base::Value* exclude_domains_value = dict->FindKey("ExcludeDomains");
  if (exclude_domains_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!exclude_domains_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->exclude_domains = std::move(temp);
      }
    }
  }

  const base::Value* pac_value = dict->FindKey("PAC");
  if (pac_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!pac_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->pac = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedProxySettings> ManagedProxySettings::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedProxySettings>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedProxySettings::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Type", (this->type).ToValue());

  if (this->manual.get()) {
    to_value_result->SetWithoutPathExpansion("Manual", (this->manual)->ToValue());

  }
  if (this->exclude_domains.get()) {
    to_value_result->SetWithoutPathExpansion("ExcludeDomains", (this->exclude_domains)->ToValue());

  }
  if (this->pac.get()) {
    to_value_result->SetWithoutPathExpansion("PAC", (this->pac)->ToValue());

  }

  return to_value_result;
}


VerifyX509::VerifyX509()
 {}

VerifyX509::~VerifyX509() = default;
VerifyX509::VerifyX509(VerifyX509&& rhs) = default;
VerifyX509& VerifyX509::operator=(VerifyX509&& rhs) = default;
// static
bool VerifyX509::Populate(
    const base::Value& value, VerifyX509* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (type_value) {
    {
      auto* temp = type_value->GetIfString();
      if (!temp) {
        out->type.reset();
        return false;
      }
      out->type = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<VerifyX509> VerifyX509::FromValue(const base::Value& value) {
  auto out = std::make_unique<VerifyX509>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> VerifyX509::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", std::make_unique<base::Value>(*this->name));

  }
  if (this->type.get()) {
    to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(*this->type));

  }

  return to_value_result;
}


ManagedVerifyX509::ManagedVerifyX509()
 {}

ManagedVerifyX509::~ManagedVerifyX509() = default;
ManagedVerifyX509::ManagedVerifyX509(ManagedVerifyX509&& rhs) = default;
ManagedVerifyX509& ManagedVerifyX509::operator=(ManagedVerifyX509&& rhs) = default;
// static
bool ManagedVerifyX509::Populate(
    const base::Value& value, ManagedVerifyX509* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!name_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->name = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->type = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedVerifyX509> ManagedVerifyX509::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedVerifyX509>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedVerifyX509::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", (this->name)->ToValue());

  }
  if (this->type.get()) {
    to_value_result->SetWithoutPathExpansion("Type", (this->type)->ToValue());

  }

  return to_value_result;
}


OpenVPNProperties::OpenVPNProperties()
 {}

OpenVPNProperties::~OpenVPNProperties() = default;
OpenVPNProperties::OpenVPNProperties(OpenVPNProperties&& rhs) = default;
OpenVPNProperties& OpenVPNProperties::operator=(OpenVPNProperties&& rhs) = default;
// static
bool OpenVPNProperties::Populate(
    const base::Value& value, OpenVPNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* auth_value = dict->FindKey("Auth");
  if (auth_value) {
    {
      auto* temp = auth_value->GetIfString();
      if (!temp) {
        out->auth.reset();
        return false;
      }
      out->auth = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* auth_retry_value = dict->FindKey("AuthRetry");
  if (auth_retry_value) {
    {
      auto* temp = auth_retry_value->GetIfString();
      if (!temp) {
        out->auth_retry.reset();
        return false;
      }
      out->auth_retry = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* auth_no_cache_value = dict->FindKey("AuthNoCache");
  if (auth_no_cache_value) {
    {
      auto temp = auth_no_cache_value->GetIfBool();
      if (!temp.has_value()) {
        out->auth_no_cache.reset();
        return false;
      }
      out->auth_no_cache = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* cipher_value = dict->FindKey("Cipher");
  if (cipher_value) {
    {
      auto* temp = cipher_value->GetIfString();
      if (!temp) {
        out->cipher.reset();
        return false;
      }
      out->cipher = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_pkcs11_id_value = dict->FindKey("ClientCertPKCS11Id");
  if (client_cert_pkcs11_id_value) {
    {
      auto* temp = client_cert_pkcs11_id_value->GetIfString();
      if (!temp) {
        out->client_cert_pkcs11_id.reset();
        return false;
      }
      out->client_cert_pkcs11_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_pattern_value = dict->FindKey("ClientCertPattern");
  if (client_cert_pattern_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pattern_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CertificatePattern>();
        if (!CertificatePattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pattern = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_provisioning_profile_id_value = dict->FindKey("ClientCertProvisioningProfileId");
  if (client_cert_provisioning_profile_id_value) {
    {
      auto* temp = client_cert_provisioning_profile_id_value->GetIfString();
      if (!temp) {
        out->client_cert_provisioning_profile_id.reset();
        return false;
      }
      out->client_cert_provisioning_profile_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_ref_value = dict->FindKey("ClientCertRef");
  if (client_cert_ref_value) {
    {
      auto* temp = client_cert_ref_value->GetIfString();
      if (!temp) {
        out->client_cert_ref.reset();
        return false;
      }
      out->client_cert_ref = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* client_cert_type_value = dict->FindKey("ClientCertType");
  if (client_cert_type_value) {
    {
      auto* temp = client_cert_type_value->GetIfString();
      if (!temp) {
        out->client_cert_type.reset();
        return false;
      }
      out->client_cert_type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* comp_lzo_value = dict->FindKey("CompLZO");
  if (comp_lzo_value) {
    {
      auto* temp = comp_lzo_value->GetIfString();
      if (!temp) {
        out->comp_lzo.reset();
        return false;
      }
      out->comp_lzo = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* comp_no_adapt_value = dict->FindKey("CompNoAdapt");
  if (comp_no_adapt_value) {
    {
      auto temp = comp_no_adapt_value->GetIfBool();
      if (!temp.has_value()) {
        out->comp_no_adapt.reset();
        return false;
      }
      out->comp_no_adapt = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* extra_hosts_value = dict->FindKey("ExtraHosts");
  if (extra_hosts_value) {
    {
      const base::ListValue* list = nullptr;
      if (!extra_hosts_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->extra_hosts)) {
          return false;
        }
      }
    }
  }

  const base::Value* ignore_default_route_value = dict->FindKey("IgnoreDefaultRoute");
  if (ignore_default_route_value) {
    {
      auto temp = ignore_default_route_value->GetIfBool();
      if (!temp.has_value()) {
        out->ignore_default_route.reset();
        return false;
      }
      out->ignore_default_route = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* key_direction_value = dict->FindKey("KeyDirection");
  if (key_direction_value) {
    {
      auto* temp = key_direction_value->GetIfString();
      if (!temp) {
        out->key_direction.reset();
        return false;
      }
      out->key_direction = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* ns_cert_type_value = dict->FindKey("NsCertType");
  if (ns_cert_type_value) {
    {
      auto* temp = ns_cert_type_value->GetIfString();
      if (!temp) {
        out->ns_cert_type.reset();
        return false;
      }
      out->ns_cert_type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* otp_value = dict->FindKey("OTP");
  if (otp_value) {
    {
      auto* temp = otp_value->GetIfString();
      if (!temp) {
        out->otp.reset();
        return false;
      }
      out->otp = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      auto* temp = password_value->GetIfString();
      if (!temp) {
        out->password.reset();
        return false;
      }
      out->password = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* port_value = dict->FindKey("Port");
  if (port_value) {
    {
      auto temp = port_value->GetIfInt();
      if (!temp.has_value()) {
        out->port.reset();
        return false;
      }
      out->port = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* proto_value = dict->FindKey("Proto");
  if (proto_value) {
    {
      auto* temp = proto_value->GetIfString();
      if (!temp) {
        out->proto.reset();
        return false;
      }
      out->proto = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* push_peer_info_value = dict->FindKey("PushPeerInfo");
  if (push_peer_info_value) {
    {
      auto temp = push_peer_info_value->GetIfBool();
      if (!temp.has_value()) {
        out->push_peer_info.reset();
        return false;
      }
      out->push_peer_info = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* remote_cert_eku_value = dict->FindKey("RemoteCertEKU");
  if (remote_cert_eku_value) {
    {
      auto* temp = remote_cert_eku_value->GetIfString();
      if (!temp) {
        out->remote_cert_eku.reset();
        return false;
      }
      out->remote_cert_eku = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* remote_cert_ku_value = dict->FindKey("RemoteCertKU");
  if (remote_cert_ku_value) {
    {
      const base::ListValue* list = nullptr;
      if (!remote_cert_ku_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->remote_cert_ku)) {
          return false;
        }
      }
    }
  }

  const base::Value* remote_cert_tls_value = dict->FindKey("RemoteCertTLS");
  if (remote_cert_tls_value) {
    {
      auto* temp = remote_cert_tls_value->GetIfString();
      if (!temp) {
        out->remote_cert_tls.reset();
        return false;
      }
      out->remote_cert_tls = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* reneg_sec_value = dict->FindKey("RenegSec");
  if (reneg_sec_value) {
    {
      auto temp = reneg_sec_value->GetIfInt();
      if (!temp.has_value()) {
        out->reneg_sec.reset();
        return false;
      }
      out->reneg_sec = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      auto temp = save_credentials_value->GetIfBool();
      if (!temp.has_value()) {
        out->save_credentials.reset();
        return false;
      }
      out->save_credentials = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* server_cape_ms_value = dict->FindKey("ServerCAPEMs");
  if (server_cape_ms_value) {
    {
      const base::ListValue* list = nullptr;
      if (!server_cape_ms_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->server_cape_ms)) {
          return false;
        }
      }
    }
  }

  const base::Value* server_ca_refs_value = dict->FindKey("ServerCARefs");
  if (server_ca_refs_value) {
    {
      const base::ListValue* list = nullptr;
      if (!server_ca_refs_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->server_ca_refs)) {
          return false;
        }
      }
    }
  }

  const base::Value* server_cert_ref_value = dict->FindKey("ServerCertRef");
  if (server_cert_ref_value) {
    {
      auto* temp = server_cert_ref_value->GetIfString();
      if (!temp) {
        out->server_cert_ref.reset();
        return false;
      }
      out->server_cert_ref = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* server_poll_timeout_value = dict->FindKey("ServerPollTimeout");
  if (server_poll_timeout_value) {
    {
      auto temp = server_poll_timeout_value->GetIfInt();
      if (!temp.has_value()) {
        out->server_poll_timeout.reset();
        return false;
      }
      out->server_poll_timeout = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* shaper_value = dict->FindKey("Shaper");
  if (shaper_value) {
    {
      auto temp = shaper_value->GetIfInt();
      if (!temp.has_value()) {
        out->shaper.reset();
        return false;
      }
      out->shaper = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* static_challenge_value = dict->FindKey("StaticChallenge");
  if (static_challenge_value) {
    {
      auto* temp = static_challenge_value->GetIfString();
      if (!temp) {
        out->static_challenge.reset();
        return false;
      }
      out->static_challenge = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tls_auth_contents_value = dict->FindKey("TLSAuthContents");
  if (tls_auth_contents_value) {
    {
      auto* temp = tls_auth_contents_value->GetIfString();
      if (!temp) {
        out->tls_auth_contents.reset();
        return false;
      }
      out->tls_auth_contents = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tls_remote_value = dict->FindKey("TLSRemote");
  if (tls_remote_value) {
    {
      auto* temp = tls_remote_value->GetIfString();
      if (!temp) {
        out->tls_remote.reset();
        return false;
      }
      out->tls_remote = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tls_version_min_value = dict->FindKey("TLSVersionMin");
  if (tls_version_min_value) {
    {
      auto* temp = tls_version_min_value->GetIfString();
      if (!temp) {
        out->tls_version_min.reset();
        return false;
      }
      out->tls_version_min = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* user_authentication_type_value = dict->FindKey("UserAuthenticationType");
  if (user_authentication_type_value) {
    {
      auto* temp = user_authentication_type_value->GetIfString();
      if (!temp) {
        out->user_authentication_type.reset();
        return false;
      }
      out->user_authentication_type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      auto* temp = username_value->GetIfString();
      if (!temp) {
        out->username.reset();
        return false;
      }
      out->username = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* verb_value = dict->FindKey("Verb");
  if (verb_value) {
    {
      auto* temp = verb_value->GetIfString();
      if (!temp) {
        out->verb.reset();
        return false;
      }
      out->verb = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* verify_hash_value = dict->FindKey("VerifyHash");
  if (verify_hash_value) {
    {
      auto* temp = verify_hash_value->GetIfString();
      if (!temp) {
        out->verify_hash.reset();
        return false;
      }
      out->verify_hash = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* verify_x509_value = dict->FindKey("VerifyX509");
  if (verify_x509_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!verify_x509_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<VerifyX509>();
        if (!VerifyX509::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->verify_x509 = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<OpenVPNProperties> OpenVPNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<OpenVPNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> OpenVPNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auth.get()) {
    to_value_result->SetWithoutPathExpansion("Auth", std::make_unique<base::Value>(*this->auth));

  }
  if (this->auth_retry.get()) {
    to_value_result->SetWithoutPathExpansion("AuthRetry", std::make_unique<base::Value>(*this->auth_retry));

  }
  if (this->auth_no_cache.get()) {
    to_value_result->SetWithoutPathExpansion("AuthNoCache", std::make_unique<base::Value>(*this->auth_no_cache));

  }
  if (this->cipher.get()) {
    to_value_result->SetWithoutPathExpansion("Cipher", std::make_unique<base::Value>(*this->cipher));

  }
  if (this->client_cert_pkcs11_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPKCS11Id", std::make_unique<base::Value>(*this->client_cert_pkcs11_id));

  }
  if (this->client_cert_pattern.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPattern", (this->client_cert_pattern)->ToValue());

  }
  if (this->client_cert_provisioning_profile_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertProvisioningProfileId", std::make_unique<base::Value>(*this->client_cert_provisioning_profile_id));

  }
  if (this->client_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertRef", std::make_unique<base::Value>(*this->client_cert_ref));

  }
  if (this->client_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertType", std::make_unique<base::Value>(*this->client_cert_type));

  }
  if (this->comp_lzo.get()) {
    to_value_result->SetWithoutPathExpansion("CompLZO", std::make_unique<base::Value>(*this->comp_lzo));

  }
  if (this->comp_no_adapt.get()) {
    to_value_result->SetWithoutPathExpansion("CompNoAdapt", std::make_unique<base::Value>(*this->comp_no_adapt));

  }
  if (this->extra_hosts.get()) {
    to_value_result->SetWithoutPathExpansion("ExtraHosts", json_schema_compiler::util::CreateValueFromArray(*this->extra_hosts));

  }
  if (this->ignore_default_route.get()) {
    to_value_result->SetWithoutPathExpansion("IgnoreDefaultRoute", std::make_unique<base::Value>(*this->ignore_default_route));

  }
  if (this->key_direction.get()) {
    to_value_result->SetWithoutPathExpansion("KeyDirection", std::make_unique<base::Value>(*this->key_direction));

  }
  if (this->ns_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("NsCertType", std::make_unique<base::Value>(*this->ns_cert_type));

  }
  if (this->otp.get()) {
    to_value_result->SetWithoutPathExpansion("OTP", std::make_unique<base::Value>(*this->otp));

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", std::make_unique<base::Value>(*this->password));

  }
  if (this->port.get()) {
    to_value_result->SetWithoutPathExpansion("Port", std::make_unique<base::Value>(*this->port));

  }
  if (this->proto.get()) {
    to_value_result->SetWithoutPathExpansion("Proto", std::make_unique<base::Value>(*this->proto));

  }
  if (this->push_peer_info.get()) {
    to_value_result->SetWithoutPathExpansion("PushPeerInfo", std::make_unique<base::Value>(*this->push_peer_info));

  }
  if (this->remote_cert_eku.get()) {
    to_value_result->SetWithoutPathExpansion("RemoteCertEKU", std::make_unique<base::Value>(*this->remote_cert_eku));

  }
  if (this->remote_cert_ku.get()) {
    to_value_result->SetWithoutPathExpansion("RemoteCertKU", json_schema_compiler::util::CreateValueFromArray(*this->remote_cert_ku));

  }
  if (this->remote_cert_tls.get()) {
    to_value_result->SetWithoutPathExpansion("RemoteCertTLS", std::make_unique<base::Value>(*this->remote_cert_tls));

  }
  if (this->reneg_sec.get()) {
    to_value_result->SetWithoutPathExpansion("RenegSec", std::make_unique<base::Value>(*this->reneg_sec));

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", std::make_unique<base::Value>(*this->save_credentials));

  }
  if (this->server_cape_ms.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCAPEMs", json_schema_compiler::util::CreateValueFromArray(*this->server_cape_ms));

  }
  if (this->server_ca_refs.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCARefs", json_schema_compiler::util::CreateValueFromArray(*this->server_ca_refs));

  }
  if (this->server_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCertRef", std::make_unique<base::Value>(*this->server_cert_ref));

  }
  if (this->server_poll_timeout.get()) {
    to_value_result->SetWithoutPathExpansion("ServerPollTimeout", std::make_unique<base::Value>(*this->server_poll_timeout));

  }
  if (this->shaper.get()) {
    to_value_result->SetWithoutPathExpansion("Shaper", std::make_unique<base::Value>(*this->shaper));

  }
  if (this->static_challenge.get()) {
    to_value_result->SetWithoutPathExpansion("StaticChallenge", std::make_unique<base::Value>(*this->static_challenge));

  }
  if (this->tls_auth_contents.get()) {
    to_value_result->SetWithoutPathExpansion("TLSAuthContents", std::make_unique<base::Value>(*this->tls_auth_contents));

  }
  if (this->tls_remote.get()) {
    to_value_result->SetWithoutPathExpansion("TLSRemote", std::make_unique<base::Value>(*this->tls_remote));

  }
  if (this->tls_version_min.get()) {
    to_value_result->SetWithoutPathExpansion("TLSVersionMin", std::make_unique<base::Value>(*this->tls_version_min));

  }
  if (this->user_authentication_type.get()) {
    to_value_result->SetWithoutPathExpansion("UserAuthenticationType", std::make_unique<base::Value>(*this->user_authentication_type));

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", std::make_unique<base::Value>(*this->username));

  }
  if (this->verb.get()) {
    to_value_result->SetWithoutPathExpansion("Verb", std::make_unique<base::Value>(*this->verb));

  }
  if (this->verify_hash.get()) {
    to_value_result->SetWithoutPathExpansion("VerifyHash", std::make_unique<base::Value>(*this->verify_hash));

  }
  if (this->verify_x509.get()) {
    to_value_result->SetWithoutPathExpansion("VerifyX509", (this->verify_x509)->ToValue());

  }

  return to_value_result;
}


ManagedOpenVPNProperties::ManagedOpenVPNProperties()
 {}

ManagedOpenVPNProperties::~ManagedOpenVPNProperties() = default;
ManagedOpenVPNProperties::ManagedOpenVPNProperties(ManagedOpenVPNProperties&& rhs) = default;
ManagedOpenVPNProperties& ManagedOpenVPNProperties::operator=(ManagedOpenVPNProperties&& rhs) = default;
// static
bool ManagedOpenVPNProperties::Populate(
    const base::Value& value, ManagedOpenVPNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* auth_value = dict->FindKey("Auth");
  if (auth_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!auth_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->auth = std::move(temp);
      }
    }
  }

  const base::Value* auth_retry_value = dict->FindKey("AuthRetry");
  if (auth_retry_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!auth_retry_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->auth_retry = std::move(temp);
      }
    }
  }

  const base::Value* auth_no_cache_value = dict->FindKey("AuthNoCache");
  if (auth_no_cache_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!auth_no_cache_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->auth_no_cache = std::move(temp);
      }
    }
  }

  const base::Value* cipher_value = dict->FindKey("Cipher");
  if (cipher_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!cipher_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->cipher = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_pkcs11_id_value = dict->FindKey("ClientCertPKCS11Id");
  if (client_cert_pkcs11_id_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pkcs11_id_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pkcs11_id = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_pattern_value = dict->FindKey("ClientCertPattern");
  if (client_cert_pattern_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_pattern_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedCertificatePattern>();
        if (!ManagedCertificatePattern::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_pattern = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_provisioning_profile_id_value = dict->FindKey("ClientCertProvisioningProfileId");
  if (client_cert_provisioning_profile_id_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_provisioning_profile_id_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_provisioning_profile_id = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_ref_value = dict->FindKey("ClientCertRef");
  if (client_cert_ref_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_ref_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_ref = std::move(temp);
      }
    }
  }

  const base::Value* client_cert_type_value = dict->FindKey("ClientCertType");
  if (client_cert_type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!client_cert_type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->client_cert_type = std::move(temp);
      }
    }
  }

  const base::Value* comp_lzo_value = dict->FindKey("CompLZO");
  if (comp_lzo_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!comp_lzo_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->comp_lzo = std::move(temp);
      }
    }
  }

  const base::Value* comp_no_adapt_value = dict->FindKey("CompNoAdapt");
  if (comp_no_adapt_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!comp_no_adapt_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->comp_no_adapt = std::move(temp);
      }
    }
  }

  const base::Value* extra_hosts_value = dict->FindKey("ExtraHosts");
  if (extra_hosts_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!extra_hosts_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->extra_hosts = std::move(temp);
      }
    }
  }

  const base::Value* ignore_default_route_value = dict->FindKey("IgnoreDefaultRoute");
  if (ignore_default_route_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ignore_default_route_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ignore_default_route = std::move(temp);
      }
    }
  }

  const base::Value* key_direction_value = dict->FindKey("KeyDirection");
  if (key_direction_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!key_direction_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->key_direction = std::move(temp);
      }
    }
  }

  const base::Value* ns_cert_type_value = dict->FindKey("NsCertType");
  if (ns_cert_type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ns_cert_type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ns_cert_type = std::move(temp);
      }
    }
  }

  const base::Value* otp_value = dict->FindKey("OTP");
  if (otp_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!otp_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->otp = std::move(temp);
      }
    }
  }

  const base::Value* password_value = dict->FindKey("Password");
  if (password_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!password_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->password = std::move(temp);
      }
    }
  }

  const base::Value* port_value = dict->FindKey("Port");
  if (port_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!port_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedLong>();
        if (!ManagedLong::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->port = std::move(temp);
      }
    }
  }

  const base::Value* proto_value = dict->FindKey("Proto");
  if (proto_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!proto_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->proto = std::move(temp);
      }
    }
  }

  const base::Value* push_peer_info_value = dict->FindKey("PushPeerInfo");
  if (push_peer_info_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!push_peer_info_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->push_peer_info = std::move(temp);
      }
    }
  }

  const base::Value* remote_cert_eku_value = dict->FindKey("RemoteCertEKU");
  if (remote_cert_eku_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!remote_cert_eku_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->remote_cert_eku = std::move(temp);
      }
    }
  }

  const base::Value* remote_cert_ku_value = dict->FindKey("RemoteCertKU");
  if (remote_cert_ku_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!remote_cert_ku_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->remote_cert_ku = std::move(temp);
      }
    }
  }

  const base::Value* remote_cert_tls_value = dict->FindKey("RemoteCertTLS");
  if (remote_cert_tls_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!remote_cert_tls_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->remote_cert_tls = std::move(temp);
      }
    }
  }

  const base::Value* reneg_sec_value = dict->FindKey("RenegSec");
  if (reneg_sec_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!reneg_sec_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedLong>();
        if (!ManagedLong::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->reneg_sec = std::move(temp);
      }
    }
  }

  const base::Value* save_credentials_value = dict->FindKey("SaveCredentials");
  if (save_credentials_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!save_credentials_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->save_credentials = std::move(temp);
      }
    }
  }

  const base::Value* server_cape_ms_value = dict->FindKey("ServerCAPEMs");
  if (server_cape_ms_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_cape_ms_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_cape_ms = std::move(temp);
      }
    }
  }

  const base::Value* server_ca_refs_value = dict->FindKey("ServerCARefs");
  if (server_ca_refs_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_ca_refs_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMStringList>();
        if (!ManagedDOMStringList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_ca_refs = std::move(temp);
      }
    }
  }

  const base::Value* server_cert_ref_value = dict->FindKey("ServerCertRef");
  if (server_cert_ref_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_cert_ref_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_cert_ref = std::move(temp);
      }
    }
  }

  const base::Value* server_poll_timeout_value = dict->FindKey("ServerPollTimeout");
  if (server_poll_timeout_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!server_poll_timeout_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedLong>();
        if (!ManagedLong::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->server_poll_timeout = std::move(temp);
      }
    }
  }

  const base::Value* shaper_value = dict->FindKey("Shaper");
  if (shaper_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!shaper_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedLong>();
        if (!ManagedLong::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->shaper = std::move(temp);
      }
    }
  }

  const base::Value* static_challenge_value = dict->FindKey("StaticChallenge");
  if (static_challenge_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!static_challenge_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->static_challenge = std::move(temp);
      }
    }
  }

  const base::Value* tls_auth_contents_value = dict->FindKey("TLSAuthContents");
  if (tls_auth_contents_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tls_auth_contents_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tls_auth_contents = std::move(temp);
      }
    }
  }

  const base::Value* tls_remote_value = dict->FindKey("TLSRemote");
  if (tls_remote_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tls_remote_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tls_remote = std::move(temp);
      }
    }
  }

  const base::Value* tls_version_min_value = dict->FindKey("TLSVersionMin");
  if (tls_version_min_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tls_version_min_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tls_version_min = std::move(temp);
      }
    }
  }

  const base::Value* user_authentication_type_value = dict->FindKey("UserAuthenticationType");
  if (user_authentication_type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!user_authentication_type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->user_authentication_type = std::move(temp);
      }
    }
  }

  const base::Value* username_value = dict->FindKey("Username");
  if (username_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!username_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->username = std::move(temp);
      }
    }
  }

  const base::Value* verb_value = dict->FindKey("Verb");
  if (verb_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!verb_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->verb = std::move(temp);
      }
    }
  }

  const base::Value* verify_hash_value = dict->FindKey("VerifyHash");
  if (verify_hash_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!verify_hash_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->verify_hash = std::move(temp);
      }
    }
  }

  const base::Value* verify_x509_value = dict->FindKey("VerifyX509");
  if (verify_x509_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!verify_x509_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedVerifyX509>();
        if (!ManagedVerifyX509::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->verify_x509 = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedOpenVPNProperties> ManagedOpenVPNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedOpenVPNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedOpenVPNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auth.get()) {
    to_value_result->SetWithoutPathExpansion("Auth", (this->auth)->ToValue());

  }
  if (this->auth_retry.get()) {
    to_value_result->SetWithoutPathExpansion("AuthRetry", (this->auth_retry)->ToValue());

  }
  if (this->auth_no_cache.get()) {
    to_value_result->SetWithoutPathExpansion("AuthNoCache", (this->auth_no_cache)->ToValue());

  }
  if (this->cipher.get()) {
    to_value_result->SetWithoutPathExpansion("Cipher", (this->cipher)->ToValue());

  }
  if (this->client_cert_pkcs11_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPKCS11Id", (this->client_cert_pkcs11_id)->ToValue());

  }
  if (this->client_cert_pattern.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertPattern", (this->client_cert_pattern)->ToValue());

  }
  if (this->client_cert_provisioning_profile_id.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertProvisioningProfileId", (this->client_cert_provisioning_profile_id)->ToValue());

  }
  if (this->client_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertRef", (this->client_cert_ref)->ToValue());

  }
  if (this->client_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("ClientCertType", (this->client_cert_type)->ToValue());

  }
  if (this->comp_lzo.get()) {
    to_value_result->SetWithoutPathExpansion("CompLZO", (this->comp_lzo)->ToValue());

  }
  if (this->comp_no_adapt.get()) {
    to_value_result->SetWithoutPathExpansion("CompNoAdapt", (this->comp_no_adapt)->ToValue());

  }
  if (this->extra_hosts.get()) {
    to_value_result->SetWithoutPathExpansion("ExtraHosts", (this->extra_hosts)->ToValue());

  }
  if (this->ignore_default_route.get()) {
    to_value_result->SetWithoutPathExpansion("IgnoreDefaultRoute", (this->ignore_default_route)->ToValue());

  }
  if (this->key_direction.get()) {
    to_value_result->SetWithoutPathExpansion("KeyDirection", (this->key_direction)->ToValue());

  }
  if (this->ns_cert_type.get()) {
    to_value_result->SetWithoutPathExpansion("NsCertType", (this->ns_cert_type)->ToValue());

  }
  if (this->otp.get()) {
    to_value_result->SetWithoutPathExpansion("OTP", (this->otp)->ToValue());

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("Password", (this->password)->ToValue());

  }
  if (this->port.get()) {
    to_value_result->SetWithoutPathExpansion("Port", (this->port)->ToValue());

  }
  if (this->proto.get()) {
    to_value_result->SetWithoutPathExpansion("Proto", (this->proto)->ToValue());

  }
  if (this->push_peer_info.get()) {
    to_value_result->SetWithoutPathExpansion("PushPeerInfo", (this->push_peer_info)->ToValue());

  }
  if (this->remote_cert_eku.get()) {
    to_value_result->SetWithoutPathExpansion("RemoteCertEKU", (this->remote_cert_eku)->ToValue());

  }
  if (this->remote_cert_ku.get()) {
    to_value_result->SetWithoutPathExpansion("RemoteCertKU", (this->remote_cert_ku)->ToValue());

  }
  if (this->remote_cert_tls.get()) {
    to_value_result->SetWithoutPathExpansion("RemoteCertTLS", (this->remote_cert_tls)->ToValue());

  }
  if (this->reneg_sec.get()) {
    to_value_result->SetWithoutPathExpansion("RenegSec", (this->reneg_sec)->ToValue());

  }
  if (this->save_credentials.get()) {
    to_value_result->SetWithoutPathExpansion("SaveCredentials", (this->save_credentials)->ToValue());

  }
  if (this->server_cape_ms.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCAPEMs", (this->server_cape_ms)->ToValue());

  }
  if (this->server_ca_refs.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCARefs", (this->server_ca_refs)->ToValue());

  }
  if (this->server_cert_ref.get()) {
    to_value_result->SetWithoutPathExpansion("ServerCertRef", (this->server_cert_ref)->ToValue());

  }
  if (this->server_poll_timeout.get()) {
    to_value_result->SetWithoutPathExpansion("ServerPollTimeout", (this->server_poll_timeout)->ToValue());

  }
  if (this->shaper.get()) {
    to_value_result->SetWithoutPathExpansion("Shaper", (this->shaper)->ToValue());

  }
  if (this->static_challenge.get()) {
    to_value_result->SetWithoutPathExpansion("StaticChallenge", (this->static_challenge)->ToValue());

  }
  if (this->tls_auth_contents.get()) {
    to_value_result->SetWithoutPathExpansion("TLSAuthContents", (this->tls_auth_contents)->ToValue());

  }
  if (this->tls_remote.get()) {
    to_value_result->SetWithoutPathExpansion("TLSRemote", (this->tls_remote)->ToValue());

  }
  if (this->tls_version_min.get()) {
    to_value_result->SetWithoutPathExpansion("TLSVersionMin", (this->tls_version_min)->ToValue());

  }
  if (this->user_authentication_type.get()) {
    to_value_result->SetWithoutPathExpansion("UserAuthenticationType", (this->user_authentication_type)->ToValue());

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("Username", (this->username)->ToValue());

  }
  if (this->verb.get()) {
    to_value_result->SetWithoutPathExpansion("Verb", (this->verb)->ToValue());

  }
  if (this->verify_hash.get()) {
    to_value_result->SetWithoutPathExpansion("VerifyHash", (this->verify_hash)->ToValue());

  }
  if (this->verify_x509.get()) {
    to_value_result->SetWithoutPathExpansion("VerifyX509", (this->verify_x509)->ToValue());

  }

  return to_value_result;
}


SIMLockStatus::SIMLockStatus()
: lock_enabled(false) {}

SIMLockStatus::~SIMLockStatus() = default;
SIMLockStatus::SIMLockStatus(SIMLockStatus&& rhs) = default;
SIMLockStatus& SIMLockStatus::operator=(SIMLockStatus&& rhs) = default;
// static
bool SIMLockStatus::Populate(
    const base::Value& value, SIMLockStatus* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* lock_type_value = dict->FindKey("LockType");
  if (!lock_type_value) {
    return false;
  }
  {
    auto* temp = lock_type_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->lock_type = *temp;
  }

  const base::Value* lock_enabled_value = dict->FindKey("LockEnabled");
  if (!lock_enabled_value) {
    return false;
  }
  {
    auto temp = lock_enabled_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->lock_enabled = temp.value();
  }

  const base::Value* retries_left_value = dict->FindKey("RetriesLeft");
  if (retries_left_value) {
    {
      auto temp = retries_left_value->GetIfInt();
      if (!temp.has_value()) {
        out->retries_left.reset();
        return false;
      }
      out->retries_left = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<SIMLockStatus> SIMLockStatus::FromValue(const base::Value& value) {
  auto out = std::make_unique<SIMLockStatus>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SIMLockStatus::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("LockType", std::make_unique<base::Value>(this->lock_type));

  to_value_result->SetWithoutPathExpansion("LockEnabled", std::make_unique<base::Value>(this->lock_enabled));

  if (this->retries_left.get()) {
    to_value_result->SetWithoutPathExpansion("RetriesLeft", std::make_unique<base::Value>(*this->retries_left));

  }

  return to_value_result;
}


ThirdPartyVPNProperties::ThirdPartyVPNProperties()
 {}

ThirdPartyVPNProperties::~ThirdPartyVPNProperties() = default;
ThirdPartyVPNProperties::ThirdPartyVPNProperties(ThirdPartyVPNProperties&& rhs) = default;
ThirdPartyVPNProperties& ThirdPartyVPNProperties::operator=(ThirdPartyVPNProperties&& rhs) = default;
// static
bool ThirdPartyVPNProperties::Populate(
    const base::Value& value, ThirdPartyVPNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* extension_id_value = dict->FindKey("ExtensionID");
  if (!extension_id_value) {
    return false;
  }
  {
    auto* temp = extension_id_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->extension_id = *temp;
  }

  const base::Value* provider_name_value = dict->FindKey("ProviderName");
  if (provider_name_value) {
    {
      auto* temp = provider_name_value->GetIfString();
      if (!temp) {
        out->provider_name.reset();
        return false;
      }
      out->provider_name = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<ThirdPartyVPNProperties> ThirdPartyVPNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ThirdPartyVPNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ThirdPartyVPNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("ExtensionID", std::make_unique<base::Value>(this->extension_id));

  if (this->provider_name.get()) {
    to_value_result->SetWithoutPathExpansion("ProviderName", std::make_unique<base::Value>(*this->provider_name));

  }

  return to_value_result;
}


ManagedThirdPartyVPNProperties::ManagedThirdPartyVPNProperties()
 {}

ManagedThirdPartyVPNProperties::~ManagedThirdPartyVPNProperties() = default;
ManagedThirdPartyVPNProperties::ManagedThirdPartyVPNProperties(ManagedThirdPartyVPNProperties&& rhs) = default;
ManagedThirdPartyVPNProperties& ManagedThirdPartyVPNProperties::operator=(ManagedThirdPartyVPNProperties&& rhs) = default;
// static
bool ManagedThirdPartyVPNProperties::Populate(
    const base::Value& value, ManagedThirdPartyVPNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* extension_id_value = dict->FindKey("ExtensionID");
  if (!extension_id_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!extension_id_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ManagedDOMString::Populate(*dictionary, &out->extension_id)) {
      return false;
    }
  }

  const base::Value* provider_name_value = dict->FindKey("ProviderName");
  if (provider_name_value) {
    {
      auto* temp = provider_name_value->GetIfString();
      if (!temp) {
        out->provider_name.reset();
        return false;
      }
      out->provider_name = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedThirdPartyVPNProperties> ManagedThirdPartyVPNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedThirdPartyVPNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedThirdPartyVPNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("ExtensionID", (this->extension_id).ToValue());

  if (this->provider_name.get()) {
    to_value_result->SetWithoutPathExpansion("ProviderName", std::make_unique<base::Value>(*this->provider_name));

  }

  return to_value_result;
}


CellularProperties::CellularProperties()
: activation_state(ACTIVATION_STATE_TYPE_NONE) {}

CellularProperties::~CellularProperties() = default;
CellularProperties::CellularProperties(CellularProperties&& rhs) = default;
CellularProperties& CellularProperties::operator=(CellularProperties&& rhs) = default;
// static
bool CellularProperties::Populate(
    const base::Value& value, CellularProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->activation_state = ACTIVATION_STATE_TYPE_NONE;
  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      auto temp = auto_connect_value->GetIfBool();
      if (!temp.has_value()) {
        out->auto_connect.reset();
        return false;
      }
      out->auto_connect = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* apn_value = dict->FindKey("APN");
  if (apn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!apn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<APNProperties>();
        if (!APNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->apn = std::move(temp);
      }
    }
  }

  const base::Value* apn_list_value = dict->FindKey("APNList");
  if (apn_list_value) {
    {
      const base::ListValue* list = nullptr;
      if (!apn_list_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->apn_list)) {
          return false;
        }
      }
    }
  }

  const base::Value* activation_type_value = dict->FindKey("ActivationType");
  if (activation_type_value) {
    {
      auto* temp = activation_type_value->GetIfString();
      if (!temp) {
        out->activation_type.reset();
        return false;
      }
      out->activation_type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* activation_state_value = dict->FindKey("ActivationState");
  if (activation_state_value) {
    {
      std::string activation_state_type_as_string;
      if (!activation_state_value->GetAsString(&activation_state_type_as_string)) {
        return false;
      }
      out->activation_state = ParseActivationStateType(activation_state_type_as_string);
      if (out->activation_state == ACTIVATION_STATE_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->activation_state = ACTIVATION_STATE_TYPE_NONE;
  }

  const base::Value* allow_roaming_value = dict->FindKey("AllowRoaming");
  if (allow_roaming_value) {
    {
      auto temp = allow_roaming_value->GetIfBool();
      if (!temp.has_value()) {
        out->allow_roaming.reset();
        return false;
      }
      out->allow_roaming = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* esn_value = dict->FindKey("ESN");
  if (esn_value) {
    {
      auto* temp = esn_value->GetIfString();
      if (!temp) {
        out->esn.reset();
        return false;
      }
      out->esn = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* family_value = dict->FindKey("Family");
  if (family_value) {
    {
      auto* temp = family_value->GetIfString();
      if (!temp) {
        out->family.reset();
        return false;
      }
      out->family = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* firmware_revision_value = dict->FindKey("FirmwareRevision");
  if (firmware_revision_value) {
    {
      auto* temp = firmware_revision_value->GetIfString();
      if (!temp) {
        out->firmware_revision.reset();
        return false;
      }
      out->firmware_revision = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* found_networks_value = dict->FindKey("FoundNetworks");
  if (found_networks_value) {
    {
      const base::ListValue* list = nullptr;
      if (!found_networks_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->found_networks)) {
          return false;
        }
      }
    }
  }

  const base::Value* hardware_revision_value = dict->FindKey("HardwareRevision");
  if (hardware_revision_value) {
    {
      auto* temp = hardware_revision_value->GetIfString();
      if (!temp) {
        out->hardware_revision.reset();
        return false;
      }
      out->hardware_revision = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* home_provider_value = dict->FindKey("HomeProvider");
  if (home_provider_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!home_provider_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CellularProviderProperties>();
        if (!CellularProviderProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->home_provider = std::move(temp);
      }
    }
  }

  const base::Value* iccid_value = dict->FindKey("ICCID");
  if (iccid_value) {
    {
      auto* temp = iccid_value->GetIfString();
      if (!temp) {
        out->iccid.reset();
        return false;
      }
      out->iccid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* imei_value = dict->FindKey("IMEI");
  if (imei_value) {
    {
      auto* temp = imei_value->GetIfString();
      if (!temp) {
        out->imei.reset();
        return false;
      }
      out->imei = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* last_good_apn_value = dict->FindKey("LastGoodAPN");
  if (last_good_apn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!last_good_apn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<APNProperties>();
        if (!APNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->last_good_apn = std::move(temp);
      }
    }
  }

  const base::Value* manufacturer_value = dict->FindKey("Manufacturer");
  if (manufacturer_value) {
    {
      auto* temp = manufacturer_value->GetIfString();
      if (!temp) {
        out->manufacturer.reset();
        return false;
      }
      out->manufacturer = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* mdn_value = dict->FindKey("MDN");
  if (mdn_value) {
    {
      auto* temp = mdn_value->GetIfString();
      if (!temp) {
        out->mdn.reset();
        return false;
      }
      out->mdn = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* meid_value = dict->FindKey("MEID");
  if (meid_value) {
    {
      auto* temp = meid_value->GetIfString();
      if (!temp) {
        out->meid.reset();
        return false;
      }
      out->meid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* min_value = dict->FindKey("MIN");
  if (min_value) {
    {
      auto* temp = min_value->GetIfString();
      if (!temp) {
        out->min.reset();
        return false;
      }
      out->min = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* model_id_value = dict->FindKey("ModelID");
  if (model_id_value) {
    {
      auto* temp = model_id_value->GetIfString();
      if (!temp) {
        out->model_id.reset();
        return false;
      }
      out->model_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* network_technology_value = dict->FindKey("NetworkTechnology");
  if (network_technology_value) {
    {
      auto* temp = network_technology_value->GetIfString();
      if (!temp) {
        out->network_technology.reset();
        return false;
      }
      out->network_technology = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* payment_portal_value = dict->FindKey("PaymentPortal");
  if (payment_portal_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!payment_portal_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<PaymentPortal>();
        if (!PaymentPortal::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->payment_portal = std::move(temp);
      }
    }
  }

  const base::Value* roaming_state_value = dict->FindKey("RoamingState");
  if (roaming_state_value) {
    {
      auto* temp = roaming_state_value->GetIfString();
      if (!temp) {
        out->roaming_state.reset();
        return false;
      }
      out->roaming_state = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* scanning_value = dict->FindKey("Scanning");
  if (scanning_value) {
    {
      auto temp = scanning_value->GetIfBool();
      if (!temp.has_value()) {
        out->scanning.reset();
        return false;
      }
      out->scanning = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* serving_operator_value = dict->FindKey("ServingOperator");
  if (serving_operator_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!serving_operator_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CellularProviderProperties>();
        if (!CellularProviderProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->serving_operator = std::move(temp);
      }
    }
  }

  const base::Value* sim_lock_status_value = dict->FindKey("SIMLockStatus");
  if (sim_lock_status_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!sim_lock_status_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<SIMLockStatus>();
        if (!SIMLockStatus::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->sim_lock_status = std::move(temp);
      }
    }
  }

  const base::Value* sim_present_value = dict->FindKey("SIMPresent");
  if (sim_present_value) {
    {
      auto temp = sim_present_value->GetIfBool();
      if (!temp.has_value()) {
        out->sim_present.reset();
        return false;
      }
      out->sim_present = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* signal_strength_value = dict->FindKey("SignalStrength");
  if (signal_strength_value) {
    {
      auto temp = signal_strength_value->GetIfInt();
      if (!temp.has_value()) {
        out->signal_strength.reset();
        return false;
      }
      out->signal_strength = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* support_network_scan_value = dict->FindKey("SupportNetworkScan");
  if (support_network_scan_value) {
    {
      auto temp = support_network_scan_value->GetIfBool();
      if (!temp.has_value()) {
        out->support_network_scan.reset();
        return false;
      }
      out->support_network_scan = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<CellularProperties> CellularProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<CellularProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CellularProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", std::make_unique<base::Value>(*this->auto_connect));

  }
  if (this->apn.get()) {
    to_value_result->SetWithoutPathExpansion("APN", (this->apn)->ToValue());

  }
  if (this->apn_list.get()) {
    to_value_result->SetWithoutPathExpansion("APNList", json_schema_compiler::util::CreateValueFromArray(*this->apn_list));

  }
  if (this->activation_type.get()) {
    to_value_result->SetWithoutPathExpansion("ActivationType", std::make_unique<base::Value>(*this->activation_type));

  }
  if (this->activation_state != ACTIVATION_STATE_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("ActivationState", std::make_unique<base::Value>(networking_private::ToString(this->activation_state)));

  }
  if (this->allow_roaming.get()) {
    to_value_result->SetWithoutPathExpansion("AllowRoaming", std::make_unique<base::Value>(*this->allow_roaming));

  }
  if (this->esn.get()) {
    to_value_result->SetWithoutPathExpansion("ESN", std::make_unique<base::Value>(*this->esn));

  }
  if (this->family.get()) {
    to_value_result->SetWithoutPathExpansion("Family", std::make_unique<base::Value>(*this->family));

  }
  if (this->firmware_revision.get()) {
    to_value_result->SetWithoutPathExpansion("FirmwareRevision", std::make_unique<base::Value>(*this->firmware_revision));

  }
  if (this->found_networks.get()) {
    to_value_result->SetWithoutPathExpansion("FoundNetworks", json_schema_compiler::util::CreateValueFromArray(*this->found_networks));

  }
  if (this->hardware_revision.get()) {
    to_value_result->SetWithoutPathExpansion("HardwareRevision", std::make_unique<base::Value>(*this->hardware_revision));

  }
  if (this->home_provider.get()) {
    to_value_result->SetWithoutPathExpansion("HomeProvider", (this->home_provider)->ToValue());

  }
  if (this->iccid.get()) {
    to_value_result->SetWithoutPathExpansion("ICCID", std::make_unique<base::Value>(*this->iccid));

  }
  if (this->imei.get()) {
    to_value_result->SetWithoutPathExpansion("IMEI", std::make_unique<base::Value>(*this->imei));

  }
  if (this->last_good_apn.get()) {
    to_value_result->SetWithoutPathExpansion("LastGoodAPN", (this->last_good_apn)->ToValue());

  }
  if (this->manufacturer.get()) {
    to_value_result->SetWithoutPathExpansion("Manufacturer", std::make_unique<base::Value>(*this->manufacturer));

  }
  if (this->mdn.get()) {
    to_value_result->SetWithoutPathExpansion("MDN", std::make_unique<base::Value>(*this->mdn));

  }
  if (this->meid.get()) {
    to_value_result->SetWithoutPathExpansion("MEID", std::make_unique<base::Value>(*this->meid));

  }
  if (this->min.get()) {
    to_value_result->SetWithoutPathExpansion("MIN", std::make_unique<base::Value>(*this->min));

  }
  if (this->model_id.get()) {
    to_value_result->SetWithoutPathExpansion("ModelID", std::make_unique<base::Value>(*this->model_id));

  }
  if (this->network_technology.get()) {
    to_value_result->SetWithoutPathExpansion("NetworkTechnology", std::make_unique<base::Value>(*this->network_technology));

  }
  if (this->payment_portal.get()) {
    to_value_result->SetWithoutPathExpansion("PaymentPortal", (this->payment_portal)->ToValue());

  }
  if (this->roaming_state.get()) {
    to_value_result->SetWithoutPathExpansion("RoamingState", std::make_unique<base::Value>(*this->roaming_state));

  }
  if (this->scanning.get()) {
    to_value_result->SetWithoutPathExpansion("Scanning", std::make_unique<base::Value>(*this->scanning));

  }
  if (this->serving_operator.get()) {
    to_value_result->SetWithoutPathExpansion("ServingOperator", (this->serving_operator)->ToValue());

  }
  if (this->sim_lock_status.get()) {
    to_value_result->SetWithoutPathExpansion("SIMLockStatus", (this->sim_lock_status)->ToValue());

  }
  if (this->sim_present.get()) {
    to_value_result->SetWithoutPathExpansion("SIMPresent", std::make_unique<base::Value>(*this->sim_present));

  }
  if (this->signal_strength.get()) {
    to_value_result->SetWithoutPathExpansion("SignalStrength", std::make_unique<base::Value>(*this->signal_strength));

  }
  if (this->support_network_scan.get()) {
    to_value_result->SetWithoutPathExpansion("SupportNetworkScan", std::make_unique<base::Value>(*this->support_network_scan));

  }

  return to_value_result;
}


ManagedCellularProperties::ManagedCellularProperties()
: activation_state(ACTIVATION_STATE_TYPE_NONE) {}

ManagedCellularProperties::~ManagedCellularProperties() = default;
ManagedCellularProperties::ManagedCellularProperties(ManagedCellularProperties&& rhs) = default;
ManagedCellularProperties& ManagedCellularProperties::operator=(ManagedCellularProperties&& rhs) = default;
// static
bool ManagedCellularProperties::Populate(
    const base::Value& value, ManagedCellularProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->activation_state = ACTIVATION_STATE_TYPE_NONE;
  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!auto_connect_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->auto_connect = std::move(temp);
      }
    }
  }

  const base::Value* apn_value = dict->FindKey("APN");
  if (apn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!apn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedAPNProperties>();
        if (!ManagedAPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->apn = std::move(temp);
      }
    }
  }

  const base::Value* apn_list_value = dict->FindKey("APNList");
  if (apn_list_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!apn_list_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedAPNList>();
        if (!ManagedAPNList::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->apn_list = std::move(temp);
      }
    }
  }

  const base::Value* activation_type_value = dict->FindKey("ActivationType");
  if (activation_type_value) {
    {
      auto* temp = activation_type_value->GetIfString();
      if (!temp) {
        out->activation_type.reset();
        return false;
      }
      out->activation_type = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* activation_state_value = dict->FindKey("ActivationState");
  if (activation_state_value) {
    {
      std::string activation_state_type_as_string;
      if (!activation_state_value->GetAsString(&activation_state_type_as_string)) {
        return false;
      }
      out->activation_state = ParseActivationStateType(activation_state_type_as_string);
      if (out->activation_state == ACTIVATION_STATE_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->activation_state = ACTIVATION_STATE_TYPE_NONE;
  }

  const base::Value* allow_roaming_value = dict->FindKey("AllowRoaming");
  if (allow_roaming_value) {
    {
      auto temp = allow_roaming_value->GetIfBool();
      if (!temp.has_value()) {
        out->allow_roaming.reset();
        return false;
      }
      out->allow_roaming = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* esn_value = dict->FindKey("ESN");
  if (esn_value) {
    {
      auto* temp = esn_value->GetIfString();
      if (!temp) {
        out->esn.reset();
        return false;
      }
      out->esn = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* family_value = dict->FindKey("Family");
  if (family_value) {
    {
      auto* temp = family_value->GetIfString();
      if (!temp) {
        out->family.reset();
        return false;
      }
      out->family = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* firmware_revision_value = dict->FindKey("FirmwareRevision");
  if (firmware_revision_value) {
    {
      auto* temp = firmware_revision_value->GetIfString();
      if (!temp) {
        out->firmware_revision.reset();
        return false;
      }
      out->firmware_revision = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* found_networks_value = dict->FindKey("FoundNetworks");
  if (found_networks_value) {
    {
      const base::ListValue* list = nullptr;
      if (!found_networks_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->found_networks)) {
          return false;
        }
      }
    }
  }

  const base::Value* hardware_revision_value = dict->FindKey("HardwareRevision");
  if (hardware_revision_value) {
    {
      auto* temp = hardware_revision_value->GetIfString();
      if (!temp) {
        out->hardware_revision.reset();
        return false;
      }
      out->hardware_revision = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* home_provider_value = dict->FindKey("HomeProvider");
  if (home_provider_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!home_provider_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CellularProviderProperties>();
        if (!CellularProviderProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->home_provider = std::move(temp);
      }
    }
  }

  const base::Value* iccid_value = dict->FindKey("ICCID");
  if (iccid_value) {
    {
      auto* temp = iccid_value->GetIfString();
      if (!temp) {
        out->iccid.reset();
        return false;
      }
      out->iccid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* imei_value = dict->FindKey("IMEI");
  if (imei_value) {
    {
      auto* temp = imei_value->GetIfString();
      if (!temp) {
        out->imei.reset();
        return false;
      }
      out->imei = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* last_good_apn_value = dict->FindKey("LastGoodAPN");
  if (last_good_apn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!last_good_apn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<APNProperties>();
        if (!APNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->last_good_apn = std::move(temp);
      }
    }
  }

  const base::Value* manufacturer_value = dict->FindKey("Manufacturer");
  if (manufacturer_value) {
    {
      auto* temp = manufacturer_value->GetIfString();
      if (!temp) {
        out->manufacturer.reset();
        return false;
      }
      out->manufacturer = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* mdn_value = dict->FindKey("MDN");
  if (mdn_value) {
    {
      auto* temp = mdn_value->GetIfString();
      if (!temp) {
        out->mdn.reset();
        return false;
      }
      out->mdn = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* meid_value = dict->FindKey("MEID");
  if (meid_value) {
    {
      auto* temp = meid_value->GetIfString();
      if (!temp) {
        out->meid.reset();
        return false;
      }
      out->meid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* min_value = dict->FindKey("MIN");
  if (min_value) {
    {
      auto* temp = min_value->GetIfString();
      if (!temp) {
        out->min.reset();
        return false;
      }
      out->min = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* model_id_value = dict->FindKey("ModelID");
  if (model_id_value) {
    {
      auto* temp = model_id_value->GetIfString();
      if (!temp) {
        out->model_id.reset();
        return false;
      }
      out->model_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* network_technology_value = dict->FindKey("NetworkTechnology");
  if (network_technology_value) {
    {
      auto* temp = network_technology_value->GetIfString();
      if (!temp) {
        out->network_technology.reset();
        return false;
      }
      out->network_technology = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* payment_portal_value = dict->FindKey("PaymentPortal");
  if (payment_portal_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!payment_portal_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<PaymentPortal>();
        if (!PaymentPortal::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->payment_portal = std::move(temp);
      }
    }
  }

  const base::Value* roaming_state_value = dict->FindKey("RoamingState");
  if (roaming_state_value) {
    {
      auto* temp = roaming_state_value->GetIfString();
      if (!temp) {
        out->roaming_state.reset();
        return false;
      }
      out->roaming_state = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* scanning_value = dict->FindKey("Scanning");
  if (scanning_value) {
    {
      auto temp = scanning_value->GetIfBool();
      if (!temp.has_value()) {
        out->scanning.reset();
        return false;
      }
      out->scanning = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* serving_operator_value = dict->FindKey("ServingOperator");
  if (serving_operator_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!serving_operator_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CellularProviderProperties>();
        if (!CellularProviderProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->serving_operator = std::move(temp);
      }
    }
  }

  const base::Value* sim_lock_status_value = dict->FindKey("SIMLockStatus");
  if (sim_lock_status_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!sim_lock_status_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<SIMLockStatus>();
        if (!SIMLockStatus::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->sim_lock_status = std::move(temp);
      }
    }
  }

  const base::Value* sim_present_value = dict->FindKey("SIMPresent");
  if (sim_present_value) {
    {
      auto temp = sim_present_value->GetIfBool();
      if (!temp.has_value()) {
        out->sim_present.reset();
        return false;
      }
      out->sim_present = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* signal_strength_value = dict->FindKey("SignalStrength");
  if (signal_strength_value) {
    {
      auto temp = signal_strength_value->GetIfInt();
      if (!temp.has_value()) {
        out->signal_strength.reset();
        return false;
      }
      out->signal_strength = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* support_network_scan_value = dict->FindKey("SupportNetworkScan");
  if (support_network_scan_value) {
    {
      auto temp = support_network_scan_value->GetIfBool();
      if (!temp.has_value()) {
        out->support_network_scan.reset();
        return false;
      }
      out->support_network_scan = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedCellularProperties> ManagedCellularProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedCellularProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedCellularProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", (this->auto_connect)->ToValue());

  }
  if (this->apn.get()) {
    to_value_result->SetWithoutPathExpansion("APN", (this->apn)->ToValue());

  }
  if (this->apn_list.get()) {
    to_value_result->SetWithoutPathExpansion("APNList", (this->apn_list)->ToValue());

  }
  if (this->activation_type.get()) {
    to_value_result->SetWithoutPathExpansion("ActivationType", std::make_unique<base::Value>(*this->activation_type));

  }
  if (this->activation_state != ACTIVATION_STATE_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("ActivationState", std::make_unique<base::Value>(networking_private::ToString(this->activation_state)));

  }
  if (this->allow_roaming.get()) {
    to_value_result->SetWithoutPathExpansion("AllowRoaming", std::make_unique<base::Value>(*this->allow_roaming));

  }
  if (this->esn.get()) {
    to_value_result->SetWithoutPathExpansion("ESN", std::make_unique<base::Value>(*this->esn));

  }
  if (this->family.get()) {
    to_value_result->SetWithoutPathExpansion("Family", std::make_unique<base::Value>(*this->family));

  }
  if (this->firmware_revision.get()) {
    to_value_result->SetWithoutPathExpansion("FirmwareRevision", std::make_unique<base::Value>(*this->firmware_revision));

  }
  if (this->found_networks.get()) {
    to_value_result->SetWithoutPathExpansion("FoundNetworks", json_schema_compiler::util::CreateValueFromArray(*this->found_networks));

  }
  if (this->hardware_revision.get()) {
    to_value_result->SetWithoutPathExpansion("HardwareRevision", std::make_unique<base::Value>(*this->hardware_revision));

  }
  if (this->home_provider.get()) {
    to_value_result->SetWithoutPathExpansion("HomeProvider", (this->home_provider)->ToValue());

  }
  if (this->iccid.get()) {
    to_value_result->SetWithoutPathExpansion("ICCID", std::make_unique<base::Value>(*this->iccid));

  }
  if (this->imei.get()) {
    to_value_result->SetWithoutPathExpansion("IMEI", std::make_unique<base::Value>(*this->imei));

  }
  if (this->last_good_apn.get()) {
    to_value_result->SetWithoutPathExpansion("LastGoodAPN", (this->last_good_apn)->ToValue());

  }
  if (this->manufacturer.get()) {
    to_value_result->SetWithoutPathExpansion("Manufacturer", std::make_unique<base::Value>(*this->manufacturer));

  }
  if (this->mdn.get()) {
    to_value_result->SetWithoutPathExpansion("MDN", std::make_unique<base::Value>(*this->mdn));

  }
  if (this->meid.get()) {
    to_value_result->SetWithoutPathExpansion("MEID", std::make_unique<base::Value>(*this->meid));

  }
  if (this->min.get()) {
    to_value_result->SetWithoutPathExpansion("MIN", std::make_unique<base::Value>(*this->min));

  }
  if (this->model_id.get()) {
    to_value_result->SetWithoutPathExpansion("ModelID", std::make_unique<base::Value>(*this->model_id));

  }
  if (this->network_technology.get()) {
    to_value_result->SetWithoutPathExpansion("NetworkTechnology", std::make_unique<base::Value>(*this->network_technology));

  }
  if (this->payment_portal.get()) {
    to_value_result->SetWithoutPathExpansion("PaymentPortal", (this->payment_portal)->ToValue());

  }
  if (this->roaming_state.get()) {
    to_value_result->SetWithoutPathExpansion("RoamingState", std::make_unique<base::Value>(*this->roaming_state));

  }
  if (this->scanning.get()) {
    to_value_result->SetWithoutPathExpansion("Scanning", std::make_unique<base::Value>(*this->scanning));

  }
  if (this->serving_operator.get()) {
    to_value_result->SetWithoutPathExpansion("ServingOperator", (this->serving_operator)->ToValue());

  }
  if (this->sim_lock_status.get()) {
    to_value_result->SetWithoutPathExpansion("SIMLockStatus", (this->sim_lock_status)->ToValue());

  }
  if (this->sim_present.get()) {
    to_value_result->SetWithoutPathExpansion("SIMPresent", std::make_unique<base::Value>(*this->sim_present));

  }
  if (this->signal_strength.get()) {
    to_value_result->SetWithoutPathExpansion("SignalStrength", std::make_unique<base::Value>(*this->signal_strength));

  }
  if (this->support_network_scan.get()) {
    to_value_result->SetWithoutPathExpansion("SupportNetworkScan", std::make_unique<base::Value>(*this->support_network_scan));

  }

  return to_value_result;
}


CellularStateProperties::CellularStateProperties()
: activation_state(ACTIVATION_STATE_TYPE_NONE) {}

CellularStateProperties::~CellularStateProperties() = default;
CellularStateProperties::CellularStateProperties(CellularStateProperties&& rhs) = default;
CellularStateProperties& CellularStateProperties::operator=(CellularStateProperties&& rhs) = default;
// static
bool CellularStateProperties::Populate(
    const base::Value& value, CellularStateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->activation_state = ACTIVATION_STATE_TYPE_NONE;
  const base::Value* activation_state_value = dict->FindKey("ActivationState");
  if (activation_state_value) {
    {
      std::string activation_state_type_as_string;
      if (!activation_state_value->GetAsString(&activation_state_type_as_string)) {
        return false;
      }
      out->activation_state = ParseActivationStateType(activation_state_type_as_string);
      if (out->activation_state == ACTIVATION_STATE_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->activation_state = ACTIVATION_STATE_TYPE_NONE;
  }

  const base::Value* eid_value = dict->FindKey("EID");
  if (eid_value) {
    {
      auto* temp = eid_value->GetIfString();
      if (!temp) {
        out->eid.reset();
        return false;
      }
      out->eid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* iccid_value = dict->FindKey("ICCID");
  if (iccid_value) {
    {
      auto* temp = iccid_value->GetIfString();
      if (!temp) {
        out->iccid.reset();
        return false;
      }
      out->iccid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* network_technology_value = dict->FindKey("NetworkTechnology");
  if (network_technology_value) {
    {
      auto* temp = network_technology_value->GetIfString();
      if (!temp) {
        out->network_technology.reset();
        return false;
      }
      out->network_technology = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* roaming_state_value = dict->FindKey("RoamingState");
  if (roaming_state_value) {
    {
      auto* temp = roaming_state_value->GetIfString();
      if (!temp) {
        out->roaming_state.reset();
        return false;
      }
      out->roaming_state = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* scanning_value = dict->FindKey("Scanning");
  if (scanning_value) {
    {
      auto temp = scanning_value->GetIfBool();
      if (!temp.has_value()) {
        out->scanning.reset();
        return false;
      }
      out->scanning = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* sim_present_value = dict->FindKey("SIMPresent");
  if (sim_present_value) {
    {
      auto temp = sim_present_value->GetIfBool();
      if (!temp.has_value()) {
        out->sim_present.reset();
        return false;
      }
      out->sim_present = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* signal_strength_value = dict->FindKey("SignalStrength");
  if (signal_strength_value) {
    {
      auto temp = signal_strength_value->GetIfInt();
      if (!temp.has_value()) {
        out->signal_strength.reset();
        return false;
      }
      out->signal_strength = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<CellularStateProperties> CellularStateProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<CellularStateProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CellularStateProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->activation_state != ACTIVATION_STATE_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("ActivationState", std::make_unique<base::Value>(networking_private::ToString(this->activation_state)));

  }
  if (this->eid.get()) {
    to_value_result->SetWithoutPathExpansion("EID", std::make_unique<base::Value>(*this->eid));

  }
  if (this->iccid.get()) {
    to_value_result->SetWithoutPathExpansion("ICCID", std::make_unique<base::Value>(*this->iccid));

  }
  if (this->network_technology.get()) {
    to_value_result->SetWithoutPathExpansion("NetworkTechnology", std::make_unique<base::Value>(*this->network_technology));

  }
  if (this->roaming_state.get()) {
    to_value_result->SetWithoutPathExpansion("RoamingState", std::make_unique<base::Value>(*this->roaming_state));

  }
  if (this->scanning.get()) {
    to_value_result->SetWithoutPathExpansion("Scanning", std::make_unique<base::Value>(*this->scanning));

  }
  if (this->sim_present.get()) {
    to_value_result->SetWithoutPathExpansion("SIMPresent", std::make_unique<base::Value>(*this->sim_present));

  }
  if (this->signal_strength.get()) {
    to_value_result->SetWithoutPathExpansion("SignalStrength", std::make_unique<base::Value>(*this->signal_strength));

  }

  return to_value_result;
}


EAPStateProperties::EAPStateProperties()
 {}

EAPStateProperties::~EAPStateProperties() = default;
EAPStateProperties::EAPStateProperties(EAPStateProperties&& rhs) = default;
EAPStateProperties& EAPStateProperties::operator=(EAPStateProperties&& rhs) = default;
// static
bool EAPStateProperties::Populate(
    const base::Value& value, EAPStateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* outer_value = dict->FindKey("Outer");
  if (outer_value) {
    {
      auto* temp = outer_value->GetIfString();
      if (!temp) {
        out->outer.reset();
        return false;
      }
      out->outer = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<EAPStateProperties> EAPStateProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<EAPStateProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EAPStateProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->outer.get()) {
    to_value_result->SetWithoutPathExpansion("Outer", std::make_unique<base::Value>(*this->outer));

  }

  return to_value_result;
}


EthernetProperties::EthernetProperties()
 {}

EthernetProperties::~EthernetProperties() = default;
EthernetProperties::EthernetProperties(EthernetProperties&& rhs) = default;
EthernetProperties& EthernetProperties::operator=(EthernetProperties&& rhs) = default;
// static
bool EthernetProperties::Populate(
    const base::Value& value, EthernetProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      auto temp = auto_connect_value->GetIfBool();
      if (!temp.has_value()) {
        out->auto_connect.reset();
        return false;
      }
      out->auto_connect = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* authentication_value = dict->FindKey("Authentication");
  if (authentication_value) {
    {
      auto* temp = authentication_value->GetIfString();
      if (!temp) {
        out->authentication.reset();
        return false;
      }
      out->authentication = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* eap_value = dict->FindKey("EAP");
  if (eap_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!eap_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<EAPProperties>();
        if (!EAPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->eap = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<EthernetProperties> EthernetProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<EthernetProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EthernetProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", std::make_unique<base::Value>(*this->auto_connect));

  }
  if (this->authentication.get()) {
    to_value_result->SetWithoutPathExpansion("Authentication", std::make_unique<base::Value>(*this->authentication));

  }
  if (this->eap.get()) {
    to_value_result->SetWithoutPathExpansion("EAP", (this->eap)->ToValue());

  }

  return to_value_result;
}


ManagedEthernetProperties::ManagedEthernetProperties()
 {}

ManagedEthernetProperties::~ManagedEthernetProperties() = default;
ManagedEthernetProperties::ManagedEthernetProperties(ManagedEthernetProperties&& rhs) = default;
ManagedEthernetProperties& ManagedEthernetProperties::operator=(ManagedEthernetProperties&& rhs) = default;
// static
bool ManagedEthernetProperties::Populate(
    const base::Value& value, ManagedEthernetProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!auto_connect_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->auto_connect = std::move(temp);
      }
    }
  }

  const base::Value* authentication_value = dict->FindKey("Authentication");
  if (authentication_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!authentication_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->authentication = std::move(temp);
      }
    }
  }

  const base::Value* eap_value = dict->FindKey("EAP");
  if (eap_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!eap_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedEAPProperties>();
        if (!ManagedEAPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->eap = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedEthernetProperties> ManagedEthernetProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedEthernetProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedEthernetProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", (this->auto_connect)->ToValue());

  }
  if (this->authentication.get()) {
    to_value_result->SetWithoutPathExpansion("Authentication", (this->authentication)->ToValue());

  }
  if (this->eap.get()) {
    to_value_result->SetWithoutPathExpansion("EAP", (this->eap)->ToValue());

  }

  return to_value_result;
}


EthernetStateProperties::EthernetStateProperties()
 {}

EthernetStateProperties::~EthernetStateProperties() = default;
EthernetStateProperties::EthernetStateProperties(EthernetStateProperties&& rhs) = default;
EthernetStateProperties& EthernetStateProperties::operator=(EthernetStateProperties&& rhs) = default;
// static
bool EthernetStateProperties::Populate(
    const base::Value& value, EthernetStateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* authentication_value = dict->FindKey("Authentication");
  if (!authentication_value) {
    return false;
  }
  {
    auto* temp = authentication_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->authentication = *temp;
  }

  return true;
}

// static
std::unique_ptr<EthernetStateProperties> EthernetStateProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<EthernetStateProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EthernetStateProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Authentication", std::make_unique<base::Value>(this->authentication));


  return to_value_result;
}


TetherProperties::TetherProperties()
: has_connected_to_host(false) {}

TetherProperties::~TetherProperties() = default;
TetherProperties::TetherProperties(TetherProperties&& rhs) = default;
TetherProperties& TetherProperties::operator=(TetherProperties&& rhs) = default;
// static
bool TetherProperties::Populate(
    const base::Value& value, TetherProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* battery_percentage_value = dict->FindKey("BatteryPercentage");
  if (battery_percentage_value) {
    {
      auto temp = battery_percentage_value->GetIfInt();
      if (!temp.has_value()) {
        out->battery_percentage.reset();
        return false;
      }
      out->battery_percentage = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* carrier_value = dict->FindKey("Carrier");
  if (carrier_value) {
    {
      auto* temp = carrier_value->GetIfString();
      if (!temp) {
        out->carrier.reset();
        return false;
      }
      out->carrier = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* has_connected_to_host_value = dict->FindKey("HasConnectedToHost");
  if (!has_connected_to_host_value) {
    return false;
  }
  {
    auto temp = has_connected_to_host_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->has_connected_to_host = temp.value();
  }

  const base::Value* signal_strength_value = dict->FindKey("SignalStrength");
  if (signal_strength_value) {
    {
      auto temp = signal_strength_value->GetIfInt();
      if (!temp.has_value()) {
        out->signal_strength.reset();
        return false;
      }
      out->signal_strength = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<TetherProperties> TetherProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<TetherProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> TetherProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->battery_percentage.get()) {
    to_value_result->SetWithoutPathExpansion("BatteryPercentage", std::make_unique<base::Value>(*this->battery_percentage));

  }
  if (this->carrier.get()) {
    to_value_result->SetWithoutPathExpansion("Carrier", std::make_unique<base::Value>(*this->carrier));

  }
  to_value_result->SetWithoutPathExpansion("HasConnectedToHost", std::make_unique<base::Value>(this->has_connected_to_host));

  if (this->signal_strength.get()) {
    to_value_result->SetWithoutPathExpansion("SignalStrength", std::make_unique<base::Value>(*this->signal_strength));

  }

  return to_value_result;
}


VPNProperties::VPNProperties()
 {}

VPNProperties::~VPNProperties() = default;
VPNProperties::VPNProperties(VPNProperties&& rhs) = default;
VPNProperties& VPNProperties::operator=(VPNProperties&& rhs) = default;
// static
bool VPNProperties::Populate(
    const base::Value& value, VPNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      auto temp = auto_connect_value->GetIfBool();
      if (!temp.has_value()) {
        out->auto_connect.reset();
        return false;
      }
      out->auto_connect = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* host_value = dict->FindKey("Host");
  if (host_value) {
    {
      auto* temp = host_value->GetIfString();
      if (!temp) {
        out->host.reset();
        return false;
      }
      out->host = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* i_psec_value = dict->FindKey("IPsec");
  if (i_psec_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!i_psec_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IPSecProperties>();
        if (!IPSecProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->i_psec = std::move(temp);
      }
    }
  }

  const base::Value* l2tp_value = dict->FindKey("L2TP");
  if (l2tp_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!l2tp_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<L2TPProperties>();
        if (!L2TPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->l2tp = std::move(temp);
      }
    }
  }

  const base::Value* open_vpn_value = dict->FindKey("OpenVPN");
  if (open_vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!open_vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<OpenVPNProperties>();
        if (!OpenVPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->open_vpn = std::move(temp);
      }
    }
  }

  const base::Value* third_party_vpn_value = dict->FindKey("ThirdPartyVPN");
  if (third_party_vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!third_party_vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ThirdPartyVPNProperties>();
        if (!ThirdPartyVPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->third_party_vpn = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (type_value) {
    {
      auto* temp = type_value->GetIfString();
      if (!temp) {
        out->type.reset();
        return false;
      }
      out->type = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<VPNProperties> VPNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<VPNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> VPNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", std::make_unique<base::Value>(*this->auto_connect));

  }
  if (this->host.get()) {
    to_value_result->SetWithoutPathExpansion("Host", std::make_unique<base::Value>(*this->host));

  }
  if (this->i_psec.get()) {
    to_value_result->SetWithoutPathExpansion("IPsec", (this->i_psec)->ToValue());

  }
  if (this->l2tp.get()) {
    to_value_result->SetWithoutPathExpansion("L2TP", (this->l2tp)->ToValue());

  }
  if (this->open_vpn.get()) {
    to_value_result->SetWithoutPathExpansion("OpenVPN", (this->open_vpn)->ToValue());

  }
  if (this->third_party_vpn.get()) {
    to_value_result->SetWithoutPathExpansion("ThirdPartyVPN", (this->third_party_vpn)->ToValue());

  }
  if (this->type.get()) {
    to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(*this->type));

  }

  return to_value_result;
}


ManagedVPNProperties::ManagedVPNProperties()
 {}

ManagedVPNProperties::~ManagedVPNProperties() = default;
ManagedVPNProperties::ManagedVPNProperties(ManagedVPNProperties&& rhs) = default;
ManagedVPNProperties& ManagedVPNProperties::operator=(ManagedVPNProperties&& rhs) = default;
// static
bool ManagedVPNProperties::Populate(
    const base::Value& value, ManagedVPNProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!auto_connect_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->auto_connect = std::move(temp);
      }
    }
  }

  const base::Value* host_value = dict->FindKey("Host");
  if (host_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!host_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->host = std::move(temp);
      }
    }
  }

  const base::Value* i_psec_value = dict->FindKey("IPsec");
  if (i_psec_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!i_psec_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedIPSecProperties>();
        if (!ManagedIPSecProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->i_psec = std::move(temp);
      }
    }
  }

  const base::Value* l2tp_value = dict->FindKey("L2TP");
  if (l2tp_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!l2tp_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedL2TPProperties>();
        if (!ManagedL2TPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->l2tp = std::move(temp);
      }
    }
  }

  const base::Value* open_vpn_value = dict->FindKey("OpenVPN");
  if (open_vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!open_vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedOpenVPNProperties>();
        if (!ManagedOpenVPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->open_vpn = std::move(temp);
      }
    }
  }

  const base::Value* third_party_vpn_value = dict->FindKey("ThirdPartyVPN");
  if (third_party_vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!third_party_vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedThirdPartyVPNProperties>();
        if (!ManagedThirdPartyVPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->third_party_vpn = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->type = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedVPNProperties> ManagedVPNProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedVPNProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedVPNProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", (this->auto_connect)->ToValue());

  }
  if (this->host.get()) {
    to_value_result->SetWithoutPathExpansion("Host", (this->host)->ToValue());

  }
  if (this->i_psec.get()) {
    to_value_result->SetWithoutPathExpansion("IPsec", (this->i_psec)->ToValue());

  }
  if (this->l2tp.get()) {
    to_value_result->SetWithoutPathExpansion("L2TP", (this->l2tp)->ToValue());

  }
  if (this->open_vpn.get()) {
    to_value_result->SetWithoutPathExpansion("OpenVPN", (this->open_vpn)->ToValue());

  }
  if (this->third_party_vpn.get()) {
    to_value_result->SetWithoutPathExpansion("ThirdPartyVPN", (this->third_party_vpn)->ToValue());

  }
  if (this->type.get()) {
    to_value_result->SetWithoutPathExpansion("Type", (this->type)->ToValue());

  }

  return to_value_result;
}


VPNStateProperties::VPNStateProperties()
 {}

VPNStateProperties::~VPNStateProperties() = default;
VPNStateProperties::VPNStateProperties(VPNStateProperties&& rhs) = default;
VPNStateProperties& VPNStateProperties::operator=(VPNStateProperties&& rhs) = default;
// static
bool VPNStateProperties::Populate(
    const base::Value& value, VPNStateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* type_value = dict->FindKey("Type");
  if (!type_value) {
    return false;
  }
  {
    auto* temp = type_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->type = *temp;
  }

  const base::Value* i_psec_value = dict->FindKey("IPsec");
  if (i_psec_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!i_psec_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IPSecProperties>();
        if (!IPSecProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->i_psec = std::move(temp);
      }
    }
  }

  const base::Value* third_party_vpn_value = dict->FindKey("ThirdPartyVPN");
  if (third_party_vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!third_party_vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ThirdPartyVPNProperties>();
        if (!ThirdPartyVPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->third_party_vpn = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<VPNStateProperties> VPNStateProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<VPNStateProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> VPNStateProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(this->type));

  if (this->i_psec.get()) {
    to_value_result->SetWithoutPathExpansion("IPsec", (this->i_psec)->ToValue());

  }
  if (this->third_party_vpn.get()) {
    to_value_result->SetWithoutPathExpansion("ThirdPartyVPN", (this->third_party_vpn)->ToValue());

  }

  return to_value_result;
}


WiFiProperties::WiFiProperties()
 {}

WiFiProperties::~WiFiProperties() = default;
WiFiProperties::WiFiProperties(WiFiProperties&& rhs) = default;
WiFiProperties& WiFiProperties::operator=(WiFiProperties&& rhs) = default;
// static
bool WiFiProperties::Populate(
    const base::Value& value, WiFiProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* allow_gateway_arp_polling_value = dict->FindKey("AllowGatewayARPPolling");
  if (allow_gateway_arp_polling_value) {
    {
      auto temp = allow_gateway_arp_polling_value->GetIfBool();
      if (!temp.has_value()) {
        out->allow_gateway_arp_polling.reset();
        return false;
      }
      out->allow_gateway_arp_polling = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      auto temp = auto_connect_value->GetIfBool();
      if (!temp.has_value()) {
        out->auto_connect.reset();
        return false;
      }
      out->auto_connect = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* bssid_value = dict->FindKey("BSSID");
  if (bssid_value) {
    {
      auto* temp = bssid_value->GetIfString();
      if (!temp) {
        out->bssid.reset();
        return false;
      }
      out->bssid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* eap_value = dict->FindKey("EAP");
  if (eap_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!eap_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<EAPProperties>();
        if (!EAPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->eap = std::move(temp);
      }
    }
  }

  const base::Value* frequency_value = dict->FindKey("Frequency");
  if (frequency_value) {
    {
      auto temp = frequency_value->GetIfInt();
      if (!temp.has_value()) {
        out->frequency.reset();
        return false;
      }
      out->frequency = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* frequency_list_value = dict->FindKey("FrequencyList");
  if (frequency_list_value) {
    {
      const base::ListValue* list = nullptr;
      if (!frequency_list_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->frequency_list)) {
          return false;
        }
      }
    }
  }

  const base::Value* hex_ssid_value = dict->FindKey("HexSSID");
  if (hex_ssid_value) {
    {
      auto* temp = hex_ssid_value->GetIfString();
      if (!temp) {
        out->hex_ssid.reset();
        return false;
      }
      out->hex_ssid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* hidden_ssid_value = dict->FindKey("HiddenSSID");
  if (hidden_ssid_value) {
    {
      auto temp = hidden_ssid_value->GetIfBool();
      if (!temp.has_value()) {
        out->hidden_ssid.reset();
        return false;
      }
      out->hidden_ssid = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* passphrase_value = dict->FindKey("Passphrase");
  if (passphrase_value) {
    {
      auto* temp = passphrase_value->GetIfString();
      if (!temp) {
        out->passphrase.reset();
        return false;
      }
      out->passphrase = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* ssid_value = dict->FindKey("SSID");
  if (ssid_value) {
    {
      auto* temp = ssid_value->GetIfString();
      if (!temp) {
        out->ssid.reset();
        return false;
      }
      out->ssid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* security_value = dict->FindKey("Security");
  if (security_value) {
    {
      auto* temp = security_value->GetIfString();
      if (!temp) {
        out->security.reset();
        return false;
      }
      out->security = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* signal_strength_value = dict->FindKey("SignalStrength");
  if (signal_strength_value) {
    {
      auto temp = signal_strength_value->GetIfInt();
      if (!temp.has_value()) {
        out->signal_strength.reset();
        return false;
      }
      out->signal_strength = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<WiFiProperties> WiFiProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<WiFiProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> WiFiProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->allow_gateway_arp_polling.get()) {
    to_value_result->SetWithoutPathExpansion("AllowGatewayARPPolling", std::make_unique<base::Value>(*this->allow_gateway_arp_polling));

  }
  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", std::make_unique<base::Value>(*this->auto_connect));

  }
  if (this->bssid.get()) {
    to_value_result->SetWithoutPathExpansion("BSSID", std::make_unique<base::Value>(*this->bssid));

  }
  if (this->eap.get()) {
    to_value_result->SetWithoutPathExpansion("EAP", (this->eap)->ToValue());

  }
  if (this->frequency.get()) {
    to_value_result->SetWithoutPathExpansion("Frequency", std::make_unique<base::Value>(*this->frequency));

  }
  if (this->frequency_list.get()) {
    to_value_result->SetWithoutPathExpansion("FrequencyList", json_schema_compiler::util::CreateValueFromArray(*this->frequency_list));

  }
  if (this->hex_ssid.get()) {
    to_value_result->SetWithoutPathExpansion("HexSSID", std::make_unique<base::Value>(*this->hex_ssid));

  }
  if (this->hidden_ssid.get()) {
    to_value_result->SetWithoutPathExpansion("HiddenSSID", std::make_unique<base::Value>(*this->hidden_ssid));

  }
  if (this->passphrase.get()) {
    to_value_result->SetWithoutPathExpansion("Passphrase", std::make_unique<base::Value>(*this->passphrase));

  }
  if (this->ssid.get()) {
    to_value_result->SetWithoutPathExpansion("SSID", std::make_unique<base::Value>(*this->ssid));

  }
  if (this->security.get()) {
    to_value_result->SetWithoutPathExpansion("Security", std::make_unique<base::Value>(*this->security));

  }
  if (this->signal_strength.get()) {
    to_value_result->SetWithoutPathExpansion("SignalStrength", std::make_unique<base::Value>(*this->signal_strength));

  }

  return to_value_result;
}


ManagedWiFiProperties::ManagedWiFiProperties()
 {}

ManagedWiFiProperties::~ManagedWiFiProperties() = default;
ManagedWiFiProperties::ManagedWiFiProperties(ManagedWiFiProperties&& rhs) = default;
ManagedWiFiProperties& ManagedWiFiProperties::operator=(ManagedWiFiProperties&& rhs) = default;
// static
bool ManagedWiFiProperties::Populate(
    const base::Value& value, ManagedWiFiProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* allow_gateway_arp_polling_value = dict->FindKey("AllowGatewayARPPolling");
  if (allow_gateway_arp_polling_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!allow_gateway_arp_polling_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->allow_gateway_arp_polling = std::move(temp);
      }
    }
  }

  const base::Value* auto_connect_value = dict->FindKey("AutoConnect");
  if (auto_connect_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!auto_connect_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->auto_connect = std::move(temp);
      }
    }
  }

  const base::Value* bssid_value = dict->FindKey("BSSID");
  if (bssid_value) {
    {
      auto* temp = bssid_value->GetIfString();
      if (!temp) {
        out->bssid.reset();
        return false;
      }
      out->bssid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* eap_value = dict->FindKey("EAP");
  if (eap_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!eap_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedEAPProperties>();
        if (!ManagedEAPProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->eap = std::move(temp);
      }
    }
  }

  const base::Value* frequency_value = dict->FindKey("Frequency");
  if (frequency_value) {
    {
      auto temp = frequency_value->GetIfInt();
      if (!temp.has_value()) {
        out->frequency.reset();
        return false;
      }
      out->frequency = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* frequency_list_value = dict->FindKey("FrequencyList");
  if (frequency_list_value) {
    {
      const base::ListValue* list = nullptr;
      if (!frequency_list_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->frequency_list)) {
          return false;
        }
      }
    }
  }

  const base::Value* hex_ssid_value = dict->FindKey("HexSSID");
  if (hex_ssid_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!hex_ssid_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->hex_ssid = std::move(temp);
      }
    }
  }

  const base::Value* hidden_ssid_value = dict->FindKey("HiddenSSID");
  if (hidden_ssid_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!hidden_ssid_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->hidden_ssid = std::move(temp);
      }
    }
  }

  const base::Value* passphrase_value = dict->FindKey("Passphrase");
  if (passphrase_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!passphrase_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->passphrase = std::move(temp);
      }
    }
  }

  const base::Value* ssid_value = dict->FindKey("SSID");
  if (ssid_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ssid_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ssid = std::move(temp);
      }
    }
  }

  const base::Value* security_value = dict->FindKey("Security");
  if (!security_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!security_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!ManagedDOMString::Populate(*dictionary, &out->security)) {
      return false;
    }
  }

  const base::Value* signal_strength_value = dict->FindKey("SignalStrength");
  if (signal_strength_value) {
    {
      auto temp = signal_strength_value->GetIfInt();
      if (!temp.has_value()) {
        out->signal_strength.reset();
        return false;
      }
      out->signal_strength = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedWiFiProperties> ManagedWiFiProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedWiFiProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedWiFiProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->allow_gateway_arp_polling.get()) {
    to_value_result->SetWithoutPathExpansion("AllowGatewayARPPolling", (this->allow_gateway_arp_polling)->ToValue());

  }
  if (this->auto_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AutoConnect", (this->auto_connect)->ToValue());

  }
  if (this->bssid.get()) {
    to_value_result->SetWithoutPathExpansion("BSSID", std::make_unique<base::Value>(*this->bssid));

  }
  if (this->eap.get()) {
    to_value_result->SetWithoutPathExpansion("EAP", (this->eap)->ToValue());

  }
  if (this->frequency.get()) {
    to_value_result->SetWithoutPathExpansion("Frequency", std::make_unique<base::Value>(*this->frequency));

  }
  if (this->frequency_list.get()) {
    to_value_result->SetWithoutPathExpansion("FrequencyList", json_schema_compiler::util::CreateValueFromArray(*this->frequency_list));

  }
  if (this->hex_ssid.get()) {
    to_value_result->SetWithoutPathExpansion("HexSSID", (this->hex_ssid)->ToValue());

  }
  if (this->hidden_ssid.get()) {
    to_value_result->SetWithoutPathExpansion("HiddenSSID", (this->hidden_ssid)->ToValue());

  }
  if (this->passphrase.get()) {
    to_value_result->SetWithoutPathExpansion("Passphrase", (this->passphrase)->ToValue());

  }
  if (this->ssid.get()) {
    to_value_result->SetWithoutPathExpansion("SSID", (this->ssid)->ToValue());

  }
  to_value_result->SetWithoutPathExpansion("Security", (this->security).ToValue());

  if (this->signal_strength.get()) {
    to_value_result->SetWithoutPathExpansion("SignalStrength", std::make_unique<base::Value>(*this->signal_strength));

  }

  return to_value_result;
}


WiFiStateProperties::WiFiStateProperties()
 {}

WiFiStateProperties::~WiFiStateProperties() = default;
WiFiStateProperties::WiFiStateProperties(WiFiStateProperties&& rhs) = default;
WiFiStateProperties& WiFiStateProperties::operator=(WiFiStateProperties&& rhs) = default;
// static
bool WiFiStateProperties::Populate(
    const base::Value& value, WiFiStateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* bssid_value = dict->FindKey("BSSID");
  if (bssid_value) {
    {
      auto* temp = bssid_value->GetIfString();
      if (!temp) {
        out->bssid.reset();
        return false;
      }
      out->bssid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* eap_value = dict->FindKey("EAP");
  if (eap_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!eap_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<EAPStateProperties>();
        if (!EAPStateProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->eap = std::move(temp);
      }
    }
  }

  const base::Value* frequency_value = dict->FindKey("Frequency");
  if (frequency_value) {
    {
      auto temp = frequency_value->GetIfInt();
      if (!temp.has_value()) {
        out->frequency.reset();
        return false;
      }
      out->frequency = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* hex_ssid_value = dict->FindKey("HexSSID");
  if (hex_ssid_value) {
    {
      auto* temp = hex_ssid_value->GetIfString();
      if (!temp) {
        out->hex_ssid.reset();
        return false;
      }
      out->hex_ssid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* security_value = dict->FindKey("Security");
  if (!security_value) {
    return false;
  }
  {
    auto* temp = security_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->security = *temp;
  }

  const base::Value* signal_strength_value = dict->FindKey("SignalStrength");
  if (signal_strength_value) {
    {
      auto temp = signal_strength_value->GetIfInt();
      if (!temp.has_value()) {
        out->signal_strength.reset();
        return false;
      }
      out->signal_strength = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* ssid_value = dict->FindKey("SSID");
  if (ssid_value) {
    {
      auto* temp = ssid_value->GetIfString();
      if (!temp) {
        out->ssid.reset();
        return false;
      }
      out->ssid = std::make_unique<std::string>(*temp);
    }
  }

  return true;
}

// static
std::unique_ptr<WiFiStateProperties> WiFiStateProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<WiFiStateProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> WiFiStateProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->bssid.get()) {
    to_value_result->SetWithoutPathExpansion("BSSID", std::make_unique<base::Value>(*this->bssid));

  }
  if (this->eap.get()) {
    to_value_result->SetWithoutPathExpansion("EAP", (this->eap)->ToValue());

  }
  if (this->frequency.get()) {
    to_value_result->SetWithoutPathExpansion("Frequency", std::make_unique<base::Value>(*this->frequency));

  }
  if (this->hex_ssid.get()) {
    to_value_result->SetWithoutPathExpansion("HexSSID", std::make_unique<base::Value>(*this->hex_ssid));

  }
  to_value_result->SetWithoutPathExpansion("Security", std::make_unique<base::Value>(this->security));

  if (this->signal_strength.get()) {
    to_value_result->SetWithoutPathExpansion("SignalStrength", std::make_unique<base::Value>(*this->signal_strength));

  }
  if (this->ssid.get()) {
    to_value_result->SetWithoutPathExpansion("SSID", std::make_unique<base::Value>(*this->ssid));

  }

  return to_value_result;
}


NetworkConfigProperties::NetworkConfigProperties()
: ip_address_config_type(IP_CONFIG_TYPE_NONE),
name_servers_config_type(IP_CONFIG_TYPE_NONE),
type(NETWORK_TYPE_NONE) {}

NetworkConfigProperties::~NetworkConfigProperties() = default;
NetworkConfigProperties::NetworkConfigProperties(NetworkConfigProperties&& rhs) = default;
NetworkConfigProperties& NetworkConfigProperties::operator=(NetworkConfigProperties&& rhs) = default;
// static
bool NetworkConfigProperties::Populate(
    const base::Value& value, NetworkConfigProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->ip_address_config_type = IP_CONFIG_TYPE_NONE;
  out->name_servers_config_type = IP_CONFIG_TYPE_NONE;
  out->type = NETWORK_TYPE_NONE;
  const base::Value* cellular_value = dict->FindKey("Cellular");
  if (cellular_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!cellular_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CellularProperties>();
        if (!CellularProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->cellular = std::move(temp);
      }
    }
  }

  const base::Value* ethernet_value = dict->FindKey("Ethernet");
  if (ethernet_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ethernet_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<EthernetProperties>();
        if (!EthernetProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ethernet = std::move(temp);
      }
    }
  }

  const base::Value* guid_value = dict->FindKey("GUID");
  if (guid_value) {
    {
      auto* temp = guid_value->GetIfString();
      if (!temp) {
        out->guid.reset();
        return false;
      }
      out->guid = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* ip_address_config_type_value = dict->FindKey("IPAddressConfigType");
  if (ip_address_config_type_value) {
    {
      std::string ip_config_type_as_string;
      if (!ip_address_config_type_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->ip_address_config_type = ParseIPConfigType(ip_config_type_as_string);
      if (out->ip_address_config_type == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->ip_address_config_type = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* name_servers_config_type_value = dict->FindKey("NameServersConfigType");
  if (name_servers_config_type_value) {
    {
      std::string ip_config_type_as_string;
      if (!name_servers_config_type_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->name_servers_config_type = ParseIPConfigType(ip_config_type_as_string);
      if (out->name_servers_config_type == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->name_servers_config_type = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* priority_value = dict->FindKey("Priority");
  if (priority_value) {
    {
      auto temp = priority_value->GetIfInt();
      if (!temp.has_value()) {
        out->priority.reset();
        return false;
      }
      out->priority = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* proxy_settings_value = dict->FindKey("ProxySettings");
  if (proxy_settings_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!proxy_settings_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ProxySettings>();
        if (!ProxySettings::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->proxy_settings = std::move(temp);
      }
    }
  }

  const base::Value* static_ip_config_value = dict->FindKey("StaticIPConfig");
  if (static_ip_config_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!static_ip_config_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IPConfigProperties>();
        if (!IPConfigProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->static_ip_config = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (type_value) {
    {
      std::string network_type_as_string;
      if (!type_value->GetAsString(&network_type_as_string)) {
        return false;
      }
      out->type = ParseNetworkType(network_type_as_string);
      if (out->type == NETWORK_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->type = NETWORK_TYPE_NONE;
  }

  const base::Value* vpn_value = dict->FindKey("VPN");
  if (vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<VPNProperties>();
        if (!VPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->vpn = std::move(temp);
      }
    }
  }

  const base::Value* wi_fi_value = dict->FindKey("WiFi");
  if (wi_fi_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!wi_fi_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<WiFiProperties>();
        if (!WiFiProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->wi_fi = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<NetworkConfigProperties> NetworkConfigProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<NetworkConfigProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> NetworkConfigProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->cellular.get()) {
    to_value_result->SetWithoutPathExpansion("Cellular", (this->cellular)->ToValue());

  }
  if (this->ethernet.get()) {
    to_value_result->SetWithoutPathExpansion("Ethernet", (this->ethernet)->ToValue());

  }
  if (this->guid.get()) {
    to_value_result->SetWithoutPathExpansion("GUID", std::make_unique<base::Value>(*this->guid));

  }
  if (this->ip_address_config_type != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("IPAddressConfigType", std::make_unique<base::Value>(networking_private::ToString(this->ip_address_config_type)));

  }
  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", std::make_unique<base::Value>(*this->name));

  }
  if (this->name_servers_config_type != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("NameServersConfigType", std::make_unique<base::Value>(networking_private::ToString(this->name_servers_config_type)));

  }
  if (this->priority.get()) {
    to_value_result->SetWithoutPathExpansion("Priority", std::make_unique<base::Value>(*this->priority));

  }
  if (this->proxy_settings.get()) {
    to_value_result->SetWithoutPathExpansion("ProxySettings", (this->proxy_settings)->ToValue());

  }
  if (this->static_ip_config.get()) {
    to_value_result->SetWithoutPathExpansion("StaticIPConfig", (this->static_ip_config)->ToValue());

  }
  if (this->type != NETWORK_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(networking_private::ToString(this->type)));

  }
  if (this->vpn.get()) {
    to_value_result->SetWithoutPathExpansion("VPN", (this->vpn)->ToValue());

  }
  if (this->wi_fi.get()) {
    to_value_result->SetWithoutPathExpansion("WiFi", (this->wi_fi)->ToValue());

  }

  return to_value_result;
}


NetworkProperties::NetworkProperties()
: connection_state(CONNECTION_STATE_TYPE_NONE),
ip_address_config_type(IP_CONFIG_TYPE_NONE),
name_servers_config_type(IP_CONFIG_TYPE_NONE),
type(NETWORK_TYPE_NONE) {}

NetworkProperties::~NetworkProperties() = default;
NetworkProperties::NetworkProperties(NetworkProperties&& rhs) = default;
NetworkProperties& NetworkProperties::operator=(NetworkProperties&& rhs) = default;
// static
bool NetworkProperties::Populate(
    const base::Value& value, NetworkProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->connection_state = CONNECTION_STATE_TYPE_NONE;
  out->ip_address_config_type = IP_CONFIG_TYPE_NONE;
  out->name_servers_config_type = IP_CONFIG_TYPE_NONE;
  const base::Value* cellular_value = dict->FindKey("Cellular");
  if (cellular_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!cellular_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CellularProperties>();
        if (!CellularProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->cellular = std::move(temp);
      }
    }
  }

  const base::Value* connectable_value = dict->FindKey("Connectable");
  if (connectable_value) {
    {
      auto temp = connectable_value->GetIfBool();
      if (!temp.has_value()) {
        out->connectable.reset();
        return false;
      }
      out->connectable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* connection_state_value = dict->FindKey("ConnectionState");
  if (connection_state_value) {
    {
      std::string connection_state_type_as_string;
      if (!connection_state_value->GetAsString(&connection_state_type_as_string)) {
        return false;
      }
      out->connection_state = ParseConnectionStateType(connection_state_type_as_string);
      if (out->connection_state == CONNECTION_STATE_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->connection_state = CONNECTION_STATE_TYPE_NONE;
  }

  const base::Value* error_state_value = dict->FindKey("ErrorState");
  if (error_state_value) {
    {
      auto* temp = error_state_value->GetIfString();
      if (!temp) {
        out->error_state.reset();
        return false;
      }
      out->error_state = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* ethernet_value = dict->FindKey("Ethernet");
  if (ethernet_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ethernet_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<EthernetProperties>();
        if (!EthernetProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ethernet = std::move(temp);
      }
    }
  }

  const base::Value* guid_value = dict->FindKey("GUID");
  if (!guid_value) {
    return false;
  }
  {
    auto* temp = guid_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->guid = *temp;
  }

  const base::Value* ip_address_config_type_value = dict->FindKey("IPAddressConfigType");
  if (ip_address_config_type_value) {
    {
      std::string ip_config_type_as_string;
      if (!ip_address_config_type_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->ip_address_config_type = ParseIPConfigType(ip_config_type_as_string);
      if (out->ip_address_config_type == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->ip_address_config_type = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* ip_configs_value = dict->FindKey("IPConfigs");
  if (ip_configs_value) {
    {
      const base::ListValue* list = nullptr;
      if (!ip_configs_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->ip_configs)) {
          return false;
        }
      }
    }
  }

  const base::Value* mac_address_value = dict->FindKey("MacAddress");
  if (mac_address_value) {
    {
      auto* temp = mac_address_value->GetIfString();
      if (!temp) {
        out->mac_address.reset();
        return false;
      }
      out->mac_address = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* metered_value = dict->FindKey("Metered");
  if (metered_value) {
    {
      auto temp = metered_value->GetIfBool();
      if (!temp.has_value()) {
        out->metered.reset();
        return false;
      }
      out->metered = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* name_servers_config_type_value = dict->FindKey("NameServersConfigType");
  if (name_servers_config_type_value) {
    {
      std::string ip_config_type_as_string;
      if (!name_servers_config_type_value->GetAsString(&ip_config_type_as_string)) {
        return false;
      }
      out->name_servers_config_type = ParseIPConfigType(ip_config_type_as_string);
      if (out->name_servers_config_type == IP_CONFIG_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->name_servers_config_type = IP_CONFIG_TYPE_NONE;
  }

  const base::Value* priority_value = dict->FindKey("Priority");
  if (priority_value) {
    {
      auto temp = priority_value->GetIfInt();
      if (!temp.has_value()) {
        out->priority.reset();
        return false;
      }
      out->priority = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* proxy_settings_value = dict->FindKey("ProxySettings");
  if (proxy_settings_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!proxy_settings_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ProxySettings>();
        if (!ProxySettings::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->proxy_settings = std::move(temp);
      }
    }
  }

  const base::Value* restricted_connectivity_value = dict->FindKey("RestrictedConnectivity");
  if (restricted_connectivity_value) {
    {
      auto temp = restricted_connectivity_value->GetIfBool();
      if (!temp.has_value()) {
        out->restricted_connectivity.reset();
        return false;
      }
      out->restricted_connectivity = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* static_ip_config_value = dict->FindKey("StaticIPConfig");
  if (static_ip_config_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!static_ip_config_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IPConfigProperties>();
        if (!IPConfigProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->static_ip_config = std::move(temp);
      }
    }
  }

  const base::Value* saved_ip_config_value = dict->FindKey("SavedIPConfig");
  if (saved_ip_config_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!saved_ip_config_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IPConfigProperties>();
        if (!IPConfigProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->saved_ip_config = std::move(temp);
      }
    }
  }

  const base::Value* source_value = dict->FindKey("Source");
  if (source_value) {
    {
      auto* temp = source_value->GetIfString();
      if (!temp) {
        out->source.reset();
        return false;
      }
      out->source = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tether_value = dict->FindKey("Tether");
  if (tether_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tether_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<TetherProperties>();
        if (!TetherProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tether = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (!type_value) {
    return false;
  }
  {
    std::string network_type_as_string;
    if (!type_value->GetAsString(&network_type_as_string)) {
      return false;
    }
    out->type = ParseNetworkType(network_type_as_string);
    if (out->type == NETWORK_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* vpn_value = dict->FindKey("VPN");
  if (vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<VPNProperties>();
        if (!VPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->vpn = std::move(temp);
      }
    }
  }

  const base::Value* wi_fi_value = dict->FindKey("WiFi");
  if (wi_fi_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!wi_fi_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<WiFiProperties>();
        if (!WiFiProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->wi_fi = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<NetworkProperties> NetworkProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<NetworkProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> NetworkProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->cellular.get()) {
    to_value_result->SetWithoutPathExpansion("Cellular", (this->cellular)->ToValue());

  }
  if (this->connectable.get()) {
    to_value_result->SetWithoutPathExpansion("Connectable", std::make_unique<base::Value>(*this->connectable));

  }
  if (this->connection_state != CONNECTION_STATE_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("ConnectionState", std::make_unique<base::Value>(networking_private::ToString(this->connection_state)));

  }
  if (this->error_state.get()) {
    to_value_result->SetWithoutPathExpansion("ErrorState", std::make_unique<base::Value>(*this->error_state));

  }
  if (this->ethernet.get()) {
    to_value_result->SetWithoutPathExpansion("Ethernet", (this->ethernet)->ToValue());

  }
  to_value_result->SetWithoutPathExpansion("GUID", std::make_unique<base::Value>(this->guid));

  if (this->ip_address_config_type != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("IPAddressConfigType", std::make_unique<base::Value>(networking_private::ToString(this->ip_address_config_type)));

  }
  if (this->ip_configs.get()) {
    to_value_result->SetWithoutPathExpansion("IPConfigs", json_schema_compiler::util::CreateValueFromArray(*this->ip_configs));

  }
  if (this->mac_address.get()) {
    to_value_result->SetWithoutPathExpansion("MacAddress", std::make_unique<base::Value>(*this->mac_address));

  }
  if (this->metered.get()) {
    to_value_result->SetWithoutPathExpansion("Metered", std::make_unique<base::Value>(*this->metered));

  }
  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", std::make_unique<base::Value>(*this->name));

  }
  if (this->name_servers_config_type != IP_CONFIG_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("NameServersConfigType", std::make_unique<base::Value>(networking_private::ToString(this->name_servers_config_type)));

  }
  if (this->priority.get()) {
    to_value_result->SetWithoutPathExpansion("Priority", std::make_unique<base::Value>(*this->priority));

  }
  if (this->proxy_settings.get()) {
    to_value_result->SetWithoutPathExpansion("ProxySettings", (this->proxy_settings)->ToValue());

  }
  if (this->restricted_connectivity.get()) {
    to_value_result->SetWithoutPathExpansion("RestrictedConnectivity", std::make_unique<base::Value>(*this->restricted_connectivity));

  }
  if (this->static_ip_config.get()) {
    to_value_result->SetWithoutPathExpansion("StaticIPConfig", (this->static_ip_config)->ToValue());

  }
  if (this->saved_ip_config.get()) {
    to_value_result->SetWithoutPathExpansion("SavedIPConfig", (this->saved_ip_config)->ToValue());

  }
  if (this->source.get()) {
    to_value_result->SetWithoutPathExpansion("Source", std::make_unique<base::Value>(*this->source));

  }
  if (this->tether.get()) {
    to_value_result->SetWithoutPathExpansion("Tether", (this->tether)->ToValue());

  }
  to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(networking_private::ToString(this->type)));

  if (this->vpn.get()) {
    to_value_result->SetWithoutPathExpansion("VPN", (this->vpn)->ToValue());

  }
  if (this->wi_fi.get()) {
    to_value_result->SetWithoutPathExpansion("WiFi", (this->wi_fi)->ToValue());

  }

  return to_value_result;
}


ManagedProperties::ManagedProperties()
: connection_state(CONNECTION_STATE_TYPE_NONE),
type(NETWORK_TYPE_NONE) {}

ManagedProperties::~ManagedProperties() = default;
ManagedProperties::ManagedProperties(ManagedProperties&& rhs) = default;
ManagedProperties& ManagedProperties::operator=(ManagedProperties&& rhs) = default;
// static
bool ManagedProperties::Populate(
    const base::Value& value, ManagedProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->connection_state = CONNECTION_STATE_TYPE_NONE;
  const base::Value* cellular_value = dict->FindKey("Cellular");
  if (cellular_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!cellular_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedCellularProperties>();
        if (!ManagedCellularProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->cellular = std::move(temp);
      }
    }
  }

  const base::Value* connectable_value = dict->FindKey("Connectable");
  if (connectable_value) {
    {
      auto temp = connectable_value->GetIfBool();
      if (!temp.has_value()) {
        out->connectable.reset();
        return false;
      }
      out->connectable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* connection_state_value = dict->FindKey("ConnectionState");
  if (connection_state_value) {
    {
      std::string connection_state_type_as_string;
      if (!connection_state_value->GetAsString(&connection_state_type_as_string)) {
        return false;
      }
      out->connection_state = ParseConnectionStateType(connection_state_type_as_string);
      if (out->connection_state == CONNECTION_STATE_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->connection_state = CONNECTION_STATE_TYPE_NONE;
  }

  const base::Value* error_state_value = dict->FindKey("ErrorState");
  if (error_state_value) {
    {
      auto* temp = error_state_value->GetIfString();
      if (!temp) {
        out->error_state.reset();
        return false;
      }
      out->error_state = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* ethernet_value = dict->FindKey("Ethernet");
  if (ethernet_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ethernet_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedEthernetProperties>();
        if (!ManagedEthernetProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ethernet = std::move(temp);
      }
    }
  }

  const base::Value* guid_value = dict->FindKey("GUID");
  if (!guid_value) {
    return false;
  }
  {
    auto* temp = guid_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->guid = *temp;
  }

  const base::Value* ip_address_config_type_value = dict->FindKey("IPAddressConfigType");
  if (ip_address_config_type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ip_address_config_type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedIPConfigType>();
        if (!ManagedIPConfigType::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ip_address_config_type = std::move(temp);
      }
    }
  }

  const base::Value* ip_configs_value = dict->FindKey("IPConfigs");
  if (ip_configs_value) {
    {
      const base::ListValue* list = nullptr;
      if (!ip_configs_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->ip_configs)) {
          return false;
        }
      }
    }
  }

  const base::Value* mac_address_value = dict->FindKey("MacAddress");
  if (mac_address_value) {
    {
      auto* temp = mac_address_value->GetIfString();
      if (!temp) {
        out->mac_address.reset();
        return false;
      }
      out->mac_address = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* metered_value = dict->FindKey("Metered");
  if (metered_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!metered_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedBoolean>();
        if (!ManagedBoolean::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->metered = std::move(temp);
      }
    }
  }

  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!name_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedDOMString>();
        if (!ManagedDOMString::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->name = std::move(temp);
      }
    }
  }

  const base::Value* name_servers_config_type_value = dict->FindKey("NameServersConfigType");
  if (name_servers_config_type_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!name_servers_config_type_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedIPConfigType>();
        if (!ManagedIPConfigType::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->name_servers_config_type = std::move(temp);
      }
    }
  }

  const base::Value* priority_value = dict->FindKey("Priority");
  if (priority_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!priority_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedLong>();
        if (!ManagedLong::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->priority = std::move(temp);
      }
    }
  }

  const base::Value* proxy_settings_value = dict->FindKey("ProxySettings");
  if (proxy_settings_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!proxy_settings_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedProxySettings>();
        if (!ManagedProxySettings::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->proxy_settings = std::move(temp);
      }
    }
  }

  const base::Value* restricted_connectivity_value = dict->FindKey("RestrictedConnectivity");
  if (restricted_connectivity_value) {
    {
      auto temp = restricted_connectivity_value->GetIfBool();
      if (!temp.has_value()) {
        out->restricted_connectivity.reset();
        return false;
      }
      out->restricted_connectivity = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* static_ip_config_value = dict->FindKey("StaticIPConfig");
  if (static_ip_config_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!static_ip_config_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedIPConfigProperties>();
        if (!ManagedIPConfigProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->static_ip_config = std::move(temp);
      }
    }
  }

  const base::Value* saved_ip_config_value = dict->FindKey("SavedIPConfig");
  if (saved_ip_config_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!saved_ip_config_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<IPConfigProperties>();
        if (!IPConfigProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->saved_ip_config = std::move(temp);
      }
    }
  }

  const base::Value* source_value = dict->FindKey("Source");
  if (source_value) {
    {
      auto* temp = source_value->GetIfString();
      if (!temp) {
        out->source.reset();
        return false;
      }
      out->source = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tether_value = dict->FindKey("Tether");
  if (tether_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tether_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<TetherProperties>();
        if (!TetherProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tether = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (!type_value) {
    return false;
  }
  {
    std::string network_type_as_string;
    if (!type_value->GetAsString(&network_type_as_string)) {
      return false;
    }
    out->type = ParseNetworkType(network_type_as_string);
    if (out->type == NETWORK_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* vpn_value = dict->FindKey("VPN");
  if (vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedVPNProperties>();
        if (!ManagedVPNProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->vpn = std::move(temp);
      }
    }
  }

  const base::Value* wi_fi_value = dict->FindKey("WiFi");
  if (wi_fi_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!wi_fi_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<ManagedWiFiProperties>();
        if (!ManagedWiFiProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->wi_fi = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ManagedProperties> ManagedProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<ManagedProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ManagedProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->cellular.get()) {
    to_value_result->SetWithoutPathExpansion("Cellular", (this->cellular)->ToValue());

  }
  if (this->connectable.get()) {
    to_value_result->SetWithoutPathExpansion("Connectable", std::make_unique<base::Value>(*this->connectable));

  }
  if (this->connection_state != CONNECTION_STATE_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("ConnectionState", std::make_unique<base::Value>(networking_private::ToString(this->connection_state)));

  }
  if (this->error_state.get()) {
    to_value_result->SetWithoutPathExpansion("ErrorState", std::make_unique<base::Value>(*this->error_state));

  }
  if (this->ethernet.get()) {
    to_value_result->SetWithoutPathExpansion("Ethernet", (this->ethernet)->ToValue());

  }
  to_value_result->SetWithoutPathExpansion("GUID", std::make_unique<base::Value>(this->guid));

  if (this->ip_address_config_type.get()) {
    to_value_result->SetWithoutPathExpansion("IPAddressConfigType", (this->ip_address_config_type)->ToValue());

  }
  if (this->ip_configs.get()) {
    to_value_result->SetWithoutPathExpansion("IPConfigs", json_schema_compiler::util::CreateValueFromArray(*this->ip_configs));

  }
  if (this->mac_address.get()) {
    to_value_result->SetWithoutPathExpansion("MacAddress", std::make_unique<base::Value>(*this->mac_address));

  }
  if (this->metered.get()) {
    to_value_result->SetWithoutPathExpansion("Metered", (this->metered)->ToValue());

  }
  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", (this->name)->ToValue());

  }
  if (this->name_servers_config_type.get()) {
    to_value_result->SetWithoutPathExpansion("NameServersConfigType", (this->name_servers_config_type)->ToValue());

  }
  if (this->priority.get()) {
    to_value_result->SetWithoutPathExpansion("Priority", (this->priority)->ToValue());

  }
  if (this->proxy_settings.get()) {
    to_value_result->SetWithoutPathExpansion("ProxySettings", (this->proxy_settings)->ToValue());

  }
  if (this->restricted_connectivity.get()) {
    to_value_result->SetWithoutPathExpansion("RestrictedConnectivity", std::make_unique<base::Value>(*this->restricted_connectivity));

  }
  if (this->static_ip_config.get()) {
    to_value_result->SetWithoutPathExpansion("StaticIPConfig", (this->static_ip_config)->ToValue());

  }
  if (this->saved_ip_config.get()) {
    to_value_result->SetWithoutPathExpansion("SavedIPConfig", (this->saved_ip_config)->ToValue());

  }
  if (this->source.get()) {
    to_value_result->SetWithoutPathExpansion("Source", std::make_unique<base::Value>(*this->source));

  }
  if (this->tether.get()) {
    to_value_result->SetWithoutPathExpansion("Tether", (this->tether)->ToValue());

  }
  to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(networking_private::ToString(this->type)));

  if (this->vpn.get()) {
    to_value_result->SetWithoutPathExpansion("VPN", (this->vpn)->ToValue());

  }
  if (this->wi_fi.get()) {
    to_value_result->SetWithoutPathExpansion("WiFi", (this->wi_fi)->ToValue());

  }

  return to_value_result;
}


NetworkStateProperties::NetworkStateProperties()
: connection_state(CONNECTION_STATE_TYPE_NONE),
type(NETWORK_TYPE_NONE) {}

NetworkStateProperties::~NetworkStateProperties() = default;
NetworkStateProperties::NetworkStateProperties(NetworkStateProperties&& rhs) = default;
NetworkStateProperties& NetworkStateProperties::operator=(NetworkStateProperties&& rhs) = default;
// static
bool NetworkStateProperties::Populate(
    const base::Value& value, NetworkStateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->connection_state = CONNECTION_STATE_TYPE_NONE;
  const base::Value* cellular_value = dict->FindKey("Cellular");
  if (cellular_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!cellular_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<CellularStateProperties>();
        if (!CellularStateProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->cellular = std::move(temp);
      }
    }
  }

  const base::Value* connectable_value = dict->FindKey("Connectable");
  if (connectable_value) {
    {
      auto temp = connectable_value->GetIfBool();
      if (!temp.has_value()) {
        out->connectable.reset();
        return false;
      }
      out->connectable = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* connection_state_value = dict->FindKey("ConnectionState");
  if (connection_state_value) {
    {
      std::string connection_state_type_as_string;
      if (!connection_state_value->GetAsString(&connection_state_type_as_string)) {
        return false;
      }
      out->connection_state = ParseConnectionStateType(connection_state_type_as_string);
      if (out->connection_state == CONNECTION_STATE_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->connection_state = CONNECTION_STATE_TYPE_NONE;
  }

  const base::Value* ethernet_value = dict->FindKey("Ethernet");
  if (ethernet_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!ethernet_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<EthernetStateProperties>();
        if (!EthernetStateProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->ethernet = std::move(temp);
      }
    }
  }

  const base::Value* error_state_value = dict->FindKey("ErrorState");
  if (error_state_value) {
    {
      auto* temp = error_state_value->GetIfString();
      if (!temp) {
        out->error_state.reset();
        return false;
      }
      out->error_state = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* guid_value = dict->FindKey("GUID");
  if (!guid_value) {
    return false;
  }
  {
    auto* temp = guid_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->guid = *temp;
  }

  const base::Value* name_value = dict->FindKey("Name");
  if (name_value) {
    {
      auto* temp = name_value->GetIfString();
      if (!temp) {
        out->name.reset();
        return false;
      }
      out->name = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* priority_value = dict->FindKey("Priority");
  if (priority_value) {
    {
      auto temp = priority_value->GetIfInt();
      if (!temp.has_value()) {
        out->priority.reset();
        return false;
      }
      out->priority = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* source_value = dict->FindKey("Source");
  if (source_value) {
    {
      auto* temp = source_value->GetIfString();
      if (!temp) {
        out->source.reset();
        return false;
      }
      out->source = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* tether_value = dict->FindKey("Tether");
  if (tether_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tether_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<TetherProperties>();
        if (!TetherProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->tether = std::move(temp);
      }
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (!type_value) {
    return false;
  }
  {
    std::string network_type_as_string;
    if (!type_value->GetAsString(&network_type_as_string)) {
      return false;
    }
    out->type = ParseNetworkType(network_type_as_string);
    if (out->type == NETWORK_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* vpn_value = dict->FindKey("VPN");
  if (vpn_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!vpn_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<VPNStateProperties>();
        if (!VPNStateProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->vpn = std::move(temp);
      }
    }
  }

  const base::Value* wi_fi_value = dict->FindKey("WiFi");
  if (wi_fi_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!wi_fi_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<WiFiStateProperties>();
        if (!WiFiStateProperties::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->wi_fi = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<NetworkStateProperties> NetworkStateProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<NetworkStateProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> NetworkStateProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->cellular.get()) {
    to_value_result->SetWithoutPathExpansion("Cellular", (this->cellular)->ToValue());

  }
  if (this->connectable.get()) {
    to_value_result->SetWithoutPathExpansion("Connectable", std::make_unique<base::Value>(*this->connectable));

  }
  if (this->connection_state != CONNECTION_STATE_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("ConnectionState", std::make_unique<base::Value>(networking_private::ToString(this->connection_state)));

  }
  if (this->ethernet.get()) {
    to_value_result->SetWithoutPathExpansion("Ethernet", (this->ethernet)->ToValue());

  }
  if (this->error_state.get()) {
    to_value_result->SetWithoutPathExpansion("ErrorState", std::make_unique<base::Value>(*this->error_state));

  }
  to_value_result->SetWithoutPathExpansion("GUID", std::make_unique<base::Value>(this->guid));

  if (this->name.get()) {
    to_value_result->SetWithoutPathExpansion("Name", std::make_unique<base::Value>(*this->name));

  }
  if (this->priority.get()) {
    to_value_result->SetWithoutPathExpansion("Priority", std::make_unique<base::Value>(*this->priority));

  }
  if (this->source.get()) {
    to_value_result->SetWithoutPathExpansion("Source", std::make_unique<base::Value>(*this->source));

  }
  if (this->tether.get()) {
    to_value_result->SetWithoutPathExpansion("Tether", (this->tether)->ToValue());

  }
  to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(networking_private::ToString(this->type)));

  if (this->vpn.get()) {
    to_value_result->SetWithoutPathExpansion("VPN", (this->vpn)->ToValue());

  }
  if (this->wi_fi.get()) {
    to_value_result->SetWithoutPathExpansion("WiFi", (this->wi_fi)->ToValue());

  }

  return to_value_result;
}


DeviceStateProperties::DeviceStateProperties()
: state(DEVICE_STATE_TYPE_NONE),
type(NETWORK_TYPE_NONE) {}

DeviceStateProperties::~DeviceStateProperties() = default;
DeviceStateProperties::DeviceStateProperties(DeviceStateProperties&& rhs) = default;
DeviceStateProperties& DeviceStateProperties::operator=(DeviceStateProperties&& rhs) = default;
// static
bool DeviceStateProperties::Populate(
    const base::Value& value, DeviceStateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* scanning_value = dict->FindKey("Scanning");
  if (scanning_value) {
    {
      auto temp = scanning_value->GetIfBool();
      if (!temp.has_value()) {
        out->scanning.reset();
        return false;
      }
      out->scanning = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* sim_lock_status_value = dict->FindKey("SIMLockStatus");
  if (sim_lock_status_value) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!sim_lock_status_value->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<SIMLockStatus>();
        if (!SIMLockStatus::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->sim_lock_status = std::move(temp);
      }
    }
  }

  const base::Value* sim_present_value = dict->FindKey("SIMPresent");
  if (sim_present_value) {
    {
      auto temp = sim_present_value->GetIfBool();
      if (!temp.has_value()) {
        out->sim_present.reset();
        return false;
      }
      out->sim_present = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* state_value = dict->FindKey("State");
  if (!state_value) {
    return false;
  }
  {
    std::string device_state_type_as_string;
    if (!state_value->GetAsString(&device_state_type_as_string)) {
      return false;
    }
    out->state = ParseDeviceStateType(device_state_type_as_string);
    if (out->state == DEVICE_STATE_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* type_value = dict->FindKey("Type");
  if (!type_value) {
    return false;
  }
  {
    std::string network_type_as_string;
    if (!type_value->GetAsString(&network_type_as_string)) {
      return false;
    }
    out->type = ParseNetworkType(network_type_as_string);
    if (out->type == NETWORK_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* managed_network_available_value = dict->FindKey("ManagedNetworkAvailable");
  if (managed_network_available_value) {
    {
      auto temp = managed_network_available_value->GetIfBool();
      if (!temp.has_value()) {
        out->managed_network_available.reset();
        return false;
      }
      out->managed_network_available = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<DeviceStateProperties> DeviceStateProperties::FromValue(const base::Value& value) {
  auto out = std::make_unique<DeviceStateProperties>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DeviceStateProperties::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->scanning.get()) {
    to_value_result->SetWithoutPathExpansion("Scanning", std::make_unique<base::Value>(*this->scanning));

  }
  if (this->sim_lock_status.get()) {
    to_value_result->SetWithoutPathExpansion("SIMLockStatus", (this->sim_lock_status)->ToValue());

  }
  if (this->sim_present.get()) {
    to_value_result->SetWithoutPathExpansion("SIMPresent", std::make_unique<base::Value>(*this->sim_present));

  }
  to_value_result->SetWithoutPathExpansion("State", std::make_unique<base::Value>(networking_private::ToString(this->state)));

  to_value_result->SetWithoutPathExpansion("Type", std::make_unique<base::Value>(networking_private::ToString(this->type)));

  if (this->managed_network_available.get()) {
    to_value_result->SetWithoutPathExpansion("ManagedNetworkAvailable", std::make_unique<base::Value>(*this->managed_network_available));

  }

  return to_value_result;
}


NetworkFilter::NetworkFilter()
: network_type(NETWORK_TYPE_NONE) {}

NetworkFilter::~NetworkFilter() = default;
NetworkFilter::NetworkFilter(NetworkFilter&& rhs) = default;
NetworkFilter& NetworkFilter::operator=(NetworkFilter&& rhs) = default;
// static
bool NetworkFilter::Populate(
    const base::Value& value, NetworkFilter* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* network_type_value = dict->FindKey("networkType");
  if (!network_type_value) {
    return false;
  }
  {
    std::string network_type_as_string;
    if (!network_type_value->GetAsString(&network_type_as_string)) {
      return false;
    }
    out->network_type = ParseNetworkType(network_type_as_string);
    if (out->network_type == NETWORK_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* visible_value = dict->FindKey("visible");
  if (visible_value) {
    {
      auto temp = visible_value->GetIfBool();
      if (!temp.has_value()) {
        out->visible.reset();
        return false;
      }
      out->visible = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* configured_value = dict->FindKey("configured");
  if (configured_value) {
    {
      auto temp = configured_value->GetIfBool();
      if (!temp.has_value()) {
        out->configured.reset();
        return false;
      }
      out->configured = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* limit_value = dict->FindKey("limit");
  if (limit_value) {
    {
      auto temp = limit_value->GetIfInt();
      if (!temp.has_value()) {
        out->limit.reset();
        return false;
      }
      out->limit = std::make_unique<int>(temp.value());
    }
  }

  return true;
}

// static
std::unique_ptr<NetworkFilter> NetworkFilter::FromValue(const base::Value& value) {
  auto out = std::make_unique<NetworkFilter>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> NetworkFilter::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("networkType", std::make_unique<base::Value>(networking_private::ToString(this->network_type)));

  if (this->visible.get()) {
    to_value_result->SetWithoutPathExpansion("visible", std::make_unique<base::Value>(*this->visible));

  }
  if (this->configured.get()) {
    to_value_result->SetWithoutPathExpansion("configured", std::make_unique<base::Value>(*this->configured));

  }
  if (this->limit.get()) {
    to_value_result->SetWithoutPathExpansion("limit", std::make_unique<base::Value>(*this->limit));

  }

  return to_value_result;
}


GlobalPolicy::GlobalPolicy()
 {}

GlobalPolicy::~GlobalPolicy() = default;
GlobalPolicy::GlobalPolicy(GlobalPolicy&& rhs) = default;
GlobalPolicy& GlobalPolicy::operator=(GlobalPolicy&& rhs) = default;
// static
bool GlobalPolicy::Populate(
    const base::Value& value, GlobalPolicy* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* allow_only_policy_networks_to_autoconnect_value = dict->FindKey("AllowOnlyPolicyNetworksToAutoconnect");
  if (allow_only_policy_networks_to_autoconnect_value) {
    {
      auto temp = allow_only_policy_networks_to_autoconnect_value->GetIfBool();
      if (!temp.has_value()) {
        out->allow_only_policy_networks_to_autoconnect.reset();
        return false;
      }
      out->allow_only_policy_networks_to_autoconnect = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* allow_only_policy_networks_to_connect_value = dict->FindKey("AllowOnlyPolicyNetworksToConnect");
  if (allow_only_policy_networks_to_connect_value) {
    {
      auto temp = allow_only_policy_networks_to_connect_value->GetIfBool();
      if (!temp.has_value()) {
        out->allow_only_policy_networks_to_connect.reset();
        return false;
      }
      out->allow_only_policy_networks_to_connect = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* allow_only_policy_networks_to_connect_if_available_value = dict->FindKey("AllowOnlyPolicyNetworksToConnectIfAvailable");
  if (allow_only_policy_networks_to_connect_if_available_value) {
    {
      auto temp = allow_only_policy_networks_to_connect_if_available_value->GetIfBool();
      if (!temp.has_value()) {
        out->allow_only_policy_networks_to_connect_if_available.reset();
        return false;
      }
      out->allow_only_policy_networks_to_connect_if_available = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* blocked_hex_ssi_ds_value = dict->FindKey("BlockedHexSSIDs");
  if (blocked_hex_ssi_ds_value) {
    {
      const base::ListValue* list = nullptr;
      if (!blocked_hex_ssi_ds_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->blocked_hex_ssi_ds)) {
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<GlobalPolicy> GlobalPolicy::FromValue(const base::Value& value) {
  auto out = std::make_unique<GlobalPolicy>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> GlobalPolicy::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->allow_only_policy_networks_to_autoconnect.get()) {
    to_value_result->SetWithoutPathExpansion("AllowOnlyPolicyNetworksToAutoconnect", std::make_unique<base::Value>(*this->allow_only_policy_networks_to_autoconnect));

  }
  if (this->allow_only_policy_networks_to_connect.get()) {
    to_value_result->SetWithoutPathExpansion("AllowOnlyPolicyNetworksToConnect", std::make_unique<base::Value>(*this->allow_only_policy_networks_to_connect));

  }
  if (this->allow_only_policy_networks_to_connect_if_available.get()) {
    to_value_result->SetWithoutPathExpansion("AllowOnlyPolicyNetworksToConnectIfAvailable", std::make_unique<base::Value>(*this->allow_only_policy_networks_to_connect_if_available));

  }
  if (this->blocked_hex_ssi_ds.get()) {
    to_value_result->SetWithoutPathExpansion("BlockedHexSSIDs", json_schema_compiler::util::CreateValueFromArray(*this->blocked_hex_ssi_ds));

  }

  return to_value_result;
}


Certificate::Certificate()
: hardware_backed(false),
device_wide(false) {}

Certificate::~Certificate() = default;
Certificate::Certificate(Certificate&& rhs) = default;
Certificate& Certificate::operator=(Certificate&& rhs) = default;
// static
bool Certificate::Populate(
    const base::Value& value, Certificate* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* hash_value = dict->FindKey("hash");
  if (!hash_value) {
    return false;
  }
  {
    auto* temp = hash_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->hash = *temp;
  }

  const base::Value* issued_by_value = dict->FindKey("issuedBy");
  if (!issued_by_value) {
    return false;
  }
  {
    auto* temp = issued_by_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->issued_by = *temp;
  }

  const base::Value* issued_to_value = dict->FindKey("issuedTo");
  if (!issued_to_value) {
    return false;
  }
  {
    auto* temp = issued_to_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->issued_to = *temp;
  }

  const base::Value* pem_value = dict->FindKey("pem");
  if (pem_value) {
    {
      auto* temp = pem_value->GetIfString();
      if (!temp) {
        out->pem.reset();
        return false;
      }
      out->pem = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* pkcs11_id_value = dict->FindKey("PKCS11Id");
  if (pkcs11_id_value) {
    {
      auto* temp = pkcs11_id_value->GetIfString();
      if (!temp) {
        out->pkcs11_id.reset();
        return false;
      }
      out->pkcs11_id = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* hardware_backed_value = dict->FindKey("hardwareBacked");
  if (!hardware_backed_value) {
    return false;
  }
  {
    auto temp = hardware_backed_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->hardware_backed = temp.value();
  }

  const base::Value* device_wide_value = dict->FindKey("deviceWide");
  if (!device_wide_value) {
    return false;
  }
  {
    auto temp = device_wide_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->device_wide = temp.value();
  }

  return true;
}

// static
std::unique_ptr<Certificate> Certificate::FromValue(const base::Value& value) {
  auto out = std::make_unique<Certificate>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Certificate::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("hash", std::make_unique<base::Value>(this->hash));

  to_value_result->SetWithoutPathExpansion("issuedBy", std::make_unique<base::Value>(this->issued_by));

  to_value_result->SetWithoutPathExpansion("issuedTo", std::make_unique<base::Value>(this->issued_to));

  if (this->pem.get()) {
    to_value_result->SetWithoutPathExpansion("pem", std::make_unique<base::Value>(*this->pem));

  }
  if (this->pkcs11_id.get()) {
    to_value_result->SetWithoutPathExpansion("PKCS11Id", std::make_unique<base::Value>(*this->pkcs11_id));

  }
  to_value_result->SetWithoutPathExpansion("hardwareBacked", std::make_unique<base::Value>(this->hardware_backed));

  to_value_result->SetWithoutPathExpansion("deviceWide", std::make_unique<base::Value>(this->device_wide));


  return to_value_result;
}


CertificateLists::CertificateLists()
 {}

CertificateLists::~CertificateLists() = default;
CertificateLists::CertificateLists(CertificateLists&& rhs) = default;
CertificateLists& CertificateLists::operator=(CertificateLists&& rhs) = default;
// static
bool CertificateLists::Populate(
    const base::Value& value, CertificateLists* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* server_ca_certificates_value = dict->FindKey("serverCaCertificates");
  if (!server_ca_certificates_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!server_ca_certificates_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->server_ca_certificates)) {
        return false;
      }
    }
  }

  const base::Value* user_certificates_value = dict->FindKey("userCertificates");
  if (!user_certificates_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!user_certificates_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->user_certificates)) {
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<CertificateLists> CertificateLists::FromValue(const base::Value& value) {
  auto out = std::make_unique<CertificateLists>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CertificateLists::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("serverCaCertificates", json_schema_compiler::util::CreateValueFromArray(this->server_ca_certificates));

  to_value_result->SetWithoutPathExpansion("userCertificates", json_schema_compiler::util::CreateValueFromArray(this->user_certificates));


  return to_value_result;
}



//
// Functions
//

namespace GetProperties {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const NetworkProperties& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace GetProperties

namespace GetManagedProperties {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const ManagedProperties& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace GetManagedProperties

namespace GetState {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const NetworkStateProperties& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace GetState

namespace SetProperties {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* properties_value = nullptr;
  if (args.Get(1, &properties_value) &&
      !properties_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!properties_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!NetworkConfigProperties::Populate(*dictionary, &params->properties)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetProperties

namespace CreateNetwork {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* shared_value = nullptr;
  if (args.Get(0, &shared_value) &&
      !shared_value->is_none()) {
    {
      auto temp = shared_value->GetIfBool();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->shared = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* properties_value = nullptr;
  if (args.Get(1, &properties_value) &&
      !properties_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!properties_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!NetworkConfigProperties::Populate(*dictionary, &params->properties)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::string& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(result)));

  return create_results;
}
}  // namespace CreateNetwork

namespace ForgetNetwork {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace ForgetNetwork

namespace GetNetworks {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* filter_value = nullptr;
  if (args.Get(0, &filter_value) &&
      !filter_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!filter_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!NetworkFilter::Populate(*dictionary, &params->filter)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<NetworkStateProperties>& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(result)));

  return create_results;
}
}  // namespace GetNetworks

namespace GetVisibleNetworks {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_type_value = nullptr;
  if (args.Get(0, &network_type_value) &&
      !network_type_value->is_none()) {
    {
      std::string network_type_as_string;
      if (!network_type_value->GetAsString(&network_type_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->network_type = ParseNetworkType(network_type_as_string);
      if (params->network_type == NETWORK_TYPE_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const std::vector<NetworkStateProperties>& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(result)));

  return create_results;
}
}  // namespace GetVisibleNetworks

namespace GetEnabledNetworkTypes {

std::vector<base::Value> Results::Create(const std::vector<NetworkType>& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  {
    std::vector<std::string> result_list;
    for (const auto& it : (result)) {
    result_list.push_back(networking_private::ToString(it));
  }
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(result_list)));
  }

  return create_results;
}
}  // namespace GetEnabledNetworkTypes

namespace GetDeviceStates {

std::vector<base::Value> Results::Create(const std::vector<DeviceStateProperties>& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(result)));

  return create_results;
}
}  // namespace GetDeviceStates

namespace EnableNetworkType {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_type_value = nullptr;
  if (args.Get(0, &network_type_value) &&
      !network_type_value->is_none()) {
    {
      std::string network_type_as_string;
      if (!network_type_value->GetAsString(&network_type_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->network_type = ParseNetworkType(network_type_as_string);
      if (params->network_type == NETWORK_TYPE_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace EnableNetworkType

namespace DisableNetworkType {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_type_value = nullptr;
  if (args.Get(0, &network_type_value) &&
      !network_type_value->is_none()) {
    {
      std::string network_type_as_string;
      if (!network_type_value->GetAsString(&network_type_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->network_type = ParseNetworkType(network_type_as_string);
      if (params->network_type == NETWORK_TYPE_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace DisableNetworkType

namespace RequestNetworkScan {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());
  params->network_type = NETWORK_TYPE_NONE;

  const base::Value* network_type_value = nullptr;
  if (args.Get(0, &network_type_value) &&
      !network_type_value->is_none()) {
    {
      std::string network_type_as_string;
      if (!network_type_value->GetAsString(&network_type_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->network_type = ParseNetworkType(network_type_as_string);
      if (params->network_type == NETWORK_TYPE_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }

  return params;
}


}  // namespace RequestNetworkScan

namespace StartConnect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace StartConnect

namespace StartDisconnect {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace StartDisconnect

namespace StartActivate {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* carrier_value = nullptr;
  if (args.Get(1, &carrier_value) &&
      !carrier_value->is_none()) {
    {
      auto* temp = carrier_value->GetIfString();
      if (!temp) {
        params->carrier.reset();
        return std::unique_ptr<Params>();
      }
      params->carrier = std::make_unique<std::string>(*temp);
    }
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace StartActivate

namespace GetCaptivePortalStatus {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const CaptivePortalStatus& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(networking_private::ToString(result))));

  return create_results;
}
}  // namespace GetCaptivePortalStatus

namespace UnlockCellularSim {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 2 || args.GetSize() > 3) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* pin_value = nullptr;
  if (args.Get(1, &pin_value) &&
      !pin_value->is_none()) {
    {
      auto* temp = pin_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->pin = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* puk_value = nullptr;
  if (args.Get(2, &puk_value) &&
      !puk_value->is_none()) {
    {
      auto* temp = puk_value->GetIfString();
      if (!temp) {
        params->puk.reset();
        return std::unique_ptr<Params>();
      }
      params->puk = std::make_unique<std::string>(*temp);
    }
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace UnlockCellularSim

namespace SetCellularSimState {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* sim_state_value = nullptr;
  if (args.Get(1, &sim_state_value) &&
      !sim_state_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!sim_state_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!CellularSimState::Populate(*dictionary, &params->sim_state)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SetCellularSimState

namespace SelectCellularMobileNetwork {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* network_guid_value = nullptr;
  if (args.Get(0, &network_guid_value) &&
      !network_guid_value->is_none()) {
    {
      auto* temp = network_guid_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_guid = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* network_id_value = nullptr;
  if (args.Get(1, &network_id_value) &&
      !network_id_value->is_none()) {
    {
      auto* temp = network_id_value->GetIfString();
      if (!temp) {
        return std::unique_ptr<Params>();
      }
      params->network_id = *temp;
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create() {
  std::vector<base::Value> create_results;

  return create_results;
}
}  // namespace SelectCellularMobileNetwork

namespace GetGlobalPolicy {

std::vector<base::Value> Results::Create(const GlobalPolicy& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace GetGlobalPolicy

namespace GetCertificateLists {

std::vector<base::Value> Results::Create(const CertificateLists& result) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((result).ToValue()));

  return create_results;
}
}  // namespace GetCertificateLists

//
// Events
//

namespace OnNetworksChanged {

const char kEventName[] = "networkingPrivate.onNetworksChanged";

std::vector<base::Value> Create(const std::vector<std::string>& changes) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(changes)));

  return create_results;
}

}  // namespace OnNetworksChanged

namespace OnNetworkListChanged {

const char kEventName[] = "networkingPrivate.onNetworkListChanged";

std::vector<base::Value> Create(const std::vector<std::string>& changes) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue(json_schema_compiler::util::CreateValueFromArray(changes)));

  return create_results;
}

}  // namespace OnNetworkListChanged

namespace OnDeviceStateListChanged {

const char kEventName[] = "networkingPrivate.onDeviceStateListChanged";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnDeviceStateListChanged

namespace OnPortalDetectionCompleted {

const char kEventName[] = "networkingPrivate.onPortalDetectionCompleted";

std::vector<base::Value> Create(const std::string& network_guid, const CaptivePortalStatus& status) {
  std::vector<base::Value> create_results;
  create_results.reserve(2);
  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(network_guid)));

  create_results.push_back(base::Value::FromUniquePtrValue(std::make_unique<base::Value>(networking_private::ToString(status))));

  return create_results;
}

}  // namespace OnPortalDetectionCompleted

namespace OnCertificateListsChanged {

const char kEventName[] = "networkingPrivate.onCertificateListsChanged";

std::vector<base::Value> Create() {
  std::vector<base::Value> create_results;

  return create_results;
}

}  // namespace OnCertificateListsChanged

}  // namespace networking_private
}  // namespace api
}  // namespace extensions

