// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/printer_provider_internal.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/printer_provider_internal.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"
#include "extensions/common/api/printer_provider.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace printer_provider_internal {
//
// Types
//

const char* ToString(PrintError enum_param) {
  switch (enum_param) {
    case PRINT_ERROR_OK:
      return "OK";
    case PRINT_ERROR_FAILED:
      return "FAILED";
    case PRINT_ERROR_INVALID_TICKET:
      return "INVALID_TICKET";
    case PRINT_ERROR_INVALID_DATA:
      return "INVALID_DATA";
    case PRINT_ERROR_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

PrintError ParsePrintError(const std::string& enum_string) {
  if (enum_string == "OK")
    return PRINT_ERROR_OK;
  if (enum_string == "FAILED")
    return PRINT_ERROR_FAILED;
  if (enum_string == "INVALID_TICKET")
    return PRINT_ERROR_INVALID_TICKET;
  if (enum_string == "INVALID_DATA")
    return PRINT_ERROR_INVALID_DATA;
  return PRINT_ERROR_NONE;
}


BlobInfo::BlobInfo()
: size(0) {}

BlobInfo::~BlobInfo() = default;
BlobInfo::BlobInfo(BlobInfo&& rhs) = default;
BlobInfo& BlobInfo::operator=(BlobInfo&& rhs) = default;
// static
bool BlobInfo::Populate(
    const base::Value& value, BlobInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* blob_uuid_value = dict->FindKey("blobUuid");
  if (!blob_uuid_value) {
    return false;
  }
  {
    auto* temp = blob_uuid_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->blob_uuid = *temp;
  }

  const base::Value* type_value = dict->FindKey("type");
  if (!type_value) {
    return false;
  }
  {
    auto* temp = type_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->type = *temp;
  }

  const base::Value* size_value = dict->FindKey("size");
  if (!size_value) {
    return false;
  }
  {
    auto temp = size_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->size = temp.value();
  }

  return true;
}

// static
std::unique_ptr<BlobInfo> BlobInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<BlobInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> BlobInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("blobUuid", std::make_unique<base::Value>(this->blob_uuid));

  to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(this->type));

  to_value_result->SetWithoutPathExpansion("size", std::make_unique<base::Value>(this->size));


  return to_value_result;
}



//
// Functions
//

namespace ReportPrinters {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_id_value = nullptr;
  if (args.Get(0, &request_id_value) &&
      !request_id_value->is_none()) {
    {
      auto temp = request_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->request_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* printers_value = nullptr;
  if (args.Get(1, &printers_value) &&
      !printers_value->is_none()) {
    {
      const base::ListValue* list = nullptr;
      if (!printers_value->GetAsList(&list)) {
        return std::unique_ptr<Params>();
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &params->printers)) {
          return std::unique_ptr<Params>();
        }
      }
    }
  }

  return params;
}


}  // namespace ReportPrinters

namespace ReportUsbPrinterInfo {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_id_value = nullptr;
  if (args.Get(0, &request_id_value) &&
      !request_id_value->is_none()) {
    {
      auto temp = request_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->request_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* printer_info_value = nullptr;
  if (args.Get(1, &printer_info_value) &&
      !printer_info_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!printer_info_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<extensions::api::printer_provider::PrinterInfo>();
        if (!extensions::api::printer_provider::PrinterInfo::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->printer_info = std::move(temp);
      }
    }
  }

  return params;
}


}  // namespace ReportUsbPrinterInfo

namespace ReportPrinterCapability {

Params::Capability::Capability()
 {}

Params::Capability::~Capability() = default;
Params::Capability::Capability(Capability&& rhs) = default;
Params::Capability& Params::Capability::operator=(Capability&& rhs) = default;
// static
bool Params::Capability::Populate(
    const base::Value& value, Capability* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->additional_properties.MergeDictionary(dict);
  return true;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_id_value = nullptr;
  if (args.Get(0, &request_id_value) &&
      !request_id_value->is_none()) {
    {
      auto temp = request_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->request_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* capability_value = nullptr;
  if (args.Get(1, &capability_value) &&
      !capability_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!capability_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<Capability>();
        if (!Capability::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->capability = std::move(temp);
      }
    }
  }

  return params;
}


}  // namespace ReportPrinterCapability

namespace ReportPrintResult {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());
  params->error = PRINT_ERROR_NONE;

  const base::Value* request_id_value = nullptr;
  if (args.Get(0, &request_id_value) &&
      !request_id_value->is_none()) {
    {
      auto temp = request_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->request_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* error_value = nullptr;
  if (args.Get(1, &error_value) &&
      !error_value->is_none()) {
    {
      std::string print_error_as_string;
      if (!error_value->GetAsString(&print_error_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->error = ParsePrintError(print_error_as_string);
      if (params->error == PRINT_ERROR_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }

  return params;
}


}  // namespace ReportPrintResult

namespace GetPrintData {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_id_value = nullptr;
  if (args.Get(0, &request_id_value) &&
      !request_id_value->is_none()) {
    {
      auto temp = request_id_value->GetIfInt();
      if (!temp.has_value()) {
        return std::unique_ptr<Params>();
      }
      params->request_id = temp.value();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const BlobInfo& blob_info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((blob_info).ToValue()));

  return create_results;
}
}  // namespace GetPrintData

}  // namespace printer_provider_internal
}  // namespace api
}  // namespace extensions

