// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/system_cpu.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/system_cpu.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace system_cpu {
//
// Types
//

CpuTime::CpuTime()
: user(0.0),
kernel(0.0),
idle(0.0),
total(0.0) {}

CpuTime::~CpuTime() = default;
CpuTime::CpuTime(CpuTime&& rhs) = default;
CpuTime& CpuTime::operator=(CpuTime&& rhs) = default;
// static
bool CpuTime::Populate(
    const base::Value& value, CpuTime* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* user_value = dict->FindKey("user");
  if (!user_value) {
    return false;
  }
  {
    auto temp = user_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->user = temp.value();
  }

  const base::Value* kernel_value = dict->FindKey("kernel");
  if (!kernel_value) {
    return false;
  }
  {
    auto temp = kernel_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->kernel = temp.value();
  }

  const base::Value* idle_value = dict->FindKey("idle");
  if (!idle_value) {
    return false;
  }
  {
    auto temp = idle_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->idle = temp.value();
  }

  const base::Value* total_value = dict->FindKey("total");
  if (!total_value) {
    return false;
  }
  {
    auto temp = total_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->total = temp.value();
  }

  return true;
}

// static
std::unique_ptr<CpuTime> CpuTime::FromValue(const base::Value& value) {
  auto out = std::make_unique<CpuTime>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CpuTime::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("user", std::make_unique<base::Value>(this->user));

  to_value_result->SetWithoutPathExpansion("kernel", std::make_unique<base::Value>(this->kernel));

  to_value_result->SetWithoutPathExpansion("idle", std::make_unique<base::Value>(this->idle));

  to_value_result->SetWithoutPathExpansion("total", std::make_unique<base::Value>(this->total));


  return to_value_result;
}


ProcessorInfo::ProcessorInfo()
 {}

ProcessorInfo::~ProcessorInfo() = default;
ProcessorInfo::ProcessorInfo(ProcessorInfo&& rhs) = default;
ProcessorInfo& ProcessorInfo::operator=(ProcessorInfo&& rhs) = default;
// static
bool ProcessorInfo::Populate(
    const base::Value& value, ProcessorInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* usage_value = dict->FindKey("usage");
  if (!usage_value) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!usage_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!CpuTime::Populate(*dictionary, &out->usage)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<ProcessorInfo> ProcessorInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ProcessorInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ProcessorInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("usage", (this->usage).ToValue());


  return to_value_result;
}


CpuInfo::CpuInfo()
: num_of_processors(0) {}

CpuInfo::~CpuInfo() = default;
CpuInfo::CpuInfo(CpuInfo&& rhs) = default;
CpuInfo& CpuInfo::operator=(CpuInfo&& rhs) = default;
// static
bool CpuInfo::Populate(
    const base::Value& value, CpuInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* num_of_processors_value = dict->FindKey("numOfProcessors");
  if (!num_of_processors_value) {
    return false;
  }
  {
    auto temp = num_of_processors_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->num_of_processors = temp.value();
  }

  const base::Value* arch_name_value = dict->FindKey("archName");
  if (!arch_name_value) {
    return false;
  }
  {
    auto* temp = arch_name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->arch_name = *temp;
  }

  const base::Value* model_name_value = dict->FindKey("modelName");
  if (!model_name_value) {
    return false;
  }
  {
    auto* temp = model_name_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->model_name = *temp;
  }

  const base::Value* features_value = dict->FindKey("features");
  if (!features_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!features_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->features)) {
        return false;
      }
    }
  }

  const base::Value* processors_value = dict->FindKey("processors");
  if (!processors_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!processors_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->processors)) {
        return false;
      }
    }
  }

  const base::Value* temperatures_value = dict->FindKey("temperatures");
  if (!temperatures_value) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!temperatures_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->temperatures)) {
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<CpuInfo> CpuInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<CpuInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CpuInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("numOfProcessors", std::make_unique<base::Value>(this->num_of_processors));

  to_value_result->SetWithoutPathExpansion("archName", std::make_unique<base::Value>(this->arch_name));

  to_value_result->SetWithoutPathExpansion("modelName", std::make_unique<base::Value>(this->model_name));

  to_value_result->SetWithoutPathExpansion("features", json_schema_compiler::util::CreateValueFromArray(this->features));

  to_value_result->SetWithoutPathExpansion("processors", json_schema_compiler::util::CreateValueFromArray(this->processors));

  to_value_result->SetWithoutPathExpansion("temperatures", json_schema_compiler::util::CreateValueFromArray(this->temperatures));


  return to_value_result;
}



//
// Functions
//

namespace GetInfo {

std::vector<base::Value> Results::Create(const CpuInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace GetInfo

}  // namespace system_cpu
}  // namespace api
}  // namespace extensions

