// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/system_memory.idl
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "extensions/common/api/system_memory.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace system_memory {
//
// Types
//

MemoryInfo::MemoryInfo()
: capacity(0.0),
available_capacity(0.0) {}

MemoryInfo::~MemoryInfo() = default;
MemoryInfo::MemoryInfo(MemoryInfo&& rhs) = default;
MemoryInfo& MemoryInfo::operator=(MemoryInfo&& rhs) = default;
// static
bool MemoryInfo::Populate(
    const base::Value& value, MemoryInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* capacity_value = dict->FindKey("capacity");
  if (!capacity_value) {
    return false;
  }
  {
    auto temp = capacity_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->capacity = temp.value();
  }

  const base::Value* available_capacity_value = dict->FindKey("availableCapacity");
  if (!available_capacity_value) {
    return false;
  }
  {
    auto temp = available_capacity_value->GetIfDouble();
    if (!temp.has_value()) {
      return false;
    }
    out->available_capacity = temp.value();
  }

  return true;
}

// static
std::unique_ptr<MemoryInfo> MemoryInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<MemoryInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> MemoryInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("capacity", std::make_unique<base::Value>(this->capacity));

  to_value_result->SetWithoutPathExpansion("availableCapacity", std::make_unique<base::Value>(this->available_capacity));


  return to_value_result;
}



//
// Functions
//

namespace GetInfo {

std::vector<base::Value> Results::Create(const MemoryInfo& info) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((info).ToValue()));

  return create_results;
}
}  // namespace GetInfo

}  // namespace system_memory
}  // namespace api
}  // namespace extensions

