// extensions/common/mojom/channel.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/channel.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/channel.mojom-params-data.h"
namespace extensions {
namespace mojom {

static NOINLINE const char* ChannelToStringHelper(Channel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Channel::kUnknown:
      return "kUnknown";
    case Channel::kCanary:
      return "kCanary";
    case Channel::kDev:
      return "kDev";
    case Channel::kBeta:
      return "kBeta";
    case Channel::kStable:
      return "kStable";
    default:
      return nullptr;
  }
}

std::string ChannelToString(Channel value) {
  const char *str = ChannelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Channel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Channel value) {
  return os << ChannelToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::Channel>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::Channel value) {
  return std::move(context).WriteString(::extensions::mojom::ChannelToString(value));
}

} // namespace perfetto
