// extensions/common/mojom/permission_set.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/permission_set.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/permission_set.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {


// static
bool APIPermission_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const APIPermission_Data* object = static_cast<const APIPermission_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::extensions::mojom::internal::APIPermissionID_Data
        ::Validate(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

APIPermission_Data::APIPermission_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool APIPermissionSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const APIPermissionSet_Data* object = static_cast<const APIPermissionSet_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams permission_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::extensions::mojom::internal::APIPermissionID_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->permission_map, validation_context,
                                         &permission_map_validate_params)) {
    return false;
  }

  return true;
}

APIPermissionSet_Data::APIPermissionSet_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestPermission_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestPermission_Data* object = static_cast<const ManifestPermission_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

ManifestPermission_Data::ManifestPermission_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManifestPermissionSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ManifestPermissionSet_Data* object = static_cast<const ManifestPermissionSet_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permission_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams permission_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->permission_map, validation_context,
                                         &permission_map_validate_params)) {
    return false;
  }

  return true;
}

ManifestPermissionSet_Data::ManifestPermissionSet_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PermissionSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PermissionSet_Data* object = static_cast<const PermissionSet_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->apis, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->apis, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest_permissions, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manifest_permissions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hosts, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hosts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_script_hosts, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_script_hosts, validation_context))
    return false;

  return true;
}

PermissionSet_Data::PermissionSet_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions
