// extensions/common/mojom/run_location.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/run_location.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/run_location.mojom-params-data.h"
namespace extensions {
namespace mojom {

static NOINLINE const char* RunLocationToStringHelper(RunLocation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RunLocation::kUndefined:
      return "kUndefined";
    case RunLocation::kDocumentStart:
      return "kDocumentStart";
    case RunLocation::kDocumentEnd:
      return "kDocumentEnd";
    case RunLocation::kDocumentIdle:
      return "kDocumentIdle";
    case RunLocation::kRunDeferred:
      return "kRunDeferred";
    case RunLocation::kBrowserDriven:
      return "kBrowserDriven";
    default:
      return nullptr;
  }
}

std::string RunLocationToString(RunLocation value) {
  const char *str = RunLocationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RunLocation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RunLocation value) {
  return os << RunLocationToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::RunLocation>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::RunLocation value) {
  return std::move(context).WriteString(::extensions::mojom::RunLocationToString(value));
}

} // namespace perfetto
