// gpu/ipc/common/sync_token.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/sync_token.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/sync_token.mojom-params-data.h"
#include "gpu/ipc/common/sync_token.mojom-shared-message-ids.h"

#include "gpu/ipc/common/sync_token.mojom-import-headers.h"


#ifndef GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_JUMBO_H_
#define GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
SyncToken::SyncToken()
    : verified_flush(),
      namespace_id(),
      command_buffer_id(),
      release_count() {}

SyncToken::SyncToken(
    bool verified_flush_in,
    CommandBufferNamespace namespace_id_in,
    uint64_t command_buffer_id_in,
    uint64_t release_count_in)
    : verified_flush(std::move(verified_flush_in)),
      namespace_id(std::move(namespace_id_in)),
      command_buffer_id(std::move(command_buffer_id_in)),
      release_count(std::move(release_count_in)) {}

SyncToken::~SyncToken() = default;

void SyncToken::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "verified_flush"), this->verified_flush,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "namespace_id"), this->namespace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CommandBufferNamespace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "command_buffer_id"), this->command_buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "release_count"), this->release_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SyncToken::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::SyncToken::DataView, ::gpu::mojom::SyncTokenPtr>::Read(
    ::gpu::mojom::SyncToken::DataView input,
    ::gpu::mojom::SyncTokenPtr* output) {
  bool success = true;
  ::gpu::mojom::SyncTokenPtr result(::gpu::mojom::SyncToken::New());
  
      if (success)
        result->verified_flush = input.verified_flush();
      if (success && !input.ReadNamespaceId(&result->namespace_id))
        success = false;
      if (success)
        result->command_buffer_id = input.command_buffer_id();
      if (success)
        result->release_count = input.release_count();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif