// media/capture/mojom/video_capture_buffer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/capture/mojom/video_capture_buffer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture_buffer.mojom-params-data.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared-message-ids.h"

#include "media/capture/mojom/video_capture_buffer.mojom-import-headers.h"


#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_JUMBO_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
VideoFrameInfo::VideoFrameInfo()
    : timestamp(),
      metadata(),
      pixel_format(),
      coded_size(),
      visible_rect(),
      is_premapped(),
      color_space(),
      strides() {}

VideoFrameInfo::VideoFrameInfo(
    ::base::TimeDelta timestamp_in,
    const ::media::VideoFrameMetadata& metadata_in,
    ::media::VideoPixelFormat pixel_format_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    bool is_premapped_in,
    const absl::optional<::gfx::ColorSpace>& color_space_in,
    ::media::mojom::PlaneStridesPtr strides_in)
    : timestamp(std::move(timestamp_in)),
      metadata(std::move(metadata_in)),
      pixel_format(std::move(pixel_format_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      is_premapped(std::move(is_premapped_in)),
      color_space(std::move(color_space_in)),
      strides(std::move(strides_in)) {}

VideoFrameInfo::~VideoFrameInfo() = default;

void VideoFrameInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoFrameMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_format"), this->pixel_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_premapped"), this->is_premapped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::gfx::ColorSpace>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::PlaneStridesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadyBuffer::ReadyBuffer()
    : buffer_id(),
      info() {}

ReadyBuffer::ReadyBuffer(
    int32_t buffer_id_in,
    VideoFrameInfoPtr info_in)
    : buffer_id(std::move(buffer_id_in)),
      info(std::move(info_in)) {}

ReadyBuffer::~ReadyBuffer() = default;

void ReadyBuffer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_id"), this->buffer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoFrameInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadyBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MailboxBufferHandleSet::MailboxBufferHandleSet()
    : mailbox_holder() {}

MailboxBufferHandleSet::MailboxBufferHandleSet(
    std::vector<::gpu::MailboxHolder> mailbox_holder_in)
    : mailbox_holder(std::move(mailbox_holder_in)) {}

MailboxBufferHandleSet::~MailboxBufferHandleSet() = default;

void MailboxBufferHandleSet::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox_holder"), this->mailbox_holder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gpu::MailboxHolder>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MailboxBufferHandleSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedMemoryViaRawFileDescriptor::SharedMemoryViaRawFileDescriptor()
    : file_descriptor_handle(),
      shared_memory_size_in_bytes() {}

SharedMemoryViaRawFileDescriptor::SharedMemoryViaRawFileDescriptor(
    ::mojo::PlatformHandle file_descriptor_handle_in,
    uint32_t shared_memory_size_in_bytes_in)
    : file_descriptor_handle(std::move(file_descriptor_handle_in)),
      shared_memory_size_in_bytes(std::move(shared_memory_size_in_bytes_in)) {}

SharedMemoryViaRawFileDescriptor::~SharedMemoryViaRawFileDescriptor() = default;

void SharedMemoryViaRawFileDescriptor::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_descriptor_handle"), this->file_descriptor_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PlatformHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_memory_size_in_bytes"), this->shared_memory_size_in_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedMemoryViaRawFileDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoBufferHandle::VideoBufferHandle() : tag_(Tag::SHARED_BUFFER_HANDLE) {
  data_.shared_buffer_handle = new ::mojo::ScopedSharedBufferHandle;
}

VideoBufferHandle::~VideoBufferHandle() {
  DestroyActive();
}


void VideoBufferHandle::set_shared_buffer_handle(
    ::mojo::ScopedSharedBufferHandle shared_buffer_handle) {
  if (tag_ == Tag::SHARED_BUFFER_HANDLE) {
    *(data_.shared_buffer_handle) = std::move(shared_buffer_handle);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_BUFFER_HANDLE;
    data_.shared_buffer_handle = new ::mojo::ScopedSharedBufferHandle(
        std::move(shared_buffer_handle));
  }
}
void VideoBufferHandle::set_read_only_shmem_region(
    ::base::ReadOnlySharedMemoryRegion read_only_shmem_region) {
  if (tag_ == Tag::READ_ONLY_SHMEM_REGION) {
    *(data_.read_only_shmem_region) = std::move(read_only_shmem_region);
  } else {
    DestroyActive();
    tag_ = Tag::READ_ONLY_SHMEM_REGION;
    data_.read_only_shmem_region = new ::base::ReadOnlySharedMemoryRegion(
        std::move(read_only_shmem_region));
  }
}
void VideoBufferHandle::set_shared_memory_via_raw_file_descriptor(
    SharedMemoryViaRawFileDescriptorPtr shared_memory_via_raw_file_descriptor) {
  if (tag_ == Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR) {
    *(data_.shared_memory_via_raw_file_descriptor) = std::move(shared_memory_via_raw_file_descriptor);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR;
    data_.shared_memory_via_raw_file_descriptor = new SharedMemoryViaRawFileDescriptorPtr(
        std::move(shared_memory_via_raw_file_descriptor));
  }
}
void VideoBufferHandle::set_mailbox_handles(
    MailboxBufferHandleSetPtr mailbox_handles) {
  if (tag_ == Tag::MAILBOX_HANDLES) {
    *(data_.mailbox_handles) = std::move(mailbox_handles);
  } else {
    DestroyActive();
    tag_ = Tag::MAILBOX_HANDLES;
    data_.mailbox_handles = new MailboxBufferHandleSetPtr(
        std::move(mailbox_handles));
  }
}
void VideoBufferHandle::set_gpu_memory_buffer_handle(
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle) {
  if (tag_ == Tag::GPU_MEMORY_BUFFER_HANDLE) {
    *(data_.gpu_memory_buffer_handle) = std::move(gpu_memory_buffer_handle);
  } else {
    DestroyActive();
    tag_ = Tag::GPU_MEMORY_BUFFER_HANDLE;
    data_.gpu_memory_buffer_handle = new ::gfx::GpuMemoryBufferHandle(
        std::move(gpu_memory_buffer_handle));
  }
}

void VideoBufferHandle::DestroyActive() {
  switch (tag_) {

    case Tag::SHARED_BUFFER_HANDLE:

      delete data_.shared_buffer_handle;
      break;
    case Tag::READ_ONLY_SHMEM_REGION:

      delete data_.read_only_shmem_region;
      break;
    case Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR:

      delete data_.shared_memory_via_raw_file_descriptor;
      break;
    case Tag::MAILBOX_HANDLES:

      delete data_.mailbox_handles;
      break;
    case Tag::GPU_MEMORY_BUFFER_HANDLE:

      delete data_.gpu_memory_buffer_handle;
      break;
  }
}

bool VideoBufferHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::VideoFrameInfo::DataView, ::media::mojom::VideoFrameInfoPtr>::Read(
    ::media::mojom::VideoFrameInfo::DataView input,
    ::media::mojom::VideoFrameInfoPtr* output) {
  bool success = true;
  ::media::mojom::VideoFrameInfoPtr result(::media::mojom::VideoFrameInfo::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadPixelFormat(&result->pixel_format))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success)
        result->is_premapped = input.is_premapped();
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadStrides(&result->strides))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::ReadyBuffer::DataView, ::media::mojom::ReadyBufferPtr>::Read(
    ::media::mojom::ReadyBuffer::DataView input,
    ::media::mojom::ReadyBufferPtr* output) {
  bool success = true;
  ::media::mojom::ReadyBufferPtr result(::media::mojom::ReadyBuffer::New());
  
      if (success)
        result->buffer_id = input.buffer_id();
      if (success && !input.ReadInfo(&result->info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::MailboxBufferHandleSet::DataView, ::media::mojom::MailboxBufferHandleSetPtr>::Read(
    ::media::mojom::MailboxBufferHandleSet::DataView input,
    ::media::mojom::MailboxBufferHandleSetPtr* output) {
  bool success = true;
  ::media::mojom::MailboxBufferHandleSetPtr result(::media::mojom::MailboxBufferHandleSet::New());
  
      if (success && !input.ReadMailboxHolder(&result->mailbox_holder))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SharedMemoryViaRawFileDescriptor::DataView, ::media::mojom::SharedMemoryViaRawFileDescriptorPtr>::Read(
    ::media::mojom::SharedMemoryViaRawFileDescriptor::DataView input,
    ::media::mojom::SharedMemoryViaRawFileDescriptorPtr* output) {
  bool success = true;
  ::media::mojom::SharedMemoryViaRawFileDescriptorPtr result(::media::mojom::SharedMemoryViaRawFileDescriptor::New());
  
      if (success)
        result->file_descriptor_handle = input.TakeFileDescriptorHandle();
      if (success)
        result->shared_memory_size_in_bytes = input.shared_memory_size_in_bytes();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::VideoBufferHandle::DataView, ::media::mojom::VideoBufferHandlePtr>::Read(
    ::media::mojom::VideoBufferHandle::DataView input,
    ::media::mojom::VideoBufferHandlePtr* output) {
  using UnionType = ::media::mojom::VideoBufferHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::SHARED_BUFFER_HANDLE: {
      *output = UnionType::NewSharedBufferHandle(
          input.TakeSharedBufferHandle());
      break;
    }
    case Tag::READ_ONLY_SHMEM_REGION: {
      ::base::ReadOnlySharedMemoryRegion result_read_only_shmem_region;
      if (!input.ReadReadOnlyShmemRegion(&result_read_only_shmem_region))
        return false;

      *output = UnionType::NewReadOnlyShmemRegion(
          std::move(result_read_only_shmem_region));
      break;
    }
    case Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR: {
      ::media::mojom::SharedMemoryViaRawFileDescriptorPtr result_shared_memory_via_raw_file_descriptor;
      if (!input.ReadSharedMemoryViaRawFileDescriptor(&result_shared_memory_via_raw_file_descriptor))
        return false;

      *output = UnionType::NewSharedMemoryViaRawFileDescriptor(
          std::move(result_shared_memory_via_raw_file_descriptor));
      break;
    }
    case Tag::MAILBOX_HANDLES: {
      ::media::mojom::MailboxBufferHandleSetPtr result_mailbox_handles;
      if (!input.ReadMailboxHandles(&result_mailbox_handles))
        return false;

      *output = UnionType::NewMailboxHandles(
          std::move(result_mailbox_handles));
      break;
    }
    case Tag::GPU_MEMORY_BUFFER_HANDLE: {
      ::gfx::GpuMemoryBufferHandle result_gpu_memory_buffer_handle;
      if (!input.ReadGpuMemoryBufferHandle(&result_gpu_memory_buffer_handle))
        return false;

      *output = UnionType::NewGpuMemoryBufferHandle(
          std::move(result_gpu_memory_buffer_handle));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif